/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.operations;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.IFileContentManagerSession;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.internal.FileItemInfo;
import com.ibm.team.filesystem.client.internal.FileItemInfoProxy;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.InverseFileItemInfo;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.Sandbox;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.Shed;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileArea;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChange;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeManager;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeTracker;
import com.ibm.team.filesystem.client.internal.operations.ChangeSetChooser;
import com.ibm.team.filesystem.client.internal.operations.CheckinUploadData;
import com.ibm.team.filesystem.client.internal.operations.CheckinUploadHandler;
import com.ibm.team.filesystem.client.internal.operations.EncodingUploadFailure;
import com.ibm.team.filesystem.client.internal.operations.FileSystemOperation;
import com.ibm.team.filesystem.client.internal.operations.LineDelimiterUploadFailure;
import com.ibm.team.filesystem.client.internal.operations.LocalChangeCheckinRequest;
import com.ibm.team.filesystem.client.internal.operations.NewCheckInOperation$1;
import com.ibm.team.filesystem.client.internal.operations.NewCheckInOperation$ComponentCheckInRequest;
import com.ibm.team.filesystem.client.internal.operations.NewCheckInOperation$WorkspaceCheckInRequest;
import com.ibm.team.filesystem.client.internal.operations.ShareableCheckinRequest;
import com.ibm.team.filesystem.client.internal.operations.UpdateOperation;
import com.ibm.team.filesystem.client.internal.operations.UploadFailure;
import com.ibm.team.filesystem.client.internal.utils.CancellationMonitor;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationDescriptor;
import com.ibm.team.filesystem.client.internal.utils.FlowNodeLock;
import com.ibm.team.filesystem.client.internal.utils.IRunnableWithProgress;
import com.ibm.team.filesystem.client.internal.utils.RepositoryUtils;
import com.ibm.team.filesystem.client.internal.utils.WorkspaceLockUtil;
import com.ibm.team.filesystem.client.operations.CommitDilemmaHandler;
import com.ibm.team.filesystem.client.operations.DilemmaHandler;
import com.ibm.team.filesystem.client.operations.ICheckinOperation;
import com.ibm.team.filesystem.client.operations.IVerifyInSyncOperation;
import com.ibm.team.filesystem.common.IFileContent;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.common.ISymbolicLink;
import com.ibm.team.filesystem.common.ISymbolicLinkHandle;
import com.ibm.team.filesystem.common.internal.FileContent;
import com.ibm.team.filesystem.common.internal.FileItem;
import com.ibm.team.filesystem.common.internal.FilesystemFactory;
import com.ibm.team.filesystem.common.internal.SymbolicLink;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.repository.rcp.common.collection.CollectionUtil;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.ContentHash;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.IComponentStateSummary;
import com.ibm.team.scm.common.dto.IItemUpdateReport;
import com.ibm.team.scm.common.dto.ISyncTime;
import com.ibm.team.scm.common.dto.IUpdateReport;
import com.ibm.team.scm.common.internal.Folder;
import com.ibm.team.scm.common.internal.ScmFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;

public class NewCheckInOperation
extends FileSystemOperation
implements ICheckinOperation {
    private static final String MULTI_SANDBOX_WARNING = "Component ''{0}'' loaded in multiple sandboxes. Not setting metadata.";
    private final Collection componentRequests = new LinkedList();
    protected final Map changeSetsCommitted = new HashMap();
    protected final CommitDilemmaHandler commitProblemHandler;
    private boolean refreshBeforeRun = false;
    private Map savedVersionable = new HashMap();
    private Shed backupShed;
    private boolean nonAtomicCommitIsAnOption = true;
    private int uploadLimit = 200;

    public Collection getCommittedChangeSets() {
        return this.changeSetsCommitted.values();
    }

    public NewCheckInOperation(CommitDilemmaHandler commitDilemmaHandler) {
        super(commitDilemmaHandler == null ? CommitDilemmaHandler.getDefault() : commitDilemmaHandler);
        this.commitProblemHandler = commitDilemmaHandler == null ? CommitDilemmaHandler.getDefault() : commitDilemmaHandler;
        this.backupShed = new Shed(this.commitProblemHandler.getBackupDilemmaHandler());
    }

    public void requestCheckin(IShareable[] iShareableArray, IChangeSetHandle iChangeSetHandle, String string, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        IShareable[] iShareableArray2;
        ConfigurationDescriptor configurationDescriptor;
        IShare iShare;
        if (iShareableArray == null) {
            throw (Throwable)new IllegalArgumentException("Call requestCheckin() with just the workspace/component");
        }
        HashMap hashMap = new HashMap();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (String)Messages.NewCheckInOperation_GETTING_READY_TO_UPLOAD, (int)(iShareableArray.length * 6));
        subMonitor.subTask(Messages.NewCheckInOperation_ORDERING_CHANGES_TO_LOCAL_FILES_AND_FOLDERS);
        IShareable[] object3 = iShareableArray;
        int n = iShareableArray.length;
        int n2 = 0;
        while (n2 < n) {
            IShareable iShareable = object3[n2];
            HashMap hashMap2 = (HashMap)hashMap.get(iShareable.getSandbox());
            if (hashMap2 == null) {
                hashMap2 = new HashMap();
                hashMap.put(iShareable.getSandbox(), hashMap2);
            }
            if ((iShare = iShareable.getShare((IProgressMonitor)subMonitor.newChild(1))) == null) {
                throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.NewCheckInOperation_MISSING_SHARE, null)));
            }
            configurationDescriptor = null;
            configurationDescriptor = new ConfigurationDescriptor(iShare.getSharingDescriptor());
            iShareableArray2 = (IShareable[])hashMap2.get(configurationDescriptor);
            if (iShareableArray2 == null) {
                iShareableArray2 = new LinkedList();
                hashMap2.put(configurationDescriptor, iShareableArray2);
            }
            iShareableArray2.add(iShareable);
            ++n2;
        }
        if (iChangeSetHandle != null) {
            subMonitor.setWorkRemaining(hashMap.size() * 2);
            subMonitor.subTask(Messages.NewCheckInOperation_ENSURE_CHANGESET_SANE);
            for (Map.Entry entry : hashMap.entrySet()) {
                this.validateChangeset(((HashMap)entry.getValue()).keySet(), iChangeSetHandle, subMonitor.newChild(1));
            }
        }
        subMonitor.subTask(Messages.NewCheckInOperation_ORDERING_CHANGES_TO_FILES);
        subMonitor.setWorkRemaining(hashMap.size());
        for (Map.Entry entry : hashMap.entrySet()) {
            SubMonitor subMonitor2 = SubMonitor.convert((IProgressMonitor)((IProgressMonitor)subMonitor.newChild(1)), (int)(((HashMap)entry.getValue()).size() * 2));
            for (Map.Entry entry2 : ((HashMap)entry.getValue()).entrySet()) {
                try {
                    configurationDescriptor = ((ConfigurationDescriptor)entry2.getKey()).getConnection((IProgressMonitor)subMonitor2.newChild(1));
                    if (!(configurationDescriptor instanceof IWorkspaceConnection)) {
                        throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, "Attempt to commit into a non-workspace connection", null)));
                    }
                    iShare = (IWorkspaceConnection)configurationDescriptor;
                }
                catch (TeamRepositoryException teamRepositoryException) {
                    throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.NewCheckInOperation_COULD_NOT_GET_CONNECTION, (Throwable)teamRepositoryException)));
                }
                configurationDescriptor = ((ConfigurationDescriptor)entry2.getKey()).componentHandle;
                this.validateShareableRequest((ISandbox)entry.getKey(), (IConnection)iShare, (IComponentHandle)configurationDescriptor, (List)entry2.getValue(), (IProgressMonitor)subMonitor2.newChild(1));
                iShareableArray2 = ((List)entry2.getValue()).toArray(new IShareable[((List)entry2.getValue()).size()]);
                this.componentRequests.add(new ShareableCheckinRequest((IWorkspaceConnection)iShare, (IComponentHandle)configurationDescriptor, (ISandbox)entry.getKey(), iShareableArray2, iChangeSetHandle, string));
            }
        }
    }

    private void validateChangeset(Set set, IChangeSetHandle iChangeSetHandle, SubMonitor subMonitor) throws FileSystemClientException {
        subMonitor = SubMonitor.convert((IProgressMonitor)((IProgressMonitor)subMonitor), (int)set.size());
        for (ConfigurationDescriptor configurationDescriptor : set) {
            IChangeSet iChangeSet;
            try {
                iChangeSet = (IChangeSet)configurationDescriptor.getTeamRepository().itemManager().fetchCompleteItem((IItemHandle)iChangeSetHandle, 0, (IProgressMonitor)subMonitor.newChild(1));
            }
            catch (TeamRepositoryException teamRepositoryException) {
                throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.NewCheckInOperation_FAILURE_GETTING_COMPLETE_ITEM_STATE, (Throwable)teamRepositoryException)));
            }
            if (configurationDescriptor.componentHandle.sameItemId((IItemHandle)iChangeSet.getComponent())) continue;
            throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.NewCheckInOperation_INCONSISTENT_COMPONENT, null)));
        }
    }

    public void requestCheckin(IWorkspaceConnection iWorkspaceConnection, IComponentHandle iComponentHandle, ILocalChange[] iLocalChangeArray, IChangeSetHandle iChangeSetHandle, String string, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        IShareable iShareable;
        IWorkspaceConnection iWorkspaceConnection2;
        if (iLocalChangeArray == null) {
            throw (Throwable)new IllegalArgumentException("Call requestCheckin() with just the workspace/component");
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)(iLocalChangeArray.length * 2));
        HashMap<IPath, IWorkspaceConnection> hashMap = new HashMap<IPath, IWorkspaceConnection>();
        ILocalChange[] object3 = iLocalChangeArray;
        int n = iLocalChangeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ILocalChange iLocalChange = object3[n2];
            IPath iPath = ((LocalChange)iLocalChange).getCfaRoot();
            iWorkspaceConnection2 = (IWorkspaceConnection)hashMap.get(iPath);
            if (iWorkspaceConnection2 == null) {
                iWorkspaceConnection2 = new HashMap();
                hashMap.put(iPath, iWorkspaceConnection2);
            }
            if ((iShareable = iLocalChange.getShareable()) == null) {
                throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.NewCheckInOperation_MISSING_FILE_OR_FOLDER_FOR_CHANGE, null)));
            }
            IShare iShare = iShareable.getShare((IProgressMonitor)subMonitor.newChild(1));
            if (iShare == null) {
                throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.NewCheckInOperation_NOT_SHARED, null)));
            }
            ConfigurationDescriptor configurationDescriptor = new ConfigurationDescriptor(iShare.getSharingDescriptor());
            LinkedList<ILocalChange> linkedList = (LinkedList<ILocalChange>)iWorkspaceConnection2.get(configurationDescriptor);
            if (linkedList == null) {
                linkedList = new LinkedList<ILocalChange>();
                iWorkspaceConnection2.put(configurationDescriptor, linkedList);
            }
            linkedList.add(iLocalChange);
            ++n2;
        }
        if (iChangeSetHandle != null) {
            subMonitor.setWorkRemaining(hashMap.size() * 2);
            subMonitor.subTask(Messages.NewCheckInOperation_ENSURE_CHANGESET_SANE);
            for (Map.Entry entry : hashMap.entrySet()) {
                this.validateChangeset(((HashMap)entry.getValue()).keySet(), iChangeSetHandle, subMonitor.newChild(1));
            }
        }
        subMonitor.setWorkRemaining(hashMap.size());
        for (Map.Entry entry : hashMap.entrySet()) {
            SubMonitor subMonitor2 = SubMonitor.convert((IProgressMonitor)((IProgressMonitor)subMonitor.newChild(1)), (int)(((HashMap)entry.getValue()).size() * 2));
            for (Map.Entry entry2 : ((HashMap)entry.getValue()).entrySet()) {
                try {
                    iShareable = ((ConfigurationDescriptor)entry2.getKey()).getConnection((IProgressMonitor)subMonitor2.newChild(1));
                    if (!(iShareable instanceof IWorkspaceConnection)) {
                        throw (Throwable)new IllegalArgumentException("Attempt to commit into a non-workspace connection");
                    }
                    iWorkspaceConnection2 = (IWorkspaceConnection)iShareable;
                }
                catch (TeamRepositoryException teamRepositoryException) {
                    throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.NewCheckInOperation_COULD_NOT_GET_CONNECTION, (Throwable)teamRepositoryException)));
                }
                iShareable = ((ConfigurationDescriptor)entry2.getKey()).componentHandle;
                this.componentRequests.add(new LocalChangeCheckinRequest(iWorkspaceConnection2, (IComponentHandle)iShareable, new Sandbox((IPath)entry.getKey()), ((List)entry2.getValue()).toArray(new ILocalChange[((List)entry2.getValue()).size()]), iChangeSetHandle, string));
            }
        }
    }

    static ISchedulingRule generateRuleFor(IWorkspaceConnection iWorkspaceConnection, IComponentHandle iComponentHandle, ILocalChange[] iLocalChangeArray, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        Object object;
        HashSet<IShare> hashSet = new HashSet<IShare>();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)iLocalChangeArray.length);
        ILocalChange[] iLocalChangeArray2 = iLocalChangeArray;
        int n = iLocalChangeArray.length;
        int n2 = 0;
        while (n2 < n) {
            object = iLocalChangeArray2[n2];
            IShare iShare = object.getShareable().getShare((IProgressMonitor)subMonitor.newChild(1));
            ISharingDescriptor iSharingDescriptor = iShare.getSharingDescriptor();
            if (iSharingDescriptor.getConnectionHandle().sameItemId((IItemHandle)iWorkspaceConnection.getContextHandle()) && iSharingDescriptor.getComponent().sameItemId((IItemHandle)iComponentHandle)) {
                hashSet.add(iShare);
            }
            ++n2;
        }
        object = new ArrayList(hashSet.size());
        for (IShare iShare : hashSet) {
            object.add(iShare.getShareable());
        }
        return SharingManager.getInstance().makeSchedulingRuleForIDE((Collection)object);
    }

    private void validateShareableRequest(ISandbox iSandbox, IConnection iConnection, IComponentHandle iComponentHandle, List list, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)list.size());
        for (IShareable iShareable : list) {
            if (!iShareable.getSandbox().equals(iSandbox)) {
                throw (Throwable)new IllegalArgumentException("Shareable " + iShareable.getFullPath().toString() + " does not have the same root path as Sandbox (" + iSandbox.getRoot() + ")");
            }
            IShare iShare = iShareable.getShare((IProgressMonitor)subMonitor.newChild(1));
            if (iShare == null) {
                throw (Throwable)new IllegalArgumentException("Shareable " + iShareable + " has no share");
            }
            if (iShare.getSharingDescriptor().getComponent().sameItemId((IItemHandle)iComponentHandle)) continue;
            throw (Throwable)new IllegalArgumentException("Shareable " + iShareable + " is not in component " + iComponentHandle);
        }
    }

    private List groupRequestsByConnection() {
        Object object2;
        HashMap hashMap = new HashMap();
        for (Object object2 : this.componentRequests) {
            IWorkspaceConnection iWorkspaceConnection = ((NewCheckInOperation$ComponentCheckInRequest)object2).getWorkspace();
            UUID uUID = iWorkspaceConnection.getContextHandle().getItemId();
            CollectionUtil.addToMapOfLists((Map)hashMap, (Object)uUID, (Object)object2);
        }
        object2 = new ArrayList(hashMap.size());
        for (Object object3 : hashMap.values()) {
            object2.add(new NewCheckInOperation$WorkspaceCheckInRequest((List)object3));
        }
        return (List)object2;
    }

    protected void execute(IProgressMonitor iProgressMonitor) throws FileSystemClientException, TeamRepositoryException {
        Object object2;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (String)Messages.NewCheckInOperation_0, (int)100);
        subMonitor.setTaskName(Messages.NewCheckInOperation_1);
        HashSet<ConfigurationDescriptor> hashSet = new HashSet<ConfigurationDescriptor>();
        for (Object object2 : this.componentRequests) {
            ConfigurationDescriptor configurationDescriptor = new ConfigurationDescriptor((IConnection)((NewCheckInOperation$ComponentCheckInRequest)object2).getWorkspace(), ((NewCheckInOperation$ComponentCheckInRequest)object2).getComponent());
            hashSet.add(configurationDescriptor);
        }
        object2 = new NewCheckInOperation$1(this, hashSet);
        FlowNodeLock flowNodeLock = WorkspaceLockUtil.acquireWrite(hashSet, (IProgressMonitor)subMonitor.newChild(1));
        try {
            this.runWithinFileSystemLock((IRunnableWithProgress)object2, Messages.NewCheckInOperation_21, (IProgressMonitor)subMonitor.newChild(99));
        }
        finally {
            WorkspaceLockUtil.release(flowNodeLock);
        }
        subMonitor.done();
    }

    protected void runRequest(NewCheckInOperation$WorkspaceCheckInRequest newCheckInOperation$WorkspaceCheckInRequest, Collection collection, SubMonitor subMonitor) throws FileSystemClientException, TeamRepositoryException {
        String string = NLS.bind((String)Messages.NewCheckInOperation_2, (Object)newCheckInOperation$WorkspaceCheckInRequest.getWorkspace().getResolvedWorkspace().getName(), (Object[])new Object[0]);
        subMonitor = SubMonitor.convert((IProgressMonitor)((IProgressMonitor)subMonitor), (String)string, (int)(100 + newCheckInOperation$WorkspaceCheckInRequest.reqs.size()));
        this.determineChangesAndVerifyInSync(newCheckInOperation$WorkspaceCheckInRequest, (IProgressMonitor)subMonitor.newChild(1));
        int n = 0;
        for (NewCheckInOperation$ComponentCheckInRequest newCheckInOperation$ComponentCheckInRequest : newCheckInOperation$WorkspaceCheckInRequest.reqs) {
            SubMonitor subMonitor2 = subMonitor.newChild(1);
            subMonitor2.subTask(NLS.bind((String)Messages.NewCheckInOperation_FINDING_LOCAL_CHANGES, (Object)n++, (Object[])new Object[]{newCheckInOperation$WorkspaceCheckInRequest.reqs.size()}));
            subMonitor2.setWorkRemaining(100);
            IWorkspaceConnection iWorkspaceConnection = newCheckInOperation$ComponentCheckInRequest.getWorkspace();
            IComponentHandle iComponentHandle = newCheckInOperation$ComponentCheckInRequest.getComponent();
            ChangeSetChooser changeSetChooser = new ChangeSetChooser(iWorkspaceConnection, collection);
            HashMap<UUID, IChangeSetHandle> hashMap = new HashMap<UUID, IChangeSetHandle>();
            HashMap<UUID, HashSet<ILocalChange>> hashMap2 = new HashMap<UUID, HashSet<ILocalChange>>();
            subMonitor2.setWorkRemaining(NewCheckInOperation$ComponentCheckInRequest.access$0(newCheckInOperation$ComponentCheckInRequest).size() + 8);
            for (ILocalChange iLocalChange : NewCheckInOperation$ComponentCheckInRequest.access$0(newCheckInOperation$ComponentCheckInRequest)) {
                UUID uUID;
                IChangeSetHandle iChangeSetHandle = changeSetChooser.getBestChangeSet(iComponentHandle, iLocalChange.getTarget(), newCheckInOperation$ComponentCheckInRequest.getPreferredChangeSet(), (IProgressMonitor)subMonitor2.newChild(1));
                if (iChangeSetHandle != null) {
                    uUID = iChangeSetHandle.getItemId();
                    hashMap.put(uUID, iChangeSetHandle);
                } else {
                    uUID = null;
                }
                HashSet<ILocalChange> hashSet = (HashSet<ILocalChange>)hashMap2.get(uUID);
                if (hashSet == null) {
                    hashSet = new HashSet<ILocalChange>();
                    hashMap2.put(uUID, hashSet);
                }
                hashSet.add(iLocalChange);
            }
            subMonitor2.worked(8);
            this.checkCancelled((IProgressMonitor)subMonitor2);
            newCheckInOperation$ComponentCheckInRequest.setChangesToCommit(hashMap2);
            newCheckInOperation$ComponentCheckInRequest.setChangeSetsToCommit(hashMap);
        }
        this.commitChanges(newCheckInOperation$WorkspaceCheckInRequest, string, (IProgressMonitor)subMonitor.newChild(99));
    }

    private void determineChangesAndVerifyInSync(NewCheckInOperation$WorkspaceCheckInRequest newCheckInOperation$WorkspaceCheckInRequest, IProgressMonitor iProgressMonitor) throws FileSystemClientException, TeamRepositoryException {
        Object object;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)(newCheckInOperation$WorkspaceCheckInRequest.reqs.size() * 2 + 10));
        int n = 1;
        DilemmaHandler dilemmaHandler = this.getDilemmaHandler();
        if (!(dilemmaHandler instanceof CommitDilemmaHandler)) {
            dilemmaHandler = CommitDilemmaHandler.getDefault();
        }
        IVerifyInSyncOperation iVerifyInSyncOperation = IOperationFactory.instance.getVerifyInSyncOperation(((CommitDilemmaHandler)dilemmaHandler).getOutOfSyncDilemmaHandler());
        for (NewCheckInOperation$ComponentCheckInRequest newCheckInOperation$ComponentCheckInRequest : newCheckInOperation$WorkspaceCheckInRequest.reqs) {
            Object object2;
            object = subMonitor.newChild(1);
            object.subTask(NLS.bind((String)Messages.NewCheckInOperation_FINDING_LOCAL_CHANGES, (Object)n++, (Object[])new Object[]{newCheckInOperation$WorkspaceCheckInRequest.reqs.size()}));
            object.setWorkRemaining(100);
            ILocalChange[] iLocalChangeArray = newCheckInOperation$ComponentCheckInRequest.getChanges(this.getRefreshBeforeRun(), (IProgressMonitor)object.newChild(10));
            NewCheckInOperation$ComponentCheckInRequest.access$1(newCheckInOperation$ComponentCheckInRequest, new HashSet());
            Object object3 = iLocalChangeArray;
            int n2 = iLocalChangeArray.length;
            int n3 = 0;
            while (n3 < n2) {
                object2 = object3[n3];
                NewCheckInOperation$ComponentCheckInRequest.access$0(newCheckInOperation$ComponentCheckInRequest).add(object2);
                ++n3;
            }
            object2 = ICopyFileAreaManager.instance.getExistingCopyFileArea(newCheckInOperation$ComponentCheckInRequest.getSandbox().getRoot());
            if (object2 == null) {
                this.collectStatus(FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.NewCheckInOperation_19, (Object)newCheckInOperation$ComponentCheckInRequest.getSandbox().getRoot().toString(), (Object[])new Object[0]), null));
            }
            IWorkspaceConnection iWorkspaceConnection = newCheckInOperation$ComponentCheckInRequest.getWorkspace();
            HashSet<IShare> hashSet = new HashSet<IShare>();
            object3 = SharingManager.getInstance();
            SubMonitor subMonitor2 = object.newChild(10);
            subMonitor2.setWorkRemaining(iLocalChangeArray.length);
            int n4 = 0;
            while (n4 < iLocalChangeArray.length) {
                IShare iShare = ((SharingManager)object3).getShare(object2.getRoot(), iLocalChangeArray[n4].isType(16) ? iLocalChangeArray[n4].getResultingPath() : iLocalChangeArray[n4].getPath(), (IProgressMonitor)subMonitor2.newChild(1));
                hashSet.add(iShare);
                ++n4;
            }
            subMonitor2.done();
            if (!this.verifyInSyncEnabled() || ((CommitDilemmaHandler)dilemmaHandler).getOutOfSyncDilemmaHandler().willIgnoreAllSharesOutOfSync() || hashSet.isEmpty()) continue;
            iVerifyInSyncOperation.addToVerify((IConnection)iWorkspaceConnection, hashSet);
        }
        if (this.verifyInSyncEnabled() && !((CommitDilemmaHandler)dilemmaHandler).getOutOfSyncDilemmaHandler().willIgnoreAllSharesOutOfSync()) {
            iVerifyInSyncOperation.run((IProgressMonitor)subMonitor.newChild(10));
        }
        n = 0;
        for (NewCheckInOperation$ComponentCheckInRequest newCheckInOperation$ComponentCheckInRequest : newCheckInOperation$WorkspaceCheckInRequest.reqs) {
            subMonitor.subTask(NLS.bind((String)Messages.NewCheckInOperation_FINDING_LOCAL_CHANGES, (Object)n++, (Object[])new Object[]{newCheckInOperation$WorkspaceCheckInRequest.reqs.size()}));
            object = ICopyFileAreaManager.instance.getExistingCopyFileArea(newCheckInOperation$ComponentCheckInRequest.getSandbox().getRoot());
            NewCheckInOperation$ComponentCheckInRequest.access$1(newCheckInOperation$ComponentCheckInRequest, this.addRequiredChanges((ICopyFileArea)object, newCheckInOperation$ComponentCheckInRequest, NewCheckInOperation$ComponentCheckInRequest.access$0(newCheckInOperation$ComponentCheckInRequest), newCheckInOperation$ComponentCheckInRequest.getTracker(), (IProgressMonitor)subMonitor.newChild(1)));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void commitChanges(NewCheckInOperation$WorkspaceCheckInRequest newCheckInOperation$WorkspaceCheckInRequest, String string, IProgressMonitor iProgressMonitor) throws FileSystemClientException, TeamRepositoryException {
        Object object5;
        Object object22;
        Object object32;
        Object object42;
        ArrayList<IStatus> arrayList;
        SubMonitor subMonitor;
        int n;
        int n2;
        CheckinUploadData checkinUploadData;
        boolean bl;
        IWorkspaceConnection iWorkspaceConnection;
        CancellationMonitor cancellationMonitor;
        SubMonitor subMonitor2;
        block33: {
            block34: {
                subMonitor2 = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
                cancellationMonitor = new CancellationMonitor((IProgressMonitor)subMonitor2);
                iWorkspaceConnection = newCheckInOperation$WorkspaceCheckInRequest.getWorkspace();
                bl = this.nonAtomicCommitIsAnOption;
                checkinUploadData = new CheckinUploadData();
                n2 = 0;
                n = 0;
                int n3 = 0;
                subMonitor = subMonitor2.newChild(1).setWorkRemaining(newCheckInOperation$WorkspaceCheckInRequest.reqs.size());
                arrayList = new ArrayList<IStatus>();
                for (NewCheckInOperation$ComponentCheckInRequest newCheckInOperation$ComponentCheckInRequest : newCheckInOperation$WorkspaceCheckInRequest.reqs) {
                    boolean bl2 = FileSystemCore.getFileSystemManager(newCheckInOperation$ComponentCheckInRequest.getWorkspace().teamRepository()).serverSupportsSymbolicLinks((IProgressMonitor)subMonitor.newChild(1));
                    n += NewCheckInOperation$ComponentCheckInRequest.access$0(newCheckInOperation$ComponentCheckInRequest).size();
                    for (Object object42 : NewCheckInOperation$ComponentCheckInRequest.access$0(newCheckInOperation$ComponentCheckInRequest)) {
                        if (object42.getTarget() instanceof IFileItemHandle && (object42.getType() & 3) != 0) {
                            ++n2;
                        } else if (!bl2 && object42.getTarget() instanceof ISymbolicLinkHandle) {
                            object32 = FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.NewCheckInOperation_20, (Object)object42.getPath().toString(), (Object[])new Object[0]), null);
                            arrayList.add((IStatus)object32);
                        }
                        if (object42.isCanceled() || (object42.getType() & 0x10) != 0) continue;
                        ++n3;
                    }
                }
                if (!this.nonAtomicCommitIsAnOption || n2 < this.uploadLimit || !bl) break block34;
                int n4 = this.commitProblemHandler.nonAtomicCommit(iWorkspaceConnection, n3, n2);
                if (n4 == 0) {
                    bl = true;
                    break block33;
                } else if (n4 == 3) {
                    bl = false;
                    break block33;
                } else {
                    if (n4 == 1) {
                        throw (Throwable)new OperationCanceledException();
                    }
                    throw (Throwable)((Object)new FileSystemClientException(new FileSystemStatus(NLS.bind((String)Messages.NewCheckInOperation_23, (Object)new Integer(n), (Object[])new Object[]{iWorkspaceConnection.getName()}))));
                }
            }
            bl = false;
        }
        if (!bl && !arrayList.isEmpty()) {
            RepositoryUtils.throwAppropriateException(Messages.NewCheckInOperation_22, arrayList.toArray(new IStatus[arrayList.size()]));
        }
        if (n2 != 0) {
            IFileContentManagerSession iFileContentManagerSession = FileSystemCore.getContentManager(iWorkspaceConnection.teamRepository()).createSession(NLS.bind((String)Messages.NewCheckInOperation_3, (Object)iWorkspaceConnection.getName(), (Object[])new Object[0]), true, n2, (IProgressMonitor)subMonitor2.newChild(40));
            for (Object object22 : newCheckInOperation$WorkspaceCheckInRequest.reqs) {
                object42 = ((NewCheckInOperation$ComponentCheckInRequest)object22).getCfa();
                try {
                    for (Object object5 : NewCheckInOperation$ComponentCheckInRequest.access$0((NewCheckInOperation$ComponentCheckInRequest)object22)) {
                        if (!(object5.getTarget() instanceof IFileItemHandle) || (object5.getType() & 3) == 0) continue;
                        CheckinUploadHandler checkinUploadHandler = new CheckinUploadHandler((ICopyFileArea)object42, (NewCheckInOperation$ComponentCheckInRequest)object22, (ILocalChange)object5, !bl, checkinUploadData, cancellationMonitor);
                        iFileContentManagerSession.storeContent(checkinUploadHandler);
                    }
                }
                catch (TeamRepositoryException teamRepositoryException) {}
            }
            iFileContentManagerSession.join();
            this.doDilemmaHandling(iWorkspaceConnection, bl, iFileContentManagerSession, arrayList, checkinUploadData, subMonitor2.newChild(20));
            object22 = checkinUploadData.clearFilesNeedingConversion();
            SubMonitor subMonitor3 = subMonitor2.newChild(4);
            subMonitor3.setWorkRemaining(object22.size());
            object5 = object22.iterator();
            while (object5.hasNext()) {
                object42 = (CheckinUploadHandler)((Object)object5.next());
                try {
                    ((CheckinUploadHandler)((Object)object42)).convert(this.backupShed, (IProgressMonitor)subMonitor3.newChild(1));
                }
                catch (FileSystemClientException fileSystemClientException) {
                    if (!bl) {
                        throw (Throwable)((Object)fileSystemClientException);
                    }
                    arrayList.add(FileSystemStatus.getStatusFor((Throwable)((Object)fileSystemClientException)));
                }
            }
        }
        HashMap<UUID, LinkedHashMap<UUID, ILocalChange>> hashMap = new HashMap<UUID, LinkedHashMap<UUID, ILocalChange>>();
        object22 = new ArrayList(n);
        ArrayList<ILocalChange> arrayList2 = new ArrayList<ILocalChange>(newCheckInOperation$WorkspaceCheckInRequest.reqs.size());
        object42 = new ArrayList(arrayList2.size());
        object5 = subMonitor2.newChild(5);
        object5.setWorkRemaining(n * 2 + newCheckInOperation$WorkspaceCheckInRequest.reqs.size());
        for (Object object32 : newCheckInOperation$WorkspaceCheckInRequest.reqs) {
            boolean bl3 = FileSystemCore.getFileSystemManager(((NewCheckInOperation$ComponentCheckInRequest)object32).getWorkspace().teamRepository()).serverSupportsSymbolicLinks((IProgressMonitor)subMonitor.newChild(1));
            for (Map.Entry entry : NewCheckInOperation$ComponentCheckInRequest.access$2((NewCheckInOperation$ComponentCheckInRequest)object32).entrySet()) {
                Object object6;
                ILocalChange iLocalChange2;
                Collection collection = (Collection)entry.getValue();
                ArrayList arrayList3 = new ArrayList(collection.size());
                SubMonitor subMonitor4 = object5.newChild(1).setWorkRemaining(collection.size());
                for (ILocalChange iLocalChange2 : collection) {
                    if (!this.addConfigOp(((NewCheckInOperation$ComponentCheckInRequest)object32).getCfa(), checkinUploadData, (NewCheckInOperation$ComponentCheckInRequest)object32, iLocalChange2, iWorkspaceConnection.configurationOpFactory(), arrayList3, bl3, (IProgressMonitor)subMonitor4.newChild(1))) continue;
                    object22.add(iLocalChange2);
                }
                if (arrayList3.isEmpty()) continue;
                for (ILocalChange iLocalChange2 : collection) {
                    if (iLocalChange2.isCanceled() || (iLocalChange2.getType() & 0x10) != 0) continue;
                    object6 = (Map)hashMap.get(((NewCheckInOperation$ComponentCheckInRequest)object32).getComponent().getItemId());
                    if (object6 == null) {
                        object6 = new LinkedHashMap<UUID, ILocalChange>(n * 4 / 3);
                        hashMap.put(((NewCheckInOperation$ComponentCheckInRequest)object32).getComponent().getItemId(), (LinkedHashMap<UUID, ILocalChange>)object6);
                    }
                    object6.put(iLocalChange2.getTarget().getItemId(), iLocalChange2);
                }
                if (entry.getKey() == null) {
                    IComponentHandle iComponentHandle = ((NewCheckInOperation$ComponentCheckInRequest)object32).getComponent();
                    iLocalChange2 = iWorkspaceConnection.getCurrentChangeSet(iComponentHandle);
                    if (iLocalChange2 == null) {
                        object6 = ((NewCheckInOperation$ComponentCheckInRequest)object32).getCommentForNewChangeSet();
                        if (object6 == null) {
                            object6 = "";
                        }
                        iLocalChange2 = iWorkspaceConnection.createChangeSet(iComponentHandle, (String)object6, true, (IProgressMonitor)object5.newChild(1));
                    }
                } else {
                    iLocalChange2 = (IChangeSetHandle)NewCheckInOperation$ComponentCheckInRequest.access$3((NewCheckInOperation$ComponentCheckInRequest)object32).get(entry.getKey());
                }
                arrayList2.add(iLocalChange2);
                ((ArrayList)object42).add(arrayList3);
            }
        }
        object5.done();
        subMonitor2.setTaskName(string);
        this.checkCancelled((IProgressMonitor)subMonitor2);
        subMonitor2.setWorkRemaining(70);
        if (!arrayList2.isEmpty()) {
            object32 = iWorkspaceConnection.commit((List)arrayList2, (List)object42, (IProgressMonitor)subMonitor2.newChild(50));
            for (IChangeSetHandle iChangeSetHandle : arrayList2) {
                this.changeSetsCommitted.put(iChangeSetHandle.getItemId(), iChangeSetHandle);
            }
            this.updateMetadata(newCheckInOperation$WorkspaceCheckInRequest, checkinUploadData, (IUpdateReport)object32, hashMap, (IProgressMonitor)subMonitor2.newChild(5));
            this.savedVersionable = new HashMap();
            checkinUploadData.clearUploadInfo();
            LocalChangeManager localChangeManager = (LocalChangeManager)FileSystemCore.getSharingManager().getLocalChangeManager();
            localChangeManager.commitChanges(object22.toArray(new ILocalChange[object22.size()]));
            if (!object32.incidentalResolutionUpdates().isEmpty()) {
                UpdateOperation updateOperation = new UpdateOperation(iWorkspaceConnection, Collections.singletonList(object32), 2, this.commitProblemHandler, null);
                this.disableVerifyInSync(updateOperation);
                updateOperation.run((IProgressMonitor)subMonitor2.newChild(5));
            }
            this.updateCFAConfigState(newCheckInOperation$WorkspaceCheckInRequest, (IUpdateReport)object32, subMonitor2.newChild(10));
        }
        if (bl) {
            object32 = checkinUploadData.getUploadFailureStatuses();
            IStatus[] iStatusArray = arrayList.toArray(new IStatus[arrayList.size() + ((Object)object32).length]);
            System.arraycopy(object32, 0, iStatusArray, arrayList.size(), ((Object)object32).length);
            RepositoryUtils.throwAppropriateException(Messages.NewCheckInOperation_6, iStatusArray);
        }
        subMonitor2.done();
    }

    private void doDilemmaHandling(IWorkspaceConnection iWorkspaceConnection, boolean bl, IFileContentManagerSession iFileContentManagerSession, List list, CheckinUploadData checkinUploadData, SubMonitor subMonitor) throws FileSystemClientException, TeamRepositoryException {
        boolean bl2;
        int n = 0;
        do {
            Object object2;
            bl2 = false;
            IStatus[] iStatusArray = checkinUploadData.getUploadFailureStatuses();
            IStatus[] iStatusArray2 = iFileContentManagerSession.getErrorStatus();
            IStatus[] iStatusArray3 = new IStatus[list.size() + iStatusArray.length + iStatusArray2.length];
            iStatusArray3 = list.toArray(iStatusArray3);
            System.arraycopy(iStatusArray, 0, iStatusArray3, list.size(), iStatusArray.length);
            System.arraycopy(iStatusArray2, 0, iStatusArray3, list.size() + iStatusArray.length, iStatusArray2.length);
            if (bl) {
                this.checkCancellationStatus(iStatusArray3);
            } else if (iStatusArray3.length > 0) {
                RepositoryUtils.throwAppropriateException(Messages.NewCheckInOperation_4, iStatusArray3);
            }
            iFileContentManagerSession = null;
            Collection collection = checkinUploadData.clearLineDelimiterFailures();
            Collection collection2 = checkinUploadData.clearEncodingFailures();
            if (!collection.isEmpty() || !collection2.isEmpty()) {
                subMonitor.setWorkRemaining(100);
                iFileContentManagerSession = FileSystemCore.getContentManager(iWorkspaceConnection.teamRepository()).createSession(NLS.bind((String)Messages.NewCheckInOperation_3, (Object)iWorkspaceConnection.getName(), (Object[])new Object[0]), true, collection.size() + collection2.size(), (IProgressMonitor)subMonitor.newChild(40));
                try {
                    int n2;
                    if (!collection.isEmpty()) {
                        n2 = this.commitProblemHandler.lineDelimiterErrors(collection, (IProgressMonitor)subMonitor.newChild(1));
                        if (n2 == 1) {
                            throw (Throwable)new OperationCanceledException();
                        }
                        if (n2 == 3 && bl) {
                            for (Object object2 : collection) {
                                checkinUploadData.uploadFailure((UploadFailure)object2);
                            }
                            iFileContentManagerSession.decrementTransferCount(collection.size());
                        } else if (n2 == 0) {
                            subMonitor.setWorkRemaining(100);
                            for (Object object2 : collection) {
                                if (((UploadFailure)object2).isSkipFailure()) {
                                    checkinUploadData.uploadFailure((UploadFailure)object2);
                                    iFileContentManagerSession.decrementTransferCount(1L);
                                    continue;
                                }
                                try {
                                    iFileContentManagerSession.storeContent(((UploadFailure)object2).getUploadHandler());
                                    bl2 = true;
                                }
                                catch (TeamRepositoryException teamRepositoryException) {}
                            }
                        } else {
                            for (Object object2 : collection) {
                                checkinUploadData.uploadFailure((UploadFailure)object2);
                            }
                            for (Object object2 : collection2) {
                                checkinUploadData.uploadFailure((UploadFailure)object2);
                            }
                            iStatusArray = checkinUploadData.getUploadFailureStatuses();
                            RepositoryUtils.throwAppropriateException(Messages.NewCheckInOperation_4, iStatusArray);
                        }
                    }
                    if (!collection2.isEmpty()) {
                        n2 = this.commitProblemHandler.encodingErrors(collection2, (IProgressMonitor)subMonitor.newChild(1));
                        if (n2 == 1) {
                            throw (Throwable)new OperationCanceledException();
                        }
                        if (n2 == 3 && bl) {
                            for (Object object2 : collection2) {
                                checkinUploadData.uploadFailure((UploadFailure)object2);
                            }
                            iFileContentManagerSession.decrementTransferCount(collection2.size());
                        } else if (n2 == 0) {
                            subMonitor.setWorkRemaining(100);
                            if (!bl) {
                                for (Object object2 : collection2) {
                                    if (((EncodingUploadFailure)object2).isIgnoreEncoding() || !((EncodingUploadFailure)object2).getEncoding().equals(((EncodingUploadFailure)object2).getAlternativeEncoding())) continue;
                                    checkinUploadData.uploadFailure((UploadFailure)object2);
                                }
                                iStatusArray = checkinUploadData.getUploadFailureStatuses();
                                RepositoryUtils.throwAppropriateException(Messages.NewCheckInOperation_4, iStatusArray);
                            }
                            for (Object object2 : collection2) {
                                if (((UploadFailure)object2).isSkipFailure()) {
                                    checkinUploadData.uploadFailure((UploadFailure)object2);
                                    iFileContentManagerSession.decrementTransferCount(1L);
                                    continue;
                                }
                                try {
                                    iFileContentManagerSession.storeContent(((UploadFailure)object2).getUploadHandler());
                                    bl2 = true;
                                }
                                catch (TeamRepositoryException teamRepositoryException) {}
                            }
                        } else {
                            for (Object object2 : collection2) {
                                checkinUploadData.uploadFailure((UploadFailure)object2);
                            }
                            iStatusArray = checkinUploadData.getUploadFailureStatuses();
                            RepositoryUtils.throwAppropriateException(Messages.NewCheckInOperation_4, iStatusArray);
                        }
                    }
                }
                finally {
                    if (iFileContentManagerSession != null && bl2) {
                        iFileContentManagerSession.join();
                    }
                }
            }
            if (++n < 500) continue;
            for (LineDelimiterUploadFailure lineDelimiterUploadFailure : collection) {
                checkinUploadData.uploadFailure(lineDelimiterUploadFailure);
            }
            object2 = collection2.iterator();
            while (object2.hasNext()) {
                EncodingUploadFailure encodingUploadFailure = (EncodingUploadFailure)object2.next();
                checkinUploadData.uploadFailure(encodingUploadFailure);
            }
            iStatusArray = checkinUploadData.getUploadFailureStatuses();
            RepositoryUtils.throwAppropriateException(Messages.NewCheckInOperation_4, iStatusArray);
        } while (bl2 && n < 500);
    }

    private void checkCancellationStatus(IStatus[] iStatusArray) {
        IStatus[] iStatusArray2 = iStatusArray;
        int n = iStatusArray.length;
        int n2 = 0;
        while (n2 < n) {
            IStatus iStatus = iStatusArray2[n2];
            if (iStatus.matches(8)) {
                throw (Throwable)new OperationCanceledException();
            }
            ++n2;
        }
    }

    private boolean addConfigOp(ICopyFileArea iCopyFileArea, CheckinUploadData checkinUploadData, NewCheckInOperation$ComponentCheckInRequest newCheckInOperation$ComponentCheckInRequest, ILocalChange iLocalChange, IWorkspaceConnection.IConfigurationOpFactory iConfigurationOpFactory, Collection collection, boolean bl, IProgressMonitor iProgressMonitor) throws FileSystemClientException, TeamRepositoryException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)10);
        IComponentHandle iComponentHandle = newCheckInOperation$ComponentCheckInRequest.getComponent();
        IWorkspaceConnection iWorkspaceConnection = newCheckInOperation$ComponentCheckInRequest.getWorkspace();
        boolean bl2 = true;
        if (iLocalChange.isType(4)) {
            if (iLocalChange.getTarget() instanceof IFolderHandle) {
                collection.add(iConfigurationOpFactory.deleteSubtree((IFolderHandle)iLocalChange.getTarget()));
            } else {
                collection.add(iConfigurationOpFactory.delete(iLocalChange.getTarget()));
            }
        } else if (checkinUploadData.isUploadFailed(iLocalChange.getComponent(), iLocalChange.getTarget())) {
            bl2 = false;
        } else if (!iLocalChange.isType(16)) {
            UUID uUID = iLocalChange.getComponent().getItemId();
            HashMap<UUID, Object> hashMap = (HashMap<UUID, Object>)this.savedVersionable.get(uUID);
            if (hashMap == null) {
                hashMap = new HashMap<UUID, Object>();
                this.savedVersionable.put(uUID, hashMap);
            }
            if (iLocalChange.getTarget() instanceof IFolderHandle) {
                Folder folder = ScmFactory.eINSTANCE.createFolder();
                folder.initNew();
                folder.setItemId(iLocalChange.getTarget().getItemId());
                folder.setParent(iLocalChange.getTargetParent());
                folder.setName(iLocalChange.getResultingPath().lastSegment());
                collection.add(iConfigurationOpFactory.save((IVersionable)folder));
                hashMap.put(folder.getItemId(), folder);
            } else if (iLocalChange.getTarget() instanceof IFileItemHandle) {
                InverseFileItemInfo inverseFileItemInfo = iCopyFileArea.getItemInfo(iLocalChange.getTarget(), iComponentHandle, (IContextHandle)iWorkspaceConnection.getResolvedWorkspace());
                FileItem fileItem = FilesystemFactory.eINSTANCE.createFileItem();
                fileItem.initNew();
                fileItem.setItemId(iLocalChange.getTarget().getItemId());
                fileItem.setParent(inverseFileItemInfo.getLocalParent());
                fileItem.setName(inverseFileItemInfo.getLocalName());
                IShareable iShareable = checkinUploadData.getShareable(iComponentHandle, iLocalChange.getTarget());
                if (iShareable == null) {
                    iShareable = iLocalChange.getShareable();
                }
                IFileStorage iFileStorage = ((Shareable)iShareable).getFileStorage();
                boolean bl3 = iFileStorage.isExecutable((IProgressMonitor)subMonitor.newChild(1));
                fileItem.setExecutable(bl3);
                fileItem.setFileTimestamp(new Date(iFileStorage.getLocalTimeStamp()));
                FileContent fileContent = checkinUploadData.getContent(iComponentHandle, iLocalChange.getTarget());
                if (fileContent != null) {
                    fileItem.setContent((IFileContent)fileContent);
                    String string = checkinUploadData.getContentType(iComponentHandle, iLocalChange.getTarget());
                    fileItem.setContentType(string);
                } else if (inverseFileItemInfo.getHash() != null) {
                    fileContent = FilesystemFactory.eINSTANCE.createFileContent();
                    ContentHash contentHash = inverseFileItemInfo.getStoredPredecessorHintHash();
                    fileContent.setPredecessorHint(contentHash);
                    fileContent.setLineDelimiter(inverseFileItemInfo.getOriginalLineDelimiter());
                    fileContent.setSize(inverseFileItemInfo.getStoredSize());
                    fileContent.setCharacterEncoding(inverseFileItemInfo.getStoredEncoding());
                    fileContent.setHash(inverseFileItemInfo.getStoredHash());
                    fileContent.setLineDelimiterCount(inverseFileItemInfo.getStoredNumLineDelimiters());
                    fileContent.setOriginalContainingState(inverseFileItemInfo.getVersionableHandle());
                    fileItem.setContent((IFileContent)fileContent);
                    fileItem.setContentType(inverseFileItemInfo.getContentType());
                } else {
                    throw (Throwable)new IllegalStateException();
                }
                collection.add(iConfigurationOpFactory.save((IVersionable)fileItem));
                hashMap.put(fileItem.getItemId(), fileItem);
            } else if (iLocalChange.getTarget() instanceof ISymbolicLinkHandle) {
                if (bl) {
                    InverseFileItemInfo inverseFileItemInfo = iCopyFileArea.getItemInfo(iLocalChange.getTarget(), iComponentHandle, (IContextHandle)iWorkspaceConnection.getResolvedWorkspace());
                    SymbolicLink symbolicLink = FilesystemFactory.eINSTANCE.createSymbolicLink();
                    symbolicLink.initNew();
                    symbolicLink.setItemId(iLocalChange.getTarget().getItemId());
                    symbolicLink.setParent(inverseFileItemInfo.getLocalParent());
                    symbolicLink.setName(inverseFileItemInfo.getLocalName());
                    IShareable iShareable = iLocalChange.getShareable();
                    IFileStorage iFileStorage = ((Shareable)iShareable).getFileStorage();
                    symbolicLink.setLinkTimestamp(new Date(iFileStorage.getLocalTimeStamp()));
                    symbolicLink.setTarget(iFileStorage.getTarget((IProgressMonitor)subMonitor.newChild(1)));
                    collection.add(iConfigurationOpFactory.save((IVersionable)symbolicLink));
                    hashMap.put(symbolicLink.getItemId(), symbolicLink);
                } else {
                    bl2 = false;
                }
            }
        }
        return bl2;
    }

    private Set addRequiredChanges(ICopyFileArea iCopyFileArea, NewCheckInOperation$ComponentCheckInRequest newCheckInOperation$ComponentCheckInRequest, Set set, LocalChangeTracker localChangeTracker, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        ArrayList arrayList = new ArrayList(set);
        HashSet<ILocalChange> hashSet = new HashSet<ILocalChange>(set.size() * 4 / 3);
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)arrayList.size());
        while (!arrayList.isEmpty()) {
            ILocalChange iLocalChange = (ILocalChange)arrayList.remove(arrayList.size() - 1);
            if (iLocalChange.isCanceled()) {
                subMonitor.worked(1);
                continue;
            }
            hashSet.add(iLocalChange);
            if (iLocalChange.getCounterpart() != null) {
                hashSet.add(iLocalChange.getCounterpart());
                if (iLocalChange.isType(16)) {
                    iLocalChange = iLocalChange.getCounterpart();
                }
                this.addDependentChangesForNewParent(iCopyFileArea, newCheckInOperation$ComponentCheckInRequest, iLocalChange, arrayList, hashSet, localChangeTracker);
            } else if (iLocalChange.isType(2)) {
                this.addDependentChangesForNewParent(iCopyFileArea, newCheckInOperation$ComponentCheckInRequest, iLocalChange, arrayList, hashSet, localChangeTracker);
            } else if (iLocalChange.isType(4)) {
                this.addDependentChangesForDeletion(iCopyFileArea, newCheckInOperation$ComponentCheckInRequest, iLocalChange, arrayList, hashSet, localChangeTracker);
            }
            subMonitor.setWorkRemaining(arrayList.size() + 1);
            subMonitor.worked(1);
        }
        subMonitor.done();
        return hashSet;
    }

    private void addDependentChangesForDeletion(ICopyFileArea iCopyFileArea, NewCheckInOperation$ComponentCheckInRequest newCheckInOperation$ComponentCheckInRequest, ILocalChange iLocalChange, List list, Set set, LocalChangeTracker localChangeTracker) throws FileSystemClientException {
        if (!(iLocalChange.getTarget() instanceof IFolderHandle)) {
            return;
        }
        IComponentHandle iComponentHandle = newCheckInOperation$ComponentCheckInRequest.getComponent();
        IWorkspaceConnection iWorkspaceConnection = newCheckInOperation$ComponentCheckInRequest.getWorkspace();
        InverseFileItemInfo inverseFileItemInfo = iCopyFileArea.getItemInfo(iLocalChange.getTarget(), iComponentHandle, iWorkspaceConnection.getContextHandle());
        ArrayList arrayList = new ArrayList(inverseFileItemInfo.getRemoteChildren().values());
        while (!arrayList.isEmpty()) {
            IVersionableHandle iVersionableHandle = (IVersionableHandle)arrayList.remove(arrayList.size() - 1);
            ILocalChange iLocalChange2 = localChangeTracker.getPendingChange(iVersionableHandle);
            if (iLocalChange2.getType() != 0) {
                Assert.isTrue((boolean)iLocalChange2.isType(8));
                if (!set.add(iLocalChange2)) continue;
                list.add(iLocalChange2);
                continue;
            }
            if (!(iVersionableHandle instanceof IFolderHandle)) continue;
            inverseFileItemInfo = iCopyFileArea.getItemInfo(iVersionableHandle, iComponentHandle, iWorkspaceConnection.getContextHandle());
            arrayList.addAll(inverseFileItemInfo.getRemoteChildren().values());
        }
    }

    private void addDependentChangesForNewParent(ICopyFileArea iCopyFileArea, NewCheckInOperation$ComponentCheckInRequest newCheckInOperation$ComponentCheckInRequest, ILocalChange iLocalChange, List list, Set set, LocalChangeTracker localChangeTracker) throws FileSystemClientException {
        IFolderHandle iFolderHandle;
        ILocalChange iLocalChange2 = this.getDependentChangeForNewParent(iCopyFileArea, newCheckInOperation$ComponentCheckInRequest, iLocalChange, localChangeTracker);
        if (iLocalChange2 != null && set.add(iLocalChange2)) {
            list.add(iLocalChange2);
        }
        if ((iLocalChange2 = localChangeTracker.getPendingChange((IVersionableHandle)(iFolderHandle = iLocalChange.getTargetParent()))).isType(2) && set.add(iLocalChange2)) {
            list.add(iLocalChange2);
        }
    }

    private ILocalChange getDependentChangeForNewParent(ICopyFileArea iCopyFileArea, NewCheckInOperation$ComponentCheckInRequest newCheckInOperation$ComponentCheckInRequest, ILocalChange iLocalChange, LocalChangeTracker localChangeTracker) throws FileSystemClientException {
        IVersionableHandle iVersionableHandle;
        IFolderHandle iFolderHandle = iLocalChange.getTargetParent();
        if (localChangeTracker.getPendingChange((IVersionableHandle)iFolderHandle).isType(2)) {
            return null;
        }
        IComponentHandle iComponentHandle = newCheckInOperation$ComponentCheckInRequest.getComponent();
        IWorkspaceConnection iWorkspaceConnection = newCheckInOperation$ComponentCheckInRequest.getWorkspace();
        String string = iLocalChange.getResultingPath().lastSegment();
        InverseFileItemInfo inverseFileItemInfo = iCopyFileArea.getItemInfo((IVersionableHandle)iFolderHandle, iComponentHandle, iWorkspaceConnection.getContextHandle());
        if (inverseFileItemInfo == null) {
            return null;
        }
        if (iCopyFileArea.isCaseSensitive()) {
            iVersionableHandle = (IVersionableHandle)inverseFileItemInfo.getRemoteChildren().get(string);
        } else {
            iVersionableHandle = null;
            string = string.toUpperCase().toLowerCase();
            for (Map.Entry object2 : inverseFileItemInfo.getRemoteChildren().entrySet()) {
                String string2 = ((String)object2.getKey()).toUpperCase().toLowerCase();
                if (!string.equals(string2)) continue;
                iVersionableHandle = (IVersionableHandle)object2.getValue();
                break;
            }
        }
        if (iVersionableHandle == null || iVersionableHandle.sameItemId((IItemHandle)iFolderHandle)) {
            return null;
        }
        ILocalChange iLocalChange2 = localChangeTracker.getPendingChange(iVersionableHandle);
        Assert.isTrue(((iLocalChange2.getType() & 0xC) != 0 ? 1 : 0) != 0);
        return iLocalChange2;
    }

    private void updateMetadata(NewCheckInOperation$WorkspaceCheckInRequest newCheckInOperation$WorkspaceCheckInRequest, CheckinUploadData checkinUploadData, IUpdateReport iUpdateReport, Map map, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        ICopyFileArea iCopyFileArea;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        IWorkspaceConnection iWorkspaceConnection = newCheckInOperation$WorkspaceCheckInRequest.getWorkspace();
        subMonitor.setWorkRemaining(iUpdateReport.updates().size() * 2);
        int n = 0;
        int n2 = iUpdateReport.updates().size();
        for (IItemUpdateReport iItemUpdateReport : iUpdateReport.updates()) {
            Object object3 = iItemUpdateReport.getComponent();
            SubMonitor subMonitor2 = subMonitor.newChild(1);
            iCopyFileArea = this.getUniqueCfaContaining(newCheckInOperation$WorkspaceCheckInRequest, (IComponentHandle)object3, iItemUpdateReport.item(), subMonitor.newChild(1));
            if (iCopyFileArea == null) continue;
            subMonitor2.subTask(NLS.bind((String)Messages.NewCheckInOperation_8, (Object)(++n), (Object[])new Object[]{n2}));
            try {
                Object object2;
                FileItemInfoProxy fileItemInfoProxy;
                InverseFileItemInfo inverseFileItemInfo;
                if (iItemUpdateReport.getNewCurrentState() == null) continue;
                ILocalChange iLocalChange = (ILocalChange)((Map)map.get(object3.getItemId())).remove(iItemUpdateReport.item().getItemId());
                IVersionable iVersionable = (IVersionable)((Map)this.savedVersionable.get(iItemUpdateReport.getComponent().getItemId())).get(iItemUpdateReport.item().getItemId());
                if (iItemUpdateReport.item() instanceof IFolderHandle) {
                    if (iLocalChange == null || (iLocalChange.getType() & 0xA) == 0) {
                        inverseFileItemInfo = iCopyFileArea.getItemInfo(iItemUpdateReport.item(), iItemUpdateReport.getComponent(), (IContextHandle)iWorkspaceConnection.getResolvedWorkspace());
                        if (iLocalChange != null && !((FileItemInfo)inverseFileItemInfo).getName().equals(iLocalChange.getPath().lastSegment()) && !((FileItemInfo)inverseFileItemInfo).isLoadedWithAnotherName()) {
                            throw (Throwable)new IllegalStateException("Name should have been " + ((FileItemInfo)inverseFileItemInfo).getName() + " but the path is " + iLocalChange.getPath());
                        }
                        fileItemInfoProxy = new FileItemInfoProxy(inverseFileItemInfo);
                        fileItemInfoProxy.setItemState(iItemUpdateReport.getNewCurrentState());
                    } else {
                        fileItemInfoProxy = new FileItemInfoProxy(iItemUpdateReport.getNewCurrentState(), iLocalChange.getTargetParent(), iLocalChange.getResultingPath().lastSegment(), false);
                    }
                } else if (iItemUpdateReport.item() instanceof IFileItemHandle) {
                    inverseFileItemInfo = iCopyFileArea.getItemInfo(iItemUpdateReport.item(), iItemUpdateReport.getComponent(), (IContextHandle)iWorkspaceConnection.getResolvedWorkspace());
                    if (inverseFileItemInfo != null) {
                        fileItemInfoProxy = new FileItemInfoProxy(inverseFileItemInfo);
                        fileItemInfoProxy.setItemState(iItemUpdateReport.getNewCurrentState());
                        if ((iLocalChange.getType() & 0xA) == 0) {
                            if (!((FileItemInfo)inverseFileItemInfo).getName().equals(iLocalChange.getPath().lastSegment()) && !((FileItemInfo)inverseFileItemInfo).isLoadedWithAnotherName()) {
                                throw (Throwable)new IllegalStateException("Name should have been " + ((FileItemInfo)inverseFileItemInfo).getName() + " but the path is " + iLocalChange.getPath());
                            }
                        } else {
                            fileItemInfoProxy.changeIdentity(iLocalChange.getTargetParent(), iLocalChange.getResultingPath().lastSegment());
                        }
                    } else {
                        fileItemInfoProxy = new FileItemInfoProxy(iItemUpdateReport.getNewCurrentState(), iLocalChange.getTargetParent(), iLocalChange.getResultingPath().lastSegment());
                    }
                    if ((object2 = checkinUploadData.getContentSize((IComponentHandle)object3, (IVersionableHandle)iVersionable)) != null) {
                        ContentHash contentHash = checkinUploadData.getHashCode((IComponentHandle)object3, (IVersionableHandle)iVersionable);
                        long l = (Long)object2;
                        Long l2 = checkinUploadData.getModTime((IComponentHandle)object3, (IVersionableHandle)iVersionable);
                        FileContent fileContent = checkinUploadData.getContent((IComponentHandle)object3, (IVersionableHandle)iVersionable);
                        fileItemInfoProxy.setContentInfo(l2, contentHash, l, fileContent);
                    }
                } else {
                    inverseFileItemInfo = iCopyFileArea.getItemInfo(iItemUpdateReport.item(), iItemUpdateReport.getComponent(), (IContextHandle)iWorkspaceConnection.getResolvedWorkspace());
                    object2 = (ISymbolicLink)iVersionable;
                    if (inverseFileItemInfo != null) {
                        fileItemInfoProxy = new FileItemInfoProxy(inverseFileItemInfo);
                        fileItemInfoProxy.setItemState(iItemUpdateReport.getNewCurrentState());
                        if ((iLocalChange.getType() & 0xA) == 0) {
                            if (!((FileItemInfo)inverseFileItemInfo).getName().equals(iLocalChange.getPath().lastSegment()) && !((FileItemInfo)inverseFileItemInfo).isLoadedWithAnotherName()) {
                                throw (Throwable)new IllegalStateException("Name should have been " + ((FileItemInfo)inverseFileItemInfo).getName() + " but the path is " + iLocalChange.getPath());
                            }
                        } else {
                            fileItemInfoProxy.changeIdentity(iLocalChange.getTargetParent(), iLocalChange.getResultingPath().lastSegment());
                        }
                    } else {
                        fileItemInfoProxy = new FileItemInfoProxy(iItemUpdateReport.getNewCurrentState(), iLocalChange.getTargetParent(), iLocalChange.getResultingPath().lastSegment());
                    }
                    fileItemInfoProxy.setTarget(((Shareable)iLocalChange.getShareable()).getFileStorage().getModificationStamp(), object2.getTarget());
                }
                fileItemInfoProxy.setProperties(iVersionable);
                if (!$assertionsDisabled && iLocalChange.getResultingPath() == null) {
                    throw (Throwable)((Object)new AssertionError());
                }
                iCopyFileArea.setItemMetaData(iLocalChange.getResultingPath(), fileItemInfoProxy.getFileItemInfo(), (IProgressMonitor)subMonitor2.newChild(1));
            }
            catch (FileSystemClientException fileSystemClientException) {
                this.collectStatus(FileSystemStatus.getStatusFor((Throwable)((Object)fileSystemClientException)));
            }
            catch (TeamRepositoryException teamRepositoryException) {
                this.collectStatus(FileSystemStatus.getStatusFor(teamRepositoryException));
            }
        }
        for (Object object : map.values()) {
            for (Object object3 : object.values()) {
                if (!object3.isType(4)) {
                    this.collectStatus((IStatus)new Status(4, "com.ibm.team.filesystem.client", String.valueOf(Messages.NewCheckInOperation_EXPECTED_FILE_OR_FOLDER_DELETION) + object3));
                    continue;
                }
                iCopyFileArea = this.getUniqueCfaContaining(newCheckInOperation$WorkspaceCheckInRequest, object3.getComponent(), object3.getTarget(), subMonitor.newChild(1));
                if (iCopyFileArea == null) continue;
                try {
                    iCopyFileArea.deleteTreeInfo(object3.getTarget(), object3.getComponent(), iWorkspaceConnection.getContextHandle(), (IProgressMonitor)subMonitor.newChild(1));
                }
                catch (FileSystemClientException fileSystemClientException) {
                    this.collectStatus(FileSystemStatus.getStatusFor((Throwable)((Object)fileSystemClientException)));
                }
            }
        }
        subMonitor.done();
    }

    private ICopyFileArea getUniqueCfaContaining(NewCheckInOperation$WorkspaceCheckInRequest newCheckInOperation$WorkspaceCheckInRequest, IComponentHandle iComponentHandle, IVersionableHandle iVersionableHandle, SubMonitor subMonitor) {
        ICopyFileArea iCopyFileArea = null;
        subMonitor = SubMonitor.convert((IProgressMonitor)((IProgressMonitor)subMonitor), (int)newCheckInOperation$WorkspaceCheckInRequest.allCfas().size());
        IWorkspaceConnection iWorkspaceConnection = newCheckInOperation$WorkspaceCheckInRequest.getWorkspace();
        for (ICopyFileArea iCopyFileArea2 : newCheckInOperation$WorkspaceCheckInRequest.allCfas()) {
            if (iCopyFileArea2.getItemInfo(iVersionableHandle, iComponentHandle, iWorkspaceConnection.getContextHandle()) == null) continue;
            if (iCopyFileArea == null) {
                iCopyFileArea = iCopyFileArea2;
                continue;
            }
            String string = Messages.NewCheckInOperation_DEFAULT_NAME_FOR_UNKNOWN_COMPONENT;
            IComponent iComponent = null;
            try {
                iComponent = (IComponent)iWorkspaceConnection.teamRepository().itemManager().fetchCompleteItem((IItemHandle)iComponentHandle, 0, (IProgressMonitor)subMonitor.newChild(10));
            }
            catch (TeamRepositoryException teamRepositoryException) {
                LoggingHelper.log(FileSystemStatus.getStatusFor(4, Messages.NewCheckInOperation_MISSING_NAME_OF_REMOTE_OBJECT, (Throwable)teamRepositoryException));
            }
            if (iComponent != null) {
                string = iComponent.getName();
            }
            LoggingHelper.log(FileSystemStatus.getStatusFor(1, NLS.bind((String)MULTI_SANDBOX_WARNING, (Object)string, (Object[])new Object[0]), null));
            subMonitor.done();
            return null;
        }
        return iCopyFileArea;
    }

    private void updateCFAConfigState(NewCheckInOperation$WorkspaceCheckInRequest newCheckInOperation$WorkspaceCheckInRequest, IUpdateReport iUpdateReport, SubMonitor subMonitor) throws FileSystemClientException {
        HashMap<UUID, ISyncTime> hashMap = new HashMap<UUID, ISyncTime>();
        for (Object object : iUpdateReport.getComponentStatesBefore()) {
            hashMap.put(object.getComponent().getItemId(), object.getConfigurationTime());
        }
        subMonitor.beginTask(Messages.NewCheckInOperation_UPDATING_SYNC_TIME, iUpdateReport.getComponentStatesAfter().size());
        IWorkspaceConnection iWorkspaceConnection = newCheckInOperation$WorkspaceCheckInRequest.getWorkspace();
        for (IComponentStateSummary iComponentStateSummary : iUpdateReport.getComponentStatesAfter()) {
            IComponentHandle iComponentHandle = iComponentStateSummary.getComponent();
            SubMonitor subMonitor2 = subMonitor.newChild(1);
            Set set = newCheckInOperation$WorkspaceCheckInRequest.allCfas();
            subMonitor2.setWorkRemaining(set.size() + 10);
            ICopyFileArea iCopyFileArea = this.getUniqueCfaContaining(newCheckInOperation$WorkspaceCheckInRequest, iComponentHandle, subMonitor2.newChild(1));
            if (iCopyFileArea == null) continue;
            ISyncTime iSyncTime = (ISyncTime)hashMap.get(iComponentHandle.getItemId());
            iCopyFileArea.setConfigurationState((IContextHandle)iWorkspaceConnection.getResolvedWorkspace(), iComponentHandle, iSyncTime, iComponentStateSummary.getConfigurationTime(), (IProgressMonitor)subMonitor2.newChild(10));
        }
    }

    private ICopyFileArea getUniqueCfaContaining(NewCheckInOperation$WorkspaceCheckInRequest newCheckInOperation$WorkspaceCheckInRequest, IComponentHandle iComponentHandle, SubMonitor subMonitor) throws FileSystemClientException {
        ICopyFileArea iCopyFileArea = null;
        subMonitor = SubMonitor.convert((IProgressMonitor)((IProgressMonitor)subMonitor), (int)newCheckInOperation$WorkspaceCheckInRequest.allCfas().size());
        IWorkspaceConnection iWorkspaceConnection = newCheckInOperation$WorkspaceCheckInRequest.getWorkspace();
        for (ICopyFileArea iCopyFileArea2 : newCheckInOperation$WorkspaceCheckInRequest.allCfas()) {
            if (!iCopyFileArea2.isConfigurationShared(iWorkspaceConnection.getContextHandle(), iComponentHandle, (IProgressMonitor)subMonitor.newChild(1))) continue;
            if (iCopyFileArea == null) {
                iCopyFileArea = iCopyFileArea2;
                continue;
            }
            String string = Messages.NewCheckInOperation_DEFAULT_NAME_FOR_UNKNOWN_COMPONENT;
            IComponent iComponent = null;
            try {
                iComponent = (IComponent)iWorkspaceConnection.teamRepository().itemManager().fetchCompleteItem((IItemHandle)iComponentHandle, 0, (IProgressMonitor)subMonitor.newChild(10));
            }
            catch (TeamRepositoryException teamRepositoryException) {
                LoggingHelper.log(FileSystemStatus.getStatusFor(4, Messages.NewCheckInOperation_MISSING_NAME_OF_REMOTE_OBJECT, (Throwable)teamRepositoryException));
            }
            if (iComponent != null) {
                string = iComponent.getName();
            }
            LoggingHelper.log(FileSystemStatus.getStatusFor(1, NLS.bind((String)MULTI_SANDBOX_WARNING, (Object)string, (Object[])new Object[0]), null));
            subMonitor.done();
            return null;
        }
        return iCopyFileArea;
    }

    protected String getTraceMessage() {
        return "No trace message";
    }

    public boolean getRefreshBeforeRun() {
        return this.refreshBeforeRun;
    }

    public void setRefreshBeforeRun(boolean bl) {
        this.refreshBeforeRun = bl;
    }

    private ILocalChange[] refreshLocalFilesystem(ILocalChange[] iLocalChangeArray, IContextHandle iContextHandle, IComponentHandle iComponentHandle, ISandbox iSandbox, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        ILocalChange[] iLocalChangeArray2;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)(5 + iLocalChangeArray.length));
        LocalChangeManager localChangeManager = LocalChangeManager.getInstance();
        ArrayList<IShareable> arrayList = new ArrayList<IShareable>(iLocalChangeArray.length);
        ILocalChange[] iLocalChangeArray3 = iLocalChangeArray;
        int n = iLocalChangeArray.length;
        int n2 = 0;
        while (n2 < n) {
            iLocalChangeArray2 = iLocalChangeArray3[n2];
            IShareable iShareable = iLocalChangeArray2.getShareable();
            if (iShareable != null) {
                ((Shareable)iShareable).getFileStorage().refreshCachedSubTree(Integer.MAX_VALUE, (IProgressMonitor)subMonitor.newChild(1));
                arrayList.add(iShareable);
            }
            ++n2;
        }
        localChangeManager.refreshChanges(arrayList, (IProgressMonitor)subMonitor.newChild(2));
        localChangeManager.syncPendingChanges(iContextHandle, iComponentHandle, iSandbox, (IProgressMonitor)subMonitor.newChild(3));
        iLocalChangeArray2 = localChangeManager.getPendingChanges(iContextHandle, iComponentHandle, iSandbox);
        HashMap<UUID, ILocalChange> hashMap = new HashMap<UUID, ILocalChange>(iLocalChangeArray2.length);
        ILocalChange[] iLocalChangeArray4 = iLocalChangeArray2;
        int n3 = iLocalChangeArray2.length;
        int n4 = 0;
        while (n4 < n3) {
            ILocalChange iLocalChange = iLocalChangeArray4[n4];
            hashMap.put(iLocalChange.getTarget().getItemId(), iLocalChange);
            ++n4;
        }
        ArrayList<ILocalChange> arrayList2 = new ArrayList<ILocalChange>(iLocalChangeArray.length);
        ILocalChange[] iLocalChangeArray5 = iLocalChangeArray;
        int n5 = iLocalChangeArray.length;
        n3 = 0;
        while (n3 < n5) {
            ILocalChange iLocalChange = iLocalChangeArray5[n3];
            ILocalChange iLocalChange2 = (ILocalChange)hashMap.get(iLocalChange.getTarget().getItemId());
            if (iLocalChange2 != null) {
                arrayList2.add(iLocalChange2);
            }
            ++n3;
        }
        return arrayList2.toArray(new ILocalChange[arrayList2.size()]);
    }

    public void disableNonAtomicCommit() {
        this.nonAtomicCommitIsAnOption = false;
    }

    public void enableNonAtomicCommit(int n) {
        this.nonAtomicCommitIsAnOption = true;
        this.uploadLimit = n;
    }

    static /* synthetic */ Collection access$0(NewCheckInOperation newCheckInOperation) {
        return newCheckInOperation.componentRequests;
    }

    static /* synthetic */ List access$1(NewCheckInOperation newCheckInOperation) {
        return newCheckInOperation.groupRequestsByConnection();
    }
}

