/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.operations;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.operations.ChangeHistoryChangeSetsOperation;
import com.ibm.team.filesystem.client.internal.operations.ChangeSetChooser;
import com.ibm.team.filesystem.client.internal.operations.IFilesystemRefresher;
import com.ibm.team.filesystem.client.internal.operations.MoveFoldersOperation$1;
import com.ibm.team.filesystem.client.internal.operations.MoveFoldersOperation$MoveRequest;
import com.ibm.team.filesystem.client.internal.operations.MoveFoldersOperation$RenameRequest;
import com.ibm.team.filesystem.client.internal.operations.UpdateOperation;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationDescriptor;
import com.ibm.team.filesystem.client.internal.utils.ConnectionDescriptor;
import com.ibm.team.filesystem.client.internal.utils.FlowNodeLock;
import com.ibm.team.filesystem.client.internal.utils.WorkspaceLockUtil;
import com.ibm.team.filesystem.client.operations.IMoveFoldersOperation;
import com.ibm.team.filesystem.client.operations.MoveFoldersDilemmaHandler;
import com.ibm.team.repository.client.util.ThreadCheck;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.IUpdateReport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class MoveFoldersOperation
extends ChangeHistoryChangeSetsOperation
implements IMoveFoldersOperation {
    private List moveRequests;
    private Map renameRequests;
    private MoveFoldersDilemmaHandler moveDilemmaHandler;
    private boolean skipFileAreaUpdates = false;

    public MoveFoldersOperation(MoveFoldersDilemmaHandler moveFoldersDilemmaHandler) {
        super(moveFoldersDilemmaHandler == null ? MoveFoldersDilemmaHandler.getDefault() : moveFoldersDilemmaHandler);
        this.moveDilemmaHandler = moveFoldersDilemmaHandler == null ? MoveFoldersDilemmaHandler.getDefault() : moveFoldersDilemmaHandler;
        this.moveRequests = new ArrayList();
        this.renameRequests = new HashMap();
    }

    protected void execute(IProgressMonitor iProgressMonitor) throws FileSystemClientException, TeamRepositoryException {
        ThreadCheck.checkLongOpsAllowed();
        iProgressMonitor.setTaskName(Messages.MoveFoldersOperation_0);
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (String)Messages.MoveAcrossComponent_ProgressMessage, (int)100);
        Set set = this.getAffectedConfigurations();
        FlowNodeLock flowNodeLock = WorkspaceLockUtil.acquireWrite(set, (IProgressMonitor)subMonitor.newChild(1));
        try {
            MoveFoldersOperation$1 moveFoldersOperation$1 = new MoveFoldersOperation$1(this, set);
            this.runWithinFileSystemLock(moveFoldersOperation$1, Messages.MoveFoldersOperation_1, (IProgressMonitor)subMonitor.newChild(99));
        }
        finally {
            WorkspaceLockUtil.release(flowNodeLock);
        }
        subMonitor.done();
    }

    private Set getAffectedConfigurations() {
        HashSet<ConfigurationDescriptor> hashSet = new HashSet<ConfigurationDescriptor>();
        for (Object object : this.moveRequests) {
            hashSet.add(new ConfigurationDescriptor((IConnection)((MoveFoldersOperation$MoveRequest)object).workspaceConnection, ((MoveFoldersOperation$MoveRequest)object).sourceComponent));
            hashSet.add(new ConfigurationDescriptor((IConnection)((MoveFoldersOperation$MoveRequest)object).workspaceConnection, ((MoveFoldersOperation$MoveRequest)object).targetComponent));
        }
        for (Object object : this.renameRequests.values()) {
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                MoveFoldersOperation$RenameRequest moveFoldersOperation$RenameRequest = (MoveFoldersOperation$RenameRequest)iterator.next();
                hashSet.add(new ConfigurationDescriptor((IConnection)moveFoldersOperation$RenameRequest.workspaceConnection, moveFoldersOperation$RenameRequest.component));
            }
        }
        return hashSet;
    }

    public void addMoveWithinComponentRequest(IWorkspaceConnection iWorkspaceConnection, IComponentHandle iComponentHandle, IFolderHandle[] iFolderHandleArray, IFolderHandle[] iFolderHandleArray2, String string) {
        Object object;
        if (iWorkspaceConnection == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (iComponentHandle == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (iFolderHandleArray == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        IFolderHandle[] iFolderHandleArray3 = iFolderHandleArray;
        int n = iFolderHandleArray.length;
        int n2 = 0;
        while (n2 < n) {
            object = iFolderHandleArray3[n2];
            if (object == null) {
                throw (Throwable)new IllegalArgumentException();
            }
            ++n2;
        }
        if (iFolderHandleArray2 == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        iFolderHandleArray3 = iFolderHandleArray2;
        n = iFolderHandleArray2.length;
        n2 = 0;
        while (n2 < n) {
            object = iFolderHandleArray3[n2];
            if (object == null) {
                throw (Throwable)new IllegalArgumentException();
            }
            ++n2;
        }
        if (iFolderHandleArray.length != iFolderHandleArray2.length) {
            throw (Throwable)new IllegalArgumentException();
        }
        object = new MoveFoldersOperation$MoveRequest(this, iWorkspaceConnection, iComponentHandle, iFolderHandleArray, iComponentHandle, iFolderHandleArray2, string, string);
        this.moveRequests.add(object);
    }

    public void addRenameRequest(IWorkspaceConnection iWorkspaceConnection, IComponentHandle iComponentHandle, IFolderHandle[] iFolderHandleArray, String[] stringArray, String string) {
        if (iWorkspaceConnection == null) {
            throw (Throwable)new IllegalArgumentException("WorkspaceConnection must be supplied for rename request");
        }
        if (iComponentHandle == null) {
            throw (Throwable)new IllegalArgumentException("Component must be supplied for rename request");
        }
        if (iFolderHandleArray == null) {
            throw (Throwable)new IllegalArgumentException("Folders to be renamed must be supplied for rename request");
        }
        if (stringArray == null) {
            throw (Throwable)new IllegalArgumentException("New folder names must be supplied");
        }
        if (iFolderHandleArray.length != stringArray.length) {
            throw (Throwable)new IllegalArgumentException("There must be a new name for each and every folder");
        }
        MoveFoldersOperation$RenameRequest moveFoldersOperation$RenameRequest = new MoveFoldersOperation$RenameRequest(this, iWorkspaceConnection, iComponentHandle, iFolderHandleArray, stringArray, string);
        ArrayList<MoveFoldersOperation$RenameRequest> arrayList = (ArrayList<MoveFoldersOperation$RenameRequest>)this.renameRequests.get(iWorkspaceConnection);
        if (arrayList == null) {
            arrayList = new ArrayList<MoveFoldersOperation$RenameRequest>();
            this.renameRequests.put(iWorkspaceConnection, arrayList);
        }
        arrayList.add(moveFoldersOperation$RenameRequest);
    }

    public void addMoveAcrossComponentRequest(IWorkspaceConnection iWorkspaceConnection, IComponentHandle iComponentHandle, IFolderHandle[] iFolderHandleArray, IComponentHandle iComponentHandle2, IFolderHandle[] iFolderHandleArray2, String string, String string2) {
        Object object;
        if (iWorkspaceConnection == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (iComponentHandle == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (iComponentHandle2 == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (iComponentHandle.sameItemId((IItemHandle)iComponentHandle2)) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (iFolderHandleArray == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        IFolderHandle[] iFolderHandleArray3 = iFolderHandleArray;
        int n = iFolderHandleArray.length;
        int n2 = 0;
        while (n2 < n) {
            object = iFolderHandleArray3[n2];
            if (object == null) {
                throw (Throwable)new IllegalArgumentException();
            }
            ++n2;
        }
        if (iFolderHandleArray2 == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (iFolderHandleArray.length != iFolderHandleArray2.length) {
            throw (Throwable)new IllegalArgumentException();
        }
        object = new MoveFoldersOperation$MoveRequest(this, iWorkspaceConnection, iComponentHandle, iFolderHandleArray, iComponentHandle2, iFolderHandleArray2, string, string2);
        this.moveRequests.add(object);
    }

    private void processRequests(Set set, IProgressMonitor iProgressMonitor) throws FileSystemClientException, TeamRepositoryException {
        Object object3;
        Object object2;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)(10 + 100 * this.moveRequests.size()));
        if (this.verifyInSyncEnabled() && !this.moveDilemmaHandler.getOutOfSyncDilemmaHandler().willIgnoreAllSharesOutOfSync()) {
            object2 = IOperationFactory.instance.getVerifyInSyncOperation(this.moveDilemmaHandler.getOutOfSyncDilemmaHandler());
            for (Object object3 : set) {
                object2.addToVerify(((ConnectionDescriptor)object3).getConnection(null), ((ConfigurationDescriptor)object3).componentHandle);
            }
            object2.run((IProgressMonitor)subMonitor.newChild(10));
        }
        this.checkCancelled((IProgressMonitor)subMonitor);
        object2 = ICopyFileAreaManager.instance.lockRequestFactory().getLockRequest(set, true);
        object3 = ICopyFileAreaManager.instance.lock(Collections.singleton(object2), (IProgressMonitor)subMonitor.newChild(1));
        try {
            this.checkinPendingChanges(set, this.moveDilemmaHandler, true, (IProgressMonitor)subMonitor.newChild(30));
            this.checkCancelled((IProgressMonitor)subMonitor);
            for (MoveFoldersOperation$MoveRequest moveFoldersOperation$MoveRequest : this.moveRequests) {
                IUpdateReport iUpdateReport = moveFoldersOperation$MoveRequest.sourceComponent.sameItemId((IItemHandle)moveFoldersOperation$MoveRequest.targetComponent) ? this.moveFoldersWithinComponent(moveFoldersOperation$MoveRequest, (IProgressMonitor)subMonitor.newChild(50)) : moveFoldersOperation$MoveRequest.workspaceConnection.moveFoldersBetweenComponents(moveFoldersOperation$MoveRequest.sourceComponent, moveFoldersOperation$MoveRequest.targetComponent, moveFoldersOperation$MoveRequest.foldersToMove, moveFoldersOperation$MoveRequest.toDestinationFolders, moveFoldersOperation$MoveRequest.sourceChangeSetComment, moveFoldersOperation$MoveRequest.targetChangeSetComment, (IProgressMonitor)subMonitor.newChild(48));
                this.checkCancelled((IProgressMonitor)subMonitor);
                if (this.skipFileAreaUpdates) continue;
                UpdateOperation updateOperation = new UpdateOperation(moveFoldersOperation$MoveRequest.workspaceConnection, Collections.singletonList(iUpdateReport), 3, this.moveDilemmaHandler, null);
                this.disableVerifyInSync(updateOperation);
                subMonitor.subTask(Messages.MoveFoldersOperation_PROGRESS_UPDATES);
                updateOperation.run((IProgressMonitor)subMonitor.newChild(50));
            }
            for (Map.Entry entry : this.renameRequests.entrySet()) {
                this.processRenames((IWorkspaceConnection)entry.getKey(), (List)entry.getValue(), (IProgressMonitor)subMonitor.newChild(100));
            }
        }
        finally {
            object3.release((IProgressMonitor)subMonitor.newChild(1));
        }
    }

    private IUpdateReport moveFoldersWithinComponent(MoveFoldersOperation$MoveRequest moveFoldersOperation$MoveRequest, IProgressMonitor iProgressMonitor) throws TeamRepositoryException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        List<IFolderHandle> list = Arrays.asList(moveFoldersOperation$MoveRequest.foldersToMove);
        List list2 = moveFoldersOperation$MoveRequest.workspaceConnection.configuration(moveFoldersOperation$MoveRequest.sourceComponent).fetchCompleteItems(list, (IProgressMonitor)subMonitor.newChild(10));
        ChangeSetChooser changeSetChooser = new ChangeSetChooser(moveFoldersOperation$MoveRequest.workspaceConnection, null);
        int n = 0;
        SubMonitor subMonitor2 = subMonitor.newChild(5);
        subMonitor2.setWorkRemaining(list2.size());
        for (IFolder iFolder : list2) {
            iFolder = (IFolder)iFolder.getWorkingCopy();
            iFolder.setParent(moveFoldersOperation$MoveRequest.toDestinationFolders[n]);
            IWorkspaceConnection.ISaveOp iSaveOp = moveFoldersOperation$MoveRequest.workspaceConnection.configurationOpFactory().save((IVersionable)iFolder);
            changeSetChooser.toCommit(moveFoldersOperation$MoveRequest.sourceComponent, (IVersionableHandle)iFolder, (IWorkspaceConnection.IConfigurationOp)iSaveOp, null, moveFoldersOperation$MoveRequest.sourceChangeSetComment, (IProgressMonitor)subMonitor2.newChild(1));
        }
        return changeSetChooser.commit((IProgressMonitor)subMonitor.newChild(85));
    }

    private void processRenames(IWorkspaceConnection iWorkspaceConnection, List list, IProgressMonitor iProgressMonitor) throws TeamRepositoryException, FileSystemClientException {
        MoveFoldersOperation$RenameRequest moveFoldersOperation$RenameRequest2;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)(100 + 15 * list.size()));
        ChangeSetChooser changeSetChooser = new ChangeSetChooser(iWorkspaceConnection, null);
        for (MoveFoldersOperation$RenameRequest moveFoldersOperation$RenameRequest2 : list) {
            List<IFolderHandle> list2 = Arrays.asList(moveFoldersOperation$RenameRequest2.foldersToRename);
            List list3 = iWorkspaceConnection.configuration(moveFoldersOperation$RenameRequest2.component).fetchCompleteItems(list2, (IProgressMonitor)subMonitor.newChild(10));
            int n = 0;
            SubMonitor subMonitor2 = subMonitor.newChild(5);
            subMonitor2.setWorkRemaining(list3.size());
            for (IFolder iFolder : list3) {
                iFolder = (IFolder)iFolder.getWorkingCopy();
                iFolder.setName(moveFoldersOperation$RenameRequest2.newNames[n]);
                ++n;
                IWorkspaceConnection.ISaveOp iSaveOp = iWorkspaceConnection.configurationOpFactory().save((IVersionable)iFolder);
                changeSetChooser.toCommit(moveFoldersOperation$RenameRequest2.component, (IVersionableHandle)iFolder, (IWorkspaceConnection.IConfigurationOp)iSaveOp, null, moveFoldersOperation$RenameRequest2.changeSetComment, (IProgressMonitor)subMonitor2.newChild(1));
            }
        }
        moveFoldersOperation$RenameRequest2 = changeSetChooser.commit((IProgressMonitor)subMonitor.newChild(50));
        this.checkCancelled((IProgressMonitor)subMonitor);
        if (!this.skipFileAreaUpdates) {
            UpdateOperation updateOperation = new UpdateOperation(iWorkspaceConnection, Collections.singletonList(moveFoldersOperation$RenameRequest2), 3, this.moveDilemmaHandler, null);
            this.disableVerifyInSync(updateOperation);
            subMonitor.subTask(Messages.MoveFoldersOperation_PROGRESS_UPDATES);
            updateOperation.run((IProgressMonitor)subMonitor.newChild(50));
        }
    }

    protected void refreshLocal(IFilesystemRefresher iFilesystemRefresher, Map map, IProgressMonitor iProgressMonitor) throws FileSystemClientException, TeamRepositoryException {
        Object object;
        SubMonitor subMonitor;
        SubMonitor subMonitor2;
        SharingManager sharingManager = SharingManager.getInstance();
        SubMonitor subMonitor3 = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)(this.moveRequests.size() + this.renameRequests.size()));
        for (Object object2 : this.moveRequests) {
            subMonitor2 = subMonitor3.newChild(1);
            subMonitor2.setWorkRemaining(((MoveFoldersOperation$MoveRequest)object2).foldersToMove.length);
            int n = 0;
            while (n < ((MoveFoldersOperation$MoveRequest)object2).toDestinationFolders.length) {
                subMonitor = subMonitor2.newChild(1);
                subMonitor.setWorkRemaining(map.size() * 2);
                for (Object object3 : map.keySet()) {
                    Object object4;
                    object = sharingManager.findShareable(object3.getRoot(), ((MoveFoldersOperation$MoveRequest)object2).workspaceConnection.getContextHandle(), ((MoveFoldersOperation$MoveRequest)object2).sourceComponent, (IVersionableHandle)((MoveFoldersOperation$MoveRequest)object2).foldersToMove[n], (IProgressMonitor)subMonitor.newChild(1));
                    if (object == null) continue;
                    iFilesystemRefresher.addToRefresh((IShareable)object);
                    Object object5 = sharingManager.findShareable(object3.getRoot(), ((MoveFoldersOperation$MoveRequest)object2).workspaceConnection.getContextHandle(), ((MoveFoldersOperation$MoveRequest)object2).targetComponent, (IVersionableHandle)((MoveFoldersOperation$MoveRequest)object2).toDestinationFolders[n], (IProgressMonitor)subMonitor.newChild(1));
                    if (object5 == null || (object4 = sharingManager.findShareable((ISandbox)object3, object5.getLocalPath().append(object.getLocalPath().lastSegment()), ResourceType.FOLDER)) == null) continue;
                    iFilesystemRefresher.addToRefresh((IShareable)object4);
                }
                ++n;
            }
        }
        for (Object object2 : this.renameRequests.values()) {
            subMonitor2 = subMonitor3.newChild(1);
            subMonitor2.setWorkRemaining(object2.size());
            subMonitor = object2.iterator();
            while (subMonitor.hasNext()) {
                Object object3;
                MoveFoldersOperation$RenameRequest moveFoldersOperation$RenameRequest = (MoveFoldersOperation$RenameRequest)subMonitor.next();
                object3 = subMonitor2.newChild(1);
                object3.setWorkRemaining(moveFoldersOperation$RenameRequest.foldersToRename.length);
                int n = 0;
                while (n < moveFoldersOperation$RenameRequest.foldersToRename.length) {
                    object = object3.newChild(1);
                    object.setWorkRemaining(map.size());
                    for (Object object5 : map.keySet()) {
                        IShareable iShareable = sharingManager.findShareable(object5.getRoot(), moveFoldersOperation$RenameRequest.workspaceConnection.getContextHandle(), moveFoldersOperation$RenameRequest.component, (IVersionableHandle)moveFoldersOperation$RenameRequest.foldersToRename[n], (IProgressMonitor)object.newChild(1));
                        if (iShareable == null) continue;
                        iFilesystemRefresher.addToRefresh(iShareable);
                        Shareable shareable = sharingManager.findShareable((ISandbox)object5, iShareable.getLocalPath().removeLastSegments(1).append(moveFoldersOperation$RenameRequest.newNames[n]), ResourceType.FOLDER);
                        if (shareable == null) continue;
                        iFilesystemRefresher.addToRefresh(shareable);
                    }
                    ++n;
                }
            }
        }
    }

    public void setSkipFileAreaUpdates(boolean bl) {
        this.skipFileAreaUpdates = bl;
    }

    static /* synthetic */ void access$0(MoveFoldersOperation moveFoldersOperation, Set set, IProgressMonitor iProgressMonitor) throws FileSystemClientException, TeamRepositoryException {
        moveFoldersOperation.processRequests(set, iProgressMonitor);
    }
}

