/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.operations;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.ILocalChangeManager;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.FileSystemManager;
import com.ibm.team.filesystem.client.internal.FileSystemServiceProxy;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.Sandbox;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileArea;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.operations.MarkAsMergedOperation$1;
import com.ibm.team.filesystem.client.internal.operations.ResolveConflictsOperation;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationDescriptor;
import com.ibm.team.filesystem.client.internal.utils.FlowNodeLock;
import com.ibm.team.filesystem.client.internal.utils.WorkspaceLockUtil;
import com.ibm.team.filesystem.client.operations.ICheckinOperation;
import com.ibm.team.filesystem.client.operations.ICheckinOptions;
import com.ibm.team.filesystem.client.operations.IVerifyInSyncOperation;
import com.ibm.team.filesystem.client.operations.MarkAsMergedDilemmaHandler;
import com.ibm.team.filesystem.client.operations.UpdateDilemmaHandler;
import com.ibm.team.filesystem.common.ILogicalChange;
import com.ibm.team.filesystem.common.ILogicalConflictReport;
import com.ibm.team.filesystem.common.internal.dto.ConflictResolutionReport;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.IItemConflictReport;
import com.ibm.team.scm.common.dto.IUpdateReport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

public class MarkAsMergedOperation
extends ResolveConflictsOperation
implements ICheckinOptions {
    private final MarkAsMergedDilemmaHandler problemHandler;
    private boolean nonAtomicCommitIsAnOption = true;
    private int nonAtomicCommitFileUploadLimit = 200;

    public MarkAsMergedOperation(IWorkspaceConnection iWorkspaceConnection, ILogicalConflictReport iLogicalConflictReport, Collection collection, MarkAsMergedDilemmaHandler markAsMergedDilemmaHandler) throws FileSystemClientException {
        super(iWorkspaceConnection, iLogicalConflictReport, collection, markAsMergedDilemmaHandler == null ? MarkAsMergedDilemmaHandler.getDefault() : markAsMergedDilemmaHandler);
        this.problemHandler = markAsMergedDilemmaHandler == null ? MarkAsMergedDilemmaHandler.getDefault() : markAsMergedDilemmaHandler;
    }

    protected void execute(IProgressMonitor iProgressMonitor) throws FileSystemClientException, TeamRepositoryException {
        Object object2;
        if (this.changes.isEmpty()) {
            return;
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        Collection collection = this.getRequiredChanges();
        if (collection.size() > 0) {
            switch (this.problemHandler.missingRequiredChanges(collection)) {
                case 2: {
                    throw (Throwable)((Object)new FileSystemClientException(new FileSystemStatus(NLS.bind((String)Messages.MarkAsMergedOperation_0, (Object)collection.size()))));
                }
                case 1: {
                    throw (Throwable)new OperationCanceledException();
                }
                case 0: {
                    this.changes.addAll(collection);
                }
            }
        }
        IVerifyInSyncOperation iVerifyInSyncOperation = IOperationFactory.instance.getVerifyInSyncOperation(this.problemHandler.getOutOfSyncDilemmaHandler());
        HashSet<ConfigurationDescriptor> hashSet = new HashSet<ConfigurationDescriptor>();
        for (Object object2 : this.changes) {
            iVerifyInSyncOperation.addToVerify((IConnection)this.connection, object2.component());
            hashSet.add(new ConfigurationDescriptor((IConnection)this.connection, object2.component()));
        }
        if (subMonitor.isCanceled()) {
            throw (Throwable)new OperationCanceledException();
        }
        object2 = WorkspaceLockUtil.acquireWrite(hashSet, (IProgressMonitor)subMonitor.newChild(1));
        try {
            if (this.verifyInSyncEnabled() && !this.problemHandler.getOutOfSyncDilemmaHandler().willIgnoreAllSharesOutOfSync()) {
                iVerifyInSyncOperation.run((IProgressMonitor)subMonitor.newChild(5));
            }
            if (subMonitor.isCanceled()) {
                throw (Throwable)new OperationCanceledException();
            }
            MarkAsMergedOperation$1 markAsMergedOperation$1 = new MarkAsMergedOperation$1(this, hashSet);
            this.runWithinFileSystemLock(markAsMergedOperation$1, Messages.MarkAsMergedOperation_3, (IProgressMonitor)subMonitor);
        }
        finally {
            WorkspaceLockUtil.release((FlowNodeLock)object2);
        }
    }

    private void doMarkAsMerged(HashSet hashSet, IProgressMonitor iProgressMonitor) throws TeamRepositoryException, FileSystemClientException {
        List list;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        Map map = this.organizeChanges();
        Map map2 = this.getCopyFileAreasAffected(hashSet, (IProgressMonitor)subMonitor.newChild(1));
        this.checkinPendingChanges(map, map2, this.problemHandler, (IProgressMonitor)subMonitor.newChild(24));
        if (subMonitor.isCanceled()) {
            throw (Throwable)new OperationCanceledException();
        }
        this.verifyChangesMerged(map, map2, this.problemHandler, (IProgressMonitor)subMonitor.newChild(5));
        if (subMonitor.isCanceled()) {
            throw (Throwable)new OperationCanceledException();
        }
        this.confirmMarkAsMerged(this.problemHandler);
        FileSystemServiceProxy fileSystemServiceProxy = ((FileSystemManager)FileSystemCore.getFileSystemManager(this.connection.teamRepository())).getFileSystemService();
        try {
            list = fileSystemServiceProxy.markAsMerged(this.connection, this.changes, (IProgressMonitor)subMonitor.newChild(25));
        }
        catch (TeamRepositoryException teamRepositoryException) {
            if (teamRepositoryException.getData() instanceof ConflictResolutionReport) {
                this.collectStatus(new FileSystemStatus(4, teamRepositoryException.getMessage()));
                if (teamRepositoryException.getCause() != null) {
                    this.collectStatus(new FileSystemStatus(4, teamRepositoryException.getCause().getMessage()));
                }
                this.updateCopyFileArea((ConflictResolutionReport)teamRepositoryException.getData(), (UpdateDilemmaHandler)this.problemHandler, (IProgressMonitor)subMonitor.newChild(45));
            }
            throw (Throwable)teamRepositoryException;
        }
        if (!list.isEmpty()) {
            this.updateCopyFileArea(list, (UpdateDilemmaHandler)this.problemHandler, (IProgressMonitor)subMonitor.newChild(45));
        }
    }

    private void confirmMarkAsMerged(MarkAsMergedDilemmaHandler markAsMergedDilemmaHandler) throws FileSystemClientException {
        int n = markAsMergedDilemmaHandler.confirmMarkAsMerged(this.changes);
        if (n == 1) {
            throw (Throwable)new OperationCanceledException();
        }
    }

    private Map organizeChanges() {
        HashMap<ConfigurationDescriptor, HashMap<UUID, ILogicalChange>> hashMap = new HashMap<ConfigurationDescriptor, HashMap<UUID, ILogicalChange>>();
        for (ILogicalChange iLogicalChange : this.changes) {
            ConfigurationDescriptor configurationDescriptor = new ConfigurationDescriptor((IConnection)this.connection, iLogicalChange.component());
            HashMap<UUID, ILogicalChange> hashMap2 = (HashMap<UUID, ILogicalChange>)hashMap.get(configurationDescriptor);
            if (hashMap2 == null) {
                hashMap2 = new HashMap<UUID, ILogicalChange>();
                hashMap.put(configurationDescriptor, hashMap2);
            }
            hashMap2.put(iLogicalChange.item().getItemId(), iLogicalChange);
        }
        return hashMap;
    }

    protected void verifyChangesMerged(Map map, Map map2, MarkAsMergedDilemmaHandler markAsMergedDilemmaHandler, IProgressMonitor iProgressMonitor) throws TeamRepositoryException, FileSystemClientException {
        int n;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        ArrayList<ILogicalChange> arrayList = new ArrayList<ILogicalChange>();
        IUpdateReport iUpdateReport = this.connection.conflictReport();
        for (IItemConflictReport iItemConflictReport : iUpdateReport.conflicts()) {
            ILogicalChange iLogicalChange;
            ConfigurationDescriptor configurationDescriptor;
            Map map3;
            boolean bl = false;
            IVersionableHandle iVersionableHandle = iItemConflictReport.getSelectedContributorState();
            IVersionableHandle iVersionableHandle2 = iItemConflictReport.getProposedContributorState();
            IVersionableHandle iVersionableHandle3 = iItemConflictReport.getOriginalSelectedContributorState();
            if (iVersionableHandle == null && iVersionableHandle3 != null) {
                bl = true;
            } else if (iVersionableHandle != null && iVersionableHandle3 == null) {
                bl = true;
            } else if (iVersionableHandle == null && iVersionableHandle3 == null) {
                if (iVersionableHandle2 == null) {
                    bl = true;
                }
            } else if (!iVersionableHandle.sameStateId((IItemHandle)iVersionableHandle3)) {
                bl = true;
            }
            if (bl || (map3 = (Map)map.get(configurationDescriptor = new ConfigurationDescriptor((IConnection)this.connection, iItemConflictReport.getComponent()))) == null || !map3.containsKey(iItemConflictReport.item().getItemId()) || this.isEvilTwin(iItemConflictReport, iLogicalChange = (ILogicalChange)map3.get(iItemConflictReport.item().getItemId()), configurationDescriptor, map2, (IProgressMonitor)subMonitor)) continue;
            arrayList.add(iLogicalChange);
        }
        if (!arrayList.isEmpty() && (n = markAsMergedDilemmaHandler.unmergedChanges(arrayList)) != 0) {
            if (n == 1) {
                throw (Throwable)new OperationCanceledException();
            }
            throw (Throwable)((Object)new FileSystemClientException(new FileSystemStatus(4, Messages.MarkAsMergedOperation_2)));
        }
    }

    private boolean isEvilTwin(IItemConflictReport iItemConflictReport, ILogicalChange iLogicalChange, ConfigurationDescriptor configurationDescriptor, Map map, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        boolean bl = false;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)map.size());
        for (Map.Entry entry : map.entrySet()) {
            ISandbox iSandbox = (ISandbox)entry.getKey();
            Set set = (Set)entry.getValue();
            if (!set.contains(configurationDescriptor) || !(bl |= this.isEvilTwin(iSandbox, iItemConflictReport, iLogicalChange, (IProgressMonitor)subMonitor.newChild(1)))) continue;
            return bl;
        }
        return false;
    }

    private boolean isEvilTwin(ISandbox iSandbox, IItemConflictReport iItemConflictReport, ILogicalChange iLogicalChange, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        Shareable shareable;
        ResourceType resourceType;
        IPath iPath;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)2);
        IVersionableHandle iVersionableHandle = iItemConflictReport.getSelectedContributorState();
        IVersionableHandle iVersionableHandle2 = iItemConflictReport.getProposedContributorState();
        IVersionableHandle iVersionableHandle3 = iItemConflictReport.getOriginalSelectedContributorState();
        return iVersionableHandle == null && iVersionableHandle3 == null && iVersionableHandle2 != null && (iPath = (IPath)iSandbox.getPathRelativeToShares(this.connection.getContextHandle(), iItemConflictReport.getComponent(), Collections.singletonList(iLogicalChange.getAncestorPathHint()), (IProgressMonitor)subMonitor.newChild(1)).get(0)) != null && (resourceType = (shareable = (Shareable)iSandbox.findShareable(iPath, ResourceType.getResourceType(iItemConflictReport.item()))).getResourceType((IProgressMonitor)subMonitor.newChild(1))) != null && resourceType == ResourceType.getResourceType(iItemConflictReport.item());
    }

    private void checkinPendingChanges(Map map, Map map2, MarkAsMergedDilemmaHandler markAsMergedDilemmaHandler, IProgressMonitor iProgressMonitor) throws TeamRepositoryException, FileSystemClientException {
        ConfigurationDescriptor configurationDescriptor;
        Object object;
        ArrayList<ILocalChange> arrayList = new ArrayList<ILocalChange>();
        HashMap<UUID, ArrayList<ILocalChange>> hashMap = new HashMap<UUID, ArrayList<ILocalChange>>();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        SubMonitor subMonitor2 = subMonitor.newChild(2).setWorkRemaining(map2.size());
        for (Map.Entry entry : map2.entrySet()) {
            ISandbox object2 = (ISandbox)entry.getKey();
            Set set = (Set)entry.getValue();
            object = subMonitor2.newChild(1).setWorkRemaining(set.size());
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                ILocalChange[] iLocalChangeArray;
                configurationDescriptor = (ConfigurationDescriptor)iterator.next();
                Map map3 = (Map)map.get(configurationDescriptor);
                ILocalChangeManager iLocalChangeManager = FileSystemCore.getSharingManager().getLocalChangeManager();
                iLocalChangeManager.syncPendingChanges(configurationDescriptor.connectionHandle, configurationDescriptor.componentHandle, object2, (IProgressMonitor)object.newChild(1));
                ILocalChange[] iLocalChangeArray2 = iLocalChangeArray = iLocalChangeManager.getPendingChanges(configurationDescriptor.connectionHandle, configurationDescriptor.componentHandle, object2);
                int n = iLocalChangeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ILocalChange iLocalChange = iLocalChangeArray2[n2];
                    if (map3.containsKey(iLocalChange.getTarget().getItemId())) {
                        arrayList.add(iLocalChange);
                        ArrayList<ILocalChange> arrayList2 = (ArrayList<ILocalChange>)hashMap.get(iLocalChange.getComponent().getItemId());
                        if (arrayList2 == null) {
                            arrayList2 = new ArrayList<ILocalChange>();
                            hashMap.put(iLocalChange.getComponent().getItemId(), arrayList2);
                        }
                        arrayList2.add(iLocalChange);
                    }
                    ++n2;
                }
            }
        }
        if (!arrayList.isEmpty()) {
            int n = markAsMergedDilemmaHandler.uncheckedInChanges(arrayList);
            if (n == 0) {
                ICheckinOperation iCheckinOperation = IOperationFactory.instance.getCheckinOperation(markAsMergedDilemmaHandler);
                if (this.nonAtomicCommitIsAnOption) {
                    iCheckinOperation.enableNonAtomicCommit(this.nonAtomicCommitFileUploadLimit);
                } else {
                    iCheckinOperation.disableNonAtomicCommit();
                }
                subMonitor2 = subMonitor.newChild(8);
                subMonitor2.setWorkRemaining(hashMap.size());
                for (Map.Entry entry : hashMap.entrySet()) {
                    object = (Collection)entry.getValue();
                    if (object.isEmpty()) continue;
                    configurationDescriptor = ((ILocalChange)object.iterator().next()).getComponent();
                    iCheckinOperation.requestCheckin(this.connection, (IComponentHandle)configurationDescriptor, object.toArray(new ILocalChange[object.size()]), null, Messages.MarkAsMergedOperation_ChangeSetDefaultComment, (IProgressMonitor)subMonitor2.newChild(1));
                }
                this.disableVerifyInSync(iCheckinOperation);
                iCheckinOperation.run((IProgressMonitor)subMonitor.newChild(90));
            } else {
                if (n == 1) {
                    throw (Throwable)new OperationCanceledException();
                }
                throw (Throwable)((Object)new FileSystemClientException(new FileSystemStatus(4, Messages.MarkAsMergedOperation_1)));
            }
        }
        subMonitor.done();
    }

    protected final Map getCopyFileAreasAffected(Set set, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        HashMap<Sandbox, HashSet<ConfigurationDescriptor>> hashMap = new HashMap<Sandbox, HashSet<ConfigurationDescriptor>>();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)set.size());
        ICopyFileAreaManager iCopyFileAreaManager = ICopyFileAreaManager.instance;
        for (ConfigurationDescriptor configurationDescriptor : set) {
            Collection collection = iCopyFileAreaManager.getCopyFileAreasForConfiguration(configurationDescriptor, (IProgressMonitor)subMonitor.newChild(1));
            for (ICopyFileArea iCopyFileArea : collection) {
                Sandbox sandbox = new Sandbox(iCopyFileArea);
                HashSet<ConfigurationDescriptor> hashSet = (HashSet<ConfigurationDescriptor>)hashMap.get(sandbox);
                if (hashSet == null) {
                    hashSet = new HashSet<ConfigurationDescriptor>();
                    hashMap.put(sandbox, hashSet);
                }
                hashSet.add(configurationDescriptor);
            }
        }
        return hashMap;
    }

    public void disableNonAtomicCommit() {
        this.nonAtomicCommitIsAnOption = false;
    }

    public void enableNonAtomicCommit(int n) {
        this.nonAtomicCommitIsAnOption = true;
        this.nonAtomicCommitFileUploadLimit = n;
    }

    static /* synthetic */ void access$0(MarkAsMergedOperation markAsMergedOperation, HashSet hashSet, IProgressMonitor iProgressMonitor) throws TeamRepositoryException, FileSystemClientException {
        markAsMergedOperation.doMarkAsMerged(hashSet, iProgressMonitor);
    }
}

