/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.operations;

import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.operations.ILoadRequest;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class LoadRequest
implements ILoadRequest {
    private final ISandbox sandbox;
    private final IPath relativeLoadPath;
    private final String alternativeName;
    private final IConnection connection;
    private final IComponentHandle component;
    private final IVersionableHandle itemToLoad;
    private boolean isReloadRequest;

    public LoadRequest(ISandbox iSandbox, IPath iPath, String string, IConnection iConnection, IComponentHandle iComponentHandle, IVersionableHandle iVersionableHandle, boolean bl) {
        this.sandbox = iSandbox;
        if (iPath == null || iPath.segmentCount() == 0) {
            this.relativeLoadPath = (IPath)new Path("");
        } else {
            IPath iPath2 = iSandbox.getRoot().append(iPath);
            if ((iPath2 = LoadRequest.getPath(iPath2)).segmentCount() < iSandbox.getRoot().segmentCount()) {
                throw (Throwable)new IllegalArgumentException("Invalid relative path " + iPath);
            }
            this.relativeLoadPath = iPath2.removeFirstSegments(iSandbox.getRoot().segmentCount()).setDevice(null);
        }
        this.alternativeName = string == null ? "" : string;
        this.connection = iConnection;
        this.component = iComponentHandle;
        this.itemToLoad = iVersionableHandle;
        this.isReloadRequest = bl;
    }

    static IPath getPath(IPath iPath) {
        return new Path(iPath.toFile().getAbsolutePath()).removeTrailingSeparator();
    }

    public IComponentHandle getComponent() {
        return this.component;
    }

    public IConnection getConnection() {
        return this.connection;
    }

    public boolean isReloadRequest() {
        return this.isReloadRequest;
    }

    public void setReloadRequest(boolean bl) {
        this.isReloadRequest = bl;
    }

    public String getAlternativeName() {
        return this.alternativeName;
    }

    public ISandbox getSandbox() {
        return this.sandbox;
    }

    public IPath getRelativeLoadPath() {
        return this.relativeLoadPath;
    }

    public IVersionableHandle getVersionableToLoad() {
        return this.itemToLoad;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.sandbox == null ? 0 : this.sandbox.toString().hashCode());
        n = 31 * n + (this.relativeLoadPath == null ? 0 : this.relativeLoadPath.toString().hashCode());
        n = 31 * n + (this.alternativeName == null ? 0 : this.alternativeName.toString().hashCode());
        n = 31 * n + (this.component == null ? 0 : this.component.getItemId().hashCode());
        n = 31 * n + (this.connection == null ? 0 : this.connection.hashCode());
        n = 31 * n + (this.itemToLoad == null ? 0 : this.itemToLoad.getItemId().hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        LoadRequest loadRequest = (LoadRequest)object;
        if (this.alternativeName == null ? loadRequest.alternativeName != null : !this.alternativeName.equals(loadRequest.alternativeName)) {
            return false;
        }
        if (this.component == null ? loadRequest.component != null : !this.component.sameItemId((IItemHandle)loadRequest.component)) {
            return false;
        }
        if (this.connection == null ? loadRequest.connection != null : !this.connection.equals(loadRequest.connection)) {
            return false;
        }
        if (this.sandbox == null) {
            if (loadRequest.sandbox != null) {
                return false;
            }
        } else {
            if (loadRequest.sandbox == null) {
                return false;
            }
            if (!this.sandbox.equals(loadRequest.sandbox)) {
                return false;
            }
        }
        if (this.itemToLoad == null ? loadRequest.itemToLoad != null : !this.itemToLoad.sameItemId((IItemHandle)loadRequest.itemToLoad)) {
            return false;
        }
        if (this.relativeLoadPath == null) {
            if (loadRequest.relativeLoadPath != null) {
                return false;
            }
        } else {
            if (loadRequest.relativeLoadPath == null) {
                return false;
            }
            if (!this.relativeLoadPath.toFile().equals(loadRequest.relativeLoadPath.toFile())) {
                return false;
            }
        }
        return true;
    }
}

