/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.operations;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.IFileSystemManager;
import com.ibm.team.filesystem.client.ILoadRule;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.Collision;
import com.ibm.team.filesystem.client.internal.FileSystemManager;
import com.ibm.team.filesystem.client.internal.FileSystemServiceProxy;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.Shed;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaLockRequest;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaManager$ICopyFileAreaLockRequestFactory;
import com.ibm.team.filesystem.client.internal.load.InvalidLoadLocation;
import com.ibm.team.filesystem.client.internal.load.LoadLocation;
import com.ibm.team.filesystem.client.internal.load.LoadOverlap;
import com.ibm.team.filesystem.client.internal.load.MergeLoadMutator;
import com.ibm.team.filesystem.client.internal.load.RemovedShare;
import com.ibm.team.filesystem.client.internal.load.ShareableToLoad;
import com.ibm.team.filesystem.client.internal.operations.FileSystemOperation;
import com.ibm.team.filesystem.client.internal.operations.InvalidLoadRequest;
import com.ibm.team.filesystem.client.internal.operations.LoadOperation$1;
import com.ibm.team.filesystem.client.internal.operations.LoadOperation$2;
import com.ibm.team.filesystem.client.internal.operations.LoadRequest;
import com.ibm.team.filesystem.client.internal.operations.MultipleSandboxLoad;
import com.ibm.team.filesystem.client.internal.operations.VerifySharesOperation;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationDescriptor;
import com.ibm.team.filesystem.client.internal.utils.FlowNodeLock;
import com.ibm.team.filesystem.client.internal.utils.PathUtils;
import com.ibm.team.filesystem.client.internal.utils.WorkspaceLockUtil;
import com.ibm.team.filesystem.client.operations.ICollision;
import com.ibm.team.filesystem.client.operations.IDownloadListener;
import com.ibm.team.filesystem.client.operations.IInvalidLoadRequest$InvalidLoadRequestReason;
import com.ibm.team.filesystem.client.operations.ILoadLocation;
import com.ibm.team.filesystem.client.operations.ILoadOperation;
import com.ibm.team.filesystem.client.operations.ILoadRequest;
import com.ibm.team.filesystem.client.operations.IRemovedShare;
import com.ibm.team.filesystem.client.operations.LoadDilemmaHandler;
import com.ibm.team.filesystem.client.operations.OutOfSyncDilemmaHandler;
import com.ibm.team.filesystem.common.internal.dto.FilesystemDTOFactory;
import com.ibm.team.filesystem.common.internal.dto.LoadTree;
import com.ibm.team.filesystem.common.internal.dto.OverlapDescription;
import com.ibm.team.filesystem.common.internal.dto.OverlapResponse;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IConfiguration;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.IAncestorReport;
import com.ibm.team.scm.common.dto.INameItemPair;
import com.ibm.team.scm.common.dto.ISynchronizationInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.osgi.util.NLS;

public class LoadOperation
extends FileSystemOperation
implements ILoadOperation {
    private final LoadDilemmaHandler dilemmaHandler;
    private HashMap requestsByCFA;
    private HashSet copyFileAreasAffected;
    private ISynchronizationInfo synchronizationInfo;
    private HashSet sharesToRemove = new HashSet();
    private HashMap invalidLoadLocations = new HashMap();
    private HashMap treesToLoad;
    private HashMap collisions;
    private HashMap newItems;
    private ArrayList loadOverLaps;
    private ArrayList sharesOutOfSync;
    private ArrayList invalidLoadRequests;
    private int options;
    private IDownloadListener downloadMonitor;

    public LoadOperation(LoadDilemmaHandler loadDilemmaHandler) {
        super(loadDilemmaHandler == null ? LoadDilemmaHandler.getDefault() : loadDilemmaHandler);
        this.dilemmaHandler = loadDilemmaHandler == null ? LoadDilemmaHandler.getDefault() : loadDilemmaHandler;
        this.requestsByCFA = new HashMap();
        this.treesToLoad = new HashMap();
        this.sharesToRemove = new HashSet();
        this.invalidLoadLocations = new HashMap();
        this.collisions = new HashMap();
        this.newItems = new HashMap();
        this.loadOverLaps = new ArrayList();
        this.sharesOutOfSync = new ArrayList();
        this.invalidLoadRequests = new ArrayList();
        this.copyFileAreasAffected = new HashSet();
        this.options = 0;
    }

    public void requestLoad(ISandbox iSandbox, IPath iPath, IWorkspaceConnection iWorkspaceConnection, IComponentHandle iComponentHandle, Collection collection) {
        this.validateRequestToLoad(iSandbox, iPath, (IConnection)iWorkspaceConnection, iComponentHandle, collection);
        this.recordRequestToLoad(iSandbox, iPath, (IConnection)iWorkspaceConnection, iComponentHandle, collection);
    }

    public void requestLoad(ISandbox iSandbox, IPath iPath, IBaselineConnection iBaselineConnection, Collection collection) {
        if (iBaselineConnection == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        this.validateRequestToLoad(iSandbox, iPath, (IConnection)iBaselineConnection, iBaselineConnection.getComponent(), collection);
        this.recordRequestToLoad(iSandbox, iPath, (IConnection)iBaselineConnection, iBaselineConnection.getComponent(), collection);
    }

    public void requestLoad(ISandbox iSandbox, IPath iPath, Collection collection, IProgressMonitor iProgressMonitor) throws TeamRepositoryException {
        if (collection == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)collection.size());
        for (ILoadRule iLoadRule : collection) {
            this.recordRequestToLoad(iSandbox, iPath, (IConnection)iLoadRule.getWorkspaceConnection(), iLoadRule.getComponent(), iLoadRule.getItemsToLoad((IProgressMonitor)subMonitor.newChild(1)));
        }
    }

    private void validateRequestToLoad(ISandbox iSandbox, IPath iPath, IConnection iConnection, IComponentHandle iComponentHandle, Collection collection) {
        if (iSandbox == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (iConnection == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (iComponentHandle == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (collection == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        for (IVersionableHandle iVersionableHandle : collection) {
            if (iVersionableHandle != null) continue;
            throw (Throwable)new IllegalArgumentException();
        }
    }

    private void recordRequestToLoad(ISandbox iSandbox, IPath iPath, IConnection iConnection, IComponentHandle iComponentHandle, Collection collection) {
        ConfigurationDescriptor configurationDescriptor = new ConfigurationDescriptor(iConnection, iComponentHandle);
        if (!collection.isEmpty()) {
            HashSet<LoadRequest> hashSet;
            HashMap hashMap;
            HashMap hashMap2 = (HashMap)this.requestsByCFA.get(iSandbox);
            if (hashMap2 == null) {
                hashMap2 = new HashMap();
                this.requestsByCFA.put(iSandbox, hashMap2);
            }
            if ((hashMap = (HashMap)hashMap2.get(iConnection)) == null) {
                hashMap = new HashMap();
                hashMap2.put(iConnection, hashMap);
            }
            if ((hashSet = (HashSet<LoadRequest>)hashMap.get(configurationDescriptor)) == null) {
                hashSet = new HashSet<LoadRequest>();
                hashMap.put(configurationDescriptor, hashSet);
            }
            for (IVersionableHandle iVersionableHandle : collection) {
                LoadRequest loadRequest = new LoadRequest(iSandbox, iPath, "", iConnection, iComponentHandle, iVersionableHandle, false);
                hashSet.add(loadRequest);
            }
        }
    }

    public void requestReLoad(Collection collection, IProgressMonitor iProgressMonitor) throws TeamRepositoryException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)collection.size());
        if (collection == null || collection.isEmpty()) {
            throw (Throwable)new IllegalArgumentException();
        }
        for (IShare iShare : collection) {
            if (iShare != null) continue;
            throw (Throwable)new IllegalArgumentException();
        }
        for (IShare iShare : collection) {
            HashSet<LoadRequest> hashSet;
            HashMap hashMap;
            ISharingDescriptor iSharingDescriptor = iShare.getSharingDescriptor();
            ConfigurationDescriptor configurationDescriptor = new ConfigurationDescriptor(iSharingDescriptor.getRepositoryId(), iSharingDescriptor.getRepositoryUri(), iSharingDescriptor.getConnectionHandle(), iSharingDescriptor.getComponent());
            IConnection iConnection = configurationDescriptor.getConnection((IProgressMonitor)subMonitor.newChild(1));
            HashMap hashMap2 = (HashMap)this.requestsByCFA.get(iShare.getSandbox());
            if (hashMap2 == null) {
                hashMap2 = new HashMap();
                this.requestsByCFA.put(iShare.getSandbox(), hashMap2);
            }
            if ((hashMap = (HashMap)hashMap2.get(iConnection)) == null) {
                hashMap = new HashMap();
                hashMap2.put(iConnection, hashMap);
            }
            if ((hashSet = (HashSet<LoadRequest>)hashMap.get(configurationDescriptor)) == null) {
                hashSet = new HashSet<LoadRequest>();
                hashMap.put(configurationDescriptor, hashSet);
            }
            IPath iPath = iShare.getPath().removeLastSegments(1);
            String string = iShare.getPath().lastSegment();
            hashSet.add(new LoadRequest(iShare.getSandbox(), iPath, string, iConnection, iSharingDescriptor.getComponent(), iSharingDescriptor.getRootVersionable(), true));
        }
    }

    public void requestLoadAs(ISandbox iSandbox, IPath iPath, String string, IBaselineConnection iBaselineConnection, IVersionableHandle iVersionableHandle) {
        ConfigurationDescriptor configurationDescriptor;
        HashSet<LoadRequest> hashSet;
        HashMap hashMap;
        if (iBaselineConnection == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        this.validateRequestToLoad(iSandbox, iPath, (IConnection)iBaselineConnection, iBaselineConnection.getComponent(), Collections.singletonList(iVersionableHandle));
        HashMap hashMap2 = (HashMap)this.requestsByCFA.get(iSandbox);
        if (hashMap2 == null) {
            hashMap2 = new HashMap();
            this.requestsByCFA.put(iSandbox, hashMap2);
        }
        if ((hashMap = (HashMap)hashMap2.get(iBaselineConnection)) == null) {
            hashMap = new HashMap();
            hashMap2.put(iBaselineConnection, hashMap);
        }
        if ((hashSet = (HashSet<LoadRequest>)hashMap.get(configurationDescriptor = new ConfigurationDescriptor(iBaselineConnection))) == null) {
            hashSet = new HashSet<LoadRequest>();
            hashMap.put(configurationDescriptor, hashSet);
        }
        LoadRequest loadRequest = new LoadRequest(iSandbox, iPath, string, (IConnection)iBaselineConnection, iBaselineConnection.getComponent(), iVersionableHandle, false);
        hashSet.add(loadRequest);
    }

    public void requestLoadAs(ISandbox iSandbox, IPath iPath, String string, IWorkspaceConnection iWorkspaceConnection, IComponentHandle iComponentHandle, IVersionableHandle iVersionableHandle) {
        ConfigurationDescriptor configurationDescriptor;
        HashSet<LoadRequest> hashSet;
        HashMap hashMap;
        if (iWorkspaceConnection == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        this.validateRequestToLoad(iSandbox, iPath, (IConnection)iWorkspaceConnection, iComponentHandle, Collections.singletonList(iVersionableHandle));
        HashMap hashMap2 = (HashMap)this.requestsByCFA.get(iSandbox);
        if (hashMap2 == null) {
            hashMap2 = new HashMap();
            this.requestsByCFA.put(iSandbox, hashMap2);
        }
        if ((hashMap = (HashMap)hashMap2.get(iWorkspaceConnection)) == null) {
            hashMap = new HashMap();
            hashMap2.put(iWorkspaceConnection, hashMap);
        }
        if ((hashSet = (HashSet<LoadRequest>)hashMap.get(configurationDescriptor = new ConfigurationDescriptor((IConnection)iWorkspaceConnection, iComponentHandle))) == null) {
            hashSet = new HashSet<LoadRequest>();
            hashMap.put(configurationDescriptor, hashSet);
        }
        LoadRequest loadRequest = new LoadRequest(iSandbox, iPath, string, (IConnection)iWorkspaceConnection, iComponentHandle, iVersionableHandle, false);
        hashSet.add(loadRequest);
    }

    public Collection getLoadRequests() {
        ArrayList arrayList = new ArrayList();
        for (HashMap hashMap : this.requestsByCFA.values()) {
            for (HashMap hashMap2 : hashMap.values()) {
                for (Set set : hashMap2.values()) {
                    arrayList.addAll(set);
                }
            }
        }
        return Collections.unmodifiableCollection(arrayList);
    }

    public Collection getLoadOverlaps() {
        return Collections.unmodifiableCollection(this.loadOverLaps);
    }

    public Collection getInvalidLoadRequests() {
        return Collections.unmodifiableCollection(this.invalidLoadRequests);
    }

    public Collection getMultipleSandboxLoads(IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        Set set = this.getAffectedConfigurations();
        Map map = this.getConfigurationSandboxes(set, (IProgressMonitor)subMonitor.newChild(10));
        return this.validateMultipleCopyFileAreas(map, true, (IProgressMonitor)subMonitor.newChild(90));
    }

    public void evaluateLoadRequests(IProgressMonitor iProgressMonitor) throws FileSystemClientException, TeamRepositoryException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)(100 * this.requestsByCFA.size()));
        this.treesToLoad = new HashMap();
        this.sharesToRemove = new HashSet();
        this.invalidLoadLocations = new HashMap();
        this.collisions = new HashMap();
        this.newItems = new HashMap();
        this.loadOverLaps = new ArrayList();
        this.invalidLoadRequests = new ArrayList();
        this.sharesOutOfSync = new ArrayList();
        HashMap hashMap = new HashMap();
        HashSet hashSet = new HashSet();
        hashSet.addAll(SharingManager.getInstance().getRegisteredSandboxes());
        for (Map.Entry entry : this.requestsByCFA.entrySet()) {
            if (!this.validateCopyFileAreas((ISandbox)entry.getKey(), (HashMap)entry.getValue(), hashSet)) continue;
            this.getElementsToLoad((ISandbox)entry.getKey(), (HashMap)entry.getValue(), hashMap, (IProgressMonitor)subMonitor.newChild(90));
        }
        if (iProgressMonitor.isCanceled()) {
            throw (Throwable)new OperationCanceledException();
        }
        if (!hashMap.isEmpty()) {
            Map.Entry entry;
            entry = new LoadOperation$1(this);
            VerifySharesOperation verifySharesOperation = new VerifySharesOperation((OutOfSyncDilemmaHandler)((Object)entry));
            for (Map.Entry entry2 : hashMap.entrySet()) {
                verifySharesOperation.addToVerify((IConnection)entry2.getValue(), (IShare)entry2.getKey());
            }
            verifySharesOperation.run((IProgressMonitor)subMonitor.newChild(10));
        }
        subMonitor.done();
    }

    private Collection validateMultipleCopyFileAreas(Map map, boolean bl, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        Object object2;
        HashMap hashMap = new HashMap();
        HashMap hashMap2 = new HashMap();
        this.recordSandbox(this.treesToLoad.values(), hashMap, hashMap2);
        if (bl) {
            for (Object object2 : this.collisions.values()) {
                this.recordSandbox(object2.getLocations(), hashMap, hashMap2);
            }
        }
        object2 = new ArrayList();
        for (Map.Entry entry : hashMap.entrySet()) {
            ConfigurationDescriptor configurationDescriptor = (ConfigurationDescriptor)entry.getKey();
            Set set = (Set)map.get(configurationDescriptor);
            Set set2 = (Set)entry.getValue();
            if (set != null) {
                set2.addAll(set);
            }
            if (set2.size() <= 1) continue;
            MultipleSandboxLoad multipleSandboxLoad = new MultipleSandboxLoad(configurationDescriptor, set2, (Set)hashMap2.get(configurationDescriptor));
            object2.add(multipleSandboxLoad);
        }
        return (Collection)object2;
    }

    private void recordSandbox(Collection collection, Map map, Map map2) {
        for (ILoadLocation iLoadLocation : collection) {
            ConfigurationDescriptor configurationDescriptor = new ConfigurationDescriptor(iLoadLocation.getConnection(), (IComponentHandle)iLoadLocation.getComponent());
            HashSet<ISandbox> hashSet = (HashSet<ISandbox>)map.get(configurationDescriptor);
            if (hashSet == null) {
                hashSet = new HashSet<ISandbox>();
                map.put(configurationDescriptor, hashSet);
            }
            hashSet.add(iLoadLocation.getSandbox());
            HashSet<ILoadLocation> hashSet2 = (HashSet<ILoadLocation>)map2.get(configurationDescriptor);
            if (hashSet2 == null) {
                hashSet2 = new HashSet<ILoadLocation>();
                map2.put(configurationDescriptor, hashSet2);
            }
            hashSet2.add(iLoadLocation);
        }
    }

    private boolean validateCopyFileAreas(ISandbox iSandbox, HashMap hashMap, HashSet hashSet) {
        boolean bl = true;
        if (!hashSet.contains(iSandbox)) {
            HashSet<ISandbox> hashSet2 = new HashSet<ISandbox>();
            for (Object object : hashSet) {
                if (!iSandbox.getRoot().isPrefixOf(object.getRoot()) && !object.getRoot().isPrefixOf(iSandbox.getRoot())) continue;
                hashSet2.add((ISandbox)object);
            }
            for (Object object : this.requestsByCFA.keySet()) {
                if (iSandbox.equals(object) || !iSandbox.getRoot().isPrefixOf(object.getRoot()) && !object.getRoot().isPrefixOf(iSandbox.getRoot())) continue;
                hashSet2.add((ISandbox)object);
            }
            if (!hashSet2.isEmpty()) {
                bl = false;
                for (Object object : hashMap.values()) {
                    for (Set set : ((HashMap)object).values()) {
                        for (ILoadRequest iLoadRequest : set) {
                            InvalidLoadLocation invalidLoadLocation = new InvalidLoadLocation(iLoadRequest);
                            invalidLoadLocation.addCopyFileAreaPaths(hashSet2);
                            this.invalidLoadLocations.put(iLoadRequest, invalidLoadLocation);
                        }
                    }
                }
            }
        }
        return bl;
    }

    public void removeLoadRequests(Collection collection) {
        if (collection == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        for (ILoadRequest iLoadRequest : collection) {
            Set set;
            HashMap hashMap = (HashMap)this.requestsByCFA.get(iLoadRequest.getSandbox());
            if (hashMap == null) continue;
            ConfigurationDescriptor configurationDescriptor = new ConfigurationDescriptor(iLoadRequest.getConnection(), iLoadRequest.getComponent());
            HashMap hashMap2 = (HashMap)hashMap.get(iLoadRequest.getConnection());
            if (hashMap2 == null || (set = (Set)hashMap2.get(configurationDescriptor)) == null) continue;
            set.remove(iLoadRequest);
            if (!set.isEmpty()) continue;
            hashMap2.remove(configurationDescriptor);
            if (!hashMap2.isEmpty()) continue;
            hashMap.remove(iLoadRequest.getConnection());
            if (!hashMap.isEmpty()) continue;
            this.requestsByCFA.remove(iLoadRequest.getSandbox());
        }
    }

    public Collection getInvalidLoadLocations() {
        return Collections.unmodifiableCollection(this.invalidLoadLocations.values());
    }

    public Collection getSharesToBeRemoved() {
        return Collections.unmodifiableCollection(this.sharesToRemove);
    }

    public Collection getCollisions() {
        return Collections.unmodifiableCollection(this.collisions.values());
    }

    public Collection getNewSharesToLoad() {
        return Collections.unmodifiableCollection(this.newItems.values());
    }

    public Collection getSharesOutOfSync() {
        return Collections.unmodifiableCollection(this.sharesOutOfSync);
    }

    public void setSychronizationInfo(ISynchronizationInfo iSynchronizationInfo) {
        this.synchronizationInfo = iSynchronizationInfo;
    }

    public void setDownloadListener(IDownloadListener iDownloadListener) {
        this.downloadMonitor = iDownloadListener;
    }

    protected final void execute(IProgressMonitor iProgressMonitor) throws FileSystemClientException, TeamRepositoryException {
        Set set = this.getAffectedConfigurations();
        LoadOperation$2 loadOperation$2 = new LoadOperation$2(this, set);
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        FlowNodeLock flowNodeLock = WorkspaceLockUtil.acquireRead(set, (IProgressMonitor)subMonitor.newChild(1));
        try {
            this.runWithinFileSystemLock(loadOperation$2, Messages.LoadOperation_18, (IProgressMonitor)subMonitor.newChild(99));
        }
        finally {
            WorkspaceLockUtil.release(flowNodeLock);
        }
        subMonitor.done();
    }

    protected Map getConfigurationSandboxes(Set set, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)set.size());
        HashMap hashMap = new HashMap();
        for (ConfigurationDescriptor configurationDescriptor : set) {
            Collection collection = SharingManager.getInstance().getSandboxes(configurationDescriptor, (IProgressMonitor)subMonitor.newChild(1));
            hashMap.put(configurationDescriptor, new HashSet(collection));
        }
        return hashMap;
    }

    private List cfaLockRequests() {
        ICopyFileAreaManager$ICopyFileAreaLockRequestFactory iCopyFileAreaManager$ICopyFileAreaLockRequestFactory = ICopyFileAreaManager.instance.lockRequestFactory();
        ArrayList<ICopyFileAreaLockRequest> arrayList = new ArrayList<ICopyFileAreaLockRequest>();
        for (Map.Entry entry : this.requestsByCFA.entrySet()) {
            HashSet hashSet = new HashSet();
            IPath iPath = ((ISandbox)entry.getKey()).getRoot();
            for (HashMap hashMap : ((HashMap)entry.getValue()).values()) {
                hashSet.addAll(hashMap.keySet());
            }
            arrayList.add(iCopyFileAreaManager$ICopyFileAreaLockRequestFactory.getLockRequest(iPath, hashSet, true));
        }
        return arrayList;
    }

    protected final Set getAffectedConfigurations() {
        HashSet hashSet = new HashSet();
        for (HashMap hashMap : this.requestsByCFA.values()) {
            for (HashMap hashMap2 : hashMap.values()) {
                hashSet.addAll(hashMap2.keySet());
            }
        }
        return hashSet;
    }

    protected void notifyDilemmaHandler(Map map, IProgressMonitor iProgressMonitor) throws TeamRepositoryException, FileSystemClientException {
        int n;
        int n2;
        Collection collection;
        Object object3;
        int n3;
        Object object22;
        int n4;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)(100 + this.requestsByCFA.size()));
        if (subMonitor.isCanceled()) {
            throw (Throwable)new OperationCanceledException();
        }
        if (!this.loadOverLaps.isEmpty()) {
            n4 = this.dilemmaHandler.overlappingLoadRequests(Collections.unmodifiableCollection(this.loadOverLaps));
            if (n4 == 1) {
                throw (Throwable)new OperationCanceledException();
            }
            if (n4 != 0) {
                object22 = new IStatus[this.loadOverLaps.size()];
                n3 = 0;
                for (Object object3 : this.loadOverLaps) {
                    Object object4 = "";
                    if (!object3.getOverlappingShares().isEmpty()) {
                        object4 = NLS.bind((String)Messages.LoadOperation_1, (Object)PathUtils.getString(object3.getPath()), (Object)object3.getOverlappingShares().size());
                    }
                    if (!object3.getOverlappingItems().isEmpty()) {
                        object4 = NLS.bind((String)Messages.LoadOperation_2, (Object)PathUtils.getString(object3.getPath()), (Object)object3.getOverlappingItems().size());
                    }
                    object22[n3] = new FileSystemStatus(4, (String)object4);
                    ++n3;
                }
                object3 = new MultiStatus("com.ibm.team.filesystem.client", 2, (IStatus[])object22, Messages.LoadOperation_3, null);
                this.handleErrors(new IStatus[]{object3});
            }
        }
        if (subMonitor.isCanceled()) {
            throw (Throwable)new OperationCanceledException();
        }
        if (!this.newItems.isEmpty()) {
            n4 = this.dilemmaHandler.newItemsToLoad(Collections.unmodifiableCollection(this.newItems.values()));
            if (n4 == 0) {
                for (Object object22 : this.newItems.values()) {
                    if (object22.willLoad()) continue;
                    this.treesToLoad.remove(((LoadLocation)object22.getLoadLocation()).getFullPath());
                }
            } else {
                if (n4 == 1) {
                    throw (Throwable)new OperationCanceledException();
                }
                object22 = new IStatus[this.newItems.size()];
                n3 = 0;
                for (Object object3 : this.newItems.values()) {
                    object22[n3] = new FileSystemStatus(2, object3.getShareable().getLocalPath() + Messages.LoadOperation_4);
                    ++n3;
                }
                object3 = new MultiStatus("com.ibm.team.filesystem.client", 2, (IStatus[])object22, Messages.LoadOperation_5, null);
                this.handleErrors(new IStatus[]{object3});
            }
        }
        if (subMonitor.isCanceled()) {
            throw (Throwable)new OperationCanceledException();
        }
        if (this.invalidLoadLocations.size() > 0 && (n4 = this.dilemmaHandler.invalidLoadLocations(this.getInvalidLoadLocations())) != 0) {
            if (n4 == 1) {
                throw (Throwable)new OperationCanceledException();
            }
            object22 = new IStatus[this.invalidLoadLocations.size()];
            int n5 = 0;
            for (Object object3 : this.invalidLoadLocations.values()) {
                object22[n5] = ((InvalidLoadLocation)object3).getStatus();
                ++n5;
            }
            object3 = new MultiStatus("com.ibm.team.filesystem.client", 4, (IStatus[])object22, NLS.bind((String)Messages.LoadOperation_15, (Object)this.invalidLoadLocations.size()), null);
            this.handleErrors(new IStatus[]{object3});
        }
        if (this.collisions.size() > 0 || this.sharesToRemove.size() > 0) {
            n4 = this.dilemmaHandler.collision(Collections.unmodifiableCollection(this.collisions.values()), Collections.unmodifiableCollection(this.sharesToRemove), Collections.unmodifiableCollection(this.sharesOutOfSync));
            if (n4 == 0) {
                object22 = this.collisions.values().toArray(new ICollision[this.collisions.size()]);
                int n6 = 0;
                while (n6 < ((Object)object22).length) {
                    object3 = (LoadLocation)object22[n6].getLoadLocation();
                    if (object3 != null) {
                        this.treesToLoad.put(((LoadLocation)object3).getFullPath(), object3);
                    }
                    ++n6;
                }
            } else if (n4 != 1) {
                object22 = new IStatus[this.collisions.size() + this.sharesToRemove.size()];
                int n7 = 0;
                object3 = this.collisions.values().iterator();
                while (object3.hasNext()) {
                    object22[n7] = ((ICollision)object3.next()).getStatus();
                    ++n7;
                }
                for (Object object3 : this.sharesToRemove) {
                    object22[n7] = new FileSystemStatus(2, NLS.bind((String)Messages.LoadOperation_0, (Object)object3.getLocalPath()));
                    ++n7;
                }
                object3 = new MultiStatus("com.ibm.team.filesystem.client", 2, (IStatus[])object22, Messages.LoadOperation_7, null);
                this.handleErrors(new IStatus[]{object3});
            } else {
                throw (Throwable)new OperationCanceledException();
            }
        }
        if ((collection = this.validateMultipleCopyFileAreas(map, false, (IProgressMonitor)subMonitor.newChild(10))).size() > 0 && (n2 = this.dilemmaHandler.multipleSandboxLoad(collection)) != 0) {
            if (n2 == 1) {
                throw (Throwable)new OperationCanceledException();
            }
            IStatus iStatus = FileSystemStatus.getStatusFor(4, Messages.LoadOperation_19, null);
            this.handleErrors(new IStatus[]{iStatus});
        }
        if (subMonitor.isCanceled()) {
            throw (Throwable)new OperationCanceledException();
        }
        if (this.invalidLoadRequests.size() > 0 && (n = this.dilemmaHandler.invalidLoadRequest(Collections.unmodifiableCollection(this.invalidLoadRequests))) != 0) {
            Object object52;
            if (n == 1) {
                throw (Throwable)new OperationCanceledException();
            }
            IStatus[] iStatusArray = new IStatus[this.invalidLoadRequests.size()];
            int n8 = 0;
            for (Object object52 : this.invalidLoadRequests) {
                iStatusArray[n8] = ((InvalidLoadRequest)object52).getStatus();
                ++n8;
            }
            object52 = new MultiStatus("com.ibm.team.filesystem.client", 4, iStatusArray, NLS.bind((String)Messages.LoadOperation_15, (Object)this.invalidLoadRequests.size()), null);
            this.handleErrors(new IStatus[]{object52});
        }
        subMonitor.done();
    }

    protected boolean maintainShareInfo() {
        return true;
    }

    private void removeShares(IProgressMonitor iProgressMonitor) throws FileSystemClientException, TeamRepositoryException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)this.sharesToRemove.size());
        Shed shed = new Shed(this.dilemmaHandler.getBackupDilemmaHandler());
        for (IRemovedShare iRemovedShare : this.sharesToRemove) {
            IShare iShare = iRemovedShare.getShare();
            subMonitor.setTaskName(NLS.bind((String)Messages.LoadOperation_8, (Object)iShare.getPath().toString()));
            if (iRemovedShare.isToBeDeleted()) {
                MergeLoadMutator.deleteShare(iShare, shed, (IProgressMonitor)subMonitor.newChild(1));
            } else {
                ResourceType resourceType = ResourceType.FOLDER;
                ISharingDescriptor iSharingDescriptor = iShare.getSharingDescriptor();
                if (iSharingDescriptor != null) {
                    resourceType = ResourceType.getResourceType(iSharingDescriptor.getRootVersionable());
                }
                Shareable shareable = (Shareable)iShare.getSandbox().findShareable(iShare.getPath(), resourceType);
                shareable.unshare((IProgressMonitor)subMonitor.newChild(1));
            }
            this.copyFileAreasAffected.add(iShare.getSandbox());
            if (!subMonitor.isCanceled()) continue;
            throw (Throwable)new OperationCanceledException();
        }
        subMonitor.done();
    }

    protected void load(IDownloadListener iDownloadListener, IProgressMonitor iProgressMonitor) throws TeamRepositoryException, FileSystemClientException {
        Object object;
        Cloneable cloneable;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)(this.treesToLoad.size() * 3));
        subMonitor.setTaskName(Messages.LoadOperation_9);
        subMonitor.beginTask(Messages.LoadOperation_10, this.treesToLoad.size() * 3);
        int n = 0;
        HashMap hashMap = new HashMap();
        for (LoadLocation loadLocation : this.treesToLoad.values()) {
            HashMap hashMap2 = (HashMap)hashMap.get(loadLocation.getSandbox());
            if (hashMap2 == null) {
                hashMap2 = new HashMap();
                hashMap.put(loadLocation.getSandbox(), hashMap2);
            }
            if ((cloneable = (ArrayList)hashMap2.get(object = new ConfigurationDescriptor(loadLocation.getConnection(), (IComponentHandle)loadLocation.getComponent()))) == null) {
                ++n;
                cloneable = new ArrayList();
                hashMap2.put(object, cloneable);
            }
            ((ArrayList)cloneable).add(loadLocation);
        }
        int n2 = 1;
        for (Map.Entry entry : hashMap.entrySet()) {
            object = (ISandbox)entry.getKey();
            cloneable = (HashMap)entry.getValue();
            for (ArrayList arrayList : ((HashMap)cloneable).values()) {
                ILoadLocation iLoadLocation2;
                LoadLocation loadLocation = (LoadLocation)arrayList.get(0);
                SubProgressMonitor subProgressMonitor = new SubProgressMonitor((IProgressMonitor)subMonitor, arrayList.size() * 2);
                IFileSystemManager iFileSystemManager = (IFileSystemManager)loadLocation.getConnection().teamRepository().getClientLibrary(IFileSystemManager.class);
                IConnection iConnection = loadLocation.getConnection();
                FileSystemServiceProxy fileSystemServiceProxy = ((FileSystemManager)iFileSystemManager).getFileSystemService();
                subProgressMonitor.setTaskName(NLS.bind((String)Messages.LoadOperation_11, (Object[])new Object[]{iConnection.getName(), loadLocation.getComponent().getName(), n2, n}));
                subMonitor.subTask(NLS.bind((String)Messages.LoadOperation_12, (Object)loadLocation.getComponent().getName()));
                IVersionableHandle[] iVersionableHandleArray = new IVersionableHandle[arrayList.size()];
                int n3 = 0;
                for (ILoadLocation iLoadLocation2 : arrayList) {
                    iVersionableHandleArray[n3] = ((LoadLocation)iLoadLocation2).getRootToLoad();
                    ++n3;
                }
                iLoadLocation2 = fileSystemServiceProxy.getFileTreeByVersionable(iConnection, (IComponentHandle)loadLocation.getComponent(), iVersionableHandleArray, -1, true, this.synchronizationInfo, (IProgressMonitor)subMonitor.newChild(arrayList.size()));
                FileSystemOperation fileSystemOperation = this.getLoadMutator(iConnection, loadLocation.getComponent(), (ISandbox)object, arrayList, (LoadTree)iLoadLocation2, this.dilemmaHandler, iDownloadListener);
                try {
                    fileSystemOperation.run((IProgressMonitor)subProgressMonitor);
                }
                finally {
                    subProgressMonitor.done();
                }
                if (subMonitor.isCanceled()) {
                    throw (Throwable)new OperationCanceledException();
                }
                ++n2;
            }
        }
        subMonitor.setTaskName(Messages.LoadOperation_13);
        subMonitor.done();
    }

    private void getElementsToLoad(ISandbox iSandbox, HashMap hashMap, HashMap hashMap2, IProgressMonitor iProgressMonitor) throws TeamRepositoryException, FileSystemClientException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        subMonitor.setTaskName(Messages.LoadOperation_14);
        HashMap hashMap3 = new HashMap();
        HashMap hashMap4 = new HashMap();
        this.organizeShares(iSandbox, hashMap3, hashMap4, (IProgressMonitor)subMonitor.newChild(1));
        HashMap hashMap5 = new HashMap();
        HashMap<Object, LoadLocation> hashMap6 = new HashMap<Object, LoadLocation>();
        subMonitor.setWorkRemaining(hashMap.size());
        for (Map.Entry entry : hashMap.entrySet()) {
            Object object;
            SubMonitor subMonitor2 = subMonitor.newChild(1);
            subMonitor2.setWorkRemaining(100);
            IConnection iConnection = (IConnection)entry.getKey();
            HashMap hashMap7 = (HashMap)entry.getValue();
            ArrayList arrayList = new ArrayList(((HashMap)entry.getValue()).size());
            HashMap hashMap8 = new HashMap();
            HashMap hashMap9 = new HashMap();
            Map map = this.fetchInfoForLoadEvaluation(iConnection, hashMap7, hashMap8, hashMap5, hashMap4, (IProgressMonitor)subMonitor2.newChild(50));
            this.buildOverlapRequestCheckExistance(iConnection, hashMap7, arrayList, hashMap8, hashMap4, hashMap9, map, (IProgressMonitor)subMonitor2.newChild(10));
            if (!arrayList.isEmpty()) {
                this.checkItemOverlaps(iConnection, arrayList, hashMap8, hashMap4, (IProgressMonitor)subMonitor2.newChild(30));
            }
            for (Map.Entry entry2 : hashMap8.entrySet()) {
                object = (ConfigurationDescriptor)entry2.getKey();
                for (Object object2 : ((HashMap)entry2.getValue()).values()) {
                    IVersionable iVersionable = (IVersionable)((HashMap)hashMap9.get(object)).get(((LoadRequest)object2).getVersionableToLoad().getItemId());
                    if (iVersionable == null) {
                        throw (Throwable)new IllegalStateException();
                    }
                    boolean bl = false;
                    String string = iVersionable.getName();
                    if (((LoadRequest)object2).getAlternativeName().length() > 0) {
                        string = ((LoadRequest)object2).getAlternativeName();
                        bl = true;
                    }
                    LoadLocation loadLocation = new LoadLocation(((LoadRequest)object2).getSandbox(), ((LoadRequest)object2).getRelativeLoadPath(), string, ((LoadRequest)object2).getConnection(), (IComponent)hashMap5.get(((LoadRequest)object2).getComponent().getItemId()), ((LoadRequest)object2).getVersionableToLoad(), bl);
                    hashMap6.put(object2, loadLocation);
                }
            }
            subMonitor2.setWorkRemaining(hashMap6.size());
            for (Map.Entry entry2 : hashMap6.entrySet()) {
                Object object2;
                object = null;
                object2 = (LoadLocation)entry2.getValue();
                for (Map.Entry entry3 : hashMap6.entrySet()) {
                    LoadLocation loadLocation = (LoadLocation)entry3.getValue();
                    if (!PathUtils.overlapsButNotEqual(((LoadLocation)object2).getLoadPath(), ((LoadLocation)object2).getSandbox().isCaseSensitive(), loadLocation.getLoadPath(), loadLocation.getSandbox().isCaseSensitive())) continue;
                    if (object == null) {
                        object = new InvalidLoadLocation((ILoadRequest)entry2.getKey());
                    }
                    ((InvalidLoadLocation)object).addOverlappingLoadRequests((ILoadRequest)entry3.getKey());
                }
                if (object == null) {
                    this.checkForCollision((LoadRequest)entry2.getKey(), (LoadLocation)object2, hashMap2, hashMap3, hashMap4, (IProgressMonitor)subMonitor2.newChild(1));
                    continue;
                }
                this.invalidLoadLocations.put((ILoadRequest)entry2.getKey(), object);
            }
        }
    }

    private void checkItemOverlaps(IConnection iConnection, ArrayList arrayList, HashMap hashMap, HashMap hashMap2, IProgressMonitor iProgressMonitor) throws TeamRepositoryException {
        FileSystemManager fileSystemManager = (FileSystemManager)FileSystemCore.getFileSystemManager(iConnection.teamRepository());
        FileSystemServiceProxy fileSystemServiceProxy = fileSystemManager.getFileSystemService();
        List list = fileSystemServiceProxy.detectOverlap(arrayList, null, iProgressMonitor);
        for (OverlapResponse overlapResponse : list) {
            Object object;
            IAncestorReport iAncestorReport22;
            ConfigurationDescriptor configurationDescriptor = new ConfigurationDescriptor(iConnection, overlapResponse.getComponent());
            HashMap hashMap3 = (HashMap)hashMap.get(configurationDescriptor);
            if (hashMap3 == null) continue;
            HashMap<UUID, IAncestorReport> hashMap4 = new HashMap<UUID, IAncestorReport>();
            for (IAncestorReport iAncestorReport22 : overlapResponse.getAncestorReports()) {
                Iterator iterator = iAncestorReport22.getNameItemPairs();
                hashMap4.put(((INameItemPair)iterator.get(iterator.size() - 1)).getItem().getItemId(), iAncestorReport22);
            }
            iAncestorReport22 = new HashMap();
            for (OverlapDescription overlapDescription : overlapResponse.getOverlapDescriptions()) {
                object = overlapDescription.getElement();
                for (Object object2 : overlapDescription.getOverlappedChildren()) {
                    this.recordOverlap((HashMap)iAncestorReport22, (IVersionableHandle)object, (IVersionableHandle)object2);
                    this.recordOverlap((HashMap)iAncestorReport22, (IVersionableHandle)object2, (IVersionableHandle)object);
                }
            }
            for (Map.Entry entry : iAncestorReport22.entrySet()) {
                Object object2;
                object = (LoadRequest)hashMap3.get(entry.getKey());
                if (object == null) continue;
                hashMap3.remove(entry.getKey());
                object2 = new LoadOverlap(((LoadRequest)object).getSandbox(), iConnection, overlapResponse.getComponent(), (IAncestorReport)hashMap4.get(entry.getKey()));
                this.loadOverLaps.add(object2);
                for (IVersionableHandle iVersionableHandle : (Collection)entry.getValue()) {
                    HashMap hashMap5 = (HashMap)hashMap2.get(configurationDescriptor);
                    if (hashMap5 != null && hashMap5.get(iVersionableHandle.getItemId()) != null) {
                        ((LoadOverlap)object2).addOverlappingShare((IShare)hashMap5.get(iVersionableHandle.getItemId()));
                    }
                    ((LoadOverlap)object2).addOverlappingItem((IAncestorReport)hashMap4.get(iVersionableHandle.getItemId()));
                }
            }
        }
    }

    private void buildOverlapRequestCheckExistance(IConnection iConnection, HashMap hashMap, ArrayList arrayList, HashMap hashMap2, HashMap hashMap3, HashMap hashMap4, Map map, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)hashMap.size());
        for (Map.Entry entry : hashMap.entrySet()) {
            IVersionable iVersionable2;
            SubMonitor subMonitor2 = subMonitor.newChild(1);
            ConfigurationDescriptor configurationDescriptor = (ConfigurationDescriptor)entry.getKey();
            HashMap hashMap5 = (HashMap)hashMap2.get(configurationDescriptor);
            HashMap hashMap6 = (HashMap)hashMap3.get(configurationDescriptor);
            Map map2 = (Map)map.get(configurationDescriptor.componentHandle.getItemId());
            if (map2 == null) continue;
            HashMap<UUID, IVersionable> hashMap7 = new HashMap<UUID, IVersionable>();
            for (IVersionable iVersionable2 : map2.values()) {
                if (iVersionable2 == null) continue;
                hashMap7.put(iVersionable2.getItemId(), iVersionable2);
            }
            hashMap4.put(configurationDescriptor, hashMap7);
            iVersionable2 = FilesystemDTOFactory.eINSTANCE.createOverlapRequest();
            iVersionable2.setContext(iConnection.getContextHandle());
            iVersionable2.setComponent(configurationDescriptor.componentHandle);
            int n = 0;
            subMonitor2.setWorkRemaining(map2.size());
            for (Map.Entry entry2 : map2.entrySet()) {
                Object object;
                Object object2;
                Object object3;
                UUID uUID = (UUID)entry2.getKey();
                if (entry2.getValue() == null) {
                    object3 = (LoadRequest)hashMap5.get(uUID);
                    if (object3 != null) {
                        hashMap5.remove(uUID);
                        if (((LoadRequest)object3).isReloadRequest()) {
                            object2 = (IShare)hashMap6.get(uUID);
                            this.sharesToRemove.add(new RemovedShare((IShare)object2, (IProgressMonitor)subMonitor2.newChild(1)));
                        } else {
                            object2 = new FileSystemStatus(2, Messages.LoadOperation_16);
                            object = new InvalidLoadRequest((ILoadRequest)object3, IInvalidLoadRequest$InvalidLoadRequestReason.NonExistantFolder, (IStatus)object2);
                            this.invalidLoadRequests.add(object);
                        }
                    } else {
                        object2 = (IShare)hashMap6.get(uUID);
                        this.sharesToRemove.add(new RemovedShare((IShare)object2, (IProgressMonitor)subMonitor2.newChild(1)));
                    }
                } else {
                    object3 = (IVersionable)entry2.getValue();
                    object2 = (LoadRequest)hashMap5.get(uUID);
                    if (object2 == null) {
                        iVersionable2.getGroup().add(object3);
                    } else {
                        object = ((LoadRequest)object2).getAlternativeName().length() == 0 ? object3.getName() : ((LoadRequest)object2).getAlternativeName();
                        Path path = new Path((String)object);
                        if (path.segmentCount() != 1) {
                            hashMap5.remove(uUID);
                            FileSystemStatus fileSystemStatus = new FileSystemStatus(4, NLS.bind((String)Messages.LoadOperation_17, (Object)object));
                            InvalidLoadRequest invalidLoadRequest = new InvalidLoadRequest((ILoadRequest)object2, IInvalidLoadRequest$InvalidLoadRequestReason.InvalidProjectName, fileSystemStatus);
                            this.invalidLoadRequests.add(invalidLoadRequest);
                        } else {
                            iVersionable2.getGroup().add(object3);
                        }
                    }
                }
                ++n;
            }
            if (iVersionable2.getGroup().size() <= 1) continue;
            arrayList.add(iVersionable2);
        }
    }

    private Map fetchInfoForLoadEvaluation(IConnection iConnection, HashMap hashMap, HashMap hashMap2, HashMap hashMap3, HashMap hashMap4, IProgressMonitor iProgressMonitor) throws TeamRepositoryException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        ArrayList<IComponentHandle> arrayList = new ArrayList<IComponentHandle>();
        ArrayList<IComponentHandle> arrayList2 = new ArrayList<IComponentHandle>();
        ArrayList arrayList3 = new ArrayList();
        for (Map.Entry object2 : hashMap.entrySet()) {
            Object object3;
            ConfigurationDescriptor configurationDescriptor = (ConfigurationDescriptor)object2.getKey();
            arrayList2.add(configurationDescriptor.componentHandle);
            ArrayList<IVersionableHandle> arrayList4 = new ArrayList<IVersionableHandle>();
            arrayList3.add(arrayList4);
            HashMap<UUID, Object> hashMap5 = new HashMap<UUID, Object>();
            hashMap2.put(configurationDescriptor, hashMap5);
            for (Object object3 : (Set)object2.getValue()) {
                if (!hashMap3.containsKey(((LoadRequest)object3).getComponent().getItemId())) {
                    arrayList.add(((LoadRequest)object3).getComponent());
                }
                arrayList4.add(((LoadRequest)object3).getVersionableToLoad());
                hashMap5.put(((LoadRequest)object3).getVersionableToLoad().getItemId(), object3);
            }
            object3 = (HashMap)hashMap4.get(configurationDescriptor);
            if (object3 == null) continue;
            for (Object object4 : ((HashMap)object3).values()) {
                ISharingDescriptor iSharingDescriptor = object4.getSharingDescriptor();
                LoadRequest loadRequest = (LoadRequest)hashMap5.get(iSharingDescriptor.getRootVersionable().getItemId());
                if (loadRequest != null) {
                    loadRequest.setReloadRequest(true);
                    continue;
                }
                arrayList4.add(iSharingDescriptor.getRootVersionable());
            }
        }
        if (!arrayList.isEmpty()) {
            List list = iConnection.teamRepository().itemManager().fetchCompleteItems((List)arrayList, 0, (IProgressMonitor)subMonitor.newChild(20));
            for (IComponent iComponent : list) {
                hashMap3.put(iComponent.getItemId(), iComponent);
            }
        }
        return this.fetchCompleteItems(iConnection, arrayList2, arrayList3, subMonitor.newChild(80));
    }

    private Map fetchCompleteItems(IConnection iConnection, ArrayList arrayList, ArrayList arrayList2, SubMonitor subMonitor) throws TeamRepositoryException {
        HashMap<UUID, HashMap<UUID, IFolder>> hashMap;
        if (iConnection instanceof IWorkspaceConnection) {
            hashMap = ((IWorkspaceConnection)iConnection).configuration().fetchCompleteItems((List)arrayList, (List)arrayList2, (IProgressMonitor)subMonitor.newChild(10));
        } else {
            IConfiguration iConfiguration = ((IBaselineConnection)iConnection).configuration();
            if (arrayList.size() != 1) {
                throw (Throwable)new IllegalStateException("There should be just 1 component in a baseline connection");
            }
            List list = (List)arrayList2.get(0);
            List list2 = iConfiguration.fetchCompleteItems(list, (IProgressMonitor)subMonitor.newChild(10));
            Iterator iterator = list2.iterator();
            HashMap<UUID, IFolder> hashMap2 = new HashMap<UUID, IFolder>();
            hashMap = new HashMap<UUID, HashMap<UUID, IFolder>>(1);
            hashMap.put(iConfiguration.component().getItemId(), hashMap2);
            for (IVersionableHandle iVersionableHandle : list) {
                IFolder iFolder = (IFolder)iterator.next();
                hashMap2.put(iVersionableHandle.getItemId(), iFolder);
            }
        }
        return hashMap;
    }

    private void recordOverlap(HashMap hashMap, IVersionableHandle iVersionableHandle, IVersionableHandle iVersionableHandle2) {
        ArrayList<IVersionableHandle> arrayList = (ArrayList<IVersionableHandle>)hashMap.get(iVersionableHandle.getItemId());
        if (arrayList == null) {
            arrayList = new ArrayList<IVersionableHandle>();
            hashMap.put(iVersionableHandle.getItemId(), arrayList);
        }
        arrayList.add(iVersionableHandle2);
    }

    private void organizeShares(ISandbox iSandbox, HashMap hashMap, HashMap hashMap2, IProgressMonitor iProgressMonitor) throws TeamRepositoryException, FileSystemClientException {
        ICopyFileAreaManager iCopyFileAreaManager = ICopyFileAreaManager.instance;
        if (iCopyFileAreaManager.copyFileAreaExists(iSandbox.getRoot(), 1)) {
            IShare[] iShareArray = iSandbox.allShares(iProgressMonitor);
            int n = iShareArray.length;
            int n2 = 0;
            while (n2 < n) {
                ISharingDescriptor iSharingDescriptor;
                IShare iShare = iShareArray[n2];
                if (iShare.getSharingDescriptor() != null) {
                    iSharingDescriptor = iShare.getSharingDescriptor();
                    ConfigurationDescriptor configurationDescriptor = new ConfigurationDescriptor(iSharingDescriptor.getRepositoryId(), iSharingDescriptor.getRepositoryUri(), iSharingDescriptor.getConnectionHandle(), iSharingDescriptor.getComponent());
                    HashMap<UUID, IShare> hashMap3 = (HashMap<UUID, IShare>)hashMap2.get(configurationDescriptor);
                    if (hashMap3 == null) {
                        hashMap3 = new HashMap<UUID, IShare>();
                        hashMap2.put(configurationDescriptor, hashMap3);
                    }
                    hashMap3.put(iSharingDescriptor.getRootVersionable().getItemId(), iShare);
                }
                iSharingDescriptor = LoadRequest.getPath(iSandbox.getRoot().append(iShare.getPath()));
                hashMap.put(iSharingDescriptor, iShare);
                ++n2;
            }
        }
    }

    private void checkForCollision(LoadRequest loadRequest, LoadLocation loadLocation, HashMap hashMap, HashMap hashMap2, HashMap hashMap3, IProgressMonitor iProgressMonitor) throws TeamRepositoryException, FileSystemClientException {
        Object object;
        Object object3;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        Collision collision = null;
        InvalidLoadLocation invalidLoadLocation = null;
        ISandbox iSandbox = loadLocation.getSandbox();
        try {
            object3 = iSandbox.findShareable(loadRequest.getConnection().getContextHandle(), loadRequest.getComponent(), loadRequest.getVersionableToLoad(), (IProgressMonitor)subMonitor.newChild(10));
            if (object3 != null && !PathUtils.sameRelativePath(object3.getLocalPath(), object3.getSandbox().isCaseSensitive(), loadLocation.getLoadPath(), loadLocation.getSandbox().isCaseSensitive())) {
                IShare object22 = object3.getShare((IProgressMonitor)subMonitor.newChild(1));
                if (!object3.isShare((IProgressMonitor)subMonitor.newChild(1)) || object22.isLoadedWithAnotherName((IProgressMonitor)subMonitor.newChild(1)) || loadLocation.isLoadWithAnotherName()) {
                    if (invalidLoadLocation == null) {
                        invalidLoadLocation = new InvalidLoadLocation(loadRequest);
                    }
                    invalidLoadLocation.setPresentLoadLocation((IShareable)object3);
                }
            }
        }
        catch (FileSystemClientException fileSystemClientException) {
            this.collectStatus(fileSystemClientException.getStatus());
        }
        object3 = loadLocation.getFullPath();
        for (Map.Entry entry : hashMap2.entrySet()) {
            object = (IPath)entry.getKey();
            if (!PathUtils.overlapsButNotEqual((IPath)object, ((IShare)entry.getValue()).getSandbox().isCaseSensitive(), (IPath)object3, loadLocation.getSandbox().isCaseSensitive())) continue;
            if (invalidLoadLocation == null) {
                invalidLoadLocation = new InvalidLoadLocation(loadRequest);
            }
            invalidLoadLocation.addOverlappingShare((IShare)entry.getValue());
        }
        if (invalidLoadLocation == null) {
            Object object2;
            IShareable iShareable = loadLocation.getSandbox().findShareable(loadLocation.getLoadPath(), ResourceType.getResourceType(loadLocation.getRootToLoad()));
            if (iShareable.exists((IProgressMonitor)subMonitor.newChild(1))) {
                object2 = iShareable.getShare((IProgressMonitor)subMonitor.newChild(1));
                collision = new Collision(iShareable, (IShare)object2, loadLocation, true);
                if (object2 != null && (object = object2.getSharingDescriptor()).getConnectionHandle().sameItemId((IItemHandle)loadLocation.getConnection().getContextHandle()) && object.getComponent().sameItemId((IItemHandle)loadLocation.getComponent()) && object.getRootVersionable().sameItemId((IItemHandle)collision.getShareable().getVersionable((IProgressMonitor)subMonitor.newChild(1)))) {
                    hashMap.put(object2, loadLocation.getConnection());
                }
            }
            if (this.collisions.containsKey(loadLocation.getFullPath())) {
                object2 = (ICollision)this.collisions.get(loadLocation.getFullPath());
                object2.getLocations().add(loadLocation);
            } else if (this.treesToLoad.containsKey(loadLocation.getFullPath())) {
                object2 = iShareable.getShare((IProgressMonitor)subMonitor.newChild(1));
                object = new Collision(iShareable, (IShare)object2, loadLocation, false);
                ILoadLocation iLoadLocation = (ILoadLocation)this.treesToLoad.remove(loadLocation.getFullPath());
                this.newItems.remove(loadLocation.getFullPath());
                ((Collision)object).getLocations().add(iLoadLocation);
                this.collisions.put(loadLocation.getFullPath(), object);
            } else if (collision != null) {
                this.collisions.put(loadLocation.getFullPath(), collision);
            } else {
                this.treesToLoad.put(loadLocation.getFullPath(), loadLocation);
                this.newItems.put(loadLocation.getFullPath(), new ShareableToLoad(iShareable, loadLocation));
            }
        } else {
            this.invalidLoadLocations.put(loadRequest, invalidLoadLocation);
        }
    }

    private FileSystemOperation getLoadMutator(IConnection iConnection, IComponent iComponent, ISandbox iSandbox, ArrayList arrayList, LoadTree loadTree, LoadDilemmaHandler loadDilemmaHandler, IDownloadListener iDownloadListener) throws TeamRepositoryException {
        return SharingManager.getInstance().getLoadMutator(this.options, iConnection, iComponent, iSandbox, arrayList, loadTree, loadDilemmaHandler, iDownloadListener);
    }

    public int getEclipseSpecificLoadOptions() {
        return this.options;
    }

    public void setEclipseSpecificLoadOptions(int n) {
        if ((n & 3) == 3) {
            throw (Throwable)new IllegalArgumentException("Only one of CREATE_PROJECTS_FOR_NEW_SHARE_ROOTS or IMPORT_PROJECTS can be specified");
        }
        if (n > 7) {
            throw (Throwable)new IllegalArgumentException("Invalid option " + n);
        }
        this.options = n;
    }

    static /* synthetic */ ArrayList access$0(LoadOperation loadOperation) {
        return loadOperation.sharesOutOfSync;
    }

    static /* synthetic */ List access$1(LoadOperation loadOperation) {
        return loadOperation.cfaLockRequests();
    }

    static /* synthetic */ HashSet access$2(LoadOperation loadOperation) {
        return loadOperation.copyFileAreasAffected;
    }

    static /* synthetic */ HashMap access$3(LoadOperation loadOperation) {
        return loadOperation.requestsByCFA;
    }

    static /* synthetic */ void access$4(LoadOperation loadOperation, IProgressMonitor iProgressMonitor) throws FileSystemClientException, TeamRepositoryException {
        loadOperation.removeShares(iProgressMonitor);
    }

    static /* synthetic */ IDownloadListener access$5(LoadOperation loadOperation) {
        return loadOperation.downloadMonitor;
    }
}

