/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.operations;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.Trace;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeManager;
import com.ibm.team.filesystem.client.internal.utils.IRunnableWithProgress;
import com.ibm.team.filesystem.client.operations.DilemmaHandler;
import com.ibm.team.filesystem.client.operations.IFileSystemOperation;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.osgi.util.NLS;

public abstract class FileSystemOperation
implements IFileSystemOperation {
    private List errors = new ArrayList();
    private DilemmaHandler dilemmaHandler;
    private boolean verifyInSync;
    private long startTime = 0L;

    protected FileSystemOperation(DilemmaHandler dilemmaHandler) {
        this.dilemmaHandler = dilemmaHandler;
        this.verifyInSync = true;
    }

    public final void run(IProgressMonitor iProgressMonitor) throws FileSystemClientException, TeamRepositoryException {
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        this.startOperation();
        Object object = ICopyFileAreaManager.instance.beginAvoidNotify();
        LocalChangeManager localChangeManager = LocalChangeManager.getInstance();
        localChangeManager.beginAvoidNotify();
        try {
            try {
                this.execute((IProgressMonitor)subMonitor.newChild(99));
            }
            catch (TeamRepositoryException teamRepositoryException) {
                if (teamRepositoryException.getCause() instanceof CoreException && !(teamRepositoryException.getCause() instanceof FileSystemClientException)) {
                    MultiStatus multiStatus = new MultiStatus("com.ibm.team.filesystem.client", 0, teamRepositoryException.getLocalizedMessage(), (Throwable)teamRepositoryException);
                    multiStatus.add(((CoreException)teamRepositoryException.getCause()).getStatus());
                    throw (Throwable)((Object)new FileSystemClientException((IStatus)multiStatus));
                }
                throw (Throwable)teamRepositoryException;
            }
        }
        finally {
            try {
                ICopyFileAreaManager.instance.endAvoidNotify(object, (IProgressMonitor)subMonitor.newChild(1));
                localChangeManager.endAvoidNotify();
                if (Trace.LOG_ELAPSED_TIME) {
                    Trace.endTrace(this.startTime, this.getTraceMessage());
                }
            }
            finally {
                this.endOperation();
            }
        }
        this.handleErrors(this.errors.toArray(new IStatus[this.errors.size()]));
    }

    protected String getTraceMessage() {
        return this.getClass().getName();
    }

    protected void startOperation() {
        this.startTime = Trace.LOG_ELAPSED_TIME ? Trace.startTrace() : 0L;
        this.resetErrors();
    }

    protected void endOperation() {
    }

    protected abstract void execute(IProgressMonitor var1) throws FileSystemClientException, TeamRepositoryException;

    protected final void runWithinFileSystemLock(IRunnableWithProgress iRunnableWithProgress, String string, IProgressMonitor iProgressMonitor) throws TeamRepositoryException, FileSystemClientException {
        this.runWithinFileSystemLock(iRunnableWithProgress, string, null, iProgressMonitor);
    }

    protected final void runWithinFileSystemLock(IRunnableWithProgress iRunnableWithProgress, String string, ISchedulingRule iSchedulingRule, IProgressMonitor iProgressMonitor) throws TeamRepositoryException, FileSystemClientException {
        try {
            SharingManager.getInstance().runWithinFileSystemLock(iRunnableWithProgress, iSchedulingRule, iProgressMonitor);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            if (throwable instanceof TeamRepositoryException) {
                throw throwable;
            }
            if (throwable instanceof FileSystemClientException) {
                throw throwable;
            }
            throw (Throwable)new TeamRepositoryException(NLS.bind((String)Messages.FileSystemOperation_1, (Object)string), throwable);
        }
        catch (InterruptedException interruptedException) {
            throw (Throwable)new OperationCanceledException();
        }
    }

    protected void collectStatus(IStatus iStatus) {
        if (iStatus.isOK()) {
            return;
        }
        if (this.isLastError(iStatus)) {
            return;
        }
        this.errors.add(iStatus);
    }

    protected void resetErrors() {
        this.errors.clear();
    }

    protected IStatus[] getErrors() {
        return this.errors.toArray(new IStatus[this.errors.size()]);
    }

    protected IStatus getLastError() {
        Assert.isTrue((this.errors.size() > 0 ? 1 : 0) != 0);
        IStatus iStatus = (IStatus)this.errors.get(this.errors.size() - 1);
        return iStatus;
    }

    private boolean isLastError(IStatus iStatus) {
        return this.errors.size() > 0 && this.getLastError() == iStatus;
    }

    protected void reportErrorsAsException(IStatus[] iStatusArray) throws FileSystemClientException {
        if (iStatusArray.length == 0) {
            return;
        }
        if (iStatusArray.length == 1) {
            throw (Throwable)((Object)new FileSystemClientException(iStatusArray[0]));
        }
        MultiStatus multiStatus = new MultiStatus("com.ibm.team.filesystem.client", 0, this.getErrorMessage(iStatusArray), null);
        int n = 0;
        while (n < iStatusArray.length) {
            IStatus iStatus = iStatusArray[n];
            multiStatus.add(iStatus);
            ++n;
        }
        throw (Throwable)((Object)new FileSystemClientException((IStatus)multiStatus));
    }

    protected final void handleErrors(IStatus[] iStatusArray) throws FileSystemClientException {
        ArrayList<IStatus> arrayList = new ArrayList<IStatus>();
        int n = 0;
        while (n < iStatusArray.length) {
            IStatus iStatus = iStatusArray[n];
            if (this.isReportableError(iStatus)) {
                arrayList.add(iStatus);
            } else if (iStatus.isMultiStatus()) {
                IStatus[] iStatusArray2 = iStatus.getChildren();
                int n2 = 0;
                while (n2 < iStatusArray2.length) {
                    IStatus iStatus2 = iStatusArray2[n2];
                    if (this.isReportableError(iStatus2)) {
                        arrayList.add(iStatus);
                        break;
                    }
                    ++n2;
                }
            }
            ++n;
        }
        if (!arrayList.isEmpty()) {
            this.reportErrorsAsException(arrayList.toArray(new IStatus[arrayList.size()]));
        }
    }

    protected DilemmaHandler getDilemmaHandler() {
        return this.dilemmaHandler;
    }

    protected boolean isReportableError(IStatus iStatus) {
        return true;
    }

    protected String getErrorMessage(IStatus[] iStatusArray) {
        return NLS.bind((String)Messages.FileSystemOperation_0, (Object)iStatusArray.length);
    }

    protected boolean errorsOccurred() {
        for (IStatus iStatus : this.errors) {
            if (this.isReportableError(iStatus)) {
                return true;
            }
            if (!iStatus.isMultiStatus()) continue;
            IStatus[] iStatusArray = iStatus.getChildren();
            int n = 0;
            while (n < iStatusArray.length) {
                IStatus iStatus2 = iStatusArray[n];
                if (this.isReportableError(iStatus2)) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    protected void checkCancelled(IProgressMonitor iProgressMonitor) {
        if (iProgressMonitor.isCanceled()) {
            throw (Throwable)new OperationCanceledException();
        }
    }

    protected final void setVerifyInSync(boolean bl) {
        this.verifyInSync = bl;
    }

    protected final boolean verifyInSyncEnabled() {
        return this.verifyInSync;
    }

    protected final void disableVerifyInSync(IFileSystemOperation iFileSystemOperation) {
        if (iFileSystemOperation instanceof FileSystemOperation) {
            FileSystemOperation fileSystemOperation = (FileSystemOperation)iFileSystemOperation;
            fileSystemOperation.setVerifyInSync(false);
        }
    }
}

