/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.operations;

import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.load.DeferredInformation;
import com.ibm.team.filesystem.client.operations.IEncodingDownloadFailure;
import com.ibm.team.filesystem.common.FileLineDelimiter;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import org.eclipse.core.runtime.IStatus;

public class EncodingDownloadFailure
implements IEncodingDownloadFailure {
    private DeferredInformation deferredInformation;
    private IStatus status;

    public EncodingDownloadFailure(DeferredInformation deferredInformation) {
        this.deferredInformation = deferredInformation;
        this.status = null;
    }

    public String getEncoding() {
        return this.deferredInformation.getEncoding();
    }

    public IShareable getShareable() {
        return this.deferredInformation.getShareable();
    }

    public boolean hasDirection() {
        return this.deferredInformation.hasAlternateDownloadDirection();
    }

    public void setAlternativeEncoding(String string) {
        if (string == null) {
            throw (Throwable)new IllegalArgumentException("alternativeEncoding cannot be null");
        }
        if (!Charset.isSupported(string)) {
            throw (Throwable)new UnsupportedCharsetException(string);
        }
        this.deferredInformation.setAlternateEncoding(string);
    }

    public void setIgnoreEncoding(boolean bl) {
        if (bl) {
            this.deferredInformation.setAlternativeLineDelimiter(FileLineDelimiter.LINE_DELIMITER_NONE);
        } else {
            this.deferredInformation.setAlternativeLineDelimiter(null);
        }
    }

    public IStatus getStatus() {
        return this.status;
    }

    public DeferredInformation getDeferredUpdateInformation() {
        return this.deferredInformation;
    }
}

