/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.operations;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.operations.ChangeHistoryChangeSetsOperation;
import com.ibm.team.filesystem.client.internal.operations.DiscardOperation$1;
import com.ibm.team.filesystem.client.internal.operations.IFilesystemRefresher;
import com.ibm.team.filesystem.client.internal.operations.UpdateOperation;
import com.ibm.team.filesystem.client.internal.utils.ChangeSetRefreshUtils;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationDescriptor;
import com.ibm.team.filesystem.client.internal.utils.FlowNodeLock;
import com.ibm.team.filesystem.client.internal.utils.WorkspaceLockUtil;
import com.ibm.team.filesystem.client.operations.DiscardDilemmaHandler;
import com.ibm.team.filesystem.client.operations.IDiscardOperation;
import com.ibm.team.repository.client.util.ThreadCheck;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.dto.IUpdateReport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;

public class DiscardOperation
extends ChangeHistoryChangeSetsOperation
implements IDiscardOperation {
    private final Map discardRequests;
    private final DiscardDilemmaHandler problemHandler;

    public DiscardOperation(DiscardDilemmaHandler discardDilemmaHandler) {
        super(discardDilemmaHandler == null ? DiscardDilemmaHandler.getDefault() : discardDilemmaHandler);
        this.problemHandler = discardDilemmaHandler == null ? DiscardDilemmaHandler.getDefault() : discardDilemmaHandler;
        this.discardRequests = new HashMap();
    }

    public void discard(IWorkspaceConnection iWorkspaceConnection, Collection collection) {
        if (iWorkspaceConnection == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (collection == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        ArrayList arrayList = (ArrayList)this.discardRequests.get(iWorkspaceConnection);
        if (arrayList == null) {
            arrayList = new ArrayList();
            this.discardRequests.put(iWorkspaceConnection, arrayList);
        }
        arrayList.addAll(collection);
    }

    protected void execute(IProgressMonitor iProgressMonitor) throws FileSystemClientException, TeamRepositoryException {
        ThreadCheck.checkLongOpsAllowed();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (String)Messages.DiscardOperation_ProgressMessage, (int)100);
        ArrayList arrayList = new ArrayList();
        Set set = this.getAffectedConfigurations(arrayList, (IProgressMonitor)subMonitor.newChild(4));
        FlowNodeLock flowNodeLock = WorkspaceLockUtil.acquireWrite(set, (Collection)arrayList, (IProgressMonitor)subMonitor.newChild(1));
        try {
            DiscardOperation$1 discardOperation$1 = new DiscardOperation$1(this, set);
            this.runWithinFileSystemLock(discardOperation$1, Messages.DiscardOperation_0, (IProgressMonitor)subMonitor.newChild(95));
        }
        finally {
            WorkspaceLockUtil.release(flowNodeLock);
        }
    }

    private void discard(Set set, IProgressMonitor iProgressMonitor) throws FileSystemClientException, TeamRepositoryException {
        Object object;
        Object object2;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (String)Messages.DiscardOperation_ProgressMessage, (int)(3 * this.discardRequests.size() + 23));
        if (this.verifyInSyncEnabled() && !this.problemHandler.getOutOfSyncDilemmaHandler().willIgnoreAllSharesOutOfSync()) {
            object2 = subMonitor.newChild(1);
            object2.setWorkRemaining(set.size());
            object = IOperationFactory.instance.getVerifyInSyncOperation(this.problemHandler.getOutOfSyncDilemmaHandler());
            for (ConfigurationDescriptor object3 : set) {
                object.addToVerify(object3.getConnection((IProgressMonitor)object2.newChild(1)), object3.componentHandle);
            }
            object.run((IProgressMonitor)subMonitor.newChild(10));
        }
        if (subMonitor.isCanceled()) {
            throw (Throwable)new OperationCanceledException();
        }
        object2 = ICopyFileAreaManager.instance.lockRequestFactory().getLockRequest(set, true);
        object = ICopyFileAreaManager.instance.lock(Collections.singleton(object2), (IProgressMonitor)subMonitor.newChild(1));
        try {
            this.checkinPendingChanges(set, this.problemHandler, true, (IProgressMonitor)subMonitor.newChild(10));
            for (Map.Entry entry : this.discardRequests.entrySet()) {
                IWorkspaceConnection iWorkspaceConnection = (IWorkspaceConnection)entry.getKey();
                List list = (List)entry.getValue();
                iWorkspaceConnection.ensureClosed((Collection)list, (IProgressMonitor)subMonitor.newChild(list.size()));
                if (subMonitor.isCanceled()) {
                    throw (Throwable)new OperationCanceledException();
                }
                IUpdateReport iUpdateReport = iWorkspaceConnection.discardChangeSets(false, (Collection)list, (IProgressMonitor)subMonitor.newChild(list.size()));
                UpdateOperation updateOperation = new UpdateOperation(iWorkspaceConnection, Collections.singletonList(iUpdateReport), 3, this.problemHandler, null);
                this.disableVerifyInSync(updateOperation);
                updateOperation.run((IProgressMonitor)subMonitor.newChild(list.size()));
            }
        }
        finally {
            object.release((IProgressMonitor)subMonitor.newChild(1));
        }
    }

    private Set getAffectedConfigurations(Collection collection, IProgressMonitor iProgressMonitor) throws TeamRepositoryException {
        HashSet<ConfigurationDescriptor> hashSet = new HashSet<ConfigurationDescriptor>();
        for (Map.Entry entry : this.discardRequests.entrySet()) {
            IWorkspaceConnection iWorkspaceConnection = (IWorkspaceConnection)entry.getKey();
            List list = (List)entry.getValue();
            List list2 = iWorkspaceConnection.teamRepository().itemManager().fetchCompleteItems(list, 0, iProgressMonitor);
            collection.addAll(list2);
            for (IChangeSet iChangeSet : list2) {
                hashSet.add(new ConfigurationDescriptor((IConnection)iWorkspaceConnection, iChangeSet.getComponent()));
            }
        }
        return hashSet;
    }

    protected void refreshLocal(IFilesystemRefresher iFilesystemRefresher, Map map, IProgressMonitor iProgressMonitor) throws FileSystemClientException, TeamRepositoryException {
        for (Map.Entry entry : this.discardRequests.entrySet()) {
            IWorkspaceConnection iWorkspaceConnection = (IWorkspaceConnection)entry.getKey();
            List list = (List)entry.getValue();
            ChangeSetRefreshUtils.refreshLocalForRemoval(iFilesystemRefresher, map, iWorkspaceConnection, list, iProgressMonitor);
        }
    }

    static /* synthetic */ void access$0(DiscardOperation discardOperation, Set set, IProgressMonitor iProgressMonitor) throws FileSystemClientException, TeamRepositoryException {
        discardOperation.discard(set, iProgressMonitor);
    }
}

