/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.operations;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.operations.ChangeHistoryChangeSetsOperation;
import com.ibm.team.filesystem.client.internal.operations.DeliverOperation$1;
import com.ibm.team.filesystem.client.internal.operations.DeliverOperation$DeliverDescriptor;
import com.ibm.team.filesystem.client.internal.operations.DeliverOperation$DeliverOperationRequest;
import com.ibm.team.filesystem.client.internal.operations.IFilesystemRefresher;
import com.ibm.team.filesystem.client.internal.operations.OperationRequest;
import com.ibm.team.filesystem.client.internal.operations.UnlockOperation;
import com.ibm.team.filesystem.client.internal.operations.UpdateOperation;
import com.ibm.team.filesystem.client.internal.utils.ChangeSetRefreshUtils;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationDescriptor;
import com.ibm.team.filesystem.client.internal.utils.FlowNodeLock;
import com.ibm.team.filesystem.client.internal.utils.WorkspaceLockUtil;
import com.ibm.team.filesystem.client.operations.DeliverDilemmaHandler;
import com.ibm.team.filesystem.client.operations.IDeliverOperation;
import com.ibm.team.filesystem.client.operations.IVerifyInSyncOperation;
import com.ibm.team.filesystem.client.operations.LockEntry;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.DeliveryRequiresHistoryReorderingException;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IFlowNodeConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.internal.FlowUtils;
import com.ibm.team.scm.client.internal.isv.IWorkspaceOperationRunner;
import com.ibm.team.scm.common.ComponentNotInWorkspaceException;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.ItemLockedInStreamException;
import com.ibm.team.scm.common.dto.IChangeHistorySyncReport;
import com.ibm.team.scm.common.dto.IStreamLockReport;
import com.ibm.team.scm.common.dto.IUpdateReport;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.ItemLists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

public class DeliverOperation
extends ChangeHistoryChangeSetsOperation
implements IDeliverOperation {
    private DeliverDilemmaHandler problemHandler;
    public Map deliverRequests = new HashMap();
    private boolean flowComponents = true;

    public DeliverOperation(DeliverDilemmaHandler deliverDilemmaHandler) {
        super(deliverDilemmaHandler == null ? DeliverDilemmaHandler.getDefault() : deliverDilemmaHandler);
        this.problemHandler = deliverDilemmaHandler == null ? DeliverDilemmaHandler.getDefault() : deliverDilemmaHandler;
        this.deliverRequests = new HashMap();
    }

    protected void execute(IProgressMonitor iProgressMonitor) throws FileSystemClientException, TeamRepositoryException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (String)Messages.DeliverOperation_0, (int)100);
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        Set set = this.getAffectedDeliverConfigurations(this.deliverRequests.values(), arrayList, arrayList2, (IProgressMonitor)subMonitor.newChild(1));
        FlowNodeLock flowNodeLock = WorkspaceLockUtil.acquireWrite(set, (Collection)arrayList2, (Collection)arrayList, (IProgressMonitor)subMonitor.newChild(1));
        HashMap<IStreamLockReport, Object> hashMap = new HashMap<IStreamLockReport, Object>();
        HashMap<IStreamLockReport, Object> hashMap2 = new HashMap<IStreamLockReport, Object>();
        try {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object6;
            SubMonitor subMonitor2;
            this.runPreConditionsOnly(set, (IProgressMonitor)subMonitor.newChild(1));
            if (this.flowComponents) {
                subMonitor.subTask(Messages.DeliverOperation_1);
                subMonitor2 = subMonitor.newChild(10).setWorkRemaining(this.deliverRequests.size() * 4);
                for (DeliverOperation$DeliverOperationRequest deliverOperation$DeliverOperationRequest : this.deliverRequests.values()) {
                    IChangeHistorySyncReport iChangeHistorySyncReport = deliverOperation$DeliverOperationRequest.getSyncReport();
                    object6 = FlowUtils.getComponentSynchronizationOps((boolean)deliverOperation$DeliverOperationRequest.isWorkspaceContext(), (List)deliverOperation$DeliverOperationRequest.getAffectedComponents((IProgressMonitor)subMonitor2.newChild(1)), (IWorkspaceConnection)deliverOperation$DeliverOperationRequest.getWorkspace(), (IWorkspaceConnection)deliverOperation$DeliverOperationRequest.getTargetWorkspace(), (IChangeHistorySyncReport)iChangeHistorySyncReport);
                    if (object6.size() <= 0) continue;
                    ArrayList object52 = new ArrayList();
                    object4 = object6.iterator();
                    while (object4.hasNext()) {
                        object3 = (IFlowNodeConnection.IComponentOp)object4.next();
                        if (!(object3 instanceof IFlowNodeConnection.IComponentAdditionOp)) continue;
                        object52.addAll(deliverOperation$DeliverOperationRequest.getWorkspace().activeChangeSets(object3.getComponent()));
                    }
                    deliverOperation$DeliverOperationRequest.getWorkspace().closeChangeSets((Collection)object52, (IProgressMonitor)subMonitor2.newChild(1));
                    deliverOperation$DeliverOperationRequest.getTargetWorkspace().applyComponentOperations((List)object6, (IProgressMonitor)subMonitor2.newChild(1));
                    object3 = subMonitor2.newChild(1).setWorkRemaining(object6.size() * 2);
                    object2 = object6.iterator();
                    while (object2.hasNext()) {
                        object4 = (IFlowNodeConnection.IComponentOp)object2.next();
                        if (object4 instanceof IFlowNodeConnection.IComponentAdditionOp) {
                            FlowUtils.addComponentSyncState((IWorkspaceConnection)deliverOperation$DeliverOperationRequest.getWorkspace(), (IConnection)((IConnection)deliverOperation$DeliverOperationRequest.getTargetWorkspace()), (IComponentHandle)object4.getComponent(), (IProgressMonitor)((IProgressMonitor)object3.newChild(1)));
                        } else if (object4 instanceof IFlowNodeConnection.IComponentDeletionOp) {
                            FlowUtils.removeComponentSyncState((IWorkspaceConnection)deliverOperation$DeliverOperationRequest.getWorkspace(), (IConnection)((IConnection)deliverOperation$DeliverOperationRequest.getTargetWorkspace()), (IComponentHandle)object4.getComponent(), (IProgressMonitor)((IProgressMonitor)object3.newChild(1)));
                        }
                        deliverOperation$DeliverOperationRequest.clearChanges(object4.getComponent(), (IProgressMonitor)object3.newChild(1));
                    }
                }
            }
            subMonitor2 = subMonitor.newChild(88).setWorkRemaining(this.deliverRequests.size());
            subMonitor.subTask(Messages.DeliverOperation_0);
            int n = 3;
            ArrayList arrayList3 = new ArrayList(this.deliverRequests.values());
            int n2 = 0;
            while (n2 < arrayList3.size()) {
                object6 = (DeliverOperation$DeliverOperationRequest)arrayList3.get(n2);
                IChangeHistorySyncReport iChangeHistorySyncReport = ((OperationRequest)object6).getSyncReport();
                if (((OperationRequest)object6).getChangeSets().size() > 0 || ((OperationRequest)object6).getBaselines().size() > 0) {
                    object3 = ((DeliverOperation$DeliverOperationRequest)object6).getTargetWorkspace();
                    try {
                        object4 = ((OperationRequest)object6).getWorkspace();
                        object2 = ((IWorkspaceOperationRunner)object4).runDeliverWithPrecondition((IWorkspaceOperationRunner.IWorkspaceOperationRunnable)new DeliverOperation$1(this), (IWorkspaceConnection)object3, iChangeHistorySyncReport, ((OperationRequest)object6).getBaselines(), ((OperationRequest)object6).getChangeSets(), (IProgressMonitor)subMonitor2.newChild(1));
                        if (object2.size() > 0) {
                            hashMap.put(IStreamLockReport.FACTORY.createInstance((IWorkspaceHandle)object3.getResolvedWorkspace(), (Collection)object2), object3);
                        }
                    }
                    catch (ItemLockedInStreamException itemLockedInStreamException) {
                        object2 = itemLockedInStreamException.getLockReport();
                        if (object2 != null) {
                            hashMap2.put((IStreamLockReport)object2, object3);
                            if (n == 3) {
                                n = this.getProblemHandler().lockBeingHeld((IStreamLockReport)object2, (IWorkspaceConnection)object3, arrayList3.size() - n2 - 1);
                                switch (n) {
                                    case 3: {
                                        break;
                                    }
                                    case 0: {
                                        break;
                                    }
                                    case 1: {
                                        throw (Throwable)new OperationCanceledException(itemLockedInStreamException.getMessage());
                                    }
                                    case 2: {
                                        throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(itemLockedInStreamException)));
                                    }
                                    default: {
                                        break;
                                    }
                                }
                            }
                        }
                        throw (Throwable)itemLockedInStreamException;
                    }
                    catch (DeliveryRequiresHistoryReorderingException deliveryRequiresHistoryReorderingException) {
                        object2 = new SubProgressMonitor((IProgressMonitor)subMonitor2, 2);
                        object = SubMonitor.convert((IProgressMonitor)((IProgressMonitor)object2), (int)3);
                        IWorkspaceConnection iWorkspaceConnection = ((OperationRequest)object6).getWorkspace();
                        IComponentHandle iComponentHandle = deliveryRequiresHistoryReorderingException.getComponent();
                        IComponent iComponent = (IComponent)iWorkspaceConnection.teamRepository().itemManager().fetchCompleteItem((IItemHandle)iComponentHandle, 0, (IProgressMonitor)object.newChild(1));
                        int n3 = this.getProblemHandler().deliveryRequiresHistoryReordering(iWorkspaceConnection, (IWorkspaceConnection)object3, iComponent);
                        switch (n3) {
                            case 3: {
                                break;
                            }
                            case 0: {
                                IUpdateReport iUpdateReport = iWorkspaceConnection.harmonizeHistory((IWorkspaceConnection)object3, deliveryRequiresHistoryReorderingException.getComponent(), (IProgressMonitor)object.newChild(1));
                                UpdateOperation updateOperation = new UpdateOperation(iWorkspaceConnection, Collections.singletonList(iUpdateReport), 3, this.problemHandler, null);
                                this.disableVerifyInSync(updateOperation);
                                try {
                                    updateOperation.run((IProgressMonitor)object.newChild(1));
                                }
                                catch (FileSystemClientException fileSystemClientException) {
                                    this.collectStatus(FileSystemStatus.getStatusFor((Throwable)((Object)fileSystemClientException)));
                                }
                                catch (TeamRepositoryException teamRepositoryException) {
                                    this.collectStatus(FileSystemStatus.getStatusFor(teamRepositoryException));
                                }
                                break;
                            }
                            case 1: {
                                throw (Throwable)new OperationCanceledException(deliveryRequiresHistoryReorderingException.getMessage());
                            }
                            case 2: {
                                throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(deliveryRequiresHistoryReorderingException)));
                            }
                        }
                    }
                }
                ++n2;
            }
            this.getProblemHandler().locksWereHeld(hashMap2);
            Map map = this.getProblemHandler().locksToRelease(hashMap);
            if (hashMap.size() > 0) {
                object6 = new UnlockOperation(this.getProblemHandler().getLockDilemmaHandler());
                for (Map.Entry entry : map.entrySet()) {
                    object4 = LockEntry.createEntries(((IWorkspaceConnection)entry.getValue()).teamRepository(), (IStreamLockReport)entry.getKey());
                    object = object4.iterator();
                    while (object.hasNext()) {
                        object2 = (LockEntry)object.next();
                        object6.unlock(((LockEntry)object2).getWorkspaceConnection((IProgressMonitor)subMonitor.newChild(1)), ((LockEntry)object2).getComponent(), ((LockEntry)object2).getVersionable(), ((LockEntry)object2).getContributor());
                    }
                }
                object6.run((IProgressMonitor)subMonitor.newChild(1));
            }
        }
        finally {
            WorkspaceLockUtil.release(flowNodeLock);
            subMonitor.done();
        }
    }

    private void verifyNonDefaultTargets() throws FileSystemClientException {
        int n;
        ArrayList<IWorkspaceConnection> arrayList = new ArrayList<IWorkspaceConnection>(1);
        for (DeliverOperation$DeliverOperationRequest deliverOperation$DeliverOperationRequest : this.deliverRequests.values()) {
            IWorkspaceConnection iWorkspaceConnection = deliverOperation$DeliverOperationRequest.getWorkspace();
            IWorkspaceConnection iWorkspaceConnection2 = deliverOperation$DeliverOperationRequest.getTargetWorkspace();
            IWorkspaceHandle iWorkspaceHandle = FlowUtils.getDefaultFlowTarget((IWorkspaceConnection)iWorkspaceConnection);
            if (iWorkspaceHandle != null && iWorkspaceHandle.sameItemId((IItemHandle)iWorkspaceConnection2.getResolvedWorkspace())) continue;
            arrayList.add(iWorkspaceConnection2);
        }
        if (arrayList.size() > 0 && (n = this.getProblemHandler().notDefaultTarget(arrayList)) != 0) {
            if (n == 1) {
                throw (Throwable)new OperationCanceledException();
            }
            throw (Throwable)((Object)new FileSystemClientException(new FileSystemStatus(4, Messages.DeliverOperation_2)));
        }
    }

    private void verifyComponentFlowing(SubMonitor subMonitor) throws FileSystemClientException, TeamRepositoryException {
        Object object;
        Object object2;
        IComponentHandle iComponentHandle;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        ArrayList<UUID> arrayList3 = new ArrayList<UUID>();
        for (DeliverOperation$DeliverOperationRequest deliverOperation$DeliverOperationRequest : this.deliverRequests.values()) {
            if (deliverOperation$DeliverOperationRequest.isComponentContext()) continue;
            List list = FlowUtils.getComponentSynchronizationOps((boolean)deliverOperation$DeliverOperationRequest.isWorkspaceContext(), (List)deliverOperation$DeliverOperationRequest.getAffectedComponents((IProgressMonitor)subMonitor), (IWorkspaceConnection)deliverOperation$DeliverOperationRequest.getWorkspace(), (IWorkspaceConnection)deliverOperation$DeliverOperationRequest.getTargetWorkspace(), (IChangeHistorySyncReport)deliverOperation$DeliverOperationRequest.getSyncReport());
            iComponentHandle = list.iterator();
            while (iComponentHandle.hasNext()) {
                object2 = (IFlowNodeConnection.IComponentOp)iComponentHandle.next();
                object = object2.getComponent();
                arrayList3.add(object.getItemId());
                if (object2 instanceof IFlowNodeConnection.IComponentAdditionOp) {
                    arrayList.add(object);
                    continue;
                }
                if (!(object2 instanceof IFlowNodeConnection.IComponentDeletionOp)) continue;
                arrayList2.add(object);
            }
        }
        if (arrayList.size() > 0 || arrayList2.size() > 0) {
            int n = this.getProblemHandler().componentsToBeAddedOrRemoved(arrayList, arrayList2);
            if (n == 1) {
                throw (Throwable)new OperationCanceledException();
            }
            if (n == 2) {
                throw (Throwable)((Object)new FileSystemClientException(new FileSystemStatus(4, Messages.DeliverOperation_3)));
            }
            if (n == 3) {
                this.setFlowComponents(false);
                for (Object object3 : this.deliverRequests.values()) {
                    object2 = ((OperationRequest)object3).getAffectedComponents((IProgressMonitor)subMonitor);
                    object = object2.iterator();
                    while (object.hasNext()) {
                        iComponentHandle = (IComponentHandle)object.next();
                        if (!arrayList3.contains(iComponentHandle.getItemId())) continue;
                        ((OperationRequest)object3).clearChanges(iComponentHandle, (IProgressMonitor)subMonitor);
                    }
                }
            }
        }
    }

    public void deliver(IWorkspaceConnection iWorkspaceConnection, IWorkspaceConnection iWorkspaceConnection2, IChangeHistorySyncReport iChangeHistorySyncReport) {
        DeliverOperation$DeliverOperationRequest deliverOperation$DeliverOperationRequest = new DeliverOperation$DeliverOperationRequest(iWorkspaceConnection, iWorkspaceConnection2, iChangeHistorySyncReport, (List)new ArrayList(), (List)new ArrayList(), new ArrayList());
        if (iWorkspaceConnection.getResolvedWorkspace().sameItemId((IItemHandle)iWorkspaceConnection2.getResolvedWorkspace())) {
            return;
        }
        ArrayList arrayList = new ArrayList();
        try {
            arrayList.addAll(iWorkspaceConnection.getComponents());
        }
        catch (TeamRepositoryException teamRepositoryException) {}
        this.deliverRequests.put(new DeliverOperation$DeliverDescriptor(iWorkspaceConnection, iWorkspaceConnection2), deliverOperation$DeliverOperationRequest);
        for (IComponentHandle iComponentHandle : arrayList) {
            this.deliver(iWorkspaceConnection, iWorkspaceConnection2, iChangeHistorySyncReport, iComponentHandle);
        }
        deliverOperation$DeliverOperationRequest.setWorkspaceContext(true);
    }

    public void deliver(IWorkspaceConnection iWorkspaceConnection, IWorkspaceConnection iWorkspaceConnection2, IChangeHistorySyncReport iChangeHistorySyncReport, IComponentHandle iComponentHandle, boolean bl) {
        if (iWorkspaceConnection.getResolvedWorkspace().sameItemId((IItemHandle)iWorkspaceConnection2.getResolvedWorkspace())) {
            return;
        }
        DeliverOperation$DeliverDescriptor deliverOperation$DeliverDescriptor = new DeliverOperation$DeliverDescriptor(iWorkspaceConnection, iWorkspaceConnection2);
        DeliverOperation$DeliverOperationRequest deliverOperation$DeliverOperationRequest = (DeliverOperation$DeliverOperationRequest)this.deliverRequests.get(deliverOperation$DeliverDescriptor);
        if (deliverOperation$DeliverOperationRequest != null && deliverOperation$DeliverOperationRequest.isWorkspaceContext()) {
            return;
        }
        if (deliverOperation$DeliverOperationRequest == null) {
            ArrayList arrayList = new ArrayList();
            deliverOperation$DeliverOperationRequest = new DeliverOperation$DeliverOperationRequest(iWorkspaceConnection, iWorkspaceConnection2, iChangeHistorySyncReport, (List)new ArrayList(), (List)new ArrayList(), arrayList);
            deliverOperation$DeliverOperationRequest.setComponentContext(!bl);
            this.deliverRequests.put(deliverOperation$DeliverDescriptor, deliverOperation$DeliverOperationRequest);
        }
        if (!deliverOperation$DeliverOperationRequest.getComponents().contains(iComponentHandle)) {
            deliverOperation$DeliverOperationRequest.setReport(iChangeHistorySyncReport);
            deliverOperation$DeliverOperationRequest.addComponent(iComponentHandle);
            this.selectWhatToDeliver(iWorkspaceConnection, iWorkspaceConnection2, iComponentHandle, iChangeHistorySyncReport, deliverOperation$DeliverOperationRequest);
        }
    }

    public void deliver(IWorkspaceConnection iWorkspaceConnection, IWorkspaceConnection iWorkspaceConnection2, IChangeHistorySyncReport iChangeHistorySyncReport, IComponentHandle iComponentHandle) {
        this.deliver(iWorkspaceConnection, iWorkspaceConnection2, iChangeHistorySyncReport, iComponentHandle, false);
    }

    public void deliver(IWorkspaceConnection iWorkspaceConnection, IWorkspaceConnection iWorkspaceConnection2, IChangeHistorySyncReport iChangeHistorySyncReport, List list) {
        if (iWorkspaceConnection.getResolvedWorkspace().sameItemId((IItemHandle)iWorkspaceConnection2.getResolvedWorkspace())) {
            return;
        }
        DeliverOperation$DeliverDescriptor deliverOperation$DeliverDescriptor = new DeliverOperation$DeliverDescriptor(iWorkspaceConnection, iWorkspaceConnection2);
        DeliverOperation$DeliverOperationRequest deliverOperation$DeliverOperationRequest = (DeliverOperation$DeliverOperationRequest)this.deliverRequests.get(deliverOperation$DeliverDescriptor);
        if (deliverOperation$DeliverOperationRequest != null && (deliverOperation$DeliverOperationRequest.isWorkspaceContext() || deliverOperation$DeliverOperationRequest.isComponentContext())) {
            return;
        }
        if (deliverOperation$DeliverOperationRequest == null) {
            deliverOperation$DeliverOperationRequest = new DeliverOperation$DeliverOperationRequest(iWorkspaceConnection, iWorkspaceConnection2, iChangeHistorySyncReport, (List)new ArrayList(), (List)new ArrayList(), new ArrayList());
            this.deliverRequests.put(deliverOperation$DeliverDescriptor, deliverOperation$DeliverOperationRequest);
        }
        deliverOperation$DeliverOperationRequest.addChangeSet(list);
    }

    public void deliver(IWorkspaceConnection iWorkspaceConnection, IWorkspaceConnection iWorkspaceConnection2, IChangeHistorySyncReport iChangeHistorySyncReport, List list, List list2, List list3) throws TeamRepositoryException {
        if (iWorkspaceConnection.getResolvedWorkspace().sameItemId((IItemHandle)iWorkspaceConnection2.getResolvedWorkspace())) {
            return;
        }
        DeliverOperation$DeliverDescriptor deliverOperation$DeliverDescriptor = new DeliverOperation$DeliverDescriptor(iWorkspaceConnection, iWorkspaceConnection2);
        DeliverOperation$DeliverOperationRequest deliverOperation$DeliverOperationRequest = (DeliverOperation$DeliverOperationRequest)this.deliverRequests.get(deliverOperation$DeliverDescriptor);
        if (deliverOperation$DeliverOperationRequest != null && deliverOperation$DeliverOperationRequest.isWorkspaceContext()) {
            return;
        }
        if (deliverOperation$DeliverOperationRequest == null) {
            deliverOperation$DeliverOperationRequest = new DeliverOperation$DeliverOperationRequest(iWorkspaceConnection, iWorkspaceConnection2, iChangeHistorySyncReport, (List)new ArrayList(), (List)new ArrayList(), new ArrayList());
            this.deliverRequests.put(deliverOperation$DeliverDescriptor, deliverOperation$DeliverOperationRequest);
        }
        deliverOperation$DeliverOperationRequest.addChangeSet(list2);
        deliverOperation$DeliverOperationRequest.addBaseline(list);
        deliverOperation$DeliverOperationRequest.addComponent(list3);
    }

    protected void setFlowComponents(boolean bl) {
        this.flowComponents = bl;
    }

    protected Collection getDeliverRequests() {
        return this.deliverRequests.values();
    }

    protected DeliverDilemmaHandler getProblemHandler() {
        return this.problemHandler;
    }

    protected Set getAffectedDeliverConfigurations(Collection collection, List list, List list2, IProgressMonitor iProgressMonitor) throws TeamRepositoryException {
        Set set = this.getAffectedConfigurations(collection, list, iProgressMonitor);
        for (DeliverOperation$DeliverOperationRequest deliverOperation$DeliverOperationRequest : collection) {
            list2.add(deliverOperation$DeliverOperationRequest.getTargetWorkspace().getResolvedWorkspace());
            list2.add(deliverOperation$DeliverOperationRequest.getWorkspace().getResolvedWorkspace());
        }
        return set;
    }

    protected Set getAffectedConfigurations(Collection collection, List list, IProgressMonitor iProgressMonitor) throws TeamRepositoryException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)collection.size());
        HashSet hashSet = new HashSet();
        for (OperationRequest operationRequest : collection) {
            hashSet.addAll(operationRequest.getAffectedConfigurations(list, (IProgressMonitor)subMonitor.newChild(1)));
        }
        return hashSet;
    }

    protected final void verifyUncheckedInChanges(IProgressMonitor iProgressMonitor) throws TeamRepositoryException, FileSystemClientException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        Set set = this.getAffectedDeliverConfigurations(this.getDeliverRequests(), new ArrayList(3), new ArrayList(3), (IProgressMonitor)subMonitor.newChild(1));
        this.checkinPendingChanges(set, this.problemHandler, false, (IProgressMonitor)subMonitor.newChild(99));
    }

    private void selectWhatToDeliver(IWorkspaceConnection iWorkspaceConnection, IWorkspaceConnection iWorkspaceConnection2, IComponentHandle iComponentHandle, IChangeHistorySyncReport iChangeHistorySyncReport, OperationRequest operationRequest) {
        try {
            List list;
            IBaselineHandle iBaselineHandle = iWorkspaceConnection.getComponentInfo(iComponentHandle).basis();
            IBaselineHandle iBaselineHandle2 = iWorkspaceConnection2.getComponentInfo(iComponentHandle).basis();
            if (!iBaselineHandle.sameItemId((IItemHandle)iBaselineHandle2) && (list = ItemLists.handlesToIds((Collection)iChangeHistorySyncReport.outgoingBaselines(iComponentHandle))).contains(ItemId.create((IItemHandle)((IItemHandle)iBaselineHandle)))) {
                operationRequest.addBaseline(iBaselineHandle);
                operationRequest.addChangeSet(iChangeHistorySyncReport.outgoingChangeSetsAfterBasis(iComponentHandle));
                return;
            }
        }
        catch (ComponentNotInWorkspaceException componentNotInWorkspaceException) {}
        operationRequest.addChangeSet(iChangeHistorySyncReport.outgoingChangeSets(iComponentHandle));
    }

    public void runPreConditionsOnly(IProgressMonitor iProgressMonitor) throws TeamRepositoryException, FileSystemClientException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        Set set = this.getAffectedConfigurations(this.getDeliverRequests(), new ArrayList(3), (IProgressMonitor)subMonitor.newChild(10));
        this.runPreConditionsOnly(set, (IProgressMonitor)subMonitor.newChild(90));
    }

    private void runPreConditionsOnly(Collection collection, IProgressMonitor iProgressMonitor) throws FileSystemClientException, TeamRepositoryException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)25);
        this.verifyInSync(collection, (IProgressMonitor)subMonitor.newChild(15));
        this.verifyNonDefaultTargets();
        this.verifyComponentFlowing(subMonitor.newChild(5));
        this.verifyUncheckedInChanges((IProgressMonitor)subMonitor.newChild(5));
    }

    private void verifyInSync(Collection collection, IProgressMonitor iProgressMonitor) throws TeamRepositoryException, FileSystemClientException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)(100 + collection.size()));
        IVerifyInSyncOperation iVerifyInSyncOperation = IOperationFactory.instance.getVerifyInSyncOperation(this.problemHandler.getOutOfSyncDilemmaHandler());
        for (ConfigurationDescriptor configurationDescriptor : collection) {
            iVerifyInSyncOperation.addToVerify(configurationDescriptor.getConnection((IProgressMonitor)subMonitor.newChild(1)), configurationDescriptor.componentHandle);
        }
        iVerifyInSyncOperation.run((IProgressMonitor)subMonitor.newChild(100));
    }

    protected void refreshLocal(IFilesystemRefresher iFilesystemRefresher, Map map, IProgressMonitor iProgressMonitor) throws FileSystemClientException, TeamRepositoryException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (String)Messages.DeliverOperation_REFRESHING_LOCAL_FILESYSTEM, (int)(this.deliverRequests.size() * 2));
        for (Map.Entry entry : this.deliverRequests.entrySet()) {
            DeliverOperation$DeliverOperationRequest deliverOperation$DeliverOperationRequest = (DeliverOperation$DeliverOperationRequest)entry.getValue();
            ChangeSetRefreshUtils.refreshLocalForAddition(iFilesystemRefresher, map, ((DeliverOperation$DeliverDescriptor)entry.getKey()).source, deliverOperation$DeliverOperationRequest.getChangeSets(), (IProgressMonitor)subMonitor.newChild(1));
            ChangeSetRefreshUtils.refreshForBaselineChange(iFilesystemRefresher, map.keySet(), ((DeliverOperation$DeliverDescriptor)entry.getKey()).source, deliverOperation$DeliverOperationRequest.getBaselines(), (IProgressMonitor)subMonitor.newChild(1));
            if (!this.flowComponents) {
                subMonitor.newChild(1);
                continue;
            }
            IChangeHistorySyncReport iChangeHistorySyncReport = deliverOperation$DeliverOperationRequest.getSyncReport();
            List list = FlowUtils.getComponentSynchronizationOps((boolean)deliverOperation$DeliverOperationRequest.isWorkspaceContext(), (List)deliverOperation$DeliverOperationRequest.getAffectedComponents((IProgressMonitor)subMonitor.newChild(1)), (IWorkspaceConnection)deliverOperation$DeliverOperationRequest.getWorkspace(), (IWorkspaceConnection)deliverOperation$DeliverOperationRequest.getTargetWorkspace(), (IChangeHistorySyncReport)iChangeHistorySyncReport);
            if (list.size() <= 0) continue;
            SubMonitor subMonitor2 = subMonitor.newChild(1);
            subMonitor2.setWorkRemaining(list.size());
            for (IFlowNodeConnection.IComponentOp iComponentOp : list) {
                IConnection iConnection;
                if (iComponentOp instanceof IFlowNodeConnection.IComponentAdditionOp) {
                    iConnection = ((IFlowNodeConnection.IComponentAdditionOp)iComponentOp).getSeedConnection();
                } else if (iComponentOp instanceof IFlowNodeConnection.IComponentReplacementOp) {
                    iConnection = ((IFlowNodeConnection.IComponentReplacementOp)iComponentOp).getSeedConnection();
                } else {
                    subMonitor2.newChild(1);
                    continue;
                }
                iFilesystemRefresher.addToRefresh(map.keySet(), iConnection.getContextHandle(), iComponentOp.getComponent(), (IProgressMonitor)subMonitor2.newChild(1));
            }
        }
        subMonitor.done();
    }
}

