/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.operations;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileArea;
import com.ibm.team.filesystem.client.internal.operations.DeleteInRepositoryOperation$1;
import com.ibm.team.filesystem.client.internal.operations.DeleteInRepositoryOperation$2;
import com.ibm.team.filesystem.client.internal.operations.FileSystemOperation;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationDescriptor;
import com.ibm.team.filesystem.client.internal.utils.ConnectionDescriptor;
import com.ibm.team.filesystem.client.internal.utils.FlowNodeLock;
import com.ibm.team.filesystem.client.internal.utils.WorkspaceLockUtil;
import com.ibm.team.filesystem.client.operations.CommitDilemmaHandler;
import com.ibm.team.filesystem.client.operations.IDeleteFoldersOperation;
import com.ibm.team.filesystem.client.operations.IVerifyInSyncOperation;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.common.ISymbolicLinkHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.dto.IComponentStateSummary;
import com.ibm.team.scm.common.dto.ISyncTime;
import com.ibm.team.scm.common.dto.IUpdateReport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;

public class DeleteInRepositoryOperation
extends FileSystemOperation
implements IDeleteFoldersOperation {
    private int totalToDelete;
    private Set affectedConfigurations;
    private Map toDelete;
    private boolean deleteContent;
    private final CommitDilemmaHandler problemHandler;

    public DeleteInRepositoryOperation(CommitDilemmaHandler commitDilemmaHandler) {
        super(commitDilemmaHandler == null ? CommitDilemmaHandler.getDefault() : commitDilemmaHandler);
        this.problemHandler = commitDilemmaHandler == null ? CommitDilemmaHandler.getDefault() : commitDilemmaHandler;
        this.toDelete = new HashMap();
        this.affectedConfigurations = new HashSet();
        this.totalToDelete = 0;
    }

    public void addDeleteRequest(IShareable[] iShareableArray, IProgressMonitor iProgressMonitor) throws TeamRepositoryException, FileSystemClientException {
        if (iShareableArray == null) {
            throw (Throwable)new IllegalArgumentException("Shareables must be supplied");
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)iShareableArray.length);
        IShareable[] iShareableArray2 = iShareableArray;
        int n = iShareableArray.length;
        int n2 = 0;
        while (n2 < n) {
            ArrayList<IShareable> arrayList;
            IShareable iShareable = iShareableArray2[n2];
            if (iShareable == null) {
                throw (Throwable)new IllegalArgumentException("List of shareables must not contain null");
            }
            IShare iShare = iShareable.getShare((IProgressMonitor)subMonitor.newChild(1));
            if (iShare == null) {
                throw (Throwable)new TeamRepositoryException(NLS.bind((String)Messages.DeleteOperation_0, (Object)iShareable.getLocalPath().toString(), (Object[])new Object[0]));
            }
            ISharingDescriptor iSharingDescriptor = iShare.getSharingDescriptor();
            if (!(iSharingDescriptor.getConnectionHandle() instanceof IWorkspaceHandle)) {
                throw (Throwable)new TeamRepositoryException(NLS.bind((String)Messages.DeleteOperation_1, (Object)iShareable.getLocalPath().toString(), (Object[])new Object[0]));
            }
            ConfigurationDescriptor configurationDescriptor = new ConfigurationDescriptor(iSharingDescriptor.getRepositoryId(), iSharingDescriptor.getRepositoryUri(), iSharingDescriptor.getConnectionHandle(), iSharingDescriptor.getComponent());
            this.affectedConfigurations.add(configurationDescriptor);
            ConnectionDescriptor connectionDescriptor = new ConnectionDescriptor(iSharingDescriptor.getRepositoryId(), iSharingDescriptor.getRepositoryUri(), iSharingDescriptor.getConnectionHandle());
            HashMap<UUID, ArrayList<IShareable>> hashMap = (HashMap<UUID, ArrayList<IShareable>>)this.toDelete.get(connectionDescriptor);
            if (hashMap == null) {
                hashMap = new HashMap<UUID, ArrayList<IShareable>>();
                this.toDelete.put(connectionDescriptor, hashMap);
            }
            if ((arrayList = (ArrayList<IShareable>)hashMap.get(iSharingDescriptor.getComponent().getItemId())) == null) {
                arrayList = new ArrayList<IShareable>();
                hashMap.put(iSharingDescriptor.getComponent().getItemId(), arrayList);
            }
            arrayList.add(iShareable);
            ++this.totalToDelete;
            ++n2;
        }
    }

    public void setDeleteContent(boolean bl) {
        this.deleteContent = bl;
    }

    protected void execute(IProgressMonitor iProgressMonitor) throws FileSystemClientException, TeamRepositoryException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (String)Messages.DeleteOperation_MainProgressMessage, (int)100);
        FlowNodeLock flowNodeLock = WorkspaceLockUtil.acquireWrite(this.affectedConfigurations, (IProgressMonitor)subMonitor.newChild(1));
        try {
            this.verifyInSync((IProgressMonitor)subMonitor.newChild(9));
            DeleteInRepositoryOperation$1 deleteInRepositoryOperation$1 = new DeleteInRepositoryOperation$1(this);
            this.runWithinFileSystemLock(deleteInRepositoryOperation$1, Messages.DeleteInRepositoryOperation_0, (IProgressMonitor)subMonitor.newChild(90));
        }
        finally {
            WorkspaceLockUtil.release(flowNodeLock);
        }
    }

    private void verifyInSync(IProgressMonitor iProgressMonitor) throws TeamRepositoryException, FileSystemClientException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)(this.toDelete.size() * 10 + 10));
        if (this.verifyInSyncEnabled() && !this.problemHandler.getOutOfSyncDilemmaHandler().willIgnoreAllSharesOutOfSync()) {
            IVerifyInSyncOperation iVerifyInSyncOperation = IOperationFactory.instance.getVerifyInSyncOperation(this.problemHandler.getOutOfSyncDilemmaHandler());
            boolean bl = false;
            for (Map.Entry entry : this.toDelete.entrySet()) {
                SubMonitor subMonitor2 = subMonitor.newChild(10);
                subMonitor2.setWorkRemaining(((Map)entry.getValue()).size() + 1);
                HashMap<String, IShare> hashMap = new HashMap<String, IShare>();
                for (Collection collection : ((Map)entry.getValue()).values()) {
                    for (IShareable iShareable : collection) {
                        IShare iShare = iShareable.getShare((IProgressMonitor)subMonitor2.newChild(1));
                        if (iShare == null) continue;
                        hashMap.put(iShare.getPath().toString(), iShare);
                    }
                }
                if (hashMap.isEmpty()) continue;
                iVerifyInSyncOperation.addToVerify(((ConnectionDescriptor)entry.getKey()).getConnection((IProgressMonitor)subMonitor2.newChild(1)), hashMap.values());
                bl = true;
            }
            if (bl) {
                iVerifyInSyncOperation.run((IProgressMonitor)subMonitor.newChild(10));
            }
        }
    }

    private void delete(Map map, IProgressMonitor iProgressMonitor) throws TeamRepositoryException, FileSystemClientException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)(this.totalToDelete + this.toDelete.size()));
        for (Map.Entry entry : this.toDelete.entrySet()) {
            IWorkspaceConnection iWorkspaceConnection = (IWorkspaceConnection)((ConnectionDescriptor)entry.getKey()).getConnection((IProgressMonitor)subMonitor.newChild(1));
            ArrayList arrayList = new ArrayList();
            ArrayList arrayList2 = new ArrayList();
            Map map2 = (Map)entry.getValue();
            this.prepareCommitArgs(iWorkspaceConnection, map2, arrayList, arrayList2, (IProgressMonitor)subMonitor);
            try {
                if (!arrayList2.isEmpty()) {
                    IUpdateReport iUpdateReport = iWorkspaceConnection.commit((List)arrayList, (List)arrayList2, (IProgressMonitor)subMonitor.newChild(100));
                    HashMap<UUID, ISyncTime> hashMap = new HashMap<UUID, ISyncTime>();
                    for (IComponentStateSummary iComponentStateSummary : iUpdateReport.getComponentStatesBefore()) {
                        hashMap.put(iComponentStateSummary.getComponent().getItemId(), iComponentStateSummary.getConfigurationTime());
                    }
                    for (IComponentStateSummary iComponentStateSummary : iUpdateReport.getComponentStatesAfter()) {
                        ISyncTime iSyncTime = (ISyncTime)hashMap.get(iComponentStateSummary.getComponent().getItemId());
                        Collection collection = (Collection)map.get(new ConfigurationDescriptor((IConnection)iWorkspaceConnection, iComponentStateSummary.getComponent()));
                        for (ICopyFileArea iCopyFileArea : collection) {
                            iCopyFileArea.setConfigurationState((IContextHandle)iWorkspaceConnection.getResolvedWorkspace(), iComponentStateSummary.getComponent(), iSyncTime, iComponentStateSummary.getConfigurationTime(), null);
                        }
                    }
                }
                this.deleteFromCFA(map2, (IProgressMonitor)subMonitor.newChild(100));
            }
            catch (TeamRepositoryException teamRepositoryException) {
                this.collectStatus(FileSystemStatus.getStatusFor(4, "com.ibm.team.filesystem.client", 0, Messages.DeleteOperation_ErrorFromServer, teamRepositoryException));
            }
        }
    }

    private void deleteFromCFA(Map map, IProgressMonitor iProgressMonitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)(map.size() * 100));
        String string = this.deleteContent ? Messages.DeleteOperation_SubProgressActionName : Messages.DeleteOperation_SubProgressActionNameAlt;
        int n = 0;
        for (Collection collection : map.values()) {
            ++n;
            SubMonitor subMonitor2 = subMonitor.newChild(100);
            subMonitor2.setWorkRemaining(collection.size() * 50);
            for (IShareable iShareable : collection) {
                IPath iPath = iShareable.getLocalPath();
                subMonitor2.setTaskName(NLS.bind((String)Messages.DeleteOperation_ActionNumbers, (Object)string, (Object[])new Object[]{iPath, n, this.totalToDelete}));
                IFileStorage iFileStorage = ((Shareable)iShareable).getFileStorage();
                try {
                    ((Shareable)iShareable).forget((IProgressMonitor)subMonitor2.newChild(24));
                }
                catch (FileSystemClientException fileSystemClientException) {
                    this.collectStatus(FileSystemStatus.getStatusFor(4, "com.ibm.team.filesystem.client", 0, NLS.bind((String)Messages.DeleteOperation_ErrorFromClientDelete, (Object)iPath, (Object[])new Object[0]), (Throwable)((Object)fileSystemClientException)));
                    break;
                }
                boolean bl = false;
                try {
                    bl = iShareable.exists((IProgressMonitor)subMonitor2.newChild(1));
                }
                catch (FileSystemClientException fileSystemClientException) {
                    this.collectStatus(FileSystemStatus.getStatusFor((Throwable)((Object)fileSystemClientException)));
                }
                if (!bl || !this.deleteContent) continue;
                try {
                    SharingManager.getInstance().doSilentChange(new DeleteInRepositoryOperation$2(this, iFileStorage, subMonitor2));
                }
                catch (CoreException coreException) {
                    this.collectStatus(FileSystemStatus.getStatusFor(4, "com.ibm.team.filesystem.client", 0, NLS.bind((String)Messages.DeleteOperation_ErrorFromFileSystemDelete, (Object)iPath, (Object[])new Object[0]), coreException));
                }
            }
            subMonitor2.done();
        }
    }

    private void prepareCommitArgs(IWorkspaceConnection iWorkspaceConnection, Map map, ArrayList arrayList, ArrayList arrayList2, IProgressMonitor iProgressMonitor) throws TeamRepositoryException, FileSystemClientException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)(map.size() * 100));
        for (Map.Entry entry : map.entrySet()) {
            IShareable iShareable2;
            Collection collection = (Collection)entry.getValue();
            ArrayList<Object> arrayList3 = new ArrayList<Object>(collection.size());
            SubMonitor subMonitor2 = subMonitor.newChild(100);
            subMonitor2.setWorkRemaining(collection.size() + 1);
            for (IShareable iShareable2 : collection) {
                IVersionableHandle iVersionableHandle = iShareable2.getRemote((IProgressMonitor)subMonitor2.newChild(1));
                if (iVersionableHandle instanceof IFolderHandle) {
                    arrayList3.add(iWorkspaceConnection.configurationOpFactory().deleteSubtree((IFolderHandle)iVersionableHandle));
                    continue;
                }
                if (!(iVersionableHandle instanceof IFileItemHandle) && !(iVersionableHandle instanceof ISymbolicLinkHandle)) continue;
                arrayList3.add(iWorkspaceConnection.configurationOpFactory().delete(iVersionableHandle));
            }
            if (subMonitor2.isCanceled()) {
                throw (Throwable)new OperationCanceledException();
            }
            if (arrayList3.isEmpty()) continue;
            iShareable2 = (IComponentHandle)IComponent.ITEM_TYPE.createItemHandle((Object)iWorkspaceConnection, (UUID)entry.getKey(), null);
            IChangeSetHandle iChangeSetHandle = iWorkspaceConnection.getCurrentChangeSet((IComponentHandle)iShareable2);
            if (iChangeSetHandle == null) {
                iChangeSetHandle = iWorkspaceConnection.createChangeSet((IComponentHandle)iShareable2, Messages.DeleteOperation_2, true, (IProgressMonitor)subMonitor2.newChild(1));
            }
            arrayList.add(iChangeSetHandle);
            arrayList2.add(arrayList3);
        }
    }

    static /* synthetic */ Set access$0(DeleteInRepositoryOperation deleteInRepositoryOperation) {
        return deleteInRepositoryOperation.affectedConfigurations;
    }

    static /* synthetic */ void access$1(DeleteInRepositoryOperation deleteInRepositoryOperation, Map map, IProgressMonitor iProgressMonitor) throws TeamRepositoryException, FileSystemClientException {
        deleteInRepositoryOperation.delete(map, iProgressMonitor);
    }
}

