/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.operations;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.operations.ChangeHistoryChangeSetsOperation;
import com.ibm.team.filesystem.client.internal.operations.CreateBaselineOperation$CreateBaselineRequest;
import com.ibm.team.filesystem.client.internal.operations.IFilesystemRefresher;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationDescriptor;
import com.ibm.team.filesystem.client.internal.utils.FlowNodeLock;
import com.ibm.team.filesystem.client.internal.utils.WorkspaceLockUtil;
import com.ibm.team.filesystem.client.operations.CreateBaselineDilemmaHandler;
import com.ibm.team.filesystem.client.operations.ICreateBaselineOperation;
import com.ibm.team.repository.client.util.ThreadCheck;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponentHandle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;

public class CreateBaselineOperation
extends ChangeHistoryChangeSetsOperation
implements ICreateBaselineOperation {
    private Map requests = new HashMap();
    private List baselines = new ArrayList();
    private CreateBaselineDilemmaHandler problemHandler;

    public CreateBaselineOperation(CreateBaselineDilemmaHandler createBaselineDilemmaHandler) {
        super(createBaselineDilemmaHandler == null ? CreateBaselineDilemmaHandler.getDefault() : createBaselineDilemmaHandler);
        this.problemHandler = createBaselineDilemmaHandler == null ? CreateBaselineDilemmaHandler.getDefault() : createBaselineDilemmaHandler;
    }

    public void createBaselineRequest(IWorkspaceConnection iWorkspaceConnection, IComponentHandle iComponentHandle, String string, String string2) {
        if (iWorkspaceConnection == null) {
            throw (Throwable)new IllegalArgumentException("missing workspace");
        }
        if (iComponentHandle == null) {
            throw (Throwable)new IllegalArgumentException("missing component");
        }
        CreateBaselineOperation$CreateBaselineRequest createBaselineOperation$CreateBaselineRequest = new CreateBaselineOperation$CreateBaselineRequest(this, null);
        createBaselineOperation$CreateBaselineRequest.workspace = iWorkspaceConnection;
        createBaselineOperation$CreateBaselineRequest.componentHandle = iComponentHandle;
        createBaselineOperation$CreateBaselineRequest.name = string;
        createBaselineOperation$CreateBaselineRequest.comment = string2;
        this.requests.put(new ConfigurationDescriptor((IConnection)iWorkspaceConnection, iComponentHandle), createBaselineOperation$CreateBaselineRequest);
    }

    protected void execute(IProgressMonitor iProgressMonitor) throws FileSystemClientException, TeamRepositoryException {
        ThreadCheck.checkLongOpsAllowed();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (String)Messages.CreateBaselineOperation_0, (int)(10 + 30 * this.requests.size()));
        ArrayList arrayList = new ArrayList();
        HashSet hashSet = new HashSet();
        hashSet.addAll(this.requests.keySet());
        FlowNodeLock flowNodeLock = WorkspaceLockUtil.acquireWrite(hashSet, (Collection)arrayList, (IProgressMonitor)subMonitor.newChild(1));
        try {
            this.runPreConditions(hashSet, (IProgressMonitor)subMonitor.newChild(9));
            for (CreateBaselineOperation$CreateBaselineRequest createBaselineOperation$CreateBaselineRequest : this.requests.values()) {
                this.baselines.add(createBaselineOperation$CreateBaselineRequest.workspace.createBaseline(createBaselineOperation$CreateBaselineRequest.componentHandle, createBaselineOperation$CreateBaselineRequest.name, createBaselineOperation$CreateBaselineRequest.comment, (IProgressMonitor)subMonitor.newChild(30)));
                this.checkCancelled((IProgressMonitor)subMonitor);
            }
        }
        finally {
            WorkspaceLockUtil.release(flowNodeLock);
        }
    }

    private void runPreConditions(Set set, IProgressMonitor iProgressMonitor) throws FileSystemClientException, TeamRepositoryException {
        Object object;
        Object object2;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        if (this.verifyInSyncEnabled() && !this.problemHandler.getOutOfSyncDilemmaHandler().willIgnoreAllSharesOutOfSync()) {
            object2 = IOperationFactory.instance.getVerifyInSyncOperation(this.problemHandler.getOutOfSyncDilemmaHandler());
            for (ConfigurationDescriptor object3 : set) {
                object2.addToVerify(object3.getConnection(null), object3.componentHandle);
            }
            object2.run((IProgressMonitor)subMonitor.newChild(50));
        }
        this.checkinPendingChanges(set, this.problemHandler, false, (IProgressMonitor)subMonitor.newChild(50));
        object2 = new ArrayList();
        for (Map.Entry entry : this.requests.entrySet()) {
            object = (CreateBaselineOperation$CreateBaselineRequest)entry.getValue();
            if (((CreateBaselineOperation$CreateBaselineRequest)object).workspace.conflictReport(((CreateBaselineOperation$CreateBaselineRequest)object).componentHandle).conflicts().isEmpty()) continue;
            object2.add((ConfigurationDescriptor)entry.getKey());
        }
        if (!object2.isEmpty()) {
            int n = this.problemHandler.conflictedConfigurations((List)object2);
            if (n == 1) {
                throw (Throwable)new OperationCanceledException();
            }
            if (n == 0) {
                object = object2.iterator();
                while (object.hasNext()) {
                    ConfigurationDescriptor configurationDescriptor = (ConfigurationDescriptor)object.next();
                    this.requests.remove(configurationDescriptor);
                }
            } else {
                throw (Throwable)new TeamRepositoryException(Messages.CreateBaselineOperation_1);
            }
        }
    }

    public Collection getBaselinesCreated() {
        return this.baselines;
    }

    protected void refreshLocal(IFilesystemRefresher iFilesystemRefresher, Map map, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (String)Messages.CreateBaselineOperation_REFRESHING_LOCAL_FILESYSTEM, (int)map.size());
        for (Map.Entry entry : map.entrySet()) {
            IShare[] iShareArray = ((ISandbox)entry.getKey()).allShares((IProgressMonitor)subMonitor);
            int n = iShareArray.length;
            int n2 = 0;
            while (n2 < n) {
                IShare iShare = iShareArray[n2];
                iFilesystemRefresher.addToRefresh(iShare.getShareable());
                ++n2;
            }
        }
    }
}

