/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.operations;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.FileUploadHandler;
import com.ibm.team.filesystem.client.IContentProperties;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.FileItemInfo;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.InverseFileItemInfo;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.Shed;
import com.ibm.team.filesystem.client.internal.copyfileareas.AbstractLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.CFALockUtil;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileArea;
import com.ibm.team.filesystem.client.internal.magic.ContentProperties;
import com.ibm.team.filesystem.client.internal.operations.CheckinUploadData;
import com.ibm.team.filesystem.client.internal.operations.CheckinUploadHandler$1;
import com.ibm.team.filesystem.client.internal.operations.EncodingUploadFailure;
import com.ibm.team.filesystem.client.internal.operations.LineDelimiterUploadFailure;
import com.ibm.team.filesystem.client.internal.operations.NewCheckInOperation$ComponentCheckInRequest;
import com.ibm.team.filesystem.client.internal.operations.UploadFailure;
import com.ibm.team.filesystem.client.internal.utils.CancellationMonitor;
import com.ibm.team.filesystem.common.FileLineDelimiter;
import com.ibm.team.filesystem.common.IFileContent;
import com.ibm.team.filesystem.common.internal.FileContent;
import com.ibm.team.filesystem.common.util.LineDelimiterUtil;
import com.ibm.team.filesystem.common.util.LineDelimiterVerifier;
import com.ibm.team.filesystem.common.util.VerifyConvertToCRInputStream;
import com.ibm.team.filesystem.common.util.VerifyConvertToCRLFInputStream;
import com.ibm.team.filesystem.common.util.VerifyConvertToLFInputStream;
import com.ibm.team.internal.repository.rcp.streams.DigestComputingInputStream;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.repository.common.utils.ContentLineDelimiterError;
import com.ibm.team.repository.common.utils.ReaderToInputStream;
import com.ibm.team.repository.common.utils.TemporaryOutputStream;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.content.AbstractUploadHandler;
import com.ibm.team.scm.client.content.AbstractVersionedContentManagerInputStreamProvider;
import com.ibm.team.scm.common.ContentHash;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.UnsupportedCharsetException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;

public class CheckinUploadHandler
extends FileUploadHandler {
    private final IComponentHandle component;
    private final IWorkspaceConnection workspace;
    private final IVersionableHandle versionable;
    private final UUID itemId;
    private final IShareable shareable;
    private final ICopyFileArea cfa;
    private final CheckinUploadData uploadData;
    private boolean initialized;
    private IPath path;
    private IFileStorage file;
    private ContentHash predecessorHintHash;
    private String predecessorEncoding;
    private IContentProperties contentProperties;
    private boolean inferredLineDelimiter;
    private LineDelimiterVerifier delimiterVerifier;
    private FileLineDelimiter expectedLineDelimiter;
    private FileLineDelimiter propsLineDelimiter;
    private FileLineDelimiter foundLineDelimiter;
    private DigestComputingInputStream contents;
    private long size;
    private ContentHash hashcode;
    private LineDelimiterUploadFailure overrideLineDelimiter;
    private boolean forceConsistentDelimiters;
    private final CancellationMonitor cMon;
    private final AbstractVersionedContentManagerInputStreamProvider inProvider = new CheckinUploadHandler$1(this);
    private EncodingUploadFailure overrideEncoding;
    private boolean atomicCommitRequired;

    public CheckinUploadHandler(ICopyFileArea iCopyFileArea, NewCheckInOperation$ComponentCheckInRequest newCheckInOperation$ComponentCheckInRequest, ILocalChange iLocalChange, boolean bl, CheckinUploadData checkinUploadData, CancellationMonitor cancellationMonitor) throws FileSystemClientException {
        this.cfa = iCopyFileArea;
        this.shareable = iLocalChange.getShareable();
        this.versionable = iLocalChange.getTarget();
        this.itemId = this.versionable.getItemId();
        this.overrideLineDelimiter = null;
        this.component = newCheckInOperation$ComponentCheckInRequest.getComponent();
        this.workspace = newCheckInOperation$ComponentCheckInRequest.getWorkspace();
        this.atomicCommitRequired = bl;
        this.uploadData = checkinUploadData;
        this.cMon = cancellationMonitor;
        this.initialized = false;
    }

    public IComponentHandle getComponent() {
        return this.component;
    }

    public IVersionableHandle getVersionable() {
        return this.versionable;
    }

    protected String getEncoding() throws TeamRepositoryException {
        this.init();
        return this.contentProperties.getEncoding();
    }

    protected String getContentType() throws TeamRepositoryException {
        this.init();
        return this.contentProperties.getMimeType();
    }

    protected FileLineDelimiter getLineDelimiter() throws TeamRepositoryException {
        this.init();
        return this.propsLineDelimiter;
    }

    public ContentHash getPredecessorHintHash() throws TeamRepositoryException {
        this.init();
        return this.predecessorHintHash;
    }

    public AbstractVersionedContentManagerInputStreamProvider getStreamProvider() throws TeamRepositoryException {
        return this.inProvider;
    }

    InputStream wrapInputStream(InputStream inputStream) throws IOException, TeamRepositoryException {
        return inputStream;
    }

    private void updateFields() {
        if (this.delimiterVerifier != null) {
            this.foundLineDelimiter = this.delimiterVerifier.getLineDelimiter();
            this.delimiterVerifier = null;
        }
        if (this.contents != null) {
            this.size = this.contents.getContentSize();
            this.hashcode = ContentHash.valueOf((byte[])this.contents.getFinalDigest());
            this.contents = null;
        }
    }

    InputStream getInputStream(int n) throws IOException, TeamRepositoryException {
        this.init();
        try {
            InputStream inputStream;
            SharingManager.getInstance().disableChangeMonitoring();
            try {
                inputStream = this.file.getContents();
            }
            catch (FileSystemClientException fileSystemClientException) {
                throw (Throwable)new TeamRepositoryException((Throwable)((Object)fileSystemClientException));
            }
            if (this.propsLineDelimiter == FileLineDelimiter.LINE_DELIMITER_NONE) {
                this.delimiterVerifier = null;
                this.expectedLineDelimiter = this.propsLineDelimiter;
                if ((n & 2) != 0 && this.contents != null) {
                    InputStream inputStream2 = inputStream;
                    return inputStream2;
                }
                DigestComputingInputStream digestComputingInputStream = this.contents = ContentHash.getDigestComputingStream((InputStream)inputStream);
                return (InputStream)digestComputingInputStream;
            }
            this.expectedLineDelimiter = this.propsLineDelimiter == FileLineDelimiter.LINE_DELIMITER_PLATFORM ? FileLineDelimiter.getPlatformDelimiter() : this.propsLineDelimiter;
            if (this.forceConsistentDelimiters) {
                this.delimiterVerifier = LineDelimiterUtil.getNonVerifyingLineDelimiterConverter((InputStream)inputStream, (String)this.contentProperties.getEncoding(), (FileLineDelimiter)this.expectedLineDelimiter);
            } else if (this.expectedLineDelimiter == FileLineDelimiter.LINE_DELIMITER_LF) {
                this.delimiterVerifier = (LineDelimiterVerifier)new VerifyConvertToLFInputStream(inputStream, this.contentProperties.getEncoding());
            } else if (this.expectedLineDelimiter == FileLineDelimiter.LINE_DELIMITER_CRLF) {
                this.delimiterVerifier = (LineDelimiterVerifier)new VerifyConvertToCRLFInputStream(inputStream, this.contentProperties.getEncoding());
            } else if (this.expectedLineDelimiter == FileLineDelimiter.LINE_DELIMITER_CR) {
                this.delimiterVerifier = (LineDelimiterVerifier)new VerifyConvertToCRInputStream(inputStream, this.contentProperties.getEncoding());
            } else {
                throw (Throwable)new IllegalStateException();
            }
            if ((n & 2) != 0 && this.contents != null) {
                ReaderToInputStream readerToInputStream = new ReaderToInputStream((InputStreamReader)this.delimiterVerifier);
                return (InputStream)readerToInputStream;
            }
            DigestComputingInputStream digestComputingInputStream = this.contents = ContentHash.getDigestComputingStream((InputStream)((InputStream)new ReaderToInputStream((InputStreamReader)this.delimiterVerifier)));
            return (InputStream)digestComputingInputStream;
        }
        finally {
            SharingManager.getInstance().enableChangeMonitoring();
        }
    }

    public void uploadCanceled() throws TeamRepositoryException {
        this.delimiterVerifier = null;
        this.contents = null;
    }

    public void uploadCompleted(IFileContent iFileContent) throws TeamRepositoryException {
        this.updateFields();
        boolean bl = false;
        if (this.forceConsistentDelimiters) {
            bl = true;
        } else if (this.foundLineDelimiter == null) {
            if (this.expectedLineDelimiter != FileLineDelimiter.LINE_DELIMITER_NONE) {
                throw (Throwable)new IllegalStateException();
            }
        } else if (this.foundLineDelimiter != this.expectedLineDelimiter && this.foundLineDelimiter != FileLineDelimiter.LINE_DELIMITER_NONE) {
            bl = true;
        }
        Long l = this.size;
        ContentHash contentHash = this.hashcode;
        String string = this.contentProperties != null ? this.contentProperties.getMimeType() : this.contentProperties.getMimeType();
        FileContent fileContent = (FileContent)iFileContent;
        this.uploadData.setUploadInfo(this, l, contentHash, fileContent, string, this.shareable, bl);
    }

    public void convert(Shed shed, IProgressMonitor iProgressMonitor) throws FileSystemClientException, TeamRepositoryException {
        block50: {
            if (!(this.forceConsistentDelimiters || this.foundLineDelimiter != null && this.foundLineDelimiter != this.expectedLineDelimiter && this.foundLineDelimiter != FileLineDelimiter.LINE_DELIMITER_NONE)) {
                throw (Throwable)new IllegalStateException();
            }
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
            try {
                SharingManager.getInstance().disableChangeMonitoring();
                boolean bl = true;
                if (this.file.isReadOnly((IProgressMonitor)subMonitor.newChild(1))) {
                    bl = this.file.setWritable(true, (IProgressMonitor)subMonitor.newChild(1));
                }
                if (bl) {
                    TemporaryOutputStream temporaryOutputStream = null;
                    InputStream inputStream = null;
                    InputStream inputStream2 = null;
                    try {
                        try {
                            LineDelimiterVerifier lineDelimiterVerifier;
                            inputStream = this.file.getContents();
                            if (this.forceConsistentDelimiters) {
                                lineDelimiterVerifier = LineDelimiterUtil.getNonVerifyingLineDelimiterConverter((InputStream)inputStream, (String)this.contentProperties.getEncoding(), (FileLineDelimiter)this.expectedLineDelimiter);
                            } else if (this.expectedLineDelimiter == FileLineDelimiter.LINE_DELIMITER_LF) {
                                lineDelimiterVerifier = new VerifyConvertToLFInputStream(inputStream, this.contentProperties.getEncoding());
                            } else if (this.expectedLineDelimiter == FileLineDelimiter.LINE_DELIMITER_CRLF) {
                                lineDelimiterVerifier = new VerifyConvertToCRLFInputStream(inputStream, this.contentProperties.getEncoding());
                            } else if (this.expectedLineDelimiter == FileLineDelimiter.LINE_DELIMITER_CR) {
                                lineDelimiterVerifier = new VerifyConvertToCRInputStream(inputStream, this.contentProperties.getEncoding());
                            } else {
                                throw (Throwable)new IllegalStateException();
                            }
                            ReaderToInputStream readerToInputStream = new ReaderToInputStream((InputStreamReader)lineDelimiterVerifier);
                            SubMonitor subMonitor2 = subMonitor.newChild(50);
                            int n = 1000;
                            int n2 = 0;
                            long l = this.size * 2L;
                            long l2 = 0L;
                            subMonitor2.setWorkRemaining(n);
                            byte[] byArray = new byte[4096];
                            temporaryOutputStream = TemporaryOutputStream.getTemporaryOutputStream((long)this.size);
                            int n3 = ((InputStream)readerToInputStream).read(byArray);
                            while (n3 != -1) {
                                int n4 = (int)((double)(l2 += (long)n3) / (double)l * (double)n);
                                subMonitor2.worked(n4 - n2);
                                n2 = n4;
                                temporaryOutputStream.write(byArray, 0, n3);
                                n4 = (int)((double)(l2 += (long)n3) / (double)l * (double)n);
                                subMonitor2.worked(n4 - n2);
                                n2 = n4;
                                n3 = ((InputStream)readerToInputStream).read(byArray);
                            }
                            subMonitor2.done();
                            inputStream.close();
                            inputStream = null;
                            temporaryOutputStream.close();
                            inputStream2 = temporaryOutputStream.getInputStream((IProgressMonitor)subMonitor.newChild(24));
                            this.file.setContents(inputStream2, shed, (IProgressMonitor)subMonitor.newChild(25));
                            inputStream2.close();
                            inputStream2 = null;
                            temporaryOutputStream.dispose();
                            temporaryOutputStream = null;
                            this.uploadData.setConvertInfo(this.component, this.itemId, this.size, this.hashcode, this.file.getModificationStamp());
                        }
                        catch (FileSystemClientException fileSystemClientException) {
                            throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.NewCheckInOperation_9, (Object)this.path, (Object[])new Object[0]), (Throwable)((Object)fileSystemClientException))));
                        }
                        catch (IOException iOException) {
                            throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.NewCheckInOperation_10, (Object)this.path, (Object[])new Object[0]), (Throwable)iOException)));
                        }
                    }
                    catch (Throwable throwable) {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (IOException iOException) {}
                        }
                        if (inputStream2 != null) {
                            try {
                                inputStream2.close();
                            }
                            catch (IOException iOException) {}
                        }
                        if (temporaryOutputStream != null) {
                            try {
                                temporaryOutputStream.close();
                                temporaryOutputStream.dispose();
                            }
                            catch (IOException iOException) {}
                        }
                        throw throwable;
                    }
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (inputStream2 != null) {
                        try {
                            inputStream2.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (temporaryOutputStream != null) {
                        try {
                            temporaryOutputStream.close();
                            temporaryOutputStream.dispose();
                        }
                        catch (IOException iOException) {}
                    }
                    break block50;
                }
                SubMonitor subMonitor3 = subMonitor.newChild(50);
                int n = 1000;
                int n5 = 0;
                long l = this.size * 2L;
                long l3 = 0L;
                subMonitor3.setWorkRemaining(n);
                InputStream inputStream = null;
                try {
                    try {
                        inputStream = this.file.getContents();
                        DigestComputingInputStream digestComputingInputStream = ContentHash.getDigestComputingStream((InputStream)inputStream);
                        byte[] byArray = new byte[4096];
                        int n6 = digestComputingInputStream.read(byArray);
                        while (n6 != -1) {
                            int n7 = (int)((double)(l3 += (long)n6) / (double)l * (double)n);
                            subMonitor3.worked(n7 - n5);
                            n5 = n7;
                            n6 = digestComputingInputStream.read(byArray);
                        }
                        this.size = digestComputingInputStream.getContentSize();
                        this.hashcode = ContentHash.valueOf((byte[])digestComputingInputStream.getFinalDigest());
                        this.uploadData.setConvertInfo(this.component, this.itemId, this.size, this.hashcode, this.file.getModificationStamp());
                        inputStream.close();
                        inputStream = null;
                    }
                    catch (IOException iOException) {
                        throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.CheckinUploadHandler_0, (Object)this.path, (Object[])new Object[0]), (Throwable)iOException)));
                    }
                }
                catch (Throwable throwable) {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                SharingManager.getInstance().enableChangeMonitoring();
            }
        }
    }

    public AbstractUploadHandler.UploadFailureDirection uploadFailed(Exception exception, IProgressMonitor iProgressMonitor) {
        this.delimiterVerifier = null;
        this.contents = null;
        try {
            SharingManager.getInstance().disableChangeMonitoring();
            Throwable throwable = this.getRootCause(exception);
            if (throwable instanceof ContentLineDelimiterError) {
                if (this.inferredLineDelimiter) {
                    this.propsLineDelimiter = FileLineDelimiter.LINE_DELIMITER_NONE;
                    AbstractUploadHandler.UploadFailureDirection uploadFailureDirection = AbstractUploadHandler.UploadFailureDirection.RETRY;
                    return uploadFailureDirection;
                }
                this.overrideLineDelimiter = new LineDelimiterUploadFailure(this.shareable, this, this.propsLineDelimiter, throwable);
                this.uploadData.lineDelimiterFailure(this.overrideLineDelimiter);
                AbstractUploadHandler.UploadFailureDirection uploadFailureDirection = AbstractUploadHandler.UploadFailureDirection.CONTINUE;
                return uploadFailureDirection;
            }
            if (throwable instanceof UnsupportedEncodingException || throwable instanceof UnsupportedCharsetException) {
                this.overrideEncoding = new EncodingUploadFailure(this.shareable, this.contentProperties.getEncoding(), this.predecessorEncoding, true, false, this, throwable);
                this.uploadData.encodingUploadFailure(this.overrideEncoding);
                AbstractUploadHandler.UploadFailureDirection uploadFailureDirection = AbstractUploadHandler.UploadFailureDirection.CONTINUE;
                return uploadFailureDirection;
            }
            if (throwable instanceof CharacterCodingException) {
                this.overrideEncoding = new EncodingUploadFailure(this.shareable, this.contentProperties.getEncoding(), this.predecessorEncoding, false, true, this, throwable);
                this.uploadData.encodingUploadFailure(this.overrideEncoding);
                AbstractUploadHandler.UploadFailureDirection uploadFailureDirection = AbstractUploadHandler.UploadFailureDirection.CONTINUE;
                return uploadFailureDirection;
            }
            if (throwable instanceof OperationCanceledException) {
                AbstractUploadHandler.UploadFailureDirection uploadFailureDirection = AbstractUploadHandler.UploadFailureDirection.FAIL;
                return uploadFailureDirection;
            }
            UploadFailure uploadFailure = new UploadFailure(this.shareable, this, exception);
            this.uploadData.uploadFailure(uploadFailure);
            AbstractUploadHandler.UploadFailureDirection uploadFailureDirection = AbstractUploadHandler.UploadFailureDirection.CONTINUE;
            return uploadFailureDirection;
        }
        finally {
            SharingManager.getInstance().enableChangeMonitoring();
        }
    }

    private Throwable getRootCause(Throwable throwable) {
        int n = 0;
        while (throwable instanceof TeamRepositoryException && n < 50) {
            Throwable throwable2 = ((TeamRepositoryException)throwable).getCause();
            if (throwable2 == null) break;
            throwable = throwable2;
            ++n;
        }
        return throwable;
    }

    public void uploadStart() throws TeamRepositoryException {
    }

    private void init() throws TeamRepositoryException {
        if (!this.initialized) {
            try {
                try {
                    InverseFileItemInfo inverseFileItemInfo;
                    SharingManager.getInstance().disableChangeMonitoring();
                    this.file = ((Shareable)this.shareable).getFileStorage();
                    Long l = this.file.getModificationStamp();
                    this.uploadData.setModTime(this.component, this.itemId, l);
                    this.contentProperties = SharingManager.getInstance().getContentExaminer().findStoredProperties(this.shareable, (IProgressMonitor)this.cMon);
                    if (this.contentProperties == null) {
                        throw (Throwable)new TeamRepositoryException(NLS.bind((String)Messages.NewCheckInOperation_16, (Object)this.file.getIDEPath(), (Object[])new Object[0]));
                    }
                    this.propsLineDelimiter = this.contentProperties.getLineDelimiter();
                    AbstractLock abstractLock = CFALockUtil.lockExistingForRead(this.cfa.getRoot(), (IProgressMonitor)this.cMon);
                    try {
                        inverseFileItemInfo = this.cfa.getItemInfo(this.versionable, this.component, (IContextHandle)this.workspace.getResolvedWorkspace());
                    }
                    finally {
                        CFALockUtil.endBatching(abstractLock, (IProgressMonitor)this.cMon);
                    }
                    this.inferredLineDelimiter = ((FileItemInfo)inverseFileItemInfo).getLineDelimiter() == null;
                    this.predecessorHintHash = ((FileItemInfo)inverseFileItemInfo).getStoredHash();
                    this.predecessorEncoding = ((FileItemInfo)inverseFileItemInfo).getStoredEncoding();
                    this.initialized = true;
                }
                catch (FileSystemClientException fileSystemClientException) {
                    throw (Throwable)new TeamRepositoryException(NLS.bind((String)Messages.NewCheckInOperation_17, (Object)this.shareable.getLocalPath(), (Object[])new Object[0]), (Throwable)((Object)fileSystemClientException));
                }
            }
            finally {
                SharingManager.getInstance().enableChangeMonitoring();
            }
        }
        if (this.overrideLineDelimiter != null) {
            if (this.overrideLineDelimiter.isForceConsistentDelimiters()) {
                this.forceConsistentDelimiters = true;
            } else {
                this.propsLineDelimiter = FileLineDelimiter.LINE_DELIMITER_NONE;
                this.inferredLineDelimiter = false;
                this.forceConsistentDelimiters = false;
            }
            this.overrideLineDelimiter = null;
        }
        if (this.overrideEncoding != null) {
            if (this.overrideEncoding.isIgnoreEncoding()) {
                this.propsLineDelimiter = FileLineDelimiter.LINE_DELIMITER_NONE;
                this.inferredLineDelimiter = false;
                this.forceConsistentDelimiters = false;
            } else {
                this.contentProperties = new ContentProperties(this.overrideEncoding.getAlternativeEncoding(), this.contentProperties.getMimeType(), this.contentProperties.getLineDelimiter());
            }
            this.overrideEncoding = null;
        }
    }

    public boolean isAtomicCommitRequired() {
        return this.atomicCommitRequired;
    }
}

