/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.operations;

import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IChange;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.IUpdateReport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class ChangeSetChooser {
    private final IWorkspaceConnection workspace;
    private final Collection determinants;
    private HashMap openChangeSets;
    private HashMap defaultCS;
    private HashMap changeSetsToCommit;
    private HashMap changesToCommit;
    private HashMap changeSetComments;
    private HashMap newChangesToCommit;

    public ChangeSetChooser(IWorkspaceConnection iWorkspaceConnection, Collection collection) {
        this.workspace = iWorkspaceConnection;
        this.determinants = collection == null ? (Collection)new ArrayList() : collection;
        this.changeSetsToCommit = new HashMap();
        this.changesToCommit = new HashMap();
        this.changeSetComments = new HashMap();
        this.newChangesToCommit = new HashMap();
        this.openChangeSets = new HashMap();
        this.defaultCS = new HashMap();
    }

    private void init(IComponentHandle iComponentHandle, IProgressMonitor iProgressMonitor) throws TeamRepositoryException {
        HashMap hashMap = (HashMap)this.openChangeSets.get(iComponentHandle.getItemId());
        if (hashMap == null) {
            hashMap = this.getOpenChangeSets(iComponentHandle, iProgressMonitor);
            this.openChangeSets.put(iComponentHandle.getItemId(), hashMap);
            this.defaultCS.put(iComponentHandle.getItemId(), this.workspace.getCurrentChangeSet(iComponentHandle));
        }
    }

    private HashMap getOpenChangeSets(IComponentHandle iComponentHandle, IProgressMonitor iProgressMonitor) throws TeamRepositoryException {
        HashMap<UUID, IChangeSet> hashMap = new HashMap<UUID, IChangeSet>();
        List list = this.workspace.activeChangeSets(iComponentHandle);
        if (!list.isEmpty()) {
            List list2 = this.workspace.teamRepository().itemManager().fetchCompleteItems(list, 0, iProgressMonitor);
            this.determinants.addAll(list2);
            for (IChangeSet iChangeSet : list2) {
                for (IChange iChange : iChangeSet.changes()) {
                    hashMap.put(iChange.item().getItemId(), iChangeSet);
                }
            }
        }
        return hashMap;
    }

    public IChangeSetHandle getBestChangeSet(IComponentHandle iComponentHandle, IVersionableHandle iVersionableHandle, IChangeSetHandle iChangeSetHandle, IProgressMonitor iProgressMonitor) throws TeamRepositoryException {
        IChangeSetHandle iChangeSetHandle2 = iChangeSetHandle;
        if (iChangeSetHandle2 == null) {
            this.init(iComponentHandle, iProgressMonitor);
            iChangeSetHandle2 = (IChangeSetHandle)((HashMap)this.openChangeSets.get(iComponentHandle.getItemId())).get(iVersionableHandle.getItemId());
            if (iChangeSetHandle2 == null) {
                iChangeSetHandle2 = (IChangeSetHandle)this.defaultCS.get(iComponentHandle.getItemId());
            }
        }
        return iChangeSetHandle2;
    }

    public void toCommit(IComponentHandle iComponentHandle, IVersionableHandle iVersionableHandle, IWorkspaceConnection.IConfigurationOp iConfigurationOp, IChangeSetHandle iChangeSetHandle, String string, IProgressMonitor iProgressMonitor) throws TeamRepositoryException {
        ArrayList<IWorkspaceConnection.IConfigurationOp> arrayList;
        IChangeSetHandle iChangeSetHandle2 = this.getBestChangeSet(iComponentHandle, iVersionableHandle, iChangeSetHandle, iProgressMonitor);
        if (iChangeSetHandle2 != null) {
            UUID uUID = iChangeSetHandle2.getItemId();
            this.changeSetsToCommit.put(uUID, iChangeSetHandle2);
            arrayList = (List)this.changesToCommit.get(uUID);
            if (arrayList == null) {
                arrayList = new ArrayList();
                this.changesToCommit.put(uUID, arrayList);
            }
        } else {
            if (string != null) {
                this.changeSetComments.put(iComponentHandle.getItemId(), string);
            }
            if ((arrayList = (ArrayList<IWorkspaceConnection.IConfigurationOp>)this.newChangesToCommit.get(iComponentHandle.getItemId())) == null) {
                arrayList = new ArrayList<IWorkspaceConnection.IConfigurationOp>();
                this.newChangesToCommit.put(iComponentHandle.getItemId(), arrayList);
            }
        }
        arrayList.add(iConfigurationOp);
    }

    /*
     * WARNING - void declaration
     */
    public IUpdateReport commit(IProgressMonitor iProgressMonitor) throws TeamRepositoryException {
        Map.Entry entry22;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)(10 * this.newChangesToCommit.size() + 100));
        for (Map.Entry entry22 : this.newChangesToCommit.entrySet()) {
            void object;
            String string = (String)this.changeSetComments.get(entry22.getKey());
            if (string == null) {
                String string2 = "";
            }
            IChangeSetHandle iChangeSetHandle = this.workspace.createChangeSet((IComponentHandle)IComponent.ITEM_TYPE.createItemHandle((UUID)entry22.getKey(), null), (String)object, true, (IProgressMonitor)subMonitor.newChild(10));
            this.changeSetsToCommit.put(iChangeSetHandle.getItemId(), iChangeSetHandle);
            this.changesToCommit.put(iChangeSetHandle.getItemId(), (List)entry22.getValue());
        }
        this.newChangesToCommit.clear();
        this.changeSetComments.clear();
        entry22 = new ArrayList(this.changesToCommit.size());
        ArrayList arrayList = new ArrayList(this.changesToCommit.size());
        for (Map.Entry entry : this.changesToCommit.entrySet()) {
            IChangeSetHandle iChangeSetHandle = (IChangeSetHandle)this.changeSetsToCommit.get(entry.getKey());
            ((ArrayList)((Object)entry22)).add(iChangeSetHandle);
            arrayList.add((Collection)entry.getValue());
        }
        this.changeSetsToCommit.clear();
        this.changesToCommit.clear();
        return this.workspace.commit((List)((Object)entry22), (List)arrayList, (IProgressMonitor)subMonitor.newChild(100));
    }
}

