/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.operations;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.Sandbox;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileArea;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeManager;
import com.ibm.team.filesystem.client.internal.operations.ChangeHistoryChangeSetsDilemmaHandler;
import com.ibm.team.filesystem.client.internal.operations.ChangeHistoryChangeSetsOperation$1;
import com.ibm.team.filesystem.client.internal.operations.ChangeHistoryChangeSetsOperation$Refresher;
import com.ibm.team.filesystem.client.internal.operations.FileSystemOperation;
import com.ibm.team.filesystem.client.internal.operations.IFilesystemRefresher;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationDescriptor;
import com.ibm.team.filesystem.client.internal.utils.ConnectionDescriptor;
import com.ibm.team.filesystem.client.internal.utils.RationalizingTree;
import com.ibm.team.filesystem.client.operations.ICheckinOperation;
import com.ibm.team.filesystem.client.operations.ICheckinOptions;
import com.ibm.team.filesystem.client.operations.IRefreshingOperation;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IWorkspaceConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;

public abstract class ChangeHistoryChangeSetsOperation
extends FileSystemOperation
implements IRefreshingOperation,
ICheckinOptions {
    private boolean refreshBeforeRun = false;
    private boolean nonAtomicCommitIsAnOption = true;
    private int nonAtomicCommitFileUploadLimit = 200;

    protected ChangeHistoryChangeSetsOperation(ChangeHistoryChangeSetsDilemmaHandler changeHistoryChangeSetsDilemmaHandler) {
        super(changeHistoryChangeSetsDilemmaHandler);
    }

    public final void setRefreshBeforeRun(boolean bl) {
        this.refreshBeforeRun = bl;
    }

    public final boolean getRefreshBeforeRun() {
        return this.refreshBeforeRun;
    }

    protected abstract void refreshLocal(IFilesystemRefresher var1, Map var2, IProgressMonitor var3) throws FileSystemClientException, TeamRepositoryException;

    protected void checkinPendingChanges(Set set, ChangeHistoryChangeSetsDilemmaHandler changeHistoryChangeSetsDilemmaHandler, boolean bl, IProgressMonitor iProgressMonitor) throws TeamRepositoryException, FileSystemClientException {
        if (bl) {
            this.checkinPendingChanges(set, changeHistoryChangeSetsDilemmaHandler, iProgressMonitor);
        } else {
            ChangeHistoryChangeSetsOperation$1 changeHistoryChangeSetsOperation$1 = new ChangeHistoryChangeSetsOperation$1(this, set, changeHistoryChangeSetsDilemmaHandler);
            this.runWithinFileSystemLock(changeHistoryChangeSetsOperation$1, Messages.ChangeHistoryChangeSetsOperation_1, iProgressMonitor);
        }
    }

    private void checkinPendingChanges(Set set, ChangeHistoryChangeSetsDilemmaHandler changeHistoryChangeSetsDilemmaHandler, IProgressMonitor iProgressMonitor) throws FileSystemClientException, TeamRepositoryException {
        Object object;
        Object object2;
        Object object32;
        ChangeHistoryChangeSetsOperation$Refresher changeHistoryChangeSetsOperation$Refresher;
        HashMap<Object, List<ILocalChange>> hashMap = new HashMap<Object, List<ILocalChange>>();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)150);
        Map map = this.getCopyFileAreasAffected(set, (IProgressMonitor)subMonitor.newChild(1));
        if (this.getRefreshBeforeRun()) {
            subMonitor.setTaskName(Messages.ChangeHistoryChangeSetsOperation_REFRESHING_FILESYSTEM);
            changeHistoryChangeSetsOperation$Refresher = new ChangeHistoryChangeSetsOperation$Refresher(null);
            this.refreshLocal(changeHistoryChangeSetsOperation$Refresher, map, (IProgressMonitor)subMonitor.newChild(10));
            List object7 = this.rationalizeRefreshTree(ChangeHistoryChangeSetsOperation$Refresher.access$1(changeHistoryChangeSetsOperation$Refresher));
            subMonitor.setWorkRemaining(110 + object7.size() * 2);
            for (Object object32 : object7) {
                ((Shareable)object32).getFileStorage().refreshCachedSubTree(Integer.MAX_VALUE, (IProgressMonitor)subMonitor.newChild(1));
            }
            LocalChangeManager.getInstance().refreshChanges(object7, (IProgressMonitor)subMonitor.newChild(object7.size()));
            object32 = subMonitor.newChild(10);
            object32.setWorkRemaining(map.size());
            for (Map.Entry entry : map.entrySet()) {
                object2 = object32.newChild(1);
                object2.setWorkRemaining(((Set)entry.getValue()).size());
                for (Object object4 : (Set)entry.getValue()) {
                    LocalChangeManager.getInstance().syncPendingChanges(((ConfigurationDescriptor)object4).connectionHandle, ((ConfigurationDescriptor)object4).componentHandle, (ISandbox)entry.getKey(), (IProgressMonitor)subMonitor);
                }
            }
        }
        subMonitor.setWorkRemaining(100);
        changeHistoryChangeSetsOperation$Refresher = subMonitor.newChild(5).setWorkRemaining(map.size());
        for (Map.Entry entry : map.entrySet()) {
            ISandbox iSandbox = (ISandbox)entry.getKey();
            Set set2 = (Set)entry.getValue();
            object2 = changeHistoryChangeSetsOperation$Refresher.newChild(1).setWorkRemaining(set2.size());
            for (Object object4 : set2) {
                object = FileSystemCore.getSharingManager().getLocalChangeManager();
                object.syncPendingChanges(((ConfigurationDescriptor)object4).connectionHandle, ((ConfigurationDescriptor)object4).componentHandle, iSandbox, (IProgressMonitor)object2.newChild(1));
                ILocalChange[] iLocalChangeArray = object.getPendingChanges(((ConfigurationDescriptor)object4).connectionHandle, ((ConfigurationDescriptor)object4).componentHandle, iSandbox);
                if (iLocalChangeArray.length <= 0) continue;
                List<ILocalChange> list = Arrays.asList(iLocalChangeArray);
                list = Collections.unmodifiableList(list);
                hashMap.put(object4, list);
            }
        }
        if (!hashMap.isEmpty()) {
            int n = changeHistoryChangeSetsDilemmaHandler.uncheckedInChanges(Collections.unmodifiableMap((Map)hashMap));
            if (n == 0) {
                object32 = subMonitor.newChild(10).setWorkRemaining(hashMap.size() * 2);
                ICheckinOperation iCheckinOperation = IOperationFactory.instance.getCheckinOperation(changeHistoryChangeSetsDilemmaHandler.getCommitDilemmaHandler());
                if (this.nonAtomicCommitIsAnOption) {
                    iCheckinOperation.enableNonAtomicCommit(this.nonAtomicCommitFileUploadLimit);
                } else {
                    iCheckinOperation.disableNonAtomicCommit();
                }
                iCheckinOperation.setRefreshBeforeRun(false);
                for (Map.Entry entry : hashMap.entrySet()) {
                    Object object4;
                    object4 = (Collection)entry.getValue();
                    ILocalChange[] iLocalChangeArray = object4.toArray(new ILocalChange[object4.size()]);
                    if (object4.isEmpty()) continue;
                    object = (ConfigurationDescriptor)entry.getKey();
                    iCheckinOperation.requestCheckin((IWorkspaceConnection)((ConnectionDescriptor)object).getConnection((IProgressMonitor)object32.newChild(1)), ((ConfigurationDescriptor)object).componentHandle, iLocalChangeArray, null, "", (IProgressMonitor)object32.newChild(1));
                }
                this.disableVerifyInSync(iCheckinOperation);
                iCheckinOperation.run((IProgressMonitor)subMonitor.newChild(84));
            } else {
                if (n == 1) {
                    throw (Throwable)new OperationCanceledException();
                }
                if (n != 3) {
                    throw (Throwable)((Object)new FileSystemClientException(new FileSystemStatus(4, Messages.ChangeHistoryChangeSetsOperation_0)));
                }
            }
        }
        subMonitor.done();
    }

    private List rationalizeRefreshTree(List list) {
        Object object2;
        HashMap<ISandbox, Object> hashMap = new HashMap<ISandbox, Object>();
        for (Object object2 : list) {
            Object object3 = (RationalizingTree)hashMap.get(object2.getSandbox());
            if (object3 == null) {
                object3 = new RationalizingTree();
                hashMap.put(object2.getSandbox(), object3);
            }
            ((RationalizingTree)object3).put(object2.getLocalPath().segments(), object2);
        }
        object2 = new ArrayList(list.size());
        for (Object object4 : hashMap.values()) {
            Iterator iterator = ((RationalizingTree)object4).iterator();
            while (iterator.hasNext()) {
                IShareable iShareable = (IShareable)iterator.next();
                ((ArrayList)object2).add(iShareable);
            }
        }
        return (List)object2;
    }

    protected final Map getCopyFileAreasAffected(Set set, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        HashMap<Sandbox, HashSet<ConfigurationDescriptor>> hashMap = new HashMap<Sandbox, HashSet<ConfigurationDescriptor>>();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)set.size());
        ICopyFileAreaManager iCopyFileAreaManager = ICopyFileAreaManager.instance;
        for (ConfigurationDescriptor configurationDescriptor : set) {
            Collection collection = iCopyFileAreaManager.getCopyFileAreasForConfiguration(configurationDescriptor, (IProgressMonitor)subMonitor.newChild(1));
            for (ICopyFileArea iCopyFileArea : collection) {
                Sandbox sandbox = new Sandbox(iCopyFileArea);
                HashSet<ConfigurationDescriptor> hashSet = (HashSet<ConfigurationDescriptor>)hashMap.get(sandbox);
                if (hashSet == null) {
                    hashSet = new HashSet<ConfigurationDescriptor>();
                    hashMap.put(sandbox, hashSet);
                }
                hashSet.add(configurationDescriptor);
            }
        }
        return hashMap;
    }

    public void disableNonAtomicCommit() {
        this.nonAtomicCommitIsAnOption = false;
    }

    public void enableNonAtomicCommit(int n) {
        this.nonAtomicCommitIsAnOption = true;
        this.nonAtomicCommitFileUploadLimit = n;
    }

    static /* synthetic */ void access$0(ChangeHistoryChangeSetsOperation changeHistoryChangeSetsOperation, Set set, ChangeHistoryChangeSetsDilemmaHandler changeHistoryChangeSetsDilemmaHandler, IProgressMonitor iProgressMonitor) throws FileSystemClientException, TeamRepositoryException {
        changeHistoryChangeSetsOperation.checkinPendingChanges(set, changeHistoryChangeSetsDilemmaHandler, iProgressMonitor);
    }
}

