/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.operations;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.ISharingManager$RuleKind;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.FileItemInfoProxy;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.Shed;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.operations.ChangeFilePropertiesOperation$1;
import com.ibm.team.filesystem.client.internal.operations.ChangeFilePropertiesOperation$ChangePropertiesRequest;
import com.ibm.team.filesystem.client.internal.operations.FileSystemOperation;
import com.ibm.team.filesystem.client.internal.utils.ConnectionDescriptor;
import com.ibm.team.filesystem.client.operations.ChangePropertiesDilemmaHandler;
import com.ibm.team.filesystem.client.operations.IChangeFilePropertiesOperation;
import com.ibm.team.filesystem.client.operations.IChangePropertiesRequest;
import com.ibm.team.filesystem.client.operations.IVerifyInSyncOperation;
import com.ibm.team.filesystem.common.FileLineDelimiter;
import com.ibm.team.filesystem.common.util.LineDelimiterUtil;
import com.ibm.team.filesystem.common.util.VerifyConvertToCRInputStream;
import com.ibm.team.filesystem.common.util.VerifyConvertToCRLFInputStream;
import com.ibm.team.filesystem.common.util.VerifyConvertToLFInputStream;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.repository.common.utils.ContentLineDelimiterError;
import com.ibm.team.repository.common.utils.ReaderToInputStream;
import com.ibm.team.repository.common.utils.TemporaryOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.UnmappableCharacterException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;

public class ChangeFilePropertiesOperation
extends FileSystemOperation
implements IChangeFilePropertiesOperation {
    private ChangePropertiesDilemmaHandler dilemmaHandler;
    private HashMap changeProperties;
    private Shed shed;
    private boolean reportedSupportedCharSets;
    private static /* synthetic */ int[] $SWITCH_TABLE$com$ibm$team$filesystem$common$FileLineDelimiter;

    public ChangeFilePropertiesOperation(ChangePropertiesDilemmaHandler changePropertiesDilemmaHandler) {
        super(changePropertiesDilemmaHandler == null ? ChangePropertiesDilemmaHandler.getDefault() : changePropertiesDilemmaHandler);
        this.dilemmaHandler = changePropertiesDilemmaHandler == null ? ChangePropertiesDilemmaHandler.getDefault() : changePropertiesDilemmaHandler;
        this.shed = new Shed(this.dilemmaHandler.getBackupDilemmaHandler());
        this.changeProperties = new HashMap();
        this.reportedSupportedCharSets = false;
    }

    public void setLineDelimiter(IShareable iShareable, FileLineDelimiter fileLineDelimiter) {
        if (iShareable == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (fileLineDelimiter == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        IPath iPath = iShareable.getLocalPath();
        ChangeFilePropertiesOperation$ChangePropertiesRequest changeFilePropertiesOperation$ChangePropertiesRequest = (ChangeFilePropertiesOperation$ChangePropertiesRequest)this.changeProperties.get(iPath);
        if (changeFilePropertiesOperation$ChangePropertiesRequest == null) {
            this.changeProperties.put(iPath, new ChangeFilePropertiesOperation$ChangePropertiesRequest(this, (Shareable)iShareable, fileLineDelimiter));
        } else {
            ChangeFilePropertiesOperation$ChangePropertiesRequest.access$0(changeFilePropertiesOperation$ChangePropertiesRequest, fileLineDelimiter);
        }
    }

    public void setContentType(IShareable iShareable, String string) {
        if (iShareable == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (string == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        IPath iPath = iShareable.getLocalPath();
        ChangeFilePropertiesOperation$ChangePropertiesRequest changeFilePropertiesOperation$ChangePropertiesRequest = (ChangeFilePropertiesOperation$ChangePropertiesRequest)this.changeProperties.get(iPath);
        if (changeFilePropertiesOperation$ChangePropertiesRequest == null) {
            this.changeProperties.put(iPath, new ChangeFilePropertiesOperation$ChangePropertiesRequest(this, (Shareable)iShareable, string));
        } else {
            ChangeFilePropertiesOperation$ChangePropertiesRequest.access$1(changeFilePropertiesOperation$ChangePropertiesRequest, string);
        }
    }

    protected void execute(IProgressMonitor iProgressMonitor) throws FileSystemClientException, TeamRepositoryException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        if (this.changeProperties.isEmpty()) {
            return;
        }
        this.verifyShares((IProgressMonitor)subMonitor.newChild(10));
        ArrayList arrayList = new ArrayList();
        ISchedulingRule iSchedulingRule = this.getAffectedElements(arrayList);
        ChangeFilePropertiesOperation$1 changeFilePropertiesOperation$1 = new ChangeFilePropertiesOperation$1(this, arrayList);
        this.runWithinFileSystemLock(changeFilePropertiesOperation$1, "Change Properties", iSchedulingRule, iProgressMonitor);
    }

    private ISchedulingRule getAffectedElements(List list) {
        for (ChangeFilePropertiesOperation$ChangePropertiesRequest changeFilePropertiesOperation$ChangePropertiesRequest : this.changeProperties.values()) {
            list.add(ChangeFilePropertiesOperation$ChangePropertiesRequest.access$2(changeFilePropertiesOperation$ChangePropertiesRequest));
        }
        return SharingManager.getInstance().makeSchedulingRuleForIDE(list, ISharingManager$RuleKind.MODIFY);
    }

    private void verifyShares(IProgressMonitor iProgressMonitor) throws FileSystemClientException, TeamRepositoryException {
        if (!this.verifyInSyncEnabled() || this.dilemmaHandler.willIgnoreAllSharesOutOfSync()) {
            iProgressMonitor.done();
            return;
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)(this.changeProperties.size() * 3));
        HashMap<ConnectionDescriptor, ConnectionDescriptor> hashMap = new HashMap<ConnectionDescriptor, ConnectionDescriptor>();
        IVerifyInSyncOperation iVerifyInSyncOperation = IOperationFactory.instance.getVerifyInSyncOperation(this.dilemmaHandler);
        for (ChangeFilePropertiesOperation$ChangePropertiesRequest changeFilePropertiesOperation$ChangePropertiesRequest : this.changeProperties.values()) {
            IShare iShare = ChangeFilePropertiesOperation$ChangePropertiesRequest.access$2(changeFilePropertiesOperation$ChangePropertiesRequest).getShare((IProgressMonitor)subMonitor.newChild(1));
            if (iShare == null) continue;
            ISharingDescriptor iSharingDescriptor = iShare.getSharingDescriptor();
            ConnectionDescriptor connectionDescriptor = new ConnectionDescriptor(iSharingDescriptor.getRepositoryId(), iSharingDescriptor.getRepositoryUri(), iSharingDescriptor.getConnectionHandle());
            ConnectionDescriptor connectionDescriptor2 = (ConnectionDescriptor)hashMap.get(connectionDescriptor);
            if (connectionDescriptor2 == null) {
                connectionDescriptor2 = connectionDescriptor;
                hashMap.put(connectionDescriptor2, connectionDescriptor2);
            }
            iVerifyInSyncOperation.addToVerify(connectionDescriptor.getConnection((IProgressMonitor)subMonitor.newChild(1)), iShare);
        }
        subMonitor.setWorkRemaining(1);
        iVerifyInSyncOperation.run((IProgressMonitor)subMonitor.newChild(1));
    }

    private void updateProperties(IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)(this.changeProperties.size() * 2 + 11));
        ArrayList arrayList = new ArrayList();
        for (ChangeFilePropertiesOperation$ChangePropertiesRequest changeFilePropertiesOperation$ChangePropertiesRequest : this.changeProperties.values()) {
            this.checkCancelled((IProgressMonitor)subMonitor);
            ResourceType resourceType = changeFilePropertiesOperation$ChangePropertiesRequest.getShareableToChange().getResourceType((IProgressMonitor)subMonitor.newChild(1));
            if (resourceType == null) {
                this.collectStatus(FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.ChangeFilePropertiesOperation_11, (Object)changeFilePropertiesOperation$ChangePropertiesRequest.getShareableToChange().getFullPath().toString(), (Object[])new Object[0]), null));
                continue;
            }
            if (resourceType != ResourceType.FILE) {
                this.collectStatus(FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.ChangeFilePropertiesOperation_12, (Object)changeFilePropertiesOperation$ChangePropertiesRequest.getShareableToChange().getFullPath().toString(), (Object[])new Object[]{resourceType.name()}), null));
                continue;
            }
            if (changeFilePropertiesOperation$ChangePropertiesRequest.getShareableToChange().getShare((IProgressMonitor)subMonitor.newChild(1)) == null) {
                this.collectStatus(FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.ChangeFilePropertiesOperation_9, (Object)changeFilePropertiesOperation$ChangePropertiesRequest.getShareableToChange().getFullPath().toString(), (Object[])new Object[0]), null));
                break;
            }
            this.convert(changeFilePropertiesOperation$ChangePropertiesRequest, arrayList, (IProgressMonitor)subMonitor.newChild(1));
        }
        if (!arrayList.isEmpty()) {
            int n = this.dilemmaHandler.inconsistentLineDelimiters(Collections.unmodifiableList(arrayList), (IProgressMonitor)subMonitor.newChild(1));
            if (n == 0) {
                subMonitor.setWorkRemaining(arrayList.size());
                for (Object object : arrayList) {
                    if (!object.isChangeLineDelimiterRequest() || !object.isForceLineDelimiterChange()) continue;
                    this.convert((ChangeFilePropertiesOperation$ChangePropertiesRequest)object, null, (IProgressMonitor)subMonitor.newChild(1));
                }
            } else if (n != 1) {
                IChangePropertiesRequest iChangePropertiesRequest2;
                Object object;
                object = new IStatus[arrayList.size()];
                int n2 = 0;
                for (IChangePropertiesRequest iChangePropertiesRequest2 : arrayList) {
                    object[n2] = new FileSystemStatus(4, NLS.bind((String)Messages.ChangeFilePropertiesOperation_2, (Object)iChangePropertiesRequest2.getShareableToChange().getLocalPath(), (Object[])new Object[0]));
                    ++n2;
                }
                iChangePropertiesRequest2 = new MultiStatus("com.ibm.team.filesystem.client", 2, (IStatus[])object, Messages.ChangeFilePropertiesOperation_3, null);
                this.handleErrors(new IStatus[]{iChangePropertiesRequest2});
            } else {
                throw (Throwable)new OperationCanceledException();
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void convert(ChangeFilePropertiesOperation$ChangePropertiesRequest var1_1, ArrayList var2_2, IProgressMonitor var3_3) {
        block43: {
            block47: {
                block45: {
                    block46: {
                        var4_4 = SubMonitor.convert((IProgressMonitor)var3_3, (int)10);
                        try {
                            var5_5 = ICopyFileAreaManager.instance.getExistingCopyFileArea(ChangeFilePropertiesOperation$ChangePropertiesRequest.access$2(var1_1).getSandbox().getRoot());
                            var6_10 = var5_5.getItemInfo(ChangeFilePropertiesOperation$ChangePropertiesRequest.access$2(var1_1).getLocalPath());
                            var4_4.setTaskName(NLS.bind((String)Messages.ChangeFilePropertiesOperation_0, (Object)ChangeFilePropertiesOperation$ChangePropertiesRequest.access$2(var1_1).getLocalPath().toPortableString(), (Object[])new Object[0]));
                            if (var6_10 == null) {
                                this.collectStatus(new FileSystemStatus(4, NLS.bind((String)Messages.ChangeFilePropertiesOperation_1, (Object)ChangeFilePropertiesOperation$ChangePropertiesRequest.access$2(var1_1).getLocalPath().toString(), (Object[])new Object[0])));
                                break block43;
                            }
                            var7_15 = var1_1.isChangeLineDelimiterRequest() != false ? ChangeFilePropertiesOperation$ChangePropertiesRequest.access$3(var1_1) : var6_10.getLineDelimiter();
                            var8_17 = var1_1.isChangeContentTypeRequest() != false ? ChangeFilePropertiesOperation$ChangePropertiesRequest.access$4(var1_1) : var6_10.getContentType();
                            var9_19 = new FileItemInfoProxy(var6_10);
                            var9_19.changeProperties(var6_10.isContentChanged(), var6_10.getLastContentChangeCheckStamp(), var7_15, var8_17, var6_10.isExecutable());
                            var5_5.setItemMetaData(ChangeFilePropertiesOperation$ChangePropertiesRequest.access$2(var1_1).getLocalPath(), var9_19.getFileItemInfo(), (IProgressMonitor)var4_4.newChild(1));
                            if (!var1_1.isChangeLineDelimiterRequest() || var7_15 == FileLineDelimiter.LINE_DELIMITER_NONE) break block43;
                            var10_21 = null;
                            var11_22 = null;
                            var12_23 = ChangeFilePropertiesOperation$ChangePropertiesRequest.access$2(var1_1).getFileStorage();
                            var13_24 = false;
                            try {
                                var14_25 = SharingManager.getInstance().getContentExaminer().getEncoding(ChangeFilePropertiesOperation$ChangePropertiesRequest.access$2(var1_1), (IProgressMonitor)var4_4.newChild(1));
                                if (var1_1.isForceLineDelimiterChange()) {
                                    var10_21 = new ReaderToInputStream((InputStreamReader)LineDelimiterUtil.getNonVerifyingLineDelimiterConverter((InputStream)var12_23.getContents(), (String)var14_25, (FileLineDelimiter)var7_15));
                                } else {
                                    block8 : switch (ChangeFilePropertiesOperation.$SWITCH_TABLE$com$ibm$team$filesystem$common$FileLineDelimiter()[var7_15.ordinal()]) {
                                        case 2: {
                                            var10_21 = new ReaderToInputStream((InputStreamReader)new VerifyConvertToLFInputStream(var12_23.getContents(), var14_25));
                                            break;
                                        }
                                        case 4: {
                                            var10_21 = new ReaderToInputStream((InputStreamReader)new VerifyConvertToCRLFInputStream(var12_23.getContents(), var14_25));
                                            break;
                                        }
                                        case 3: {
                                            var10_21 = new ReaderToInputStream((InputStreamReader)new VerifyConvertToCRInputStream(var12_23.getContents(), var14_25));
                                            break;
                                        }
                                        case 5: {
                                            switch (ChangeFilePropertiesOperation.$SWITCH_TABLE$com$ibm$team$filesystem$common$FileLineDelimiter()[FileLineDelimiter.getPlatformDelimiter().ordinal()]) {
                                                case 4: {
                                                    var10_21 = new ReaderToInputStream((InputStreamReader)new VerifyConvertToCRLFInputStream(var12_23.getContents(), var14_25));
                                                    break block8;
                                                }
                                                case 2: {
                                                    var10_21 = new ReaderToInputStream((InputStreamReader)new VerifyConvertToLFInputStream(var12_23.getContents(), var14_25));
                                                    break block8;
                                                }
                                                case 3: {
                                                    var10_21 = new ReaderToInputStream((InputStreamReader)new VerifyConvertToCRInputStream(var12_23.getContents(), var14_25));
                                                    break block8;
                                                }
                                            }
                                            throw (Throwable)new IllegalStateException();
                                        }
                                        default: {
                                            throw (Throwable)new IllegalStateException();
                                        }
                                    }
                                }
                                var15_26 = TemporaryOutputStream.createLocalBuffer((InputStream)((InputStream)var10_21), (IProgressMonitor)((IProgressMonitor)var4_4.newChild(2)));
                                try {
                                    var11_22 = var15_26.getInputStream((IProgressMonitor)var4_4.newChild(1));
                                    try {
                                        var12_23.setContents(var11_22, this.shed, (IProgressMonitor)var4_4.newChild(2));
                                        var13_24 = true;
                                    }
                                    finally {
                                        var11_22.close();
                                    }
                                }
                                finally {
                                    var15_26.dispose();
                                }
                            }
                            catch (Throwable var18_29) {
                                try {
                                    if (var10_21 != null) {
                                        ((InputStream)var10_21).close();
                                    }
                                }
                                catch (IOException v0) {}
                                try {
                                    if (var11_22 != null) {
                                        var11_22.close();
                                    }
                                }
                                catch (IOException v1) {}
                                if (!var13_24) {
                                    var5_5.setItemMetaData(ChangeFilePropertiesOperation$ChangePropertiesRequest.access$2(var1_1).getLocalPath(), var6_10, (IProgressMonitor)var4_4.newChild(1));
                                }
                                throw var18_29;
                            }
                            try {
                                if (var10_21 != null) {
                                    ((InputStream)var10_21).close();
                                }
                            }
                            catch (IOException v2) {}
                            try {
                                if (var11_22 != null) {
                                    var11_22.close();
                                }
                            }
                            catch (IOException v3) {}
                            if (!var13_24) {
                                var5_5.setItemMetaData(ChangeFilePropertiesOperation$ChangePropertiesRequest.access$2(var1_1).getLocalPath(), var6_10, (IProgressMonitor)var4_4.newChild(1));
                            }
                            break block43;
                        }
                        catch (ContentLineDelimiterError v4) {
                            var2_2.add(var1_1);
                            break block43;
                        }
                        catch (FileSystemClientException var5_6) {
                            var6_11 = FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.ChangeFilePropertiesOperation_8, (Object)ChangeFilePropertiesOperation$ChangePropertiesRequest.access$2(var1_1).getLocalPath().toString(), (Object[])new Object[0]), (Throwable)var5_6);
                            this.collectStatus(var6_11);
                            break block43;
                        }
                        catch (TeamRepositoryException var5_7) {
                            var6_12 = FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.ChangeFilePropertiesOperation_8, (Object)ChangeFilePropertiesOperation$ChangePropertiesRequest.access$2(var1_1).getLocalPath().toString(), (Object[])new Object[0]), (Throwable)var5_7);
                            this.collectStatus(var6_12);
                            break block43;
                        }
                        catch (UnsupportedCharsetException var5_8) {
                            var6_13 = FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.ChangeFilePropertiesOperation_4, (Object)ChangeFilePropertiesOperation$ChangePropertiesRequest.access$2(var1_1).getLocalPath().toString(), (Object[])new Object[0]), (Throwable)var5_8);
                            this.collectStatus(var6_13);
                            break block43;
                        }
                        catch (IOException var5_9) {
                            if (!(var5_9 instanceof UnsupportedEncodingException)) break block45;
                            if (this.reportedSupportedCharSets) break block46;
                            var7_16 = new StringBuffer();
                            ** for (var8_18 : Charset.availableCharsets().keySet())
                        }
lbl-1000:
                        // 1 sources

                        {
                            var7_16.append(var8_18).append(' ');
                            continue;
                        }
lbl113:
                        // 1 sources

                        var8_18 = new Status(1, "com.ibm.team.filesystem.client", NLS.bind((String)Messages.ChangeFilePropertiesOperation_10, (Object)var7_16.toString(), (Object[])new Object[0]));
                        this.collectStatus((IStatus)var8_18);
                        this.reportedSupportedCharSets = true;
                    }
                    var6_14 = FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.ChangeFilePropertiesOperation_5, (Object)ChangeFilePropertiesOperation$ChangePropertiesRequest.access$2(var1_1).getLocalPath().toString(), (Object[])new Object[0]), (Throwable)var5_9);
                    break block47;
                }
                var6_14 = var5_9 instanceof CharacterCodingException != false || var5_9 instanceof UnmappableCharacterException != false ? FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.ChangeFilePropertiesOperation_6, (Object)ChangeFilePropertiesOperation$ChangePropertiesRequest.access$2(var1_1).getLocalPath().toString(), (Object[])new Object[0]), (Throwable)var5_9) : FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.ChangeFilePropertiesOperation_7, (Object)ChangeFilePropertiesOperation$ChangePropertiesRequest.access$2(var1_1).getLocalPath().toString(), (Object[])new Object[0]), (Throwable)var5_9);
            }
            this.collectStatus(var6_14);
        }
    }

    static /* synthetic */ HashMap access$0(ChangeFilePropertiesOperation changeFilePropertiesOperation) {
        return changeFilePropertiesOperation.changeProperties;
    }

    static /* synthetic */ void access$1(ChangeFilePropertiesOperation changeFilePropertiesOperation, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        changeFilePropertiesOperation.updateProperties(iProgressMonitor);
    }

    static /* synthetic */ int[] $SWITCH_TABLE$com$ibm$team$filesystem$common$FileLineDelimiter() {
        if ($SWITCH_TABLE$com$ibm$team$filesystem$common$FileLineDelimiter != null) {
            return $SWITCH_TABLE$com$ibm$team$filesystem$common$FileLineDelimiter;
        }
        int[] nArray = new int[FileLineDelimiter.values().length];
        try {
            nArray[FileLineDelimiter.LINE_DELIMITER_CR.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[FileLineDelimiter.LINE_DELIMITER_CRLF.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[FileLineDelimiter.LINE_DELIMITER_LF.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[FileLineDelimiter.LINE_DELIMITER_NONE.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[FileLineDelimiter.LINE_DELIMITER_PLATFORM.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$com$ibm$team$filesystem$common$FileLineDelimiter = nArray;
        return nArray;
    }
}

