/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.operations;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.IFileContentMerger;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.Sandbox;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.Shed;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileArea;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeManager;
import com.ibm.team.filesystem.client.internal.operations.ApplyAcceptedOperation;
import com.ibm.team.filesystem.client.internal.operations.AutoResolveOperation$1;
import com.ibm.team.filesystem.client.internal.operations.AutoResolveOperation$2;
import com.ibm.team.filesystem.client.internal.operations.AutoResolveOperation$AutoResolveRequest;
import com.ibm.team.filesystem.client.internal.operations.AutoResolveOperation$AutoResolveState;
import com.ibm.team.filesystem.client.internal.operations.FailedAutoResolveRequest;
import com.ibm.team.filesystem.client.internal.operations.FileSystemOperation;
import com.ibm.team.filesystem.client.internal.operations.MarkAsMergedOperation;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationDescriptor;
import com.ibm.team.filesystem.client.internal.utils.FlowNodeLock;
import com.ibm.team.filesystem.client.internal.utils.WorkspaceLockUtil;
import com.ibm.team.filesystem.client.operations.ApplyAcceptedDilemmaHandler;
import com.ibm.team.filesystem.client.operations.AutoResolveConflictsDilemmaHandler;
import com.ibm.team.filesystem.client.operations.ChangePropertiesDilemmaHandler;
import com.ibm.team.filesystem.client.operations.IAutoResolveConflictsOperation;
import com.ibm.team.filesystem.client.operations.IChangeFilePropertiesOperation;
import com.ibm.team.filesystem.client.operations.IFailedAutoResolveRequest;
import com.ibm.team.filesystem.client.operations.IFileSystemOperation;
import com.ibm.team.filesystem.client.operations.MarkAsMergedDilemmaHandler;
import com.ibm.team.filesystem.client.operations.OutOfSyncDilemmaHandler;
import com.ibm.team.filesystem.common.FileLineDelimiter;
import com.ibm.team.filesystem.common.IFileContent;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.common.ILogicalChange;
import com.ibm.team.filesystem.common.ILogicalConflict;
import com.ibm.team.filesystem.common.ILogicalConflictReport;
import com.ibm.team.filesystem.common.ISymbolicLink;
import com.ibm.team.filesystem.common.ISymbolicLinkHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.IItemConflictReport;
import com.ibm.team.scm.common.dto.IUpdateReport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;

public class AutoResolveOperation
extends FileSystemOperation
implements IAutoResolveConflictsOperation {
    private final AutoResolveConflictsDilemmaHandler problemHandler;
    private ApplyAcceptedDilemmaHandler applyAcceptedDilemmaHandler;
    private MarkAsMergedDilemmaHandler markAsMergedDilemmaHandler;
    private ChangePropertiesDilemmaHandler changePropertiesDilemmaHandler;
    private OutOfSyncDilemmaHandler outOfSyncDilemmaHandler;
    private int conflictsResolvedCount;
    private Shed shed;
    private final HashMap contentConflicts;
    private final HashMap autoMergeableConflicts;
    private boolean nonAtomicCommitIsAnOption = true;
    private int nonAtomicCommitFileUploadLimit = 200;

    public AutoResolveOperation(AutoResolveConflictsDilemmaHandler autoResolveConflictsDilemmaHandler) {
        super(autoResolveConflictsDilemmaHandler == null ? AutoResolveConflictsDilemmaHandler.getDefault() : autoResolveConflictsDilemmaHandler);
        this.problemHandler = autoResolveConflictsDilemmaHandler == null ? AutoResolveConflictsDilemmaHandler.getDefault() : autoResolveConflictsDilemmaHandler;
        this.applyAcceptedDilemmaHandler = this.problemHandler.getApplyAcceptedDilemmaHandler();
        if (this.problemHandler.getApplyAcceptedDilemmaHandler() == null) {
            this.applyAcceptedDilemmaHandler = ApplyAcceptedDilemmaHandler.getDefault();
        }
        this.markAsMergedDilemmaHandler = this.problemHandler.getMarkAsMergedDilemmaHandler();
        if (this.markAsMergedDilemmaHandler == null) {
            this.markAsMergedDilemmaHandler = MarkAsMergedDilemmaHandler.getDefault();
        }
        this.changePropertiesDilemmaHandler = this.problemHandler.getChangePropertiesDilemmaHandler();
        if (this.changePropertiesDilemmaHandler == null) {
            this.changePropertiesDilemmaHandler = ChangePropertiesDilemmaHandler.getDefault();
        }
        this.outOfSyncDilemmaHandler = this.problemHandler.getOutOfSyncDilemmaHandler();
        if (this.outOfSyncDilemmaHandler == null) {
            this.outOfSyncDilemmaHandler = OutOfSyncDilemmaHandler.getDefault();
        }
        this.contentConflicts = new HashMap();
        this.autoMergeableConflicts = new HashMap();
        this.shed = new Shed(this.problemHandler.getBackupDilemmaHandler());
        this.conflictsResolvedCount = 0;
    }

    protected void execute(IProgressMonitor iProgressMonitor) throws FileSystemClientException, TeamRepositoryException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        Set set = this.getAffectedConfigurations();
        FlowNodeLock flowNodeLock = WorkspaceLockUtil.acquireWrite(set, (IProgressMonitor)subMonitor.newChild(1));
        try {
            AutoResolveOperation$1 autoResolveOperation$1 = new AutoResolveOperation$1(this, set);
            this.runWithinFileSystemLock(autoResolveOperation$1, Messages.AutoResolveOperation_2, (IProgressMonitor)subMonitor.newChild(99));
        }
        finally {
            WorkspaceLockUtil.release(flowNodeLock);
        }
        subMonitor.done();
    }

    private Set getAffectedConfigurations() throws FileSystemClientException {
        HashSet hashSet = new HashSet();
        this.getAffectedConfigurations(this.contentConflicts, hashSet);
        this.getAffectedConfigurations(this.autoMergeableConflicts, hashSet);
        return hashSet;
    }

    private Map getAffectedCFA(Set set, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)set.size());
        HashMap hashMap = new HashMap();
        ICopyFileAreaManager iCopyFileAreaManager = ICopyFileAreaManager.instance;
        for (ConfigurationDescriptor configurationDescriptor : set) {
            ArrayList<Sandbox> arrayList = new ArrayList<Sandbox>(2);
            hashMap.put(configurationDescriptor, arrayList);
            Collection collection = iCopyFileAreaManager.getCopyFileAreasForConfiguration(configurationDescriptor, (IProgressMonitor)subMonitor.newChild(1));
            for (ICopyFileArea iCopyFileArea : collection) {
                arrayList.add(new Sandbox(iCopyFileArea));
            }
        }
        return hashMap;
    }

    private void getAffectedConfigurations(HashMap hashMap, HashSet hashSet) {
        for (HashMap hashMap2 : hashMap.values()) {
            for (List list : hashMap2.values()) {
                for (AutoResolveOperation$AutoResolveRequest autoResolveOperation$AutoResolveRequest : list) {
                    hashSet.add(autoResolveOperation$AutoResolveRequest.getAffectedConfiguation());
                }
            }
        }
    }

    public int numberOfConflictsResolved() {
        return this.conflictsResolvedCount;
    }

    private int performAutoMerge(Map map, IProgressMonitor iProgressMonitor) throws TeamRepositoryException, FileSystemClientException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)(this.contentConflicts.size() + this.autoMergeableConflicts.size()));
        int n = 0;
        n += this.performStructuralAutoMerge((IProgressMonitor)subMonitor.newChild(this.autoMergeableConflicts.size()));
        for (HashMap hashMap : this.contentConflicts.values()) {
            Object object;
            IVersionableHandle iVersionableHandle;
            Object object22;
            Object object3;
            Object object4;
            Object object5;
            Object object62;
            SubMonitor subMonitor2 = subMonitor.newChild(1);
            ArrayList<IFileItemHandle> arrayList = new ArrayList<IFileItemHandle>();
            ArrayList<ISymbolicLinkHandle> arrayList2 = new ArrayList<ISymbolicLinkHandle>();
            ArrayList<Object> arrayList3 = new ArrayList<Object>();
            IWorkspaceConnection iWorkspaceConnection = null;
            int n2 = 0;
            for (Object object62 : hashMap.values()) {
                object5 = object62.iterator();
                while (object5.hasNext()) {
                    object4 = (AutoResolveOperation$AutoResolveRequest)object5.next();
                    if (iWorkspaceConnection == null) {
                        iWorkspaceConnection = AutoResolveOperation$AutoResolveRequest.access$0((AutoResolveOperation$AutoResolveRequest)object4);
                    }
                    if (((AutoResolveOperation$AutoResolveRequest)object4).getCommonAncestorState() instanceof IFileItemHandle) {
                        arrayList.add((IFileItemHandle)((AutoResolveOperation$AutoResolveRequest)object4).getCommonAncestorState());
                    }
                    if (((AutoResolveOperation$AutoResolveRequest)object4).getCommonAncestorState() instanceof ISymbolicLinkHandle) {
                        arrayList2.add((ISymbolicLinkHandle)((AutoResolveOperation$AutoResolveRequest)object4).getCommonAncestorState());
                    }
                    if (((AutoResolveOperation$AutoResolveRequest)object4).getProposedContributorState() instanceof IFileItemHandle) {
                        arrayList.add((IFileItemHandle)((AutoResolveOperation$AutoResolveRequest)object4).getProposedContributorState());
                    }
                    if (((AutoResolveOperation$AutoResolveRequest)object4).getProposedContributorState() instanceof ISymbolicLinkHandle) {
                        arrayList2.add((ISymbolicLinkHandle)((AutoResolveOperation$AutoResolveRequest)object4).getProposedContributorState());
                    }
                    if (this.isQualifyingFolderAddAddConflict(AutoResolveOperation$AutoResolveRequest.access$1((AutoResolveOperation$AutoResolveRequest)object4))) {
                        object3 = (IFolderHandle)((AutoResolveOperation$AutoResolveRequest)object4).getCommonAncestorState();
                        if (object3 != null) {
                            arrayList3.add(object3);
                        }
                        if ((object3 = (IFolderHandle)((AutoResolveOperation$AutoResolveRequest)object4).getProposedContributorState()) != null) {
                            arrayList3.add(object3);
                        }
                        if ((object3 = (IFolderHandle)((AutoResolveOperation$AutoResolveRequest)object4).getSelectedContributorState()) != null) {
                            arrayList3.add(object3);
                        }
                    }
                    ++n2;
                }
            }
            subMonitor2.setWorkRemaining(100);
            object62 = this.fetchItems(iWorkspaceConnection, arrayList, arrayList3, arrayList2, (IProgressMonitor)subMonitor2.newChild(25));
            ArrayList arrayList4 = new ArrayList();
            object4 = new ArrayList();
            object5 = new HashMap();
            SubMonitor subMonitor3 = subMonitor2.newChild(25).setWorkRemaining(n2);
            for (Map.Entry entry : hashMap.entrySet()) {
                object3 = new ArrayList();
                ((HashMap)object5).put((ILogicalConflictReport)entry.getKey(), object3);
                for (Object object22 : (List)entry.getValue()) {
                    IVersionable iVersionable;
                    iVersionableHandle = ((AutoResolveOperation$AutoResolveRequest)object22).getCommonAncestorState();
                    object = ((AutoResolveOperation$AutoResolveRequest)object22).getProposedContributorState();
                    if (object == null) continue;
                    IVersionable iVersionable2 = null;
                    if (iVersionableHandle != null) {
                        iVersionable2 = (IVersionable)object62.get(iVersionableHandle.getStateId());
                    }
                    if ((iVersionable = (IVersionable)object62.get(object.getStateId())) == null) continue;
                    try {
                        List list = (List)map.get(AutoResolveOperation$AutoResolveRequest.access$2((AutoResolveOperation$AutoResolveRequest)object22));
                        SubMonitor subMonitor4 = subMonitor3.newChild(1).setWorkRemaining(list.size());
                        for (ISandbox iSandbox : list) {
                            Object object7;
                            SubMonitor subMonitor5 = subMonitor4.newChild(1).setWorkRemaining(100);
                            Shareable shareable = (Shareable)iSandbox.findShareable(AutoResolveOperation$AutoResolveRequest.access$0((AutoResolveOperation$AutoResolveRequest)object22).getContextHandle(), AutoResolveOperation$AutoResolveRequest.access$2((AutoResolveOperation$AutoResolveRequest)object22).componentHandle, AutoResolveOperation$AutoResolveRequest.access$1((AutoResolveOperation$AutoResolveRequest)object22).item(), (IProgressMonitor)subMonitor5.newChild(2));
                            if (shareable == null) continue;
                            ResourceType resourceType = shareable.getResourceType((IProgressMonitor)subMonitor5.newChild(1));
                            IVersionableHandle iVersionableHandle2 = shareable.getVersionable((IProgressMonitor)subMonitor5.newChild(1));
                            if (resourceType == ResourceType.FOLDER && ResourceType.getResourceType(iVersionableHandle2) == ResourceType.FOLDER) {
                                if (!this.isQualifyingFolderAddAddConflict(AutoResolveOperation$AutoResolveRequest.access$1((AutoResolveOperation$AutoResolveRequest)object22))) continue;
                                boolean bl = false;
                                object7 = (IVersionable)object62.get(((AutoResolveOperation$AutoResolveRequest)object22).getSelectedContributorState().getStateId());
                                if (object7 != null && object7.getName().equals(iVersionable.getName()) && shareable.getLocalPath().lastSegment().equals(iVersionable.getName()) && object7.getParent().sameItemId((IItemHandle)iVersionable.getParent())) {
                                    if (!shareable.isShare((IProgressMonitor)subMonitor5.newChild(49))) {
                                        if (iVersionable.getParent().sameItemId((IItemHandle)shareable.getParent().getRemote((IProgressMonitor)subMonitor5.newChild(48)))) {
                                            bl = true;
                                        }
                                    } else {
                                        bl = true;
                                    }
                                }
                                if (!bl) continue;
                                object3.add(AutoResolveOperation$AutoResolveRequest.access$1((AutoResolveOperation$AutoResolveRequest)object22));
                                continue;
                            }
                            if (resourceType == ResourceType.FILE && ResourceType.getResourceType(iVersionableHandle2) == ResourceType.FILE) {
                                AutoResolveOperation$AutoResolveState autoResolveOperation$AutoResolveState = new AutoResolveOperation$AutoResolveState(this, resourceType);
                                autoResolveOperation$AutoResolveState.executableMerged = this.performExecutablePropertyMerge((IFileItem)iVersionable2, (IFileItem)iVersionable, shareable, (IProgressMonitor)subMonitor5.newChild(1));
                                autoResolveOperation$AutoResolveState.propertiesMerged = this.performFilePropertyAutoMerge((IFileItem)iVersionable2, (IFileItem)iVersionable, shareable, subMonitor5.newChild(3));
                                if (AutoResolveOperation$AutoResolveRequest.access$1((AutoResolveOperation$AutoResolveRequest)object22).isChangeType(4) && !AutoResolveOperation$AutoResolveRequest.access$1((AutoResolveOperation$AutoResolveRequest)object22).isModificationChange(4)) {
                                    autoResolveOperation$AutoResolveState.contentMerged = true;
                                }
                                if (!AutoResolveOperation$AutoResolveRequest.access$1((AutoResolveOperation$AutoResolveRequest)object22).isChangeType(1)) {
                                    autoResolveOperation$AutoResolveState.addMerged = true;
                                }
                                if (!(!autoResolveOperation$AutoResolveState.propertiesMerged || autoResolveOperation$AutoResolveState.contentMerged && autoResolveOperation$AutoResolveState.addMerged)) {
                                    object7 = SharingManager.getInstance().getFileContentMerger();
                                    IStatus iStatus = object7.performAutoMerge(iWorkspaceConnection.teamRepository(), (IFileItem)iVersionable2, (IFileItem)iVersionable, shareable, null, this.shed, (IProgressMonitor)subMonitor5.newChild(89));
                                    if (iStatus.isOK()) {
                                        autoResolveOperation$AutoResolveState.contentMerged = true;
                                    } else if (iStatus.getCode() == 1002) {
                                        arrayList4.add(new FailedAutoResolveRequest((AutoResolveOperation$AutoResolveRequest)object22, shareable, true, autoResolveOperation$AutoResolveState));
                                    } else if (iStatus.getCode() == 1001) {
                                        object4.add(new FailedAutoResolveRequest((AutoResolveOperation$AutoResolveRequest)object22, shareable, true, autoResolveOperation$AutoResolveState));
                                    }
                                }
                                if (this.isQualifyingAddAddChange(AutoResolveOperation$AutoResolveRequest.access$1((AutoResolveOperation$AutoResolveRequest)object22)) && iVersionable.getName().equals(shareable.getLocalPath().lastSegment())) {
                                    if (shareable.isShare((IProgressMonitor)subMonitor5.newChild(2))) {
                                        if (iVersionable.getParent().sameItemId((IItemHandle)shareable.getParent().getRemote((IProgressMonitor)subMonitor5.newChild(1)))) {
                                            autoResolveOperation$AutoResolveState.addMerged = true;
                                        }
                                    } else {
                                        autoResolveOperation$AutoResolveState.addMerged = true;
                                    }
                                }
                                if (!autoResolveOperation$AutoResolveState.isMerged()) continue;
                                object3.add(AutoResolveOperation$AutoResolveRequest.access$1((AutoResolveOperation$AutoResolveRequest)object22));
                                continue;
                            }
                            if (resourceType != ResourceType.SYMBOLIC_LINK || ResourceType.getResourceType(iVersionableHandle2) != ResourceType.SYMBOLIC_LINK) continue;
                            AutoResolveOperation$AutoResolveState autoResolveOperation$AutoResolveState = new AutoResolveOperation$AutoResolveState(this, resourceType);
                            autoResolveOperation$AutoResolveState.propertiesMerged = this.performPropertyAutoMerge(iVersionable2, iVersionable, shareable, subMonitor5.newChild(3));
                            if (AutoResolveOperation$AutoResolveRequest.access$1((AutoResolveOperation$AutoResolveRequest)object22).isChangeType(4) && !AutoResolveOperation$AutoResolveRequest.access$1((AutoResolveOperation$AutoResolveRequest)object22).isModificationChange(4)) {
                                autoResolveOperation$AutoResolveState.contentMerged = true;
                            }
                            if (!AutoResolveOperation$AutoResolveRequest.access$1((AutoResolveOperation$AutoResolveRequest)object22).isChangeType(1)) {
                                autoResolveOperation$AutoResolveState.addMerged = true;
                            }
                            if (autoResolveOperation$AutoResolveState.propertiesMerged && (!autoResolveOperation$AutoResolveState.contentMerged || !autoResolveOperation$AutoResolveState.addMerged) && shareable.getFileStorage().getTarget((IProgressMonitor)subMonitor5.newChild(1)).equals(((ISymbolicLink)iVersionable).getTarget())) {
                                autoResolveOperation$AutoResolveState.contentMerged = true;
                            }
                            if (this.isQualifyingAddAddChange(AutoResolveOperation$AutoResolveRequest.access$1((AutoResolveOperation$AutoResolveRequest)object22)) && iVersionable.getName().equals(shareable.getLocalPath().lastSegment())) {
                                if (shareable.isShare((IProgressMonitor)subMonitor5.newChild(2))) {
                                    if (iVersionable.getParent().sameItemId((IItemHandle)shareable.getParent().getRemote((IProgressMonitor)subMonitor5.newChild(1)))) {
                                        autoResolveOperation$AutoResolveState.addMerged = true;
                                    }
                                } else {
                                    autoResolveOperation$AutoResolveState.addMerged = true;
                                }
                            }
                            if (!autoResolveOperation$AutoResolveState.isMerged()) continue;
                            object3.add(AutoResolveOperation$AutoResolveRequest.access$1((AutoResolveOperation$AutoResolveRequest)object22));
                        }
                    }
                    catch (Exception exception) {
                        this.collectStatus(FileSystemStatus.getStatusFor(exception));
                    }
                }
            }
            if (!object4.isEmpty() || !arrayList4.isEmpty()) {
                subMonitor3 = subMonitor2.newChild(25).setWorkRemaining(100);
                int n3 = this.problemHandler.missingStorageMerger(Collections.unmodifiableCollection(arrayList4), Collections.unmodifiableCollection((Collection)object4), (IProgressMonitor)subMonitor3.newChild(5));
                if (n3 == 2) {
                    throw (Throwable)((Object)new FileSystemClientException(new FileSystemStatus(4, Messages.AutoResolveOperation_0)));
                }
                if (n3 == 1) {
                    throw (Throwable)new OperationCanceledException();
                }
                ITeamRepository iTeamRepository = iWorkspaceConnection.teamRepository();
                subMonitor3.setWorkRemaining(arrayList4.size() + object4.size());
                Iterator iterator = arrayList4.iterator();
                while (iterator.hasNext()) {
                    object22 = (IFailedAutoResolveRequest)iterator.next();
                    iVersionableHandle = subMonitor3.newChild(1).setWorkRemaining(100);
                    object = (FailedAutoResolveRequest)object22;
                    if (!((FailedAutoResolveRequest)object).isRetryMerge()) continue;
                    this.retryFileContentMerge(iTeamRepository, (FailedAutoResolveRequest)object, (Map)object62, (HashMap)object5, (IProgressMonitor)iVersionableHandle);
                }
                iterator = object4.iterator();
                while (iterator.hasNext()) {
                    object22 = (IFailedAutoResolveRequest)iterator.next();
                    iVersionableHandle = subMonitor3.newChild(1).setWorkRemaining(100);
                    object = (FailedAutoResolveRequest)object22;
                    if (!((FailedAutoResolveRequest)object).isRetryMerge()) continue;
                    this.retryFileContentMerge(iTeamRepository, (FailedAutoResolveRequest)object, (Map)object62, (HashMap)object5, (IProgressMonitor)iVersionableHandle);
                }
            }
            subMonitor2.setWorkRemaining(((HashMap)object5).size());
            for (Map.Entry entry : ((HashMap)object5).entrySet()) {
                try {
                    object22 = new MarkAsMergedOperation(iWorkspaceConnection, (ILogicalConflictReport)entry.getKey(), (Collection)entry.getValue(), this.markAsMergedDilemmaHandler);
                    this.disableVerifyInSync((IFileSystemOperation)object22);
                    if (this.nonAtomicCommitIsAnOption) {
                        ((MarkAsMergedOperation)object22).enableNonAtomicCommit(this.nonAtomicCommitFileUploadLimit);
                    } else {
                        ((MarkAsMergedOperation)object22).disableNonAtomicCommit();
                    }
                    ((FileSystemOperation)object22).run((IProgressMonitor)subMonitor2.newChild(1));
                    n += ((List)entry.getValue()).size();
                }
                catch (Exception exception) {
                    this.collectStatus(FileSystemStatus.getStatusFor(exception));
                }
            }
        }
        return n;
    }

    private boolean performPropertyAutoMerge(IVersionable iVersionable, IVersionable iVersionable2, Shareable shareable, SubMonitor subMonitor) {
        return true;
    }

    private boolean isQualifyingFolderAddAddConflict(ILogicalChange iLogicalChange) {
        return iLogicalChange.item() instanceof IFolderHandle && this.isQualifyingAddAddChange(iLogicalChange);
    }

    private boolean isQualifyingAddAddChange(ILogicalChange iLogicalChange) {
        IVersionableHandle iVersionableHandle;
        ILogicalConflict iLogicalConflict;
        return iLogicalChange.kind() == 1 && ((ILogicalConflict)iLogicalChange).conflictType() == 1 && (iLogicalConflict = (ILogicalConflict)iLogicalChange).conflictingItems().size() == 1 && (iVersionableHandle = (IVersionableHandle)iLogicalConflict.conflictingItems().iterator().next()).sameItemId((IItemHandle)iLogicalConflict.item());
    }

    private boolean performExecutablePropertyMerge(IFileItem iFileItem, IFileItem iFileItem2, IShareable iShareable, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        if (iFileItem2.isExecutable() == ((Shareable)iShareable).getFileStorage().isExecutable((IProgressMonitor)subMonitor.newChild(30))) {
            return true;
        }
        if (iFileItem == null) {
            return false;
        }
        if (iFileItem2.isExecutable() == iFileItem.isExecutable()) {
            return true;
        }
        boolean bl = ((Shareable)iShareable).getFileStorage().setExecutable(iFileItem2.isExecutable(), (IProgressMonitor)subMonitor.newChild(65));
        if (bl) {
            LocalChangeManager.getInstance().computeChanges(iShareable, (IProgressMonitor)subMonitor.newChild(5));
        }
        return bl;
    }

    private void retryFileContentMerge(ITeamRepository iTeamRepository, FailedAutoResolveRequest failedAutoResolveRequest, Map map, HashMap hashMap, IProgressMonitor iProgressMonitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        AutoResolveOperation$AutoResolveRequest autoResolveOperation$AutoResolveRequest = failedAutoResolveRequest.getRequest();
        IVersionableHandle iVersionableHandle = autoResolveOperation$AutoResolveRequest.getCommonAncestorState();
        IVersionableHandle iVersionableHandle2 = autoResolveOperation$AutoResolveRequest.getProposedContributorState();
        if (!(AutoResolveOperation$AutoResolveRequest.access$1(autoResolveOperation$AutoResolveRequest).item() instanceof IFileItemHandle)) {
            return;
        }
        IFileItem iFileItem = (IFileItem)map.get(iVersionableHandle.getStateId());
        IFileItem iFileItem2 = (IFileItem)map.get(iVersionableHandle2.getStateId());
        if (iFileItem2 == null) {
            return;
        }
        try {
            IFileContentMerger iFileContentMerger;
            IStatus iStatus;
            IShareable iShareable = failedAutoResolveRequest.getConflictedShareable();
            ResourceType resourceType = iShareable.getResourceType((IProgressMonitor)subMonitor.newChild(1));
            if (resourceType == ResourceType.FILE && (iStatus = (iFileContentMerger = SharingManager.getInstance().getFileContentMerger()).performAutoMerge(iTeamRepository, iFileItem, iFileItem2, iShareable, failedAutoResolveRequest.getDefaultContentTypeMerger(), this.shed, (IProgressMonitor)subMonitor.newChild(94))).isOK()) {
                failedAutoResolveRequest.getResolveState().contentMerged = true;
                LocalChangeManager.getInstance().computeChanges(iShareable, (IProgressMonitor)subMonitor.newChild(5));
                if (failedAutoResolveRequest.getResolveState().isMerged()) {
                    List list = (List)hashMap.get(AutoResolveOperation$AutoResolveRequest.access$3(autoResolveOperation$AutoResolveRequest));
                    list.add(AutoResolveOperation$AutoResolveRequest.access$1(autoResolveOperation$AutoResolveRequest));
                }
            }
        }
        catch (Exception exception) {
            this.collectStatus(FileSystemStatus.getStatusFor(exception));
        }
    }

    private int performStructuralAutoMerge(IProgressMonitor iProgressMonitor) {
        int n = 0;
        for (HashMap hashMap : this.autoMergeableConflicts.values()) {
            IWorkspaceConnection iWorkspaceConnection = null;
            for (Map.Entry entry : hashMap.entrySet()) {
                ILogicalConflictReport iLogicalConflictReport = (ILogicalConflictReport)entry.getKey();
                ArrayList<ILogicalChange> arrayList = new ArrayList<ILogicalChange>();
                for (Object object : (List)entry.getValue()) {
                    if (iWorkspaceConnection == null) {
                        iWorkspaceConnection = AutoResolveOperation$AutoResolveRequest.access$0((AutoResolveOperation$AutoResolveRequest)object);
                    }
                    arrayList.add(AutoResolveOperation$AutoResolveRequest.access$1((AutoResolveOperation$AutoResolveRequest)object));
                }
                try {
                    Object object;
                    object = new ApplyAcceptedOperation(iWorkspaceConnection, iLogicalConflictReport, (Collection)arrayList, this.applyAcceptedDilemmaHandler);
                    this.disableVerifyInSync((IFileSystemOperation)object);
                    ((FileSystemOperation)object).run(iProgressMonitor);
                    n += arrayList.size();
                }
                catch (Exception exception) {
                    this.collectStatus(FileSystemStatus.getStatusFor(4, Messages.AutoResolveOperation_1, (Throwable)exception));
                }
            }
        }
        return n;
    }

    private Map fetchItems(IWorkspaceConnection iWorkspaceConnection, List list, ArrayList arrayList, ArrayList arrayList2, IProgressMonitor iProgressMonitor) throws TeamRepositoryException {
        List list2;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)(list.size() + arrayList.size()));
        HashMap<UUID, IVersionable> hashMap = new HashMap<UUID, IVersionable>();
        IWorkspaceManager iWorkspaceManager = SCMPlatform.getWorkspaceManager((ITeamRepository)iWorkspaceConnection.teamRepository());
        if (!list.isEmpty()) {
            list2 = iWorkspaceManager.versionableManager().fetchCompleteStates(list, (IProgressMonitor)subMonitor.newChild(list.size()));
            for (IVersionable iVersionable : list2) {
                hashMap.put(iVersionable.getStateId(), iVersionable);
            }
        }
        if (!arrayList.isEmpty()) {
            list2 = iWorkspaceManager.versionableManager().fetchCompleteStates((List)arrayList, (IProgressMonitor)subMonitor.newChild(arrayList.size()));
            for (IVersionable iVersionable : list2) {
                hashMap.put(iVersionable.getStateId(), iVersionable);
            }
        }
        if (!arrayList2.isEmpty()) {
            list2 = iWorkspaceManager.versionableManager().fetchCompleteStates((List)arrayList2, (IProgressMonitor)subMonitor.newChild(arrayList.size()));
            for (IVersionable iVersionable : list2) {
                hashMap.put(iVersionable.getStateId(), iVersionable);
            }
        }
        return hashMap;
    }

    private boolean performFilePropertyAutoMerge(IFileItem iFileItem, IFileItem iFileItem2, Shareable shareable, SubMonitor subMonitor) throws FileSystemClientException, TeamRepositoryException {
        boolean[] blArray = new boolean[]{true};
        AutoResolveOperation$2 autoResolveOperation$2 = new AutoResolveOperation$2(this, blArray);
        IChangeFilePropertiesOperation iChangeFilePropertiesOperation = null;
        IFileContent iFileContent = iFileItem2.getContent();
        IFileContent iFileContent2 = null;
        if (iFileItem != null) {
            iFileContent2 = iFileItem.getContent();
        }
        subMonitor.setWorkRemaining(100);
        String string = shareable.getContentType((IProgressMonitor)subMonitor.newChild(10));
        String string2 = iFileItem2.getContentType();
        String string3 = "";
        if (iFileItem != null) {
            string3 = iFileItem.getContentType();
        }
        if (!string3.equals(string2)) {
            if (string == null || string.equals(string3)) {
                iChangeFilePropertiesOperation = IOperationFactory.instance.getChangeFilePropertiesOperation(autoResolveOperation$2);
                iChangeFilePropertiesOperation.setContentType(shareable, string2);
            } else if (!string.equals(string2)) {
                blArray[0] = false;
            }
        }
        FileLineDelimiter fileLineDelimiter = shareable.getLineDelimiter((IProgressMonitor)subMonitor.newChild(10));
        FileLineDelimiter fileLineDelimiter2 = iFileContent.getLineDelimiter();
        FileLineDelimiter fileLineDelimiter3 = null;
        if (iFileContent2 != null) {
            fileLineDelimiter3 = iFileContent2.getLineDelimiter();
        }
        if (blArray[0] && fileLineDelimiter3 != fileLineDelimiter2) {
            if (fileLineDelimiter == null || fileLineDelimiter == fileLineDelimiter3) {
                if (iChangeFilePropertiesOperation == null) {
                    iChangeFilePropertiesOperation = IOperationFactory.instance.getChangeFilePropertiesOperation(autoResolveOperation$2);
                }
                iChangeFilePropertiesOperation.setLineDelimiter(shareable, fileLineDelimiter2);
            } else if (fileLineDelimiter != fileLineDelimiter2) {
                blArray[0] = false;
            }
        }
        if (blArray[0] && iChangeFilePropertiesOperation != null) {
            this.disableVerifyInSync(iChangeFilePropertiesOperation);
            iChangeFilePropertiesOperation.run((IProgressMonitor)subMonitor.newChild(80));
        }
        return blArray[0];
    }

    public void autoResolveConflict(IWorkspaceConnection iWorkspaceConnection, ILogicalConflictReport iLogicalConflictReport, ILogicalChange iLogicalChange) {
        if (iLogicalConflictReport == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (iLogicalChange == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (iWorkspaceConnection == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        IUpdateReport iUpdateReport = iLogicalConflictReport.conflictReport();
        Object object = null;
        for (Object object2 : iUpdateReport.conflicts()) {
            if (!object2.item().sameItemId((IItemHandle)iLogicalChange.item())) continue;
            object = object2;
            break;
        }
        if (object == null) {
            ++this.conflictsResolvedCount;
        } else {
            Object object2;
            object2 = new AutoResolveOperation$AutoResolveRequest(this, iWorkspaceConnection, iLogicalConflictReport, iLogicalChange, (IItemConflictReport)object);
            if (((AutoResolveOperation$AutoResolveRequest)object2).isContentConflict()) {
                this.addRequest(this.contentConflicts, (AutoResolveOperation$AutoResolveRequest)object2);
            } else if (((AutoResolveOperation$AutoResolveRequest)object2).isAutoMergeable()) {
                this.addRequest(this.autoMergeableConflicts, (AutoResolveOperation$AutoResolveRequest)object2);
            }
        }
    }

    private void addRequest(HashMap hashMap, AutoResolveOperation$AutoResolveRequest autoResolveOperation$AutoResolveRequest) {
        ArrayList<AutoResolveOperation$AutoResolveRequest> arrayList;
        IContextHandle iContextHandle = autoResolveOperation$AutoResolveRequest.getAffectedConfiguation().connectionHandle;
        HashMap<ILogicalConflictReport, ArrayList<AutoResolveOperation$AutoResolveRequest>> hashMap2 = (HashMap<ILogicalConflictReport, ArrayList<AutoResolveOperation$AutoResolveRequest>>)hashMap.get(iContextHandle.getItemId());
        if (hashMap2 == null) {
            hashMap2 = new HashMap<ILogicalConflictReport, ArrayList<AutoResolveOperation$AutoResolveRequest>>();
            hashMap.put(iContextHandle.getItemId(), hashMap2);
            arrayList = new ArrayList();
            hashMap2.put(AutoResolveOperation$AutoResolveRequest.access$3(autoResolveOperation$AutoResolveRequest), arrayList);
        } else {
            arrayList = (ArrayList<AutoResolveOperation$AutoResolveRequest>)hashMap2.get(AutoResolveOperation$AutoResolveRequest.access$3(autoResolveOperation$AutoResolveRequest));
            if (arrayList == null) {
                arrayList = new ArrayList<AutoResolveOperation$AutoResolveRequest>();
                hashMap2.put(AutoResolveOperation$AutoResolveRequest.access$3(autoResolveOperation$AutoResolveRequest), arrayList);
            }
        }
        arrayList.add(autoResolveOperation$AutoResolveRequest);
    }

    public void disableNonAtomicCommit() {
        this.nonAtomicCommitIsAnOption = false;
    }

    public void enableNonAtomicCommit(int n) {
        this.nonAtomicCommitIsAnOption = true;
        this.nonAtomicCommitFileUploadLimit = n;
    }

    static /* synthetic */ OutOfSyncDilemmaHandler access$0(AutoResolveOperation autoResolveOperation) {
        return autoResolveOperation.outOfSyncDilemmaHandler;
    }

    static /* synthetic */ Map access$1(AutoResolveOperation autoResolveOperation, Set set, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        return autoResolveOperation.getAffectedCFA(set, iProgressMonitor);
    }

    static /* synthetic */ int access$2(AutoResolveOperation autoResolveOperation) {
        return autoResolveOperation.conflictsResolvedCount;
    }

    static /* synthetic */ int access$3(AutoResolveOperation autoResolveOperation, Map map, IProgressMonitor iProgressMonitor) throws TeamRepositoryException, FileSystemClientException {
        return autoResolveOperation.performAutoMerge(map, iProgressMonitor);
    }

    static /* synthetic */ void access$4(AutoResolveOperation autoResolveOperation, int n) {
        autoResolveOperation.conflictsResolvedCount = n;
    }

    static /* synthetic */ AutoResolveConflictsDilemmaHandler access$5(AutoResolveOperation autoResolveOperation) {
        return autoResolveOperation.problemHandler;
    }
}

