/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.operations;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.internal.FileSystemManager;
import com.ibm.team.filesystem.client.internal.FileSystemServiceProxy;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.operations.ResolveConflictsOperation;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationDescriptor;
import com.ibm.team.filesystem.client.internal.utils.FlowNodeLock;
import com.ibm.team.filesystem.client.internal.utils.PathUtils;
import com.ibm.team.filesystem.client.internal.utils.WorkspaceLockUtil;
import com.ibm.team.filesystem.client.operations.ApplyAcceptedDilemmaHandler;
import com.ibm.team.filesystem.client.operations.IVerifyInSyncOperation;
import com.ibm.team.filesystem.client.operations.UpdateDilemmaHandler;
import com.ibm.team.filesystem.common.ILogicalChange;
import com.ibm.team.filesystem.common.ILogicalConflict;
import com.ibm.team.filesystem.common.ILogicalConflictReport;
import com.ibm.team.filesystem.common.internal.dto.ConflictResolution;
import com.ibm.team.filesystem.common.internal.dto.ConflictResolutionReport;
import com.ibm.team.filesystem.common.internal.dto.FilesystemDTOFactory;
import com.ibm.team.filesystem.common.internal.dto.LogicalConflict;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

public class ApplyAcceptedOperation
extends ResolveConflictsOperation {
    private HashMap parentForResolution;
    private final ApplyAcceptedDilemmaHandler problemHandler;

    public ApplyAcceptedOperation(IWorkspaceConnection iWorkspaceConnection, ILogicalConflictReport iLogicalConflictReport, Collection collection, ApplyAcceptedDilemmaHandler applyAcceptedDilemmaHandler) throws FileSystemClientException {
        super(iWorkspaceConnection, iLogicalConflictReport, collection, applyAcceptedDilemmaHandler == null ? ApplyAcceptedDilemmaHandler.getDefault() : applyAcceptedDilemmaHandler);
        this.problemHandler = applyAcceptedDilemmaHandler == null ? ApplyAcceptedDilemmaHandler.getDefault() : applyAcceptedDilemmaHandler;
        this.parentForResolution = new HashMap();
    }

    private boolean changeNeedsParentSpecification(ILogicalConflict iLogicalConflict) {
        if (iLogicalConflict.conflictType() == 2) {
            if (!this.isBeingUndone((IVersionableHandle)iLogicalConflict.parent())) {
                return !this.parentForResolution.containsKey(((LogicalConflict)iLogicalConflict).getId());
            }
        } else {
            if (iLogicalConflict.conflictType() == 10) {
                return !this.parentForResolution.containsKey(((LogicalConflict)iLogicalConflict).getId());
            }
            if (iLogicalConflict.conflictType() == 8) {
                for (IVersionableHandle iVersionableHandle : iLogicalConflict.conflictingItems()) {
                    if (!iVersionableHandle.sameItemId((IItemHandle)iLogicalConflict.parent()) || this.isBeingUndone((IVersionableHandle)iLogicalConflict.parent())) continue;
                    return !this.parentForResolution.containsKey(((LogicalConflict)iLogicalConflict).getId());
                }
            }
        }
        return false;
    }

    private boolean destinationInUse(ILogicalConflict iLogicalConflict) {
        IVersionableHandle iVersionableHandle;
        if (this.parentForResolution.containsKey(((LogicalConflict)iLogicalConflict).getId())) {
            return false;
        }
        if (iLogicalConflict.conflictType() == 7) {
            return this.isBeingUndone((IVersionableHandle)iLogicalConflict.conflictingItems().iterator().next());
        }
        if (iLogicalConflict.conflictType() == 1 && iLogicalConflict.conflictingItems().size() == 1 && !(iVersionableHandle = (IVersionableHandle)iLogicalConflict.conflictingItems().iterator().next()).sameItemId((IItemHandle)iLogicalConflict.item())) {
            return this.isBeingUndone(iVersionableHandle);
        }
        return false;
    }

    private boolean changeBlockedByContent(ILogicalConflict iLogicalConflict) {
        if (iLogicalConflict.conflictType() == 3) {
            for (IVersionableHandle iVersionableHandle : iLogicalConflict.conflictingItems()) {
                if (this.isBeingUndone(iVersionableHandle)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isBeingUndone(IVersionableHandle iVersionableHandle) {
        for (ILogicalChange iLogicalChange : this.changes) {
            if (!iLogicalChange.item().sameItemId((IItemHandle)iVersionableHandle) || !iLogicalChange.isChangeType(11)) continue;
            return true;
        }
        return false;
    }

    public void setParentForResolution(ILogicalConflict iLogicalConflict, IFolderHandle iFolderHandle, String string) {
        if (iLogicalConflict == null || !this.changeNeedsParentSpecification(iLogicalConflict)) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (iFolderHandle == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (string == null || string.length() == 0) {
            throw (Throwable)new IllegalArgumentException();
        }
        ConflictResolution conflictResolution = FilesystemDTOFactory.eINSTANCE.createConflictResolution();
        conflictResolution.setConflictType(iLogicalConflict.conflictType());
        conflictResolution.setItem(iLogicalConflict.item());
        conflictResolution.setParent(iFolderHandle);
        conflictResolution.setName(string);
        if (this.parentForResolution.put(((LogicalConflict)iLogicalConflict).getId(), conflictResolution) != null) {
            throw (Throwable)new IllegalArgumentException(Messages.ApplyAcceptedOperation_0);
        }
    }

    protected void execute(IProgressMonitor iProgressMonitor) throws FileSystemClientException, TeamRepositoryException {
        FileSystemServiceProxy fileSystemServiceProxy;
        Object object;
        if (this.changes.isEmpty()) {
            return;
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        IVerifyInSyncOperation iVerifyInSyncOperation = IOperationFactory.instance.getVerifyInSyncOperation(this.problemHandler.getOutOfSyncDilemmaHandler());
        Collection collection = this.getRequiredChanges();
        if (collection.size() > 0) {
            switch (this.problemHandler.missingRequiredChanges(collection)) {
                case 2: {
                    throw (Throwable)((Object)new FileSystemClientException(new FileSystemStatus(NLS.bind((String)Messages.ApplyAcceptedOperation_1, (Object)collection.size()))));
                }
                case 1: {
                    throw (Throwable)new OperationCanceledException();
                }
                case 0: {
                    this.changes.addAll(collection);
                }
            }
        }
        Object object2 = this.changes.iterator();
        while (object2.hasNext()) {
            object = (ILogicalChange)object2.next();
            if (object.kind() != 3) continue;
            object2.remove();
        }
        object2 = new HashSet();
        for (Object object3 : this.changes) {
            iVerifyInSyncOperation.addToVerify((IConnection)this.connection, object3.component());
            ((HashSet)object2).add(new ConfigurationDescriptor((IConnection)this.connection, object3.component()));
            if (!(object3 instanceof ILogicalConflict) || !this.changeNeedsParentSpecification((ILogicalConflict)(fileSystemServiceProxy = (ILogicalConflict)object3))) continue;
            throw (Throwable)((Object)new FileSystemClientException(new FileSystemStatus(4, NLS.bind((String)Messages.ApplyAcceptedOperation_2, (Object)PathUtils.getString(object3.getPathHint())))));
        }
        if (subMonitor.isCanceled()) {
            throw (Throwable)new OperationCanceledException();
        }
        object = WorkspaceLockUtil.acquireWrite((Collection)object2, (IProgressMonitor)subMonitor.newChild(1));
        try {
            List list;
            Object object3;
            if (this.verifyInSyncEnabled() && !this.problemHandler.getOutOfSyncDilemmaHandler().willIgnoreAllSharesOutOfSync()) {
                iVerifyInSyncOperation.run((IProgressMonitor)subMonitor.newChild(4));
            }
            if (subMonitor.isCanceled()) {
                throw (Throwable)new OperationCanceledException();
            }
            object3 = FileSystemCore.getFileSystemManager(this.connection.teamRepository());
            fileSystemServiceProxy = ((FileSystemManager)object3).getFileSystemService();
            try {
                list = fileSystemServiceProxy.applyAccepted(this.connection, this.changes, this.parentForResolution.values(), (IProgressMonitor)subMonitor.newChild(45));
            }
            catch (TeamRepositoryException teamRepositoryException) {
                if (teamRepositoryException.getData() instanceof ConflictResolutionReport) {
                    this.collectStatus(new FileSystemStatus(4, teamRepositoryException.getMessage()));
                    this.updateCopyFileArea((ConflictResolutionReport)teamRepositoryException.getData(), (UpdateDilemmaHandler)this.problemHandler, (IProgressMonitor)subMonitor.newChild(50));
                }
                throw (Throwable)teamRepositoryException;
            }
            if (!list.isEmpty()) {
                this.updateCopyFileArea(list, (UpdateDilemmaHandler)this.problemHandler, (IProgressMonitor)subMonitor.newChild(50));
            }
        }
        finally {
            WorkspaceLockUtil.release((FlowNodeLock)object);
        }
    }

    public Collection needParentForResolution() {
        ArrayList<ILogicalChange> arrayList = new ArrayList<ILogicalChange>();
        for (ILogicalChange iLogicalChange : this.changes) {
            if (!(iLogicalChange instanceof ILogicalConflict)) continue;
            ILogicalConflict iLogicalConflict = (ILogicalConflict)iLogicalChange;
            if (this.changeNeedsParentSpecification(iLogicalConflict)) {
                arrayList.add(iLogicalChange);
                continue;
            }
            if (!this.destinationInUse(iLogicalConflict)) continue;
            arrayList.add(iLogicalChange);
        }
        return arrayList;
    }

    public Collection needContentToRemoved() {
        ArrayList<ILogicalChange> arrayList = new ArrayList<ILogicalChange>();
        for (ILogicalChange iLogicalChange : this.changes) {
            ILogicalConflict iLogicalConflict;
            if (!(iLogicalChange instanceof ILogicalConflict) || !this.destinationInUse(iLogicalConflict = (ILogicalConflict)iLogicalChange) && !this.changeBlockedByContent(iLogicalConflict)) continue;
            arrayList.add(iLogicalChange);
        }
        return arrayList;
    }
}

