/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.operations;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.operations.FileSystemOperation;
import com.ibm.team.filesystem.client.operations.LockDilemmaHandler;
import com.ibm.team.filesystem.client.operations.LockEntry;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.LockOperationFailureException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.SubMonitor;

public abstract class AbstractLockOperation
extends FileSystemOperation {
    private Map repoBatch = new HashMap();

    public AbstractLockOperation(LockDilemmaHandler lockDilemmaHandler) {
        super(lockDilemmaHandler == null ? new LockDilemmaHandler() : lockDilemmaHandler);
    }

    protected LockEntry add(IWorkspaceConnection iWorkspaceConnection, IComponentHandle iComponentHandle, IVersionableHandle iVersionableHandle, IContributorHandle iContributorHandle) {
        LockEntry lockEntry = new LockEntry(iWorkspaceConnection, iComponentHandle, iVersionableHandle, iContributorHandle);
        this.addLockEntry(lockEntry);
        return lockEntry;
    }

    protected void addLockEntry(LockEntry lockEntry) {
        ITeamRepository iTeamRepository = lockEntry.getRepository();
        ArrayList<LockEntry> arrayList = (ArrayList<LockEntry>)this.repoBatch.get(iTeamRepository);
        if (arrayList == null) {
            arrayList = new ArrayList<LockEntry>();
            this.repoBatch.put(iTeamRepository, arrayList);
        }
        arrayList.add(lockEntry);
    }

    /*
     * Unable to fully structure code
     */
    protected void execute(IProgressMonitor var1_1) throws FileSystemClientException, TeamRepositoryException {
        var2_2 = SubMonitor.convert((IProgressMonitor)var1_1, (int)(this.repoBatch.size() * 2));
        for (Map.Entry<K, V> var3_4 : this.repoBatch.entrySet()) {
            var5_5 = (List)var3_4.getValue();
            var6_6 = SCMPlatform.getWorkspaceManager((ITeamRepository)((ITeamRepository)var3_4.getKey()));
            var7_7 = var2_2.newChild(1);
            var7_7.setTaskName(Messages.AbstractLockOperation_0);
            var8_8 = this.getLockOperations(var6_6, var5_5, (IProgressMonitor)var7_7);
            var7_7 = var2_2.newChild(1);
            var7_7.setTaskName(Messages.AbstractLockOperation_1);
            try {
                var6_6.applyLockOperations((Collection)var8_8, (IProgressMonitor)var7_7);
                continue;
            }
            catch (LockOperationFailureException var9_9) {
                var10_10 = var9_9.getMessage().split("\r\n|\r|\n");
                if (var10_10.length == 1) {
                    throw (Throwable)var9_9;
                }
                var11_11 = new IStatus[var10_10.length];
                var12_12 = 0;
                ** while (var12_12 < var10_10.length)
            }
lbl-1000:
            // 1 sources

            {
                var11_11[var12_12] = new FileSystemStatus(var10_10[var12_12]);
                ++var12_12;
                continue;
            }
lbl23:
            // 1 sources

            var12_13 = new MultiStatus("com.ibm.team.filesystem.client", 4, var11_11, "Lock operation failed", null);
            throw (Throwable)new FileSystemClientException((IStatus)var12_13);
        }
    }

    private List getLockOperations(IWorkspaceManager iWorkspaceManager, List list, IProgressMonitor iProgressMonitor) throws TeamRepositoryException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)list.size());
        IWorkspaceManager.IVersionableLockOperationFactory iVersionableLockOperationFactory = iWorkspaceManager.lockOperationFactory();
        ArrayList<IWorkspaceManager.IVersionableLockOperation> arrayList = new ArrayList<IWorkspaceManager.IVersionableLockOperation>();
        for (LockEntry lockEntry : list) {
            IWorkspaceConnection iWorkspaceConnection;
            IWorkspaceManager.IVersionableLockOperation iVersionableLockOperation = this.getLockOperation(iVersionableLockOperationFactory, lockEntry, iWorkspaceConnection = iWorkspaceManager.getWorkspaceConnection(lockEntry.getStream(), (IProgressMonitor)subMonitor.newChild(1)));
            if (iVersionableLockOperation == null) continue;
            arrayList.add(iVersionableLockOperation);
        }
        return arrayList;
    }

    protected Map getRepositoryBatch() {
        return this.repoBatch;
    }

    protected abstract IWorkspaceManager.IVersionableLockOperation getLockOperation(IWorkspaceManager.IVersionableLockOperationFactory var1, LockEntry var2, IWorkspaceConnection var3);

    protected int checkLockOwners() {
        HashMap<ITeamRepository, ArrayList<LockEntry>> hashMap = new HashMap<ITeamRepository, ArrayList<LockEntry>>();
        for (Map.Entry object2 : this.getRepositoryBatch().entrySet()) {
            ITeamRepository iTeamRepository = (ITeamRepository)object2.getKey();
            for (LockEntry lockEntry : (List)object2.getValue()) {
                IContributorHandle iContributorHandle = lockEntry.getContributor();
                if (iContributorHandle != null && iContributorHandle.sameItemId((IItemHandle)iTeamRepository.loggedInContributor())) continue;
                ArrayList<LockEntry> arrayList = (ArrayList<LockEntry>)hashMap.get(iTeamRepository);
                if (arrayList == null) {
                    arrayList = new ArrayList<LockEntry>();
                    hashMap.put(iTeamRepository, arrayList);
                }
                arrayList.add(lockEntry);
            }
        }
        LockDilemmaHandler lockDilemmaHandler = (LockDilemmaHandler)this.getDilemmaHandler();
        int n = !hashMap.isEmpty() ? lockDilemmaHandler.currentUserDoesntOwnLock(hashMap) : 3;
        return n;
    }
}

