/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.namespace.impl;

import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.dto.IChangeSetLinkSummary;
import com.ibm.team.scm.common.links.ChangeSetLocationFactory;
import org.eclipse.osgi.util.NLS;

public class DescriptionRecord {
    public static final int TYPE_CHANGE = 0;
    public static final int TYPE_DEFECT = 1;
    public static final int TYPE_DEFECTS = 2;
    private IChangeSet changeSet;
    private IChangeSetLinkSummary linkSummary;
    public static final DescriptionRecord DELETED_DESCRIPTION = new DescriptionRecord(null, null){

        public String getDescription() {
            return Messages.EraCache_0;
        }

        public int getWorkItemType() {
            return 0;
        }

        public boolean isComplete() {
            return true;
        }
    };

    public DescriptionRecord(IChangeSet changeSet, IChangeSetLinkSummary linkSummary) {
        this.changeSet = changeSet;
        this.linkSummary = linkSummary;
    }

    public String getDescription() {
        String comment = this.changeSet.getComment();
        if (this.linkSummary == null) {
            return comment;
        }
        String linkComment = this.linkSummary.getSummary();
        if (linkComment.length() > 0) {
            if (comment.length() == 0) {
                return linkComment;
            }
            return NLS.bind((String)Messages.EraCache_2, (Object)linkComment, (Object)ChangeSetLocationFactory.replaceLineEnding((String)comment.trim(), (String)" "));
        }
        return ChangeSetLocationFactory.getFullContextLabel((IChangeSet)this.changeSet);
    }

    public IChangeSet getChangeSet() {
        return this.changeSet;
    }

    public IChangeSetLinkSummary getChangeSetLinkSummary() {
        return this.linkSummary;
    }

    public int getWorkItemType() {
        if (this.linkSummary == null) {
            return 0;
        }
        if (this.linkSummary.getLinks().isEmpty()) {
            return 0;
        }
        if (this.linkSummary.getLinks().size() == 1) {
            return 1;
        }
        return 2;
    }

    public boolean isComplete() {
        return !this.changeSet.isActive();
    }
}

