/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.namespace.impl;

import com.ibm.team.filesystem.client.internal.ClientRepositoryUtil;
import com.ibm.team.filesystem.client.internal.era.DeliveryInfo;
import com.ibm.team.filesystem.client.internal.era.EraDescriptor;
import com.ibm.team.filesystem.client.internal.namespace.AbstractContext;
import com.ibm.team.filesystem.client.internal.namespace.IConfigurationWrapper;
import com.ibm.team.filesystem.client.internal.namespace.IContextHistory;
import com.ibm.team.filesystem.client.internal.namespace.IItemContext;
import com.ibm.team.filesystem.client.internal.namespace.ItemFetcher;
import com.ibm.team.filesystem.client.internal.namespace.ItemNamespace;
import com.ibm.team.filesystem.client.util.ConnectionUtil;
import com.ibm.team.filesystem.common.changemodel.VersionablePath;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.common.collection.SoftValueMap;
import com.ibm.team.scm.client.IConfiguration;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.internal.RepoFetcher;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.internal.util.FetchProfile;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.ItemLists;
import com.ibm.team.scm.common.internal.util.NewCollection;
import com.ibm.team.scm.common.internal.util.SiloedItemId;
import com.ibm.team.scm.common.internal.util.StateId;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractConfigurationContext
extends AbstractContext
implements IContextHistory,
IConfigurationWrapper {
    private ItemId<IFolder> rootFolder = null;
    private SoftValueMap<UUID, UUID> uuidCache = new SoftValueMap();

    public AbstractConfigurationContext(ItemNamespace namespace) {
        super(namespace);
    }

    @Override
    public abstract IConfiguration getConfiguration();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void flushStateCache() {
        SoftValueMap<UUID, UUID> softValueMap = this.uuidCache;
        synchronized (softValueMap) {
            this.uuidCache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends IItem> Map<ItemId<T>, StateId<T>> getStates(Collection<ItemId<T>> itemIds, boolean shouldRefresh, IProgressMonitor rep) throws TeamRepositoryException {
        HashMap<ItemId<T>, StateId<T>> result = new HashMap<ItemId<T>, StateId<T>>();
        HashSet<ItemId<T>> toFetch = new HashSet<ItemId<T>>();
        SoftValueMap<UUID, UUID> softValueMap = this.uuidCache;
        synchronized (softValueMap) {
            for (ItemId<T> next : itemIds) {
                UUID state = (UUID)this.uuidCache.get((Object)next.getItemUUID());
                if (shouldRefresh || state == null) {
                    toFetch.add(next);
                    continue;
                }
                result.put(next, new StateId(next, state));
            }
        }
        IConfiguration configuration = this.getConfiguration();
        if (configuration == null) {
            for (ItemId<T> next : itemIds) {
                result.put(next, StateId.getDeletedState(next));
            }
        } else {
            result.putAll(RepoFetcher.fetchStateIds((IConfiguration)configuration, toFetch, (boolean)shouldRefresh, (IProgressMonitor)rep));
        }
        SoftValueMap<UUID, UUID> softValueMap2 = this.uuidCache;
        synchronized (softValueMap2) {
            for (StateId next : result.values()) {
                this.uuidCache.put((Object)next.getItemUUID(), (Object)next.getStateUUID());
            }
        }
        return result;
    }

    @Override
    public <T extends IItem> Map<ItemId<T>, T> fetchCurrents(Collection<ItemId<T>> itemIds, FetchProfile profile, boolean shouldRefresh, IProgressMonitor monitor) throws TeamRepositoryException {
        IConfiguration configuration = this.getConfiguration();
        if (configuration == null) {
            return Collections.emptyMap();
        }
        return RepoFetcher.fetchCurrents((IConfiguration)configuration, itemIds, (boolean)shouldRefresh, (IProgressMonitor)monitor);
    }

    @Override
    public IConfigurationWrapper getVersionableTree() {
        return this;
    }

    @Override
    public ItemId<IFolder> getRoot(IProgressMonitor monitor) throws TeamRepositoryException {
        IConfiguration configuration = this.getConfiguration();
        if (configuration == null) {
            return ItemId.getNullItem((IItemType)IFolder.ITEM_TYPE);
        }
        if (this.rootFolder == null) {
            this.rootFolder = new ItemId((IItemHandle)configuration.rootFolderHandle(monitor));
        }
        return this.rootFolder;
    }

    @Override
    public String getNameOf(ItemId handle, IProgressMonitor mon) throws TeamRepositoryException {
        SubMonitor rep = SubMonitor.convert((IProgressMonitor)mon, (int)100);
        IVersionable item = (IVersionable)ItemFetcher.fetchCurrent(this.getContext(), handle, FetchProfile.createFullProfile(), false, (IProgressMonitor)rep.newChild(25));
        return item.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, ItemId<IVersionable>> fetchChildren(ItemId<IFolder> folder, IProgressMonitor rep) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)rep, (int)100);
        IConfiguration configuration = this.getConfiguration();
        if (configuration == null) {
            return Collections.emptyMap();
        }
        try {
            Map childEntries = configuration.childEntries((IFolderHandle)folder.toHandle(), (IProgressMonitor)progress.newChild(100));
            HashMap result = NewCollection.hashMap();
            SoftValueMap<UUID, UUID> softValueMap = this.uuidCache;
            synchronized (softValueMap) {
                for (Map.Entry next : childEntries.entrySet()) {
                    IVersionableHandle nextVersionable = (IVersionableHandle)next.getValue();
                    result.put((String)next.getKey(), new ItemId((IItemHandle)nextVersionable));
                    this.uuidCache.put((Object)nextVersionable.getItemId(), (Object)nextVersionable.getStateId());
                }
            }
            return result;
        }
        catch (ItemNotFoundException itemNotFoundException) {
            return NewCollection.hashMap();
        }
    }

    @Override
    public List<DeliveryInfo> findChangeSetsAffecting(ItemId<?> item, int maxResults, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ClientRepositoryUtil.checkCanceled(monitor);
        EraDescriptor context = this.getChangeSets((IProgressMonitor)progress.newChild(10));
        if (context == null) {
            return Collections.emptyList();
        }
        ClientRepositoryUtil.checkCanceled(monitor);
        return context.findChangeSetsAffecting(item, maxResults, monitor);
    }

    @Override
    public IContextHistory getHistory() {
        return this;
    }

    @Override
    public IItemContext getContext() {
        return this;
    }

    @Override
    public Collection<ItemId<IChangeSet>> changeSetsInHistory(Collection<ItemId<IChangeSet>> singleton, IProgressMonitor monitor) throws TeamRepositoryException {
        IConnection connection = this.getConnection();
        List handles = connection.changeSetsInHistory(ItemLists.idsToHandles(singleton), monitor);
        return ItemLists.handlesToIds((Collection)handles);
    }

    @Override
    public Map<ItemId<IVersionable>, VersionablePath> resolve(Collection<ItemId<IVersionable>> versionables, IProgressMonitor monitor) throws TeamRepositoryException {
        IConfiguration config = this.getConfiguration();
        if (config == null) {
            HashMap<ItemId<IVersionable>, VersionablePath> result = new HashMap<ItemId<IVersionable>, VersionablePath>();
            for (ItemId<IVersionable> next : versionables) {
                result.put(next, VersionablePath.create(Collections.emptyList(), (SiloedItemId)SiloedItemId.create(next, this.getComponent()), (boolean)false, (boolean)false));
            }
            return result;
        }
        return ConnectionUtil.resolvePaths(config, versionables, monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean stateCacheEmpty() {
        SoftValueMap<UUID, UUID> softValueMap = this.uuidCache;
        synchronized (softValueMap) {
            return this.uuidCache.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void discardStates(Collection<ItemId<IVersionable>> toDiscard) {
        SoftValueMap<UUID, UUID> softValueMap = this.uuidCache;
        synchronized (softValueMap) {
            for (ItemId<IVersionable> next : toDiscard) {
                this.uuidCache.remove((Object)next.getItemUUID());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateStates(Collection<StateId<IVersionable>> toAdd) {
        SoftValueMap<UUID, UUID> softValueMap = this.uuidCache;
        synchronized (softValueMap) {
            for (StateId<IVersionable> next : toAdd) {
                this.uuidCache.put((Object)next.getItemUUID(), (Object)next.getStateUUID());
            }
        }
    }
}

