/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.magic;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.IContentExaminer;
import com.ibm.team.filesystem.client.IContentExaminer$IStreamSource;
import com.ibm.team.filesystem.client.IContentProperties;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.magic.ContentProperties;
import com.ibm.team.filesystem.client.internal.magic.LocalContentExaminer$1;
import com.ibm.team.filesystem.client.internal.magic.LocalContentExaminer$2;
import com.ibm.team.filesystem.client.internal.magic.LocalContentExaminer$3;
import com.ibm.team.filesystem.client.internal.magic.LocalContentExaminer$State;
import com.ibm.team.filesystem.client.internal.magic.MagicPattern;
import com.ibm.team.filesystem.client.internal.utils.PropertiesLoader;
import com.ibm.team.filesystem.common.FileLineDelimiter;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

public class LocalContentExaminer
implements IContentExaminer {
    private static final String PROP_MIME = "mime";
    private static final String PROP_DELIM = "delim";
    private static final String PROP_ENCODING = "encoding";
    private static final String PROP_CASE = "respectcase";
    private static final String MAGIC_SOURCE_DEFAULT = "/resources/magic.default.properties";
    public static final String MAGIC_SOURCE_USER_FILENAME = "magic.properties";
    public static final byte[] BOM_UTF_8 = new byte[]{-17, -69, -65};
    public static final byte[] BOM_UTF_16BE = new byte[]{-2, -1};
    public static final byte[] BOM_UTF_16LE = new byte[]{-1, -2};
    private static volatile LocalContentExaminer instance = new LocalContentExaminer();
    private final File userDir;
    private List matchers = null;
    private static final MagicPattern UNKNOWN = new MagicPattern("", true, ContentProperties.UNKNOWN.getMimeType(), ContentProperties.UNKNOWN.getLineDelimiter(), null, true);
    private static final char ESCAPE = '\\';
    private static final char QUOTE = '\"';
    private static final char SEMI = ';';

    public static FileLineDelimiter getLineDelimiter(String string) {
        if ("lf".equals(string)) {
            return FileLineDelimiter.LINE_DELIMITER_LF;
        }
        if ("cr".equals(string)) {
            return FileLineDelimiter.LINE_DELIMITER_CR;
        }
        if ("crlf".equals(string)) {
            return FileLineDelimiter.LINE_DELIMITER_CRLF;
        }
        if ("platform".equals(string)) {
            return FileLineDelimiter.LINE_DELIMITER_PLATFORM;
        }
        if ("none".equals(string)) {
            return FileLineDelimiter.LINE_DELIMITER_NONE;
        }
        throw (Throwable)new IllegalArgumentException(NLS.bind((String)"{0} has value {1} which is not one of {2}, {3}, {4}, {5}, {6}", (Object[])new Object[]{"lineDelimiter", string, "lf", "cr", "crlf", "platform", "none"}));
    }

    public static String getLineDelimiter(FileLineDelimiter fileLineDelimiter) {
        if (fileLineDelimiter == null) {
            return "";
        }
        switch (fileLineDelimiter) {
            case LINE_DELIMITER_PLATFORM: {
                return "platform";
            }
            case LINE_DELIMITER_CRLF: {
                return "crlf";
            }
            case LINE_DELIMITER_LF: {
                return "lf";
            }
            case LINE_DELIMITER_CR: {
                return "cr";
            }
            case LINE_DELIMITER_NONE: {
                return "none";
            }
        }
        return "";
    }

    public static IContentExaminer getInstance() {
        return instance;
    }

    public LocalContentExaminer(String string) {
        File file = new File(FileSystemCore.USER_DIR);
        if (string != null && !(file = new File(string)).exists()) {
            file = null;
        }
        this.userDir = file;
    }

    public LocalContentExaminer() {
        this(FileSystemCore.USER_DIR);
    }

    public synchronized List getMatchers(IProgressMonitor iProgressMonitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)1);
        if (this.matchers != null) {
            return this.matchers;
        }
        subMonitor.beginTask(Messages.LocalContentExaminer_LOAD_PROGRESS_MESSAGE, 4);
        this.matchers = new ArrayList();
        InputStream inputStream = this.getUserPatternStream(subMonitor.newChild(1));
        if (inputStream != null) {
            subMonitor.setTaskName(Messages.LocalContentExaminer_LOAD_SUBTASK_USER);
            this.matchers.addAll(this.parseStream(inputStream, false, subMonitor.newChild(1)));
        }
        subMonitor.setWorkRemaining(2);
        inputStream = this.getBasePatternStream(subMonitor.newChild(1));
        if (inputStream != null) {
            subMonitor.setTaskName(Messages.LocalContentExaminer_LOAD_SUBTASK_DEFAULTS);
            this.matchers.addAll(this.parseStream(inputStream, true, subMonitor.newChild(1)));
        }
        return this.matchers;
    }

    public synchronized void setMatchers(List list, IProgressMonitor iProgressMonitor) throws IOException {
        Object object2;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)2);
        this.matchers = new ArrayList();
        for (Object object2 : list) {
            if (!((MagicPattern)object2).isBuiltIn()) continue;
            throw (Throwable)new IllegalArgumentException();
        }
        this.matchers.addAll(list);
        subMonitor.setWorkRemaining(2);
        object2 = this.getBasePatternStream(subMonitor.newChild(1));
        if (object2 != null) {
            subMonitor.setTaskName(Messages.LocalContentExaminer_LOAD_SUBTASK_DEFAULTS);
            this.matchers.addAll(this.parseStream((InputStream)object2, true, subMonitor.newChild(1)));
        }
        File file = new File(this.userDir, MAGIC_SOURCE_USER_FILENAME);
        file.getParentFile().mkdirs();
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file, false), "UTF-8"));
        try {
            bufferedWriter.write("### Jazz Magic 0");
            bufferedWriter.newLine();
            for (MagicPattern magicPattern : list) {
                bufferedWriter.append(LocalContentExaminer.escapePattern(magicPattern.getPattern()));
                bufferedWriter.append(": ");
                boolean bl = false;
                if (magicPattern.getMimeType() != null) {
                    this.writeSep(bufferedWriter, bl);
                    bufferedWriter.append(PROP_MIME);
                    bufferedWriter.append(": ");
                    bufferedWriter.append(LocalContentExaminer.escapeValue(magicPattern.getMimeType()));
                    bl = true;
                }
                if (magicPattern.getEncoding() != null) {
                    this.writeSep(bufferedWriter, bl);
                    bufferedWriter.append(PROP_ENCODING);
                    bufferedWriter.append(": ");
                    bufferedWriter.append(LocalContentExaminer.escapeValue(magicPattern.getEncoding()));
                    bl = true;
                }
                if (magicPattern.getDelim() != null && magicPattern.getDelim() != FileLineDelimiter.LINE_DELIMITER_NONE) {
                    this.writeSep(bufferedWriter, bl);
                    bufferedWriter.append(PROP_DELIM);
                    bufferedWriter.append(": ");
                    bufferedWriter.write(LocalContentExaminer.getLineDelimiter(magicPattern.getDelim()));
                    bl = true;
                }
                if (!magicPattern.matcher.isIgnoreCase()) {
                    this.writeSep(bufferedWriter, bl);
                    bufferedWriter.append(PROP_CASE);
                    bufferedWriter.append(": true");
                    bl = true;
                }
                bufferedWriter.newLine();
            }
        }
        finally {
            bufferedWriter.close();
        }
    }

    void writeSep(BufferedWriter bufferedWriter, boolean bl) throws IOException {
        if (bl) {
            bufferedWriter.append("; ");
        }
    }

    private static String escapePattern(String string) {
        return string;
    }

    private static String escapeValue(String string) {
        boolean bl = false;
        if (string.contains("\"")) {
            string = string.replace("\"", "\\\"");
            bl = true;
        }
        if (bl || string.contains(";")) {
            return "\"" + string + "\"";
        }
        return string;
    }

    private InputStream getUserPatternStream(SubMonitor subMonitor) {
        if (this.userDir == null || !this.userDir.exists()) {
            return null;
        }
        File file = new File(this.userDir, MAGIC_SOURCE_USER_FILENAME);
        if (!file.exists()) {
            return null;
        }
        try {
            return new FileInputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            LoggingHelper.log(FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.LocalContentExaminer_COULD_NOT_OPEN_MAGIC_FILE, (Object)file.getAbsolutePath()), (Throwable)fileNotFoundException));
            return null;
        }
    }

    private List parseStream(InputStream inputStream, boolean bl, SubMonitor subMonitor) {
        LinkedHashMap linkedHashMap;
        block12: {
            subMonitor = SubMonitor.convert((IProgressMonitor)((IProgressMonitor)subMonitor), (int)10);
            linkedHashMap = new LinkedHashMap();
            try {
                try {
                    PropertiesLoader.load(linkedHashMap, inputStream, "UTF-8", -1L, (IProgressMonitor)subMonitor.newChild(9));
                }
                catch (IOException iOException) {
                    LoggingHelper.log(FileSystemStatus.getStatusFor(4, "Couldn't load base magic file", (Throwable)iOException));
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException2) {}
                    break block12;
                }
            }
            catch (Throwable throwable) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
        subMonitor.setWorkRemaining(linkedHashMap.size());
        ArrayList<MagicPattern> arrayList = new ArrayList<MagicPattern>(linkedHashMap.size());
        for (Map.Entry entry : linkedHashMap.entrySet()) {
            MagicPattern magicPattern = this.parseTemplate((String)entry.getKey(), (String)entry.getValue(), bl, subMonitor.newChild(1));
            if (magicPattern == null) continue;
            arrayList.add(magicPattern);
        }
        return arrayList;
    }

    private StringBuffer convertToPropsFile(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        LocalContentExaminer$State localContentExaminer$State = LocalContentExaminer$State.BARE;
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            block0 : switch (localContentExaminer$State) {
                case BARE: {
                    switch (c) {
                        case '\"': {
                            localContentExaminer$State = LocalContentExaminer$State.QUOTED;
                            break block0;
                        }
                        case ';': {
                            stringBuffer.append("\n");
                            break block0;
                        }
                    }
                    stringBuffer.append(c);
                    break;
                }
                case QUOTED: {
                    switch (c) {
                        case '\\': {
                            localContentExaminer$State = LocalContentExaminer$State.ESCAPED;
                            break block0;
                        }
                        case '\"': {
                            localContentExaminer$State = LocalContentExaminer$State.BARE;
                            break block0;
                        }
                    }
                    stringBuffer.append(c);
                    break;
                }
                case ESCAPED: {
                    stringBuffer.append(c);
                    localContentExaminer$State = LocalContentExaminer$State.QUOTED;
                }
            }
            ++n;
        }
        return stringBuffer;
    }

    private MagicPattern parseTemplate(String string, String string2, boolean bl, SubMonitor subMonitor) {
        FileLineDelimiter fileLineDelimiter;
        String string3 = this.convertToPropsFile(string2).toString();
        HashMap hashMap = new HashMap();
        try {
            PropertiesLoader.load(hashMap, new ByteArrayInputStream(string3.getBytes("UTF-8")), "UTF-8", -1L, (IProgressMonitor)subMonitor);
        }
        catch (IOException iOException) {
            LoggingHelper.log(FileSystemStatus.getStatusFor(4, -1, NLS.bind((String)Messages.LocalContentExaminer_FAILED_TO_PARSE, (Object)string), iOException));
            return null;
        }
        String string4 = (String)hashMap.get(PROP_MIME);
        String string5 = (String)hashMap.get(PROP_DELIM);
        if (string5 == null) {
            fileLineDelimiter = null;
        } else {
            try {
                fileLineDelimiter = LocalContentExaminer.getLineDelimiter(string5);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                LoggingHelper.log(FileSystemStatus.getStatusFor(4, -1, NLS.bind((String)Messages.LocalContentExaminer_UNRECOGNIZED_VALUE, (Object[])new String[]{PROP_DELIM, string, string5}), null));
                fileLineDelimiter = null;
            }
        }
        string5 = (String)hashMap.get(PROP_ENCODING);
        boolean bl2 = false;
        if (hashMap.containsKey(PROP_CASE)) {
            bl2 = ((String)hashMap.get(PROP_CASE)).trim().toLowerCase().equals("true");
        }
        return new MagicPattern(string, !bl2, string4, fileLineDelimiter, string5, bl);
    }

    private InputStream getBasePatternStream(SubMonitor subMonitor) {
        InputStream inputStream = this.getClass().getResourceAsStream(MAGIC_SOURCE_DEFAULT);
        if (inputStream == null) {
            LoggingHelper.log(FileSystemStatus.getStatusFor(4, "Could not open default magic file", null));
        }
        return inputStream;
    }

    public IContentProperties examine(String string, IContentExaminer$IStreamSource iContentExaminer$IStreamSource, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)10);
        List list = this.getMagicMatchers(string, (IProgressMonitor)subMonitor.newChild(5));
        String string2 = this.getMimeType(list);
        FileLineDelimiter fileLineDelimiter = this.getLineDelimiter(list);
        String string3 = this.getEncoding(string, iContentExaminer$IStreamSource, (IProgressMonitor)subMonitor.newChild(5));
        if (string3 == null) {
            string3 = System.getProperty("file.encoding");
        }
        return new ContentProperties(string3, string2, fileLineDelimiter);
    }

    public IContentProperties examine(IShareable iShareable, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        return this.examine(iShareable.getLocalPath().lastSegment(), new LocalContentExaminer$1(this, iShareable), iProgressMonitor);
    }

    public IContentProperties findStoredProperties(IShareable iShareable, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        String string;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        File file = (File)iShareable.getAdapter(File.class);
        ResourceType resourceType = iShareable.getResourceType((IProgressMonitor)subMonitor.newChild(1));
        if (file == null || resourceType == null) {
            return ContentProperties.UNKNOWN;
        }
        String string2 = iShareable.getContentType((IProgressMonitor)subMonitor.newChild(25));
        FileLineDelimiter fileLineDelimiter = iShareable.getLineDelimiter((IProgressMonitor)subMonitor.newChild(25));
        if (string2 == null || fileLineDelimiter == null) {
            IContentProperties iContentProperties = this.examine(iShareable, (IProgressMonitor)subMonitor.newChild(50));
            if (string2 == null) {
                string2 = iContentProperties.getMimeType();
            }
            if (fileLineDelimiter == null) {
                fileLineDelimiter = iContentProperties.getLineDelimiter();
            }
            string = iContentProperties.getEncoding();
        } else {
            LocalContentExaminer$2 localContentExaminer$2 = new LocalContentExaminer$2(this, file, resourceType);
            string = this.getEncoding(iShareable.getLocalPath().lastSegment(), localContentExaminer$2, (IProgressMonitor)subMonitor.newChild(50));
        }
        if (string == null) {
            string = System.getProperty("file.encoding");
        }
        return new ContentProperties(string, string2, fileLineDelimiter);
    }

    public String getEncoding(IShareable iShareable, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)10);
        File file = (File)iShareable.getAdapter(File.class);
        ResourceType resourceType = iShareable.getResourceType((IProgressMonitor)subMonitor);
        String string = null;
        LocalContentExaminer$3 localContentExaminer$3 = new LocalContentExaminer$3(this, file, resourceType);
        string = this.getEncoding(iShareable.getLocalPath().lastSegment(), localContentExaminer$3, (IProgressMonitor)subMonitor.newChild(10));
        if (string == null) {
            string = System.getProperty("file.encoding");
        }
        return string;
    }

    private String getEncoding(String string, IContentExaminer$IStreamSource iContentExaminer$IStreamSource, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        String string2 = null;
        if (iContentExaminer$IStreamSource != null) {
            string2 = LocalContentExaminer.sniffEncoding(iContentExaminer$IStreamSource);
        }
        if (string2 == null) {
            List list = this.getMagicMatchers(string, iProgressMonitor);
            string2 = this.getEncoding(list);
        }
        return string2;
    }

    private List getMagicMatchers(String string, IProgressMonitor iProgressMonitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        List list = this.getMatchers((IProgressMonitor)subMonitor.newChild(9));
        ArrayList<MagicPattern> arrayList = new ArrayList<MagicPattern>(1);
        subMonitor.setWorkRemaining(list.size());
        for (MagicPattern magicPattern : list) {
            if (magicPattern.matcher.match(string)) {
                arrayList.add(magicPattern);
            }
            subMonitor.worked(1);
        }
        if (arrayList.size() == 0) {
            arrayList.add(UNKNOWN);
        }
        return arrayList;
    }

    private FileLineDelimiter getLineDelimiter(List list) {
        FileLineDelimiter fileLineDelimiter = FileLineDelimiter.LINE_DELIMITER_NONE;
        for (MagicPattern magicPattern : list) {
            if (magicPattern.delim == null) continue;
            fileLineDelimiter = magicPattern.delim;
            break;
        }
        return fileLineDelimiter;
    }

    private String getMimeType(List list) {
        String string = "application/unknown";
        for (MagicPattern magicPattern : list) {
            if (magicPattern.mimeType == null) continue;
            string = magicPattern.mimeType;
            break;
        }
        return string;
    }

    private String getEncoding(List list) {
        for (MagicPattern magicPattern : list) {
            if (magicPattern.encoding == null) continue;
            return magicPattern.encoding;
        }
        return null;
    }

    /*
     * Loose catch block
     */
    public static String sniffEncoding(IContentExaminer$IStreamSource iContentExaminer$IStreamSource) throws FileSystemClientException {
        block23: {
            InputStream inputStream;
            block22: {
                int n;
                byte[] byArray;
                block21: {
                    block20: {
                        inputStream = iContentExaminer$IStreamSource.getStream();
                        if (inputStream == null) {
                            return null;
                        }
                        byArray = new byte[3];
                        int n2 = 0;
                        n = 0;
                        int n3 = byArray.length;
                        while (n2 != -1 && n < byArray.length) {
                            n2 = inputStream.read(byArray, n, n3);
                            if (n2 == -1) continue;
                            n += n2;
                            n3 -= n2;
                        }
                        if (!LocalContentExaminer.startsWith(byArray, n, BOM_UTF_8)) break block20;
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException) {}
                        return "UTF-8";
                    }
                    if (!LocalContentExaminer.startsWith(byArray, n, BOM_UTF_16BE)) break block21;
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                    return "UTF-16BE";
                }
                if (!LocalContentExaminer.startsWith(byArray, n, BOM_UTF_16LE)) break block22;
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
                return "UTF-16LE";
                catch (IOException iOException) {
                    try {}
                    catch (Throwable throwable) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException2) {}
                        throw throwable;
                    }
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException3) {}
                    break block23;
                }
            }
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    private static boolean startsWith(byte[] byArray, int n, byte[] byArray2) {
        if (n < byArray2.length) {
            return false;
        }
        int n2 = 0;
        while (n2 < byArray2.length) {
            if (byArray[n2] != byArray2[n2]) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public void makeDefault() {
        instance = this;
    }
}

