/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.localchanges;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.ILocalChangeManager;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.internal.FileItemInfo;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.IMetadataChangeTracker;
import com.ibm.team.filesystem.client.internal.IMetadataChangeTracker$IChangeType;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.Share;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.CFALockUtil;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileArea;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaStore;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileArea;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreasLock;
import com.ibm.team.filesystem.client.internal.localchanges.LocalAddition;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChange;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeContext;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeManager;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeNode;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeNotifier;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeTracker$1;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeTracker$2;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeTracker$DateRecord;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeTracker$DefaultSchedulingRule;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeTracker$LocalChangesComputer;
import com.ibm.team.filesystem.client.internal.localchanges.LocalDeletion;
import com.ibm.team.filesystem.client.internal.localchanges.LocalModification;
import com.ibm.team.filesystem.client.internal.localchanges.LocalMoveFrom;
import com.ibm.team.filesystem.client.internal.localchanges.LocalMoveTo;
import com.ibm.team.filesystem.client.internal.localchanges.NoOpChange;
import com.ibm.team.filesystem.common.ISymbolicLink;
import com.ibm.team.filesystem.common.ISymbolicLinkHandle;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.ContentHash;
import com.ibm.team.scm.common.ContentHashAlgorithmException;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;

public class LocalChangeTracker {
    public static final Object CHANGES_COMPUTER_JOB_FAMILY = Messages.LocalChangeTracker_0;
    private static final long DELAY = 200000000L;
    private static final long DELAY_MS = 200L;
    private LocalChangeNotifier notifier;
    LocalChangeContext context;
    private LocalChangeNode changeTree = new LocalChangeNode(null, null);
    private LocalChangeTracker$LocalChangesComputer computeChangesjob;
    private Map localChanges = new HashMap();
    private HashMap needDates = new HashMap();

    private static void setCounterpart(LocalMoveFrom localMoveFrom, LocalMoveTo localMoveTo) {
        localMoveFrom.setCounterpart(localMoveTo);
        localMoveTo.setCounterpart(localMoveFrom);
    }

    private static void setNode(LocalChangeNode localChangeNode, LocalChange localChange) {
        localChange.setNode(localChangeNode);
        localChangeNode.addChange(localChange);
    }

    public LocalChangeTracker(LocalChangeNotifier localChangeNotifier, LocalChangeContext localChangeContext, ISchedulingRule iSchedulingRule) {
        this.notifier = localChangeNotifier;
        this.context = localChangeContext;
        if (iSchedulingRule == null) {
            iSchedulingRule = new LocalChangeTracker$DefaultSchedulingRule(null);
        }
        this.computeChangesjob = new LocalChangeTracker$LocalChangesComputer(this, iSchedulingRule);
        this.computeChangesjob.requestRefresh();
    }

    public synchronized void cancelChanges(ILocalChange[] iLocalChangeArray) {
        ILocalChange[] iLocalChangeArray2 = this.forgetChanges(iLocalChangeArray);
        this.notifier.changesCanceled(this.context, iLocalChangeArray2);
    }

    public synchronized void cancelChanges(IShareable iShareable) {
        ILocalChange[] iLocalChangeArray = this.forgetChanges(iShareable);
        this.notifier.changesCanceled(this.context, iLocalChangeArray);
    }

    public synchronized void cancelAllChanges() {
        if (!this.localChanges.isEmpty()) {
            this.cancelChanges(this.localChanges.values().toArray(new ILocalChange[this.localChanges.size()]));
        }
    }

    private void changeCanceled(LocalChange localChange) {
        if (this.notifier != null && this.context != null) {
            this.notifier.changeCanceled(this.context, localChange);
        }
    }

    private void changeOccurred(LocalChange localChange) {
        if (this.notifier != null && this.context != null) {
            this.notifier.changeOccurred(this.context, localChange);
        }
    }

    public synchronized void confirmChanges(ILocalChange[] iLocalChangeArray) {
        ILocalChange[] iLocalChangeArray2 = this.forgetChanges(iLocalChangeArray);
        this.notifier.changesConfirmed(this.context, iLocalChangeArray2);
    }

    private ILocalChange[] forgetChanges(ILocalChange[] iLocalChangeArray) {
        ArrayList<LocalChange> arrayList = new ArrayList<LocalChange>();
        int n = 0;
        while (n < iLocalChangeArray.length) {
            if (!iLocalChangeArray[n].isCanceled()) {
                LocalChange localChange = (LocalChange)iLocalChangeArray[n];
                arrayList.add(localChange);
                localChange.cancel();
                localChange.getNode().removeChange(localChange);
                this.localChanges.remove(localChange.getItemId());
            }
            ++n;
        }
        return arrayList.toArray(new ILocalChange[arrayList.size()]);
    }

    private ILocalChange[] forgetChanges(IShareable iShareable) {
        LocalChangeNode localChangeNode = this.changeTree.getNode(iShareable.getLocalPath(), false);
        if (localChangeNode == null) {
            return new ILocalChange[0];
        }
        ArrayList arrayList = new ArrayList();
        localChangeNode.collect(arrayList);
        for (LocalChange localChange : arrayList) {
            localChange.cancel();
            this.localChanges.remove(localChange.getItemId());
        }
        this.clear(localChangeNode);
        return arrayList.toArray(new ILocalChange[arrayList.size()]);
    }

    public synchronized ILocalChange getPendingChange(IVersionableHandle iVersionableHandle) {
        if (iVersionableHandle == null) {
            return NoOpChange.NO_OP;
        }
        LocalChange localChange = (LocalChange)this.localChanges.get(iVersionableHandle.getItemId());
        if (localChange == null) {
            return NoOpChange.NO_OP;
        }
        localChange.setWild();
        return localChange;
    }

    public ILocalChange[] getPendingChanges() {
        return this.getPendingChanges(false);
    }

    public synchronized ILocalChange[] getPendingChanges(boolean bl) {
        ILocalChange[] iLocalChangeArray;
        ILocalChange[] iLocalChangeArray2 = iLocalChangeArray = this.getPendingChanges(this.changeTree, bl);
        int n = iLocalChangeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ILocalChange iLocalChange = iLocalChangeArray2[n2];
            ((LocalChange)iLocalChange).setWild();
            ++n2;
        }
        return iLocalChangeArray;
    }

    public synchronized ILocalChange[] getPendingChanges(IPath iPath, boolean bl) {
        ILocalChange[] iLocalChangeArray;
        LocalChangeNode localChangeNode = this.changeTree.getNode(iPath, false);
        if (localChangeNode == null) {
            return LocalChangeManager.NO_CHANGES;
        }
        ILocalChange[] iLocalChangeArray2 = iLocalChangeArray = this.getPendingChanges(localChangeNode, bl);
        int n = iLocalChangeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ILocalChange iLocalChange = iLocalChangeArray2[n2];
            ((LocalChange)iLocalChange).setWild();
            ++n2;
        }
        return iLocalChangeArray;
    }

    public synchronized ILocalChange[] getPendingChangesAt(IPath iPath) {
        LocalChange[] localChangeArray;
        LocalChangeNode localChangeNode = this.changeTree.getNode(iPath, false);
        if (localChangeNode == null) {
            return LocalChangeManager.NO_CHANGES;
        }
        LocalChange[] localChangeArray2 = localChangeArray = localChangeNode.getChanges().toArray(new LocalChange[localChangeNode.getChanges().size()]);
        int n = localChangeArray.length;
        int n2 = 0;
        while (n2 < n) {
            LocalChange localChange = localChangeArray2[n2];
            localChange.setWild();
            ++n2;
        }
        return localChangeArray;
    }

    private ILocalChange[] getPendingChanges(LocalChangeNode localChangeNode, boolean bl) {
        Assert.isNotNull((Object)localChangeNode);
        ArrayList arrayList = new ArrayList();
        localChangeNode.collect(arrayList);
        if (bl) {
            for (LocalChange localChange : arrayList) {
                this.localChanges.remove(localChange.getItemId());
                localChange.cancel();
            }
            this.clear(localChangeNode);
        }
        return arrayList.toArray(new ILocalChange[arrayList.size()]);
    }

    /*
     * Exception decompiling
     */
    public void trackFileAddition(IFolderHandle var1_1, IShareable var2_2, IProgressMonitor var3_3) throws FileSystemClientException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [18[CATCHBLOCK]], but top level block is 17[CATCHBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void trackFolderAddition(IFolderHandle iFolderHandle, IShareable iShareable, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        FileItemInfo fileItemInfo;
        Assert.isNotNull((Object)iShareable, (String)Messages.LocalChangeTracker_7);
        ICopyFileArea iCopyFileArea = CopyFileAreaManager.instance.getExistingCopyFileArea(this.context.getRoot());
        Assert.isNotNull((Object)iCopyFileArea);
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        IPath iPath = iShareable.getLocalPath();
        if (iFolderHandle == null) {
            IShare iShare = iShareable.getShare((IProgressMonitor)subMonitor.newChild(50));
            ISharingDescriptor iSharingDescriptor = iShare.getSharingDescriptor();
            Assert.isTrue((boolean)(iSharingDescriptor.getRootVersionable() instanceof IFolderHandle));
            Assert.isTrue((iShare.getPath().segmentCount() == iPath.segmentCount() ? 1 : 0) != 0);
            fileItemInfo = ((CopyFileAreaStore)((Object)iCopyFileArea)).getItemInfo(iSharingDescriptor.getRootVersionable(), iSharingDescriptor.getComponent(), iSharingDescriptor.getConnectionHandle());
            if (fileItemInfo == null) {
                fileItemInfo = new FileItemInfo((IFolderHandle)IFolder.ITEM_TYPE.createItemHandle(iSharingDescriptor.getRootVersionable().getItemId(), null), null, null, false);
            }
        } else {
            fileItemInfo = ((CopyFileAreaStore)((Object)iCopyFileArea)).getDeletedItem(iFolderHandle, iPath.lastSegment(), this.context.getComponent(), this.context.getConnection(), (IProgressMonitor)subMonitor.newChild(50));
            if (fileItemInfo == null || fileItemInfo.getVersionableHandle().getItemType() != IFolder.ITEM_TYPE) {
                fileItemInfo = null;
            }
        }
        if (fileItemInfo == null) {
            fileItemInfo = new FileItemInfo((IFolderHandle)IFolder.ITEM_TYPE.createItemHandle(UUID.generate(), null), null, null, false);
        }
        subMonitor.setWorkRemaining(50);
        ((CopyFileAreaStore)((Object)iCopyFileArea)).setItemInfo(iPath, fileItemInfo, (IProgressMonitor)subMonitor.newChild(50));
        subMonitor.done();
    }

    public void trackSymbolicLinkAddition(IFolderHandle iFolderHandle, IShareable iShareable, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        FileItemInfo fileItemInfo;
        Object object;
        Assert.isNotNull((Object)iShareable, (String)Messages.LocalChangeTracker_7);
        ICopyFileArea iCopyFileArea = CopyFileAreaManager.instance.getExistingCopyFileArea(this.context.getRoot());
        Assert.isNotNull((Object)iCopyFileArea);
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        IPath iPath = iShareable.getLocalPath();
        if (iFolderHandle == null) {
            object = iShareable.getShare((IProgressMonitor)subMonitor.newChild(15));
            ISharingDescriptor iSharingDescriptor = object.getSharingDescriptor();
            Assert.isTrue((boolean)(iSharingDescriptor.getRootVersionable() instanceof ISymbolicLinkHandle));
            Assert.isTrue((object.getPath().segmentCount() == iPath.segmentCount() ? 1 : 0) != 0);
            fileItemInfo = ((CopyFileAreaStore)((Object)iCopyFileArea)).getItemInfo(iSharingDescriptor.getRootVersionable(), iSharingDescriptor.getComponent(), iSharingDescriptor.getConnectionHandle());
            if (fileItemInfo == null) {
                fileItemInfo = new FileItemInfo((ISymbolicLinkHandle)ISymbolicLink.ITEM_TYPE.createItemHandle(iSharingDescriptor.getRootVersionable().getItemId(), null), false, null, null, false, null, null);
            }
        } else {
            fileItemInfo = ((CopyFileAreaStore)((Object)iCopyFileArea)).getDeletedItem(iFolderHandle, iPath.lastSegment(), this.context.getComponent(), this.context.getConnection(), (IProgressMonitor)subMonitor.newChild(25));
            if (fileItemInfo != null && fileItemInfo.getVersionableHandle().getItemType() != ISymbolicLink.ITEM_TYPE) {
                fileItemInfo = null;
            }
        }
        if (fileItemInfo == null) {
            fileItemInfo = new FileItemInfo((ISymbolicLinkHandle)ISymbolicLink.ITEM_TYPE.createItemHandle(UUID.generate(), null), false, null, null, false, null, null);
        } else if (fileItemInfo.getHash() != null) {
            object = ((Shareable)iShareable).getFileStorage();
            boolean bl = LocalChangeTracker.contentChanged(fileItemInfo, (IFileStorage)object, (IProgressMonitor)subMonitor.newChild(10));
            fileItemInfo = new FileItemInfo((ISymbolicLinkHandle)fileItemInfo.getVersionableHandle(), bl, fileItemInfo.getParent(), fileItemInfo.getName(), fileItemInfo.isLoadedWithAnotherName(), fileItemInfo.getHash(), fileItemInfo.getStoredHash());
        }
        subMonitor.setWorkRemaining(50);
        ((CopyFileAreaStore)((Object)iCopyFileArea)).setItemInfo(iPath, fileItemInfo, (IProgressMonitor)subMonitor.newChild(50));
        subMonitor.done();
    }

    private IFileInfo fetchBaseInfo(IFileStore iFileStore, SubMonitor subMonitor) throws CoreException {
        IFileInfo[] iFileInfoArray = new IFileInfo[1];
        SharingManager.getInstance().doSilentChange(new LocalChangeTracker$1(this, iFileInfoArray, iFileStore, subMonitor));
        return iFileInfoArray[0];
    }

    public static boolean contentChanged(FileItemInfo fileItemInfo, IFileStorage iFileStorage, IProgressMonitor iProgressMonitor) {
        if (fileItemInfo.getHash() == null) {
            return false;
        }
        try {
            String string = iFileStorage.getTarget(iProgressMonitor);
            return LocalChangeTracker.contentChanged(fileItemInfo, string);
        }
        catch (FileSystemClientException fileSystemClientException) {
            return true;
        }
    }

    public static boolean contentChanged(FileItemInfo fileItemInfo, String string) {
        block6: {
            block5: {
                if (string != null) break block5;
                return true;
            }
            if (fileItemInfo.getHash() != null) break block6;
            return false;
        }
        try {
            return !LocalChangeTracker.getLinkHash(string).equals((Object)fileItemInfo.getHash());
        }
        catch (ContentHashAlgorithmException contentHashAlgorithmException) {
            return true;
        }
        catch (IOException iOException) {
            return true;
        }
    }

    public static ContentHash getLinkHash(String string) throws ContentHashAlgorithmException, IOException {
        ContentHash contentHash;
        block9: {
            ByteArrayInputStream byteArrayInputStream = null;
            try {
                byteArrayInputStream = new ByteArrayInputStream(string.getBytes("UTF-8"));
                ContentHash contentHash2 = ContentHash.valueOf((InputStream)byteArrayInputStream);
                ((InputStream)byteArrayInputStream).close();
                byteArrayInputStream = null;
                contentHash = contentHash2;
                if (byteArrayInputStream == null) break block9;
            }
            catch (Throwable throwable) {
                if (byteArrayInputStream != null) {
                    try {
                        ((InputStream)byteArrayInputStream).close();
                    }
                    catch (IOException iOException) {
                    }
                    catch (RuntimeException runtimeException) {}
                }
                throw throwable;
            }
            try {
                ((InputStream)byteArrayInputStream).close();
            }
            catch (IOException iOException) {
            }
            catch (RuntimeException runtimeException) {}
        }
        return contentHash;
    }

    private void clear(LocalChangeNode localChangeNode) {
        localChangeNode.prune();
    }

    public void syncChanges(IProgressMonitor iProgressMonitor) {
        this.computeChangesjob.rejoin(iProgressMonitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshPendingChanges(IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        Object object;
        HashSet<UUID> hashSet;
        SharingManager sharingManager = SharingManager.getInstance();
        HashMap hashMap = new HashMap();
        ICopyFileArea iCopyFileArea = CopyFileAreaManager.instance.getExistingCopyFileArea(this.context.getRoot());
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)2);
        SubMonitor subMonitor2 = subMonitor.newChild(1);
        while (true) {
            int n;
            hashSet = this.needDates;
            synchronized (hashSet) {
                n = this.needDates.size();
                if (n == 0) {
                    break;
                }
                Iterator iterator = this.needDates.entrySet().iterator();
                object = iterator.next();
                iterator.remove();
            }
            subMonitor2.setWorkRemaining(n + 1);
            hashSet = (LocalChangeTracker$DateRecord)object.getKey();
            long l = (Long)object.getValue();
            IShareable localChange = sharingManager.findShareable(this.context.getRoot(), ((LocalChangeTracker$DateRecord)((Object)hashSet)).connection, ((LocalChangeTracker$DateRecord)((Object)hashSet)).component, ((LocalChangeTracker$DateRecord)((Object)hashSet)).versionable, null);
            if (localChange == null) continue;
            long localChangeNode = ((Shareable)localChange).getFileStorage().getLocalTimeStamp();
            if (localChangeNode != l) {
                if (localChangeNode >= l) continue;
                hashMap.put(hashSet, l);
                continue;
            }
            FileItemInfo fileItemInfo = ((Shareable)localChange).getFileItemInfo((IProgressMonitor)subMonitor2.newChild(1));
            Assert.isNotNull((Object)fileItemInfo);
            Assert.isNotNull((Object)fileItemInfo.getHash());
            long l2 = ((Shareable)localChange).getFileStorage().getModificationStamp();
            if (l2 == fileItemInfo.getLastContentChangeCheckStamp()) continue;
            FileItemInfo fileItemInfo2 = new FileItemInfo(fileItemInfo.getVersionableHandle(), fileItemInfo.isContentChanged(), l2, fileItemInfo.getParent(), fileItemInfo.getName(), fileItemInfo.isLoadedWithAnotherName(), fileItemInfo.getHash(), fileItemInfo.getContentLength(), fileItemInfo.getOriginalLineDelimiter(), fileItemInfo.getLineDelimiter(), fileItemInfo.getOriginalContentType(), fileItemInfo.getContentType(), fileItemInfo.getStoredPredecessorHintHash(), fileItemInfo.getStoredSize(), fileItemInfo.getStoredEncoding(), fileItemInfo.getStoredHash(), fileItemInfo.getStoredNumLineDelimiters(), fileItemInfo.isExecutable(), fileItemInfo.isOriginalExecutable());
            ((CopyFileAreaStore)((Object)iCopyFileArea)).setItemInfo(localChange.getLocalPath(), fileItemInfo2, null);
        }
        subMonitor2.done();
        object = this.needDates;
        synchronized (object) {
            this.needDates.putAll(hashMap);
        }
        object = ((IMetadataChangeTracker)((Object)((CopyFileAreaStore)((Object)iCopyFileArea)).internalGetMetadata())).getLocalChanges(this.context.getComponent(), this.context.getConnection(), (IProgressMonitor)subMonitor.newChild(1));
        ArrayList<LocalChange> arrayList = new ArrayList<LocalChange>(object.size());
        hashSet = new HashSet<UUID>();
        Map.Entry entry = object.iterator();
        block13: while (entry.hasNext()) {
            IMetadataChangeTracker$IChangeType iMetadataChangeTracker$IChangeType = (IMetadataChangeTracker$IChangeType)entry.next();
            switch (iMetadataChangeTracker$IChangeType.getType()) {
                case 2: {
                    break;
                }
                case 1: {
                    arrayList.add(new LocalDeletion(this.context, iMetadataChangeTracker$IChangeType.getCurrentPath(), iMetadataChangeTracker$IChangeType.getOriginalPath(), iMetadataChangeTracker$IChangeType.getItem(), iMetadataChangeTracker$IChangeType.getPreviousParent()));
                    hashSet.add(iMetadataChangeTracker$IChangeType.getItem().getItemId());
                    break;
                }
                case 3: {
                    int n = 0;
                    if (iMetadataChangeTracker$IChangeType.isContentChange()) {
                        n = 1;
                    }
                    if (iMetadataChangeTracker$IChangeType.isFlagChange()) {
                        n |= 0x20;
                    }
                    LocalMoveFrom localMoveFrom = new LocalMoveFrom(this.context, iMetadataChangeTracker$IChangeType.getCurrentMovedFromPath(), iMetadataChangeTracker$IChangeType.getOriginalPath(), iMetadataChangeTracker$IChangeType.getItem(), iMetadataChangeTracker$IChangeType.getPreviousParent(), n);
                    LocalMoveTo localMoveTo = new LocalMoveTo(this.context, iMetadataChangeTracker$IChangeType.getCurrentPath(), iMetadataChangeTracker$IChangeType.getItem(), iMetadataChangeTracker$IChangeType.getCurrentParent(), n);
                    LocalChangeTracker.setCounterpart(localMoveFrom, localMoveTo);
                    arrayList.add(localMoveTo);
                    hashSet.add(iMetadataChangeTracker$IChangeType.getItem().getItemId());
                    break;
                }
                case 4: {
                    arrayList.add(new LocalAddition(this.context, iMetadataChangeTracker$IChangeType.getCurrentPath(), iMetadataChangeTracker$IChangeType.getItem(), iMetadataChangeTracker$IChangeType.getCurrentParent()));
                    hashSet.add(iMetadataChangeTracker$IChangeType.getItem().getItemId());
                    break;
                }
                default: {
                    int n = 0;
                    if (iMetadataChangeTracker$IChangeType.isContentChange()) {
                        n = 1;
                    }
                    if (iMetadataChangeTracker$IChangeType.isFlagChange()) {
                        n |= 0x20;
                    }
                    if (n == 0) continue block13;
                    arrayList.add(new LocalModification(this.context, iMetadataChangeTracker$IChangeType.getCurrentPath(), iMetadataChangeTracker$IChangeType.getOriginalPath(), iMetadataChangeTracker$IChangeType.getItem(), n));
                    hashSet.add(iMetadataChangeTracker$IChangeType.getItem().getItemId());
                }
            }
        }
        Iterator object22 = this.localChanges.entrySet().iterator();
        while (object22.hasNext()) {
            entry = object22.next();
            if (hashSet.contains(entry.getKey())) continue;
            ((LocalChange)entry.getValue()).cancel();
            ((LocalChange)entry.getValue()).getNode().removeChange((LocalChange)entry.getValue());
            this.changeCanceled((LocalChange)entry.getValue());
            object22.remove();
        }
        for (LocalChange localChange : arrayList) {
            LocalChange localChange2 = (LocalChange)this.localChanges.get(localChange.getItemId());
            if (localChange2 != null) {
                if (localChange.equals(localChange2)) continue;
                localChange2.cancel();
                localChange2.getNode().removeChange(localChange2);
                this.changeCanceled(localChange2);
            }
            LocalChangeNode localChangeNode = this.changeTree.getNode(localChange.getPath(), true);
            LocalChangeTracker.setNode(localChangeNode, localChange);
            this.localChanges.put(localChange.getItemId(), localChange);
            this.changeOccurred(localChange);
        }
    }

    public static void computePendingChanges(IShareable iShareable, ILocalChangeManager.RefreshType refreshType, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        ArrayList<FileSystemClientException> arrayList = new ArrayList<FileSystemClientException>();
        LocalChangeTracker localChangeTracker = null;
        ICopyFileAreasLock iCopyFileAreasLock = ICopyFileAreaManager.instance.lock(Collections.singleton(ICopyFileAreaManager.instance.lockRequestFactory().getLockRequest(Collections.singleton(iShareable))), (IProgressMonitor)subMonitor.newChild(1));
        try {
            MultiStatus multiStatus;
            Share share = (Share)iShareable.getShare((IProgressMonitor)subMonitor.newChild(1));
            if (share == null || !CFALockUtil.isLockedForUpdate(share.getSandbox().getRoot(), share.getSharingDescriptor().getComponent(), share.getSharingDescriptor().getConnectionHandle())) {
                return;
            }
            LocalChangeTracker localChangeTracker2 = localChangeTracker = share.getTracker();
            ICopyFileArea iCopyFileArea = CopyFileAreaManager.instance.getExistingCopyFileArea(iShareable.getSandbox().getRoot());
            ArrayList<IShareable> arrayList2 = new ArrayList<IShareable>();
            arrayList2.add(iShareable);
            do {
                subMonitor.setWorkRemaining(98);
                multiStatus = new ArrayList();
                Shareable object = (Shareable)arrayList2.remove(arrayList2.size() - 1);
                object.accept(new LocalChangeTracker$2(arrayList, refreshType, iShareable, (CopyFileArea)iCopyFileArea, share, (List)multiStatus, arrayList2, localChangeTracker2), Integer.MAX_VALUE, true, true, (IProgressMonitor)subMonitor.newChild(68));
                SubMonitor subMonitor2 = subMonitor.newChild(10);
                subMonitor2.setWorkRemaining(multiStatus.size());
                for (IShareable iShareable2 : multiStatus) {
                    try {
                        ((CopyFileAreaStore)((Object)iCopyFileArea)).deleteTreeInfo(iShareable2.getLocalPath(), false, (IProgressMonitor)subMonitor2.newChild(1));
                    }
                    catch (FileSystemClientException fileSystemClientException) {
                        arrayList.add(fileSystemClientException);
                    }
                }
                subMonitor2.done();
            } while (!arrayList2.isEmpty());
            if (!arrayList.isEmpty()) {
                multiStatus = new MultiStatus("com.ibm.team.filesystem.client", 0, Messages.LocalChangeTracker_11, null);
                for (FileSystemClientException fileSystemClientException : arrayList) {
                    multiStatus.add(FileSystemStatus.getStatusFor((Throwable)((Object)fileSystemClientException)));
                }
                throw (Throwable)((Object)new FileSystemClientException((IStatus)multiStatus));
            }
        }
        finally {
            iCopyFileAreasLock.release((IProgressMonitor)subMonitor.newChild(1));
            if (localChangeTracker != null) {
                localChangeTracker.computeChangesjob.requestRefresh();
            }
            subMonitor.done();
        }
    }

    public LocalChangeContext getContext() {
        return this.context;
    }

    public void metadataChanged() {
        this.computeChangesjob.requestRefresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerDatelessVersionable(long l, IVersionableHandle iVersionableHandle, IComponentHandle iComponentHandle, IContextHandle iContextHandle) {
        HashMap hashMap = this.needDates;
        synchronized (hashMap) {
            LocalChangeTracker$DateRecord localChangeTracker$DateRecord = new LocalChangeTracker$DateRecord(iVersionableHandle, iComponentHandle, iContextHandle);
            this.needDates.remove(localChangeTracker$DateRecord);
            this.needDates.put(localChangeTracker$DateRecord, l);
        }
        this.computeChangesjob.requestRefresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterDatelessVersionable(IVersionableHandle iVersionableHandle, IComponentHandle iComponentHandle, IContextHandle iContextHandle) {
        HashMap hashMap = this.needDates;
        synchronized (hashMap) {
            LocalChangeTracker$DateRecord localChangeTracker$DateRecord = new LocalChangeTracker$DateRecord(iVersionableHandle, iComponentHandle, iContextHandle);
            this.needDates.remove(localChangeTracker$DateRecord);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsDatelessVersionable(long l, IVersionableHandle iVersionableHandle, IComponentHandle iComponentHandle, IContextHandle iContextHandle) {
        Long l2;
        HashMap hashMap = this.needDates;
        synchronized (hashMap) {
            l2 = (Long)this.needDates.get(new LocalChangeTracker$DateRecord(iVersionableHandle, iComponentHandle, iContextHandle));
        }
        return l2 != null && l2 == l;
    }

    static /* synthetic */ void access$0(LocalChangeTracker localChangeTracker, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        localChangeTracker.refreshPendingChanges(iProgressMonitor);
    }
}

