/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.localchanges;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.ILocalChangeManager$RefreshType;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.FileItemInfo;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.IShareableVisitor;
import com.ibm.team.filesystem.client.internal.InverseFileItemInfo;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.ManagedFileStore;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.Share;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileArea;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeTracker;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeTracker$2$1;
import com.ibm.team.filesystem.common.ISymbolicLinkHandle;
import com.ibm.team.scm.common.IFolderHandle;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

class LocalChangeTracker$2
implements IShareableVisitor {
    private final /* synthetic */ List val$exceptions;
    private final /* synthetic */ ILocalChangeManager$RefreshType val$traversalType;
    private final /* synthetic */ IShareable val$root;
    private final /* synthetic */ CopyFileArea val$cfa;
    private final /* synthetic */ Share val$share;
    private final /* synthetic */ List val$toDelete;
    private final /* synthetic */ List val$toVisit;
    private final /* synthetic */ LocalChangeTracker val$myTracker;

    LocalChangeTracker$2(List list, ILocalChangeManager$RefreshType refreshType, IShareable iShareable, CopyFileArea copyFileArea, Share share, List list2, List list3, LocalChangeTracker localChangeTracker) {
        this.val$exceptions = list;
        this.val$traversalType = refreshType;
        this.val$root = iShareable;
        this.val$cfa = copyFileArea;
        this.val$share = share;
        this.val$toDelete = list2;
        this.val$toVisit = list3;
        this.val$myTracker = localChangeTracker;
    }

    public boolean visit(IShareable iShareable, IProgressMonitor iProgressMonitor) {
        ResourceType resourceType;
        FileItemInfo fileItemInfo;
        IFileStorage iFileStorage;
        IFileStorage iFileStorage2;
        SubMonitor subMonitor;
        block49: {
            block50: {
                subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)5);
                try {
                    if (iShareable.shouldBeIgnored((IProgressMonitor)subMonitor.newChild(1))) {
                        return false;
                    }
                }
                catch (FileSystemClientException fileSystemClientException) {
                    this.val$exceptions.add(fileSystemClientException);
                }
                iFileStorage2 = ((Shareable)iShareable).getFileStorage();
                if (!iFileStorage2.isRepositoryProviderRegistered((IProgressMonitor)subMonitor.newChild(1))) break block49;
                if (this.val$traversalType != ILocalChangeManager$RefreshType.OPTIMIZED_TRAVERSAL) break block50;
                return false;
            }
            try {
                if (this.val$traversalType == ILocalChangeManager$RefreshType.TRAVERSE_ALL_WITH_RECOMPUTE_OF_KNOWN && (this.val$root.equals(iShareable) || iFileStorage2.getIDEPath().segmentCount() == 1)) {
                    SharingManager.getInstance().doSilentChange(new LocalChangeTracker$2$1(this, iFileStorage2, subMonitor));
                }
            }
            catch (FileSystemClientException fileSystemClientException) {
                this.val$exceptions.add(fileSystemClientException);
            }
            catch (CoreException coreException) {
                this.val$exceptions.add(new FileSystemClientException(FileSystemStatus.getStatusFor(coreException)));
            }
        }
        subMonitor.subTask(NLS.bind((String)Messages.LocalChangeTracker_RecomputeChangesForPath, (Object)iShareable.getLocalPath().toString()));
        Shareable shareable = (Shareable)((Shareable)iShareable).getParent();
        if (shareable != null) {
            iFileStorage = shareable.getFileStorage();
            fileItemInfo = this.val$cfa.getItemInfo(shareable.getLocalPath());
            if (fileItemInfo == null) {
                try {
                    ManagedFileStore.createFolderHierarchyUpToParentOf(iShareable.getLocalPath(), this.val$share, this.val$cfa, false, (IProgressMonitor)subMonitor.newChild(1));
                    fileItemInfo = this.val$cfa.getItemInfo(shareable.getLocalPath());
                }
                catch (CoreException coreException) {
                    LoggingHelper.log(coreException);
                }
            }
        } else {
            iFileStorage = null;
            fileItemInfo = null;
        }
        try {
            resourceType = iShareable.getResourceType((IProgressMonitor)subMonitor.newChild(1));
        }
        catch (FileSystemClientException fileSystemClientException) {
            this.val$exceptions.add(fileSystemClientException);
            return false;
        }
        if (iFileStorage == null && resourceType == ResourceType.FOLDER) {
            return true;
        }
        if (iFileStorage != null && resourceType == null) {
            this.val$toDelete.add(iShareable);
            return false;
        }
        FileItemInfo fileItemInfo2 = this.val$cfa.getItemInfo(iShareable.getLocalPath());
        if (iFileStorage != null && fileItemInfo2 != null && (resourceType == ResourceType.SYMBOLIC_LINK != fileItemInfo2.isSymbolicLink() || !fileItemInfo2.isSymbolicLink() && fileItemInfo2.isFolder() != (resourceType == ResourceType.FOLDER))) {
            this.val$toDelete.add(iShareable);
            this.val$toVisit.add(iShareable);
            return false;
        }
        if (iFileStorage != null && fileItemInfo2 == null && fileItemInfo != null) {
            try {
                if (resourceType == ResourceType.SYMBOLIC_LINK) {
                    this.val$myTracker.trackSymbolicLinkAddition((IFolderHandle)fileItemInfo.getVersionableHandle(), iShareable, (IProgressMonitor)subMonitor.newChild(1));
                } else if (resourceType == ResourceType.FOLDER) {
                    this.val$myTracker.trackFolderAddition((IFolderHandle)fileItemInfo.getVersionableHandle(), iShareable, (IProgressMonitor)subMonitor.newChild(1));
                } else if (resourceType == ResourceType.FILE) {
                    this.val$myTracker.trackFileAddition((IFolderHandle)fileItemInfo.getVersionableHandle(), iShareable, (IProgressMonitor)subMonitor.newChild(1));
                }
            }
            catch (FileSystemClientException fileSystemClientException) {
                this.val$exceptions.add(fileSystemClientException);
            }
        } else if (fileItemInfo2 != null && fileItemInfo2.isFile() && fileItemInfo2.getHash() != null) {
            Object object;
            long l;
            SubMonitor subMonitor2 = subMonitor.newChild(1).setWorkRemaining(100);
            boolean bl = fileItemInfo2.isContentChanged();
            boolean bl2 = fileItemInfo2.isExecutable();
            try {
                try {
                    SharingManager.getInstance().disableChangeMonitoring();
                    l = iFileStorage2.getModificationStamp();
                    if (iFileStorage2.supportsExecBit()) {
                        bl2 = iFileStorage2.isExecutable((IProgressMonitor)subMonitor2.newChild(25));
                        subMonitor2.setWorkRemaining(100);
                    }
                    bl = iFileStorage2.isContentChangedFrom(fileItemInfo2, (IProgressMonitor)subMonitor2.newChild(50));
                }
                catch (FileSystemClientException fileSystemClientException) {
                    if (fileSystemClientException.getStatus().getCode() != 203) {
                        this.val$exceptions.add(fileSystemClientException);
                    }
                    SharingManager.getInstance().enableChangeMonitoring();
                    return true;
                }
            }
            finally {
                SharingManager.getInstance().enableChangeMonitoring();
            }
            boolean bl3 = false;
            if (!this.val$cfa.isCaseSensitive()) {
                object = this.val$share.getSharingDescriptor();
                InverseFileItemInfo inverseFileItemInfo = this.val$cfa.getItemInfo(fileItemInfo2.getVersionableHandle(), object.getComponent(), object.getConnectionHandle());
                boolean bl4 = bl3 = !inverseFileItemInfo.getLocalName().equals(iShareable.getLocalPath().lastSegment());
            }
            if (fileItemInfo2.getLastContentChangeCheckStamp() != l || bl != fileItemInfo2.isContentChanged() || bl2 != fileItemInfo2.isExecutable() || bl3) {
                object = new FileItemInfo(fileItemInfo2.getVersionableHandle(), bl, l, fileItemInfo2.getParent(), fileItemInfo2.getName(), fileItemInfo2.isLoadedWithAnotherName(), fileItemInfo2.getHash(), fileItemInfo2.getContentLength(), fileItemInfo2.getOriginalLineDelimiter(), fileItemInfo2.getLineDelimiter(), fileItemInfo2.getOriginalContentType(), fileItemInfo2.getContentType(), fileItemInfo2.getStoredPredecessorHintHash(), fileItemInfo2.getStoredSize(), fileItemInfo2.getStoredEncoding(), fileItemInfo2.getStoredHash(), fileItemInfo2.getStoredNumLineDelimiters(), bl2, fileItemInfo2.isOriginalExecutable());
                subMonitor2.setWorkRemaining(100);
                try {
                    this.val$cfa.setItemInfo(iShareable.getLocalPath(), (FileItemInfo)object, (IProgressMonitor)subMonitor2.newChild(100));
                }
                catch (FileSystemClientException fileSystemClientException) {
                    this.val$exceptions.add(fileSystemClientException);
                }
            }
            iProgressMonitor.done();
        } else if (fileItemInfo2 != null && fileItemInfo2.isSymbolicLink() && fileItemInfo2.getHash() != null) {
            boolean bl = LocalChangeTracker.contentChanged(fileItemInfo2, iFileStorage2, (IProgressMonitor)subMonitor.newChild(1));
            if (bl != fileItemInfo2.isContentChanged()) {
                FileItemInfo fileItemInfo3 = new FileItemInfo((ISymbolicLinkHandle)fileItemInfo2.getVersionableHandle(), bl, fileItemInfo2.getParent(), fileItemInfo2.getName(), fileItemInfo2.isLoadedWithAnotherName(), fileItemInfo2.getHash(), fileItemInfo2.getStoredHash());
                try {
                    this.val$cfa.setItemInfo(iShareable.getLocalPath(), fileItemInfo3, (IProgressMonitor)subMonitor.newChild(1));
                }
                catch (FileSystemClientException fileSystemClientException) {
                    this.val$exceptions.add(fileSystemClientException);
                }
            }
        } else if (fileItemInfo2 != null && fileItemInfo2.isFolder() && !this.val$cfa.isCaseSensitive()) {
            ISharingDescriptor iSharingDescriptor = this.val$share.getSharingDescriptor();
            InverseFileItemInfo inverseFileItemInfo = this.val$cfa.getItemInfo(fileItemInfo2.getVersionableHandle(), iSharingDescriptor.getComponent(), iSharingDescriptor.getConnectionHandle());
            if (!inverseFileItemInfo.getLocalName().equals(iShareable.getLocalPath().lastSegment())) {
                FileItemInfo fileItemInfo4 = new FileItemInfo((IFolderHandle)fileItemInfo2.getVersionableHandle(), fileItemInfo2.getParent(), fileItemInfo2.getName(), fileItemInfo2.isLoadedWithAnotherName());
                try {
                    this.val$cfa.setItemInfo(iShareable.getLocalPath(), fileItemInfo4, (IProgressMonitor)subMonitor.newChild(1));
                }
                catch (FileSystemClientException fileSystemClientException) {
                    this.val$exceptions.add(fileSystemClientException);
                }
            }
        }
        return true;
    }
}

