/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.localchanges;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.IFileContentManager;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.ILocalChangeListener;
import com.ibm.team.filesystem.client.ILocalChangeManager;
import com.ibm.team.filesystem.client.ILocalChangeManager$RefreshType;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.FileItemInfo;
import com.ibm.team.filesystem.client.internal.FileSystemManager;
import com.ibm.team.filesystem.client.internal.FileSystemServiceProxy;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.IRepositoryResolver;
import com.ibm.team.filesystem.client.internal.InverseFileItemInfo;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.Share;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.Shed;
import com.ibm.team.filesystem.client.internal.copyfileareas.AbstractLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.CFALockUtil;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileArea;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaStore;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileArea;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.localchanges.LocalAddition;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChange;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeContext;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeManager$1;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeManager$2;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeManager$3;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeManager$DefaultRepoResolver;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeManager$RecomputePendingChangesJob;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeManager$RefreshRequest;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeNotifier;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeTracker;
import com.ibm.team.filesystem.client.internal.localchanges.LocalDeletion;
import com.ibm.team.filesystem.client.internal.localchanges.LocalModification;
import com.ibm.team.filesystem.client.internal.localchanges.LocalMoveFrom;
import com.ibm.team.filesystem.client.internal.localchanges.LocalMoveTo;
import com.ibm.team.filesystem.client.internal.localchanges.NoOpChange;
import com.ibm.team.filesystem.client.internal.utils.CancellationMonitor;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationDescriptor;
import com.ibm.team.filesystem.client.internal.utils.FlowNodeLock;
import com.ibm.team.filesystem.client.internal.utils.WorkspaceLockUtil;
import com.ibm.team.filesystem.client.operations.UndoDilemmaHandler;
import com.ibm.team.filesystem.client.operations.UpdateDilemmaHandler;
import com.ibm.team.filesystem.common.IFileContent;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.common.ISymbolicLink;
import com.ibm.team.filesystem.common.ISymbolicLinkHandle;
import com.ibm.team.filesystem.common.internal.FilesystemFactory;
import com.ibm.team.filesystem.common.internal.dto.FileAreaUpdate;
import com.ibm.team.filesystem.common.internal.dto.FileAreaUpdateReport;
import com.ibm.team.filesystem.common.internal.dto.FilesystemDTOFactory;
import com.ibm.team.filesystem.common.internal.dto.LoadTree;
import com.ibm.team.internal.repository.rcp.streams.DigestComputingInputStream;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.ContentHash;
import com.ibm.team.scm.common.ContentHashAlgorithmException;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.internal.dto.ComponentStateSummary;
import com.ibm.team.scm.common.internal.dto.ScmDtoFactory;
import com.ibm.team.scm.common.internal.dto.SynchronizationTime;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;

public class LocalChangeManager
implements ILocalChangeManager {
    public static final IRepositoryResolver DEFAULT_RESOLVER = new LocalChangeManager$DefaultRepoResolver(null);
    private Object avoidNotification = new Object();
    private int avoidNotificationCount = 0;
    public static final ILocalChange[] NO_CHANGES = new ILocalChange[0];
    private static volatile LocalChangeManager instance;
    public static String RECOMPUTE_PENDING_CHANGES_FAMILY;
    private Set toRefresh = new HashSet();
    private Object refreshLock = new Object();
    private Map trackers = new HashMap();
    private LocalChangeNotifier notifier = new LocalChangeNotifier();
    private LocalChangeManager$RecomputePendingChangesJob recomputeJob = new LocalChangeManager$RecomputePendingChangesJob(this);
    private static final String BACKUP_NAME = "#apo";

    static {
        RECOMPUTE_PENDING_CHANGES_FAMILY = LocalChangeManager$RecomputePendingChangesJob.class.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LocalChangeManager getInstance() {
        LocalChangeManager localChangeManager = instance;
        if (localChangeManager != null) return localChangeManager;
        Class<LocalChangeManager> clazz = LocalChangeManager.class;
        synchronized (LocalChangeManager.class) {
            localChangeManager = instance;
            if (localChangeManager != null) return localChangeManager;
            instance = localChangeManager = new LocalChangeManager();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return localChangeManager;
        }
    }

    private LocalChangeManager() {
    }

    public void addLocalChangeListener(ILocalChangeListener iLocalChangeListener) {
        this.notifier.addListener(iLocalChangeListener);
    }

    public String getProgressDescription(ILocalChange iLocalChange) {
        if ((iLocalChange instanceof LocalModification || iLocalChange instanceof LocalAddition) && iLocalChange.getTarget() instanceof IFileItemHandle) {
            return NLS.bind((String)Messages.LocalChangeManager_3, (Object)iLocalChange.getPath());
        }
        if (iLocalChange instanceof LocalDeletion) {
            return NLS.bind((String)Messages.LocalChangeManager_4, (Object)iLocalChange.getPath());
        }
        if (iLocalChange instanceof LocalAddition) {
            return NLS.bind((String)Messages.LocalChangeManager_5, (Object)iLocalChange.getPath());
        }
        if (iLocalChange instanceof LocalMoveFrom) {
            return NLS.bind((String)Messages.LocalChangeManager_7, (Object)iLocalChange.getPath());
        }
        if (iLocalChange instanceof LocalMoveTo) {
            return NLS.bind((String)Messages.LocalChangeManager_8, (Object)iLocalChange.getResultingPath());
        }
        LoggingHelper.log((IStatus)new Status(2, "com.ibm.team.filesystem.client", NLS.bind((String)Messages.LocalChangeManager_9, (Object)this.getClass().getName())));
        return Messages.LocalChangeManager_10;
    }

    public void cancelChanges(IShare iShare) {
        LocalChangeTracker localChangeTracker = this.findTracker(iShare);
        if (localChangeTracker != null) {
            localChangeTracker.cancelChanges(localChangeTracker.getPendingChanges(iShare.getPath(), false));
        }
    }

    private LocalChangeTracker findTracker(IShare iShare) {
        ISharingDescriptor iSharingDescriptor = iShare.getSharingDescriptor();
        return this.findTracker(iSharingDescriptor.getConnectionHandle(), iSharingDescriptor.getComponent(), iShare.getSandbox().getRoot());
    }

    private Map getChangesMap(ILocalChange[] iLocalChangeArray) {
        HashMap<LocalChangeContext, ArrayList<ILocalChange>> hashMap = new HashMap<LocalChangeContext, ArrayList<ILocalChange>>();
        ILocalChange[] iLocalChangeArray2 = iLocalChangeArray;
        int n = iLocalChangeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ILocalChange iLocalChange = iLocalChangeArray2[n2];
            LocalChangeContext localChangeContext = ((LocalChange)iLocalChange).context;
            if (localChangeContext != null) {
                ArrayList<ILocalChange> arrayList = (ArrayList<ILocalChange>)hashMap.get(localChangeContext);
                if (arrayList == null) {
                    arrayList = new ArrayList<ILocalChange>();
                    hashMap.put(localChangeContext, arrayList);
                }
                arrayList.add(iLocalChange);
            }
            ++n2;
        }
        return hashMap;
    }

    public void cancelChanges(ILocalChange[] iLocalChangeArray) {
        for (Map.Entry entry : this.getChangesMap(iLocalChangeArray).entrySet()) {
            LocalChangeTracker localChangeTracker = this.findTracker((LocalChangeContext)entry.getKey());
            localChangeTracker.cancelChanges(((List)entry.getValue()).toArray(new ILocalChange[((List)entry.getValue()).size()]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearPendingChanges(IContextHandle iContextHandle, IComponentHandle iComponentHandle, IPath iPath) {
        LocalChangeTracker localChangeTracker = null;
        Map map = this.trackers;
        synchronized (map) {
            localChangeTracker = (LocalChangeTracker)this.trackers.remove(new LocalChangeContext(iComponentHandle, iContextHandle, iPath));
        }
        if (localChangeTracker != null) {
            localChangeTracker.cancelAllChanges();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearPendingChanges(IPath iPath) {
        Map map = this.trackers;
        synchronized (map) {
            Iterator iterator = this.trackers.keySet().iterator();
            while (iterator.hasNext()) {
                LocalChangeContext localChangeContext = (LocalChangeContext)iterator.next();
                if (!localChangeContext.getRoot().equals((Object)iPath)) continue;
                iterator.remove();
            }
        }
    }

    public void commitChanges(ILocalChange[] iLocalChangeArray) {
        for (Map.Entry entry : this.getChangesMap(iLocalChangeArray).entrySet()) {
            LocalChangeTracker localChangeTracker = this.findTracker((LocalChangeContext)entry.getKey());
            localChangeTracker.confirmChanges(((List)entry.getValue()).toArray(new ILocalChange[((List)entry.getValue()).size()]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshSynchronously(IShare iShare, IShareable iShareable, ILocalChangeManager$RefreshType iLocalChangeManager$RefreshType, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        ILocalChange[] iLocalChangeArray;
        ILocalChange[] iLocalChangeArray2;
        Share share = (Share)iShare;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        LocalChangeTracker localChangeTracker = share.getTracker();
        LocalChangeNotifier.disableChangeNotification();
        try {
            ISchedulingRule iSchedulingRule = SharingManager.getInstance().getTrackingRule(share.getCopyFileAreaPath());
            try {
                Job.getJobManager().beginRule(iSchedulingRule, (IProgressMonitor)subMonitor.newChild(1));
                AbstractLock abstractLock = CFALockUtil.createAndLockForUpdate(share.getCopyFileAreaPath(), share.getSharingDescriptor().getConnectionHandle(), share.getSharingDescriptor().getComponent(), (IProgressMonitor)subMonitor.newChild(1));
                try {
                    LocalChangeTracker localChangeTracker2 = localChangeTracker;
                    synchronized (localChangeTracker2) {
                        iLocalChangeArray2 = localChangeTracker.getPendingChanges(true);
                        LocalChangeTracker.computePendingChanges(iShareable, iLocalChangeManager$RefreshType, (IProgressMonitor)subMonitor.newChild(93));
                        localChangeTracker.syncChanges((IProgressMonitor)subMonitor.newChild(5));
                        iLocalChangeArray = localChangeTracker.getPendingChanges();
                    }
                }
                finally {
                    CFALockUtil.endBatching(abstractLock, (IProgressMonitor)subMonitor.newChild(1));
                }
            }
            finally {
                Job.getJobManager().endRule(iSchedulingRule);
            }
        }
        finally {
            LocalChangeNotifier.enableChangeNotification();
        }
        this.notifier.changesCanceled(localChangeTracker.getContext(), iLocalChangeArray2);
        this.notifier.changesOccurred(localChangeTracker.getContext(), iLocalChangeArray);
        subMonitor.done();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRefresh(IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        Set set;
        Object object = this.refreshLock;
        synchronized (object) {
            if (this.toRefresh.isEmpty()) {
                return;
            }
            set = this.toRefresh;
            this.toRefresh = new HashSet();
        }
        object = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (String)Messages.LocalChangeManager_11, (int)set.size());
        try {
            for (LocalChangeManager$RefreshRequest localChangeManager$RefreshRequest : set) {
                this.refreshSynchronously(localChangeManager$RefreshRequest.getShare(), localChangeManager$RefreshRequest.getRootShareable(), localChangeManager$RefreshRequest.getTraversalType(), (IProgressMonitor)object.newChild(1));
            }
        }
        finally {
            object.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LocalChangeTracker findTracker(LocalChangeContext localChangeContext) {
        Map map = this.trackers;
        synchronized (map) {
            block5: {
                LocalChangeTracker localChangeTracker = (LocalChangeTracker)this.trackers.get(localChangeContext);
                if (localChangeTracker != null) {
                    return localChangeTracker;
                }
                if (ICopyFileAreaManager.instance.copyFileAreaExists(localChangeContext.getRoot(), 0)) break block5;
                return null;
            }
            return this.getTracker(localChangeContext.getConnection(), localChangeContext.getComponent(), localChangeContext.getRoot(), SharingManager.getInstance().getTrackingRule(localChangeContext.getRoot()));
        }
    }

    public LocalChangeTracker findTracker(IContextHandle iContextHandle, IComponentHandle iComponentHandle, IPath iPath) {
        return this.findTracker(new LocalChangeContext(iComponentHandle, iContextHandle, iPath));
    }

    public ILocalChange getPendingChange(IShareable iShareable, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        IShare iShare = iShareable.getShare((IProgressMonitor)subMonitor.newChild(50));
        if (iShare == null) {
            return NoOpChange.NO_OP;
        }
        return this.getPendingChange(iShare, iShareable.getVersionable((IProgressMonitor)subMonitor.newChild(50)));
    }

    public ILocalChange getPendingChange(IShare iShare, IVersionableHandle iVersionableHandle) {
        LocalChangeTracker localChangeTracker = this.findTracker(iShare.getSharingDescriptor().getConnectionHandle(), iShare.getSharingDescriptor().getComponent(), iShare.getSandbox().getRoot());
        return localChangeTracker == null ? NoOpChange.NO_OP : localChangeTracker.getPendingChange(iVersionableHandle);
    }

    public void syncPendingChanges(IContextHandle iContextHandle, IComponentHandle iComponentHandle, ISandbox iSandbox, IProgressMonitor iProgressMonitor) {
        LocalChangeTracker localChangeTracker = this.findTracker(iContextHandle, iComponentHandle, iSandbox.getRoot());
        if (localChangeTracker != null) {
            localChangeTracker.syncChanges(iProgressMonitor);
        }
    }

    public ILocalChange[] getPendingChanges(IContextHandle iContextHandle, IComponentHandle iComponentHandle, ISandbox iSandbox) {
        LocalChangeTracker localChangeTracker = this.findTracker(iContextHandle, iComponentHandle, iSandbox.getRoot());
        if (localChangeTracker == null) {
            return NO_CHANGES;
        }
        return localChangeTracker.getPendingChanges();
    }

    public ILocalChange[] getPendingChanges(IShareable[] iShareableArray, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        Object object;
        HashMap<LocalChangeContext, ArrayList<Object>> hashMap = new HashMap<LocalChangeContext, ArrayList<Object>>();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)iShareableArray.length);
        Object object2 = iShareableArray;
        int n = iShareableArray.length;
        int n2 = 0;
        while (n2 < n) {
            object = object2[n2];
            Object object3 = object.getShare((IProgressMonitor)subMonitor.newChild(1));
            if (object3 != null) {
                ISharingDescriptor iSharingDescriptor = object3.getSharingDescriptor();
                LocalChangeContext localChangeContext = new LocalChangeContext(iSharingDescriptor.getComponent(), iSharingDescriptor.getConnectionHandle(), object.getSandbox().getRoot());
                ArrayList<Object> arrayList = (ArrayList<Object>)hashMap.get(localChangeContext);
                if (arrayList == null) {
                    arrayList = new ArrayList<Object>();
                    hashMap.put(localChangeContext, arrayList);
                }
                arrayList.add(object);
            }
            ++n2;
        }
        object = new ArrayList();
        for (Map.Entry entry : hashMap.entrySet()) {
            object2 = this.findTracker((LocalChangeContext)entry.getKey());
            if (object2 == null) continue;
            for (Object object3 : (List)entry.getValue()) {
                object.addAll((Collection)Arrays.asList(((LocalChangeTracker)object2).getPendingChanges(object3.getLocalPath(), false)));
            }
        }
        return object.toArray(new ILocalChange[object.size()]);
    }

    public IShareable getShareable(LocalChange localChange) {
        Assert.isNotNull((Object)localChange.path);
        Assert.isNotNull((Object)localChange.target);
        Assert.isNotNull((Object)localChange.context);
        IPath iPath = localChange.isType(16) ? localChange.getResultingPath() : localChange.getPath();
        SharingManager sharingManager = SharingManager.getInstance();
        ISandbox iSandbox = sharingManager.getSandbox(localChange.context.getRoot(), false);
        return iSandbox.findShareable(iPath, ResourceType.getResourceType(localChange.getTarget()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocalChangeTracker getTracker(IContextHandle iContextHandle, IComponentHandle iComponentHandle, IPath iPath, ISchedulingRule iSchedulingRule) {
        Map map = this.trackers;
        synchronized (map) {
            LocalChangeContext localChangeContext = new LocalChangeContext(iComponentHandle, iContextHandle, iPath);
            LocalChangeTracker localChangeTracker = (LocalChangeTracker)this.trackers.get(localChangeContext);
            if (localChangeTracker == null) {
                localChangeTracker = new LocalChangeTracker(this.notifier, localChangeContext, iSchedulingRule);
                this.trackers.put(localChangeContext, localChangeTracker);
            }
            return localChangeTracker;
        }
    }

    public void loadChanges(IShare iShare, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        IShareable iShareable = iShare.getSandbox().findShareable(iShare.getPath(), ResourceType.getResourceType(iShare.getSharingDescriptor().getRootVersionable()));
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        ISchedulingRule iSchedulingRule = SharingManager.getInstance().getTrackingRule(iShare.getSandbox().getRoot());
        try {
            Job.getJobManager().beginRule(iSchedulingRule, (IProgressMonitor)subMonitor.newChild(5));
            LocalChangeTracker.computePendingChanges(iShareable, ILocalChangeManager$RefreshType.TRAVERSE_ALL_KNOWN, (IProgressMonitor)subMonitor.newChild(95));
        }
        finally {
            Job.getJobManager().endRule(iSchedulingRule);
            subMonitor.done();
        }
    }

    public void refreshAllChanges(IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        IShare[] iShareArray = SharingManager.getInstance().allShares((IProgressMonitor)subMonitor.newChild(1));
        this.refreshChanges(iShareArray, ILocalChangeManager$RefreshType.TRAVERSE_ALL_KNOWN, iProgressMonitor);
        subMonitor.done();
    }

    public void computeChanges(IShareable iShareable, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        LocalChangeTracker.computePendingChanges(iShareable, ILocalChangeManager$RefreshType.TRAVERSE_ALL_KNOWN, iProgressMonitor);
    }

    public void refreshChanges(Collection collection, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        this.refreshChanges(collection, ILocalChangeManager$RefreshType.TRAVERSE_ALL_KNOWN, iProgressMonitor);
    }

    public void refreshChanges(Collection collection, ILocalChangeManager$RefreshType iLocalChangeManager$RefreshType, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)(collection.size() * 2));
        for (IShareable iShareable : collection) {
            IShare iShare = iShareable.getShare((IProgressMonitor)subMonitor.newChild(1));
            if (iShare == null) {
                throw (Throwable)new IllegalArgumentException("Refresh root must be shared: " + iShareable.getLocalPath().toPortableString());
            }
            this.addToRefresh(iShare, iShareable, iLocalChangeManager$RefreshType);
        }
        subMonitor.setWorkRemaining(1);
        this.doRefresh((IProgressMonitor)subMonitor.newChild(1));
    }

    public void refreshChanges(IShare iShare, IShareable iShareable, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        this.addToRefresh(iShare, iShareable, ILocalChangeManager$RefreshType.TRAVERSE_ALL_KNOWN);
        this.doRefresh(iProgressMonitor);
    }

    public void refreshChanges(IShareable iShareable, ILocalChangeManager$RefreshType iLocalChangeManager$RefreshType, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)10);
        IShare iShare = iShareable.getShare((IProgressMonitor)subMonitor.newChild(1));
        if (iShare == null) {
            throw (Throwable)new IllegalArgumentException("Refresh root not shared.");
        }
        this.refreshSynchronously(iShare, iShareable, iLocalChangeManager$RefreshType, (IProgressMonitor)subMonitor.newChild(9));
    }

    public void refreshChanges(IShare[] iShareArray, ILocalChangeManager$RefreshType iLocalChangeManager$RefreshType, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        int n = 0;
        while (n < iShareArray.length) {
            this.addToRefresh(iShareArray[n], null, iLocalChangeManager$RefreshType);
            ++n;
        }
        this.doRefresh(iProgressMonitor);
    }

    public void refreshChanges(IContextHandle iContextHandle, IComponentHandle iComponentHandle, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        IShare[] iShareArray = SharingManager.getInstance().allShares((IProgressMonitor)subMonitor.newChild(1));
        int n = 0;
        while (n < iShareArray.length) {
            ISharingDescriptor iSharingDescriptor = iShareArray[n].getSharingDescriptor();
            if (iSharingDescriptor.getComponent().sameItemId((IItemHandle)iComponentHandle) && iSharingDescriptor.getConnectionHandle().sameItemId((IItemHandle)iContextHandle)) {
                this.addToRefresh(iShareArray[n], null, ILocalChangeManager$RefreshType.TRAVERSE_ALL_KNOWN);
            }
            ++n;
        }
        this.doRefresh((IProgressMonitor)subMonitor.newChild(99));
        subMonitor.done();
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public void undoChanges(ILocalChange[] var1_1, IRepositoryResolver var2_2, UndoDilemmaHandler var3_3, IProgressMonitor var4_4) throws FileSystemClientException, TeamRepositoryException {
        v0 = var5_5 = var3_3 == null ? UndoDilemmaHandler.getDefault() : var3_3;
        if (var1_1.length == 0) {
            return;
        }
        var6_6 = SharingManager.getInstance();
        var7_7 = var2_2 == null ? LocalChangeManager.DEFAULT_RESOLVER : var2_2;
        var8_8 = new HashMap<LocalChangeContext, Object>();
        var9_9 = new HashMap<LocalChangeContext, ITeamRepository>();
        var10_10 = SubMonitor.convert((IProgressMonitor)var4_4, (int)100);
        var11_11 = var10_10.newChild(1);
        var11_11.setWorkRemaining(var1_1.length);
        var12_12 = new HashMap<IPath, ArrayList<LocalChange>>();
        var16_13 = var1_1;
        var15_14 = var1_1.length;
        var14_17 = 0;
        while (var14_17 < var15_14) {
            var13_19 = var16_13[var14_17];
            var17_20 = (LocalChange)var13_19;
            var18_22 = (ITeamRepository)var9_9.get(var17_20.context);
            if (var18_22 != null) ** GOTO lbl34
            var19_23 = (Share)var6_6.getShare(var17_20.context.getRoot(), var17_20.getPath(), (IProgressMonitor)var11_11.newChild(1));
            if (var19_23 == null) {
                var20_24 = (ArrayList<LocalChange>)var12_12.get(var17_20.context.getRoot());
                if (var20_24 == null) {
                    var20_24 = new ArrayList<LocalChange>();
                    var12_12.put(var17_20.context.getRoot(), var20_24);
                }
                var20_24.add((LocalChange)var17_20);
            } else {
                var18_22 = var7_7.getRepoFor(var19_23.getSharingDescriptor().getRepositoryUri(), var19_23.getSharingDescriptor().getRepositoryId());
                var9_9.put(var17_20.context, var18_22);
lbl34:
                // 2 sources

                if ((var19_23 = (Set[])var8_8.get(var17_20.context)) == null) {
                    var19_23 = new Set[]{new HashSet<E>(), new HashSet<E>(), new HashSet<E>()};
                    var8_8.put(var17_20.context, var19_23);
                }
                if (var17_20.isType(4)) {
                    var19_23[0].add(var17_20);
                } else if (var17_20.isType(2)) {
                    var19_23[2].add(var17_20);
                } else if (var17_20.isType(16)) {
                    var19_23[1].add((LocalChange)var17_20.getCounterpart());
                } else {
                    var19_23[1].add(var17_20);
                }
            }
            ++var14_17;
        }
        var11_11.done();
        var13_19 = this.getConfigurationsAffected(var8_8, var9_9, var10_10.newChild(1));
        var14_18 = WorkspaceLockUtil.acquireRead((Collection)var13_19, (IProgressMonitor)var10_10.newChild(1));
        try {
            try {
                var6_6.runWithinFileSystemLock(new LocalChangeManager$1(this, var1_1, var5_5, (Collection)var13_19, var8_8, var9_9, var7_7), null, (IProgressMonitor)var10_10.newChild(95));
            }
            catch (InvocationTargetException var15_15) {
                var16_13 = var15_15.getCause();
                if (var16_13 instanceof TeamRepositoryException) {
                    throw (Throwable)var16_13;
                }
                if (var16_13 instanceof FileSystemClientException) {
                    throw (Throwable)var16_13;
                }
                throw (Throwable)new TeamRepositoryException(Messages.LocalChangeManager_12, (Throwable)var16_13);
            }
            catch (InterruptedException v1) {
                throw (Throwable)new OperationCanceledException();
            }
        }
        finally {
            WorkspaceLockUtil.release(var14_18);
        }
        if (!var12_12.isEmpty()) {
            var10_10.setWorkRemaining(var12_12.size() * 10);
            for (Map.Entry var15_16 : var12_12.entrySet()) {
                var17_20 = CFALockUtil.lockExistingForGlobalUpdate((IPath)var15_16.getKey(), (IProgressMonitor)var10_10.newChild(1));
                var18_22 = var10_10.newChild(8);
                var18_22.setWorkRemaining(((Collection)var15_16.getValue()).size());
                try {
                    for (Object var19_23 : (Collection)var15_16.getValue()) {
                        var21_25 = var19_23.getShareable();
                        if (var21_25 == null) continue;
                        try {
                            this.forget(var21_25, (IProgressMonitor)var18_22.newChild(1));
                        }
                        catch (FileSystemClientException v2) {}
                    }
                }
                finally {
                    if (var17_20 != null) {
                        CFALockUtil.endBatching((AbstractLock)var17_20, (IProgressMonitor)var10_10.newChild(1));
                    }
                }
            }
        }
        var10_10.done();
    }

    private HashSet getConfigurationsAffected(Map map, Map map2, SubMonitor subMonitor) throws TeamRepositoryException {
        HashSet<ConfigurationDescriptor> hashSet = new HashSet<ConfigurationDescriptor>();
        for (Map.Entry entry : map.entrySet()) {
            LocalChangeContext localChangeContext = (LocalChangeContext)entry.getKey();
            ITeamRepository iTeamRepository = (ITeamRepository)map2.get(localChangeContext);
            if (iTeamRepository == null) continue;
            hashSet.add(new ConfigurationDescriptor(iTeamRepository.getId(), iTeamRepository.getRepositoryURI(), localChangeContext.getConnection(), localChangeContext.getComponent()));
        }
        return hashSet;
    }

    private void undoChanges(LocalChangeTracker localChangeTracker, ITeamRepository iTeamRepository, Set[] setArray, IRepositoryResolver iRepositoryResolver, UpdateDilemmaHandler updateDilemmaHandler, Shed shed, IProgressMonitor iProgressMonitor) throws TeamRepositoryException, FileSystemClientException {
        if (iTeamRepository == null) {
            return;
        }
        if (localChangeTracker == null) {
            return;
        }
        ISchedulingRule iSchedulingRule = SharingManager.getInstance().getTrackingRule(localChangeTracker.getContext().getRoot());
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        try {
            Job.getJobManager().beginRule(iSchedulingRule, (IProgressMonitor)subMonitor.newChild(1));
            AbstractLock abstractLock = CFALockUtil.lockExistingForUpdate(localChangeTracker.getContext().getRoot(), localChangeTracker.getContext().getConnection(), localChangeTracker.getContext().getComponent(), (IProgressMonitor)subMonitor.newChild(1));
            if (abstractLock == null) {
                return;
            }
            try {
                Object object3;
                Set set;
                ICopyFileArea iCopyFileArea = CopyFileAreaManager.instance.getExistingCopyFileArea(localChangeTracker.getContext().getRoot());
                localChangeTracker.syncChanges((IProgressMonitor)subMonitor.newChild(1));
                Object object22 = setArray;
                int n = setArray.length;
                int n2 = 0;
                while (n2 < n) {
                    set = object22[n2];
                    Iterator iterator = set.iterator();
                    while (iterator.hasNext()) {
                        object3 = (LocalChange)iterator.next();
                        if (!((LocalChange)object3).isCanceled()) continue;
                        iterator.remove();
                    }
                    ++n2;
                }
                this.validateUndoPrereq(localChangeTracker, (CopyFileAreaStore)((Object)iCopyFileArea), setArray[0], setArray[1], setArray[2], (IProgressMonitor)subMonitor.newChild(1));
                set = localChangeTracker.getContext().getConnection() instanceof IBaselineHandle ? SCMPlatform.getWorkspaceManager((ITeamRepository)iTeamRepository).getBaselineConnection((IBaselineHandle)localChangeTracker.getContext().getConnection(), (IProgressMonitor)subMonitor.newChild(1)) : SCMPlatform.getWorkspaceManager((ITeamRepository)iTeamRepository).getWorkspaceConnection((IWorkspaceHandle)localChangeTracker.getContext().getConnection(), (IProgressMonitor)subMonitor.newChild(1));
                FileSystemServiceProxy fileSystemServiceProxy = ((FileSystemManager)FileSystemCore.getFileSystemManager(iTeamRepository)).getFileSystemService();
                SubMonitor subMonitor2 = subMonitor.newChild(93);
                subMonitor2.setWorkRemaining(setArray[0].size() + setArray[1].size() + setArray[2].size());
                for (Object object22 : setArray[0]) {
                    this.undoDeletion((LocalChange)object22, localChangeTracker, (CopyFileArea)iCopyFileArea, (IConnection)set, fileSystemServiceProxy, updateDilemmaHandler, (IProgressMonitor)subMonitor2.newChild(1));
                }
                int n3 = setArray[1].size() + setArray[2].size();
                while (true) {
                    object22 = new HashSet();
                    for (Object object3 : setArray[1]) {
                        if (!this.undoChange((LocalChange)object3, localChangeTracker, (CopyFileAreaStore)((Object)iCopyFileArea), (IConnection)set, shed, (IProgressMonitor)subMonitor2.newChild(1))) {
                            object22.add(object3);
                            subMonitor2.setWorkRemaining(n3);
                            continue;
                        }
                        --n3;
                    }
                    if (object22.isEmpty()) break;
                    if (setArray[1].size() == object22.size()) {
                        object3 = new StringBuilder(Messages.LocalChangeManager_13);
                        boolean bl = true;
                        Iterator iterator = object22.iterator();
                        while (iterator.hasNext()) {
                            LocalChange localChange = (LocalChange)iterator.next();
                            if (!bl) {
                                ((StringBuilder)object3).append(", ");
                            } else {
                                bl = false;
                            }
                            ((StringBuilder)object3).append(localChange.toString());
                            if (!localChange.isType(8)) continue;
                            ((StringBuilder)object3).append(" - ").append(localChange.getCounterpart().toString());
                        }
                        throw (Throwable)new IllegalStateException(((StringBuilder)object3).toString());
                    }
                    setArray[1] = object22;
                }
                for (Object object3 : setArray[2]) {
                    this.undoAddition((LocalChange)object3, localChangeTracker, (CopyFileAreaStore)((Object)iCopyFileArea), (IConnection)set, shed, (IProgressMonitor)subMonitor2.newChild(1));
                }
                subMonitor2.done();
            }
            finally {
                CFALockUtil.endBatching(abstractLock, (IProgressMonitor)subMonitor.newChild(1));
            }
        }
        finally {
            Job.getJobManager().endRule(iSchedulingRule);
            subMonitor.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateUndoPrereq(LocalChangeTracker localChangeTracker, CopyFileAreaStore copyFileAreaStore, Set set, Set set2, Set set3, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        Object object4;
        Object object2;
        SubMonitor subMonitor;
        Object object32;
        for (Object object32 : set) {
            subMonitor = localChangeTracker.getPendingChangesAt(((LocalChange)object32).getPath());
            object2 = subMonitor;
            int n = ((SubMonitor)object2).length;
            int n2 = 0;
            while (n2 < n) {
                object4 = object2[n2];
                if (object4.isType(2)) {
                    if (!set3.contains(object4)) {
                        throw (Throwable)((Object)new FileSystemClientException(new FileSystemStatus(NLS.bind((String)Messages.LocalChangeManager_16, (Object)((LocalChange)object32).getPath(), (Object)object4.getResultingPath()))));
                    }
                } else if (object4.isType(8)) {
                    if (!set2.contains(object4)) {
                        throw (Throwable)((Object)new FileSystemClientException(new FileSystemStatus(NLS.bind((String)Messages.LocalChangeManager_17, (Object)((LocalChange)object32).getPath(), (Object)object4.getResultingPath()))));
                    }
                } else if (!object4.equals(object32)) {
                    throw (Throwable)new IllegalStateException(NLS.bind((String)Messages.LocalChangeManager_18, (Object)object4, (Object)object32));
                }
                ++n2;
            }
        }
        object32 = localChangeTracker.getContext().getComponent();
        IContextHandle iContextHandle = localChangeTracker.getContext().getConnection();
        subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)set2.size());
        block5: for (Object object4 : set2) {
            Object object5;
            Object object6;
            ILocalChange[] iLocalChangeArray;
            if (!object4.isType(8)) {
                subMonitor.worked(1);
                continue;
            }
            IFolderHandle iFolderHandle = object4.getCounterpart().getTargetParent();
            object2 = subMonitor.newChild(1);
            object2.setWorkRemaining(2);
            IPath iPath = copyFileAreaStore.getLocalPathFor((IVersionableHandle)iFolderHandle, (IComponentHandle)object32, iContextHandle, (IProgressMonitor)object2.newChild(1));
            String string = object4.getCounterpart().getPath().lastSegment();
            if (iPath != null) {
                iLocalChangeArray = localChangeTracker.getPendingChangesAt(iPath.append(string));
                object6 = iLocalChangeArray;
                int n = iLocalChangeArray.length;
                int n3 = 0;
                while (n3 < n) {
                    object5 = object6[n3];
                    if (object5.isType(2)) {
                        if (!set3.contains(object5)) {
                            throw (Throwable)((Object)new FileSystemClientException(new FileSystemStatus(NLS.bind((String)Messages.LocalChangeManager_19, (Object)object4.getResultingPath(), (Object)object5.getResultingPath()))));
                        }
                    } else if (object5.isType(8)) {
                        if (!set2.contains(object5)) {
                            throw (Throwable)((Object)new FileSystemClientException(new FileSystemStatus(NLS.bind((String)Messages.LocalChangeManager_20, (Object)object4.getResultingPath(), (Object)object5.getResultingPath()))));
                        }
                    } else {
                        throw (Throwable)new IllegalStateException(NLS.bind((String)Messages.LocalChangeManager_21, (Object)object5, (Object)object4));
                    }
                    ++n3;
                }
            }
            iLocalChangeArray = new ArrayList();
            object5 = new HashSet<UUID>();
            object5.add(object4.getTarget().getItemId());
            Object object7 = object4;
            while (!copyFileAreaStore.isShareRoot((IVersionableHandle)iFolderHandle, object4.getComponent(), object4.getConnection())) {
                iLocalChangeArray.add(iFolderHandle);
                InverseFileItemInfo inverseFileItemInfo = copyFileAreaStore.getItemInfo((IVersionableHandle)iFolderHandle, object4.getComponent(), object4.getConnection());
                if (inverseFileItemInfo == null) {
                    throw (Throwable)new IllegalStateException(NLS.bind((String)Messages.LocalChangeManager_InverseMetadataMissing, (Object)object4.getShareable().getLocalPath()));
                }
                object6 = localChangeTracker.getPendingChange((IVersionableHandle)iFolderHandle);
                if (object6.isType(4)) {
                    if (!set.contains(object6)) {
                        throw (Throwable)((Object)new FileSystemClientException(new FileSystemStatus(NLS.bind((String)Messages.LocalChangeManager_22, (Object)object7.getResultingPath(), (Object)object6.getPath()))));
                    }
                    iFolderHandle = inverseFileItemInfo.getParent();
                } else if (object6.isType(2)) {
                    if (set3.contains(object6)) continue block5;
                    iFolderHandle = inverseFileItemInfo.getLocalParent();
                } else if (object6.isType(8)) {
                    if (set2.contains(object6)) {
                        iFolderHandle = inverseFileItemInfo.getParent();
                        object7 = object6;
                    } else {
                        iFolderHandle = inverseFileItemInfo.getLocalParent();
                    }
                } else {
                    iFolderHandle = inverseFileItemInfo.getLocalParent();
                    if (iFolderHandle == null) {
                        iFolderHandle = inverseFileItemInfo.getParent();
                    }
                }
                if (object5.contains(iFolderHandle.getItemId())) {
                    iLocalChangeArray.add(iFolderHandle);
                    object2.setWorkRemaining(iLocalChangeArray.size());
                    HashMap<UUID, IFolderHandle> hashMap = new HashMap<UUID, IFolderHandle>((int)((double)iLocalChangeArray.size() / 0.75));
                    HashSet<UUID> hashSet = new HashSet<UUID>((int)((double)iLocalChangeArray.size() / 0.75));
                    int n = 0;
                    while (n < iLocalChangeArray.size()) {
                        IFolderHandle iFolderHandle2 = (IFolderHandle)iLocalChangeArray.get(n);
                        ILocalChange iLocalChange = localChangeTracker.getPendingChange((IVersionableHandle)iFolderHandle2);
                        hashSet.add(iFolderHandle2.getItemId());
                        if (iLocalChange.isType(8)) {
                            if (set2.contains(iLocalChange)) {
                                UUID uUID;
                                HashSet hashSet2 = new HashSet(hashMap.keySet());
                                while ((uUID = copyFileAreaStore.getRemoteAncestor(hashSet2, (IVersionableHandle)iFolderHandle2, object4.getComponent(), object4.getConnection(), (IProgressMonitor)object2.newChild(1))) != null) {
                                    ILocalChange iLocalChange2 = localChangeTracker.getPendingChange((IVersionableHandle)hashMap.get(uUID));
                                    if (!hashSet.contains(iLocalChange2.getCounterpart().getTargetParent().getItemId())) {
                                        throw (Throwable)((Object)new FileSystemClientException(new FileSystemStatus(NLS.bind((String)Messages.LocalChangeManager_23, (Object)iLocalChange.getResultingPath(), (Object)iLocalChange2.getResultingPath()))));
                                    }
                                    hashSet2.remove(uUID);
                                }
                            } else {
                                hashMap.put(iFolderHandle2.getItemId(), iFolderHandle2);
                            }
                        }
                        ++n;
                    }
                    throw (Throwable)new IllegalStateException(Messages.LocalChangeManager_24);
                }
                object5.add(iFolderHandle.getItemId());
            }
            object2.done();
        }
        object4 = new FileSystemClientException[1];
        LocalChangeTracker localChangeTracker2 = localChangeTracker;
        synchronized (localChangeTracker2) {
            for (LocalChange localChange : set3) {
                localChange.getNode().basicAccept(new LocalChangeManager$2(this, localChange, set3, (FileSystemClientException[])object4, set2));
                if (object4[0] == null) continue;
                throw (Throwable)object4[0];
            }
        }
        subMonitor.done();
    }

    private void undoDeletion(LocalChange localChange, LocalChangeTracker localChangeTracker, CopyFileArea copyFileArea, IConnection iConnection, FileSystemServiceProxy fileSystemServiceProxy, UpdateDilemmaHandler updateDilemmaHandler, IProgressMonitor iProgressMonitor) throws FileSystemClientException, TeamRepositoryException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        LoadTree loadTree = fileSystemServiceProxy.getFileTreeByVersionable(iConnection, localChange.getComponent(), new IVersionableHandle[]{localChange.getTarget()}, -1, true, null, (IProgressMonitor)subMonitor);
        FileAreaUpdateReport fileAreaUpdateReport = this.getUpdatesForDeletion(localChange, localChangeTracker, loadTree.getFileAreaUpdates());
        ComponentStateSummary componentStateSummary = ScmDtoFactory.eINSTANCE.createComponentStateSummary();
        componentStateSummary.setComponent(localChange.getComponent());
        componentStateSummary.setConfigurationState(((SynchronizationTime)loadTree.getConfigurationState()).getTime());
        List<ComponentStateSummary> list = Collections.singletonList(componentStateSummary);
        SharingManager sharingManager = SharingManager.getInstance();
        subMonitor.worked(50);
        IPath iPath = copyFileArea.getLocalPathFor((IVersionableHandle)localChange.getTargetParent(), localChange.getComponent(), localChange.getConnection(), (IProgressMonitor)subMonitor.newChild(1));
        if (iPath == null) {
            this.forget(localChange.getShareable(), (IProgressMonitor)subMonitor.newChild(1));
        } else {
            subMonitor.setWorkRemaining(100);
            sharingManager.getUpdateMutator(iConnection, list, list, fileAreaUpdateReport, Collections.singletonList(copyFileArea), updateDilemmaHandler, null).run((IProgressMonitor)subMonitor.newChild(100));
        }
        subMonitor.done();
    }

    private FileAreaUpdateReport getUpdatesForDeletion(LocalChange localChange, LocalChangeTracker localChangeTracker, List list) throws TeamRepositoryException {
        FileAreaUpdateReport fileAreaUpdateReport = FilesystemDTOFactory.eINSTANCE.createFileAreaUpdateReport();
        HashSet<UUID> hashSet = new HashSet<UUID>();
        for (FileAreaUpdate fileAreaUpdate : list) {
            if (localChange.getTarget().sameItemId((IItemHandle)fileAreaUpdate.getItem()) || !hashSet.contains(fileAreaUpdate.getDestinationParent().getItemId()) && localChangeTracker.getPendingChange(fileAreaUpdate.getItem()).getType() == 0) {
                fileAreaUpdateReport.getAdds().add(fileAreaUpdate);
                continue;
            }
            hashSet.add(fileAreaUpdate.getItem().getItemId());
        }
        return fileAreaUpdateReport;
    }

    private void preserve(IFileStorage iFileStorage, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        IFileStorage iFileStorage2 = ((Shareable)iFileStorage.getShareable().getParent()).getFileStorage();
        String string = String.valueOf(iFileStorage.getName()) + BACKUP_NAME;
        int n = 2;
        String string2 = string;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        while (iFileStorage2.getChild(string2, (IProgressMonitor)subMonitor.newChild(1)) != null) {
            string2 = String.valueOf(string) + Integer.toString(n++);
            subMonitor.setWorkRemaining(100);
        }
        Share share = (Share)iFileStorage.getShareable().getShare((IProgressMonitor)subMonitor.newChild(18));
        ResourceType resourceType = iFileStorage.getResourceType((IProgressMonitor)subMonitor.newChild(1));
        if (resourceType == null) {
            resourceType = ResourceType.getResourceType(iFileStorage.getShareable().getVersionable((IProgressMonitor)subMonitor.newChild(1)));
        }
        Shareable shareable = share.getShareable(iFileStorage2.getShareable().getLocalPath().append(string2), resourceType);
        iFileStorage.move(shareable.getSandbox(), shareable.getLocalPath(), (IProgressMonitor)subMonitor.newChild(80));
        subMonitor.done();
    }

    private boolean undoChange(LocalChange localChange, LocalChangeTracker localChangeTracker, CopyFileAreaStore copyFileAreaStore, IConnection iConnection, Shed shed, IProgressMonitor iProgressMonitor) throws FileSystemClientException, TeamRepositoryException {
        Object object;
        IFileStorage iFileStorage;
        Object object2;
        IFileStorage iFileStorage2;
        Object object3;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        Object object4 = copyFileAreaStore.getLocalPathFor(localChange.getTarget(), localChange.getComponent(), localChange.getConnection(), (IProgressMonitor)subMonitor.newChild(1));
        SharingManager sharingManager = SharingManager.getInstance();
        ISandbox iSandbox = sharingManager.getSandbox(localChange.context.getRoot(), false);
        Object object5 = sharingManager.findShareable(iSandbox, (IPath)object4, ResourceType.getResourceType(localChange.getTarget()));
        if (localChange.isType(8)) {
            object3 = subMonitor.newChild(localChange.isType(1) ? 19 : 99);
            object3.setWorkRemaining(100);
            iFileStorage2 = copyFileAreaStore.getLocalPathFor((IVersionableHandle)localChange.getCounterpart().getTargetParent(), localChange.getComponent(), localChange.getConnection(), (IProgressMonitor)object3.newChild(20)).append(localChange.getCounterpart().getPath().lastSegment());
            if (object4.isPrefixOf((IPath)iFileStorage2)) {
                object3.done();
                subMonitor.done();
                return false;
            }
            object2 = sharingManager.findShareable(iSandbox, (IPath)iFileStorage2, ResourceType.getResourceType(localChange.getTarget()));
            iFileStorage = ((Shareable)object2).getFileStorage();
            object = ((Shareable)((Shareable)object2).getParent()).getFileStorage().getChild(iFileStorage.getName(), (IProgressMonitor)object3.newChild(1));
            if (object != null && (iSandbox.isCaseSensitive() || !this.isSamePathWithCaseChangeInName((IPath)iFileStorage2, (IPath)object4))) {
                this.preserve((IFileStorage)object, (IProgressMonitor)object3.newChild(19));
            }
            if (iFileStorage2.isPrefixOf((IPath)object4)) {
                object4 = copyFileAreaStore.getLocalPathFor(localChange.getTarget(), localChange.getComponent(), localChange.getConnection(), (IProgressMonitor)object3.newChild(20));
                object5 = sharingManager.findShareable(iSandbox, (IPath)object4, ResourceType.getResourceType(localChange.getTarget()));
            }
            object3.setWorkRemaining(40);
            ((Shareable)object5).getFileStorage().move(((Shareable)object2).getSandbox(), ((Shareable)object2).getLocalPath(), (IProgressMonitor)object3.newChild(40));
            object4 = iFileStorage2;
            object5 = object2;
            object3.done();
        }
        object3 = null;
        if (localChange.isType(1)) {
            subMonitor.setWorkRemaining(100);
            object3 = copyFileAreaStore.getItemInfo((IPath)object4);
            if (object3 == null) {
                return true;
            }
            if (((FileItemInfo)object3).getVersionableHandle() instanceof IFileItemHandle) {
                iFileStorage2 = ((Shareable)object5).getFileStorage();
                object2 = FilesystemFactory.eINSTANCE.createFileContent();
                ContentHash contentHash = ((FileItemInfo)object3).getStoredPredecessorHintHash();
                object2.setPredecessorHint(contentHash);
                object2.setLineDelimiter(((FileItemInfo)object3).getOriginalLineDelimiter());
                object2.setSize(((FileItemInfo)object3).getStoredSize());
                object2.setCharacterEncoding(((FileItemInfo)object3).getStoredEncoding());
                object2.setHash(((FileItemInfo)object3).getStoredHash());
                object2.setLineDelimiterCount(((FileItemInfo)object3).getStoredNumLineDelimiters());
                boolean bl = ((FileItemInfo)object3).isExecutable();
                boolean bl2 = ((FileItemInfo)object3).isOriginalExecutable();
                String string = ((FileItemInfo)object3).getContentType();
                String string2 = ((FileItemInfo)object3).getOriginalContentType();
                IFileContentManager iFileContentManager = FileSystemCore.getContentManager(iConnection.teamRepository());
                DigestComputingInputStream digestComputingInputStream = ContentHash.getDigestComputingStream((InputStream)iFileContentManager.retrieveContentStream((IFileItemHandle)localChange.getTarget(), (IFileContent)object2, (IProgressMonitor)subMonitor.newChild(68)));
                iFileStorage2.setContents((InputStream)digestComputingInputStream, shed, (IProgressMonitor)new CancellationMonitor((IProgressMonitor)subMonitor));
                FileItemInfo fileItemInfo = new FileItemInfo(((FileItemInfo)object3).getVersionableHandle(), false, iFileStorage2.getModificationStamp(), ((FileItemInfo)object3).getParent(), ((FileItemInfo)object3).getName(), ((FileItemInfo)object3).isLoadedWithAnotherName(), ContentHash.valueOf((byte[])digestComputingInputStream.getFinalDigest()), digestComputingInputStream.getContentSize(), object2.getLineDelimiter(), object2.getLineDelimiter(), string2, string, object2.getPredecessorHintHash(), object2.getSize(), object2.getCharacterEncoding(), object2.getHash(), object2.getLineDelimiterCount(), bl, bl2);
                copyFileAreaStore.setItemInfo(object5.getLocalPath(), fileItemInfo, (IProgressMonitor)subMonitor.newChild(1));
                object3 = fileItemInfo;
            } else if (((FileItemInfo)object3).getVersionableHandle() instanceof ISymbolicLinkHandle) {
                iFileStorage2 = (ISymbolicLink)SCMPlatform.getWorkspaceManager((ITeamRepository)iConnection.teamRepository()).versionableManager().fetchCompleteState(((FileItemInfo)object3).getVersionableHandle(), (IProgressMonitor)subMonitor.newChild(1));
                object2 = iFileStorage2.getTarget();
                iFileStorage = ((Shareable)object5).getFileStorage();
                iFileStorage.setTarget(shed, (String)object2, (IProgressMonitor)subMonitor.newChild(1));
                object = iFileStorage.getTarget((IProgressMonitor)subMonitor.newChild(1));
                try {
                    FileItemInfo fileItemInfo = new FileItemInfo((ISymbolicLinkHandle)((FileItemInfo)object3).getVersionableHandle(), false, ((FileItemInfo)object3).getParent(), ((FileItemInfo)object3).getName(), ((FileItemInfo)object3).isLoadedWithAnotherName(), LocalChangeTracker.getLinkHash((String)object), ((FileItemInfo)object3).getStoredHash());
                    copyFileAreaStore.setItemInfo(object5.getLocalPath(), fileItemInfo, (IProgressMonitor)subMonitor.newChild(1));
                    object3 = fileItemInfo;
                }
                catch (ContentHashAlgorithmException contentHashAlgorithmException) {
                    throw (Throwable)new TeamRepositoryException((Throwable)contentHashAlgorithmException);
                }
                catch (IOException iOException) {
                    throw (Throwable)new TeamRepositoryException((Throwable)iOException);
                }
            }
        }
        if (localChange.isType(32)) {
            subMonitor.setWorkRemaining(1);
            if (object3 == null) {
                object3 = copyFileAreaStore.getItemInfo((IPath)object4);
            }
            if (object3 == null) {
                return true;
            }
            iFileStorage2 = ((Shareable)object5).getFileStorage();
            iFileStorage2.setExecutable(((FileItemInfo)object3).isOriginalExecutable(), (IProgressMonitor)subMonitor.newChild(1));
            object2 = new FileItemInfo(((FileItemInfo)object3).getVersionableHandle(), false, iFileStorage2.getModificationStamp(), ((FileItemInfo)object3).getParent(), ((FileItemInfo)object3).getName(), ((FileItemInfo)object3).isLoadedWithAnotherName(), ((FileItemInfo)object3).getHash(), ((FileItemInfo)object3).getContentLength(), ((FileItemInfo)object3).getOriginalLineDelimiter(), ((FileItemInfo)object3).getOriginalLineDelimiter(), ((FileItemInfo)object3).getOriginalContentType(), ((FileItemInfo)object3).getOriginalContentType(), ((FileItemInfo)object3).getStoredPredecessorHintHash(), ((FileItemInfo)object3).getStoredSize(), ((FileItemInfo)object3).getStoredEncoding(), ((FileItemInfo)object3).getStoredHash(), ((FileItemInfo)object3).getStoredNumLineDelimiters(), ((FileItemInfo)object3).isOriginalExecutable(), ((FileItemInfo)object3).isOriginalExecutable());
            copyFileAreaStore.setItemInfo(object5.getLocalPath(), (FileItemInfo)object2, (IProgressMonitor)subMonitor.newChild(1));
        }
        subMonitor.done();
        return true;
    }

    private boolean isSamePathWithCaseChangeInName(IPath iPath, IPath iPath2) {
        return iPath.segmentCount() == iPath2.segmentCount() && iPath.removeLastSegments(1).equals((Object)iPath2.removeLastSegments(1)) && iPath.lastSegment().toUpperCase().equals(iPath2.lastSegment().toUpperCase());
    }

    private void undoAddition(LocalChange localChange, LocalChangeTracker localChangeTracker, CopyFileAreaStore copyFileAreaStore, IConnection iConnection, Shed shed, IProgressMonitor iProgressMonitor) throws FileSystemClientException, TeamRepositoryException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        IPath iPath = copyFileAreaStore.getLocalPathFor(localChange.getTarget(), localChange.getComponent(), localChange.getConnection(), (IProgressMonitor)subMonitor.newChild(1));
        if (iPath != null) {
            SharingManager sharingManager = SharingManager.getInstance();
            ISandbox iSandbox = sharingManager.getSandbox(localChange.context.getRoot(), false);
            Shareable shareable = sharingManager.findShareable(iSandbox, iPath, ResourceType.getResourceType(localChange.getTarget()));
            shareable.getFileStorage().delete(shed, (IProgressMonitor)subMonitor.newChild(99));
        }
        subMonitor.done();
    }

    public void removeLocalChangeListener(ILocalChangeListener iLocalChangeListener) {
        this.notifier.removeListener(iLocalChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToRefresh(IShare iShare, IShareable iShareable, ILocalChangeManager$RefreshType iLocalChangeManager$RefreshType) {
        Object object = this.refreshLock;
        synchronized (object) {
            this.toRefresh.add(new LocalChangeManager$RefreshRequest(iShare, iShareable, iLocalChangeManager$RefreshType));
            this.recomputeJob.schedule(500L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToRefresh(IShare iShare, IShareable iShareable) {
        Object object = this.refreshLock;
        synchronized (object) {
            this.toRefresh.add(new LocalChangeManager$RefreshRequest(iShare, iShareable, ILocalChangeManager$RefreshType.TRAVERSE_ALL_KNOWN));
            this.recomputeJob.schedule(500L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginAvoidNotify() {
        Object object = this.avoidNotification;
        synchronized (object) {
            ++this.avoidNotificationCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endAvoidNotify() throws FileSystemClientException {
        Object object = this.avoidNotification;
        synchronized (object) {
            --this.avoidNotificationCount;
            Assert.isTrue((this.avoidNotificationCount >= 0 ? 1 : 0) != 0, (String)"Unmatched start/end notification");
            if (this.avoidNotificationCount < 0) {
                this.avoidNotificationCount = 0;
            }
            if (this.avoidNotificationCount == 0) {
                this.notifier.scheduleNotification();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isNotificationEnabled() {
        Object object = this.avoidNotification;
        synchronized (object) {
            return this.avoidNotificationCount == 0;
        }
    }

    public ILocalChange[] getPendingChanges(IShare[] iShareArray) {
        Object object;
        HashMap<Object, ArrayList<IPath>> hashMap = new HashMap<Object, ArrayList<IPath>>();
        Object object2 = iShareArray;
        int n = iShareArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISharingDescriptor iSharingDescriptor;
            object = object2[n2];
            if (object != null && (iSharingDescriptor = object.getSharingDescriptor()) != null) {
                LocalChangeContext localChangeContext = new LocalChangeContext(iSharingDescriptor.getComponent(), iSharingDescriptor.getConnectionHandle(), object.getSandbox().getRoot());
                ArrayList<IPath> arrayList = (ArrayList<IPath>)hashMap.get(localChangeContext);
                if (arrayList == null) {
                    arrayList = new ArrayList<IPath>();
                    hashMap.put(localChangeContext, arrayList);
                }
                arrayList.add(object.getPath());
            }
            ++n2;
        }
        object = new ArrayList();
        for (Map.Entry entry : hashMap.entrySet()) {
            object2 = this.findTracker((LocalChangeContext)entry.getKey());
            if (object2 == null) continue;
            for (ISharingDescriptor iSharingDescriptor : (List)entry.getValue()) {
                object.addAll((Collection)Arrays.asList(((LocalChangeTracker)object2).getPendingChanges((IPath)iSharingDescriptor, false)));
            }
        }
        return object.toArray(new ILocalChange[object.size()]);
    }

    public void undoChanges(ILocalChange[] iLocalChangeArray, UndoDilemmaHandler undoDilemmaHandler, IProgressMonitor iProgressMonitor) throws FileSystemClientException, TeamRepositoryException {
        this.undoChanges(iLocalChangeArray, null, undoDilemmaHandler, iProgressMonitor);
    }

    public boolean isContentDirty(IShareable iShareable, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        AbstractLock abstractLock = CFALockUtil.lockExistingForRead(iShareable.getSandbox().getRoot(), (IProgressMonitor)subMonitor.newChild(10));
        if (abstractLock == null) {
            throw (Throwable)new IllegalArgumentException("The cfa must exist");
        }
        try {
            FileItemInfo fileItemInfo = ((CopyFileAreaStore)((Object)CopyFileAreaManager.instance.getExistingCopyFileArea(iShareable.getSandbox().getRoot()))).getItemInfo(iShareable.getLocalPath());
            if (fileItemInfo != null && !fileItemInfo.isFolder()) {
                if (iShareable.getResourceType((IProgressMonitor)subMonitor.newChild(1)) == ResourceType.FOLDER) {
                    return true;
                }
                boolean bl = fileItemInfo.isContentChanged();
                return bl;
            }
            return false;
        }
        finally {
            CFALockUtil.endBatching(abstractLock, (IProgressMonitor)subMonitor.newChild(10));
        }
    }

    public void combineDeleteAdd(ILocalChange iLocalChange, ILocalChange iLocalChange2, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        this.combineDeleteAdd(DEFAULT_RESOLVER, iLocalChange, iLocalChange2, iProgressMonitor);
    }

    public void combineDeleteAdd(IRepositoryResolver iRepositoryResolver, ILocalChange iLocalChange, ILocalChange iLocalChange2, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        if (iLocalChange == null || !iLocalChange.isType(4)) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (iLocalChange2 == null || !iLocalChange2.isType(2)) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (!iLocalChange.getConnection().sameItemId((IItemHandle)iLocalChange2.getConnection())) {
            throw (Throwable)new IllegalArgumentException("Changes must be in the same workspace");
        }
        if (!iLocalChange.getComponent().sameItemId((IItemHandle)iLocalChange2.getComponent())) {
            throw (Throwable)new IllegalArgumentException("Changes must be in the same component");
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        SharingManager sharingManager = SharingManager.getInstance();
        Object object = iLocalChange.getShareable();
        if (object == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        Object object2 = iLocalChange2.getShareable();
        if (object2 == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (!object.getSandbox().getRoot().equals((Object)object2.getSandbox().getRoot())) {
            throw (Throwable)new IllegalArgumentException("Changes have different roots");
        }
        IVersionableHandle iVersionableHandle = iLocalChange.getTarget();
        if (iVersionableHandle == null) {
            throw (Throwable)new IllegalArgumentException("No versionable");
        }
        FileSystemClientException[] fileSystemClientExceptionArray = object.getShare((IProgressMonitor)subMonitor.newChild(1));
        if (fileSystemClientExceptionArray == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        ITeamRepository iTeamRepository = iRepositoryResolver.getRepoFor(fileSystemClientExceptionArray.getSharingDescriptor().getRepositoryUri(), fileSystemClientExceptionArray.getSharingDescriptor().getRepositoryId());
        ISandbox iSandbox = ((Share)fileSystemClientExceptionArray).getSandbox();
        object = new ConfigurationDescriptor(iTeamRepository.getId(), iTeamRepository.getRepositoryURI(), iLocalChange2.getConnection(), iLocalChange2.getComponent());
        object2 = WorkspaceLockUtil.acquireRead(Collections.singleton(object), (IProgressMonitor)subMonitor.newChild(1));
        try {
            try {
                fileSystemClientExceptionArray = new FileSystemClientException[1];
                sharingManager.runWithinFileSystemLock(new LocalChangeManager$3(this, iLocalChange2, iSandbox, iLocalChange, iVersionableHandle, fileSystemClientExceptionArray), null, (IProgressMonitor)subMonitor.newChild(98));
                if (fileSystemClientExceptionArray[0] != null) {
                    throw (Throwable)((Object)fileSystemClientExceptionArray[0]);
                }
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
                WorkspaceLockUtil.release((FlowNodeLock)object2);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
                WorkspaceLockUtil.release((FlowNodeLock)object2);
            }
        }
        finally {
            WorkspaceLockUtil.release((FlowNodeLock)object2);
        }
    }

    private void combineDeleteAddInternal(CopyFileAreaStore copyFileAreaStore, IVersionableHandle iVersionableHandle, ILocalChange iLocalChange, ILocalChange iLocalChange2, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        IComponentHandle iComponentHandle = iLocalChange.getComponent();
        IContextHandle iContextHandle = iLocalChange.getConnection();
        Shareable shareable = (Shareable)((LocalChange)iLocalChange2).getShareable();
        LinkedList<Shareable> linkedList = new LinkedList<Shareable>();
        LinkedList<IVersionableHandle> linkedList2 = new LinkedList<IVersionableHandle>();
        linkedList.add(shareable);
        linkedList2.add(iVersionableHandle);
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        while (!linkedList.isEmpty()) {
            if (!$assertionsDisabled && linkedList2.isEmpty()) {
                throw (Throwable)((Object)new AssertionError());
            }
            subMonitor.setWorkRemaining(linkedList.size() + 4);
            Shareable shareable2 = (Shareable)linkedList.removeFirst();
            IVersionableHandle iVersionableHandle2 = (IVersionableHandle)linkedList2.removeFirst();
            InverseFileItemInfo inverseFileItemInfo = copyFileAreaStore.getItemInfo(iVersionableHandle2, iComponentHandle, iContextHandle);
            copyFileAreaStore.setItemInfo(shareable2.getLocalPath(), inverseFileItemInfo, (IProgressMonitor)subMonitor.newChild(1));
            Map map = inverseFileItemInfo.getRemoteChildren();
            IFileStorage iFileStorage = shareable2.getFileStorage();
            Collection collection = iFileStorage.getChildren((IProgressMonitor)subMonitor.newChild(1));
            if (collection != null) {
                SubMonitor subMonitor2 = subMonitor.newChild(1);
                subMonitor2.setWorkRemaining(collection.size());
                for (IFileStorage iFileStorage2 : collection) {
                    Shareable shareable3 = iFileStorage2.getShareable();
                    if (!$assertionsDisabled && !shareable3.exists((IProgressMonitor)subMonitor2.newChild(1))) {
                        throw (Throwable)((Object)new AssertionError());
                    }
                    IVersionableHandle iVersionableHandle3 = (IVersionableHandle)map.get(iFileStorage2.getName());
                    if (iVersionableHandle3 == null) continue;
                    linkedList.addFirst(shareable3);
                    linkedList2.addFirst(iVersionableHandle3);
                }
            }
            if (shareable2.getResourceType((IProgressMonitor)subMonitor.newChild(1)) == ResourceType.FOLDER) continue;
            this.refreshChanges(shareable2.getShare((IProgressMonitor)subMonitor.newChild(10)), shareable2, (IProgressMonitor)subMonitor.newChild(10));
        }
        if (!$assertionsDisabled && !linkedList2.isEmpty()) {
            throw (Throwable)((Object)new AssertionError());
        }
        subMonitor.done();
    }

    public void refreshChanges(ISandbox[] iSandboxArray, ILocalChangeManager$RefreshType iLocalChangeManager$RefreshType, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)(100 + iSandboxArray.length));
        ArrayList arrayList = new ArrayList();
        ISandbox[] iSandboxArray2 = iSandboxArray;
        int n = iSandboxArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISandbox iSandbox = iSandboxArray2[n2];
            IShare[] iShareArray = iSandbox.allShares((IProgressMonitor)subMonitor.newChild(1));
            arrayList.addAll(Arrays.asList(iShareArray));
            ++n2;
        }
        if (!arrayList.isEmpty()) {
            this.refreshChanges(arrayList.toArray(new IShare[arrayList.size()]), iLocalChangeManager$RefreshType, (IProgressMonitor)subMonitor.newChild(100));
        }
    }

    private void forget(IShareable iShareable, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        IPath iPath = ((Shareable)iShareable).getCopyFileAreaRoot();
        AbstractLock abstractLock = CFALockUtil.lockExistingForGlobalUpdate(iPath, (IProgressMonitor)subMonitor.newChild(1));
        if (abstractLock == null) {
            return;
        }
        try {
            CopyFileArea copyFileArea = (CopyFileArea)ICopyFileAreaManager.instance.getExistingCopyFileArea(iPath);
            copyFileArea.deleteTreeInfo(iShareable.getLocalPath(), true, (IProgressMonitor)subMonitor.newChild(74));
        }
        finally {
            CFALockUtil.endBatching(abstractLock, (IProgressMonitor)subMonitor.newChild(1));
            subMonitor.done();
        }
    }

    static /* synthetic */ LocalChangeTracker access$0(LocalChangeManager localChangeManager, LocalChangeContext localChangeContext) {
        return localChangeManager.findTracker(localChangeContext);
    }

    static /* synthetic */ void access$1(LocalChangeManager localChangeManager, LocalChangeTracker localChangeTracker, ITeamRepository iTeamRepository, Set[] setArray, IRepositoryResolver iRepositoryResolver, UpdateDilemmaHandler updateDilemmaHandler, Shed shed, IProgressMonitor iProgressMonitor) throws TeamRepositoryException, FileSystemClientException {
        localChangeManager.undoChanges(localChangeTracker, iTeamRepository, setArray, iRepositoryResolver, updateDilemmaHandler, shed, iProgressMonitor);
    }

    static /* synthetic */ void access$2(LocalChangeManager localChangeManager, CopyFileAreaStore copyFileAreaStore, IVersionableHandle iVersionableHandle, ILocalChange iLocalChange, ILocalChange iLocalChange2, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        localChangeManager.combineDeleteAddInternal(copyFileAreaStore, iVersionableHandle, iLocalChange, iLocalChange2, iProgressMonitor);
    }
}

