/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.load;

import com.ibm.team.filesystem.client.internal.load.IUpdateInfo;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.common.ISymbolicLinkHandle;
import com.ibm.team.filesystem.common.internal.dto.FileAreaUpdate;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class UpdateOrder
implements IUpdateInfo {
    private List folderAdds;
    private List linkAdds;
    private List fileAdds;
    private List orderedDeletes;
    private Map movedOrDeletedItemIds = new HashMap();
    private List folderMoves;
    private List linkMoves;
    private List fileMoves;
    private List groupedModifies;

    public UpdateOrder(Collection collection, Collection collection2, Collection collection3, Collection collection4) {
        this.orderAdds(collection);
        this.orderModifies(collection4);
        this.orderDeletes(collection2);
        this.orderMoves(collection3);
    }

    public List getOrderedDeletes() {
        return this.orderedDeletes;
    }

    private void orderDeletes(Collection collection) {
        this.orderedDeletes = new ArrayList(collection.size());
        HashMap hashMap = this.group(collection);
        for (Map.Entry entry : hashMap.entrySet()) {
            UUID uUID = (UUID)entry.getKey();
            List list = (List)entry.getValue();
            HashMap<UUID, ArrayList<FileAreaUpdate>> hashMap2 = new HashMap<UUID, ArrayList<FileAreaUpdate>>();
            for (FileAreaUpdate fileAreaUpdate : list) {
                UUID uUID2 = fileAreaUpdate.getSourceParent().getItemId();
                ArrayList<FileAreaUpdate> arrayList = (ArrayList<FileAreaUpdate>)hashMap2.get(uUID2);
                if (arrayList == null) {
                    arrayList = new ArrayList<FileAreaUpdate>();
                    hashMap2.put(uUID2, arrayList);
                }
                arrayList.add(fileAreaUpdate);
                HashSet<UUID> hashSet = (HashSet<UUID>)this.movedOrDeletedItemIds.get(uUID);
                if (hashSet == null) {
                    hashSet = new HashSet<UUID>();
                    this.movedOrDeletedItemIds.put(uUID, hashSet);
                }
                hashSet.add(fileAreaUpdate.getItem().getItemId());
            }
            this.orderedDeletes.addAll(this.calculateOrdering(hashMap2));
        }
    }

    public List getFolderAdds() {
        return this.folderAdds;
    }

    public List getLinkAdds() {
        return this.linkAdds;
    }

    public List getFileAdds() {
        return this.fileAdds;
    }

    private void orderAdds(Collection collection) {
        this.folderAdds = new ArrayList(collection.size() / 2 + 1);
        this.fileAdds = new ArrayList(collection.size() / 2 + 1);
        this.linkAdds = new ArrayList();
        HashMap hashMap = this.calculateOrderedAdds(collection);
        for (List list : hashMap.values()) {
            for (FileAreaUpdate fileAreaUpdate : list) {
                if (fileAreaUpdate.getItem() instanceof IFolderHandle) {
                    this.folderAdds.add(fileAreaUpdate);
                    continue;
                }
                if (fileAreaUpdate.getItem() instanceof IFileItemHandle) {
                    this.fileAdds.add(fileAreaUpdate);
                    continue;
                }
                if (!(fileAreaUpdate.getItem() instanceof ISymbolicLinkHandle)) continue;
                this.linkAdds.add(fileAreaUpdate);
            }
        }
    }

    public List getFolderMoves() {
        return this.folderMoves;
    }

    public List getLinkMoves() {
        return this.linkMoves;
    }

    public List getFileMoves() {
        return this.fileMoves;
    }

    private void orderMoves(Collection collection) {
        this.folderMoves = new ArrayList();
        this.linkMoves = new ArrayList();
        this.fileMoves = new ArrayList();
        for (FileAreaUpdate fileAreaUpdate : collection) {
            if (fileAreaUpdate.getItem() instanceof IFolderHandle) {
                this.folderMoves.add(fileAreaUpdate);
            } else if (fileAreaUpdate.getItem() instanceof IFileItemHandle) {
                this.fileMoves.add(fileAreaUpdate);
            } else if (fileAreaUpdate.getItem() instanceof ISymbolicLinkHandle) {
                this.linkMoves.add(fileAreaUpdate);
            }
            HashSet<UUID> hashSet = (HashSet<UUID>)this.movedOrDeletedItemIds.get(fileAreaUpdate.getPreviousComponent().getItemId());
            if (hashSet == null) {
                hashSet = new HashSet<UUID>();
                this.movedOrDeletedItemIds.put(fileAreaUpdate.getPreviousComponent().getItemId(), hashSet);
            }
            hashSet.add(fileAreaUpdate.getItem().getItemId());
        }
    }

    public List getGroupedModifies() {
        return this.groupedModifies;
    }

    private void orderModifies(Collection collection) {
        this.groupedModifies = new ArrayList(collection.size());
        HashMap hashMap = this.group(collection);
        for (List list : hashMap.values()) {
            this.groupedModifies.addAll(list);
        }
    }

    public boolean isMovedOrDeleted(IComponentHandle iComponentHandle, IVersionableHandle iVersionableHandle) {
        Set set = (Set)this.movedOrDeletedItemIds.get(iComponentHandle.getItemId());
        return set != null && set.contains(iVersionableHandle.getItemId());
    }

    private HashMap group(Collection collection) {
        HashMap<UUID, ArrayList<FileAreaUpdate>> hashMap = new HashMap<UUID, ArrayList<FileAreaUpdate>>();
        for (FileAreaUpdate fileAreaUpdate : collection) {
            ArrayList<FileAreaUpdate> arrayList = (ArrayList<FileAreaUpdate>)hashMap.get(fileAreaUpdate.component().getItemId());
            if (arrayList == null) {
                arrayList = new ArrayList<FileAreaUpdate>();
                hashMap.put(fileAreaUpdate.component().getItemId(), arrayList);
            }
            arrayList.add(fileAreaUpdate);
        }
        return hashMap;
    }

    private HashMap calculateOrderedAdds(Collection collection) {
        HashMap hashMap = this.group(collection);
        HashMap<UUID, ArrayList> hashMap2 = new HashMap<UUID, ArrayList>();
        for (Map.Entry entry : hashMap.entrySet()) {
            ArrayList arrayList2;
            HashMap<UUID, ArrayList<ArrayList>> hashMap3 = new HashMap<UUID, ArrayList<ArrayList>>();
            for (ArrayList arrayList2 : (List)entry.getValue()) {
                ArrayList<ArrayList> arrayList3 = (ArrayList<ArrayList>)hashMap3.get(arrayList2.getDestinationParent().getItemId());
                if (arrayList3 == null) {
                    arrayList3 = new ArrayList<ArrayList>();
                    hashMap3.put(arrayList2.getDestinationParent().getItemId(), arrayList3);
                }
                arrayList3.add(arrayList2);
            }
            arrayList2 = this.calculateOrdering(hashMap3);
            Collections.reverse(arrayList2);
            hashMap2.put((UUID)entry.getKey(), arrayList2);
        }
        return hashMap2;
    }

    private ArrayList calculateOrdering(HashMap hashMap) {
        ArrayList arrayList = new ArrayList();
        while (!hashMap.isEmpty()) {
            Object k = hashMap.keySet().iterator().next();
            List list = (List)hashMap.get(k);
            this.orderChildrenFirst(list, hashMap, arrayList);
            hashMap.remove(k);
        }
        return arrayList;
    }

    private void orderChildrenFirst(List list, HashMap hashMap, List list2) {
        for (FileAreaUpdate fileAreaUpdate : list) {
            List list3 = (List)hashMap.get(fileAreaUpdate.getItem().getItemId());
            if (list3 != null) {
                this.orderChildrenFirst(list3, hashMap, list2);
            }
            list2.add(fileAreaUpdate);
            hashMap.remove(fileAreaUpdate.getItem().getItemId());
        }
    }

    public void processed(FileAreaUpdate fileAreaUpdate) {
        Set set = (Set)this.movedOrDeletedItemIds.get(fileAreaUpdate.component().getItemId());
        if (set != null) {
            set.remove(fileAreaUpdate.getItem().getItemId());
        }
    }
}

