/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.load;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.IFileContentManagerSession;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.FileItemInfo;
import com.ibm.team.filesystem.client.internal.FileItemInfoProxy;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.InverseFileItemInfo;
import com.ibm.team.filesystem.client.internal.ManagedFileStore;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingDescriptor;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.Shed;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileArea;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.load.DeferredDownloadInformation;
import com.ibm.team.filesystem.client.internal.load.DeferredInformation;
import com.ibm.team.filesystem.client.internal.load.IUpdateInfo;
import com.ibm.team.filesystem.client.internal.load.UpdateMutator$1;
import com.ibm.team.filesystem.client.internal.load.UpdateMutator$2;
import com.ibm.team.filesystem.client.internal.load.UpdateMutator$3;
import com.ibm.team.filesystem.client.internal.load.UpdateMutator$4;
import com.ibm.team.filesystem.client.internal.load.UpdateMutator$5;
import com.ibm.team.filesystem.client.internal.load.UpdateMutator$6;
import com.ibm.team.filesystem.client.internal.load.UpdateMutator$DownloadHandler;
import com.ibm.team.filesystem.client.internal.load.UpdateMutator$ShareReference;
import com.ibm.team.filesystem.client.internal.load.UpdateOrder;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeManager;
import com.ibm.team.filesystem.client.internal.operations.EncodingDownloadFailure;
import com.ibm.team.filesystem.client.internal.operations.FileSystemOperation;
import com.ibm.team.filesystem.client.internal.utils.CancellationMonitor;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationDescriptor;
import com.ibm.team.filesystem.client.internal.utils.NonCancellingProgressMonitor;
import com.ibm.team.filesystem.client.internal.utils.PathUtils;
import com.ibm.team.filesystem.client.internal.utils.RepositoryUtils;
import com.ibm.team.filesystem.client.operations.IDownloadListener;
import com.ibm.team.filesystem.client.operations.UpdateDilemmaHandler;
import com.ibm.team.filesystem.common.IFileContent;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.common.ISymbolicLinkHandle;
import com.ibm.team.filesystem.common.internal.FileContent;
import com.ibm.team.filesystem.common.internal.dto.FileAreaUpdate;
import com.ibm.team.filesystem.common.internal.dto.FileAreaUpdateReport;
import com.ibm.team.filesystem.common.internal.dto.SharePoint;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.ThreadCheck;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.IAncestorReport;
import com.ibm.team.scm.common.dto.IComponentStateSummary;
import com.ibm.team.scm.common.dto.INameItemPair;
import com.ibm.team.scm.common.dto.ISyncTime;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;

public class UpdateMutator
extends FileSystemOperation {
    private static final String COLLISION_RENAME = "#jazz";
    private final FileAreaUpdateReport updates;
    protected final ITeamRepository repository;
    protected final IConnection connection;
    protected final IContextHandle connectionHandle;
    private final HashSet copyFileAreasToUpdate;
    protected final IDownloadListener downloadMonitor;
    protected IFileContentManagerSession contentSession;
    private boolean lastComponentSharedResult;
    private IComponentHandle lastComponentShareTested;
    private Map toSkip = new HashMap();
    private HashSet inconsistentShares = new HashSet();
    private HashSet newShares = new HashSet();
    private HashMap componentStatesBefore;
    private HashMap componentStatesAfter;
    private HashSet componentNotShared;
    private Map shareParents;
    private final HashMap failedUpdates;
    private HashMap copyFileAreasByComponent;
    private Shed shed;
    private UpdateOrder updateInfo;

    public UpdateMutator(IConnection iConnection, Collection collection, Collection collection2, FileAreaUpdateReport fileAreaUpdateReport, Collection collection3, UpdateDilemmaHandler updateDilemmaHandler, IDownloadListener iDownloadListener) {
        super(updateDilemmaHandler == null ? UpdateDilemmaHandler.getDefault() : updateDilemmaHandler);
        Object object;
        HashMap hashMap;
        Path path;
        updateDilemmaHandler = updateDilemmaHandler == null ? UpdateDilemmaHandler.getDefault() : updateDilemmaHandler;
        this.repository = iConnection.teamRepository();
        if (iConnection instanceof IWorkspaceConnection) {
            this.connectionHandle = (IContextHandle)((IWorkspaceConnection)iConnection).getResolvedWorkspace();
        } else if (iConnection instanceof IBaselineConnection) {
            this.connectionHandle = (IContextHandle)((IBaselineConnection)iConnection).getBaseline();
        } else {
            throw (Throwable)new IllegalArgumentException();
        }
        this.connection = iConnection;
        if (collection == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (collection2 == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (collection3 == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        this.componentStatesBefore = new HashMap();
        for (Object object2 : collection) {
            this.componentStatesBefore.put(object2.getComponent().getItemId(), object2);
        }
        this.componentStatesAfter = new HashMap();
        for (Object object2 : collection2) {
            this.componentStatesAfter.put(object2.getComponent().getItemId(), object2);
        }
        this.componentNotShared = new HashSet();
        this.shareParents = new HashMap();
        for (Object object2 : fileAreaUpdateReport.getShareParents()) {
            IVersionableHandle iVersionableHandle;
            path = new Path(object2.getCopyFileArea());
            hashMap = (HashMap)this.shareParents.get(path);
            if (hashMap == null) {
                hashMap = new HashMap();
                this.shareParents.put(path, hashMap);
            }
            if ((object = (HashMap<UUID, IComponentStateSummary>)hashMap.get(object2.getComponent().getItemId())) == null) {
                object = new HashMap<UUID, IComponentStateSummary>();
                hashMap.put(object2.getComponent().getItemId(), object);
            }
            if ((iVersionableHandle = object2.getVersionable()) == null) {
                object.put(null, object2);
                continue;
            }
            object.put(iVersionableHandle.getItemId(), object2);
        }
        this.updates = fileAreaUpdateReport;
        this.failedUpdates = new HashMap();
        this.downloadMonitor = iDownloadListener;
        this.copyFileAreasToUpdate = new HashSet(collection3);
        for (Object object2 : fileAreaUpdateReport.getCopyFileAreasWithOverlaps()) {
            path = new Path((String)object2);
            hashMap = collection3.iterator();
            while (hashMap.hasNext()) {
                object = (ICopyFileArea)hashMap.next();
                if (!PathUtils.samePath(object.getRoot(), object.isCaseSensitive(), (IPath)path, object.isCaseSensitive())) continue;
                hashMap.remove();
                this.collectStatus(new FileSystemStatus(2, NLS.bind((String)Messages.UpdateMutator_45, (Object)object2, (Object[])new Object[0])));
            }
        }
        this.copyFileAreasByComponent = new HashMap();
        this.shed = new Shed(updateDilemmaHandler.getBackupDilemmaHandler());
    }

    private final void createFile(IComponent iComponent, FileAreaUpdate fileAreaUpdate, ArrayList arrayList, Date date, IProgressMonitor iProgressMonitor) throws FileSystemClientException, TeamRepositoryException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)101);
        IFileItemHandle iFileItemHandle = (IFileItemHandle)fileAreaUpdate.afterState();
        if (!this.isComponentShared((IComponentHandle)iComponent, (IProgressMonitor)subMonitor.newChild(1))) {
            return;
        }
        List list = (List)this.copyFileAreasByComponent.get(iComponent.getItemId());
        subMonitor.setWorkRemaining(100 * list.size());
        for (ICopyFileArea iCopyFileArea : list) {
            Object object;
            Object object2;
            IPath iPath;
            SubMonitor subMonitor2 = subMonitor.newChild(100);
            String string = fileAreaUpdate.getName();
            SharingDescriptor sharingDescriptor = null;
            IFolderHandle iFolderHandle = fileAreaUpdate.getDestinationParent();
            IPath iPath2 = iCopyFileArea.getLocalPathFor(this.connectionHandle, (IComponentHandle)iComponent, (IVersionableHandle)iFolderHandle, (IProgressMonitor)subMonitor2.newChild(1));
            if (iPath2 == null) {
                iPath = this.getSharePoint(iCopyFileArea, iComponent, iFolderHandle);
                if (iPath != null) {
                    sharingDescriptor = new SharingDescriptor(this.connection.teamRepository().getRepositoryURI(), this.connection.teamRepository().getId(), this.connection, (IComponentHandle)iComponent, iComponent.getName(), (IVersionableHandle)iFileItemHandle);
                    iPath2 = PathUtils.getPath(iPath.getRelativePath());
                } else {
                    object2 = iCopyFileArea.getItemInfo((IVersionableHandle)iFolderHandle, (IComponentHandle)iComponent, this.connectionHandle);
                    if (object2 != null) {
                        object = iCopyFileArea.getShare(this.connectionHandle, (IComponentHandle)iComponent, (IVersionableHandle)iFolderHandle, (IProgressMonitor)subMonitor2.newChild(1));
                        if (object != null) {
                            this.recordInconsistentShare((IComponentHandle)iComponent, (IShare)object);
                        } else {
                            this.recordInconsistentComponent(iCopyFileArea, iComponent, (IProgressMonitor)subMonitor2.newChild(1));
                        }
                        this.collectStatus(new FileSystemStatus(4, 367, NLS.bind((String)Messages.UpdateMutator_2, (Object)string, (Object[])new Object[]{iComponent.getName()})));
                        continue;
                    }
                    this.failedUpdate(iCopyFileArea, fileAreaUpdate);
                    continue;
                }
            }
            iPath = iPath2.append(fileAreaUpdate.getName());
            string = iPath.toString();
            object2 = new Shareable(iCopyFileArea.getRoot(), iPath, ResourceType.FILE);
            object = (Shareable)SharingManager.getInstance().findShareable(iCopyFileArea.getRoot(), this.connectionHandle, (IComponentHandle)iComponent, (IVersionableHandle)iFileItemHandle, (IProgressMonitor)subMonitor2.newChild(1));
            if (((Shareable)object2).exists((IProgressMonitor)subMonitor2.newChild(1))) {
                if (sharingDescriptor != null) {
                    this.failedUpdate(iCopyFileArea, fileAreaUpdate);
                    if (object == null) continue;
                    this.collectStatus(new FileSystemStatus(4, 367, NLS.bind((String)Messages.UpdateMutator_1, (Object)string, (Object[])new Object[]{iComponent.getName()})));
                    this.recordInconsistentShare((IComponentHandle)iComponent, ((Shareable)object).getShare((IProgressMonitor)subMonitor2.newChild(1)));
                    continue;
                }
                if (object != null) {
                    this.collectStatus(new FileSystemStatus(4, 367, NLS.bind((String)Messages.UpdateMutator_0, (Object)string, (Object[])new Object[]{iComponent.getName()})));
                    this.recordInconsistentShare((IComponentHandle)iComponent, ((Shareable)object).getShare((IProgressMonitor)subMonitor2.newChild(1)));
                    continue;
                }
                if (!this.handleCollision(iCopyFileArea, iComponent, (Shareable)object2, (IProgressMonitor)subMonitor2.newChild(1))) {
                    this.collectStatus(new FileSystemStatus(4, 367, NLS.bind((String)Messages.UpdateMutator_0, (Object)string, (Object[])new Object[]{iComponent.getName()})));
                    this.recordInconsistentShare((IComponentHandle)iComponent, ((Shareable)object2).getShare((IProgressMonitor)subMonitor2.newChild(1)));
                    continue;
                }
            }
            if (object != null) {
                this.collectStatus(new FileSystemStatus(4, 367, NLS.bind((String)Messages.UpdateMutator_29, (Object)string, (Object[])new Object[]{iComponent.getName()})));
                this.recordInconsistentShare((IComponentHandle)iComponent, ((Shareable)object).getShare((IProgressMonitor)subMonitor2.newChild(1)));
                continue;
            }
            subMonitor2.setWorkRemaining(100);
            Shareable shareable = new Shareable(iCopyFileArea.getRoot(), iPath, ResourceType.FILE);
            DeferredDownloadInformation deferredDownloadInformation = new DeferredDownloadInformation(iCopyFileArea, fileAreaUpdate, sharingDescriptor);
            arrayList.add(deferredDownloadInformation);
            boolean bl = this.skipUpdate(iCopyFileArea.getRoot(), (IComponentHandle)iComponent, (IVersionableHandle)iFileItemHandle);
            this.storeFileContent(deferredDownloadInformation, shareable, bl, (IProgressMonitor)subMonitor2);
        }
    }

    private void createLink(IComponent iComponent, FileAreaUpdate fileAreaUpdate, Set set, HashSet hashSet, IProgressMonitor iProgressMonitor) throws FileSystemClientException, TeamRepositoryException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)101);
        ISymbolicLinkHandle iSymbolicLinkHandle = (ISymbolicLinkHandle)fileAreaUpdate.afterState();
        if (!this.isComponentShared((IComponentHandle)iComponent, (IProgressMonitor)subMonitor.newChild(1))) {
            return;
        }
        List list = (List)this.copyFileAreasByComponent.get(iComponent.getItemId());
        subMonitor.setWorkRemaining(100 * list.size());
        for (ICopyFileArea iCopyFileArea : list) {
            FileItemInfoProxy fileItemInfoProxy;
            Object object;
            Object object2;
            IPath iPath;
            SubMonitor subMonitor2 = subMonitor.newChild(100);
            String string = fileAreaUpdate.getName();
            SharingDescriptor sharingDescriptor = null;
            IFolderHandle iFolderHandle = fileAreaUpdate.getDestinationParent();
            IPath iPath2 = iCopyFileArea.getLocalPathFor(this.connectionHandle, (IComponentHandle)iComponent, (IVersionableHandle)iFolderHandle, (IProgressMonitor)subMonitor2.newChild(1));
            boolean bl = false;
            if (iPath2 == null) {
                iPath = this.getSharePoint(iCopyFileArea, iComponent, iFolderHandle);
                if (iPath != null) {
                    sharingDescriptor = new SharingDescriptor(this.connection.teamRepository().getRepositoryURI(), this.connection.teamRepository().getId(), this.connection, (IComponentHandle)iComponent, iComponent.getName(), (IVersionableHandle)iSymbolicLinkHandle);
                    iPath2 = PathUtils.getPath(iPath.getRelativePath());
                    bl = true;
                } else {
                    object2 = iCopyFileArea.getItemInfo((IVersionableHandle)iFolderHandle, (IComponentHandle)iComponent, this.connectionHandle);
                    if (object2 != null) {
                        object = iCopyFileArea.getShare(this.connectionHandle, (IComponentHandle)iComponent, (IVersionableHandle)iFolderHandle, (IProgressMonitor)subMonitor2.newChild(1));
                        if (object != null) {
                            this.recordInconsistentShare((IComponentHandle)iComponent, (IShare)object);
                        } else {
                            this.recordInconsistentComponent(iCopyFileArea, iComponent, (IProgressMonitor)subMonitor2.newChild(1));
                        }
                        this.collectStatus(new FileSystemStatus(4, 367, NLS.bind((String)Messages.UpdateMutator_2, (Object)string, (Object[])new Object[]{iComponent.getName()})));
                        continue;
                    }
                    this.failedUpdate(iCopyFileArea, fileAreaUpdate);
                    continue;
                }
            }
            iPath = iPath2.append(fileAreaUpdate.getName());
            string = iPath.toString();
            object2 = new Shareable(iCopyFileArea.getRoot(), iPath, ResourceType.SYMBOLIC_LINK);
            object = (Shareable)SharingManager.getInstance().findShareable(iCopyFileArea.getRoot(), this.connectionHandle, (IComponentHandle)iComponent, (IVersionableHandle)iSymbolicLinkHandle, (IProgressMonitor)subMonitor2.newChild(1));
            if (((Shareable)object2).exists((IProgressMonitor)subMonitor2.newChild(1))) {
                if (sharingDescriptor != null) {
                    this.failedUpdate(iCopyFileArea, fileAreaUpdate);
                    if (object == null) continue;
                    this.collectStatus(new FileSystemStatus(4, 367, NLS.bind((String)Messages.UpdateMutator_1, (Object)string, (Object[])new Object[]{iComponent.getName()})));
                    this.recordInconsistentShare((IComponentHandle)iComponent, ((Shareable)object).getShare((IProgressMonitor)subMonitor2.newChild(1)));
                    continue;
                }
                if (object != null) {
                    this.collectStatus(new FileSystemStatus(4, 367, NLS.bind((String)Messages.UpdateMutator_0, (Object)string, (Object[])new Object[]{iComponent.getName()})));
                    this.recordInconsistentShare((IComponentHandle)iComponent, ((Shareable)object).getShare((IProgressMonitor)subMonitor2.newChild(1)));
                    continue;
                }
                if (!this.handleCollision(iCopyFileArea, iComponent, (Shareable)object2, (IProgressMonitor)subMonitor2.newChild(1))) {
                    this.collectStatus(new FileSystemStatus(4, 367, NLS.bind((String)Messages.UpdateMutator_0, (Object)string, (Object[])new Object[]{iComponent.getName()})));
                    this.recordInconsistentShare((IComponentHandle)iComponent, ((Shareable)object2).getShare((IProgressMonitor)subMonitor2.newChild(1)));
                    continue;
                }
            }
            if (object != null) {
                this.collectStatus(new FileSystemStatus(4, 367, NLS.bind((String)Messages.UpdateMutator_29, (Object)string, (Object[])new Object[]{iComponent.getName()})));
                this.recordInconsistentShare((IComponentHandle)iComponent, ((Shareable)object).getShare((IProgressMonitor)subMonitor2.newChild(1)));
                continue;
            }
            subMonitor2.setWorkRemaining(100);
            Shareable shareable = new Shareable(iCopyFileArea.getRoot(), iPath, ResourceType.SYMBOLIC_LINK);
            if (!this.skipUpdate(iCopyFileArea.getRoot(), (IComponentHandle)iComponent, (IVersionableHandle)iSymbolicLinkHandle)) {
                if (ManagedFileStore.supportsSymLinks()) {
                    try {
                        SharingManager.getInstance().doSilentChange(new UpdateMutator$1(this, shareable, fileAreaUpdate, subMonitor2, set));
                    }
                    catch (CoreException coreException) {
                        this.recordInconsistentShare((IComponentHandle)iComponent, shareable.getShare((IProgressMonitor)subMonitor2.newChild(1)));
                        this.collectStatus(FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.UpdateMutator_31, (Object)iPath.toString(), (Object[])new Object[]{iComponent.getName()}), (Throwable)coreException));
                    }
                } else {
                    this.collectStatus(FileSystemStatus.getStatusFor(1, NLS.bind((String)Messages.UpdateMutator_50, (Object)iPath.toOSString(), (Object[])new Object[]{fileAreaUpdate.getLinkTarget()}), null));
                    hashSet.add(shareable);
                }
            }
            if (bl) {
                fileItemInfoProxy = new FileItemInfoProxy((IVersionableHandle)iSymbolicLinkHandle, iFolderHandle, fileAreaUpdate.getName(), false);
                fileItemInfoProxy.setTarget(shareable.getFileStorage().getModificationStamp(), fileAreaUpdate.getLinkTarget());
                IShare iShare = SharingManager.getInstance().share(shareable, sharingDescriptor, fileItemInfoProxy.getFileItemInfo(), 2, (IProgressMonitor)subMonitor2.newChild(1));
                this.newShares.add(new UpdateMutator$ShareReference((IComponentHandle)iComponent, iShare));
                continue;
            }
            fileItemInfoProxy = new FileItemInfoProxy((IVersionableHandle)iSymbolicLinkHandle, iFolderHandle, fileAreaUpdate.getName());
            fileItemInfoProxy.setTarget(shareable.getFileStorage().getModificationStamp(), fileAreaUpdate.getLinkTarget());
            iCopyFileArea.setItemMetaData(shareable.getLocalPath(), fileItemInfoProxy.getFileItemInfo(), (IProgressMonitor)subMonitor2.newChild(1));
        }
    }

    private final void createFolder(IComponent iComponent, FileAreaUpdate fileAreaUpdate, IProgressMonitor iProgressMonitor) throws FileSystemClientException, TeamRepositoryException {
        IFolderHandle iFolderHandle = fileAreaUpdate.getDestinationParent();
        if (iFolderHandle == null) {
            return;
        }
        String string = fileAreaUpdate.getName();
        IFolderHandle iFolderHandle2 = (IFolderHandle)fileAreaUpdate.afterState();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)101);
        if (!this.isComponentShared((IComponentHandle)iComponent, (IProgressMonitor)subMonitor.newChild(1))) {
            return;
        }
        List list = (List)this.copyFileAreasByComponent.get(iComponent.getItemId());
        subMonitor.setWorkRemaining(100 * list.size());
        for (ICopyFileArea iCopyFileArea : list) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            Object object6;
            Object object7;
            SubMonitor subMonitor2 = subMonitor.newChild(100);
            String string2 = string;
            boolean bl = false;
            IPath iPath = iCopyFileArea.getLocalPathFor(this.connectionHandle, (IComponentHandle)iComponent, (IVersionableHandle)iFolderHandle, (IProgressMonitor)subMonitor2.newChild(1));
            if (iPath == null) {
                object7 = this.getSharePoint(iCopyFileArea, iComponent, iFolderHandle);
                if (object7 != null) {
                    bl = true;
                    iPath = PathUtils.getPath(object7.getRelativePath());
                } else {
                    object6 = iCopyFileArea.getItemInfo((IVersionableHandle)iFolderHandle, (IComponentHandle)iComponent, this.connectionHandle);
                    if (object6 != null) {
                        object5 = iCopyFileArea.getShare(this.connectionHandle, (IComponentHandle)iComponent, (IVersionableHandle)iFolderHandle, (IProgressMonitor)subMonitor2.newChild(1));
                        if (object5 != null) {
                            this.recordInconsistentShare((IComponentHandle)iComponent, (IShare)object5);
                        } else {
                            this.recordInconsistentComponent(iCopyFileArea, iComponent, (IProgressMonitor)subMonitor2.newChild(1));
                        }
                        this.collectStatus(new FileSystemStatus(4, 368, NLS.bind((String)Messages.UpdateMutator_2, (Object)string2, (Object[])new Object[]{iComponent.getName()})));
                        continue;
                    }
                    this.failedUpdate(iCopyFileArea, fileAreaUpdate);
                    continue;
                }
            }
            IPath iPath2 = iPath.append(string);
            string2 = iPath2.toString();
            object7 = new Shareable(iCopyFileArea.getRoot(), iPath2, ResourceType.FOLDER);
            object6 = new Shareable(iCopyFileArea.getRoot(), iPath2, ResourceType.FOLDER);
            object5 = (Shareable)SharingManager.getInstance().findShareable(iCopyFileArea.getRoot(), this.connectionHandle, (IComponentHandle)iComponent, (IVersionableHandle)iFolderHandle2, null);
            if (((Shareable)object6).exists((IProgressMonitor)subMonitor2.newChild(1)) || !((Shareable)object6).getSandbox().isCaseSensitive() && (((Shareable)object6).getFileStorage().storageExists((IProgressMonitor)subMonitor2.newChild(1)) || !fileAreaUpdate.getName().equals(((Shareable)object6).getFileStorage().getActualName()))) {
                if (((Shareable)object6).getResourceType((IProgressMonitor)subMonitor2.newChild(1)) == ResourceType.FOLDER && ((Shareable)object6).getRemote((IProgressMonitor)subMonitor2.newChild(1)) == null && object5 == null) {
                    if (!string.equals(((Shareable)(object6 = this.getShareableForExistingStorage((Shareable)object6, (IProgressMonitor)subMonitor2.newChild(1)))).getFileStorage().getActualName())) {
                        this.move(iCopyFileArea, iComponent, (IComponentHandle)iComponent, (Shareable)object6, (Shareable)object7, iFolderHandle, string, null, false, false, (IProgressMonitor)subMonitor2.newChild(25));
                    }
                    if (bl) {
                        object4 = new SharingDescriptor(this.connection.teamRepository().getRepositoryURI(), this.connection.teamRepository().getId(), this.connection, (IComponentHandle)iComponent, iComponent.getName(), (IVersionableHandle)iFolderHandle2);
                        object3 = new FileItemInfoProxy((IVersionableHandle)iFolderHandle2, iFolderHandle, string, PathUtils.isLoadedWithAnotherName(((Shareable)object7).getSandbox(), iPath2, string)).getFileItemInfo();
                        object2 = SharingManager.getInstance().share((Shareable)object7, (ISharingDescriptor)object4, (FileItemInfo)object3, 2, iProgressMonitor);
                        this.newShares.add(new UpdateMutator$ShareReference((IComponentHandle)iComponent, (IShare)object2));
                        continue;
                    }
                    object4 = new FileItemInfoProxy((IVersionableHandle)iFolderHandle2, iFolderHandle, string).getFileItemInfo();
                    iCopyFileArea.setItemMetaData(iPath2, (FileItemInfo)object4, (IProgressMonitor)subMonitor2.newChild(50));
                    continue;
                }
                object4 = null;
                object3 = null;
                object2 = ((Shareable)object6).getShare((IProgressMonitor)subMonitor2.newChild(1));
                if (object2 != null) {
                    object4 = object2.getSharingDescriptor().getComponent();
                    object3 = object2.getSharingDescriptor().getConnectionHandle();
                }
                if (iFolderHandle2.sameItemId((IItemHandle)((Shareable)object6).getRemote((IProgressMonitor)subMonitor2.newChild(1))) && iComponent.sameItemId((IItemHandle)object4) && this.connectionHandle.sameItemId((IItemHandle)object3)) {
                    if (string.equals(((Shareable)object6).getFileStorage().getActualName())) {
                        object = new FileItemInfoProxy((IVersionableHandle)iFolderHandle2, iFolderHandle, string, false).getFileItemInfo();
                        iCopyFileArea.setItemMetaData(((Shareable)object6).getLocalPath(), (FileItemInfo)object, (IProgressMonitor)subMonitor2.newChild(50));
                        continue;
                    }
                    this.move(iCopyFileArea, iComponent, (IComponentHandle)iComponent, (Shareable)object6, (Shareable)object7, iFolderHandle, string, (IVersionableHandle)iFolderHandle2, true, false, (IProgressMonitor)subMonitor2.newChild(25));
                    continue;
                }
                if (!(!bl || iFolderHandle2.sameItemId((IItemHandle)((Shareable)object6).getRemote((IProgressMonitor)subMonitor2.newChild(1))) && this.connectionHandle.sameItemId((IItemHandle)object3))) {
                    this.collectStatus(new FileSystemStatus(2, NLS.bind((String)Messages.UpdateMutator_46, (Object)iPath2.toString(), (Object[])new Object[0])));
                    this.failedUpdate(iCopyFileArea, fileAreaUpdate);
                    continue;
                }
                if (!this.handleCollision(iCopyFileArea, iComponent, (Shareable)object6, (IProgressMonitor)subMonitor2.newChild(25))) {
                    this.collectStatus(new FileSystemStatus(4, 368, NLS.bind((String)Messages.UpdateMutator_12, (Object)string2, (Object[])new Object[]{((Shareable)object6).getFileStorage().getActualName()})));
                    this.recordInconsistentShare((IComponentHandle)iComponent, ((Shareable)object6).getShare((IProgressMonitor)subMonitor2.newChild(1)));
                    continue;
                }
            }
            if (object5 != null && ((Shareable)object5).exists((IProgressMonitor)subMonitor2.newChild(1))) {
                this.move(iCopyFileArea, iComponent, (IComponentHandle)iComponent, (Shareable)object5, (Shareable)object7, iFolderHandle, string, (IVersionableHandle)iFolderHandle2, true, false, (IProgressMonitor)subMonitor2.newChild(25));
                continue;
            }
            try {
                object4 = ((Shareable)object7).getFileStorage();
                if (!this.skipUpdate(((Shareable)object7).getCopyFileAreaRoot(), (IComponentHandle)iComponent, (IVersionableHandle)iFolderHandle2)) {
                    SharingManager.getInstance().doSilentChange(new UpdateMutator$2(this, (IFileStorage)object4, subMonitor2));
                }
                if (bl) {
                    object3 = new FileItemInfoProxy((IVersionableHandle)iFolderHandle2, iFolderHandle, string, false).getFileItemInfo();
                    object2 = new SharingDescriptor(this.connection.teamRepository().getRepositoryURI(), this.connection.teamRepository().getId(), this.connection, (IComponentHandle)iComponent, iComponent.getName(), (IVersionableHandle)iFolderHandle2);
                    object = SharingManager.getInstance().share((Shareable)object7, (ISharingDescriptor)object2, (FileItemInfo)object3, 2, (IProgressMonitor)subMonitor2.newChild(1));
                    this.newShares.add(new UpdateMutator$ShareReference((IComponentHandle)iComponent, (IShare)object));
                } else {
                    object3 = new FileItemInfoProxy((IVersionableHandle)iFolderHandle2, iFolderHandle, string).getFileItemInfo();
                    iCopyFileArea.setItemMetaData(((Shareable)object7).getLocalPath(), (FileItemInfo)object3, (IProgressMonitor)subMonitor2.newChild(1));
                }
            }
            catch (CoreException coreException) {
                this.recordInconsistentShare((IComponentHandle)iComponent, ((Shareable)object7).getShare((IProgressMonitor)subMonitor2.newChild(1)));
                this.collectStatus(FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.UpdateMutator_31, (Object)iPath2.toString(), (Object[])new Object[]{iComponent.getName()}), (Throwable)coreException));
            }
            this.folderCreated((Shareable)object7, bl, (IProgressMonitor)subMonitor2.newChild(1));
        }
    }

    private SharePoint getSharePoint(ICopyFileArea iCopyFileArea, IComponent iComponent, IFolderHandle iFolderHandle) {
        Map map;
        Map map2 = (Map)this.shareParents.get(iCopyFileArea.getRoot());
        if (map2 != null && (map = (Map)map2.get(iComponent.getItemId())) != null) {
            return (SharePoint)map.get(iFolderHandle.getItemId());
        }
        return null;
    }

    private final void deleteSubtree(IComponent iComponent, IFolderHandle iFolderHandle, String string, IVersionableHandle iVersionableHandle, IProgressMonitor iProgressMonitor) throws FileSystemClientException, TeamRepositoryException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)101);
        if (!this.isComponentShared((IComponentHandle)iComponent, (IProgressMonitor)subMonitor.newChild(1))) {
            return;
        }
        List list = (List)this.copyFileAreasByComponent.get(iComponent.getItemId());
        subMonitor.setWorkRemaining(100 * list.size());
        for (ICopyFileArea iCopyFileArea : list) {
            SubMonitor subMonitor2 = subMonitor.newChild(100);
            if (iFolderHandle == null) {
                this.collectStatus(FileSystemStatus.getStatusFor(4, Messages.UpdateMutator_32, null));
                this.recordInconsistentComponent(iCopyFileArea, iComponent, (IProgressMonitor)subMonitor2.newChild(1));
                continue;
            }
            subMonitor2.subTask(NLS.bind((String)Messages.UpdateMutator_4, (Object)string, (Object[])new Object[0]));
            IPath iPath = iCopyFileArea.getLocalPathFor(this.connectionHandle, (IComponentHandle)iComponent, iVersionableHandle, (IProgressMonitor)subMonitor2.newChild(1));
            if (iPath == null) {
                iCopyFileArea.forget(this.connectionHandle, (IComponentHandle)iComponent, iVersionableHandle, null);
                continue;
            }
            Shareable shareable = new Shareable(iCopyFileArea.getRoot(), iPath, ResourceType.getResourceType(iVersionableHandle));
            if (!shareable.exists((IProgressMonitor)subMonitor2.newChild(1))) {
                if (shareable.isShare((IProgressMonitor)subMonitor2.newChild(1))) {
                    shareable.unshare((IProgressMonitor)subMonitor2.newChild(98));
                    continue;
                }
                shareable.forget((IProgressMonitor)subMonitor2.newChild(98));
                continue;
            }
            this.deleteSubtree(iComponent, shareable, (IProgressMonitor)subMonitor2.newChild(98));
        }
    }

    private void deleteSubtree(IComponent iComponent, Shareable shareable, IProgressMonitor iProgressMonitor) throws FileSystemClientException, TeamRepositoryException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        IVersionableHandle iVersionableHandle = shareable.getRemote((IProgressMonitor)subMonitor.newChild(1));
        if (iVersionableHandle == null || !this.skipUpdate(shareable.getCopyFileAreaRoot(), (IComponentHandle)iComponent, iVersionableHandle)) {
            IFileStorage iFileStorage = shareable.getFileStorage();
            try {
                SharingManager.getInstance().doSilentChange(new UpdateMutator$3(this, iFileStorage, subMonitor));
            }
            catch (CoreException coreException) {
                this.recordInconsistentShare((IComponentHandle)iComponent, shareable.getShare((IProgressMonitor)subMonitor.newChild(1)));
                this.collectStatus(FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.UpdateMutator_34, (Object)shareable.getLocalPath(), (Object[])new Object[]{iComponent.getName()}), (Throwable)coreException));
            }
        }
        if (shareable.isShare((IProgressMonitor)subMonitor.newChild(1))) {
            shareable.unshare((IProgressMonitor)subMonitor.newChild(49));
        } else {
            shareable.forget((IProgressMonitor)subMonitor.newChild(49));
        }
        subMonitor.done();
    }

    protected final void modifyFile(IComponent iComponent, FileAreaUpdate fileAreaUpdate, ArrayList arrayList, Date date, IProgressMonitor iProgressMonitor) throws FileSystemClientException, TeamRepositoryException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)101);
        if (!this.isComponentShared((IComponentHandle)iComponent, (IProgressMonitor)subMonitor.newChild(1))) {
            return;
        }
        List list = (List)this.copyFileAreasByComponent.get(iComponent.getItemId());
        subMonitor.setWorkRemaining(100 * list.size());
        IFileItemHandle iFileItemHandle = (IFileItemHandle)fileAreaUpdate.afterState();
        for (ICopyFileArea iCopyFileArea : list) {
            SubMonitor subMonitor2 = subMonitor.newChild(100);
            String string = fileAreaUpdate.getName();
            try {
                Object object;
                Object object2;
                IPath iPath = iCopyFileArea.getLocalPathFor(this.connectionHandle, (IComponentHandle)iComponent, (IVersionableHandle)iFileItemHandle, (IProgressMonitor)subMonitor2.newChild(1));
                if (iPath == null) {
                    object2 = iCopyFileArea.getItemInfo((IVersionableHandle)iFileItemHandle, (IComponentHandle)iComponent, this.connectionHandle);
                    if (object2 != null) {
                        object = iCopyFileArea.getRemotePathFor(this.connectionHandle, (IComponentHandle)iComponent, (IVersionableHandle)iFileItemHandle, (IProgressMonitor)subMonitor2.newChild(1));
                        if (object != null) {
                            string = object.toString();
                        }
                        this.collectStatus(new FileSystemStatus(2, 369, NLS.bind((String)Messages.UpdateMutator_8, (Object)string, (Object[])new Object[]{iComponent.getName()})));
                        continue;
                    }
                    object = iCopyFileArea.getShare(this.connectionHandle, (IComponentHandle)iComponent, (IVersionableHandle)fileAreaUpdate.getDestinationParent(), (IProgressMonitor)subMonitor2.newChild(1));
                    if (object != null) {
                        this.recordInconsistentShare((IComponentHandle)iComponent, (IShare)object);
                        continue;
                    }
                    this.failedUpdate(iCopyFileArea, fileAreaUpdate);
                    continue;
                }
                string = iPath.toString();
                object2 = new Shareable(iCopyFileArea.getRoot(), iPath, ResourceType.FILE);
                if (((Shareable)object2).getResourceType((IProgressMonitor)subMonitor2.newChild(1)) != ResourceType.FILE) {
                    this.collectStatus(new FileSystemStatus(4, 369, NLS.bind((String)Messages.UpdateMutator_35, (Object)string, (Object[])new Object[]{iComponent.getName()})));
                    this.recordInconsistentShare((IComponentHandle)iComponent, ((Shareable)object2).getShare((IProgressMonitor)subMonitor2.newChild(1)));
                    continue;
                }
                if (((Shareable)object2).exists((IProgressMonitor)subMonitor2.newChild(1)) && (((Shareable)object2).getSandbox().isCaseSensitive() || ((Shareable)object2).getFileStorage().storageExists((IProgressMonitor)subMonitor2.newChild(1)) && ((Shareable)object2).getFileStorage().getActualName().equals(iPath.lastSegment()))) {
                    object = new DeferredDownloadInformation(iCopyFileArea, fileAreaUpdate, null);
                    arrayList.add(object);
                    boolean bl = this.skipUpdate(((Shareable)object2).getCopyFileAreaRoot(), ((DeferredInformation)object).getComponent(), ((Shareable)object2).getRemote((IProgressMonitor)subMonitor2));
                    this.storeFileContent((DeferredDownloadInformation)object, (Shareable)object2, bl, (IProgressMonitor)subMonitor2);
                    continue;
                }
                this.collectStatus(new FileSystemStatus(2, 369, NLS.bind((String)Messages.UpdateMutator_8, (Object)string, (Object[])new Object[]{iComponent.getName()})));
            }
            finally {
                subMonitor2.done();
            }
        }
    }

    private void modifyLink(IComponent iComponent, FileAreaUpdate fileAreaUpdate, HashSet hashSet, HashSet hashSet2, IProgressMonitor iProgressMonitor) throws FileSystemClientException, TeamRepositoryException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)101);
        if (!this.isComponentShared((IComponentHandle)iComponent, (IProgressMonitor)subMonitor.newChild(1))) {
            return;
        }
        List list = (List)this.copyFileAreasByComponent.get(iComponent.getItemId());
        subMonitor.setWorkRemaining(100 * list.size());
        ISymbolicLinkHandle iSymbolicLinkHandle = (ISymbolicLinkHandle)fileAreaUpdate.afterState();
        for (ICopyFileArea iCopyFileArea : list) {
            SubMonitor subMonitor2 = subMonitor.newChild(100);
            String string = fileAreaUpdate.getName();
            try {
                Object object;
                IPath iPath = iCopyFileArea.getLocalPathFor(this.connectionHandle, (IComponentHandle)iComponent, (IVersionableHandle)iSymbolicLinkHandle, (IProgressMonitor)subMonitor2.newChild(1));
                if (iPath == null) {
                    Object object2;
                    object = iCopyFileArea.getItemInfo((IVersionableHandle)iSymbolicLinkHandle, (IComponentHandle)iComponent, this.connectionHandle);
                    if (object != null) {
                        object2 = iCopyFileArea.getRemotePathFor(this.connectionHandle, (IComponentHandle)iComponent, (IVersionableHandle)iSymbolicLinkHandle, (IProgressMonitor)subMonitor2.newChild(1));
                        if (object2 != null) {
                            string = object2.toString();
                        }
                        this.collectStatus(new FileSystemStatus(2, 369, NLS.bind((String)Messages.UpdateMutator_30, (Object)string, (Object[])new Object[]{iComponent.getName()})));
                        continue;
                    }
                    object2 = iCopyFileArea.getShare(this.connectionHandle, (IComponentHandle)iComponent, (IVersionableHandle)fileAreaUpdate.getDestinationParent(), (IProgressMonitor)subMonitor2.newChild(1));
                    if (object2 != null) {
                        this.recordInconsistentShare((IComponentHandle)iComponent, (IShare)object2);
                        continue;
                    }
                    this.failedUpdate(iCopyFileArea, fileAreaUpdate);
                    continue;
                }
                string = iPath.toString();
                object = new Shareable(iCopyFileArea.getRoot(), iPath, ResourceType.SYMBOLIC_LINK);
                if (((Shareable)object).getResourceType((IProgressMonitor)subMonitor2.newChild(1)) != ResourceType.SYMBOLIC_LINK) {
                    this.collectStatus(new FileSystemStatus(4, 369, NLS.bind((String)Messages.UpdateMutator_33, (Object)string, (Object[])new Object[]{iComponent.getName()})));
                    this.recordInconsistentShare((IComponentHandle)iComponent, ((Shareable)object).getShare((IProgressMonitor)subMonitor2.newChild(1)));
                    continue;
                }
                if (((Shareable)object).exists((IProgressMonitor)subMonitor2.newChild(1)) && (((Shareable)object).getSandbox().isCaseSensitive() || ((Shareable)object).getFileStorage().storageExists((IProgressMonitor)subMonitor2.newChild(1)) && ((Shareable)object).getFileStorage().getActualName().equals(iPath.lastSegment()))) {
                    this.modifyLink(iCopyFileArea, (Shareable)object, iComponent, fileAreaUpdate, hashSet, hashSet2, subMonitor2);
                    continue;
                }
                this.collectStatus(new FileSystemStatus(2, 369, NLS.bind((String)Messages.UpdateMutator_42, (Object)string, (Object[])new Object[]{iComponent.getName()})));
            }
            finally {
                subMonitor2.done();
            }
        }
    }

    private void modifyLink(ICopyFileArea iCopyFileArea, Shareable shareable, IComponent iComponent, FileAreaUpdate fileAreaUpdate, HashSet hashSet, HashSet hashSet2, SubMonitor subMonitor) throws TeamRepositoryException, FileSystemClientException {
        InverseFileItemInfo inverseFileItemInfo;
        IVersionableHandle iVersionableHandle;
        String string;
        SubMonitor subMonitor2;
        block10: {
            subMonitor2 = SubMonitor.convert((IProgressMonitor)((IProgressMonitor)subMonitor), (int)100);
            string = fileAreaUpdate.getLinkTarget();
            iVersionableHandle = fileAreaUpdate.afterState();
            if (ManagedFileStore.supportsSymLinks()) {
                if (!this.skipUpdate(iCopyFileArea.getRoot(), (IComponentHandle)iComponent, shareable.getRemote((IProgressMonitor)subMonitor))) {
                    SharingManager.getInstance().disableChangeMonitoring();
                    try {
                        try {
                            shareable.getFileStorage().setTarget(this.shed, string == null ? "" : string, (IProgressMonitor)subMonitor2.newChild(50));
                            hashSet.add(shareable);
                        }
                        catch (FileSystemClientException fileSystemClientException) {
                            this.collectStatus(FileSystemStatus.getStatusFor((Throwable)((Object)fileSystemClientException)));
                            this.recordInconsistentShare((IComponentHandle)iComponent, shareable.getShare(null));
                            SharingManager.getInstance().enableChangeMonitoring();
                            break block10;
                        }
                    }
                    catch (Throwable throwable) {
                        SharingManager.getInstance().enableChangeMonitoring();
                        throw throwable;
                    }
                    SharingManager.getInstance().enableChangeMonitoring();
                }
            } else {
                this.collectStatus(FileSystemStatus.getStatusFor(1, NLS.bind((String)Messages.UpdateMutator_47, (Object)shareable.getLocalPath().toString(), (Object[])new Object[]{string}), null));
                hashSet2.add(shareable);
            }
        }
        if ((inverseFileItemInfo = iCopyFileArea.getItemInfo(iVersionableHandle, (IComponentHandle)iComponent, this.connectionHandle)) == null) {
            this.collectStatus(FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.UpdateMutator_48, (Object)shareable.getLocalPath().toString(), (Object[])new Object[]{iComponent.getName()}), null));
            this.recordInconsistentShare((IComponentHandle)iComponent, shareable.getShare(null));
        } else {
            FileItemInfoProxy fileItemInfoProxy = new FileItemInfoProxy(inverseFileItemInfo);
            fileItemInfoProxy.setItemState(iVersionableHandle);
            fileItemInfoProxy.setTarget(shareable.getFileStorage().getModificationStamp(), string);
            FileItemInfo fileItemInfo = fileItemInfoProxy.getFileItemInfo();
            iCopyFileArea.setItemMetaData(shareable.getLocalPath(), fileItemInfo, (IProgressMonitor)subMonitor2.newChild(10));
        }
    }

    private void storeFileContent(DeferredDownloadInformation deferredDownloadInformation, Shareable shareable, boolean bl, IProgressMonitor iProgressMonitor) throws TeamRepositoryException, FileSystemClientException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        if (bl && shareable.getRemote((IProgressMonitor)subMonitor.newChild(1)) != null && !FileSystemCore.getContentManager(this.repository).convertDelimitersDuringRetrieval(deferredDownloadInformation.getContent())) {
            IFileContent iFileContent = deferredDownloadInformation.getContent();
            deferredDownloadInformation.setContentUpdated(shareable, iFileContent.getHash(), iFileContent.getRawLength());
            return;
        }
        if (shareable.exists((IProgressMonitor)subMonitor.newChild(1))) {
            try {
                this.shed.forceBackup(shareable, (IProgressMonitor)subMonitor.newChild(10));
            }
            catch (TeamRepositoryException teamRepositoryException) {
                throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.UpdateMutator_36, (Object)shareable.getLocalPath().toString(), (Object[])new Object[0]), (Throwable)teamRepositoryException)));
            }
            catch (FileSystemClientException fileSystemClientException) {
                throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.UpdateMutator_36, (Object)shareable.getLocalPath().toString(), (Object[])new Object[0]), (Throwable)((Object)fileSystemClientException))));
            }
        }
        UpdateMutator$DownloadHandler updateMutator$DownloadHandler = new UpdateMutator$DownloadHandler(this, shareable, deferredDownloadInformation, bl);
        this.contentSession.retrieveContent((IFileItemHandle)deferredDownloadInformation.getFileItemState(), deferredDownloadInformation.getContent(), updateMutator$DownloadHandler);
    }

    private static void read(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[16000];
        try {
            while (inputStream.read(byArray) != -1) {
            }
        }
        catch (Throwable throwable) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            inputStream.close();
        }
        catch (IOException iOException) {}
    }

    protected final void moveSubtree(IComponent iComponent, FileAreaUpdate fileAreaUpdate, IProgressMonitor iProgressMonitor) throws FileSystemClientException, TeamRepositoryException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)110);
        IComponent iComponent2 = fileAreaUpdate.getComponent().sameItemId((IItemHandle)fileAreaUpdate.getPreviousComponent()) ? iComponent : (IComponent)this.connection.teamRepository().itemManager().fetchCompleteItem((IItemHandle)fileAreaUpdate.getPreviousComponent(), 0, (IProgressMonitor)subMonitor.newChild(1));
        IFolderHandle iFolderHandle = fileAreaUpdate.getDestinationParent();
        String string = fileAreaUpdate.getName();
        IVersionableHandle iVersionableHandle = fileAreaUpdate.afterState();
        boolean bl = fileAreaUpdate.isChangeType(4);
        if (!this.isComponentShared((IComponentHandle)iComponent2, (IProgressMonitor)subMonitor.newChild(1))) {
            return;
        }
        List list = (List)this.copyFileAreasByComponent.get(iComponent2.getItemId());
        subMonitor.setWorkRemaining(100 * list.size());
        for (ICopyFileArea iCopyFileArea : list) {
            Object object;
            Shareable shareable;
            Object object2;
            Shareable shareable2;
            SubMonitor subMonitor2 = subMonitor.newChild(100);
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = false;
            IShare iShare = null;
            IShare iShare2 = null;
            IPath iPath = null;
            String string2 = fileAreaUpdate.getOldName();
            String string3 = fileAreaUpdate.getName();
            IPath iPath2 = iCopyFileArea.getLocalPathFor(this.connectionHandle, (IComponentHandle)iComponent2, iVersionableHandle, (IProgressMonitor)subMonitor2.newChild(1));
            if (iPath2 != null) {
                shareable2 = new Shareable(iCopyFileArea.getRoot(), iPath2, ResourceType.getResourceType(iVersionableHandle));
                iShare2 = shareable2.getShare((IProgressMonitor)subMonitor2.newChild(1));
                bl2 = shareable2.exists((IProgressMonitor)subMonitor2.newChild(1));
                if (!(!bl2 || shareable2.getSandbox().isCaseSensitive() || shareable2.getFileStorage().storageExists((IProgressMonitor)subMonitor2.newChild(1)) && iPath2.lastSegment().equals(shareable2.getFileStorage().getActualName()))) {
                    bl2 = false;
                }
                bl3 = shareable2.isShare((IProgressMonitor)subMonitor2.newChild(1));
                string2 = iPath2.toString();
            } else {
                bl2 = false;
                iShare2 = iCopyFileArea.getShare(this.connectionHandle, (IComponentHandle)iComponent2, iVersionableHandle, (IProgressMonitor)subMonitor2.newChild(1));
                shareable2 = iCopyFileArea.getRemotePathFor(this.connectionHandle, (IComponentHandle)iComponent2, iVersionableHandle, (IProgressMonitor)subMonitor2.newChild(1));
                if (shareable2 != null) {
                    string2 = shareable2.toString();
                }
            }
            shareable2 = null;
            SharePoint sharePoint = this.getSharePoint(iCopyFileArea, iComponent, iFolderHandle);
            if (sharePoint != null) {
                iPath = PathUtils.getPath(sharePoint.getRelativePath()).append(string);
                bl5 = true;
                string3 = iPath.toString();
            } else {
                object2 = iCopyFileArea.getLocalPathFor(this.connectionHandle, (IComponentHandle)iComponent, (IVersionableHandle)iFolderHandle, (IProgressMonitor)subMonitor2.newChild(1));
                shareable2 = null;
                if (object2 != null) {
                    shareable2 = new Shareable(iCopyFileArea.getRoot(), (IPath)object2, ResourceType.FOLDER);
                    iPath = shareable2.getLocalPath().append(string);
                    string3 = iPath.toString();
                    iShare = shareable2.getShare((IProgressMonitor)subMonitor2.newChild(1));
                    bl4 = true;
                } else {
                    bl4 = false;
                    iShare = iCopyFileArea.getShare(this.connectionHandle, (IComponentHandle)iComponent, (IVersionableHandle)iFolderHandle, (IProgressMonitor)subMonitor2.newChild(1));
                    if (iShare == null && bl3) {
                        bl5 = true;
                        iPath = iShare2.getPath().removeLastSegments(1).append(string);
                    } else if (iShare != null && (shareable = iCopyFileArea.getRemotePathFor(this.connectionHandle, (IComponentHandle)iComponent, (IVersionableHandle)iFolderHandle, (IProgressMonitor)subMonitor2.newChild(1))) != null) {
                        string3 = shareable.toString();
                    }
                }
            }
            if (!bl2) {
                this.recordInconsistentShare((IComponentHandle)iComponent2, iShare2);
                this.recordInconsistentShare((IComponentHandle)iComponent, iShare);
                if (iShare2 == null) {
                    this.failedUpdate(iCopyFileArea, fileAreaUpdate, fileAreaUpdate.getPreviousComponent());
                }
                if (iShare != null || iShare2 != null) {
                    this.collectStatus(new FileSystemStatus(4, 371, NLS.bind((String)Messages.UpdateMutator_9, (Object)string2, (Object[])new Object[]{string3, iComponent.getName()})));
                    continue;
                }
                if (bl5) continue;
                this.failedUpdate(iCopyFileArea, fileAreaUpdate);
                continue;
            }
            if (!(bl4 || bl5 || bl3 && iShare == null)) {
                this.recordInconsistentShare((IComponentHandle)iComponent2, iShare2);
                this.recordInconsistentShare((IComponentHandle)iComponent, iShare);
                this.collectStatus(new FileSystemStatus(4, 371, NLS.bind((String)Messages.UpdateMutator_10, (Object)string2, (Object[])new Object[]{string3, iComponent.getName()})));
                continue;
            }
            object2 = new Shareable(iCopyFileArea.getRoot(), iPath2, ResourceType.getResourceType(iVersionableHandle));
            shareable = new Shareable(iCopyFileArea.getRoot(), iPath, ResourceType.getResourceType(iVersionableHandle));
            if (bl3 && bl5 && ((FileItemInfo)(object = iCopyFileArea.getItemInfo(((Shareable)object2).getLocalPath()))).isLoadedWithAnotherName()) {
                if (!bl5) {
                    this.recordInconsistentShare((IComponentHandle)iComponent2, iShare2);
                    this.recordInconsistentShare((IComponentHandle)iComponent, iShare);
                    this.collectStatus(new FileSystemStatus(4, 371, NLS.bind((String)Messages.UpdateMutator_43, (Object)string2, (Object[])new Object[]{string3, iComponent.getName()})));
                }
                this.updateMetaDataAfterMove(iCopyFileArea, iComponent, (IComponentHandle)iComponent2, (Shareable)object2, shareable, bl3, true, bl, iFolderHandle, iVersionableHandle, string, (IProgressMonitor)subMonitor2.newChild(75));
                continue;
            }
            if (iVersionableHandle.sameItemId((IItemHandle)shareable.getRemote((IProgressMonitor)subMonitor2.newChild(1))) && iComponent.sameItemId((IItemHandle)iComponent2)) {
                if (fileAreaUpdate.getOldName().equals(fileAreaUpdate.getName())) {
                    this.updateMetaDataAfterMove(iCopyFileArea, iComponent, (IComponentHandle)iComponent2, (Shareable)object2, shareable, bl3, true, bl, iFolderHandle, iVersionableHandle, string, (IProgressMonitor)subMonitor2.newChild(75));
                    continue;
                }
            } else if (shareable.exists((IProgressMonitor)subMonitor2.newChild(1)) || !shareable.getSandbox().isCaseSensitive() && (shareable.getFileStorage().storageExists((IProgressMonitor)subMonitor2.newChild(1)) || !shareable.getFileStorage().getActualName().equals(fileAreaUpdate.getName()))) {
                if (PathUtils.sameRelativePath(shareable.getLocalPath(), true, ((Shareable)object2).getLocalPath(), true)) {
                    this.updateMetaDataAfterMove(iCopyFileArea, iComponent, (IComponentHandle)iComponent2, (Shareable)object2, shareable, bl3, true, bl, iFolderHandle, iVersionableHandle, string, (IProgressMonitor)subMonitor2.newChild(75));
                    continue;
                }
                if (!this.handleCollision(iCopyFileArea, iComponent, shareable, (IProgressMonitor)subMonitor2.newChild(25))) {
                    this.collectStatus(new FileSystemStatus(4, 371, NLS.bind((String)Messages.UpdateMutator_13, (Object)iPath2.toString(), (Object[])new Object[]{iPath.toString()})));
                    this.recordInconsistentShare((IComponentHandle)iComponent2, iShare2);
                    this.recordInconsistentShare((IComponentHandle)iComponent, iShare);
                    continue;
                }
            }
            object = new Shareable(iCopyFileArea.getRoot(), iPath, ResourceType.getResourceType(iVersionableHandle));
            this.move(iCopyFileArea, iComponent, (IComponentHandle)iComponent2, (Shareable)object2, (Shareable)object, iFolderHandle, string, iVersionableHandle, true, bl, (IProgressMonitor)subMonitor2.newChild(75));
        }
    }

    private void move(ICopyFileArea iCopyFileArea, IComponent iComponent, IComponentHandle iComponentHandle, Shareable shareable, Shareable shareable2, IFolderHandle iFolderHandle, String string, IVersionableHandle iVersionableHandle, boolean bl, boolean bl2, IProgressMonitor iProgressMonitor) throws FileSystemClientException, TeamRepositoryException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        boolean bl3 = shareable.isShare((IProgressMonitor)subMonitor.newChild(1));
        IFileStorage iFileStorage = shareable.getFileStorage();
        IPath iPath = shareable2.getLocalPath();
        if (!this.skipUpdate(iCopyFileArea.getRoot(), iComponentHandle, shareable.getRemote((IProgressMonitor)subMonitor.newChild(1)))) {
            try {
                SharingManager.getInstance().doSilentChange(new UpdateMutator$4(this, iFileStorage, shareable2, iPath, subMonitor));
            }
            catch (CoreException coreException) {
                throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(coreException)));
            }
        }
        this.updateMetaDataAfterMove(iCopyFileArea, iComponent, iComponentHandle, shareable, shareable2, bl3, bl, bl2, iFolderHandle, iVersionableHandle, string, (IProgressMonitor)subMonitor.newChild(24));
    }

    private boolean handleCollision(ICopyFileArea iCopyFileArea, IComponent iComponent, Shareable shareable, IProgressMonitor iProgressMonitor) throws FileSystemClientException, TeamRepositoryException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        IVersionableHandle iVersionableHandle = shareable.getRemote((IProgressMonitor)subMonitor.newChild(1));
        boolean bl = false;
        shareable = this.getShareableForExistingStorage(shareable, (IProgressMonitor)subMonitor.newChild(1));
        if (iVersionableHandle != null) {
            boolean bl2 = this.updateInfo.isMovedOrDeleted((IComponentHandle)iComponent, iVersionableHandle);
            if (shareable.isShare((IProgressMonitor)subMonitor.newChild(1))) {
                if (!bl2) {
                    this.collectStatus(new FileSystemStatus(2, 333, NLS.bind((String)Messages.UpdateMutator_17, (Object)shareable.getLocalPath(), (Object[])new Object[0])));
                } else {
                    bl = true;
                }
            } else if (bl2) {
                bl = true;
            } else {
                return false;
            }
        }
        if (bl) {
            this.preserve(iCopyFileArea, iComponent, shareable, (IProgressMonitor)subMonitor.newChild(98));
        } else {
            this.deleteSubtree(iComponent, shareable, (IProgressMonitor)subMonitor.newChild(98));
        }
        return true;
    }

    private Shareable getShareableForExistingStorage(Shareable shareable, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        if (!shareable.getSandbox().isCaseSensitive() && !shareable.getFileStorage().storageExists((IProgressMonitor)subMonitor.newChild(1))) {
            Object object;
            Shareable shareable2 = null;
            ResourceType resourceType = shareable.getResourceType((IProgressMonitor)subMonitor.newChild(4));
            IFileStorage iFileStorage = shareable.getFileStorage().getParent();
            if (iFileStorage != null) {
                object = iFileStorage.getChild(shareable.getLocalPath().lastSegment(), (IProgressMonitor)subMonitor.newChild(10));
                if (object != null) {
                    shareable2 = object.getShareable();
                }
            } else {
                object = shareable.getFullPath().toFile().getParentFile();
                if (object != null) {
                    File[] fileArray;
                    String string = shareable.getLocalPath().lastSegment().toUpperCase().toLowerCase();
                    File[] fileArray2 = fileArray = ((File)object).listFiles();
                    int n = fileArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File file = fileArray2[n2];
                        if (file.getName().length() == string.length() && file.getName().toUpperCase().toLowerCase().equals(string)) {
                            Path path = new Path(file.getAbsolutePath());
                            shareable2 = (Shareable)SharingManager.getInstance().findShareable((IPath)path, resourceType == null ? ResourceType.FILE : resourceType);
                            if (shareable2 == null || shareable2.getFileStorage().storageExists((IProgressMonitor)subMonitor.newChild(1))) break;
                            shareable2 = null;
                            break;
                        }
                        ++n2;
                    }
                }
            }
            if (shareable2 == null) {
                object = SharingManager.getInstance().getLocalFileStorage(shareable.getSandbox(), shareable.getLocalPath(), resourceType == null ? ResourceType.FILE : resourceType);
                shareable2 = object.getShareable();
            }
            shareable = shareable2;
        }
        return shareable;
    }

    private void preserve(ICopyFileArea iCopyFileArea, IComponent iComponent, Shareable shareable, IProgressMonitor iProgressMonitor) throws FileSystemClientException, TeamRepositoryException {
        String string;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        boolean bl = shareable.isShare((IProgressMonitor)subMonitor.newChild(1));
        IPath iPath = shareable.getFullPath();
        ResourceType resourceType = shareable.getResourceType((IProgressMonitor)subMonitor.newChild(1));
        IPath iPath2 = iPath.removeLastSegments(1);
        String string2 = iPath.lastSegment();
        String string3 = shareable.getLocalPath().lastSegment();
        int n = string3.lastIndexOf(".");
        if (n < 0) {
            string3 = "";
        } else {
            string3 = string3.substring(n);
            string2 = string2.substring(0, string2.length() - string3.length());
        }
        string2 = String.valueOf(string2) + COLLISION_RENAME;
        int n2 = 0;
        IPath iPath3 = null;
        do {
            string = String.valueOf(string2) + n2 + string3;
            ++n2;
        } while (PathUtils.exists(iPath3 = iPath2.append(string), (IProgressMonitor)subMonitor.newChild(1)));
        IFileStorage iFileStorage = shareable.getFileStorage();
        IPath iPath4 = shareable.getLocalPath().removeLastSegments(1).append(string);
        try {
            SharingManager.getInstance().doSilentChange(new UpdateMutator$5(this, iFileStorage, shareable, iPath4, subMonitor));
        }
        catch (CoreException coreException) {
            throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(coreException)));
        }
        Shareable shareable2 = new Shareable(shareable.getSandbox(), iPath4, resourceType);
        this.updateMetaDataAfterMove(iCopyFileArea, iComponent, (IComponentHandle)iComponent, shareable, shareable2, bl, false, false, null, null, null, (IProgressMonitor)subMonitor.newChild(25));
        subMonitor.done();
    }

    protected final boolean isComponentShared(IComponentHandle iComponentHandle, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        if (iComponentHandle.sameItemId((IItemHandle)this.lastComponentShareTested)) {
            return this.lastComponentSharedResult;
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)this.copyFileAreasToUpdate.size());
        this.lastComponentShareTested = iComponentHandle;
        ArrayList<ICopyFileArea> arrayList = (ArrayList<ICopyFileArea>)this.copyFileAreasByComponent.get(iComponentHandle.getItemId());
        if (arrayList != null) {
            this.lastComponentSharedResult = true;
            return this.lastComponentSharedResult;
        }
        if (this.componentNotShared.contains(iComponentHandle.getItemId())) {
            this.lastComponentSharedResult = false;
            return this.lastComponentSharedResult;
        }
        arrayList = new ArrayList<ICopyFileArea>(2);
        for (Object object : this.copyFileAreasToUpdate) {
            if (!object.isConfigurationShared(this.connectionHandle, iComponentHandle, (IProgressMonitor)subMonitor.newChild(1))) continue;
            arrayList.add((ICopyFileArea)object);
        }
        boolean bl = this.lastComponentSharedResult = !arrayList.isEmpty();
        if (this.lastComponentSharedResult) {
            this.copyFileAreasByComponent.put(iComponentHandle.getItemId(), arrayList);
        } else {
            Object object;
            this.componentNotShared.add(iComponentHandle.getItemId());
            try {
                IComponent iComponent = this.getFullComponent(iComponentHandle, null, (IProgressMonitor)subMonitor.newChild(1));
                object = NLS.bind((String)Messages.UpdateMutator_18, (Object)iComponent.getName(), (Object[])new Object[0]);
            }
            catch (TeamRepositoryException teamRepositoryException) {
                object = Messages.UpdateMutator_7;
            }
            this.collectStatus(new FileSystemStatus(2, 367, (String)object));
        }
        return this.lastComponentSharedResult;
    }

    private void recordInconsistentShare(IComponentHandle iComponentHandle, IShare iShare) {
        if (iShare != null) {
            this.inconsistentShares.add(new UpdateMutator$ShareReference(iComponentHandle, iShare));
        }
    }

    private void recordInconsistentComponent(ICopyFileArea iCopyFileArea, IComponent iComponent, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        Collection collection = iCopyFileArea.allShares(this.connectionHandle, (IComponentHandle)iComponent, iProgressMonitor);
        for (IShare iShare : collection) {
            this.recordInconsistentShare((IComponentHandle)iComponent, iShare);
        }
    }

    /*
     * Unable to fully structure code
     */
    protected final void execute(IProgressMonitor var1_1) throws TeamRepositoryException, FileSystemClientException {
        ThreadCheck.checkLongOpsAllowed();
        var2_2 = SubMonitor.convert((IProgressMonitor)var1_1, (int)100);
        this.updateInfo = var3_3 = new UpdateOrder(this.updates.getAdds(), this.updates.getDeletes(), this.updates.getMoves(), this.updates.getModifies());
        var4_4 = var3_3.getFileMoves().size() + var3_3.getFileAdds().size() + var3_3.getGroupedModifies().size();
        var5_5 = new ArrayList<E>(var4_4);
        var6_6 = new HashSet<E>();
        var7_7 = new HashSet<E>();
        this.contentSession = FileSystemCore.getContentManager(this.repository).createSession(NLS.bind((String)Messages.UpdateMutator_19, (Object)this.connection.getName(), (Object[])new Object[0]), true, var4_4, (IProgressMonitor)var2_2.newChild(80));
        var8_8 = new CancellationMonitor((IProgressMonitor)var2_2);
        var9_9 = null;
        try {
            this.startingUpdates(var3_3, (IProgressMonitor)var8_8);
            for (FileAreaUpdate var10_12 : var3_3.getFolderAdds()) {
                var9_9 = this.getFullComponent(var10_12, var9_9, (IProgressMonitor)var8_8);
                this.createFolder(var9_9, var10_12, (IProgressMonitor)var8_8);
                this.checkCancelled((IProgressMonitor)var8_8);
            }
            for (FileAreaUpdate var10_12 : var3_3.getFolderMoves()) {
                var9_9 = this.getFullComponent(var10_12, var9_9, (IProgressMonitor)var8_8);
                this.moveSubtree(var9_9, var10_12, (IProgressMonitor)var8_8);
                var3_3.processed(var10_12);
                this.checkCancelled((IProgressMonitor)var8_8);
            }
            this.folderAddsAndMovesCompleted((IProgressMonitor)var8_8);
            for (FileAreaUpdate var10_12 : var3_3.getLinkMoves()) {
                var9_9 = this.getFullComponent(var10_12, var9_9, (IProgressMonitor)var8_8);
                this.moveSubtree(var9_9, var10_12, (IProgressMonitor)var8_8);
                var3_3.processed(var10_12);
                if (var10_12.isChangeType(4)) {
                    this.modifyLink(var9_9, var10_12, var6_6, var7_7, (IProgressMonitor)var8_8);
                }
                this.checkCancelled((IProgressMonitor)var8_8);
            }
            for (FileAreaUpdate var10_12 : var3_3.getFileMoves()) {
                var9_9 = this.getFullComponent(var10_12, var9_9, (IProgressMonitor)var8_8);
                this.moveSubtree(var9_9, var10_12, (IProgressMonitor)var8_8);
                var3_3.processed(var10_12);
                if (var10_12.isChangeType(4)) {
                    this.modifyFile(var9_9, var10_12, var5_5, var10_12.getFileTimestamp(), (IProgressMonitor)var8_8);
                } else {
                    this.contentSession.decrementTransferCount(1L);
                }
                this.checkCancelled((IProgressMonitor)var8_8);
            }
            for (FileAreaUpdate var10_12 : var3_3.getOrderedDeletes()) {
                var9_9 = this.getFullComponent(var10_12, var9_9, (IProgressMonitor)var8_8);
                this.deleteSubtree(var9_9, var10_12.getSourceParent(), var10_12.getName(), var10_12.beforeState(), (IProgressMonitor)var8_8);
                var3_3.processed(var10_12);
                this.checkCancelled((IProgressMonitor)var8_8);
            }
            for (FileAreaUpdate var10_12 : var3_3.getGroupedModifies()) {
                if (var10_12.getItem() instanceof IFileItemHandle) {
                    var9_9 = this.getFullComponent(var10_12, var9_9, (IProgressMonitor)var8_8);
                    this.modifyFile(var9_9, var10_12, var5_5, var10_12.getFileTimestamp(), (IProgressMonitor)var8_8);
                } else if (var10_12.getItem() instanceof ISymbolicLinkHandle) {
                    var9_9 = this.getFullComponent(var10_12, var9_9, (IProgressMonitor)var8_8);
                    this.modifyLink(var9_9, var10_12, var6_6, var7_7, (IProgressMonitor)var8_8);
                    this.contentSession.decrementTransferCount(1L);
                }
                this.checkCancelled((IProgressMonitor)var8_8);
            }
            for (FileAreaUpdate var10_12 : var3_3.getLinkAdds()) {
                var9_9 = this.getFullComponent(var10_12, var9_9, (IProgressMonitor)var8_8);
                this.createLink(var9_9, var10_12, var6_6, var7_7, (IProgressMonitor)var8_8);
                this.checkCancelled((IProgressMonitor)var8_8);
            }
            for (FileAreaUpdate var10_12 : var3_3.getFileAdds()) {
                var9_9 = this.getFullComponent(var10_12, var9_9, (IProgressMonitor)var8_8);
                this.createFile(var9_9, var10_12, var5_5, var10_12.getFileTimestamp(), (IProgressMonitor)var8_8);
                this.checkCancelled((IProgressMonitor)var8_8);
            }
            this.verifyUpdatesOutsideShares((IProgressMonitor)var8_8);
        }
        finally {
            this.contentSession.join();
            try {
                if (!var8_8.isCanceled()) {
                    this.doDilemmaHandling(var5_5, (IProgressMonitor)var2_2.newChild(10));
                }
            }
            finally {
                var14_21 = new NonCancellingProgressMonitor((IProgressMonitor)var2_2.newChild(5));
                var15_26 = SubMonitor.convert((IProgressMonitor)((IProgressMonitor)var14_21), (int)(var5_5.size() * 4 + var6_6.size() + var7_7.size()));
                var17_30 = var5_5.iterator();
                if (true) ** GOTO lbl89
            }
            {
            }
        }
        do {
            if (!(var16_34 = (DeferredDownloadInformation)var17_30.next()).contentUpdated()) continue;
            this.refresh(var16_34, (IProgressMonitor)var15_26.newChild(1));
lbl89:
            // 3 sources

        } while (var17_30.hasNext());
        if (!var6_6.isEmpty() || !var7_7.isEmpty()) {
            this.refreshLinks(var6_6, var7_7, (IProgressMonitor)var15_26.newChild(var6_6.size()));
        }
        for (DeferredDownloadInformation var16_34 : var5_5) {
            if (!var16_34.contentUpdated()) continue;
            var18_41 = this.skipUpdate(var16_34.getCopyFileArea().getRoot(), var16_34.getComponent(), var16_34.getShareable().getRemote((IProgressMonitor)var15_26.newChild(1)));
            this.updateMetaData(var16_34, var18_41, (IProgressMonitor)var15_26.newChild(1));
            if (var18_41) continue;
            var16_34.getShareable().getFileStorage().setExecutable(var16_34.isExecutable(), (IProgressMonitor)var15_26.newChild(1));
        }
        var15_26.done();
        var16_34 = var2_2.newChild(5);
        var16_34.setWorkRemaining(var5_5.size());
        for (Object var17_30 : var5_5) {
            if (!var17_30.contentUpdated()) continue;
            this.fileLoaded(var17_30.getShareable(), (IProgressMonitor)var16_34.newChild(1));
        }
        var16_34.done();
        this.updatesComplete((IProgressMonitor)var2_2.newChild(5));
        var10_12 = this.getDownloadFailures(var5_5);
        if (((IStatus[])var10_12).length > 0) {
            var11_11 = false;
            var15_26 = var10_12;
            var14_22 = ((IStatus[])var10_12).length;
            var13_17 = 0;
            while (var13_17 < var14_22) {
                var12_14 = var15_26[var13_17];
                if (var12_14.getSeverity() == 4 || var12_14.getSeverity() == 8) {
                    var11_11 = true;
                }
                this.collectStatus(var12_14);
                ++var13_17;
            }
            if (var11_11) {
                var10_12 = this.getErrors();
                RepositoryUtils.throwAppropriateException(Messages.UpdateMutator_20, (IStatus[])var10_12);
            }
        } else if (this.contentSession.isCanceled()) {
            throw (Throwable)new OperationCanceledException();
        }
        this.updateConfigStates((IProgressMonitor)var2_2.newChild(5));
        this.updateCompleted((IProgressMonitor)var2_2.newChild(5));
    }

    private void refreshLinks(Set set, HashSet hashSet, IProgressMonitor iProgressMonitor) {
        Object object2;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)(set.size() + hashSet.size()));
        for (Object object2 : set) {
            try {
                new Shareable(((Shareable)object2).getSandbox(), ((Shareable)object2).getLocalPath(), ResourceType.SYMBOLIC_LINK).getFileStorage().refreshCachedSubTree(Integer.MAX_VALUE, (IProgressMonitor)subMonitor.newChild(1));
            }
            catch (FileSystemClientException fileSystemClientException) {}
        }
        object2 = LocalChangeManager.getInstance();
        for (Object object3 : hashSet) {
            try {
                ((LocalChangeManager)object2).computeChanges((IShareable)object3, (IProgressMonitor)subMonitor.newChild(1));
            }
            catch (FileSystemClientException fileSystemClientException) {}
        }
    }

    protected void startingUpdates(IUpdateInfo iUpdateInfo, IProgressMonitor iProgressMonitor) {
    }

    protected void folderAddsAndMovesCompleted(IProgressMonitor iProgressMonitor) throws TeamRepositoryException, FileSystemClientException {
    }

    protected void updateCompleted(IProgressMonitor iProgressMonitor) throws TeamRepositoryException, FileSystemClientException {
    }

    private void verifyUpdatesOutsideShares(IProgressMonitor iProgressMonitor) throws TeamRepositoryException, FileSystemClientException {
        HashMap<UUID, IShare> hashMap;
        Map<UUID, Object> map;
        ISharingDescriptor iSharingDescriptor;
        Object object;
        Object object2;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)this.failedUpdates.size());
        if (this.failedUpdates.isEmpty()) {
            return;
        }
        HashMap<ICopyFileArea, Map<UUID, Object>> hashMap2 = new HashMap<ICopyFileArea, Map<UUID, Object>>();
        for (ICopyFileArea object3 : this.copyFileAreasToUpdate) {
            object2 = (Map)this.failedUpdates.get(object3);
            if (object2 == null) continue;
            object = object3.allShares();
            Iterator<Object> iterator = object.iterator();
            while (iterator.hasNext()) {
                IShare iShare = (IShare)iterator.next();
                iSharingDescriptor = iShare.getSharingDescriptor();
                if (!object2.containsKey(iSharingDescriptor.getComponent().getItemId()) || !iSharingDescriptor.getConnectionHandle().sameItemId((IItemHandle)this.connectionHandle)) continue;
                map = (Map)hashMap2.get(object3);
                if (map == null) {
                    map = new HashMap();
                    hashMap2.put(object3, map);
                }
                if ((hashMap = (HashMap<UUID, IShare>)map.get(iSharingDescriptor.getComponent().getItemId())) == null) {
                    hashMap = new HashMap<UUID, IShare>();
                    map.put(iSharingDescriptor.getComponent().getItemId(), hashMap);
                }
                hashMap.put(iSharingDescriptor.getRootVersionable().getItemId(), iShare);
            }
        }
        for (Map.Entry entry : this.failedUpdates.entrySet()) {
            object2 = (ICopyFileArea)entry.getKey();
            object = (Map)entry.getValue();
            for (Map.Entry entry2 : object.entrySet()) {
                AbstractCollection abstractCollection;
                UUID uUID;
                Object object3;
                iSharingDescriptor = null;
                map = new HashMap();
                hashMap = new HashMap<UUID, IShare>();
                HashMap<UUID, AbstractCollection> hashMap3 = new HashMap<UUID, AbstractCollection>();
                Object object4 = ((List)entry2.getValue()).iterator();
                while (object4.hasNext()) {
                    object3 = (FileAreaUpdate)object4.next();
                    if (iSharingDescriptor == null) {
                        iSharingDescriptor = this.connection instanceof IWorkspaceConnection ? (((UUID)entry2.getKey()).equals((Object)object3.getComponent().getItemId()) ? ((IWorkspaceConnection)this.connection).configuration(object3.component()) : ((IWorkspaceConnection)this.connection).configuration(object3.getPreviousComponent())) : ((IBaselineConnection)this.connection).configuration();
                    }
                    if (object3.isChangeType(8)) {
                        if (((UUID)entry2.getKey()).equals((Object)object3.getComponent().getItemId())) {
                            this.determineWhatToLocate((HashMap)map, hashMap, hashMap3, (FileAreaUpdate)object3);
                        }
                        if (!((UUID)entry2.getKey()).equals((Object)object3.getPreviousComponent().getItemId())) continue;
                        uUID = object3.getSourceParent().getItemId();
                        abstractCollection = new HashSet<Object>();
                        ((HashSet)abstractCollection).add(object3);
                        if (!((HashMap)map).containsKey(uUID)) {
                            hashMap.put(uUID, (IShare)object3.getSourceParent());
                            hashMap3.put(uUID, abstractCollection);
                            ((HashMap)map).put(uUID, null);
                            continue;
                        }
                        this.recordUpdateAgainstLocate(uUID, (HashSet)abstractCollection, (HashMap)map, hashMap3);
                        continue;
                    }
                    if (!object3.isChangeType(1) && !object3.isChangeType(4)) continue;
                    this.determineWhatToLocate((HashMap)map, hashMap, hashMap3, (FileAreaUpdate)object3);
                }
                object3 = (Map)hashMap2.get(object2);
                if (object3 == null || (object4 = (HashMap)object3.get(iSharingDescriptor.component().getItemId())) == null || ((HashMap)object4).isEmpty() || hashMap.isEmpty()) continue;
                uUID = (IComponent)this.repository.itemManager().fetchCompleteItem((IItemHandle)iSharingDescriptor.component(), 0, null);
                abstractCollection = new ArrayList(hashMap.values());
                List list = iSharingDescriptor.locateAncestors((List)((Object)abstractCollection), (IProgressMonitor)subMonitor.newChild(1));
                int n = 0;
                for (IAncestorReport iAncestorReport : list) {
                    for (INameItemPair iNameItemPair : iAncestorReport.getNameItemPairs()) {
                        IShare iShare = (IShare)((HashMap)object4).get(iNameItemPair.getItem().getItemId());
                        if (iShare == null) continue;
                        this.recordInconsistentShare(iSharingDescriptor.component(), iShare);
                        this.reportFailedUpdates((IComponent)uUID, (IVersionableHandle)((ArrayList)abstractCollection).get(n), hashMap3);
                    }
                    ++n;
                }
            }
        }
    }

    private void determineWhatToLocate(HashMap hashMap, HashMap hashMap2, HashMap hashMap3, FileAreaUpdate fileAreaUpdate) {
        HashSet hashSet;
        UUID uUID = fileAreaUpdate.item().getItemId();
        UUID uUID2 = fileAreaUpdate.getDestinationParent().getItemId();
        hashMap.put(uUID, uUID2);
        if (hashMap2.containsKey(uUID)) {
            hashMap2.remove(uUID);
            hashSet = (HashSet)hashMap3.remove(uUID);
        } else {
            hashSet = new HashSet();
        }
        hashSet.add(fileAreaUpdate);
        if (!hashMap.containsKey(uUID2)) {
            hashMap2.put(uUID2, fileAreaUpdate.getDestinationParent());
            hashMap3.put(uUID2, hashSet);
            hashMap.put(uUID2, null);
        } else {
            this.recordUpdateAgainstLocate(uUID2, hashSet, hashMap, hashMap3);
        }
    }

    private void recordUpdateAgainstLocate(UUID uUID, HashSet hashSet, HashMap hashMap, HashMap hashMap2) {
        int n = 0;
        while (n < 2000) {
            UUID uUID2 = (UUID)hashMap.get(uUID);
            if (uUID2 == null) {
                HashSet hashSet2 = (HashSet)hashMap2.get(uUID);
                if (hashSet2 == null) {
                    hashMap2.put(uUID, hashSet);
                    break;
                }
                hashSet2.addAll(hashSet);
                break;
            }
            uUID = uUID2;
            ++n;
        }
    }

    private void reportFailedUpdates(IComponent iComponent, IVersionableHandle iVersionableHandle, HashMap hashMap) {
        HashSet hashSet = (HashSet)hashMap.get(iVersionableHandle.getItemId());
        if (hashSet != null) {
            for (FileAreaUpdate fileAreaUpdate : hashSet) {
                if (fileAreaUpdate.isChangeType(4)) {
                    this.collectStatus(new FileSystemStatus(NLS.bind((String)Messages.UpdateMutator_25, (Object)fileAreaUpdate.getName(), (Object[])new Object[]{iComponent.getName()})));
                    continue;
                }
                if (fileAreaUpdate.isChangeType(1) && fileAreaUpdate.item() instanceof IFileItemHandle) {
                    this.collectStatus(new FileSystemStatus(NLS.bind((String)Messages.UpdateMutator_26, (Object)fileAreaUpdate.getName(), (Object[])new Object[]{iComponent.getName()})));
                    continue;
                }
                if (fileAreaUpdate.isChangeType(1) && fileAreaUpdate.item() instanceof IFolderHandle) {
                    this.collectStatus(new FileSystemStatus(NLS.bind((String)Messages.UpdateMutator_27, (Object)fileAreaUpdate.getName(), (Object[])new Object[]{iComponent.getName()})));
                    continue;
                }
                if (fileAreaUpdate.isChangeType(1) && fileAreaUpdate.item() instanceof ISymbolicLinkHandle) {
                    this.collectStatus(new FileSystemStatus(NLS.bind((String)Messages.UpdateMutator_49, (Object)fileAreaUpdate.getName(), (Object[])new Object[]{iComponent.getName()})));
                    continue;
                }
                if (!fileAreaUpdate.isChangeType(8)) continue;
                this.collectStatus(new FileSystemStatus(NLS.bind((String)Messages.UpdateMutator_28, (Object)fileAreaUpdate.getOldName(), (Object[])new Object[]{iComponent.getName()})));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void doDilemmaHandling(ArrayList arrayList, IProgressMonitor iProgressMonitor) throws FileSystemClientException, TeamRepositoryException {
        Throwable throwable;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor);
        subMonitor.setWorkRemaining(100);
        ArrayList<EncodingDownloadFailure> arrayList2 = new ArrayList<EncodingDownloadFailure>();
        for (DeferredInformation deferredInformation : arrayList) {
            void var7_15;
            if (deferredInformation == null || deferredInformation.getFailure() == null) continue;
            Throwable throwable2 = deferredInformation.getFailure().getCause();
            int n = 0;
            while (var7_15 instanceof TeamRepositoryException && n < 50) {
                throwable = ((TeamRepositoryException)var7_15).getCause();
                if (throwable == null) break;
                Throwable throwable3 = throwable;
                ++n;
            }
            if (var7_15 instanceof UnsupportedEncodingException || var7_15 instanceof UnsupportedCharsetException) {
                arrayList2.add(new EncodingDownloadFailure(deferredInformation));
                continue;
            }
            if (var7_15 instanceof CharacterCodingException) {
                arrayList2.add(new EncodingDownloadFailure(deferredInformation));
                continue;
            }
            if (!(var7_15 instanceof OperationCanceledException)) continue;
            throw (Throwable)new OperationCanceledException();
        }
        if (arrayList2.size() > 0) {
            boolean bl;
            for (EncodingDownloadFailure encodingDownloadFailure : arrayList2) {
                encodingDownloadFailure.setIgnoreEncoding(true);
            }
            boolean bl2 = false;
            this.contentSession = FileSystemCore.getContentManager(this.repository).createSession(NLS.bind((String)Messages.UpdateMutator_19, (Object)this.connection.getName(), (Object[])new Object[0]), true, arrayList2.size(), (IProgressMonitor)subMonitor.newChild(75));
            try {
                for (EncodingDownloadFailure encodingDownloadFailure : arrayList2) {
                    if (!encodingDownloadFailure.hasDirection()) continue;
                    DeferredDownloadInformation deferredDownloadInformation = (DeferredDownloadInformation)encodingDownloadFailure.getDeferredUpdateInformation();
                    throwable = deferredDownloadInformation.getFileItemState();
                    this.contentSession.retrieveContent((IFileItemHandle)throwable, deferredDownloadInformation.getContent(), deferredDownloadInformation.getEncoding(), deferredDownloadInformation.getLineDelimiter(), new UpdateMutator$DownloadHandler(this, deferredDownloadInformation.getShareable(), deferredDownloadInformation, false));
                    bl = true;
                }
            }
            finally {
                if (bl) {
                    this.contentSession.join();
                }
            }
            SubMonitor subMonitor2 = subMonitor.newChild(25);
            subMonitor2.setWorkRemaining(arrayList2.size());
            for (EncodingDownloadFailure encodingDownloadFailure : arrayList2) {
                if (!encodingDownloadFailure.getDeferredUpdateInformation().isLineDelimiterIgnored() || encodingDownloadFailure.getDeferredUpdateInformation().getFailure() != null) continue;
                encodingDownloadFailure.getDeferredUpdateInformation().convert((IProgressMonitor)subMonitor2.newChild(1));
            }
        }
    }

    private IStatus[] getDownloadFailures(ArrayList arrayList) {
        ArrayList<String> arrayList2 = new ArrayList<String>();
        boolean bl = false;
        for (DeferredDownloadInformation deferredDownloadInformation : arrayList) {
            Status status;
            Throwable throwable;
            if (deferredDownloadInformation == null) continue;
            if (deferredDownloadInformation.getFailure() != null) {
                Serializable serializable;
                throwable = deferredDownloadInformation.getFailure().getCause();
                if (throwable == null) {
                    throwable = deferredDownloadInformation.getFailure();
                }
                int n = 0;
                while (throwable instanceof TeamRepositoryException && n < 50) {
                    serializable = ((TeamRepositoryException)throwable).getCause();
                    if (serializable == null) break;
                    throwable = serializable;
                    ++n;
                }
                if (throwable instanceof UnsupportedEncodingException || throwable instanceof UnsupportedCharsetException) {
                    if (!bl) {
                        String string2;
                        serializable = new StringBuffer();
                        for (String string2 : Charset.availableCharsets().keySet()) {
                            ((StringBuffer)serializable).append(string2).append(' ');
                        }
                        string2 = new Status(1, "com.ibm.team.filesystem.client", NLS.bind((String)Messages.UpdateMutator_11, (Object)((StringBuffer)serializable).toString(), (Object[])new Object[0]));
                        arrayList2.add(string2);
                        bl = true;
                    }
                    status = new Status(4, "com.ibm.team.filesystem.client", NLS.bind((String)Messages.UpdateMutator_21, (Object)deferredDownloadInformation.getShareable().getLocalPath(), (Object[])new Object[]{deferredDownloadInformation.getContent().getCharacterEncoding()}), (Throwable)deferredDownloadInformation.getFailure());
                } else if (throwable instanceof CharacterCodingException) {
                    status = new Status(4, "com.ibm.team.filesystem.client", NLS.bind((String)Messages.UpdateMutator_23, (Object)deferredDownloadInformation.getShareable().getLocalPath(), (Object[])new Object[]{deferredDownloadInformation.getContent().getCharacterEncoding()}), (Throwable)deferredDownloadInformation.getFailure());
                } else {
                    if (throwable instanceof OperationCanceledException) continue;
                    status = new Status(4, "com.ibm.team.filesystem.client", NLS.bind((String)Messages.UpdateMutator_22, (Object)deferredDownloadInformation.getShareable().getLocalPath(), (Object[])new Object[0]), (Throwable)deferredDownloadInformation.getFailure());
                }
                arrayList2.add((String)status);
                continue;
            }
            if (!deferredDownloadInformation.isLineDelimiterIgnored()) continue;
            throwable = deferredDownloadInformation.getFileAreaUpdate().getOptionalContent();
            status = new Status(2, "com.ibm.team.filesystem.client", NLS.bind((String)Messages.UpdateMutator_51, (Object)deferredDownloadInformation.getShareable().getLocalPath(), (Object[])new Object[]{throwable.getCharacterEncoding(), throwable.getLineDelimiter().toString()}));
            arrayList2.add((String)status);
        }
        return arrayList2.toArray(new IStatus[arrayList2.size()]);
    }

    protected void refresh(DeferredDownloadInformation deferredDownloadInformation, IProgressMonitor iProgressMonitor) throws FileSystemClientException, TeamRepositoryException {
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)((IProgressMonitor)new NonCancellingProgressMonitor(iProgressMonitor)), (int)100);
        Shareable shareable = deferredDownloadInformation.getShareable();
        IFileStorage iFileStorage = shareable.getFileStorage();
        if (iFileStorage != null) {
            try {
                SharingManager.getInstance().doSilentChange(new UpdateMutator$6(this, iFileStorage, subMonitor));
            }
            catch (CoreException coreException) {
                throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.UpdateMutator_44, (Throwable)coreException)));
            }
        }
    }

    protected void updateMetaData(DeferredDownloadInformation deferredDownloadInformation, boolean bl, IProgressMonitor iProgressMonitor) throws FileSystemClientException, TeamRepositoryException {
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)((IProgressMonitor)new NonCancellingProgressMonitor(iProgressMonitor)), (int)100);
        Shareable shareable = deferredDownloadInformation.getShareable();
        IFileStorage iFileStorage = shareable.getFileStorage();
        if (iFileStorage != null) {
            ISharingDescriptor iSharingDescriptor;
            boolean bl2;
            String string;
            IFolderHandle iFolderHandle;
            long l = iFileStorage.getModificationStamp();
            FileContent fileContent = (FileContent)deferredDownloadInformation.getContent();
            FileItemInfo fileItemInfo = deferredDownloadInformation.getCopyFileArea().getItemInfo(shareable.getLocalPath());
            if (fileItemInfo == null) {
                iFolderHandle = deferredDownloadInformation.getRemoteParent();
                string = deferredDownloadInformation.getRemoteName();
                bl2 = PathUtils.isLoadedWithAnotherName(shareable.getSandbox(), shareable.getLocalPath(), string);
            } else {
                iFolderHandle = fileItemInfo.getParent();
                string = fileItemInfo.getName();
                bl2 = fileItemInfo.isLoadedWithAnotherName();
            }
            FileItemInfoProxy fileItemInfoProxy = new FileItemInfoProxy(deferredDownloadInformation.getFileItemState(), iFolderHandle, string, bl2);
            fileItemInfoProxy.setContentInfo(l, deferredDownloadInformation.getHash(), deferredDownloadInformation.getContentSize(), fileContent);
            fileItemInfoProxy.setExecutable(deferredDownloadInformation.isExecutable(), deferredDownloadInformation.isExecutable());
            fileItemInfoProxy.setProperties(deferredDownloadInformation.getProperties());
            if (bl) {
                fileItemInfoProxy.setContentChanged(true, l);
            }
            if ((iSharingDescriptor = deferredDownloadInformation.getSharingDescriptor()) != null) {
                IShare iShare = SharingManager.getInstance().share(shareable, iSharingDescriptor, fileItemInfoProxy.getFileItemInfo(), 2, (IProgressMonitor)subMonitor);
                this.newShares.add(new UpdateMutator$ShareReference(iSharingDescriptor.getComponent(), iShare));
            } else {
                deferredDownloadInformation.getCopyFileArea().setItemMetaData(shareable.getLocalPath(), fileItemInfoProxy.getFileItemInfo(), (IProgressMonitor)subMonitor);
            }
            if (bl && !shareable.exists((IProgressMonitor)subMonitor.newChild(1))) {
                deferredDownloadInformation.getCopyFileArea().makePendingDeletion(deferredDownloadInformation.getShareable().getLocalPath(), (IProgressMonitor)subMonitor);
            }
        }
        subMonitor.done();
    }

    private IComponent getFullComponent(FileAreaUpdate fileAreaUpdate, IComponent iComponent, IProgressMonitor iProgressMonitor) throws TeamRepositoryException {
        IComponentHandle iComponentHandle = fileAreaUpdate.component();
        return this.getFullComponent(iComponentHandle, iComponent, iProgressMonitor);
    }

    private IComponent getFullComponent(IComponentHandle iComponentHandle, IComponent iComponent, IProgressMonitor iProgressMonitor) throws TeamRepositoryException {
        if (iComponentHandle instanceof IComponent) {
            return (IComponent)iComponentHandle;
        }
        if (!iComponentHandle.sameItemId((IItemHandle)iComponent)) {
            iComponent = (IComponent)this.repository.itemManager().fetchCompleteItem((IItemHandle)iComponentHandle, 0, iProgressMonitor);
        }
        return iComponent;
    }

    private void updateConfigStates(IProgressMonitor iProgressMonitor) throws TeamRepositoryException, FileSystemClientException {
        Object object;
        this.newShares.removeAll(this.inconsistentShares);
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)(this.newShares.size() + this.inconsistentShares.size() + this.componentStatesAfter.size()));
        for (UpdateMutator$ShareReference updateMutator$ShareReference : this.newShares) {
            object = (IComponentStateSummary)this.componentStatesAfter.get(updateMutator$ShareReference.component.getItemId());
            ICopyFileArea iCopyFileArea = ICopyFileAreaManager.instance.getExistingCopyFileArea(updateMutator$ShareReference.share.getSandbox().getRoot());
            iCopyFileArea.setConfigurationState(this.connectionHandle, updateMutator$ShareReference.component, updateMutator$ShareReference.share.getShareable().getLocalPath(), object.getConfigurationTime(), (IProgressMonitor)subMonitor.newChild(1));
        }
        for (UpdateMutator$ShareReference updateMutator$ShareReference : this.componentStatesAfter.values()) {
            object = (IComponentStateSummary)this.componentStatesBefore.get(updateMutator$ShareReference.getComponent().getItemId());
            if (object == null) continue;
            for (ICopyFileArea iCopyFileArea : this.copyFileAreasToUpdate) {
                iCopyFileArea.setConfigurationState(this.connectionHandle, updateMutator$ShareReference.getComponent(), object.getConfigurationTime(), updateMutator$ShareReference.getConfigurationTime(), (IProgressMonitor)subMonitor.newChild(1));
            }
        }
        for (UpdateMutator$ShareReference updateMutator$ShareReference : this.inconsistentShares) {
            object = ICopyFileAreaManager.instance.getExistingCopyFileArea(updateMutator$ShareReference.share.getSandbox().getRoot());
            object.setUnknownConfigurationState(this.connectionHandle, updateMutator$ShareReference.component, updateMutator$ShareReference.share.getShareable().getLocalPath(), (IProgressMonitor)subMonitor.newChild(1));
        }
    }

    protected ISyncTime getBeforeConfigState(IComponentHandle iComponentHandle) {
        return ((IComponentStateSummary)this.componentStatesBefore.get(iComponentHandle.getItemId())).getConfigurationTime();
    }

    protected void updateMetaDataAfterMove(ICopyFileArea iCopyFileArea, IComponent iComponent, IComponentHandle iComponentHandle, Shareable shareable, Shareable shareable2, boolean bl, boolean bl2, boolean bl3, IFolderHandle iFolderHandle, IVersionableHandle iVersionableHandle, String string, IProgressMonitor iProgressMonitor) throws FileSystemClientException, TeamRepositoryException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        FileItemInfo fileItemInfo = iCopyFileArea.getItemInfo(shareable.getLocalPath());
        if (bl) {
            if (!PathUtils.sameRelativePath(shareable.getLocalPath(), shareable.getSandbox().isCaseSensitive(), shareable2.getLocalPath(), shareable2.getSandbox().isCaseSensitive())) {
                iCopyFileArea.moveInfo(shareable.getLocalPath(), shareable2.getLocalPath(), false, (IProgressMonitor)subMonitor.newChild(74));
            }
            if (!iComponent.sameItemId((IItemHandle)iComponentHandle)) {
                Object object;
                SharingDescriptor sharingDescriptor = (SharingDescriptor)shareable2.getShare((IProgressMonitor)subMonitor.newChild(1)).getSharingDescriptor();
                ISyncTime iSyncTime = this.getBeforeConfigState(iComponentHandle);
                ISyncTime iSyncTime2 = this.getBeforeConfigState((IComponentHandle)iComponent);
                FileItemInfo fileItemInfo2 = null;
                if (bl2) {
                    object = iCopyFileArea.getItemInfo(iVersionableHandle, iComponentHandle, this.connectionHandle);
                    FileItemInfoProxy fileItemInfoProxy = new FileItemInfoProxy((FileItemInfo)object);
                    if (!bl3) {
                        fileItemInfoProxy.setItemState(iVersionableHandle);
                    }
                    fileItemInfoProxy.changeIdentity(iFolderHandle, string);
                    fileItemInfo2 = fileItemInfoProxy.getFileItemInfo();
                }
                if (!sharingDescriptor.getConfigurationState().equals(iSyncTime)) {
                    this.recordInconsistentShare((IComponentHandle)iComponent, shareable2.getShare((IProgressMonitor)subMonitor.newChild(1)));
                    object = new SharingDescriptor(sharingDescriptor.getRepositoryUri(), sharingDescriptor.getRepositoryId(), this.connection, (IComponentHandle)iComponent, iComponent.getName(), sharingDescriptor.getRootVersionable());
                    iCopyFileArea.share(shareable2.getLocalPath(), (ISharingDescriptor)object, fileItemInfo2, 2, (IProgressMonitor)subMonitor.newChild(24));
                } else if (iSyncTime2 == null) {
                    this.newShares.add(new UpdateMutator$ShareReference((IComponentHandle)iComponent, shareable2.getShare((IProgressMonitor)subMonitor.newChild(1))));
                    object = new SharingDescriptor(sharingDescriptor.getRepositoryUri(), sharingDescriptor.getRepositoryId(), this.connection, (IComponentHandle)iComponent, iComponent.getName(), sharingDescriptor.getRootVersionable());
                    iCopyFileArea.share(shareable2.getLocalPath(), (ISharingDescriptor)object, fileItemInfo2, 2, (IProgressMonitor)subMonitor.newChild(24));
                } else {
                    object = new SharingDescriptor(sharingDescriptor.getRepositoryUri(), sharingDescriptor.getRepositoryId(), this.connection, (IComponentHandle)iComponent, iComponent.getName(), sharingDescriptor.getRootVersionable(), iSyncTime2);
                    iCopyFileArea.share(shareable2.getLocalPath(), (ISharingDescriptor)object, fileItemInfo2, 2, (IProgressMonitor)subMonitor.newChild(25));
                }
            } else if (bl2) {
                InverseFileItemInfo inverseFileItemInfo = iCopyFileArea.getItemInfo(iVersionableHandle, (IComponentHandle)iComponent, this.connectionHandle);
                FileItemInfoProxy fileItemInfoProxy = new FileItemInfoProxy(inverseFileItemInfo);
                if (!bl3) {
                    fileItemInfoProxy.setItemState(iVersionableHandle);
                }
                fileItemInfoProxy.changeIdentity(iFolderHandle, string);
                iCopyFileArea.setItemMetaData(shareable2.getLocalPath(), fileItemInfoProxy.getFileItemInfo(), null);
            }
        } else if (fileItemInfo != null) {
            Object object;
            iCopyFileArea.moveInfo(shareable.getLocalPath(), shareable2.getLocalPath(), bl2, (IProgressMonitor)subMonitor.newChild(90));
            if (bl2 && !bl3 && (iVersionableHandle instanceof IFileItemHandle || iVersionableHandle instanceof ISymbolicLinkHandle)) {
                object = iCopyFileArea.getItemInfo(iVersionableHandle, (IComponentHandle)iComponent, this.connectionHandle);
                FileItemInfoProxy fileItemInfoProxy = new FileItemInfoProxy((FileItemInfo)object);
                fileItemInfoProxy.setItemState(iVersionableHandle);
                iCopyFileArea.setItemMetaData(shareable2.getLocalPath(), fileItemInfoProxy.getFileItemInfo(), null);
            }
            if (!((SharingDescriptor)(object = (SharingDescriptor)shareable.getShare((IProgressMonitor)subMonitor.newChild(1)).getSharingDescriptor())).getConfigurationState().equals(this.getBeforeConfigState(((SharingDescriptor)object).getComponent()))) {
                this.recordInconsistentShare((IComponentHandle)iComponent, shareable2.getShare((IProgressMonitor)subMonitor.newChild(1)));
            }
        }
    }

    public final void setSkipStoreContent(Map map) {
        this.toSkip = map;
    }

    protected final void addUpdateToSkip(IPath iPath, IComponentHandle iComponentHandle, IVersionableHandle iVersionableHandle) {
        ConfigurationDescriptor configurationDescriptor;
        HashSet<UUID> hashSet;
        HashMap<ConfigurationDescriptor, HashSet<UUID>> hashMap = (HashMap<ConfigurationDescriptor, HashSet<UUID>>)this.toSkip.get(iPath);
        if (hashMap == null) {
            hashMap = new HashMap<ConfigurationDescriptor, HashSet<UUID>>();
            this.toSkip.put(iPath, hashMap);
        }
        if ((hashSet = (HashSet<UUID>)hashMap.get(configurationDescriptor = new ConfigurationDescriptor(this.connection, iComponentHandle))) == null) {
            hashSet = new HashSet<UUID>();
            hashMap.put(configurationDescriptor, hashSet);
        }
        hashSet.add(iVersionableHandle.getItemId());
    }

    protected final boolean isSkipping() {
        return this.toSkip.size() > 0;
    }

    protected final boolean skipUpdate(IPath iPath, IComponentHandle iComponentHandle, IVersionableHandle iVersionableHandle) {
        if (iVersionableHandle == null) {
            return false;
        }
        Map map = (Map)this.toSkip.get(iPath);
        if (map == null) {
            return false;
        }
        ConfigurationDescriptor configurationDescriptor = new ConfigurationDescriptor(this.connection, iComponentHandle);
        Set set = (Set)map.get(configurationDescriptor);
        if (set == null) {
            return false;
        }
        return set.contains(iVersionableHandle.getItemId());
    }

    private void failedUpdate(ICopyFileArea iCopyFileArea, FileAreaUpdate fileAreaUpdate) {
        this.failedUpdate(iCopyFileArea, fileAreaUpdate, fileAreaUpdate.component());
    }

    protected final void failedUpdate(ICopyFileArea iCopyFileArea, FileAreaUpdate fileAreaUpdate, IComponentHandle iComponentHandle) {
        ArrayList<FileAreaUpdate> arrayList;
        HashMap<UUID, ArrayList<FileAreaUpdate>> hashMap = (HashMap<UUID, ArrayList<FileAreaUpdate>>)this.failedUpdates.get(iCopyFileArea);
        if (hashMap == null) {
            hashMap = new HashMap<UUID, ArrayList<FileAreaUpdate>>();
            this.failedUpdates.put(iCopyFileArea, hashMap);
        }
        if ((arrayList = (ArrayList<FileAreaUpdate>)hashMap.get(iComponentHandle.getItemId())) == null) {
            arrayList = new ArrayList<FileAreaUpdate>();
            hashMap.put(iComponentHandle.getItemId(), arrayList);
        }
        arrayList.add(fileAreaUpdate);
    }

    protected void reportErrorsAsException(IStatus[] iStatusArray) throws FileSystemClientException {
        if (iStatusArray.length == 0) {
            return;
        }
        if (this.inconsistentShares.size() > 0) {
            MultiStatus multiStatus = new MultiStatus("com.ibm.team.filesystem.client", 0, iStatusArray, NLS.bind((String)Messages.UpdateMutator_24, (Object)iStatusArray.length, (Object[])new Object[0]), null);
            throw (Throwable)((Object)new FileSystemClientException((IStatus)multiStatus));
        }
        super.reportErrorsAsException(iStatusArray);
    }

    protected void folderCreated(Shareable shareable, boolean bl, IProgressMonitor iProgressMonitor) throws TeamRepositoryException {
    }

    protected void fileLoaded(Shareable shareable, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
    }

    protected void updatesComplete(IProgressMonitor iProgressMonitor) throws FileSystemClientException {
    }

    static /* synthetic */ void access$0(InputStream inputStream) throws IOException {
        UpdateMutator.read(inputStream);
    }

    static /* synthetic */ Shed access$1(UpdateMutator updateMutator) {
        return updateMutator.shed;
    }
}

