/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.load;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.ILocalChangeManager$RefreshType;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeManager;
import com.ibm.team.filesystem.client.operations.IRemovedShare;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

public class RemovedShare
implements IRemovedShare {
    private final int uncommittedChangeCount;
    private final IShare share;
    private boolean toDelete;

    public RemovedShare(IShare iShare, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        this.share = iShare;
        LocalChangeManager localChangeManager = LocalChangeManager.getInstance();
        LocalChangeManager.getInstance().refreshChanges(new IShare[]{iShare}, ILocalChangeManager$RefreshType.TRAVERSE_ALL_KNOWN, iProgressMonitor);
        this.uncommittedChangeCount = localChangeManager.getPendingChanges(new IShare[]{iShare}).length;
        this.toDelete = false;
    }

    public boolean isToBeDeleted() {
        return this.toDelete;
    }

    public void isToBeDeleted(boolean bl) {
        this.toDelete = bl;
    }

    public int getUncommittedChangeCount() {
        return this.uncommittedChangeCount;
    }

    public IPath getLocalPath() {
        return this.share.getPath();
    }

    public IPath getFullPath() {
        return this.share.getSandbox().getRoot().append(this.share.getPath());
    }

    public int hashCode() {
        int n = 1;
        n *= 31;
        n = 31 * n + (this.share != null && this.share.getSandbox() != null ? 0 : this.share.getSandbox().hashCode());
        n = 31 * n + (this.share != null && this.share.getPath() != null ? 0 : this.share.getPath().hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        RemovedShare removedShare = (RemovedShare)object;
        if (this.share == null ? removedShare.share != null : removedShare.share == null) {
            return false;
        }
        if (this.share.getSandbox() == null ? removedShare.share.getSandbox() != null : !this.share.getSandbox().equals(removedShare.share.getSandbox())) {
            return false;
        }
        return !(this.share.getPath() == null ? removedShare.share.getPath() != null : !this.share.getPath().equals((Object)removedShare.share.getPath()));
    }

    public IShare getShare() {
        return this.share;
    }
}

