/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.load;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.IFileContentManagerSession;
import com.ibm.team.filesystem.client.ILocalChangeManager$RefreshType;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.FileItemInfo;
import com.ibm.team.filesystem.client.internal.FileItemInfoProxy;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.InverseFileItemInfo;
import com.ibm.team.filesystem.client.internal.ManagedFileStore;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingDescriptor;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.Shed;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileArea;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.load.DeferredInformation;
import com.ibm.team.filesystem.client.internal.load.DeferredUpdateInformation;
import com.ibm.team.filesystem.client.internal.load.MergeLoadMutator$1;
import com.ibm.team.filesystem.client.internal.load.MergeLoadMutator$2;
import com.ibm.team.filesystem.client.internal.load.MergeLoadMutator$3;
import com.ibm.team.filesystem.client.internal.load.MergeLoadMutator$4;
import com.ibm.team.filesystem.client.internal.load.MergeLoadMutator$5;
import com.ibm.team.filesystem.client.internal.load.MergeLoadMutator$6;
import com.ibm.team.filesystem.client.internal.load.MergeLoadMutator$DownloadHandler;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeManager;
import com.ibm.team.filesystem.client.internal.operations.EncodingDownloadFailure;
import com.ibm.team.filesystem.client.internal.operations.FileSystemOperation;
import com.ibm.team.filesystem.client.internal.utils.CancellationMonitor;
import com.ibm.team.filesystem.client.internal.utils.NonCancellingProgressMonitor;
import com.ibm.team.filesystem.client.internal.utils.PathUtils;
import com.ibm.team.filesystem.client.internal.utils.RepositoryUtils;
import com.ibm.team.filesystem.client.operations.IDownloadListener;
import com.ibm.team.filesystem.client.operations.ILoadLocation;
import com.ibm.team.filesystem.client.operations.LoadDilemmaHandler;
import com.ibm.team.filesystem.common.IFileContent;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.common.ISymbolicLinkHandle;
import com.ibm.team.filesystem.common.internal.FileContent;
import com.ibm.team.filesystem.common.internal.dto.FileAreaUpdate;
import com.ibm.team.filesystem.common.internal.dto.LoadTree;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.internal.ContentManager;
import com.ibm.team.repository.client.util.ThreadCheck;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.ISyncTime;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.SocketException;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;

public class MergeLoadMutator
extends FileSystemOperation {
    final IDownloadListener downloadMonitor;
    protected IFileContentManagerSession contentSession = null;
    private final IConnection connection;
    private IComponent component;
    private final IContextHandle connectionHandle;
    private final ISandbox sandbox;
    private final LoadTree loadTree;
    private final ITeamRepository repo;
    private Map loadLocations;
    private LoadDilemmaHandler problemHandler;
    private Shed shed;

    public MergeLoadMutator(IConnection iConnection, IComponent iComponent, ISandbox iSandbox, List list, LoadTree loadTree, LoadDilemmaHandler loadDilemmaHandler, IDownloadListener iDownloadListener) {
        super(loadDilemmaHandler == null ? LoadDilemmaHandler.getDefault() : loadDilemmaHandler);
        LoadDilemmaHandler loadDilemmaHandler2 = this.problemHandler = loadDilemmaHandler == null ? LoadDilemmaHandler.getDefault() : loadDilemmaHandler;
        if (iConnection == null) {
            throw (Throwable)new IllegalArgumentException("Invalid connection");
        }
        if (iComponent == null) {
            throw (Throwable)new IllegalArgumentException("Invalid component");
        }
        if (list == null) {
            throw (Throwable)new IllegalArgumentException("Invalid items to load");
        }
        if (loadTree == null) {
            throw (Throwable)new IllegalArgumentException("Invalid load tree");
        }
        this.connection = iConnection;
        this.component = iComponent;
        this.repo = iConnection.teamRepository();
        this.sandbox = iSandbox;
        this.loadTree = loadTree;
        this.loadLocations = new HashMap();
        this.downloadMonitor = iDownloadListener;
        for (ILoadLocation iLoadLocation : list) {
            if (!iComponent.sameItemId((IItemHandle)iLoadLocation.getComponent())) {
                throw (Throwable)new IllegalArgumentException("Items to be loaded not for component " + iComponent.getName());
            }
            if (!iSandbox.equals(iLoadLocation.getSandbox())) {
                throw (Throwable)new IllegalArgumentException("Items to be loaded must be for the same sandbox " + iSandbox.getRoot().toString() + " and " + iLoadLocation.getSandbox().toString());
            }
            this.loadLocations.put(iLoadLocation.getRootToLoad().getItemId(), iLoadLocation);
        }
        this.connectionHandle = iConnection instanceof IWorkspaceConnection ? (IContextHandle)((IWorkspaceConnection)iConnection).getResolvedWorkspace().getItemHandle() : (IContextHandle)((IBaselineConnection)iConnection).getBaseline();
        this.shed = new Shed(this.problemHandler.getBackupDilemmaHandler());
    }

    protected void beginning() throws TeamRepositoryException, FileSystemClientException {
    }

    /*
     * WARNING - void declaration
     */
    protected final void execute(IProgressMonitor iProgressMonitor) throws TeamRepositoryException, FileSystemClientException {
        IStatus[] iStatusArray;
        FileAreaUpdate fileAreaUpdate2;
        ThreadCheck.checkLongOpsAllowed();
        List list = this.loadTree.getFileAreaUpdates();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)210);
        this.contentSession = FileSystemCore.getContentManager(this.repo).createSession("", true, list.size(), (IProgressMonitor)subMonitor.newChild(155));
        HashMap<UUID, IPath> hashMap = new HashMap<UUID, IPath>();
        HashMap hashMap2 = new HashMap();
        DeferredUpdateInformation[] deferredUpdateInformationArray = new DeferredUpdateInformation[list.size()];
        HashSet<Shareable> hashSet = new HashSet<Shareable>();
        HashSet hashSet2 = new HashSet();
        ArrayList<Shareable> arrayList = new ArrayList<Shareable>();
        HashSet<IShareable> hashSet3 = new HashSet<IShareable>();
        HashSet hashSet4 = new HashSet();
        LocalChangeManager localChangeManager = LocalChangeManager.getInstance();
        ICopyFileArea iCopyFileArea = ICopyFileAreaManager.instance.getCopyFileAreaForPath(this.sandbox.getRoot());
        CancellationMonitor cancellationMonitor = new CancellationMonitor((IProgressMonitor)subMonitor);
        try {
            int n = -1;
            HashSet<Shareable> hashSet5 = new HashSet<Shareable>();
            for (FileAreaUpdate fileAreaUpdate2 : list) {
                Object object;
                Object object2;
                boolean bl;
                boolean bl2;
                IShare iShare;
                Object object3;
                Shareable shareable;
                IPath iPath;
                Shareable shareable2;
                Shareable shareable3;
                this.checkCancelled(iProgressMonitor);
                ++n;
                IComponentHandle n2 = fileAreaUpdate2.getComponent();
                if (!n2.sameItemId((IItemHandle)this.component)) {
                    this.collectStatus(new FileSystemStatus(4, NLS.bind((String)Messages.MergeLoadMutator_13, (Object)this.component.getName(), (Object[])new Object[0])));
                    break;
                }
                if (fileAreaUpdate2.getChangeType() != 1) {
                    throw (Throwable)new IllegalStateException("Mutator is intended to only load new files/folders");
                }
                iStatusArray = fileAreaUpdate2.afterState();
                ResourceType resourceType = ResourceType.getResourceType((IVersionableHandle)iStatusArray);
                boolean bl3 = false;
                ILoadLocation iLoadLocation = (ILoadLocation)this.loadLocations.get(fileAreaUpdate2.getItem().getItemId());
                if (iLoadLocation != null) {
                    shareable3 = this.getExistingShareable(iCopyFileArea, fileAreaUpdate2.getItem(), (IProgressMonitor)cancellationMonitor);
                    shareable2 = fileAreaUpdate2.getDestinationParent() == null ? null : this.getExistingShareable(iCopyFileArea, (IVersionableHandle)fileAreaUpdate2.getDestinationParent(), (IProgressMonitor)cancellationMonitor);
                    if (shareable2 == null) {
                        bl3 = true;
                        iPath = iLoadLocation.getLoadPath();
                        shareable = new Shareable(this.sandbox, iPath, resourceType);
                        object3 = (Shareable)shareable.getParent();
                        if (object3 != null && !((Shareable)object3).exists((IProgressMonitor)subMonitor.newChild(1))) {
                            SharingManager.getInstance().disableChangeMonitoring();
                            try {
                                ((Shareable)object3).getFileStorage().create(true, (IProgressMonitor)cancellationMonitor);
                            }
                            finally {
                                SharingManager.getInstance().enableChangeMonitoring();
                            }
                        }
                    } else {
                        iPath = shareable2.getLocalPath().append(fileAreaUpdate2.getName());
                        shareable = new Shareable(this.sandbox, iPath, resourceType);
                    }
                    object3 = new ArrayList(2);
                    if (shareable.exists((IProgressMonitor)cancellationMonitor) && (iShare = shareable.getShare((IProgressMonitor)cancellationMonitor)) != null && !hashSet4.contains(iShare.getShareable())) {
                        ((ArrayList)object3).add(iShare);
                    }
                    if (shareable3 != null && (iShare = shareable3.getShare((IProgressMonitor)cancellationMonitor)) != null && !hashSet4.contains(iShare.getShareable())) {
                        ((ArrayList)object3).add(iShare);
                    }
                    if (!((ArrayList)object3).isEmpty()) {
                        localChangeManager.refreshChanges(((ArrayList)object3).toArray(new IShare[((ArrayList)object3).size()]), ILocalChangeManager$RefreshType.TRAVERSE_ALL_KNOWN, (IProgressMonitor)cancellationMonitor);
                    }
                } else {
                    shareable3 = this.getExistingShareable(iCopyFileArea, fileAreaUpdate2.getItem(), (IProgressMonitor)cancellationMonitor);
                    shareable2 = this.getExistingShareable(iCopyFileArea, (IVersionableHandle)fileAreaUpdate2.getDestinationParent(), (IProgressMonitor)cancellationMonitor);
                    if (shareable2 == null) {
                        this.collectStatus(FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.MergeLoadMutator_19, (Object)fileAreaUpdate2.getName(), (Object[])new Object[0]), null));
                        if (shareable3 == null) continue;
                        MergeLoadMutator.deleteSubtree(shareable3, resourceType, this.shed, (IProgressMonitor)cancellationMonitor);
                        shareable3.forget((IProgressMonitor)cancellationMonitor);
                        continue;
                    }
                    iPath = shareable2.getLocalPath().append(fileAreaUpdate2.getName());
                    shareable = new Shareable(this.sandbox, iPath, resourceType);
                    object3 = (HashMap)hashMap2.get(fileAreaUpdate2.getDestinationParent().getItemId());
                    if (object3 != null) {
                        ((HashMap)object3).put(fileAreaUpdate2.getName(), fileAreaUpdate2.getItem().getItemId());
                    }
                }
                if (bl3) {
                    arrayList.add(shareable);
                }
                if (shareable3 != null) {
                    if (bl3 != shareable3.isShare((IProgressMonitor)cancellationMonitor)) {
                        MergeLoadMutator.deleteSubtree(shareable3, resourceType, this.shed, (IProgressMonitor)cancellationMonitor);
                        shareable3.forget((IProgressMonitor)cancellationMonitor);
                    } else {
                        object3 = shareable3.getParent();
                        if (object3 == null && shareable2 != null || object3 != null && fileAreaUpdate2.parent() == null && object3.getRemote((IProgressMonitor)cancellationMonitor) != null || object3 != null && fileAreaUpdate2.parent() != null && !fileAreaUpdate2.parent().sameItemId((IItemHandle)object3.getRemote((IProgressMonitor)cancellationMonitor)) || !shareable.getLocalPath().lastSegment().equals(shareable3.getLocalPath().lastSegment())) {
                            MergeLoadMutator.deleteSubtree(shareable3, resourceType, this.shed, (IProgressMonitor)cancellationMonitor);
                            shareable3.forget((IProgressMonitor)cancellationMonitor);
                        }
                    }
                } else {
                    SharingManager.getInstance().forget(this.sandbox.getRoot(), this.connectionHandle, (IComponentHandle)this.component, fileAreaUpdate2.getItem(), (IProgressMonitor)cancellationMonitor);
                }
                if (!this.sandbox.isCaseSensitive()) {
                    if (hashSet5.contains(shareable)) {
                        object3 = shareable.getShare((IProgressMonitor)cancellationMonitor);
                        if (object3 == null) {
                            hashSet3.add(shareable);
                        } else {
                            hashSet3.add(object3.getShareable());
                        }
                        this.collectStatus(FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.MergeLoadMutator_20, (Object)iPath, (Object[])new Object[0]), null));
                        continue;
                    }
                    hashSet5.add(shareable);
                }
                if ((object3 = shareable.getResourceType((IProgressMonitor)cancellationMonitor)) == null) {
                    if (resourceType == ResourceType.FOLDER) {
                        this.createNewFolder(iCopyFileArea, bl3, shareable, fileAreaUpdate2, (IProgressMonitor)cancellationMonitor);
                        if (fileAreaUpdate2.getDestinationParent() != null && hashMap2.containsKey(fileAreaUpdate2.getDestinationParent().getItemId())) {
                            hashMap2.put(iStatusArray.getItemId(), new HashMap());
                        }
                        this.contentSession.decrementTransferCount(1L);
                        continue;
                    }
                    if (resourceType == ResourceType.FILE) {
                        deferredUpdateInformationArray[n] = new DeferredUpdateInformation(this.sandbox, iPath, fileAreaUpdate2, bl3);
                        this.createNewFile(deferredUpdateInformationArray[n], (IProgressMonitor)cancellationMonitor);
                        continue;
                    }
                    if (resourceType != ResourceType.SYMBOLIC_LINK) continue;
                    this.createNewLink(iCopyFileArea, bl3, shareable, fileAreaUpdate2, hashSet, hashSet2, (IProgressMonitor)cancellationMonitor);
                    this.contentSession.decrementTransferCount(1L);
                    continue;
                }
                iShare = shareable.getRemote((IProgressMonitor)cancellationMonitor);
                boolean bl4 = bl2 = object3 == resourceType;
                if (!(bl2 && (iShare == null || iStatusArray.sameItemId((IItemHandle)iShare)) && (this.sandbox.isCaseSensitive() || shareable.getFileStorage().storageExists((IProgressMonitor)cancellationMonitor) && fileAreaUpdate2.getName().equals(shareable.getFileStorage().getActualName())))) {
                    MergeLoadMutator.deleteSubtree(shareable, (ResourceType)((Object)object3), this.shed, (IProgressMonitor)cancellationMonitor);
                    shareable.forget((IProgressMonitor)cancellationMonitor);
                    if (!this.sandbox.isCaseSensitive() && !fileAreaUpdate2.getName().equals(shareable.getFileStorage().getActualName())) {
                        shareable = new Shareable(shareable.getSandbox(), iPath, resourceType);
                    }
                    if (resourceType == ResourceType.FOLDER) {
                        this.createNewFolder(iCopyFileArea, bl3, shareable, fileAreaUpdate2, (IProgressMonitor)cancellationMonitor);
                        if (fileAreaUpdate2.getDestinationParent() != null && hashMap2.containsKey(fileAreaUpdate2.getDestinationParent().getItemId())) {
                            hashMap2.put(iStatusArray.getItemId(), new HashMap());
                        }
                        this.contentSession.decrementTransferCount(1L);
                        continue;
                    }
                    if (resourceType == ResourceType.FILE) {
                        deferredUpdateInformationArray[n] = new DeferredUpdateInformation(this.sandbox, iPath, fileAreaUpdate2, bl3);
                        this.createNewFile(deferredUpdateInformationArray[n], (IProgressMonitor)cancellationMonitor);
                        continue;
                    }
                    if (resourceType != ResourceType.SYMBOLIC_LINK) continue;
                    this.createNewLink(iCopyFileArea, bl3, shareable, fileAreaUpdate2, hashSet, hashSet2, (IProgressMonitor)cancellationMonitor);
                    this.contentSession.decrementTransferCount(1L);
                    continue;
                }
                boolean bl5 = bl = !iStatusArray.sameStateId((IItemHandle)iShare);
                if (resourceType == ResourceType.FILE) {
                    bl |= localChangeManager.isContentDirty(shareable, (IProgressMonitor)cancellationMonitor);
                    object2 = localChangeManager.getPendingChange(shareable, (IProgressMonitor)cancellationMonitor);
                    bl |= object2 != null && object2.getType() != 0;
                } else if (resourceType == ResourceType.FOLDER) {
                    hashMap.put(iStatusArray.getItemId(), iPath);
                    hashMap2.put(iStatusArray.getItemId(), new HashMap());
                } else if (resourceType == ResourceType.SYMBOLIC_LINK) {
                    object2 = fileAreaUpdate2.getLinkTarget();
                    boolean bl6 = bl = !((String)object2).equals(object = shareable.getFileStorage().getTarget((IProgressMonitor)cancellationMonitor));
                }
                if (bl) {
                    if (bl3) {
                        object2 = new SharingDescriptor(this.repo.getRepositoryURI(), this.repo.getId(), this.connection, n2, this.component.getName(), (IVersionableHandle)iStatusArray);
                        if (resourceType == ResourceType.FOLDER) {
                            object = new FileItemInfoProxy((IVersionableHandle)iStatusArray, fileAreaUpdate2.getDestinationParent(), fileAreaUpdate2.getName(), PathUtils.isLoadedWithAnotherName(this.sandbox, iPath, fileAreaUpdate2.getName())).getFileItemInfo();
                            SharingManager.getInstance().share(shareable, (ISharingDescriptor)object2, (FileItemInfo)object, 2, (IProgressMonitor)cancellationMonitor);
                            this.contentSession.decrementTransferCount(1L);
                            continue;
                        }
                        if (resourceType == ResourceType.FILE) {
                            object = iCopyFileArea.getItemInfo(iPath);
                            SharingManager.getInstance().share(shareable, (ISharingDescriptor)object2, (FileItemInfo)object, 2, (IProgressMonitor)cancellationMonitor);
                            deferredUpdateInformationArray[n] = new DeferredUpdateInformation(this.sandbox, iPath, fileAreaUpdate2, false, this.loadLocations.containsKey(fileAreaUpdate2.getItem().getItemId()));
                            this.modifyFile(shareable, deferredUpdateInformationArray[n], (IProgressMonitor)cancellationMonitor);
                            continue;
                        }
                        if (resourceType != ResourceType.SYMBOLIC_LINK) continue;
                        this.modifyLink(iCopyFileArea, bl3, (IVersionableHandle)iStatusArray, fileAreaUpdate2, shareable, this.loadLocations.containsKey(fileAreaUpdate2.getItem().getItemId()), hashSet, hashSet2, (IProgressMonitor)cancellationMonitor);
                        continue;
                    }
                    if (resourceType == ResourceType.FOLDER) {
                        object2 = new FileItemInfoProxy((IVersionableHandle)iStatusArray, fileAreaUpdate2.getDestinationParent(), fileAreaUpdate2.getName()).getFileItemInfo();
                        iCopyFileArea.setItemMetaData(shareable.getLocalPath(), (FileItemInfo)object2, (IProgressMonitor)cancellationMonitor);
                        this.contentSession.decrementTransferCount(1L);
                        continue;
                    }
                    if (resourceType == ResourceType.FILE) {
                        deferredUpdateInformationArray[n] = new DeferredUpdateInformation(this.sandbox, iPath, fileAreaUpdate2, bl3, this.loadLocations.containsKey(fileAreaUpdate2.getItem().getItemId()));
                        this.modifyFile(shareable, deferredUpdateInformationArray[n], (IProgressMonitor)cancellationMonitor);
                        continue;
                    }
                    if (resourceType != ResourceType.SYMBOLIC_LINK) continue;
                    this.modifyLink(iCopyFileArea, bl3, (IVersionableHandle)iStatusArray, fileAreaUpdate2, shareable, this.loadLocations.containsKey(fileAreaUpdate2.getItem().getItemId()), hashSet, hashSet2, (IProgressMonitor)cancellationMonitor);
                    hashSet.add(shareable);
                    continue;
                }
                if (bl3) {
                    object2 = iCopyFileArea.getItemInfo(iPath);
                    if (!$assertionsDisabled && object2 == null) {
                        throw (Throwable)((Object)new AssertionError());
                    }
                    object = new SharingDescriptor(this.repo.getRepositoryURI(), this.repo.getId(), this.connection, n2, this.component.getName(), (IVersionableHandle)iStatusArray);
                    SharingManager.getInstance().share(shareable, (ISharingDescriptor)object, (FileItemInfo)object2, 2, (IProgressMonitor)cancellationMonitor);
                    this.contentSession.decrementTransferCount(1L);
                    continue;
                }
                this.contentSession.decrementTransferCount(1L);
            }
        }
        finally {
            this.contentSession.join();
            try {
                if (!subMonitor.isCanceled()) {
                    this.doDilemmaHandling(deferredUpdateInformationArray, (IProgressMonitor)subMonitor.newChild(10));
                }
            }
            finally {
                if (subMonitor.isCanceled()) {
                    subMonitor.subTask(Messages.MergeLoadMutator_11);
                } else if (this.component != null) {
                    subMonitor.subTask(NLS.bind((String)Messages.MergeLoadMutator_12, (Object)this.component.getName(), (Object[])new Object[0]));
                } else {
                    subMonitor.subTask(Messages.MergeLoadMutator_10);
                }
                this.updateContentLoadedMetaData(iCopyFileArea, deferredUpdateInformationArray, list, (IProgressMonitor)new NonCancellingProgressMonitor((IProgressMonitor)subMonitor.newChild(25)));
                this.refreshLinks(hashSet, hashSet2, (IProgressMonitor)new NonCancellingProgressMonitor((IProgressMonitor)subMonitor.newChild(5)));
            }
        }
        IStatus[] iStatusArray2 = this.getDownloadFailures(deferredUpdateInformationArray);
        if (iStatusArray2.length > 0) {
            void iShareable;
            boolean bl = false;
            iStatusArray = iStatusArray2;
            int n = iStatusArray2.length;
            boolean n2 = false;
            while (iShareable < n) {
                fileAreaUpdate2 = iStatusArray[iShareable];
                if (fileAreaUpdate2.getSeverity() == 4 || fileAreaUpdate2.getSeverity() == 8) {
                    bl = true;
                }
                this.collectStatus((IStatus)fileAreaUpdate2);
                ++iShareable;
            }
            if (bl) {
                iStatusArray2 = this.getErrors();
                RepositoryUtils.throwAppropriateException(Messages.MergeLoadMutator_4, iStatusArray2);
            }
        } else if (this.contentSession.isCanceled()) {
            throw (Throwable)new OperationCanceledException();
        }
        this.removeExtraneousContent(iCopyFileArea, arrayList, hashMap, hashMap2, (IProgressMonitor)subMonitor.newChild(5));
        this.removeExtraneousMetadata(iCopyFileArea, hashMap2, (IProgressMonitor)subMonitor.newChild(5));
        SubMonitor subMonitor2 = subMonitor.newChild(5);
        subMonitor2.setWorkRemaining(arrayList.size());
        fileAreaUpdate2 = ISyncTime.FACTORY.createFrom(this.loadTree.getConfigurationState());
        for (IShareable iShareable : arrayList) {
            if (hashSet3.contains(iShareable)) continue;
            iCopyFileArea.setConfigurationState(this.connectionHandle, (IComponentHandle)this.component, iShareable.getLocalPath(), (ISyncTime)fileAreaUpdate2, (IProgressMonitor)subMonitor2.newChild(1));
        }
        subMonitor.done();
    }

    private void removeExtraneousMetadata(ICopyFileArea iCopyFileArea, HashMap hashMap, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)hashMap.size());
        for (Map.Entry entry : hashMap.entrySet()) {
            SubMonitor subMonitor2 = subMonitor.newChild(1);
            IFolderHandle iFolderHandle = (IFolderHandle)IFolder.ITEM_TYPE.createItemHandle((Object)this.repo, (UUID)entry.getKey(), null);
            HashMap hashMap2 = (HashMap)entry.getValue();
            InverseFileItemInfo inverseFileItemInfo = iCopyFileArea.getItemInfo((IVersionableHandle)iFolderHandle, (IComponentHandle)this.component, this.connectionHandle);
            if (inverseFileItemInfo != null) {
                HashMap hashMap3 = new HashMap(inverseFileItemInfo.getRemoteChildren());
                subMonitor2.setWorkRemaining(hashMap3.size());
                for (Map.Entry entry2 : hashMap3.entrySet()) {
                    UUID uUID = (UUID)hashMap2.get(entry2.getKey());
                    if (uUID != null && ((IVersionableHandle)entry2.getValue()).getItemId().equals((Object)uUID)) continue;
                    iCopyFileArea.forget(this.connectionHandle, (IComponentHandle)this.component, (IVersionableHandle)entry2.getValue(), (IProgressMonitor)subMonitor2.newChild(1));
                }
            }
            subMonitor2.done();
        }
    }

    private void removeExtraneousContent(ICopyFileArea iCopyFileArea, ArrayList arrayList, HashMap hashMap, HashMap hashMap2, IProgressMonitor iProgressMonitor) throws FileSystemClientException, TeamRepositoryException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)hashMap.size());
        for (Map.Entry entry : hashMap.entrySet()) {
            IPath iPath = (IPath)entry.getValue();
            HashMap hashMap3 = (HashMap)hashMap2.get(entry.getKey());
            if (hashMap3 == null) {
                hashMap3 = new HashMap();
            }
            ArrayList<Shareable> arrayList2 = Collections.EMPTY_LIST;
            File file = this.sandbox.getRoot().append(iPath).toFile();
            File[] fileArray = file.listFiles();
            if (fileArray != null) {
                arrayList2 = new ArrayList<Shareable>(fileArray.length);
                int n = 0;
                while (n < fileArray.length) {
                    arrayList2.add(SharingManager.getInstance().findShareable(this.sandbox, iPath.append(fileArray[n].getName()), fileArray[n].isDirectory() ? ResourceType.FOLDER : ResourceType.FILE));
                    ++n;
                }
            }
            SubMonitor subMonitor2 = subMonitor.newChild(1);
            subMonitor2.setWorkRemaining(arrayList2.size());
            for (IShareable iShareable : arrayList2) {
                SubMonitor subMonitor3 = subMonitor2.newChild(1);
                subMonitor3.setWorkRemaining(100);
                if (hashMap3.containsKey(iShareable.getLocalPath().lastSegment())) continue;
                iCopyFileArea.forget(iShareable.getLocalPath(), (IProgressMonitor)subMonitor3.newChild(40));
                if (iShareable.shouldBeIgnored((IProgressMonitor)subMonitor3.newChild(10))) continue;
                if (!this.isSpecialCase(iShareable, (IProgressMonitor)subMonitor3.newChild(1))) {
                    MergeLoadMutator.deleteSubtree((Shareable)iShareable, iShareable.getResourceType((IProgressMonitor)subMonitor3.newChild(1)), this.shed, (IProgressMonitor)subMonitor3.newChild(48));
                    continue;
                }
                LocalChangeManager.getInstance().computeChanges(iShareable, (IProgressMonitor)subMonitor3.newChild(49));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void doDilemmaHandling(DeferredUpdateInformation[] deferredUpdateInformationArray, IProgressMonitor iProgressMonitor) throws FileSystemClientException, TeamRepositoryException {
        Throwable throwable;
        void var6_11;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor);
        subMonitor.setWorkRemaining(100);
        ArrayList<EncodingDownloadFailure> arrayList = new ArrayList<EncodingDownloadFailure>();
        Object object = deferredUpdateInformationArray;
        int n = deferredUpdateInformationArray.length;
        boolean bl = false;
        while (var6_11 < n) {
            DeferredUpdateInformation deferredUpdateInformation = object[var6_11];
            if (deferredUpdateInformation != null && deferredUpdateInformation.getFailure() != null) {
                throwable = deferredUpdateInformation.getFailure().getCause();
                int n2 = 0;
                while (throwable instanceof TeamRepositoryException && n2 < 50) {
                    Throwable throwable2 = ((TeamRepositoryException)throwable).getCause();
                    if (throwable2 == null) break;
                    throwable = throwable2;
                    ++n2;
                }
                if (throwable instanceof UnsupportedEncodingException || throwable instanceof UnsupportedCharsetException) {
                    arrayList.add(new EncodingDownloadFailure(deferredUpdateInformation));
                } else if (throwable instanceof CharacterCodingException) {
                    arrayList.add(new EncodingDownloadFailure(deferredUpdateInformation));
                } else if (throwable instanceof OperationCanceledException) {
                    throw (Throwable)new OperationCanceledException();
                }
            }
            ++var6_11;
        }
        if (arrayList.size() > 0) {
            boolean bl2;
            for (EncodingDownloadFailure encodingDownloadFailure : arrayList) {
                encodingDownloadFailure.setIgnoreEncoding(true);
            }
            boolean bl3 = false;
            this.contentSession = FileSystemCore.getContentManager(this.repo).createSession("", true, arrayList.size(), (IProgressMonitor)subMonitor.newChild(75));
            try {
                for (EncodingDownloadFailure encodingDownloadFailure : arrayList) {
                    if (!encodingDownloadFailure.hasDirection()) continue;
                    object = (DeferredUpdateInformation)encodingDownloadFailure.getDeferredUpdateInformation();
                    throwable = ((DeferredInformation)object).getFileItemState();
                    this.contentSession.retrieveContent((IFileItemHandle)throwable, ((DeferredInformation)object).getContent(), ((DeferredInformation)object).getEncoding(), ((DeferredInformation)object).getLineDelimiter(), new MergeLoadMutator$DownloadHandler((DeferredUpdateInformation)object, this));
                    bl2 = true;
                }
            }
            finally {
                if (bl2) {
                    this.contentSession.join();
                }
            }
            SubMonitor subMonitor2 = subMonitor.newChild(25);
            subMonitor2.setWorkRemaining(arrayList.size());
            for (EncodingDownloadFailure encodingDownloadFailure : arrayList) {
                if (!encodingDownloadFailure.getDeferredUpdateInformation().isLineDelimiterIgnored() || encodingDownloadFailure.getDeferredUpdateInformation().getFailure() != null) continue;
                encodingDownloadFailure.getDeferredUpdateInformation().convert((IProgressMonitor)subMonitor2.newChild(1));
            }
        }
    }

    protected void createNewLink(ICopyFileArea iCopyFileArea, boolean bl, Shareable shareable, FileAreaUpdate fileAreaUpdate, HashSet hashSet, HashSet hashSet2, IProgressMonitor iProgressMonitor) throws TeamRepositoryException, FileSystemClientException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        subMonitor.setTaskName(Messages.MergeLoadMutator_15);
        ISandbox iSandbox = shareable.getSandbox();
        IPath iPath = shareable.getLocalPath();
        String string = fileAreaUpdate.getLinkTarget();
        try {
            IFileStorage iFileStorage = shareable.getFileStorage();
            if (iFileStorage != null) {
                if (ManagedFileStore.supportsSymLinks()) {
                    SharingManager.getInstance().doSilentChange(new MergeLoadMutator$1(this, iFileStorage, string, subMonitor));
                    hashSet.add(shareable);
                    if (this.downloadMonitor != null) {
                        this.downloadMonitor.downloadStarted(iPath, 0L);
                    }
                } else {
                    hashSet2.add(shareable);
                    this.collectStatus(FileSystemStatus.getStatusFor(1, NLS.bind((String)Messages.MergeLoadMutator_21, (Object)shareable.getLocalPath().toString(), (Object[])new Object[]{string}), null));
                }
                ISymbolicLinkHandle iSymbolicLinkHandle = (ISymbolicLinkHandle)fileAreaUpdate.afterState();
                if (bl) {
                    FileItemInfoProxy fileItemInfoProxy = new FileItemInfoProxy((IVersionableHandle)iSymbolicLinkHandle, fileAreaUpdate.parent(), fileAreaUpdate.getName(), PathUtils.isLoadedWithAnotherName(iSandbox, iPath, fileAreaUpdate.getName()));
                    fileItemInfoProxy.setTarget(iFileStorage.getModificationStamp(), string);
                    SharingDescriptor sharingDescriptor = new SharingDescriptor(this.connection.teamRepository().getRepositoryURI(), this.connection.teamRepository().getId(), this.connection, (IComponentHandle)this.component, this.component.getName(), (IVersionableHandle)iSymbolicLinkHandle);
                    SharingManager.getInstance().share(shareable, sharingDescriptor, fileItemInfoProxy.getFileItemInfo(), 2, (IProgressMonitor)subMonitor.newChild(1));
                } else {
                    FileItemInfo fileItemInfo = iCopyFileArea.getItemInfo(iPath.removeLastSegments(1));
                    FileItemInfoProxy fileItemInfoProxy = new FileItemInfoProxy((IVersionableHandle)iSymbolicLinkHandle, (IFolderHandle)fileItemInfo.getVersionableHandle(), fileAreaUpdate.getName());
                    fileItemInfoProxy.setTarget(iFileStorage.getModificationStamp(), string);
                    iCopyFileArea.setItemMetaData(shareable.getLocalPath(), fileItemInfoProxy.getFileItemInfo(), (IProgressMonitor)subMonitor.newChild(1));
                }
            }
        }
        catch (CoreException coreException) {
            throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.MergeLoadMutator_16, (Object)iPath, (Object[])new Object[0]), (Throwable)coreException)));
        }
        iProgressMonitor.done();
        this.checkCancelled(iProgressMonitor);
    }

    private void modifyLink(ICopyFileArea iCopyFileArea, boolean bl, IVersionableHandle iVersionableHandle, FileAreaUpdate fileAreaUpdate, Shareable shareable, boolean bl2, HashSet hashSet, HashSet hashSet2, IProgressMonitor iProgressMonitor) throws FileSystemClientException, TeamRepositoryException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        String string = fileAreaUpdate.getLinkTarget();
        this.shed.forceBackup(shareable, (IProgressMonitor)subMonitor);
        if (ManagedFileStore.supportsSymLinks()) {
            SharingManager.getInstance().disableChangeMonitoring();
            try {
                shareable.getFileStorage().setTarget(this.shed, string == null ? "" : string, (IProgressMonitor)subMonitor.newChild(50));
            }
            finally {
                SharingManager.getInstance().enableChangeMonitoring();
            }
            hashSet.add(shareable);
        } else {
            hashSet2.add(shareable);
            this.collectStatus(FileSystemStatus.getStatusFor(1, NLS.bind((String)Messages.MergeLoadMutator_22, (Object)shareable.getLocalPath().toString(), (Object[])new Object[]{string}), null));
        }
        InverseFileItemInfo inverseFileItemInfo = iCopyFileArea.getItemInfo(iVersionableHandle, (IComponentHandle)this.component, this.connectionHandle);
        IFolderHandle iFolderHandle = null;
        String string2 = null;
        boolean bl3 = false;
        if (bl2 && inverseFileItemInfo != null) {
            iFolderHandle = ((FileItemInfo)inverseFileItemInfo).getParent();
            string2 = ((FileItemInfo)inverseFileItemInfo).getName();
            bl3 = ((FileItemInfo)inverseFileItemInfo).isLoadedWithAnotherName();
        } else {
            iFolderHandle = fileAreaUpdate.parent();
            string2 = fileAreaUpdate.getName();
            if (bl) {
                bl3 = PathUtils.isLoadedWithAnotherName(shareable.getSandbox(), shareable.getLocalPath(), string2);
            }
        }
        FileItemInfoProxy fileItemInfoProxy = new FileItemInfoProxy(iVersionableHandle, iFolderHandle, string2, bl3);
        fileItemInfoProxy.setTarget(shareable.getFileStorage().getModificationStamp(), string);
        FileItemInfo fileItemInfo = fileItemInfoProxy.getFileItemInfo();
        if (bl) {
            SharingDescriptor sharingDescriptor = new SharingDescriptor(this.connection.teamRepository().getRepositoryURI(), this.connection.teamRepository().getId(), this.connection, (IComponentHandle)this.component, this.component.getName(), iVersionableHandle);
            SharingManager.getInstance().share(shareable, sharingDescriptor, fileItemInfo, 2, (IProgressMonitor)subMonitor.newChild(10));
        } else {
            iCopyFileArea.setItemMetaData(shareable.getLocalPath(), fileItemInfo, (IProgressMonitor)subMonitor.newChild(10));
        }
    }

    protected boolean isSpecialCase(IShareable iShareable, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        return false;
    }

    private IStatus[] getDownloadFailures(DeferredUpdateInformation[] deferredUpdateInformationArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl = false;
        DeferredUpdateInformation[] deferredUpdateInformationArray2 = deferredUpdateInformationArray;
        int n = deferredUpdateInformationArray.length;
        int n2 = 0;
        while (n2 < n) {
            block7: {
                Status status;
                Throwable throwable;
                DeferredUpdateInformation deferredUpdateInformation;
                block8: {
                    block10: {
                        block11: {
                            block9: {
                                Serializable serializable;
                                deferredUpdateInformation = deferredUpdateInformationArray2[n2];
                                if (deferredUpdateInformation == null) break block7;
                                if (deferredUpdateInformation.getFailure() == null) break block8;
                                throwable = deferredUpdateInformation.getFailure().getCause();
                                int n3 = 0;
                                while (throwable instanceof TeamRepositoryException && n3 < 50) {
                                    serializable = ((TeamRepositoryException)throwable).getCause();
                                    if (serializable == null) break;
                                    throwable = serializable;
                                    ++n3;
                                }
                                if (!(throwable instanceof UnsupportedEncodingException) && !(throwable instanceof UnsupportedCharsetException)) break block9;
                                if (!bl) {
                                    String string2;
                                    serializable = new StringBuffer();
                                    for (String string2 : Charset.availableCharsets().keySet()) {
                                        ((StringBuffer)serializable).append(string2).append(' ');
                                    }
                                    string2 = new Status(1, "com.ibm.team.filesystem.client", NLS.bind((String)Messages.MergeLoadMutator_3, (Object)((StringBuffer)serializable).toString(), (Object[])new Object[0]));
                                    arrayList.add(string2);
                                    bl = true;
                                }
                                status = new Status(4, "com.ibm.team.filesystem.client", NLS.bind((String)Messages.MergeLoadMutator_5, (Object)deferredUpdateInformation.getPath().toString(), (Object[])new Object[]{deferredUpdateInformation.getContent().getCharacterEncoding()}), (Throwable)deferredUpdateInformation.getFailure());
                                break block10;
                            }
                            if (!(throwable instanceof CharacterCodingException)) break block11;
                            status = new Status(4, "com.ibm.team.filesystem.client", NLS.bind((String)Messages.MergeLoadMutator_1, (Object)deferredUpdateInformation.getPath().toString(), (Object[])new Object[]{deferredUpdateInformation.getContent().getCharacterEncoding()}), (Throwable)deferredUpdateInformation.getFailure());
                            break block10;
                        }
                        if (throwable instanceof OperationCanceledException) break block7;
                        status = new Status(4, "com.ibm.team.filesystem.client", NLS.bind((String)Messages.MergeLoadMutator_6, (Object)deferredUpdateInformation.getPath(), (Object[])new Object[0]), (Throwable)deferredUpdateInformation.getFailure());
                    }
                    arrayList.add((String)status);
                    break block7;
                }
                if (deferredUpdateInformation.isLineDelimiterIgnored()) {
                    throwable = deferredUpdateInformation.getFileAreaUpdate().getOptionalContent();
                    status = new Status(2, "com.ibm.team.filesystem.client", NLS.bind((String)Messages.MergeLoadMutator_23, (Object)deferredUpdateInformation.getPath().toString(), (Object[])new Object[]{throwable.getCharacterEncoding(), throwable.getLineDelimiter().toString()}));
                    arrayList.add((String)status);
                }
            }
            ++n2;
        }
        return arrayList.toArray(new IStatus[arrayList.size()]);
    }

    private void updateContentLoadedMetaData(ICopyFileArea iCopyFileArea, DeferredUpdateInformation[] deferredUpdateInformationArray, List list, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        Shareable shareable;
        FileAreaUpdate fileAreaUpdate;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)(deferredUpdateInformationArray.length * 2 + 10));
        Shareable[] shareableArray = new Shareable[deferredUpdateInformationArray.length];
        int n = 0;
        while (n < deferredUpdateInformationArray.length) {
            if (deferredUpdateInformationArray[n] == null || !deferredUpdateInformationArray[n].contentUpdated()) {
                subMonitor.worked(1);
            } else {
                fileAreaUpdate = (FileAreaUpdate)list.get(n);
                shareableArray[n] = shareable = new Shareable(deferredUpdateInformationArray[n].getSandbox(), deferredUpdateInformationArray[n].getPath(), ResourceType.getResourceType(fileAreaUpdate.afterState()));
                this.refresh(shareable, 0, (IProgressMonitor)subMonitor.newChild(1));
            }
            ++n;
        }
        n = 0;
        while (n < deferredUpdateInformationArray.length) {
            if (deferredUpdateInformationArray[n] == null || !deferredUpdateInformationArray[n].contentUpdated()) {
                subMonitor.worked(1);
            } else {
                fileAreaUpdate = (FileAreaUpdate)list.get(n);
                shareable = shareableArray[n];
                if (shareable == null) {
                    shareableArray[n] = shareable = new Shareable(deferredUpdateInformationArray[n].getSandbox(), deferredUpdateInformationArray[n].getPath(), ResourceType.getResourceType(fileAreaUpdate.afterState()));
                }
                this.updateMetaInfoForPath(iCopyFileArea, fileAreaUpdate.getComponent(), fileAreaUpdate.afterState(), shareable, deferredUpdateInformationArray[n], (IProgressMonitor)subMonitor.newChild(1));
            }
            ++n;
        }
        this.contentLoadCompleted((IProgressMonitor)subMonitor.newChild(10));
        subMonitor.done();
    }

    private void refreshLinks(Set set, HashSet hashSet, IProgressMonitor iProgressMonitor) {
        Object object2;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)(set.size() + hashSet.size()));
        for (Object object2 : set) {
            try {
                new Shareable(((Shareable)object2).getSandbox(), ((Shareable)object2).getLocalPath(), ResourceType.SYMBOLIC_LINK).getFileStorage().refreshCachedSubTree(Integer.MAX_VALUE, (IProgressMonitor)subMonitor.newChild(1));
            }
            catch (FileSystemClientException fileSystemClientException) {}
        }
        object2 = LocalChangeManager.getInstance();
        for (Object object3 : hashSet) {
            try {
                ((LocalChangeManager)object2).computeChanges((IShareable)object3, (IProgressMonitor)subMonitor.newChild(1));
            }
            catch (FileSystemClientException fileSystemClientException) {}
        }
    }

    private void refresh(Shareable shareable, int n, IProgressMonitor iProgressMonitor) {
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        IFileStorage iFileStorage = shareable.getFileStorage();
        if (iFileStorage != null) {
            try {
                SharingManager.getInstance().doSilentChange(new MergeLoadMutator$2(this, iFileStorage, n, subMonitor));
            }
            catch (CoreException coreException) {
                this.collectStatus(FileSystemStatus.getStatusFor(coreException));
            }
        }
    }

    private void updateMetaInfoForPath(ICopyFileArea iCopyFileArea, IComponentHandle iComponentHandle, IVersionableHandle iVersionableHandle, Shareable shareable, DeferredUpdateInformation deferredUpdateInformation, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)((IProgressMonitor)new NonCancellingProgressMonitor(iProgressMonitor)), (int)100);
        IFileStorage iFileStorage = shareable.getFileStorage();
        InverseFileItemInfo inverseFileItemInfo = iCopyFileArea.getItemInfo(iVersionableHandle, iComponentHandle, this.connectionHandle);
        IFolderHandle iFolderHandle = null;
        String string = null;
        boolean bl = false;
        if (deferredUpdateInformation.isUndo()) {
            iFolderHandle = ((FileItemInfo)inverseFileItemInfo).getParent();
            string = ((FileItemInfo)inverseFileItemInfo).getName();
            bl = ((FileItemInfo)inverseFileItemInfo).isLoadedWithAnotherName();
        } else {
            iFolderHandle = deferredUpdateInformation.getRemoteParent();
            string = deferredUpdateInformation.getRemoteName();
            if (deferredUpdateInformation.isShare()) {
                bl = PathUtils.isLoadedWithAnotherName(shareable.getSandbox(), deferredUpdateInformation.getPath(), string);
            }
        }
        FileContent fileContent = (FileContent)deferredUpdateInformation.getContent();
        FileItemInfoProxy fileItemInfoProxy = new FileItemInfoProxy(iVersionableHandle, iFolderHandle, string, bl);
        fileItemInfoProxy.setContentInfo(iFileStorage.getModificationStamp(), deferredUpdateInformation.getHash(), deferredUpdateInformation.getContentSize(), fileContent);
        fileItemInfoProxy.setExecutable(deferredUpdateInformation.isExecutable(), deferredUpdateInformation.isExecutable());
        fileItemInfoProxy.setProperties(deferredUpdateInformation.getFileAreaUpdate().getProperties());
        FileItemInfo fileItemInfo = fileItemInfoProxy.getFileItemInfo();
        if (deferredUpdateInformation.isShare()) {
            SharingDescriptor sharingDescriptor = new SharingDescriptor(this.connection.teamRepository().getRepositoryURI(), this.connection.teamRepository().getId(), this.connection, (IComponentHandle)this.component, this.component.getName(), iVersionableHandle);
            SharingManager.getInstance().share(shareable, sharingDescriptor, fileItemInfo, 2, (IProgressMonitor)subMonitor.newChild(10));
        } else {
            iCopyFileArea.setItemMetaData(deferredUpdateInformation.getPath(), fileItemInfo, (IProgressMonitor)subMonitor.newChild(10));
        }
        iFileStorage.setExecutable(deferredUpdateInformation.isExecutable(), (IProgressMonitor)subMonitor.newChild(10));
        this.contentLoadCompleted(shareable, (IProgressMonitor)subMonitor.newChild(30));
        subMonitor.done();
    }

    protected void contentLoadCompleted(Shareable shareable, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
    }

    protected void contentLoadCompleted(IProgressMonitor iProgressMonitor) throws FileSystemClientException {
    }

    private Shareable getExistingShareable(ICopyFileArea iCopyFileArea, IVersionableHandle iVersionableHandle, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        IPath iPath = iCopyFileArea.getLocalPathFor(this.connectionHandle, (IComponentHandle)this.component, iVersionableHandle, iProgressMonitor);
        return iPath == null ? null : new Shareable(this.sandbox, iPath, ResourceType.getResourceType(iVersionableHandle));
    }

    protected void createNewFile(DeferredUpdateInformation deferredUpdateInformation, IProgressMonitor iProgressMonitor) throws FileSystemClientException, TeamRepositoryException {
        if (deferredUpdateInformation.getContent() != null) {
            this.contentSession.retrieveContent((IFileItemHandle)deferredUpdateInformation.getFileItemState(), deferredUpdateInformation.getContent(), new MergeLoadMutator$DownloadHandler(deferredUpdateInformation, this));
        } else {
            this.storeFileContents(deferredUpdateInformation.getSandbox().getRoot(), deferredUpdateInformation.getPath(), deferredUpdateInformation.getContent(), new ByteArrayInputStream(new byte[0]));
        }
    }

    protected void createNewFolder(ICopyFileArea iCopyFileArea, boolean bl, Shareable shareable, FileAreaUpdate fileAreaUpdate, IProgressMonitor iProgressMonitor) throws FileSystemClientException, TeamRepositoryException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        subMonitor.setTaskName(Messages.MergeLoadMutator_15);
        ISandbox iSandbox = shareable.getSandbox();
        IPath iPath = shareable.getLocalPath();
        try {
            IFileStorage iFileStorage = shareable.getFileStorage();
            if (iFileStorage != null) {
                SharingManager.getInstance().doSilentChange(new MergeLoadMutator$3(this, iFileStorage, subMonitor));
                IFolderHandle iFolderHandle = (IFolderHandle)fileAreaUpdate.afterState();
                if (bl) {
                    FileItemInfo fileItemInfo = new FileItemInfoProxy((IVersionableHandle)iFolderHandle, fileAreaUpdate.parent(), fileAreaUpdate.getName(), PathUtils.isLoadedWithAnotherName(iSandbox, iPath, fileAreaUpdate.getName())).getFileItemInfo();
                    SharingDescriptor sharingDescriptor = new SharingDescriptor(this.connection.teamRepository().getRepositoryURI(), this.connection.teamRepository().getId(), this.connection, (IComponentHandle)this.component, this.component.getName(), (IVersionableHandle)iFolderHandle);
                    SharingManager.getInstance().share(shareable, sharingDescriptor, fileItemInfo, 2, (IProgressMonitor)subMonitor.newChild(1));
                } else {
                    FileItemInfo fileItemInfo = iCopyFileArea.getItemInfo(iPath.removeLastSegments(1));
                    FileItemInfo fileItemInfo2 = new FileItemInfoProxy((IVersionableHandle)iFolderHandle, (IFolderHandle)fileItemInfo.getVersionableHandle(), fileAreaUpdate.getName()).getFileItemInfo();
                    iCopyFileArea.setItemMetaData(shareable.getLocalPath(), fileItemInfo2, (IProgressMonitor)subMonitor.newChild(1));
                }
            }
        }
        catch (CoreException coreException) {
            throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.MergeLoadMutator_16, (Object)iPath, (Object[])new Object[0]), (Throwable)coreException)));
        }
        iProgressMonitor.done();
        this.checkCancelled(iProgressMonitor);
    }

    protected static void deleteSubtree(Shareable shareable, ResourceType resourceType, Shed shed, IProgressMonitor iProgressMonitor) throws FileSystemClientException, TeamRepositoryException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        try {
            SharingManager.getInstance().doSilentChange(new MergeLoadMutator$4(shareable, subMonitor, resourceType, shed));
        }
        catch (CoreException coreException) {
            throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, 370, NLS.bind((String)Messages.MergeLoadMutator_17, (Object)shareable.getLocalPath(), (Object[])new Object[0]), coreException)));
        }
    }

    protected void modifyFile(Shareable shareable, DeferredUpdateInformation deferredUpdateInformation, IProgressMonitor iProgressMonitor) throws FileSystemClientException, TeamRepositoryException {
        this.shed.forceBackup(shareable, iProgressMonitor);
        IVersionableHandle iVersionableHandle = deferredUpdateInformation.getFileItemState();
        this.contentSession.retrieveContent((IFileItemHandle)iVersionableHandle, deferredUpdateInformation.getContent(), new MergeLoadMutator$DownloadHandler(deferredUpdateInformation, this));
    }

    protected void deleteIncompleteFile(IPath iPath, IPath iPath2) throws TeamRepositoryException {
        try {
            SharingManager.getInstance().doSilentChange(new MergeLoadMutator$5(this, iPath, iPath2));
        }
        catch (CoreException coreException) {
            throw (Throwable)new TeamRepositoryException((Throwable)coreException);
        }
    }

    private void storeFileContents(IPath iPath, IPath iPath2, IFileContent iFileContent, InputStream inputStream) throws TeamRepositoryException {
        try {
            SharingManager.getInstance().doSilentChange(new MergeLoadMutator$6(this, iFileContent, iPath2, iPath, inputStream));
        }
        catch (CoreException coreException) {
            throw (Throwable)new TeamRepositoryException(NLS.bind((String)Messages.MergeLoadMutator_18, (Object)iPath2, (Object[])new Object[0]), (Throwable)coreException);
        }
    }

    protected void internalStoreFileContents(IPath iPath, IPath iPath2, InputStream inputStream) throws TeamRepositoryException {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(iPath.append(iPath2).toFile());
            try {
                ContentManager.read((InputStream)inputStream, (OutputStream)fileOutputStream);
            }
            catch (Throwable throwable) {
                try {
                    ((OutputStream)fileOutputStream).close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                ((OutputStream)fileOutputStream).close();
            }
            catch (IOException iOException) {}
        }
        catch (SocketException socketException) {
            throw (Throwable)new TeamRepositoryException(NLS.bind((String)Messages.MergeLoadMutator_7, (Object)socketException.getMessage(), (Object[])new Object[0]), (Throwable)socketException);
        }
        catch (IOException iOException) {
            throw (Throwable)new TeamRepositoryException(NLS.bind((String)Messages.MergeLoadMutator_8, (Object)iPath2, (Object[])new Object[0]), (Throwable)iOException);
        }
    }

    protected void reportErrorsAsException(IStatus[] iStatusArray) throws FileSystemClientException {
        if (iStatusArray.length == 0) {
            return;
        }
        MultiStatus multiStatus = new MultiStatus("com.ibm.team.filesystem.client", 0, iStatusArray, NLS.bind((String)Messages.MergeLoadMutator_9, (Object)iStatusArray.length, (Object[])new Object[0]), null);
        throw (Throwable)((Object)new FileSystemClientException((IStatus)multiStatus));
    }

    public static void deleteShare(IShare iShare, Shed shed, IProgressMonitor iProgressMonitor) throws FileSystemClientException, TeamRepositoryException {
        IShareable iShareable = iShare.getShareable();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        MergeLoadMutator.deleteSubtree((Shareable)iShareable, ResourceType.getResourceType(iShare.getSharingDescriptor().getRootVersionable()), shed, (IProgressMonitor)subMonitor.newChild(75));
        SharingManager.getInstance().forget((Shareable)iShareable, (IProgressMonitor)subMonitor.newChild(25));
    }

    static /* synthetic */ void access$0(MergeLoadMutator mergeLoadMutator, IPath iPath, IPath iPath2, IFileContent iFileContent, InputStream inputStream) throws TeamRepositoryException {
        mergeLoadMutator.storeFileContents(iPath, iPath2, iFileContent, inputStream);
    }
}

