/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.load;

import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.ILoadRule;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.client.IConfiguration;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;

public class LoadRule
implements ILoadRule {
    public static final String FOLDER_NAME = "foldername=";
    public static final String VERSIONABLE_NAME = "versionablename=";
    public static final String ROOT_FOLDER_NAME = "rootfoldername=";
    private IWorkspaceConnection workspaceConnection;
    private IComponentHandle componentHandle;
    private HashMap rootFolders;
    private HashMap toLoad;
    private boolean toLoadValid;
    private HashMap folders;

    public LoadRule(IWorkspaceConnection iWorkspaceConnection, IComponentHandle iComponentHandle) {
        if (iWorkspaceConnection == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (iComponentHandle == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        this.workspaceConnection = iWorkspaceConnection;
        this.componentHandle = iComponentHandle;
        this.folders = new HashMap();
        this.rootFolders = new HashMap();
        this.toLoad = new HashMap();
        this.toLoadValid = true;
    }

    public void addLoadRules(IFileItemHandle iFileItemHandle, IProgressMonitor iProgressMonitor) throws TeamRepositoryException {
        if (iFileItemHandle == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        IFileItem iFileItem = (IFileItem)this.workspaceConnection.configuration(this.componentHandle).fetchCompleteItem((IVersionableHandle)iFileItemHandle, (IProgressMonitor)subMonitor.newChild(10));
        InputStream inputStream = FileSystemCore.getContentManager(this.workspaceConnection.teamRepository()).retrieveContentStream((IFileItemHandle)iFileItem, iFileItem.getContent(), (IProgressMonitor)subMonitor.newChild(50));
        this.getRules(iFileItem.getContent().getCharacterEncoding(), inputStream, (IProgressMonitor)subMonitor.newChild(40));
    }

    public void addLoadRules(InputStream inputStream, String string, IProgressMonitor iProgressMonitor) throws TeamRepositoryException {
        if (inputStream == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (string == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        this.getRules(string, inputStream, iProgressMonitor);
    }

    private void getRules(String string, InputStream inputStream, IProgressMonitor iProgressMonitor) throws TeamRepositoryException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        CharsetDecoder charsetDecoder = Charset.forName(string).newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, charsetDecoder));
        IConfiguration iConfiguration = this.workspaceConnection.configuration(this.componentHandle);
        IComponent iComponent = (IComponent)this.workspaceConnection.teamRepository().itemManager().fetchCompleteItem((IItemHandle)this.componentHandle, 0, (IProgressMonitor)subMonitor.newChild(1));
        try {
            String string2;
            while ((string2 = bufferedReader.readLine()) != null) {
                IVersionableHandle iVersionableHandle;
                Path path;
                if (string2.startsWith("#") || string2.trim().length() == 0) continue;
                if (string2.toLowerCase().startsWith(VERSIONABLE_NAME)) {
                    path = new Path(string2.substring(VERSIONABLE_NAME.length()));
                    iVersionableHandle = iConfiguration.resolvePath(iComponent.getRootFolder(), path.segments(), null);
                    if (iVersionableHandle == null) {
                        throw (Throwable)new TeamRepositoryException(NLS.bind((String)Messages.LoadRule_0, (Object)path.toString(), (Object[])new Object[]{iComponent.getName()}));
                    }
                    this.folders.put(iVersionableHandle.getItemId(), iVersionableHandle);
                    this.toLoad.put(iVersionableHandle.getItemId(), iVersionableHandle);
                    continue;
                }
                if (string2.toLowerCase().startsWith(FOLDER_NAME)) {
                    path = new Path(string2.substring(FOLDER_NAME.length()));
                    iVersionableHandle = iConfiguration.resolvePath(iComponent.getRootFolder(), path.segments(), null);
                    if (iVersionableHandle == null) {
                        throw (Throwable)new TeamRepositoryException(NLS.bind((String)Messages.LoadRule_0, (Object)path.toString(), (Object[])new Object[]{iComponent.getName()}));
                    }
                    this.folders.put(iVersionableHandle.getItemId(), iVersionableHandle);
                    this.toLoad.put(iVersionableHandle.getItemId(), iVersionableHandle);
                    continue;
                }
                if (string2.toLowerCase().startsWith(ROOT_FOLDER_NAME)) {
                    path = new Path(string2.substring(ROOT_FOLDER_NAME.length()));
                    iVersionableHandle = iConfiguration.resolvePath(iComponent.getRootFolder(), path.segments(), null);
                    if (!(iVersionableHandle instanceof IFolderHandle)) {
                        throw (Throwable)new TeamRepositoryException(NLS.bind((String)Messages.LoadRule_1, (Object)path.toString(), (Object[])new Object[]{iComponent.getName()}));
                    }
                    this.rootFolders.put(iVersionableHandle.getItemId(), (IFolderHandle)iVersionableHandle);
                    this.toLoadValid = false;
                    continue;
                }
                throw (Throwable)new TeamRepositoryException(NLS.bind((String)Messages.LoadRule_2, (Object)string2, (Object[])new Object[]{iComponent.getName()}));
            }
        }
        catch (IOException iOException) {
            throw (Throwable)new TeamRepositoryException(NLS.bind((String)Messages.LoadRule_3, (Object)iComponent.getName(), (Object[])new Object[0]));
        }
    }

    public Collection getItemsToLoad(IProgressMonitor iProgressMonitor) throws TeamRepositoryException {
        if (!this.toLoadValid) {
            this.toLoad.clear();
            this.toLoad.putAll(this.folders);
            this.toLoad.putAll(this.getRootFolderChildren(iProgressMonitor));
            this.toLoadValid = true;
        }
        return this.toLoad.values();
    }

    private Map getRootFolderChildren(IProgressMonitor iProgressMonitor) throws TeamRepositoryException {
        HashMap<UUID, IVersionableHandle> hashMap = new HashMap<UUID, IVersionableHandle>();
        if (!this.rootFolders.isEmpty()) {
            ArrayList arrayList = new ArrayList(this.rootFolders.size());
            arrayList.addAll(this.rootFolders.values());
            IConfiguration iConfiguration = this.workspaceConnection.configuration(this.componentHandle);
            List list = iConfiguration.childEntries((List)arrayList, null);
            for (Map map : list) {
                if (map == null) continue;
                for (IVersionableHandle iVersionableHandle : map.values()) {
                    hashMap.put(iVersionableHandle.getItemId(), iVersionableHandle);
                }
            }
        }
        return hashMap;
    }

    public void storeLoadRules(IShareable iShareable, String string, IProgressMonitor iProgressMonitor) {
        ((Shareable)iShareable).getFileStorage();
        throw (Throwable)new UnsupportedOperationException();
    }

    public void addItemToLoad(IVersionableHandle iVersionableHandle) {
        if (iVersionableHandle == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        this.folders.put(iVersionableHandle.getItemId(), iVersionableHandle);
        this.toLoad.put(iVersionableHandle.getItemId(), iVersionableHandle);
    }

    public void addRootFolderToLoad(IFolderHandle iFolderHandle) {
        if (iFolderHandle == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        this.rootFolders.put(iFolderHandle.getItemId(), iFolderHandle);
        this.toLoadValid = false;
    }

    public IComponentHandle getComponent() {
        return this.componentHandle;
    }

    public IWorkspaceConnection getWorkspaceConnection() {
        return this.workspaceConnection;
    }
}

