/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.load;

import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.operations.ILoadOverlap;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.IAncestorReport;
import com.ibm.team.scm.common.dto.INameItemPair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class LoadOverlap
implements ILoadOverlap {
    private IConnection connection;
    private IComponentHandle component;
    private ArrayList overlappingItems;
    private ArrayList overlappingShares;
    private IAncestorReport overlappedItem;
    private ISandbox sandbox;

    public LoadOverlap(ISandbox iSandbox, IConnection iConnection, IComponentHandle iComponentHandle, IAncestorReport iAncestorReport) {
        this.sandbox = iSandbox;
        this.connection = iConnection;
        this.component = iComponentHandle;
        this.overlappedItem = iAncestorReport;
        this.overlappingItems = new ArrayList();
        this.overlappingShares = new ArrayList();
    }

    public ISandbox getSandbox() {
        return this.sandbox;
    }

    public IComponentHandle getComponent() {
        return this.component;
    }

    public IConnection getConnection() {
        return this.connection;
    }

    public IVersionableHandle getItem() {
        return this.getVersionableRepresented(this.overlappedItem);
    }

    public String[] getPath() {
        return this.getPathRepresented(this.overlappedItem);
    }

    public Collection getOverlappingShares() {
        return Collections.unmodifiableCollection(this.overlappingShares);
    }

    public Map getOverlappingItems() {
        HashMap<IVersionableHandle, String[]> hashMap = new HashMap<IVersionableHandle, String[]>();
        for (IAncestorReport iAncestorReport : this.overlappingItems) {
            hashMap.put(this.getVersionableRepresented(iAncestorReport), this.getPathRepresented(iAncestorReport));
        }
        return hashMap;
    }

    public void addOverlappingItem(IAncestorReport iAncestorReport) {
        this.overlappingItems.add(iAncestorReport);
    }

    public void addOverlappingShare(IShare iShare) {
        this.overlappingShares.add(iShare);
    }

    private IVersionableHandle getVersionableRepresented(IAncestorReport iAncestorReport) {
        List list = iAncestorReport.getNameItemPairs();
        INameItemPair iNameItemPair = (INameItemPair)list.get(list.size() - 1);
        return iNameItemPair.getItem();
    }

    private String[] getPathRepresented(IAncestorReport iAncestorReport) {
        List list = iAncestorReport.getNameItemPairs();
        String[] stringArray = new String[list.size() - 1];
        int n = 0;
        Iterator iterator = list.iterator();
        iterator.next();
        while (iterator.hasNext()) {
            INameItemPair iNameItemPair = (INameItemPair)iterator.next();
            stringArray[n] = iNameItemPair.getName();
            ++n;
        }
        return stringArray;
    }
}

