/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.load;

import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.operations.ILoadLocation;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IVersionableHandle;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class LoadLocation
implements ILoadLocation {
    private ISandbox sandbox;
    private IPath relativeLoadPath;
    private String name;
    private IPath fullPath;
    private IConnection connection;
    private IComponent component;
    private IVersionableHandle itemToLoad;
    private boolean loadWithAnotherName;

    public LoadLocation(ISandbox iSandbox, IPath iPath, String string, IConnection iConnection, IComponent iComponent, IVersionableHandle iVersionableHandle, boolean bl) throws TeamRepositoryException {
        this.sandbox = iSandbox;
        this.relativeLoadPath = iPath;
        this.name = string;
        this.fullPath = new Path(iSandbox.getRoot().append(iPath).append(string).toFile().getAbsolutePath()).removeTrailingSeparator();
        this.connection = iConnection;
        this.component = iComponent;
        this.itemToLoad = iVersionableHandle;
        this.loadWithAnotherName = bl;
    }

    public IComponent getComponent() {
        return this.component;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.connection == null ? 0 : this.connection.hashCode());
        n = 31 * n + (this.component == null ? 0 : this.component.getItemId().hashCode());
        n = 31 * n + (this.fullPath == null ? 0 : this.fullPath.hashCode());
        n = 31 * n + (this.itemToLoad == null ? 0 : this.itemToLoad.getItemId().hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        LoadLocation loadLocation = (LoadLocation)object;
        if (this.connection == null ? loadLocation.connection != null : !this.connection.equals(loadLocation.connection)) {
            return false;
        }
        if (this.component == null ? loadLocation.component != null : !this.component.sameItemId((IItemHandle)loadLocation.component)) {
            return false;
        }
        if (this.fullPath == null ? loadLocation.fullPath != null : !this.fullPath.equals((Object)loadLocation.fullPath)) {
            return false;
        }
        return !(this.itemToLoad == null ? loadLocation.itemToLoad != null : !this.itemToLoad.sameItemId((IItemHandle)loadLocation.itemToLoad));
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getComponent().getName());
        stringBuffer.append('/');
        stringBuffer.append(this.fullPath.toString());
        return stringBuffer.toString();
    }

    public IConnection getConnection() {
        return this.connection;
    }

    public ISandbox getSandbox() {
        return this.sandbox;
    }

    public IPath getLoadPath() {
        return this.relativeLoadPath.append(this.name);
    }

    public IVersionableHandle getRootToLoad() {
        return this.itemToLoad;
    }

    public IPath getFullPath() {
        return this.fullPath;
    }

    public boolean isLoadWithAnotherName() {
        return this.loadWithAnotherName;
    }
}

