/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.load;

import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.operations.IInvalidLoadLocation;
import com.ibm.team.filesystem.client.operations.ILoadRequest;
import com.ibm.team.repository.common.util.NLS;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;

public class InvalidLoadLocation
implements IInvalidLoadLocation {
    private ILoadRequest loadRequest;
    private Collection sandboxesOverlapped;
    private Collection loadRequestsOverlapped;
    private IShareable presentLoadLocation;
    private Collection sharesOverlapped;
    private List failureReasons;

    public InvalidLoadLocation(ILoadRequest iLoadRequest) {
        this.loadRequest = iLoadRequest;
        this.sandboxesOverlapped = new ArrayList(2);
        this.loadRequestsOverlapped = new ArrayList(2);
        this.sharesOverlapped = new ArrayList(2);
        this.failureReasons = new ArrayList(2);
    }

    public void addCopyFileAreaPaths(Collection collection) {
        for (ISandbox iSandbox : collection) {
            this.failureReasons.add(FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.InvalidLoadLocation_1, (Object)iSandbox.getRoot().toString(), (Object[])new Object[0]), null));
        }
        this.sandboxesOverlapped.addAll(collection);
    }

    public void addOverlappingLoadRequests(ILoadRequest iLoadRequest) {
        this.failureReasons.add(FileSystemStatus.getStatusFor(4, Messages.InvalidLoadLocation_2, null));
        this.loadRequestsOverlapped.add(iLoadRequest);
    }

    public void addOverlappingShare(IShare iShare) {
        this.failureReasons.add(FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.InvalidLoadLocation_3, (Object)iShare.getPath().toString(), (Object[])new Object[0]), null));
        this.sharesOverlapped.add(iShare);
    }

    public void setPresentLoadLocation(IShareable iShareable) {
        this.failureReasons.add(FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.InvalidLoadLocation_4, (Object)iShareable.getFullPath().toString(), (Object[])new Object[0]), null));
        this.presentLoadLocation = iShareable;
    }

    public Collection getSandboxesOverlapped() {
        return Collections.unmodifiableCollection(this.sandboxesOverlapped);
    }

    public ILoadRequest getLoadRequest() {
        return this.loadRequest;
    }

    public Collection getLoadRequestsOverlapped() {
        return Collections.unmodifiableCollection(this.loadRequestsOverlapped);
    }

    public IShareable getPresentLoadLocation() {
        return this.presentLoadLocation;
    }

    public Collection getSharesOverlapped() {
        return Collections.unmodifiableCollection(this.sharesOverlapped);
    }

    public IStatus getStatus() {
        String string = NLS.bind((String)Messages.InvalidLoadLocation_0, (Object)this.loadRequest.getSandbox().getRoot().append(this.loadRequest.getRelativeLoadPath()).append(this.loadRequest.getAlternativeName()), (Object[])new Object[0]);
        MultiStatus multiStatus = new MultiStatus("com.ibm.team.filesystem.client", 0, string, null);
        for (IStatus iStatus : this.failureReasons) {
            multiStatus.add(iStatus);
        }
        return (IStatus)multiStatus;
    }
}

