/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.load;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.common.FileLineDelimiter;
import com.ibm.team.filesystem.common.IFileContent;
import com.ibm.team.filesystem.common.internal.dto.FileAreaUpdate;
import com.ibm.team.filesystem.common.util.VerifyConvertToCRInputStream;
import com.ibm.team.filesystem.common.util.VerifyConvertToCRLFInputStream;
import com.ibm.team.filesystem.common.util.VerifyConvertToLFInputStream;
import com.ibm.team.repository.common.utils.ReaderToInputStream;
import com.ibm.team.repository.common.utils.TemporaryOutputStream;
import com.ibm.team.scm.common.ContentHash;
import com.ibm.team.scm.common.ContentHashAlgorithmException;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public abstract class DeferredInformation {
    private boolean contentTransferred;
    private ContentHash hash;
    private long contentSize;
    private Exception failure;
    private FileAreaUpdate fileAreaUpdate;
    private String alternateEncoding;
    private FileLineDelimiter alternateDelimiter;

    public DeferredInformation(FileAreaUpdate fileAreaUpdate) {
        this.fileAreaUpdate = fileAreaUpdate;
        this.contentTransferred = false;
        this.alternateEncoding = null;
    }

    public boolean contentUpdated() {
        return this.contentTransferred;
    }

    public boolean isExecutable() {
        return this.fileAreaUpdate.isExecutable();
    }

    public void setContentUpdated(ContentHash contentHash, long l) {
        this.contentTransferred = true;
        this.hash = contentHash;
        this.contentSize = l;
    }

    public IFileContent getContent() {
        return this.fileAreaUpdate.getOptionalContent();
    }

    public String getContentType() {
        return this.fileAreaUpdate.getContentType();
    }

    public String getRemoteName() {
        return this.fileAreaUpdate.getName();
    }

    public IFolderHandle getRemoteParent() {
        return this.fileAreaUpdate.getDestinationParent();
    }

    public IVersionableHandle getFileItemState() {
        return this.fileAreaUpdate.afterState();
    }

    public IComponentHandle getComponent() {
        return this.fileAreaUpdate.getComponent();
    }

    public Map getProperties() {
        return this.fileAreaUpdate.getProperties();
    }

    public ContentHash getHash() {
        return this.hash;
    }

    public long getContentSize() {
        return this.contentSize;
    }

    public void setFailure(Exception exception) {
        this.failure = exception;
        this.contentTransferred = false;
    }

    public Exception getFailure() {
        return this.failure;
    }

    public String getEncoding() {
        if (this.alternateEncoding == null) {
            return this.fileAreaUpdate.getOptionalContent().getCharacterEncoding();
        }
        return this.alternateEncoding;
    }

    public FileLineDelimiter getLineDelimiter() {
        if (this.alternateDelimiter == null) {
            return this.fileAreaUpdate.getOptionalContent().getLineDelimiter();
        }
        return this.alternateDelimiter;
    }

    public FileAreaUpdate getFileAreaUpdate() {
        return this.fileAreaUpdate;
    }

    public void setAlternateEncoding(String string) {
        this.alternateEncoding = string;
    }

    public void setAlternativeLineDelimiter(FileLineDelimiter fileLineDelimiter) {
        this.alternateDelimiter = fileLineDelimiter;
    }

    public boolean hasAlternateDownloadDirection() {
        return this.alternateDelimiter != null && this.fileAreaUpdate.getOptionalContent().getLineDelimiter() != this.alternateDelimiter || this.alternateEncoding != null && !this.fileAreaUpdate.getOptionalContent().getCharacterEncoding().equals(this.alternateEncoding);
    }

    public boolean isLineDelimiterIgnored() {
        return this.alternateDelimiter != null && this.fileAreaUpdate.getOptionalContent().getLineDelimiter() != this.alternateDelimiter && this.alternateDelimiter == FileLineDelimiter.LINE_DELIMITER_NONE;
    }

    public void reset() {
        this.failure = null;
        this.contentTransferred = false;
        this.hash = null;
        this.contentSize = 0L;
    }

    /*
     * Unable to fully structure code
     */
    public void convert(IProgressMonitor var1_1) {
        block63: {
            var2_2 = SubMonitor.convert((IProgressMonitor)var1_1, (int)100);
            if (!this.contentUpdated()) {
                return;
            }
            try {
                block64: {
                    block65: {
                        SharingManager.getInstance().disableChangeMonitoring();
                        var3_3 = this.getShareable();
                        ((Shareable)var3_3).getFileStorage().refreshCachedSubTree(1, (IProgressMonitor)var2_2.newChild(10));
                        var4_4 = SharingManager.getInstance().getContentExaminer().findStoredProperties(var3_3, (IProgressMonitor)var2_2.newChild(10));
                        var5_5 = this.fileAreaUpdate.getOptionalContent().getLineDelimiter();
                        if (var5_5.equals((Object)FileLineDelimiter.LINE_DELIMITER_PLATFORM)) {
                            var5_5 = FileLineDelimiter.getPlatformDelimiter();
                        }
                        var6_6 = var4_4.getEncoding();
                        if (this.fileAreaUpdate.getOptionalContent().getCharacterEncoding().equals(var6_6)) break block63;
                        var7_7 = ((Shareable)var3_3).getFileStorage();
                        var8_8 = null;
                        var9_9 = null;
                        var10_10 = null;
                        var9_9 = var7_7.getContents();
                        if (var5_5 == FileLineDelimiter.LINE_DELIMITER_LF) {
                            var11_11 = new VerifyConvertToLFInputStream(var9_9, var4_4.getEncoding());
                            break block64;
                        }
                        if (var5_5 == FileLineDelimiter.LINE_DELIMITER_CRLF) {
                            var11_11 = new VerifyConvertToCRLFInputStream(var9_9, var4_4.getEncoding());
                            break block64;
                        }
                        if (var5_5 != FileLineDelimiter.LINE_DELIMITER_CR) break block65;
                        var11_11 = new VerifyConvertToCRInputStream(var9_9, var4_4.getEncoding());
                        break block64;
                    }
lbl30:
                    // 2 sources

                    while (true) {
                        if (var9_9 != null) {
                            try {
                                var9_9.close();
                            }
                            catch (IOException v0) {}
                        }
                        if (var10_10 != null) {
                            try {
                                var10_10.close();
                            }
                            catch (IOException v1) {}
                        }
                        if (var8_8 != null) {
                            try {
                                var8_8.close();
                                var8_8.dispose();
                            }
                            catch (IOException v2) {}
                        }
                        return;
                    }
                }
                try {
                    block67: {
                        try {
                            var12_12 = new ReaderToInputStream((InputStreamReader)var11_11);
                            var13_13 = var2_2.newChild(40);
                            var14_14 = 1000;
                            var15_15 = 0;
                            var16_16 = this.fileAreaUpdate.getOptionalContent().getEstimatedConvertedLength();
                            var18_17 = 0L;
                            var13_13.setWorkRemaining(var14_14);
                            var20_18 = new byte[4096];
                            var8_8 = TemporaryOutputStream.getTemporaryOutputStream((long)var16_16);
                            var21_19 = ((InputStream)var12_12).read(var20_18);
                            while (var21_19 != -1) {
                                var22_21 = (int)((double)(var18_17 += (long)var21_19) / (double)var16_16 * (double)var14_14);
                                var13_13.worked(var22_21 - var15_15);
                                var15_15 = var22_21;
                                var8_8.write(var20_18, 0, var21_19);
                                var22_21 = (int)((double)(var18_17 += (long)var21_19) / (double)var16_16 * (double)var14_14);
                                var13_13.worked(var22_21 - var15_15);
                                var15_15 = var22_21;
                                var21_19 = ((InputStream)var12_12).read(var20_18);
                            }
                            var13_13.done();
                            var9_9.close();
                            var9_9 = null;
                            var8_8.close();
                            var10_10 = var8_8.getInputStream((IProgressMonitor)var2_2.newChild(5));
                            var21_20 = ContentHash.getDigestComputingStream((InputStream)var10_10);
                            try {
                                var7_7.setContents((InputStream)var21_20, true, (IProgressMonitor)var2_2.newChild(35));
                                this.setContentUpdated(ContentHash.valueOf((byte[])var21_20.getFinalDigest()), var21_20.getContentSize());
                                this.alternateDelimiter = null;
                            }
                            catch (FileSystemClientException var22_22) {
                                this.setFailure((Exception)var22_22);
                                ** continue;
                            }
                            var10_10.close();
                            var10_10 = null;
                            var8_8.dispose();
                            var8_8 = null;
                        }
                        catch (IOException v3) {
                            if (var9_9 != null) {
                                try {
                                    var9_9.close();
                                }
                                catch (IOException v4) {}
                            }
                            if (var10_10 != null) {
                                try {
                                    var10_10.close();
                                }
                                catch (IOException v5) {}
                            }
                            if (var8_8 != null) {
                                try {
                                    var8_8.close();
                                    var8_8.dispose();
                                }
                                catch (IOException v6) {}
                            }
                            break block63;
                        }
                        catch (ContentHashAlgorithmException v7) {
                            block66: {
                                try {
                                    if (var9_9 == null) break block66;
                                }
                                catch (Throwable var23_23) {
                                    if (var9_9 != null) {
                                        try {
                                            var9_9.close();
                                        }
                                        catch (IOException v8) {}
                                    }
                                    if (var10_10 != null) {
                                        try {
                                            var10_10.close();
                                        }
                                        catch (IOException v9) {}
                                    }
                                    if (var8_8 != null) {
                                        try {
                                            var8_8.close();
                                            var8_8.dispose();
                                        }
                                        catch (IOException v10) {}
                                    }
                                    throw var23_23;
                                }
                                try {
                                    var9_9.close();
                                }
                                catch (IOException v11) {}
                            }
                            if (var10_10 != null) {
                                try {
                                    var10_10.close();
                                }
                                catch (IOException v12) {}
                            }
                            if (var8_8 != null) {
                                try {
                                    var8_8.close();
                                    var8_8.dispose();
                                }
                                catch (IOException v13) {}
                            }
                            break block63;
                        }
                        if (var9_9 == null) break block67;
                        try {
                            var9_9.close();
                        }
                        catch (IOException v14) {}
                    }
                    if (var10_10 != null) {
                        try {
                            var10_10.close();
                        }
                        catch (IOException v15) {}
                    }
                    if (var8_8 == null) break block63;
                    try {
                        var8_8.close();
                        var8_8.dispose();
                    }
                    catch (IOException v16) {
                    }
                }
                catch (FileSystemClientException v17) {}
            }
            finally {
                SharingManager.getInstance().enableChangeMonitoring();
            }
        }
    }

    public abstract IShareable getShareable();
}

