/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.ignore;

import com.ibm.team.filesystem.client.IShareable;
import org.eclipse.core.runtime.IPath;

public class PathPair {
    private final IPath root;
    private final IPath innerPath;

    public PathPair(IShareable iShareable) {
        this.root = PathPair.normalize(iShareable.getSandbox().getRoot());
        this.innerPath = PathPair.normalize(iShareable.getLocalPath());
    }

    public PathPair(IPath iPath, IPath iPath2) {
        this.root = PathPair.normalize(iPath);
        this.innerPath = PathPair.normalize(iPath2);
    }

    private static IPath normalize(IPath iPath) {
        return iPath.makeAbsolute().removeTrailingSeparator();
    }

    public int hashCode() {
        return this.root.hashCode() + this.innerPath.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof PathPair) {
            PathPair pathPair = (PathPair)object;
            return this.getRoot().equals((Object)pathPair.getRoot()) && this.getInnerPath().equals((Object)pathPair.getInnerPath());
        }
        return false;
    }

    public IPath getRoot() {
        return this.root;
    }

    public IPath getInnerPath() {
        return this.innerPath;
    }

    public PathPair append(String string) {
        return new PathPair(this.getRoot(), this.getInnerPath().append(string));
    }

    public boolean isPrefixOf(PathPair pathPair) {
        return this.root.equals((Object)pathPair.getRoot()) && this.innerPath.isPrefixOf(pathPair.getInnerPath());
    }

    public String toString() {
        return this.root + " -> " + this.innerPath;
    }
}

