/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.ignore;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.ignore.IIgnoreEvent;
import com.ibm.team.filesystem.client.internal.ignore.IIgnoreManager;
import com.ibm.team.filesystem.client.internal.ignore.IIgnoreManager$ICopyParameter;
import com.ibm.team.filesystem.client.internal.ignore.IIgnoreManager$IIgnoreManagerCopyParameter;
import com.ibm.team.filesystem.client.internal.ignore.IIgnoreProvider;
import com.ibm.team.repository.client.util.EventSource;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class IgnoreProvider
implements IIgnoreProvider {
    private IIgnoreManager manager = null;
    private EventSource eventQueue = null;

    @Override
    public void setIgnoreManager(IIgnoreManager ignoreManager, EventSource eventQueue, IProgressMonitor progress) {
        if (this.eventQueue != null) {
            throw new IllegalStateException(Messages.IgnoreProvider_0);
        }
        this.manager = ignoreManager;
        this.eventQueue = eventQueue;
    }

    public final IIgnoreManager getIgnoreManager() {
        return this.manager;
    }

    protected void queueEvent(IIgnoreEvent event) throws FileSystemClientException {
        this.eventQueue.queueEvent((Object)event);
    }

    protected abstract void syncChangeTrackerForEvent(IShareable var1, IIgnoreEvent var2, SubMonitor var3) throws FileSystemClientException;

    @Override
    public void deallocate(IIgnoreManager ignoreManager) {
        assert (ignoreManager == this.manager);
    }

    public final IIgnoreProvider createCopy(Collection<IIgnoreManager$ICopyParameter> params, IProgressMonitor progress) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)2);
        for (IIgnoreManager$ICopyParameter icp : params) {
            if (!(icp instanceof IIgnoreManager$IIgnoreManagerCopyParameter)) continue;
            IIgnoreManager$IIgnoreManagerCopyParameter copyParam = (IIgnoreManager$IIgnoreManagerCopyParameter)icp;
            IgnoreProvider copy = this.createCopyInternal(params, copyParam.getNewIgnoreManager(), (IProgressMonitor)monitor.newChild(1));
            copy.manager = copyParam.getNewIgnoreManager();
            copy.eventQueue = copyParam.getEventQueue();
            return copy;
        }
        throw new IllegalArgumentException(NLS.bind((String)"Parameters did not include an instance of {0}", (Object)IIgnoreManager$IIgnoreManagerCopyParameter.class.getName()));
    }

    protected abstract IgnoreProvider createCopyInternal(Collection<IIgnoreManager$ICopyParameter> var1, IIgnoreManager var2, IProgressMonitor var3);
}

