/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.ignore;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.ICopyFileAreaEvent;
import com.ibm.team.filesystem.client.ICopyFileAreaListener;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.IFileStorageVisitor;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.Share;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.SharingManager$CoreRunnable;
import com.ibm.team.filesystem.client.internal.ignore.GlobalIgnoreEvent;
import com.ibm.team.filesystem.client.internal.ignore.IIgnoreEvent;
import com.ibm.team.filesystem.client.internal.ignore.IIgnoreManager;
import com.ibm.team.filesystem.client.internal.ignore.IIgnoreManager$ICopyParameter;
import com.ibm.team.filesystem.client.internal.ignore.IIgnoreManager$IIgnoreReason;
import com.ibm.team.filesystem.client.internal.ignore.IIgnoreProvider$IIgnoreRule;
import com.ibm.team.filesystem.client.internal.ignore.IIgnoreProvider$IIgnoreTester;
import com.ibm.team.filesystem.client.internal.ignore.IgnoreEvent;
import com.ibm.team.filesystem.client.internal.ignore.IgnoreFileLoader;
import com.ibm.team.filesystem.client.internal.ignore.IgnorePattern;
import com.ibm.team.filesystem.client.internal.ignore.IgnoreProvider;
import com.ibm.team.filesystem.client.internal.ignore.IgnoreRule;
import com.ibm.team.filesystem.client.internal.ignore.IgnoreRuleComparator;
import com.ibm.team.filesystem.client.internal.ignore.JazzIgnoreFile;
import com.ibm.team.filesystem.client.internal.ignore.LocalIgnoreEvent;
import com.ibm.team.filesystem.client.internal.ignore.LocalIgnoreRule;
import com.ibm.team.filesystem.client.internal.ignore.PathPair;
import com.ibm.team.filesystem.client.internal.ignore.RecursiveIgnoreRule;
import com.ibm.team.filesystem.client.internal.operations.IgnoreFileAgeDBHM;
import com.ibm.team.filesystem.client.internal.utils.LRUCache;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultIgnoreProvider
extends IgnoreProvider
implements ICopyFileAreaListener {
    public static final String EVENT_EXTERNAL_CHANGE = "external_change";
    private static final List CATEGORY_EXTERNAL_CHANGE = Collections.singletonList("external_change");
    public static final double FILE_CACHE_RATIO = 4.0;
    private static final int FILE_CACHE_MIN = 150;
    private static final int FILE_CACHE_NO_DEFAULT_CFA = 300;
    private final LRUCache<PathPair, JazzIgnoreFile> files;
    private int shareCount;
    private IgnoreFileAgeDBHM fileAges = new IgnoreFileAgeDBHM();
    private boolean shouldInvalidateCache = false;
    private IFilesystemAbstraction filesystem;
    public static final String IGNORE_FILE_NAME = ".jazzignore";
    Set<IShareable> modifiedFiles = new HashSet<IShareable>();

    private IShareable getParentFor(IShareable shareable) {
        return ((Shareable)shareable).getParent();
    }

    public static DefaultIgnoreProvider getDefault(IProgressMonitor progress) {
        return (DefaultIgnoreProvider)SharingManager.getInstance().getIgnoreManager().getIgnoreProvider("default", progress);
    }

    public DefaultIgnoreProvider() {
        this(new PassThroughFilesystemAbstraction());
    }

    public DefaultIgnoreProvider(IFilesystemAbstraction fs) {
        this.filesystem = fs;
        final SharingManager sm = SharingManager.getInstance();
        this.shareCount = 300;
        sm.addListener(this);
        this.files = new LRUCache(DefaultIgnoreProvider.computeFileCacheSize(this.shareCount));
        final LRUCache<PathPair, JazzIgnoreFile> lock = this.files;
        new Job(Messages.DefaultIgnoreProvider_2){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected IStatus run(IProgressMonitor monitor) {
                try {
                    int numShares = sm.allShares(monitor).length;
                    Object object = lock;
                    synchronized (object) {
                        int sizeChange = numShares - DefaultIgnoreProvider.this.shareCount;
                        DefaultIgnoreProvider.this.updateSize(sizeChange, Collections.EMPTY_LIST);
                    }
                }
                catch (FileSystemClientException fileSystemClientException) {}
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    @Override
    public void change(ICopyFileAreaEvent[] events) {
        int sizeChange = 0;
        LinkedList<IPath> removed = null;
        ICopyFileAreaEvent[] iCopyFileAreaEventArray = events;
        int n = events.length;
        int n2 = 0;
        while (n2 < n) {
            ICopyFileAreaEvent event = iCopyFileAreaEventArray[n2];
            switch (event.getReason()) {
                case 1: {
                    ++sizeChange;
                    break;
                }
                case 2: {
                    if (removed == null) {
                        removed = new LinkedList<IPath>();
                    }
                    removed.add(event.getPath());
                    --sizeChange;
                }
            }
            ++n2;
        }
        if (sizeChange == 0) {
            return;
        }
        this.updateSize(sizeChange, removed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateSize(int sizeChange, List<IPath> removed) {
        LRUCache<PathPair, JazzIgnoreFile> lRUCache = this.files;
        synchronized (lRUCache) {
            this.shareCount += sizeChange;
            int desiredCacheSize = DefaultIgnoreProvider.computeFileCacheSize(this.shareCount);
            this.files.setSpaceLimit(desiredCacheSize);
            if (removed != null) {
                for (IPath removedSharePath : removed) {
                    Iterator keys = this.files.keys();
                    while (keys.hasNext()) {
                        IPath key = ((PathPair)keys.next()).getInnerPath();
                        if (!removedSharePath.isPrefixOf(key)) continue;
                        keys.remove();
                    }
                }
                this.shouldInvalidateCache = true;
            }
        }
    }

    private static int computeFileCacheSize(int shareCount) {
        return (int)Math.max(150.0, (double)shareCount * 4.0);
    }

    public IgnoreRule getIgnoreRuleFor(IShareable toIgnore, boolean isGlobal) {
        IPath path = toIgnore.getLocalPath();
        String lastSegment = path.lastSegment();
        if (isGlobal) {
            return new RecursiveIgnoreRule(this.getGlobalIgnoreShareable(toIgnore), this, lastSegment, false, false);
        }
        return new LocalIgnoreRule(this.getIgnoreShareableForFolder(toIgnore, path.removeLastSegments(1)), this, lastSegment, false, false);
    }

    public List<IgnoreRule> getIgnoreRulesFor(String pattern, List<? extends IShareable> installationPoints, boolean isGlobal) {
        HashSet<IShareable> roots = new HashSet<IShareable>();
        for (IShareable iShareable : installationPoints) {
            roots.add(iShareable);
        }
        ArrayList<IgnoreRule> arrayList = new ArrayList<IgnoreRule>(roots.size());
        for (IShareable root : roots) {
            IgnoreRule rule = null;
            rule = isGlobal ? new RecursiveIgnoreRule(this.getIgnoreShareableForFolder(root, root.getLocalPath()), this, pattern, false, false) : new LocalIgnoreRule(this.getIgnoreShareableForFolder(root, root.getLocalPath()), this, pattern, false, false);
            arrayList.add(rule);
        }
        return arrayList;
    }

    public IIgnoreProvider$IIgnoreRule ignore(IShareable shareable, IProgressMonitor progress) throws FileSystemClientException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        IShare share = shareable.getShare((IProgressMonitor)monitor.newChild(1));
        if (share == null) {
            throw new FileSystemClientException((IStatus)new Status(4, "com.ibm.team.filesystem.client", String.valueOf(Messages.DefaultIgnoreProvider_3) + shareable.getLocalPath().toString()));
        }
        IShareable parent = this.getParentFor(shareable);
        if (parent == null) {
            throw new FileSystemClientException((IStatus)new Status(4, "com.ibm.team.filesystem.client", NLS.bind((String)Messages.DefaultIgnoreProvider_4, (Object)shareable.getLocalPath().toString())));
        }
        if (!this.canIgnore(shareable, (IProgressMonitor)monitor.newChild(1))) {
            throw new FileSystemClientException((IStatus)new Status(4, "com.ibm.team.filesystem.client", NLS.bind((String)Messages.DefaultIgnoreProvider_5, (Object)shareable.getLocalPath().toString())));
        }
        IgnoreRule rule = this.getIgnoreRuleFor(shareable, false);
        this.addIgnoreRule(rule, (IProgressMonitor)monitor.newChild(98));
        return rule;
    }

    public void unignore(IShareable shareable, IProgressMonitor progress) throws FileSystemClientException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress);
        try {
            IIgnoreManager$IIgnoreReason reason = this.getIgnoreManager().findIgnoreReasons(shareable, progress);
            if (reason == null) {
                throw new FileSystemClientException((IStatus)new Status(4, "com.ibm.team.filesystem.client", NLS.bind((String)Messages.DefaultIgnoreProvider_6, (Object)shareable.getLocalPath())));
            }
            if (reason.inherited()) {
                throw new FileSystemClientException((IStatus)new Status(4, "com.ibm.team.filesystem.client", NLS.bind((String)Messages.DefaultIgnoreProvider_7, (Object)shareable.getLocalPath())));
            }
            monitor.setWorkRemaining(reason.getRules().size());
            for (IIgnoreProvider$IIgnoreRule externalRule : reason.getRules()) {
                this.removeIgnoreRule((IgnoreRule)externalRule, (IProgressMonitor)monitor.newChild(1));
            }
        }
        finally {
            monitor.done();
        }
    }

    public boolean canIgnore(IShareable shareable, IProgressMonitor progress) throws FileSystemClientException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)2);
        if (shareable.getShare((IProgressMonitor)monitor.newChild(1)) == null) {
            return false;
        }
        IPath path = shareable.getLocalPath();
        if (path.segmentCount() <= 1) {
            return false;
        }
        return !this.getIgnoreManager().shouldBeIgnored(shareable, (IProgressMonitor)monitor.newChild(1));
    }

    public void accept(Collection<IShareable> roots, final IIgnoreVisitor visitor, IFilesystemAbstraction fs, IProgressMonitor progress) throws FileSystemClientException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)(roots.size() * 10));
        final MultiStatus multi = new MultiStatus("com.ibm.team.filesystem.client", 4, Messages.DefaultIgnoreProvider_8, null);
        final IFilesystemAbstraction filesystem = fs == null ? this.filesystem : fs;
        for (IShareable root : roots) {
            final boolean[] visitedGlobalIgnoreFile = new boolean[1];
            ((Shareable)root).getFileStorage().accept(new IFileStorageVisitor(){

                public boolean visit(IFileStorage storage, IProgressMonitor monitor) {
                    if (DefaultIgnoreProvider.IGNORE_FILE_NAME.equals(storage.getName())) {
                        JazzIgnoreFile file;
                        try {
                            file = IgnoreFileLoader.getInstance().load(filesystem, DefaultIgnoreProvider.this, storage.getShareable(), false, monitor);
                        }
                        catch (FileSystemClientException e) {
                            multi.add(e.getStatus());
                            return true;
                        }
                        catch (IgnoreFileLoader.FileInaccessibleException fileInaccessibleException) {
                            return true;
                        }
                        if (file == null) {
                            return true;
                        }
                        if (file.isGlobal()) {
                            visitedGlobalIgnoreFile[0] = true;
                        }
                        visitor.visit(file.getRules());
                    }
                    return true;
                }
            }, Integer.MAX_VALUE, (IProgressMonitor)monitor.newChild(9));
            if (visitedGlobalIgnoreFile[0]) continue;
            visitor.visit(this.getGlobalIgnoreFile(root, monitor.newChild(1)).getRules());
        }
        if (multi.getChildren().length > 0) {
            throw new FileSystemClientException((IStatus)multi);
        }
    }

    private void removeRule(IIgnoreProvider$IIgnoreRule passedRule, IProgressMonitor progress) throws FileSystemClientException {
        if (!(passedRule instanceof IgnoreRule)) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.DefaultIgnoreProvider_9, (Object)passedRule.getClass().getSimpleName()));
        }
        IgnoreRule rule = (IgnoreRule)passedRule;
        IShareable parent = rule.getRootShareable();
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (String)Messages.DefaultIgnoreProvider_REMOVING_ITEM_FROM_FILE, (int)5);
        JazzIgnoreFile file = this.getIgnoreFileForFolder(parent, parent.getLocalPath(), false, (IProgressMonitor)monitor.newChild(1));
        if (file == null) {
            return;
        }
        monitor.setTaskName(NLS.bind((String)Messages.DefaultIgnoreProvider_REMOVING_ITEM_FROM_FILE_WITH_NAME, (Object)file.getFile().getLocalPath().toOSString()));
        ISchedulingRule sr = this.findSchedulingRuleFor(rule.getFile(), (IProgressMonitor)monitor.newChild(1));
        try {
            Job.getJobManager().beginRule(sr, (IProgressMonitor)monitor.newChild(1));
            this.startModifyingFile(rule.getFile());
            try {
                JazzIgnoreFile newFile = file.removeRules(Collections.singleton(rule), (IProgressMonitor)monitor.newChild(1));
                this.updateCacheFor(new PathPair(parent), newFile);
            }
            finally {
                this.stopModifyingFile(rule.getFile(), monitor.newChild(1));
            }
        }
        finally {
            Job.getJobManager().endRule(sr);
            monitor.done();
        }
    }

    @Override
    public IIgnoreProvider$IIgnoreTester getTester(IShareable shareable) {
        return new DefaultIgnoreTester(shareable);
    }

    public IFilesystemAbstraction getFilesystem() {
        return this.filesystem;
    }

    private IPath getGlobalIgnoreRoot(IShareable shareable) {
        return shareable.getLocalPath().uptoSegment(1);
    }

    private JazzIgnoreFile getGlobalIgnoreFile(IShareable shareable, SubMonitor monitor) throws FileSystemClientException {
        JazzIgnoreFile file = this.getIgnoreFileForFolder(shareable, this.getGlobalIgnoreRoot(shareable), false, (IProgressMonitor)monitor);
        if (file == null) {
            file = IgnoreFileLoader.getInstance().createGlobalIgnoreFile(this, shareable);
        }
        return file;
    }

    private IShareable getGlobalIgnoreShareable(IShareable shareable) {
        IPath rootPath = this.getGlobalIgnoreRoot(shareable).append(IGNORE_FILE_NAME);
        return shareable.getSandbox().findShareable(rootPath, ResourceType.FILE);
    }

    public JazzIgnoreFile getIgnoreFileForFolder(IShareable shareable, IPath folderPath, boolean create, IProgressMonitor progress) throws FileSystemClientException {
        PathPair fullFolderPath = new PathPair(shareable.getSandbox().getRoot(), folderPath);
        return this.getIgnoreFileForFolder(shareable, fullFolderPath, create, progress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JazzIgnoreFile getIgnoreFileForFolder(IShareable shareable, PathPair fullFolderPath, boolean create, IProgressMonitor progress) throws FileSystemClientException {
        JazzIgnoreFile file;
        LRUCache<PathPair, JazzIgnoreFile> lRUCache = this.files;
        synchronized (lRUCache) {
            if (this.files.containsKey((Object)fullFolderPath)) {
                JazzIgnoreFile file2 = (JazzIgnoreFile)this.files.get((Object)fullFolderPath);
                if (file2 != null) {
                    return file2;
                }
                if (!create) {
                    return null;
                }
            }
        }
        IShareable ignoreFile = this.getIgnoreShareableForFolder(shareable, fullFolderPath);
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        try {
            file = IgnoreFileLoader.getInstance().load(this, ignoreFile, create, (IProgressMonitor)monitor.newChild(90));
        }
        catch (IgnoreFileLoader.FileInaccessibleException fileInaccessibleException) {
            LRUCache<PathPair, JazzIgnoreFile> lRUCache2 = this.files;
            synchronized (lRUCache2) {
                return (JazzIgnoreFile)this.files.get((Object)fullFolderPath);
            }
        }
        LRUCache<PathPair, JazzIgnoreFile> lRUCache3 = this.files;
        synchronized (lRUCache3) {
            this.files.put((Object)fullFolderPath, (Object)file);
            if (file == null) {
                this.fileAges.remove(fullFolderPath);
            } else {
                IgnoreFileAgeDBHM.DateStamp lastModified = this.filesystem.lastModified(shareable);
                long size = this.filesystem.size(shareable, (IProgressMonitor)monitor.newChild(10));
                this.fileAges.put(fullFolderPath, lastModified, size);
            }
            return file;
        }
    }

    private IShareable getIgnoreShareableForFolder(IShareable shareable, IPath folderPath) {
        return this.getIgnoreShareableForFolder(shareable, new PathPair(shareable.getSandbox().getRoot(), folderPath));
    }

    private IShareable getIgnoreShareableForFolder(IShareable shareable, PathPair folderPath) {
        assert (folderPath.getRoot() == null || folderPath.getRoot().equals((Object)shareable.getSandbox().getRoot()));
        ISandbox sandbox = SharingManager.getInstance().getSandbox(folderPath.getRoot(), false);
        return sandbox.findShareable(folderPath.getInnerPath().append(IGNORE_FILE_NAME), ResourceType.FILE);
    }

    private IShareable getShareableForPath(IShareable peer, IPath shareablePath, ResourceType typeHint) {
        return peer.getSandbox().findShareable(shareablePath, typeHint);
    }

    public IStatus ignoreFilesChanged(List<IShareable> ignoreFiles, IProgressMonitor progress) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)(ignoreFiles.size() * 3));
        MultiStatus multi = new MultiStatus("com.ibm.team.filesystem.client", -1, Messages.DefaultIgnoreProvider_10, null);
        SharingManager sm = SharingManager.getInstance();
        for (IShareable shareable : ignoreFiles) {
            IgnoreEvent event;
            try {
                ISchedulingRule rule = sm.makeSchedulingRuleForIDE(Collections.singleton(shareable));
                try {
                    Job.getJobManager().beginRule(rule, (IProgressMonitor)monitor.newChild(1));
                    event = this.ignoreFileChanged(shareable, (IProgressMonitor)monitor.newChild(1));
                }
                finally {
                    Job.getJobManager().endRule(rule);
                }
            }
            catch (FileSystemClientException e) {
                multi.add(e.getStatus());
                continue;
            }
            if (event != null) {
                try {
                    this.queueEvent(((Shareable)shareable).getParent(), event, (IProgressMonitor)monitor.newChild(1));
                }
                catch (FileSystemClientException e) {
                    multi.add((IStatus)new Status(4, "com.ibm.team.filesystem.client", NLS.bind((String)Messages.DefaultIgnoreProvider_11, (Object)shareable.getLocalPath()), (Throwable)((Object)e)));
                }
                continue;
            }
            monitor.newChild(1);
        }
        monitor.done();
        if (multi.getChildren().length > 0) {
            return multi;
        }
        return Status.OK_STATUS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IgnoreEvent ignoreFileChanged(IShareable shareable, IProgressMonitor progress) throws FileSystemClientException {
        String type;
        JazzIgnoreFile currentFile;
        IShareable parent;
        SubMonitor monitor;
        block31: {
            PathPair parentPath;
            block28: {
                LRUCache<PathPair, JazzIgnoreFile> lRUCache;
                block29: {
                    block30: {
                        JazzIgnoreFile cachedFile;
                        boolean containsKey;
                        Assert.isTrue((boolean)shareable.getLocalPath().lastSegment().equals(IGNORE_FILE_NAME));
                        monitor = SubMonitor.convert((IProgressMonitor)progress, (int)5);
                        Set<IShareable> set = this.modifiedFiles;
                        synchronized (set) {
                            if (this.modifiedFiles.contains(shareable)) {
                                return null;
                            }
                        }
                        IgnoreFileAgeDBHM.DateStamp lastModified = this.filesystem.lastModified(shareable);
                        long size = this.filesystem.size(shareable, (IProgressMonitor)monitor.newChild(1));
                        IPath path = shareable.getLocalPath().removeLastSegments(1);
                        LRUCache<PathPair, JazzIgnoreFile> lRUCache2 = this.files;
                        synchronized (lRUCache2) {
                            if (!this.fileAges.shouldReload(new PathPair(shareable.getSandbox().getRoot(), path), lastModified, size)) {
                                return null;
                            }
                        }
                        IShare share = shareable.getShare((IProgressMonitor)monitor.newChild(1));
                        if (share == null) {
                            return null;
                        }
                        parent = this.getParentFor(shareable);
                        if (parent != null && parent.shouldBeIgnored((IProgressMonitor)monitor.newChild(1))) {
                            return null;
                        }
                        parent = this.getParentFor(shareable);
                        parentPath = new PathPair(shareable.getSandbox().getRoot(), parent.getLocalPath());
                        boolean exists = shareable.exists((IProgressMonitor)monitor.newChild(1));
                        LRUCache<PathPair, JazzIgnoreFile> lRUCache3 = this.files;
                        synchronized (lRUCache3) {
                            containsKey = this.files.containsKey((Object)parentPath);
                            cachedFile = (JazzIgnoreFile)this.files.get((Object)parentPath);
                            this.shouldInvalidateCache = true;
                        }
                        currentFile = null;
                        type = null;
                        if (!containsKey) break block28;
                        if (!exists) break block29;
                        if (cachedFile != null) break block30;
                        lRUCache = this.files;
                        synchronized (lRUCache) {
                            this.files.removeKey((Object)parentPath);
                        }
                        currentFile = this.getIgnoreFileForFolder(shareable, parentPath, false, (IProgressMonitor)monitor.newChild(1));
                        if (currentFile == null) {
                            lRUCache = this.files;
                            synchronized (lRUCache) {
                                this.files.removeKey((Object)parentPath);
                                this.fileAges.remove(parentPath);
                            }
                            type = "unignore";
                            break block31;
                        } else {
                            type = "ignore";
                        }
                        break block31;
                    }
                    type = "unknown";
                    lRUCache = this.files;
                    synchronized (lRUCache) {
                        this.files.removeKey((Object)parentPath);
                    }
                    currentFile = this.getIgnoreFileForFolder(shareable, parentPath, false, (IProgressMonitor)monitor.newChild(1));
                    break block31;
                }
                type = "unignore";
                lRUCache = this.files;
                synchronized (lRUCache) {
                    this.files.removeKey((Object)parentPath);
                    this.fileAges.remove(parentPath);
                }
            }
            type = "unknown";
            currentFile = this.getIgnoreFileForFolder(shareable, parentPath, false, (IProgressMonitor)monitor.newChild(1));
        }
        SortedSet<IgnoreRule> rules = currentFile == null ? null : currentFile.getRules();
        monitor.done();
        if (this.getGlobalIgnoreRoot(shareable).equals((Object)shareable)) {
            return new GlobalIgnoreEvent(this.getIgnoreManager(), shareable, parent, type, (List<Object>)CATEGORY_EXTERNAL_CHANGE, rules);
        }
        return new LocalIgnoreEvent(this.getIgnoreManager(), shareable, parent, type, (List<Object>)CATEGORY_EXTERNAL_CHANGE, rules);
    }

    private void verifyRule(IIgnoreProvider$IIgnoreRule rule) {
        if (rule == null) {
            throw new IllegalArgumentException(Messages.DefaultIgnoreProvider_12);
        }
        if (rule.getProvider() != this) {
            throw new IllegalArgumentException(Messages.DefaultIgnoreProvider_13);
        }
        if (!(rule instanceof IgnoreRule)) {
            throw new IllegalArgumentException(Messages.DefaultIgnoreProvider_14);
        }
    }

    private void verifyRules(Collection<? extends IIgnoreProvider$IIgnoreRule> rules) {
        for (IIgnoreProvider$IIgnoreRule iIgnoreProvider$IIgnoreRule : rules) {
            this.verifyRule(iIgnoreProvider$IIgnoreRule);
        }
    }

    public void addIgnoreRule(IIgnoreProvider$IIgnoreRule externalRule, IProgressMonitor progress) throws FileSystemClientException {
        this.addIgnoreRules(Collections.singleton(externalRule), progress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCacheFor(PathPair parentPath, JazzIgnoreFile file) {
        LRUCache<PathPair, JazzIgnoreFile> lRUCache = this.files;
        synchronized (lRUCache) {
            this.files.put((Object)parentPath, (Object)file);
            if (file == null) {
                this.fileAges.remove(parentPath);
            } else {
                this.fileAges.put(parentPath, file.getLastModified(), file.getSize());
            }
        }
    }

    private ISchedulingRule findSchedulingRuleFor(IShareable shareable, IProgressMonitor monitor) throws FileSystemClientException {
        IShare share = shareable.getShare(monitor);
        if (share == null) {
            return null;
        }
        return SharingManager.getInstance().getTrackingRule(share.getSandbox().getRoot());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIgnoreRules(Collection<? extends IIgnoreProvider$IIgnoreRule> allRules, IProgressMonitor progress) throws FileSystemClientException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        monitor.setTaskName(Messages.DefaultIgnoreProvider_15);
        this.verifyRules(allRules);
        Map<JazzIgnoreFile, Collection<IgnoreRule>> rulesByOwner = this.groupRulesByOwner(allRules, monitor.newChild(10));
        monitor.setWorkRemaining(rulesByOwner.size() * 6);
        for (Map.Entry<JazzIgnoreFile, Collection<IgnoreRule>> entry : rulesByOwner.entrySet()) {
            IgnoreEvent event;
            Collection<IgnoreRule> rules;
            JazzIgnoreFile file = entry.getKey();
            Collection<IgnoreRule> added = file.computeComplement(rules = entry.getValue());
            if (added.isEmpty()) continue;
            IShareable shareable = file.getFile();
            ISchedulingRule rule = this.findSchedulingRuleFor(shareable, (IProgressMonitor)monitor.newChild(1));
            try {
                Job.getJobManager().beginRule(rule, (IProgressMonitor)monitor.newChild(1));
                this.startModifyingFile(shareable);
                try {
                    JazzIgnoreFile newFile = file.addRules(added, (IProgressMonitor)monitor.newChild(1));
                    this.updateCacheFor(new PathPair(file.getRootShareable()), newFile);
                    LRUCache<PathPair, JazzIgnoreFile> lRUCache = this.files;
                    synchronized (lRUCache) {
                        this.shouldInvalidateCache = true;
                    }
                }
                finally {
                    this.stopModifyingFile(shareable, monitor.newChild(1));
                }
            }
            finally {
                Job.getJobManager().endRule(rule);
            }
            ArrayList<IgnoreRule> recursiveRules = new ArrayList<IgnoreRule>(rules.size());
            ArrayList<IgnoreRule> localRules = new ArrayList<IgnoreRule>(rules.size());
            this.splitRulesByScope(added, recursiveRules, localRules);
            if (recursiveRules.size() > 0) {
                event = new GlobalIgnoreEvent(this.getIgnoreManager(), file.getFile(), file.getRootShareable(), "ignore", (List<Object>)Collections.EMPTY_LIST, recursiveRules);
                this.queueEvent(file.getRootShareable(), event, (IProgressMonitor)monitor.newChild(1));
            }
            if (localRules.size() <= 0) continue;
            event = new LocalIgnoreEvent(this.getIgnoreManager(), file.getFile(), file.getRootShareable(), "ignore", (List<Object>)Collections.EMPTY_LIST, rules);
            this.queueEvent(file.getRootShareable(), event, (IProgressMonitor)monitor.newChild(1));
        }
    }

    private Map<JazzIgnoreFile, Collection<IgnoreRule>> groupRulesByOwner(Collection<? extends IIgnoreProvider$IIgnoreRule> rules, SubMonitor monitor) throws FileSystemClientException {
        HashMap<JazzIgnoreFile, Collection<IgnoreRule>> grouping = new HashMap<JazzIgnoreFile, Collection<IgnoreRule>>();
        monitor.beginTask(Messages.DefaultIgnoreProvider_CATEGORIZING_IGNORE_RULES_BY_FILENAME, rules.size());
        for (IIgnoreProvider$IIgnoreRule iIgnoreProvider$IIgnoreRule : rules) {
            IgnoreRule rule = (IgnoreRule)iIgnoreProvider$IIgnoreRule;
            IShareable rootShareable = rule.getRootShareable();
            JazzIgnoreFile owner = this.getIgnoreFileForFolder(rootShareable, rootShareable.getLocalPath(), true, (IProgressMonitor)monitor.newChild(1));
            Collection<IgnoreRule> associatedWithFile = grouping.get(owner);
            if (associatedWithFile == null) {
                associatedWithFile = new LinkedList<IgnoreRule>();
                grouping.put(owner, associatedWithFile);
            }
            associatedWithFile.add(rule);
        }
        monitor.done();
        return grouping;
    }

    private void splitRulesByScope(Collection<IgnoreRule> allRules, Collection<IgnoreRule> recursive, Collection<IgnoreRule> local) {
        for (IgnoreRule rule : allRules) {
            if (rule.isRecursive()) {
                recursive.add(rule);
                continue;
            }
            local.add(rule);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends IIgnoreProvider$IIgnoreRule> void removeIgnoreRule(T externalRule, IProgressMonitor progress) throws FileSystemClientException {
        this.verifyRule(externalRule);
        IgnoreRule rule = (IgnoreRule)externalRule;
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)4);
        this.removeRule(rule, (IProgressMonitor)monitor.newChild(1));
        LRUCache<PathPair, JazzIgnoreFile> lRUCache = this.files;
        synchronized (lRUCache) {
            this.shouldInvalidateCache = true;
        }
        IgnoreEvent event = null;
        event = rule.isRecursive() ? new GlobalIgnoreEvent(this.getIgnoreManager(), rule.getFile(), rule.getRootShareable(), "unignore", (List<Object>)Collections.EMPTY_LIST, Collections.singletonList(rule)) : new LocalIgnoreEvent(this.getIgnoreManager(), rule.getFile(), rule.getRootShareable(), "unignore", (List<Object>)Collections.EMPTY_LIST, Collections.singletonList(rule));
        this.queueEvent(rule.getRootShareable(), event, (IProgressMonitor)monitor.newChild(3));
        monitor.done();
    }

    public void removeIgnoreRules(List<? extends IIgnoreProvider$IIgnoreRule> externalRules, IProgressMonitor progress) throws FileSystemClientException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)externalRules.size());
        for (IIgnoreProvider$IIgnoreRule iIgnoreProvider$IIgnoreRule : externalRules) {
            this.removeIgnoreRule(iIgnoreProvider$IIgnoreRule, (IProgressMonitor)monitor.newChild(1));
        }
        monitor.done();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startModifyingFile(IShareable file) {
        Set<IShareable> set = this.modifiedFiles;
        synchronized (set) {
            if (!this.modifiedFiles.add(file)) {
                throw new RuntimeException(NLS.bind((String)Messages.DefaultIgnoreProvider_16, (Object)file));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopModifyingFile(IShareable file, SubMonitor monitor) {
        Set<IShareable> set = this.modifiedFiles;
        synchronized (set) {
            if (!this.modifiedFiles.remove(file)) {
                throw new RuntimeException(NLS.bind((String)Messages.DefaultIgnoreProvider_17, (Object)file));
            }
        }
        this.ignoreFilesChanged(Collections.singletonList(file), (IProgressMonitor)monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearFileCache() {
        LRUCache<PathPair, JazzIgnoreFile> lRUCache = this.files;
        synchronized (lRUCache) {
            this.files.flush();
            this.fileAges.clear();
            this.shouldInvalidateCache = true;
        }
    }

    @Override
    protected IgnoreProvider createCopyInternal(Collection<IIgnoreManager$ICopyParameter> params, IIgnoreManager ignoreManager, IProgressMonitor progress) {
        IFilesystemAbstraction abs = null;
        for (IIgnoreManager$ICopyParameter param : params) {
            IDefaultIgnoreProviderCopyReason myReason;
            IFilesystemAbstraction preferred;
            if (!(param instanceof IDefaultIgnoreProviderCopyReason) || (preferred = (myReason = (IDefaultIgnoreProviderCopyReason)param).useFilesystemAbstraction(this.filesystem)) == null) continue;
            assert (abs == null) : "IFilesystemAbstraction set twice. Original: " + abs + " new: " + preferred;
            abs = preferred;
        }
        if (abs == null) {
            abs = (IFilesystemAbstraction)this.filesystem.clone();
        }
        return new DefaultIgnoreProvider(abs);
    }

    @Override
    protected void syncChangeTrackerForEvent(IShareable ignoreRoot, IIgnoreEvent event, SubMonitor monitor) throws FileSystemClientException {
        Share share = (Share)ignoreRoot.getShare((IProgressMonitor)(monitor = SubMonitor.convert((IProgressMonitor)monitor, (int)3)).newChild(1));
        if (share == null) {
            return;
        }
        Collection<IShareable> changed = event.getChanged((IProgressMonitor)monitor);
        if (changed == null) {
            if (ignoreRoot == null) {
                throw new IllegalArgumentException(Messages.DefaultIgnoreProvider_18);
            }
            share.refreshChanges(ignoreRoot, (IProgressMonitor)monitor.newChild(1));
            return;
        }
        Assert.isNotNull(changed);
        monitor.setWorkRemaining(changed.size());
        for (IShareable shareable : changed) {
            SubMonitor subMonitor = monitor.newChild(1);
            share.refreshChanges(shareable, (IProgressMonitor)subMonitor);
            subMonitor.done();
        }
    }

    protected void queueEvent(IShareable ignoreRoot, IIgnoreEvent event, IProgressMonitor progress) throws FileSystemClientException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress);
        this.syncChangeTrackerForEvent(ignoreRoot, event, monitor);
        monitor.done();
        super.queueEvent(event);
    }

    public byte[] getIgnoreFileContents(IPath path, Collection<String> globalPatterns, Collection<String> localPatterns) throws FileSystemClientException {
        boolean isGlobal;
        boolean bl = isGlobal = path.segmentCount() == 1;
        if (!isGlobal && globalPatterns != null) {
            throw new IllegalArgumentException(Messages.DefaultIgnoreProvider_19);
        }
        TreeSet<IgnoreRule> rules = new TreeSet<IgnoreRule>(IgnoreRuleComparator.INSTANCE);
        if (globalPatterns != null) {
            for (String pattern : globalPatterns) {
                rules.add(new RecursiveIgnoreRule(null, this, pattern, false, false));
            }
        }
        if (localPatterns != null) {
            for (String pattern : localPatterns) {
                rules.add(new LocalIgnoreRule(null, this, pattern, false, false));
            }
        }
        return IgnoreFileLoader.getInstance().asBytes(path.append(IGNORE_FILE_NAME), rules);
    }

    public Collection<IgnorePattern> getDefaultIgnorePatterns(IPath path) {
        if (path.segmentCount() < 1) {
            throw new IllegalArgumentException();
        }
        return IgnoreFileLoader.getInstance().getDefaultIgnorePatterns(path.append(IGNORE_FILE_NAME));
    }

    @Override
    public void deallocate(IIgnoreManager ignoreManager) {
        super.deallocate(ignoreManager);
        SharingManager.getInstance().removeListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFileCacheSize() {
        LRUCache<PathPair, JazzIgnoreFile> lRUCache = this.files;
        synchronized (lRUCache) {
            return this.files.getSpaceLimit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushInAbsenceOfEvents(Collection<IShareable> roots, IProgressMonitor progress) {
        LRUCache<PathPair, JazzIgnoreFile> lRUCache = this.files;
        synchronized (lRUCache) {
            if (roots == null) {
                this.files.flush();
                return;
            }
            SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)(roots.size() * this.files.getCurrentSpace()));
            for (IShareable root : roots) {
                if (root == null || root.getLocalPath().segmentCount() < 2) {
                    monitor.worked(this.files.getCurrentSpace());
                    continue;
                }
                IShareable parent = null;
                PathPair rootPair = new PathPair(root);
                Iterator i = this.files.keys();
                while (i.hasNext()) {
                    PathPair loc = (PathPair)i.next();
                    if (rootPair.isPrefixOf(loc)) {
                        if (parent == null) {
                            parent = ((Shareable)root).getParent();
                        }
                        boolean remove = false;
                        try {
                            long size = this.filesystem.size(parent, (IProgressMonitor)monitor.newChild(1));
                            if (this.fileAges.shouldReload(loc, this.filesystem.lastModified(parent), size)) {
                                remove = true;
                            }
                        }
                        catch (FileSystemClientException fileSystemClientException) {
                            remove = true;
                        }
                        if (!remove) continue;
                        i.remove();
                        continue;
                    }
                    monitor.worked(1);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DefaultIgnoreTester
    implements IIgnoreProvider$IIgnoreTester {
        public DefaultIgnoreTester(IShareable shareable) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean shouldInvalidateCache(IShareable shareable) {
            LRUCache lRUCache = DefaultIgnoreProvider.this.files;
            synchronized (lRUCache) {
                boolean result = DefaultIgnoreProvider.this.shouldInvalidateCache;
                if (result) {
                    DefaultIgnoreProvider.this.shouldInvalidateCache = false;
                }
                return result;
            }
        }

        @Override
        public boolean shouldBeIgnored(IShareable shareable, IPath path, IProgressMonitor progress) {
            if (path.segmentCount() < 2) {
                return false;
            }
            SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)2);
            int segmentCount = path.segmentCount();
            int i = 1;
            while (i < segmentCount) {
                IPath walker = path.uptoSegment(i);
                JazzIgnoreFile ignoreFile = null;
                try {
                    ignoreFile = walker.segmentCount() == 1 ? DefaultIgnoreProvider.this.getGlobalIgnoreFile(shareable, monitor.newChild(1)) : DefaultIgnoreProvider.this.getIgnoreFileForFolder(shareable, walker, false, (IProgressMonitor)monitor.newChild(1));
                }
                catch (FileSystemClientException fileSystemClientException) {}
                if (ignoreFile != null) {
                    boolean isCurrentDir = i == segmentCount - 1;
                    for (IgnoreRule rule : ignoreFile.getRules()) {
                        if (!rule.isRecursive() && !isCurrentDir || !rule.shouldBeIgnored(path)) continue;
                        return true;
                    }
                }
                ++i;
            }
            return false;
        }

        @Override
        public List<IIgnoreProvider$IIgnoreRule> findIgnoreReasons(IShareable shareable, IPath path, IProgressMonitor progress) {
            if (path.segmentCount() < 2) {
                return Collections.emptyList();
            }
            SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)2);
            ArrayList<IIgnoreProvider$IIgnoreRule> result = new ArrayList<IIgnoreProvider$IIgnoreRule>(2);
            int segmentCount = path.segmentCount();
            int i = 1;
            while (i < segmentCount) {
                IPath walker = path.uptoSegment(i);
                JazzIgnoreFile ignoreFile = null;
                try {
                    ignoreFile = walker.segmentCount() == 1 ? DefaultIgnoreProvider.this.getGlobalIgnoreFile(shareable, monitor.newChild(1)) : DefaultIgnoreProvider.this.getIgnoreFileForFolder(shareable, walker, false, (IProgressMonitor)monitor.newChild(1));
                }
                catch (FileSystemClientException fileSystemClientException) {}
                if (ignoreFile != null) {
                    boolean isCurrentDir = i == segmentCount - 1;
                    for (IgnoreRule rule : ignoreFile.getRules()) {
                        if (!rule.isRecursive() && !isCurrentDir || !rule.shouldBeIgnored(path)) continue;
                        result.add(rule);
                    }
                }
                if (result.size() > 0) {
                    return result;
                }
                ++i;
            }
            return result;
        }

        @Override
        public void done() {
        }
    }

    public static interface IDefaultIgnoreProviderCopyReason
    extends IIgnoreManager$ICopyParameter {
        public IFilesystemAbstraction useFilesystemAbstraction(IFilesystemAbstraction var1);
    }

    public static interface IFilesystemAbstraction
    extends Cloneable {
        public static final IgnoreFileAgeDBHM.DateStamp NULL_MOD = new IgnoreFileAgeDBHM.DateStamp(-1L, -1L);
        public static final long NULL_SIZE = -2L;

        public boolean exists(IShareable var1, IProgressMonitor var2) throws FileSystemClientException;

        public InputStream read(IShareable var1, IProgressMonitor var2) throws FileSystemClientException, IgnoreFileLoader.FileInaccessibleException;

        public void write(IShareable var1, InputStream var2, IProgressMonitor var3) throws FileSystemClientException;

        public IgnoreFileAgeDBHM.DateStamp lastModified(IShareable var1);

        public long size(IShareable var1, IProgressMonitor var2) throws FileSystemClientException;

        public Object clone();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface IIgnoreVisitor {
        public void visit(Collection<IgnoreRule> var1);
    }

    public static class PassThroughFilesystemAbstraction
    implements IFilesystemAbstraction {
        public boolean exists(IShareable file, IProgressMonitor progress) throws FileSystemClientException {
            return file.exists(progress);
        }

        public InputStream read(final IShareable file, IProgressMonitor progress) throws FileSystemClientException, IgnoreFileLoader.FileInaccessibleException {
            final InputStream[] stream = new InputStream[1];
            try {
                if (file.exists(progress)) {
                    SharingManager.getInstance().doSilentChange(new SharingManager$CoreRunnable(){

                        public void run() throws CoreException {
                            stream[0] = ((Shareable)file).getFileStorage().getContents(true);
                        }
                    });
                }
            }
            catch (CoreException coreException) {
                throw new IgnoreFileLoader.FileInaccessibleException();
            }
            return stream[0];
        }

        public void write(IShareable file, InputStream in, IProgressMonitor monitor) throws FileSystemClientException {
            IFileStorage store = ((Shareable)file).getFileStorage();
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            if (file.exists((IProgressMonitor)progress.newChild(1))) {
                store.setContents(in, false, (IProgressMonitor)progress.newChild(99));
            } else {
                store.create(in, monitor);
            }
        }

        public IgnoreFileAgeDBHM.DateStamp lastModified(IShareable file) {
            return new IgnoreFileAgeDBHM.DateStamp(((Shareable)file).getFileStorage());
        }

        public long size(IShareable file, IProgressMonitor monitor) throws FileSystemClientException {
            try {
                SharingManager.getInstance().disableChangeMonitoring();
                long l = ((Shareable)file).getFileStorage().getSize(monitor);
                return l;
            }
            finally {
                SharingManager.getInstance().enableChangeMonitoring();
            }
        }

        public Object clone() {
            return new PassThroughFilesystemAbstraction();
        }
    }
}

