/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.era;

import com.ibm.team.filesystem.client.internal.FunctionCache;
import com.ibm.team.filesystem.client.internal.era.ClientEraDescriptor;
import com.ibm.team.filesystem.client.internal.era.DeliveryInfo;
import com.ibm.team.filesystem.client.internal.era.EmptyEraDescriptor;
import com.ibm.team.filesystem.client.internal.era.EraRootComputer;
import com.ibm.team.filesystem.client.internal.era.EraSyncReport;
import com.ibm.team.filesystem.client.internal.era.LiveChangeHistoryCache;
import com.ibm.team.filesystem.client.internal.era.StaticEraDescriptor;
import com.ibm.team.filesystem.client.internal.namespace.WorkspaceNamespace;
import com.ibm.team.filesystem.client.internal.namespace.impl.EraCache;
import com.ibm.team.filesystem.common.changemodel.VersionablePath;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.common.IRemoteFunction;
import com.ibm.team.repository.rcp.common.NullUtil;
import com.ibm.team.scm.client.IChangeHistory;
import com.ibm.team.scm.client.internal.RepoFetcher;
import com.ibm.team.scm.common.ComponentNotInWorkspaceException;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.IChangeHistorySyncReport;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.ItemLists;
import com.ibm.team.scm.common.internal.util.NewCollection;
import com.ibm.team.scm.common.internal.util.StateId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EraDescriptor {
    public abstract ItemId<IComponent> getComponent();

    public abstract ITeamRepository getRepository();

    public abstract EraDescriptor getPreviousEra(IProgressMonitor var1) throws TeamRepositoryException;

    public final List<ItemId<IChangeSet>> getChangeSets(IProgressMonitor monitor) throws TeamRepositoryException {
        return DeliveryInfo.getChangeSetList(this.getDeliveries(monitor));
    }

    public abstract List<DeliveryInfo> getDeliveries(IProgressMonitor var1) throws TeamRepositoryException;

    public abstract Map<ItemId<IChangeSet>, StateId<IChangeSet>> getActiveChangeSetStates();

    public static EraDescriptor create(ITeamRepository repository, EraDescriptor previous, List<DeliveryInfo> changeSets, ItemId<IComponent> component, IRemoteFunction<ItemId<IFolder>> rootComputer) {
        return ClientEraDescriptor.createDescriptor(repository, previous, changeSets, Collections.EMPTY_MAP, 0, changeSets.size(), component, rootComputer);
    }

    public static EraDescriptor createEmptyEra(ITeamRepository repository, ItemId<IComponent> component) {
        return new EmptyEraDescriptor(repository, component);
    }

    public abstract IChangeHistory getChangeHistory();

    public final EraDescriptor discardLast(IProgressMonitor monitor) throws TeamRepositoryException {
        return this.discardLast(1, monitor);
    }

    public static EraDescriptor createStaticDescriptor(IChangeHistory history) {
        if (history == null) {
            throw new IllegalArgumentException("history must not be null");
        }
        if (history.isLive()) {
            throw new IllegalArgumentException("Era must not be live");
        }
        return new StaticEraDescriptor(history);
    }

    public static EraDescriptor createLiveHistory(WorkspaceNamespace workspace, boolean refresh, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (workspace == null) {
            throw new IllegalArgumentException("history must not be null");
        }
        try {
            EraDescriptor previousSnapshot;
            ITeamRepository repo = workspace.getRepository();
            LiveChangeHistoryCache.CachedChangeHistory cachedHistory = LiveChangeHistoryCache.fetchRecent(workspace, monitor);
            List<DeliveryInfo> changeSets = cachedHistory.getRecent();
            IChangeHistory previous = cachedHistory.getPrevious();
            IChangeHistory history = cachedHistory.getCurrent();
            EraDescriptor eraDescriptor = previousSnapshot = previous == null ? EraDescriptor.createEmptyEra(repo, workspace.getComponentId()) : EraDescriptor.createStaticDescriptor(previous);
            if (changeSets.isEmpty() || history == null) {
                return previousSnapshot;
            }
            return EraDescriptor.createWithActiveChanges(changeSets, repo, previousSnapshot, workspace.getComponentId(), refresh, new EraRootComputer(history), (IProgressMonitor)progress);
        }
        catch (ComponentNotInWorkspaceException componentNotInWorkspaceException) {
            return EraDescriptor.createEmptyEra(workspace.getRepository(), workspace.getComponentId());
        }
    }

    public static EraDescriptor createWithActiveChanges(ITeamRepository repository, EraDescriptor previousSnapshot, List<DeliveryInfo> changeSets, ItemId<IComponent> component, IRemoteFunction<ItemId<IFolder>> rootComputer, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        Map fetched = RepoFetcher.fetchCurrents((ITeamRepository)repository, DeliveryInfo.getChangeSetList(changeSets), (IProgressMonitor)progress.newChild(100));
        HashMap<ItemId<IChangeSet>, StateId<IChangeSet>> activeChangeStates = new HashMap<ItemId<IChangeSet>, StateId<IChangeSet>>();
        for (IChangeSet next : fetched.values()) {
            if (!next.isActive()) continue;
            activeChangeStates.put((ItemId<IChangeSet>)ItemId.forItem((IItem)next), (StateId<IChangeSet>)StateId.forItem((IItem)next));
        }
        return EraDescriptor.createWithActiveChanges(repository, previousSnapshot, changeSets, activeChangeStates, component, rootComputer);
    }

    public static EraDescriptor createWithActiveChanges(ITeamRepository repository, EraDescriptor previousSnapshot, List<DeliveryInfo> changeSets, Map<ItemId<IChangeSet>, StateId<IChangeSet>> activeChanges, ItemId<IComponent> component, IRemoteFunction<ItemId<IFolder>> rootComputer) {
        return ClientEraDescriptor.createDescriptor(repository, previousSnapshot, changeSets, activeChanges, 0, changeSets.size(), component, rootComputer);
    }

    private static EraDescriptor createWithActiveChanges(List<DeliveryInfo> changeSets, ITeamRepository repository, EraDescriptor previousSnapshot, ItemId<IComponent> component, boolean refresh, IRemoteFunction<ItemId<IFolder>> rootComputer, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        HashMap activeChangeSets = NewCollection.hashMap();
        SubMonitor activeChangeSetsProgress = progress.newChild(10);
        HashMap fetchedChanges = NewCollection.hashMap();
        List<ItemId<IChangeSet>> changeSetList = DeliveryInfo.getChangeSetList(changeSets);
        int idx = changeSetList.size() - 1;
        while (idx >= 0) {
            activeChangeSetsProgress.setWorkRemaining(2);
            ItemId<IChangeSet> nextChange = changeSetList.get(idx);
            IChangeSet changeSet = (IChangeSet)fetchedChanges.get(nextChange);
            if (changeSet == null) {
                List<ItemId<IChangeSet>> changeSetsToFetch = changeSetList.subList(Math.max(0, idx - 1), idx + 1);
                fetchedChanges.putAll(RepoFetcher.fetchCurrents((ITeamRepository)repository, changeSetsToFetch, (boolean)refresh, (IProgressMonitor)activeChangeSetsProgress.newChild(1)));
                changeSet = (IChangeSet)fetchedChanges.get(nextChange);
            }
            if (changeSet == null || !changeSet.isActive()) break;
            StateId state = new StateId((IItemHandle)changeSet);
            activeChangeSets.put(state.getItemId(), state);
            --idx;
        }
        return ClientEraDescriptor.createDescriptor(repository, previousSnapshot, changeSets, activeChangeSets, 0, changeSets.size(), component, rootComputer);
    }

    public final IChangeSet fetchChangeSet(int index, boolean sharedItem, IProgressMonitor monitor) throws TeamRepositoryException {
        return EraCache.getDefault().fetchChangeSet(this, index, sharedItem, monitor);
    }

    public final DeliveryInfo fetchDelivery(int index, IProgressMonitor monitor) throws TeamRepositoryException {
        return EraCache.getDefault().fetchDelivery(this, index, monitor);
    }

    public final Map<String, ItemId<IVersionable>> fetchChildren(ItemId<IFolder> handle, IProgressMonitor monitor) throws TeamRepositoryException {
        return FunctionCache.getDefault().compute(new ChildComputer(this, handle), false, monitor);
    }

    protected abstract Map<String, ItemId<IVersionable>> doFetchChildren(ItemId<IFolder> var1, IProgressMonitor var2) throws TeamRepositoryException;

    public abstract boolean isEmpty();

    public final EraSyncReport compare(EraDescriptor other, IProgressMonitor monitor) throws TeamRepositoryException {
        return EraDescriptor.compare(this, other, monitor);
    }

    public static EraSyncReport compare(EraDescriptor snapshot1, EraDescriptor snapshot2, IProgressMonitor monitor) throws TeamRepositoryException {
        ItemId nextId;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (NullUtil.equals((Object)snapshot1, (Object)snapshot2)) {
            return new EraSyncReport();
        }
        StaticEraDescriptor static1 = EraDescriptor.findStaticAncestor(snapshot1, null, (IProgressMonitor)progress.newChild(10));
        StaticEraDescriptor static2 = EraDescriptor.findStaticAncestor(snapshot2, null, (IProgressMonitor)progress.newChild(10));
        EraSyncReport staticReport = EraDescriptor.compareStaticSnapshots(static1, static2, (IProgressMonitor)progress.newChild(50));
        List additionalIncoming = EraDescriptor.computeAllChangeSets(snapshot2, static2, (IProgressMonitor)progress.newChild(10));
        List additionalOutgoing = EraDescriptor.computeAllChangeSets(snapshot1, static1, (IProgressMonitor)progress.newChild(10));
        Map<ItemId<IChangeSet>, StateId<IChangeSet>> incomingActiveStateSelections = EraDescriptor.computeActiveStateSelections(snapshot2, static2, (IProgressMonitor)progress.newChild(5));
        Map<ItemId<IChangeSet>, StateId<IChangeSet>> outgoingActiveStateSelections = EraDescriptor.computeActiveStateSelections(snapshot1, static1, (IProgressMonitor)progress.newChild(5));
        HashSet<ItemId<IChangeSet>> allIncoming = new HashSet<ItemId<IChangeSet>>();
        allIncoming.addAll(staticReport.getIncomingIds());
        allIncoming.addAll(additionalIncoming);
        HashSet<ItemId<IChangeSet>> allOutgoing = new HashSet<ItemId<IChangeSet>>();
        allOutgoing.addAll(staticReport.getOutgoingIds());
        allOutgoing.addAll(additionalOutgoing);
        HashSet oldIncoming = NewCollection.hashSet();
        oldIncoming.addAll(allIncoming);
        allIncoming.removeAll(allOutgoing);
        allOutgoing.removeAll(oldIncoming);
        HashMap incomingChanges = NewCollection.hashMap();
        HashMap outgoingChanges = NewCollection.hashMap();
        HashSet incomingCloses = NewCollection.hashSet();
        HashSet outgoingCloses = NewCollection.hashSet();
        for (StateId<IChangeSet> next : incomingActiveStateSelections.values()) {
            nextId = next.getItemId();
            if (allIncoming.contains(nextId)) {
                incomingChanges.put(nextId, next);
                continue;
            }
            StateId<IChangeSet> outgoingState = outgoingActiveStateSelections.get(nextId);
            if (outgoingState != null) {
                if (outgoingState.equals(next)) continue;
                incomingChanges.put(nextId, next);
                continue;
            }
            outgoingCloses.add(nextId);
        }
        for (StateId<IChangeSet> next : outgoingActiveStateSelections.values()) {
            nextId = next.getItemId();
            if (allOutgoing.contains(nextId)) {
                outgoingChanges.put(nextId, next);
                continue;
            }
            StateId<IChangeSet> incomingState = incomingActiveStateSelections.get(nextId);
            if (incomingState != null) {
                if (incomingState.equals(next)) continue;
                outgoingChanges.put(nextId, next);
                continue;
            }
            incomingCloses.add(nextId);
        }
        EraSyncReport additionalChanges = new EraSyncReport(additionalIncoming, additionalOutgoing, incomingCloses, outgoingCloses, incomingChanges, outgoingChanges);
        return staticReport.append(additionalChanges);
    }

    private static Map<ItemId<IChangeSet>, StateId<IChangeSet>> computeActiveStateSelections(EraDescriptor era, EraDescriptor ancestor, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        HashMap<ItemId<IChangeSet>, StateId<IChangeSet>> result = new HashMap<ItemId<IChangeSet>, StateId<IChangeSet>>();
        LinkedList<EraDescriptor> eraStack = new LinkedList<EraDescriptor>();
        SubMonitor eraProgress = progress.newChild(50);
        EraDescriptor current = era;
        while (current != null && current != ancestor) {
            eraProgress.setWorkRemaining(2);
            eraStack.addFirst(current);
            current = current.getPreviousEra((IProgressMonitor)eraProgress.newChild(1));
        }
        SubMonitor changeSetProgress = progress.newChild(50);
        changeSetProgress.setWorkRemaining(eraStack.size());
        for (EraDescriptor next : eraStack) {
            result.putAll(next.getActiveChangeSetStates());
        }
        return result;
    }

    private static List computeAllChangeSets(EraDescriptor snapshot, EraDescriptor start, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ArrayList<ItemId<IChangeSet>> result = new ArrayList<ItemId<IChangeSet>>();
        LinkedList<EraDescriptor> eraStack = new LinkedList<EraDescriptor>();
        SubMonitor eraProgress = progress.newChild(50);
        EraDescriptor current = snapshot;
        while (current != null && current != start) {
            eraProgress.setWorkRemaining(2);
            eraStack.addFirst(current);
            current = current.getPreviousEra((IProgressMonitor)eraProgress.newChild(1));
        }
        SubMonitor changeSetProgress = progress.newChild(50);
        changeSetProgress.setWorkRemaining(eraStack.size());
        for (EraDescriptor next : eraStack) {
            result.addAll(next.getChangeSets((IProgressMonitor)changeSetProgress.newChild(1)));
        }
        return result;
    }

    private static EraSyncReport compareStaticSnapshots(StaticEraDescriptor snapshot1, StaticEraDescriptor snapshot2, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (snapshot1 == null && snapshot2 == null) {
            return new EraSyncReport();
        }
        if (snapshot1 == null) {
            return new EraSyncReport(EraDescriptor.computeAllChangeSets(snapshot2, null, (IProgressMonitor)progress.newChild(100)), Collections.EMPTY_LIST);
        }
        if (snapshot2 == null) {
            return new EraSyncReport(Collections.EMPTY_LIST, EraDescriptor.computeAllChangeSets(snapshot1, null, (IProgressMonitor)progress.newChild(100)));
        }
        if (snapshot1.equals(snapshot2)) {
            return new EraSyncReport();
        }
        IChangeHistory changeHistory1 = snapshot1.getChangeHistory();
        IChangeHistory changeHistory2 = snapshot2.getChangeHistory();
        IChangeHistorySyncReport syncReport = changeHistory1.compareChangeHistories(changeHistory2, (IProgressMonitor)progress.newChild(100));
        List incoming = ItemLists.handlesToIds((Collection)syncReport.incomingChangeSets());
        List outgoing = ItemLists.handlesToIds((Collection)syncReport.outgoingChangeSets());
        return new EraSyncReport(incoming, outgoing);
    }

    private static StaticEraDescriptor findStaticAncestor(EraDescriptor snapshot1, ItemId componentId, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        EraDescriptor current = snapshot1;
        while (current != null) {
            if (current instanceof StaticEraDescriptor) {
                StaticEraDescriptor staticEra = (StaticEraDescriptor)current;
                if (componentId == null || staticEra.getComponent().equals((Object)componentId)) {
                    return staticEra;
                }
            }
            progress.setWorkRemaining(2);
            current = current.getPreviousEra((IProgressMonitor)progress.newChild(1));
        }
        return null;
    }

    public EraDescriptor discardLast(int changeSetsToDiscard, IProgressMonitor monitor) throws TeamRepositoryException {
        List<DeliveryInfo> changes;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        if (changeSetsToDiscard == 0) {
            return this;
        }
        int remainToDiscard = changeSetsToDiscard;
        EraDescriptor current = this;
        while (true) {
            if (current == null || current.isEmpty()) {
                return EraDescriptor.createEmptyEra(this.getRepository(), this.getComponent());
            }
            progress.setWorkRemaining(100);
            changes = current.getDeliveries((IProgressMonitor)progress.newChild(40));
            if (changes.size() > remainToDiscard) break;
            progress.setWorkRemaining(remainToDiscard + 1);
            current = current.getPreviousEra((IProgressMonitor)progress.newChild(changes.size()));
            remainToDiscard -= changes.size();
        }
        if (remainToDiscard == 0) {
            return current;
        }
        if (current != this) {
            progress.setWorkRemaining(1);
            return current.discardLast(remainToDiscard, (IProgressMonitor)progress.newChild(1));
        }
        HashMap activeChangeSets = current.getActiveChangeSetStates();
        List<DeliveryInfo> toRemoveList = changes.subList(changes.size() - remainToDiscard, changes.size());
        if (!activeChangeSets.isEmpty()) {
            HashMap newActiveChangeSets = NewCollection.hashMap();
            newActiveChangeSets.putAll(activeChangeSets);
            for (DeliveryInfo toRemove : toRemoveList) {
                newActiveChangeSets.remove(toRemove.getChangeSet());
            }
            activeChangeSets = newActiveChangeSets;
        }
        progress.setWorkRemaining(1);
        ArrayList resultList = NewCollection.arrayList();
        resultList.addAll(changes.subList(0, changes.size() - remainToDiscard));
        return ClientEraDescriptor.createDescriptor(this.getRepository(), current.getPreviousEra((IProgressMonitor)progress.newChild(1)), resultList, activeChangeSets, 0, resultList.size(), this.getComponent(), this.getRootComputer());
    }

    protected abstract IRemoteFunction<ItemId<IFolder>> getRootComputer();

    public final int findIndexOf(ItemId<IChangeSet> cs, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        EraDescriptor currentEra = this;
        int index = 0;
        while (!currentEra.isEmpty()) {
            progress.setWorkRemaining(100);
            List<DeliveryInfo> changes = EraCache.getDefault().fetchDeliveries(currentEra, (IProgressMonitor)progress.newChild(10));
            index += changes.size();
            int eraIndex = 0;
            while (eraIndex < changes.size()) {
                DeliveryInfo next = changes.get(eraIndex);
                if (next.getChangeSet().equals(cs)) break;
                ++eraIndex;
            }
            if (eraIndex < changes.size()) {
                return index - eraIndex - 1;
            }
            currentEra = currentEra.getPreviousEra((IProgressMonitor)progress.newChild(10));
        }
        return -1;
    }

    public abstract List<DeliveryInfo> findChangeSetsAffecting(ItemId<?> var1, int var2, IProgressMonitor var3) throws TeamRepositoryException;

    public abstract ItemId<IFolder> getRoot(IProgressMonitor var1) throws TeamRepositoryException;

    public final List<DeliveryInfo> getLastDeliveries(int entryCount, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        LinkedList<DeliveryInfo> result = new LinkedList<DeliveryInfo>();
        List<EraDescriptor> previousEras = this.getPreviousEras(entryCount, (IProgressMonitor)progress.newChild(100));
        ListIterator<EraDescriptor> iter = previousEras.listIterator(previousEras.size());
        block0: while (iter.hasPrevious()) {
            EraDescriptor currentEra = iter.previous();
            progress.setWorkRemaining(100);
            List<DeliveryInfo> next = currentEra.getDeliveries((IProgressMonitor)progress.newChild(1));
            ArrayList<DeliveryInfo> arrayList = new ArrayList<DeliveryInfo>();
            arrayList.addAll(next);
            Collections.reverse(arrayList);
            int spaceRemain = entryCount - result.size();
            for (DeliveryInfo nextInfo : arrayList) {
                if (spaceRemain == 0) continue block0;
                result.addFirst(nextInfo);
                --spaceRemain;
            }
        }
        return result;
    }

    public List<EraDescriptor> getPreviousEras(int entryCount, IProgressMonitor monitor) throws TeamRepositoryException {
        if (entryCount == 0) {
            return Collections.emptyList();
        }
        return this.doGetPreviousEras(entryCount, monitor);
    }

    protected abstract List<EraDescriptor> doGetPreviousEras(int var1, IProgressMonitor var2) throws TeamRepositoryException;

    public static List<DeliveryInfo> getDeliveryInfo(IChangeHistory changeHistory, ItemId<?> item, int maxResults, IProgressMonitor monitor) throws TeamRepositoryException {
        if (maxResults <= 0) {
            return Collections.emptyList();
        }
        List<DeliveryInfo> reversedResult = DeliveryInfo.createFromChangeHistory(changeHistory.getHistoryFor((IVersionableHandle)item.toHandle(), maxResults, true, monitor));
        ArrayList result = NewCollection.arrayList((int)reversedResult.size());
        result.addAll(reversedResult);
        Collections.reverse(result);
        return result;
    }

    public final Map<ItemId<IVersionable>, VersionablePath> resolve(Collection<ItemId<IVersionable>> versionables, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.doResolve(versionables, monitor);
    }

    protected abstract Map<ItemId<IVersionable>, VersionablePath> doResolve(Collection<ItemId<IVersionable>> var1, IProgressMonitor var2) throws TeamRepositoryException;

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ChildComputer
    implements IRemoteFunction<Map<String, ItemId<IVersionable>>> {
        private EraDescriptor era;
        private ItemId<IFolder> parent;

        public ChildComputer(EraDescriptor era, ItemId<IFolder> parent) {
            this.era = era;
            this.parent = parent;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.era == null ? 0 : this.era.hashCode());
            result = 31 * result + (this.parent == null ? 0 : this.parent.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ChildComputer other = (ChildComputer)obj;
            if (this.era == null ? other.era != null : !this.era.equals(other.era)) {
                return false;
            }
            return !(this.parent == null ? other.parent != null : !this.parent.equals(other.parent));
        }

        public Map<String, ItemId<IVersionable>> compute(IProgressMonitor monitor) throws TeamRepositoryException {
            return this.era.doFetchChildren(this.parent, monitor);
        }
    }
}

