/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.copyfileareas.migration;

import com.ibm.team.filesystem.client.internal.copyfileareas.migration.DiskBackedHashMapEntriesValidator;
import com.ibm.team.filesystem.client.internal.copyfileareas.migration.GlobalMetadataValidator;
import com.ibm.team.filesystem.client.internal.copyfileareas.migration.HeapValidator;
import com.ibm.team.filesystem.client.internal.copyfileareas.migration.InverseInfo;
import com.ibm.team.filesystem.client.internal.copyfileareas.migration.ItemComponentConnection;
import com.ibm.team.filesystem.client.internal.copyfileareas.migration.ValidationItemHandle;
import com.ibm.team.internal.repository.rcp.util.RAFWrapper;
import com.ibm.team.repository.common.utils.HashCode;
import com.ibm.team.scm.common.IContextHandle;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.core.runtime.Path;

public class InverseItemInfoMapValidator
extends DiskBackedHashMapEntriesValidator {
    protected static final int STRING_TAG = 1;
    protected static final int INVERSE_ITEM_INFO_TAG = 3;
    protected static final int METADATA_VERSION = 4;
    protected static final int METADATA_VERSION_M5D1 = 5;
    protected static final int METADATA_VERSION_M6D1 = 6;
    protected static final int METADATA_VERSION_RC1 = 7;
    protected static final long NULL_CHECKSUM = -1L;
    protected File cfaRoot;

    public InverseItemInfoMapValidator(File rootPath, HeapValidator hv, GlobalMetadataValidator gv) throws IOException {
        super(hv, gv);
        this.cfaRoot = rootPath;
    }

    public void beginValidation() throws IOException {
        super.beginValidation();
        if (!this.hv.getHeapFile().getName().equals(".inverseiteminfo.dat")) {
            this.log.append("Invalid inverse item info map file name " + this.hv.getHeapFile() + "\n");
        }
        if (!this.hv.getHeapFile().getParentFile().equals(this.cfaRoot)) {
            this.log.append("Invalid inverse item info map location " + this.hv.getHeapFile() + " relative to root " + this.cfaRoot + "\n");
        }
    }

    public void validateEntry(long entryOffset, long keyOffset, boolean keyIsHeapADT, long valueOffset, boolean valueIsHeapADT, int hash, RAFWrapper raf) throws IOException {
        if (keyIsHeapADT) {
            this.log.append("HeapADT attribute unexpectedly set on inverse item info key of entry at " + entryOffset + "\n");
        }
        if (valueIsHeapADT) {
            this.log.append("HeapADT attribute unexpectedly set on inverse item info value of entry at " + entryOffset + "\n");
        }
        String itemId = this.validateKey(entryOffset, keyOffset, hash, raf);
        this.validateValue(entryOffset, valueOffset, raf, itemId);
    }

    protected String validateKey(long entryOffset, long keyOffset, int hashCode, RAFWrapper raf) throws IOException {
        if (keyOffset < 0L || keyOffset >= this.hv.getWorkingAreaSize()) {
            this.log.append("The inverse item info key pointer is at an impossible location " + keyOffset + " at " + entryOffset + "\n");
            return null;
        }
        this.setPosition(keyOffset);
        try {
            String itemId;
            int tag = this.validateByte("inverse item info key", keyOffset, "tag", raf);
            if (tag == -1) {
                return null;
            }
            if (tag != 1) {
                this.log.append("Unexpected tag found instead of STRING_TAG " + tag + " at offset " + keyOffset + "\n");
            }
            if ((itemId = this.validateUUID("inverse item info key", keyOffset, "item id", raf)) != null) {
                this.addKey(itemId, entryOffset, keyOffset, "inverse item info");
                if (hashCode != itemId.hashCode()) {
                    this.log.append("The entry at " + entryOffset + " contains a hash code (" + hashCode + ") for inverse item info key at " + keyOffset + " with item id \"" + itemId + "\" whose hash code is " + itemId.hashCode() + "\n");
                }
            }
            String string = itemId;
            return string;
        }
        finally {
            this.hv.claim(new HeapValidator.HeapClaimant(keyOffset, this.getPosition() - keyOffset, "Inverse Item Info Key"));
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void validateValue(long entryOffset, long valueOffset, RAFWrapper raf, String keyItem) throws IOException {
        block112: {
            if (valueOffset < 0L || valueOffset > this.hv.getWorkingAreaSize()) {
                this.log.append("The inverse item info value pointer is at an impossible location " + valueOffset + " at " + entryOffset + "\n");
                return;
            }
            this.setPosition(valueOffset);
            icc = null;
            info = null;
            tag = this.validateByte("inverse item info value", valueOffset, "tag", raf);
            if (tag != -1) break block112;
lbl11:
            // 26 sources

            while (true) {
                if (icc != null && info != null && icc.getConnectionId() != null && icc.getComponentId() != null && icc.getItemId() != null) {
                    this.gv.addInverseInfo((ItemComponentConnection)icc, info);
                }
                this.hv.claim(new HeapValidator.HeapClaimant(valueOffset, this.getPosition() - valueOffset, "Inverse Item Info Value"));
                return;
            }
        }
        try {
            if (tag != 3) {
                this.log.append("Unexpected tag found instead of INVERSE_ITEM_INFO_TAG " + tag + " at offset " + valueOffset + "\n");
            }
            if ((version = this.validateInt("inverse item info value", valueOffset, "version", raf)) == -1L) ** GOTO lbl11
            switch ((int)version) {
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
                default: {
                    this.log.append("Unexpected version found " + version + " at offset " + valueOffset + "\n");
                }
            }
            if ((mapSize = this.validateInt("inverse item info value", valueOffset, "map size", raf)) == -1L) ** GOTO lbl11
            if (mapSize > 0x7FFFFFFFL) {
                this.log.append("Impossible inverse item info map size " + mapSize + " at offset " + valueOffset + "\n");
            }
            existing = new HashSet<ConnectionComponent>();
            i = 0L;
            while (i < mapSize) {
                block117: {
                    block120: {
                        block119: {
                            block118: {
                                block116: {
                                    block115: {
                                        block114: {
                                            block113: {
                                                icc = new ItemComponentConnection();
                                                icc.setItemId(keyItem);
                                                info = new InverseInfo();
                                                info.setItemId(keyItem);
                                                info.setLastModification(-1L);
                                                info.setLocalSize(-1L);
                                                info.setRemoteSize(-1L);
                                                info.setRemoteChecksum(-1L);
                                                info.setNumLineDelimiters(-1L);
                                                info.setRemoteChildren(Collections.<String, ValidationItemHandle>emptyMap());
                                                connType = this.validateString("inverse item info value", valueOffset, "connection type name", raf);
                                                connNS = this.validateString("inverse item info value", valueOffset, "connection type namespace", raf);
                                                this.validateItemType(connType, connNS, IContextHandle.class, "inverse item info value", valueOffset, "connection item type");
                                                connId = this.validateUUID("inverse item info value", valueOffset, "connection id", raf);
                                                componentId = this.validateUUID("inverse item info value", valueOffset, "component id", raf);
                                                icc.setConnectionType(connType);
                                                icc.setConnectionTypeNS(connNS);
                                                icc.setConnectionId(connId);
                                                icc.setComponentId(componentId);
                                                if (connId != null && componentId != null && !existing.add(new ConnectionComponent(connId, componentId))) {
                                                    this.log.append("The connection and component pair \"" + connId + "\" and \"" + componentId + "\" found at " + valueOffset + " already occured in the map\n");
                                                }
                                                if ((isFolder = this.validateByte("inverse item info value", valueOffset, "isFolder", raf)) == -1) ** GOTO lbl11
                                                if ((isFolder & -2) != 0) {
                                                    this.log.append("Unexpected value found for isFolder " + isFolder + " at offset " + valueOffset + "\n");
                                                }
                                                info.setFolder(isFolder != 0);
                                                itemHandle = this.validateHandle("inverse item info value", valueOffset, "item", raf);
                                                if (keyItem != null && itemHandle != null && !(match = (idx = itemHandle.indexOf(124)) == -1 ? keyItem.equals(itemHandle) : keyItem.equals(itemHandle.substring(0, idx)))) {
                                                    this.log.append("Mismatch between item id in key and value of inverse item info map at " + valueOffset + ", key is " + keyItem + " and value is " + itemHandle + "\n");
                                                }
                                                if (itemHandle != null) {
                                                    itemId = itemHandle;
                                                    stateId = null;
                                                    idx = itemHandle.indexOf(124);
                                                    if (idx != -1) {
                                                        itemId = itemHandle.substring(0, idx);
                                                        stateId = itemHandle.substring(idx + 1);
                                                    }
                                                    info.setItemId(itemId);
                                                    info.setStateId(stateId);
                                                }
                                                if (isFolder != 0) break block113;
                                                lastMod = this.validateLong("inverse item info value", valueOffset, "last modification", raf);
                                                if (lastMod[1] == -1L) ** GOTO lbl11
                                                if (lastMod[0] != -1L && itemHandle != null && itemHandle.indexOf(124) == -1) {
                                                    this.log.append("File \"" + itemHandle + "\" has no state id but has modification stamp " + lastMod[0] + " at " + valueOffset + "\n");
                                                }
                                                info.setLastModification(lastMod[0]);
                                            }
                                            if ((hasParent = this.validateByte("inverse item info value", valueOffset, "hasParent", raf)) == -1) ** GOTO lbl11
                                            if ((hasParent & -2) != 0) {
                                                this.log.append("Unexpected value found for hasParent " + hasParent + " at offset " + valueOffset + "\n");
                                            }
                                            if (hasParent != 0) {
                                                parent = this.validateHandle("inverse item info value", valueOffset, "parent folder", raf);
                                                info.setRemoteParentId(parent);
                                                name = this.validateString("inverse item info value", valueOffset, "parent folder name", raf);
                                                if (name != null && !Path.ROOT.isValidSegment(name)) {
                                                    this.log.append("The parent name \"" + name + "\" at offset " + valueOffset + " is not valid\n");
                                                }
                                                if (itemHandle != null && itemHandle.indexOf(124) == -1) {
                                                    this.log.append("The item \"" + itemHandle + "\" has a parent, but no state id at offset " + valueOffset + "\n");
                                                }
                                                info.setRemoteName(name);
                                            } else if (isFolder == 0 && itemHandle != null && itemHandle.indexOf(124) != -1) {
                                                this.log.append("The file \"" + itemHandle + "\" has a state id, but no parent at offset " + valueOffset + "\n");
                                            }
                                            if ((hasLocalParent = this.validateByte("inverse item info value", valueOffset, "hasLocalParent", raf)) == -1) ** GOTO lbl11
                                            if ((hasLocalParent & -2) != 0) {
                                                this.log.append("Unexpected value found for hasLocalParent " + hasLocalParent + " at offset " + valueOffset + "\n");
                                            }
                                            if (hasLocalParent != 0) {
                                                parent = this.validateHandle("inverse item info value", valueOffset, "local parent folder", raf);
                                                info.setLocalParentId(parent);
                                                name = this.validateString("inverse item info value", valueOffset, "local parent folder name", raf);
                                                if (name != null && !Path.ROOT.isValidSegment(name)) {
                                                    this.log.append("The local parent name \"" + name + "\" at offset " + valueOffset + " is not valid\n");
                                                }
                                                info.setLocalName(name);
                                            }
                                            if (isFolder == 0 && hasLocalParent == 0 && hasParent == 0) {
                                                this.log.append("The local parent and remote parent are both missing for file at offset " + valueOffset + "\n");
                                            }
                                            if (isFolder == 0) break block114;
                                            childMapSize = this.validateInt("inverse item info value", valueOffset, "child map size", raf);
                                            if (childMapSize == -1L) ** GOTO lbl11
                                            if (childMapSize > 0x7FFFFFFFL) {
                                                this.log.append("Impossible inverse item info child map size " + mapSize + " at offset " + valueOffset + "\n");
                                            }
                                            if (childMapSize > 0L) {
                                                if (info.getStateId() == null) {
                                                    this.log.append("The folder at " + valueOffset + " has no state id but has " + childMapSize + " remote children\n");
                                                }
                                                info.setRemoteChildren(new HashMap<String, ValidationItemHandle>());
                                            }
                                            children = new HashSet<String>();
                                            childIds = new HashSet<String>();
                                            j = 0L;
                                            while (j < childMapSize) {
                                                name = this.validateString("inverse item info value", valueOffset, "child item name", raf);
                                                if (name != null) {
                                                    if (!Path.ROOT.isValidSegment(name)) {
                                                        this.log.append("The child name \"" + name + "\" at offset " + valueOffset + " is not valid\n");
                                                    }
                                                    if (!children.add(name)) {
                                                        this.log.append("The child name \"" + name + "\" at offset " + valueOffset + " occurs more than once\n");
                                                    }
                                                }
                                                if ((isChildFolder = this.validateByte("inverse item info value", valueOffset, "isChildFolder", raf)) == -1) ** GOTO lbl11
                                                if ((isChildFolder & -2) != 0) {
                                                    this.log.append("Unexpected value found for isChildFolder " + isChildFolder + " at offset " + valueOffset + "\n");
                                                }
                                                if ((childId = this.validateUUID("inverse item info value", valueOffset, "child item id", raf)) != null) {
                                                    if (!childIds.add(childId)) {
                                                        this.log.append("The child id \"" + childId + "\" at offset " + valueOffset + " occurs more than once\n");
                                                    }
                                                    if (keyItem != null && childId.equals(keyItem)) {
                                                        this.log.append("The child id \"" + childId + "\" at offset " + valueOffset + " is its own parent\n");
                                                    }
                                                    if (name != null) {
                                                        info.getRemoteChildren().put(name, new ValidationItemHandle(isChildFolder != 0, childId));
                                                    }
                                                }
                                                ++j;
                                            }
                                        }
                                        if ((hasHash = this.validateByte("inverse item info value", valueOffset, "hasHash", raf)) == -1) ** GOTO lbl11
                                        if ((hasHash & -2) != 0) {
                                            this.log.append("Unexpected value found for hasHash " + hasHash + " at offset " + valueOffset + "\n");
                                        }
                                        if (hasHash == 0) break block115;
                                        if (isFolder != 0) {
                                            this.log.append("Unexpected folder has hash at " + valueOffset + "\n");
                                        }
                                        if ((hash = this.validateLong("inverse item info value", valueOffset, "hash", raf))[1] == -1L) ** GOTO lbl11
                                        info.setLocalChecksum(new HashCode(hash[0]));
                                        break block116;
                                    }
                                    if (isFolder == 0 && hasParent != 0) {
                                        this.log.append("Unexpected file has no hash but has remote parent at " + valueOffset + "\n");
                                    }
                                }
                                if ((localSize = this.validateLong("inverse item info value", valueOffset, "size", raf))[1] == -1L) ** GOTO lbl11
                                if (localSize[0] == -1L) {
                                    if (isFolder == 0 && hasParent != 0) {
                                        this.log.append("Unexpected file has no size but has remote parent at " + valueOffset + "\n");
                                    }
                                } else if (isFolder != 0) {
                                    this.log.append("Folder at " + valueOffset + " has localSize " + localSize[0] + "\n");
                                } else if (hasParent == 0) {
                                    this.log.append("File at " + valueOffset + " has localSize " + localSize[0] + " but no remote parent\n");
                                }
                                info.setLocalSize(localSize[0]);
                                if (version < 5L) break block117;
                                origLineDelimiterPresent = this.validateByte("inverse item info value", valueOffset, "origLineDelimiterPresent", raf);
                                if (origLineDelimiterPresent == -1) ** GOTO lbl11
                                if ((origLineDelimiterPresent & -2) != 0) {
                                    this.log.append("Unexpected value found for origLineDelimiterPresent " + origLineDelimiterPresent + " at offset " + valueOffset + "\n");
                                }
                                origLineDelimiterOrd = -1L;
                                if (origLineDelimiterPresent == 0) break block118;
                                origLineDelimiterOrd = this.validateInt("inverse item info value", valueOffset, "origLineDelimiter", raf);
                                if (isFolder != 0) {
                                    this.log.append("Folder at offset " + valueOffset + " has original line delimiter \"" + origLineDelimiterOrd + "\"\n");
                                } else if (hasParent == 0) {
                                    this.log.append("File at " + valueOffset + " has original line delimiter \"" + origLineDelimiterOrd + "\" but no remote parent\n");
                                }
                                if (origLineDelimiterOrd == -1L) ** GOTO lbl11
                                del = this.validateLineDelimeter((int)origLineDelimiterOrd, "inverse item info value", valueOffset, "origLineDelimiter");
                                info.setRemoteLineDelimiter(del);
                            }
                            if ((currentLineDelimiterPresent = this.validateByte("inverse item info value", valueOffset, "currentLineDelimiterPresent", raf)) == -1) ** GOTO lbl11
                            if ((currentLineDelimiterPresent & -2) != 0) {
                                this.log.append("Unexpected value found for currentLineDelimiterPresent " + currentLineDelimiterPresent + " at offset " + valueOffset + "\n");
                            }
                            if (currentLineDelimiterPresent == 0) break block119;
                            currentLineDelimiterOrd = this.validateInt("inverse item info value", valueOffset, "currentLineDelimiter", raf);
                            if (isFolder != 0) {
                                this.log.append("Folder entry at offset " + valueOffset + " has current line delimiter \"" + currentLineDelimiterOrd + "\"\n");
                            }
                            if (currentLineDelimiterOrd == -1L) ** GOTO lbl11
                            del = this.validateLineDelimeter((int)currentLineDelimiterOrd, "inverse item info value", valueOffset, "currentLineDelimiter");
                            info.setLocalLineDelimiter(del);
                            break block120;
                        }
                        if (isFolder == 0 && origLineDelimiterPresent != 0) {
                            this.log.append("File entry at offset " + valueOffset + " has original line delimiter but not a current one\n");
                        }
                    }
                    if ((origContentTypePresent = this.validateByte("inverse item info value", valueOffset, "origContentTypePresent", raf)) == -1) ** GOTO lbl11
                    if ((origContentTypePresent & -2) != 0) {
                        this.log.append("Unexpected value found for origContentTypePresent " + origContentTypePresent + " at offset " + valueOffset + "\n");
                    }
                    if (origContentTypePresent != 0) {
                        origContentType = this.validateString("inverse item info value", valueOffset, "origContentType", raf);
                        if (isFolder != 0) {
                            this.log.append("Folder at offset " + valueOffset + " has original content type \"" + origContentType + "\"\n");
                        } else if (hasParent == 0) {
                            this.log.append("File at " + valueOffset + " has original content type \"" + origContentType + "\" but no remote parent\n");
                        }
                        if (origLineDelimiterPresent == 0) {
                            this.log.append("Item at " + valueOffset + " has original content type \"" + origContentType + "\" but no original line delimiter\n");
                        }
                        info.setRemoteContentType(origContentType);
                    } else if (origLineDelimiterPresent != 0) {
                        this.log.append("Item at " + valueOffset + " has original line delimiter \"" + origLineDelimiterOrd + "\" but no original content type\n");
                    }
                    if ((currentContentTypePresent = this.validateByte("inverse item info value", valueOffset, "currentContentTypePresent", raf)) == -1) ** GOTO lbl11
                    if ((currentContentTypePresent & -2) != 0) {
                        this.log.append("Unexpected value found for currentContentTypePresent " + currentContentTypePresent + " at offset " + valueOffset + "\n");
                    }
                    if (currentContentTypePresent != 0) {
                        currentContentType = this.validateString("inverse item info value", valueOffset, "currentContentType", raf);
                        if (isFolder != 0) {
                            this.log.append("Folder entry at offset " + valueOffset + " has current content type \"" + currentContentType + "\"\n");
                        }
                        info.setLocalContentType(currentContentType);
                    } else if (isFolder == 0 && origContentTypePresent != 0) {
                        this.log.append("File entry at offset " + valueOffset + " has original content type but not a current one\n");
                    }
                    if (version < 6L) break block117;
                    contentIdPresent = this.validateByte("inverse item info value", valueOffset, "contentIdPresent", raf);
                    if (contentIdPresent == -1) ** GOTO lbl11
                    if ((contentIdPresent & -2) != 0) {
                        this.log.append("Unexpected value found for contentIdPresent " + contentIdPresent + " at offset " + valueOffset + "\n");
                    }
                    contentId = null;
                    if (contentIdPresent != 0) {
                        contentId = this.validateUUID("inverse item info value", valueOffset, "contentId", raf);
                        if (isFolder != 0) {
                            this.log.append("Folder at offset " + valueOffset + " has content id \"" + contentId + "\"\n");
                        } else if (hasParent == 0) {
                            this.log.append("File at " + valueOffset + " has content id \"" + contentId + "\" but no remote parent\n");
                        }
                        if (origLineDelimiterPresent == 0) {
                            this.log.append("Item at " + valueOffset + " has content id \"" + contentId + "\" but no original line delimiter\n");
                        }
                        if (origContentTypePresent == 0) {
                            this.log.append("Item at " + valueOffset + " has content id \"" + contentId + "\" but no original content type\n");
                        }
                        info.setContentId(contentId);
                    }
                    if ((deltaPredecessorPresent = this.validateByte("inverse item info value", valueOffset, "deltaPredecessorPresent", raf)) == -1) ** GOTO lbl11
                    if ((deltaPredecessorPresent & -2) != 0) {
                        this.log.append("Unexpected value found for deltaPredecessorPresent " + deltaPredecessorPresent + " at offset " + valueOffset + "\n");
                    }
                    if (deltaPredecessorPresent != 0) {
                        deltaPredecessor = this.validateUUID("inverse item info value", valueOffset, "deltaPredecessor", raf);
                        if (isFolder != 0) {
                            this.log.append("Folder at offset " + valueOffset + " has delta predecessor \"" + deltaPredecessor + "\"\n");
                        } else if (hasParent == 0) {
                            this.log.append("File at " + valueOffset + " has delta predecessor \"" + deltaPredecessor + "\" but no remote parent\n");
                        }
                        if (contentIdPresent == 0) {
                            this.log.append("Item at " + valueOffset + " has delta predecessor \"" + deltaPredecessor + "\" but no content id\n");
                        }
                        info.setDeltaPredecessor(deltaPredecessor);
                    }
                    if ((sizeInRepo = this.validateLong("inverse item info value", valueOffset, "sizeInRepo", raf))[1] == -1L) ** GOTO lbl11
                    if (sizeInRepo[0] != -1L) {
                        if (isFolder != 0) {
                            this.log.append("Folder at offset " + valueOffset + " has size in repo \"" + sizeInRepo[0] + "\"\n");
                        } else if (hasParent == 0) {
                            this.log.append("File at " + valueOffset + " has size in repo \"" + sizeInRepo[0] + "\" but no remote parent\n");
                        }
                        if (contentIdPresent == 0) {
                            this.log.append("Item at " + valueOffset + " has size in repo \"" + sizeInRepo[0] + "\" but no content id\n");
                        }
                    } else if (contentIdPresent != 0) {
                        this.log.append("Item at " + valueOffset + " has content id \"" + contentId + "\" but no size in repo\n");
                    }
                    info.setRemoteSize(sizeInRepo[0]);
                    contentEncodingPresent = this.validateByte("inverse item info value", valueOffset, "contentEncodingPresent", raf);
                    if (contentEncodingPresent == -1) ** GOTO lbl11
                    if ((contentEncodingPresent & -2) != 0) {
                        this.log.append("Unexpected value found for contentEncodingPresent " + contentEncodingPresent + " at offset " + valueOffset + "\n");
                    }
                    if (contentEncodingPresent != 0) {
                        encoding = this.validateString("inverse item info value", valueOffset, "contentEncoding", raf);
                        if (isFolder != 0) {
                            this.log.append("Folder at offset " + valueOffset + " has content encoding \"" + encoding + "\"\n");
                        } else if (hasParent == 0) {
                            this.log.append("File at " + valueOffset + " has content encoding \"" + encoding + "\" but no remote parent\n");
                        }
                        if (contentIdPresent == 0) {
                            this.log.append("Item at " + valueOffset + " has content encoding \"" + encoding + "\" but no content id\n");
                        }
                        info.setRemoteEncoding(encoding);
                    }
                    if ((checksumInRepo = this.validateLong("inverse item info value", valueOffset, "checksumInRepo", raf))[1] == -1L) ** GOTO lbl11
                    if (checksumInRepo[0] != -1L) {
                        if (isFolder != 0) {
                            this.log.append("Folder at offset " + valueOffset + " has checksum in repo \"" + checksumInRepo[0] + "\"\n");
                        } else if (hasParent == 0) {
                            this.log.append("File at " + valueOffset + " has checksum in repo \"" + checksumInRepo[0] + "\" but no remote parent\n");
                        }
                        if (contentIdPresent == 0) {
                            this.log.append("Item at " + valueOffset + " has checksum in repo \"" + checksumInRepo[0] + "\" but no content id\n");
                        }
                    } else if (contentIdPresent != 0) {
                        this.log.append("Item at " + valueOffset + " has content id \"" + contentId + "\" but no checksum in repo\n");
                    }
                    info.setRemoteChecksum(checksumInRepo[0]);
                    numDelimiters = this.validateLong("inverse item info value", valueOffset, "numDelimiters", raf);
                    if (numDelimiters[1] == -1L) ** GOTO lbl11
                    if (numDelimiters[0] != -1L) {
                        if (isFolder != 0) {
                            this.log.append("Folder at offset " + valueOffset + " has num delimiters \"" + numDelimiters[0] + "\"\n");
                        } else if (hasParent == 0) {
                            this.log.append("File at " + valueOffset + " has num delimiters \"" + numDelimiters[0] + "\" but no remote parent\n");
                        }
                        if (contentIdPresent == 0) {
                            this.log.append("Item at " + valueOffset + " has num delimiters \"" + numDelimiters[0] + "\" but no content id\n");
                        }
                    }
                    info.setNumLineDelimiters(numDelimiters[0]);
                    if (version < 7L || isFolder != 0) break block117;
                    isExecutable = this.validateByte("inverse item info value", valueOffset, "isExecutable", raf);
                    if (isExecutable == -1) ** GOTO lbl11
                    if ((isExecutable & -2) != 0) {
                        this.log.append("Unexpected value found for isExecutable " + isExecutable + " at offset " + valueOffset + "\n");
                    }
                    info.setLocalExecutable(isExecutable != 0);
                    isOrigExecutable = this.validateByte("inverse item info value", valueOffset, "isOrigExecutable", raf);
                    if (isOrigExecutable != -1) ** break;
                    ** continue;
                    if ((isOrigExecutable & -2) != 0) {
                        this.log.append("Unexpected value found for isOrigExecutable " + isOrigExecutable + " at offset " + valueOffset + "\n");
                    }
                    info.setRemoteExecutable(isOrigExecutable != 0);
                }
                if (icc.getConnectionId() != null && icc.getComponentId() != null && icc.getItemId() != null) {
                    this.gv.addInverseInfo((ItemComponentConnection)icc, info);
                }
                icc = null;
                info = null;
                ++i;
            }
        }
        catch (Throwable var42_54) {
            if (icc != null && info != null && icc.getConnectionId() != null && icc.getComponentId() != null && icc.getItemId() != null) {
                this.gv.addInverseInfo((ItemComponentConnection)icc, info);
            }
            this.hv.claim(new HeapValidator.HeapClaimant(valueOffset, this.getPosition() - valueOffset, "Inverse Item Info Value"));
            throw var42_54;
        }
        if (icc != null && info != null && icc.getConnectionId() != null && icc.getComponentId() != null && icc.getItemId() != null) {
            this.gv.addInverseInfo((ItemComponentConnection)icc, info);
        }
        this.hv.claim(new HeapValidator.HeapClaimant(valueOffset, this.getPosition() - valueOffset, "Inverse Item Info Value"));
    }

    protected static class ConnectionComponent {
        protected String connection;
        protected String component;

        public ConnectionComponent(String connection, String component) {
            this.connection = connection;
            this.component = component;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof ConnectionComponent)) {
                return false;
            }
            ConnectionComponent other = (ConnectionComponent)obj;
            return other.connection.equals(this.connection) && other.component.equals(this.component);
        }

        public int hashCode() {
            return this.connection.hashCode() ^ this.component.hashCode();
        }
    }
}

