/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.copyfileareas;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.internal.copyfileareas.AbstractLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.CFAReadLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.ComponentLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaLockRequest;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaStore;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileArea;
import java.util.Collection;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class PathLockRequest
extends CopyFileAreaLockRequest {
    private final Collection shareables;

    public PathLockRequest(Collection collection) {
        this.shareables = collection;
    }

    public void addLocks(Set set, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        for (IShareable iShareable : this.shareables) {
            IPath iPath = iShareable.getSandbox().getRoot();
            AbstractLock abstractLock = PathLockRequest.lockCFA(iPath, iProgressMonitor);
            try {
                ICopyFileArea iCopyFileArea = CopyFileAreaManager.instance.getExistingCopyFileArea(iPath);
                ISharingDescriptor iSharingDescriptor = ((CopyFileAreaStore)((Object)iCopyFileArea)).findSharingDescriptor(iShareable.getLocalPath());
                if (iSharingDescriptor != null) {
                    set.add(new ComponentLock(((CopyFileAreaStore)((Object)iCopyFileArea)).getRoot(), iSharingDescriptor.getConnectionHandle(), iSharingDescriptor.getComponent()));
                    continue;
                }
                set.add(new CFAReadLock(((CopyFileAreaStore)((Object)iCopyFileArea)).getRoot()));
            }
            finally {
                CopyFileAreaManager.instance.batchingLock.release(abstractLock, iProgressMonitor);
            }
        }
    }

    protected static AbstractLock lockCFA(IPath iPath, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        CopyFileAreaManager copyFileAreaManager = CopyFileAreaManager.instance;
        ICopyFileArea iCopyFileArea = copyFileAreaManager.getExistingCopyFileArea(iPath);
        if (iCopyFileArea == null) {
            iCopyFileArea = copyFileAreaManager.createCopyFileArea(iPath, (IProgressMonitor)subMonitor.newChild(20));
        }
        IPath iPath2 = ((CopyFileAreaStore)((Object)iCopyFileArea)).getRoot();
        while (true) {
            subMonitor.setWorkRemaining(100);
            AbstractLock abstractLock = copyFileAreaManager.batchingLock.acquire(new CFAReadLock(iPath2), copyFileAreaManager, CopyFileAreaManager.NULL_PARTICIPANT, true, (IProgressMonitor)subMonitor.newChild(50));
            boolean bl = false;
            try {
                iCopyFileArea = copyFileAreaManager.getExistingCopyFileArea(iPath);
                if (iCopyFileArea != null) {
                    if (iPath2.equals((Object)((CopyFileAreaStore)((Object)iCopyFileArea)).getRoot())) {
                        bl = true;
                        AbstractLock abstractLock2 = abstractLock;
                        return abstractLock2;
                    }
                } else {
                    copyFileAreaManager.batchingLock.release(abstractLock, (IProgressMonitor)subMonitor.newChild(1));
                    bl = true;
                    iCopyFileArea = copyFileAreaManager.createCopyFileArea(iPath, (IProgressMonitor)subMonitor.newChild(20));
                }
                iPath2 = ((CopyFileAreaStore)((Object)iCopyFileArea)).getRoot();
                continue;
            }
            finally {
                if (bl) continue;
                copyFileAreaManager.batchingLock.release(abstractLock, (IProgressMonitor)subMonitor.newChild(1));
                continue;
            }
            break;
        }
    }

    public boolean validateLocks(IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        for (IShareable iShareable : this.shareables) {
            IPath iPath = iShareable.getSandbox().getRoot();
            ICopyFileArea iCopyFileArea = CopyFileAreaManager.instance.getExistingCopyFileArea(iPath);
            if (iCopyFileArea == null) {
                return false;
            }
            ISharingDescriptor iSharingDescriptor = ((CopyFileAreaStore)((Object)iCopyFileArea)).findSharingDescriptor(iShareable.getLocalPath());
            if (!(iSharingDescriptor != null ? !CopyFileAreaManager.instance.batchingLock.isLocked(new ComponentLock(((CopyFileAreaStore)((Object)iCopyFileArea)).getRoot(), iSharingDescriptor.getConnectionHandle(), iSharingDescriptor.getComponent())) : !CopyFileAreaManager.instance.batchingLock.isLocked(new CFAReadLock(((CopyFileAreaStore)((Object)iCopyFileArea)).getRoot())))) continue;
            return false;
        }
        return true;
    }
}

