/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.copyfileareas;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.internal.copyfileareas.CFAListReadLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.ComponentLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaLockRequest;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.GlobalCFALock;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileArea;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationDescriptor;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class GlobalConfigurationLockRequest
extends CopyFileAreaLockRequest {
    private final Collection configurationsToLock;
    private final boolean expandToIncludeEntireCopyFileArea;

    public GlobalConfigurationLockRequest(Set set, boolean bl) {
        this.configurationsToLock = set;
        this.expandToIncludeEntireCopyFileArea = bl;
    }

    public void addLocks(Set set, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)this.configurationsToLock.size());
        if (this.configurationsToLock.isEmpty()) {
            subMonitor.done();
            return;
        }
        set.add(CFAListReadLock.INSTANCE);
        if (this.expandToIncludeEntireCopyFileArea) {
            HashSet<IPath> hashSet = new HashSet<IPath>();
            for (ConfigurationDescriptor configurationDescriptor : this.configurationsToLock) {
                for (ICopyFileArea iCopyFileArea : CopyFileAreaManager.instance.getCopyFileAreasForConfiguration(configurationDescriptor, (IProgressMonitor)subMonitor.newChild(1))) {
                    IPath iPath = iCopyFileArea.getRoot();
                    if (!hashSet.add(iPath)) continue;
                    set.add(new GlobalCFALock(iPath));
                }
            }
        } else {
            for (ConfigurationDescriptor configurationDescriptor : this.configurationsToLock) {
                for (ICopyFileArea iCopyFileArea : CopyFileAreaManager.instance.getCopyFileAreasForConfiguration(configurationDescriptor, (IProgressMonitor)subMonitor.newChild(1))) {
                    IPath iPath = iCopyFileArea.getRoot();
                    set.add(new ComponentLock(iPath, configurationDescriptor.connectionHandle, configurationDescriptor.componentHandle));
                }
            }
        }
        subMonitor.done();
    }

    public boolean validateLocks(IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)this.configurationsToLock.size());
        if (this.configurationsToLock.isEmpty()) {
            subMonitor.done();
            return true;
        }
        if (this.expandToIncludeEntireCopyFileArea) {
            HashSet<IPath> hashSet = new HashSet<IPath>();
            for (ConfigurationDescriptor configurationDescriptor : this.configurationsToLock) {
                for (ICopyFileArea iCopyFileArea : CopyFileAreaManager.instance.getCopyFileAreasForConfiguration(configurationDescriptor, (IProgressMonitor)subMonitor.newChild(1))) {
                    IPath iPath = iCopyFileArea.getRoot();
                    if (!hashSet.add(iPath) || CopyFileAreaManager.instance.batchingLock.isLocked(new GlobalCFALock(iPath))) continue;
                    subMonitor.done();
                    return false;
                }
            }
        } else {
            for (ConfigurationDescriptor configurationDescriptor : this.configurationsToLock) {
                for (ICopyFileArea iCopyFileArea : CopyFileAreaManager.instance.getCopyFileAreasForConfiguration(configurationDescriptor, (IProgressMonitor)subMonitor.newChild(1))) {
                    IPath iPath = iCopyFileArea.getRoot();
                    if (CopyFileAreaManager.instance.batchingLock.isLocked(new ComponentLock(iPath, configurationDescriptor.connectionHandle, configurationDescriptor.componentHandle))) continue;
                    subMonitor.done();
                    return false;
                }
            }
        }
        subMonitor.done();
        return true;
    }
}

