/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.copyfileareas;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.ICopyFileAreaListener;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.internal.FileItemInfo;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.IRemoteVisitor;
import com.ibm.team.filesystem.client.internal.ISharingMetadata;
import com.ibm.team.filesystem.client.internal.ISharingMetadata$IConnectionComponent;
import com.ibm.team.filesystem.client.internal.IVisitor;
import com.ibm.team.filesystem.client.internal.InverseFileItemInfo;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.SharingDescriptor;
import com.ibm.team.filesystem.client.internal.copyfileareas.AbstractLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.BatchingLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.CFAReadLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.ComponentLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaEvent;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaStore$1;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaStore$10;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaStore$11;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaStore$2;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaStore$3;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaStore$4;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaStore$5;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaStore$6;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaStore$7;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaStore$8;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaStore$9;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaStore$IOperation;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaStore$RuleDescriptorPair;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaStore$RuleDescriptorPairForMove;
import com.ibm.team.filesystem.client.internal.copyfileareas.ILockParticipant;
import com.ibm.team.filesystem.client.internal.copyfileareas.MultiLock;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeManager;
import com.ibm.team.filesystem.client.internal.utils.LoadedConfigurationDescriptor;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.ISyncTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.AssertionFailedException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

public abstract class CopyFileAreaStore {
    protected final ISharingMetadata metadata;
    protected final IPath path;
    protected final ListenerList listeners;
    protected final ReentrantLock sharingInfoLock;
    protected final CFAReadLock rlock;

    protected CopyFileAreaStore(IPath iPath, ISharingMetadata iSharingMetadata) {
        Assert.isNotNull((Object)iPath);
        Assert.isNotNull((Object)iSharingMetadata);
        this.path = iPath;
        this.metadata = iSharingMetadata;
        this.listeners = new ListenerList();
        this.sharingInfoLock = new ReentrantLock();
        this.rlock = new CFAReadLock(iPath);
    }

    public void addListener(ICopyFileAreaListener iCopyFileAreaListener) {
        this.listeners.add((Object)iCopyFileAreaListener);
    }

    public void removeListener(ICopyFileAreaListener iCopyFileAreaListener) {
        this.listeners.remove((Object)iCopyFileAreaListener);
    }

    public ReentrantLock getSharingLock() {
        return this.sharingInfoLock;
    }

    protected void assertReadLocked() {
        Assert.isTrue((boolean)CopyFileAreaManager.instance.batchingLock.isLocked(this.rlock));
        Assert.isTrue((this == CopyFileAreaManager.instance.getExistingCopyFileArea(this.getRoot()) ? 1 : 0) != 0);
    }

    public boolean isLocked(IComponentHandle iComponentHandle, IContextHandle iContextHandle) {
        return CopyFileAreaManager.instance.batchingLock.isLocked(new ComponentLock(this.getRoot(), iContextHandle, iComponentHandle));
    }

    public AbstractLock lock(IComponentHandle iComponentHandle, IContextHandle iContextHandle, IProgressMonitor iProgressMonitor) {
        return CopyFileAreaStore.beginBatching(new ComponentLock(this.getRoot(), iContextHandle, iComponentHandle), iProgressMonitor);
    }

    public AbstractLock lock(IPath iPath, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        this.assertReadLocked();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        CopyFileAreaStore$RuleDescriptorPair copyFileAreaStore$RuleDescriptorPair = this.beginBatching(iPath, (IProgressMonitor)subMonitor.newChild(99));
        if (copyFileAreaStore$RuleDescriptorPair.desc == null) {
            CopyFileAreaStore.endBatching(copyFileAreaStore$RuleDescriptorPair.rule, (IProgressMonitor)subMonitor.newChild(1));
            return null;
        }
        return copyFileAreaStore$RuleDescriptorPair.rule;
    }

    public void release(AbstractLock abstractLock, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        CopyFileAreaManager.instance.batchingLock.release(abstractLock, iProgressMonitor);
    }

    private void updateParentInfoForChange(FileItemInfo fileItemInfo, FileItemInfo fileItemInfo2, IComponentHandle iComponentHandle, IContextHandle iContextHandle) throws FileSystemClientException {
        if (fileItemInfo2 != null && !fileItemInfo2.getVersionableHandle().sameItemId((IItemHandle)fileItemInfo.getVersionableHandle())) {
            throw (Throwable)new IllegalArgumentException("Infos must be for the same versionable");
        }
        if (this.metadata.getPathForShareRoot(fileItemInfo.getVersionableHandle(), iComponentHandle, iContextHandle) == null) {
            if (fileItemInfo2 != null && fileItemInfo2.getParent() != null && fileItemInfo2.getParent().sameItemId((IItemHandle)fileItemInfo.getParent()) && !fileItemInfo2.getName().equals(fileItemInfo.getName())) {
                this.updateParentInfoForRename(fileItemInfo2, fileItemInfo, iComponentHandle, iContextHandle);
            } else {
                if (fileItemInfo2 != null && fileItemInfo2.getParent() != null && !fileItemInfo2.getParent().sameItemId((IItemHandle)fileItemInfo.getParent())) {
                    this.updateParentInfoForRemoval(fileItemInfo2, iComponentHandle, iContextHandle);
                }
                if (!(fileItemInfo.getParent() == null || fileItemInfo2 != null && fileItemInfo.getParent().sameItemId((IItemHandle)fileItemInfo2.getParent()))) {
                    InverseFileItemInfo inverseFileItemInfo = this.metadata.getFileItemInfo((IVersionableHandle)fileItemInfo.getParent(), iComponentHandle, iContextHandle);
                    if (inverseFileItemInfo == null) {
                        this.metadata.setCorrupt(true, "Unexpected null parent", null);
                        throw (Throwable)new RuntimeException("Detected metadata corruption");
                    }
                    InverseFileItemInfo inverseFileItemInfo2 = inverseFileItemInfo.addRemoteChild(fileItemInfo.getName(), fileItemInfo.getVersionableHandle());
                    this.metadata.setFileItemInfo((IVersionableHandle)fileItemInfo.getParent(), iComponentHandle, iContextHandle, inverseFileItemInfo2);
                }
            }
        }
    }

    private void updateParentInfoForRename(FileItemInfo fileItemInfo, FileItemInfo fileItemInfo2, IComponentHandle iComponentHandle, IContextHandle iContextHandle) throws FileSystemClientException {
        InverseFileItemInfo inverseFileItemInfo = this.metadata.getFileItemInfo((IVersionableHandle)fileItemInfo2.getParent(), iComponentHandle, iContextHandle);
        IVersionableHandle iVersionableHandle = inverseFileItemInfo.getRemoteChild(fileItemInfo.getName());
        if (iVersionableHandle == null) {
            throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.CopyFileAreaStore_0, (Object)fileItemInfo2.getName()), null)));
        }
        LinkedHashMap<String, IVersionableHandle> linkedHashMap = new LinkedHashMap<String, IVersionableHandle>(inverseFileItemInfo.getRemoteChildren());
        if (fileItemInfo.getVersionableHandle().sameItemId((IItemHandle)iVersionableHandle)) {
            linkedHashMap.remove(fileItemInfo.getName());
        }
        linkedHashMap.put(fileItemInfo2.getName(), fileItemInfo2.getVersionableHandle());
        InverseFileItemInfo inverseFileItemInfo2 = inverseFileItemInfo.withRemoteChildren(linkedHashMap);
        this.metadata.setFileItemInfo((IVersionableHandle)fileItemInfo2.getParent(), iComponentHandle, iContextHandle, inverseFileItemInfo2);
    }

    private void updateParentInfoForRemoval(FileItemInfo fileItemInfo, IComponentHandle iComponentHandle, IContextHandle iContextHandle) throws FileSystemClientException {
        if (fileItemInfo.getParent() != null) {
            InverseFileItemInfo inverseFileItemInfo = this.metadata.getFileItemInfo((IVersionableHandle)fileItemInfo.getParent(), iComponentHandle, iContextHandle);
            if (inverseFileItemInfo == null) {
                return;
            }
            IVersionableHandle iVersionableHandle = inverseFileItemInfo.getRemoteChild(fileItemInfo.getName());
            if (iVersionableHandle == null) {
                throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.CopyFileAreaStore_0, (Object)fileItemInfo.getName()), null)));
            }
            if (!fileItemInfo.getVersionableHandle().sameItemId((IItemHandle)iVersionableHandle)) {
                return;
            }
            InverseFileItemInfo inverseFileItemInfo2 = inverseFileItemInfo.removeRemoteChild(fileItemInfo.getName());
            this.metadata.setFileItemInfo((IVersionableHandle)fileItemInfo.getParent(), iComponentHandle, iContextHandle, inverseFileItemInfo2);
        }
    }

    private void updateLocalParent(IPath iPath, IFolderHandle iFolderHandle, IComponentHandle iComponentHandle, IContextHandle iContextHandle) throws FileSystemClientException {
        Map map = this.metadata.getChildInfos(iPath);
        for (FileItemInfo fileItemInfo : map.values()) {
            InverseFileItemInfo inverseFileItemInfo = this.metadata.getFileItemInfo(fileItemInfo.getVersionableHandle(), iComponentHandle, iContextHandle);
            if (inverseFileItemInfo.getLocalName() == null) continue;
            InverseFileItemInfo inverseFileItemInfo2 = inverseFileItemInfo.withLocalParent(iFolderHandle);
            this.metadata.setFileItemInfo(inverseFileItemInfo2.getVersionableHandle(), iComponentHandle, iContextHandle, inverseFileItemInfo2);
        }
    }

    public FileItemInfo setItemInfo(IPath iPath, FileItemInfo fileItemInfo, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        FileItemInfo fileItemInfo2;
        SubMonitor subMonitor;
        block15: {
            Assert.isNotNull((Object)fileItemInfo);
            this.assertReadLocked();
            AbstractLock abstractLock = null;
            subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)2);
            try {
                Object object;
                FileItemInfo fileItemInfo3;
                Object object2;
                IFolderHandle iFolderHandle;
                CopyFileAreaStore$RuleDescriptorPair copyFileAreaStore$RuleDescriptorPair = this.beginBatching(iPath, (IProgressMonitor)subMonitor.newChild(1));
                ISharingDescriptor iSharingDescriptor = copyFileAreaStore$RuleDescriptorPair.desc;
                abstractLock = copyFileAreaStore$RuleDescriptorPair.rule;
                InverseFileItemInfo inverseFileItemInfo = this.metadata.getFileItemInfo(fileItemInfo.getVersionableHandle(), iSharingDescriptor.getComponent(), iSharingDescriptor.getConnectionHandle());
                if (fileItemInfo.getVersionableHandle().sameItemId((IItemHandle)iSharingDescriptor.getRootVersionable())) {
                    iFolderHandle = fileItemInfo.getParent();
                    if (inverseFileItemInfo != null && !inverseFileItemInfo.getVersionableHandle().sameItemId((IItemHandle)fileItemInfo.getVersionableHandle())) {
                        throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, "Internal error: Share root must be at root of share", null)));
                    }
                } else {
                    object2 = this.metadata.getFileItemInfo(iPath.removeLastSegments(1));
                    if (object2 == null) {
                        throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, NLS.bind((String)"Internal error: Parent info missing for path {0}", (Object)iPath.toOSString()), null)));
                    }
                    iFolderHandle = (IFolderHandle)((FileItemInfo)object2).getVersionableHandle();
                    if (!(inverseFileItemInfo == null || inverseFileItemInfo.getLocalParent() == null || iFolderHandle != null && iFolderHandle.sameItemId((IItemHandle)inverseFileItemInfo.getLocalParent()))) {
                        throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.CopyFileAreaStore_3, (Object)iPath.toString(), (Object)this.getLocalPathInternal(inverseFileItemInfo, iSharingDescriptor.getComponent(), iSharingDescriptor.getConnectionHandle())), null)));
                    }
                }
                object2 = iPath.lastSegment();
                if (this.isCaseSensitive()) {
                    fileItemInfo3 = this.metadata.setFileItemInfo(iPath, fileItemInfo);
                } else {
                    fileItemInfo3 = this.metadata.setFileItemInfo(iPath, null);
                    this.metadata.setFileItemInfo(iPath, fileItemInfo);
                }
                if (fileItemInfo3 != null && !fileItemInfo.getVersionableHandle().sameItemId((IItemHandle)fileItemInfo3.getVersionableHandle())) {
                    if (fileItemInfo3.getVersionableHandle().sameItemId((IItemHandle)iSharingDescriptor.getRootVersionable())) {
                        throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, "Internal error: Cannot change share root item id this way", null)));
                    }
                    if (fileItemInfo3.getVersionableHandle() instanceof IFolderHandle) {
                        this.updateLocalParent(iPath, (IFolderHandle)fileItemInfo.getVersionableHandle(), iSharingDescriptor.getComponent(), iSharingDescriptor.getConnectionHandle());
                    }
                    if (fileItemInfo3.getVersionableHandle().hasStateId()) {
                        object = this.metadata.getFileItemInfo(fileItemInfo3.getVersionableHandle(), iSharingDescriptor.getComponent(), iSharingDescriptor.getConnectionHandle());
                        object = new InverseFileItemInfo(((FileItemInfo)object).getVersionableHandle(), false, -1L, ((FileItemInfo)object).getParent(), ((FileItemInfo)object).getName(), ((FileItemInfo)object).isLoadedWithAnotherName(), ((InverseFileItemInfo)object).getRemoteChildren(), null, null, ((FileItemInfo)object).getHash(), ((FileItemInfo)object).getContentLength(), ((FileItemInfo)object).getOriginalLineDelimiter(), ((FileItemInfo)object).getLineDelimiter(), ((FileItemInfo)object).getOriginalContentType(), ((FileItemInfo)object).getContentType(), ((FileItemInfo)object).getStoredPredecessorHintHash(), ((FileItemInfo)object).getStoredSize(), ((FileItemInfo)object).getStoredEncoding(), ((FileItemInfo)object).getStoredHash(), ((FileItemInfo)object).getStoredNumLineDelimiters(), ((FileItemInfo)object).isOriginalExecutable(), ((FileItemInfo)object).isOriginalExecutable());
                        this.metadata.setFileItemInfo(fileItemInfo3.getVersionableHandle(), iSharingDescriptor.getComponent(), iSharingDescriptor.getConnectionHandle(), (InverseFileItemInfo)object);
                    } else {
                        this.metadata.setFileItemInfo(fileItemInfo3.getVersionableHandle(), iSharingDescriptor.getComponent(), iSharingDescriptor.getConnectionHandle(), null);
                    }
                }
                this.updateParentInfoForChange(fileItemInfo, inverseFileItemInfo, iSharingDescriptor.getComponent(), iSharingDescriptor.getConnectionHandle());
                object = fileItemInfo.isFolder() ? (inverseFileItemInfo != null ? inverseFileItemInfo.getRemoteChildren() : Collections.EMPTY_MAP) : Collections.EMPTY_MAP;
                InverseFileItemInfo inverseFileItemInfo2 = new InverseFileItemInfo(fileItemInfo.getVersionableHandle(), fileItemInfo.isContentChanged(), fileItemInfo.getLastContentChangeCheckStamp(), fileItemInfo.getParent(), fileItemInfo.getName(), fileItemInfo.isLoadedWithAnotherName(), (Map)object, iFolderHandle, (String)object2, fileItemInfo.getHash(), fileItemInfo.getContentLength(), fileItemInfo.getOriginalLineDelimiter(), fileItemInfo.getLineDelimiter(), fileItemInfo.getOriginalContentType(), fileItemInfo.getContentType(), fileItemInfo.getStoredPredecessorHintHash(), fileItemInfo.getStoredSize(), fileItemInfo.getStoredEncoding(), fileItemInfo.getStoredHash(), fileItemInfo.getStoredNumLineDelimiters(), fileItemInfo.isExecutable(), fileItemInfo.isOriginalExecutable());
                this.metadata.setFileItemInfo(fileItemInfo.getVersionableHandle(), iSharingDescriptor.getComponent(), iSharingDescriptor.getConnectionHandle(), inverseFileItemInfo2);
                fileItemInfo2 = fileItemInfo3;
                if (abstractLock == null) break block15;
            }
            catch (Throwable throwable) {
                if (abstractLock != null) {
                    CopyFileAreaStore.endBatching(abstractLock, (IProgressMonitor)subMonitor.newChild(1));
                }
                subMonitor.done();
                throw throwable;
            }
            CopyFileAreaStore.endBatching(abstractLock, (IProgressMonitor)subMonitor.newChild(1));
        }
        subMonitor.done();
        return fileItemInfo2;
    }

    public FileItemInfo setItemInfo(IVersionableHandle iVersionableHandle, IComponentHandle iComponentHandle, IContextHandle iContextHandle, FileItemInfo fileItemInfo, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        InverseFileItemInfo inverseFileItemInfo;
        SubMonitor subMonitor;
        block6: {
            this.assertReadLocked();
            AbstractLock abstractLock = null;
            subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
            try {
                IFolderHandle iFolderHandle;
                String string;
                abstractLock = CopyFileAreaStore.beginBatching(new ComponentLock(this.getRoot(), iContextHandle, iComponentHandle), (IProgressMonitor)subMonitor.newChild(1));
                InverseFileItemInfo inverseFileItemInfo2 = this.metadata.getFileItemInfo(iVersionableHandle, iComponentHandle, iContextHandle);
                this.updateParentInfoForChange(fileItemInfo, inverseFileItemInfo2, iComponentHandle, iContextHandle);
                Map map = fileItemInfo.isFolder() && inverseFileItemInfo2 != null ? inverseFileItemInfo2.getRemoteChildren() : Collections.EMPTY_MAP;
                IPath iPath = this.getLocalPathInternal(inverseFileItemInfo2, iComponentHandle, iContextHandle);
                if (iPath != null) {
                    this.metadata.setFileItemInfo(iPath, fileItemInfo);
                }
                if (inverseFileItemInfo2 != null) {
                    string = inverseFileItemInfo2.getLocalName();
                    iFolderHandle = inverseFileItemInfo2.getLocalParent();
                } else {
                    string = null;
                    iFolderHandle = null;
                }
                InverseFileItemInfo inverseFileItemInfo3 = new InverseFileItemInfo(fileItemInfo.getVersionableHandle(), fileItemInfo.isContentChanged(), fileItemInfo.getLastContentChangeCheckStamp(), fileItemInfo.getParent(), fileItemInfo.getName(), fileItemInfo.isLoadedWithAnotherName(), map, iFolderHandle, string, fileItemInfo.getHash(), fileItemInfo.getContentLength(), fileItemInfo.getOriginalLineDelimiter(), fileItemInfo.getLineDelimiter(), fileItemInfo.getOriginalContentType(), fileItemInfo.getContentType(), fileItemInfo.getStoredPredecessorHintHash(), fileItemInfo.getStoredSize(), fileItemInfo.getStoredEncoding(), fileItemInfo.getStoredHash(), fileItemInfo.getStoredNumLineDelimiters(), fileItemInfo.isExecutable(), fileItemInfo.isOriginalExecutable());
                this.metadata.setFileItemInfo(iVersionableHandle, iComponentHandle, iContextHandle, inverseFileItemInfo3);
                subMonitor.worked(98);
                inverseFileItemInfo = inverseFileItemInfo2;
                if (abstractLock == null) break block6;
            }
            catch (Throwable throwable) {
                if (abstractLock != null) {
                    CopyFileAreaStore.endBatching(abstractLock, (IProgressMonitor)subMonitor.newChild(1));
                }
                subMonitor.done();
                throw throwable;
            }
            CopyFileAreaStore.endBatching(abstractLock, (IProgressMonitor)subMonitor.newChild(1));
        }
        subMonitor.done();
        return inverseFileItemInfo;
    }

    public Map getChildInfos(IPath iPath, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        this.assertReadLocked();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        Map map = this.metadata.getChildInfos(iPath);
        subMonitor.done();
        return map;
    }

    /*
     * Unable to fully structure code
     */
    public UUID getRemoteAncestor(Set var1_1, IVersionableHandle var2_2, IComponentHandle var3_3, IContextHandle var4_4, IProgressMonitor var5_5) throws FileSystemClientException {
        block10: {
            block8: {
                block9: {
                    block7: {
                        this.assertReadLocked();
                        var6_6 = SubMonitor.convert((IProgressMonitor)var5_5, (int)100);
                        var7_7 = null;
                        if (!var1_1.isEmpty()) break block7;
                        while (true) {
                            if (var7_7 != null) {
                                CopyFileAreaStore.endBatching(var7_7, (IProgressMonitor)var6_6.newChild(1));
                            }
                            var6_6.done();
                            return null;
                        }
                    }
                    try {
                        if (!var1_1.contains(var2_2.getItemId())) break block8;
                        var11_8 = var2_2.getItemId();
                        if (var7_7 == null) break block9;
                    }
                    catch (Throwable var10_12) {
                        if (var7_7 != null) {
                            CopyFileAreaStore.endBatching(var7_7, (IProgressMonitor)var6_6.newChild(1));
                        }
                        var6_6.done();
                        throw var10_12;
                    }
                    CopyFileAreaStore.endBatching(var7_7, (IProgressMonitor)var6_6.newChild(1));
                }
                var6_6.done();
                return var11_8;
            }
            var7_7 = CopyFileAreaStore.beginBatching(new ComponentLock(this.getRoot(), var4_4, var3_3), (IProgressMonitor)var6_6.newChild(1));
            if ((var8_10 = this.metadata.getFileItemInfo(var2_2, var3_3, var4_4)) == null || !var8_10.getVersionableHandle().hasStateId() || (var9_11 = this.metadata.getPathForShareRoot(var8_10.getVersionableHandle(), var3_3, var4_4)) != null) ** continue;
            var11_9 = this.getRemoteAncestorInternal_rec(var1_1, (IVersionableHandle)var8_10.getParent(), var3_3, var4_4);
            if (var7_7 == null) break block10;
            CopyFileAreaStore.endBatching(var7_7, (IProgressMonitor)var6_6.newChild(1));
        }
        var6_6.done();
        return var11_9;
    }

    private UUID getRemoteAncestorInternal(Set set, IVersionableHandle iVersionableHandle, IComponentHandle iComponentHandle, IContextHandle iContextHandle) throws FileSystemClientException {
        if (set.isEmpty()) {
            return null;
        }
        if (set.contains(iVersionableHandle.getItemId())) {
            return iVersionableHandle.getItemId();
        }
        InverseFileItemInfo inverseFileItemInfo = this.metadata.getFileItemInfo(iVersionableHandle, iComponentHandle, iContextHandle);
        if (inverseFileItemInfo == null) {
            return null;
        }
        IPath iPath = this.metadata.getPathForShareRoot(inverseFileItemInfo.getVersionableHandle(), iComponentHandle, iContextHandle);
        if (iPath != null) {
            return null;
        }
        if (inverseFileItemInfo.getName() == null) {
            return null;
        }
        return this.getRemoteAncestorInternal_rec(set, (IVersionableHandle)inverseFileItemInfo.getParent(), iComponentHandle, iContextHandle);
    }

    private UUID getRemoteAncestorInternal_rec(Set set, IVersionableHandle iVersionableHandle, IComponentHandle iComponentHandle, IContextHandle iContextHandle) throws FileSystemClientException {
        while (!set.contains(iVersionableHandle.getItemId())) {
            IPath iPath = this.metadata.getPathForShareRoot(iVersionableHandle, iComponentHandle, iContextHandle);
            if (iPath != null) {
                return null;
            }
            InverseFileItemInfo inverseFileItemInfo = this.metadata.getFileItemInfo(iVersionableHandle, iComponentHandle, iContextHandle);
            if (inverseFileItemInfo == null) {
                throw (Throwable)new IllegalStateException(NLS.bind((String)Messages.CopyFileAreaStore_6, (Object)((FileItemInfo)inverseFileItemInfo).getVersionableHandle()));
            }
            if (((FileItemInfo)inverseFileItemInfo).getName() == null) {
                throw (Throwable)new IllegalStateException(NLS.bind((String)Messages.CopyFileAreaStore_7, (Object)((FileItemInfo)inverseFileItemInfo).getVersionableHandle()));
            }
            iVersionableHandle = ((FileItemInfo)inverseFileItemInfo).getParent();
        }
        return iVersionableHandle.getItemId();
    }

    public IPath getRemotePathFor(IPath iPath, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        IPath iPath2;
        SubMonitor subMonitor;
        block12: {
            FileItemInfo fileItemInfo;
            ISharingDescriptor iSharingDescriptor;
            AbstractLock abstractLock;
            block8: {
                IPath iPath3;
                block11: {
                    IPath iPath4;
                    block9: {
                        IPath iPath5;
                        block10: {
                            block6: {
                                block7: {
                                    this.assertReadLocked();
                                    abstractLock = null;
                                    subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
                                    try {
                                        CopyFileAreaStore$RuleDescriptorPair copyFileAreaStore$RuleDescriptorPair = this.beginBatching(iPath, (IProgressMonitor)subMonitor.newChild(1));
                                        iSharingDescriptor = copyFileAreaStore$RuleDescriptorPair.desc;
                                        abstractLock = copyFileAreaStore$RuleDescriptorPair.rule;
                                        fileItemInfo = this.metadata.getFileItemInfo(iPath);
                                        if (fileItemInfo != null && fileItemInfo.getVersionableHandle().hasStateId()) break block6;
                                        if (abstractLock == null) break block7;
                                    }
                                    catch (Throwable throwable) {
                                        if (abstractLock != null) {
                                            CopyFileAreaStore.endBatching(abstractLock, (IProgressMonitor)subMonitor.newChild(1));
                                        }
                                        subMonitor.done();
                                        throw throwable;
                                    }
                                    CopyFileAreaStore.endBatching(abstractLock, (IProgressMonitor)subMonitor.newChild(1));
                                }
                                subMonitor.done();
                                return null;
                            }
                            iPath4 = this.metadata.getPathForShareRoot(fileItemInfo.getVersionableHandle(), iSharingDescriptor.getComponent(), iSharingDescriptor.getConnectionHandle());
                            if (iPath4 == null) break block8;
                            if (fileItemInfo.getName() == null || fileItemInfo.getName().equals(iPath4.lastSegment())) break block9;
                            iPath5 = iPath4.removeLastSegments(1).append(fileItemInfo.getName());
                            if (abstractLock == null) break block10;
                            CopyFileAreaStore.endBatching(abstractLock, (IProgressMonitor)subMonitor.newChild(1));
                        }
                        subMonitor.done();
                        return iPath5;
                    }
                    iPath3 = iPath4;
                    if (abstractLock == null) break block11;
                    CopyFileAreaStore.endBatching(abstractLock, (IProgressMonitor)subMonitor.newChild(1));
                }
                subMonitor.done();
                return iPath3;
            }
            iPath2 = this.getRemotePathInternal((IVersionableHandle)fileItemInfo.getParent(), iSharingDescriptor.getComponent(), iSharingDescriptor.getConnectionHandle()).append(fileItemInfo.getName());
            if (abstractLock == null) break block12;
            CopyFileAreaStore.endBatching(abstractLock, (IProgressMonitor)subMonitor.newChild(1));
        }
        subMonitor.done();
        return iPath2;
    }

    public IPath getRemotePathFor(IVersionableHandle iVersionableHandle, IComponentHandle iComponentHandle, IContextHandle iContextHandle, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        IPath iPath;
        SubMonitor subMonitor;
        block12: {
            InverseFileItemInfo inverseFileItemInfo;
            AbstractLock abstractLock;
            block8: {
                IPath iPath2;
                block11: {
                    IPath iPath3;
                    block9: {
                        IPath iPath4;
                        block10: {
                            block6: {
                                block7: {
                                    this.assertReadLocked();
                                    abstractLock = null;
                                    subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
                                    try {
                                        abstractLock = CopyFileAreaStore.beginBatching(new ComponentLock(this.getRoot(), iContextHandle, iComponentHandle), (IProgressMonitor)subMonitor.newChild(1));
                                        inverseFileItemInfo = this.metadata.getFileItemInfo(iVersionableHandle, iComponentHandle, iContextHandle);
                                        if (inverseFileItemInfo != null && inverseFileItemInfo.getVersionableHandle().hasStateId()) break block6;
                                        if (abstractLock == null) break block7;
                                    }
                                    catch (Throwable throwable) {
                                        if (abstractLock != null) {
                                            CopyFileAreaStore.endBatching(abstractLock, (IProgressMonitor)subMonitor.newChild(1));
                                        }
                                        subMonitor.done();
                                        throw throwable;
                                    }
                                    CopyFileAreaStore.endBatching(abstractLock, (IProgressMonitor)subMonitor.newChild(1));
                                }
                                subMonitor.done();
                                return null;
                            }
                            iPath3 = this.metadata.getPathForShareRoot(inverseFileItemInfo.getVersionableHandle(), iComponentHandle, iContextHandle);
                            if (iPath3 == null) break block8;
                            if (inverseFileItemInfo.getName() == null || inverseFileItemInfo.getName().equals(iPath3.lastSegment())) break block9;
                            iPath4 = iPath3.removeLastSegments(1).append(inverseFileItemInfo.getName());
                            if (abstractLock == null) break block10;
                            CopyFileAreaStore.endBatching(abstractLock, (IProgressMonitor)subMonitor.newChild(1));
                        }
                        subMonitor.done();
                        return iPath4;
                    }
                    iPath2 = iPath3;
                    if (abstractLock == null) break block11;
                    CopyFileAreaStore.endBatching(abstractLock, (IProgressMonitor)subMonitor.newChild(1));
                }
                subMonitor.done();
                return iPath2;
            }
            iPath = this.getRemotePathInternal((IVersionableHandle)inverseFileItemInfo.getParent(), iComponentHandle, iContextHandle).append(inverseFileItemInfo.getName());
            if (abstractLock == null) break block12;
            CopyFileAreaStore.endBatching(abstractLock, (IProgressMonitor)subMonitor.newChild(1));
        }
        subMonitor.done();
        return iPath;
    }

    private IPath getRemotePathInternal(IVersionableHandle iVersionableHandle, IComponentHandle iComponentHandle, IContextHandle iContextHandle) throws FileSystemClientException {
        InverseFileItemInfo inverseFileItemInfo = this.metadata.getFileItemInfo(iVersionableHandle, iComponentHandle, iContextHandle);
        if (inverseFileItemInfo == null || !((FileItemInfo)inverseFileItemInfo).getVersionableHandle().hasStateId()) {
            return null;
        }
        IPath iPath = this.metadata.getPathForShareRoot(iVersionableHandle, iComponentHandle, iContextHandle);
        if (iPath != null) {
            if (((FileItemInfo)inverseFileItemInfo).getName() != null && !((FileItemInfo)inverseFileItemInfo).getName().equals(iPath.lastSegment())) {
                return iPath.removeLastSegments(1).append(((FileItemInfo)inverseFileItemInfo).getName());
            }
            return iPath;
        }
        return this.getRemotePathInternal_rec(inverseFileItemInfo, iComponentHandle, iContextHandle);
    }

    private IPath getRemotePathInternal_rec(FileItemInfo fileItemInfo, IComponentHandle iComponentHandle, IContextHandle iContextHandle) throws FileSystemClientException {
        ArrayList<String> arrayList = null;
        int n = 0;
        while (true) {
            String string;
            IPath iPath;
            if ((iPath = this.metadata.getPathForShareRoot(fileItemInfo.getVersionableHandle(), iComponentHandle, iContextHandle)) != null) {
                if (fileItemInfo.getName() != null && !fileItemInfo.getName().equals(iPath.lastSegment())) {
                    if (arrayList == null) {
                        return iPath.removeLastSegments(1).append(fileItemInfo.getName());
                    }
                    iPath = iPath.removeLastSegments(1);
                    string = fileItemInfo.getName();
                    n += string.length();
                    arrayList.add(string);
                } else if (arrayList == null) {
                    return iPath;
                }
                int n2 = arrayList.size() - 1;
                if (n2 == 0) {
                    return iPath.append((String)arrayList.get(0));
                }
                StringBuilder stringBuilder = new StringBuilder(n + n2);
                stringBuilder.append((String)arrayList.get(n2));
                int n3 = n2 - 1;
                while (n3 >= 0) {
                    stringBuilder.append('/');
                    stringBuilder.append((String)arrayList.get(n3));
                    --n3;
                }
                return iPath.append(stringBuilder.toString());
            }
            string = fileItemInfo.getName();
            if (string == null) {
                throw (Throwable)new IllegalStateException(NLS.bind((String)Messages.CopyFileAreaStore_8, (Object)fileItemInfo.getVersionableHandle()));
            }
            if (arrayList == null) {
                arrayList = new ArrayList<String>();
            }
            n += string.length();
            arrayList.add(string);
            fileItemInfo = this.metadata.getFileItemInfo((IVersionableHandle)fileItemInfo.getParent(), iComponentHandle, iContextHandle);
        }
    }

    public List getLocalPathFor(List list, IComponentHandle iComponentHandle, IContextHandle iContextHandle, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        ArrayList<IPath> arrayList;
        SubMonitor subMonitor;
        block4: {
            this.assertReadLocked();
            AbstractLock abstractLock = null;
            subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
            try {
                abstractLock = CopyFileAreaStore.beginBatching(new ComponentLock(this.getRoot(), iContextHandle, iComponentHandle), (IProgressMonitor)subMonitor.newChild(1));
                ArrayList<IPath> arrayList2 = new ArrayList<IPath>(list.size());
                SubMonitor subMonitor2 = subMonitor.newChild(98);
                subMonitor2.setWorkRemaining(list.size());
                for (IVersionableHandle iVersionableHandle : list) {
                    arrayList2.add(this.getLocalPathInternal(iVersionableHandle, iComponentHandle, iContextHandle));
                    subMonitor2.worked(1);
                }
                subMonitor2.done();
                arrayList = arrayList2;
                if (abstractLock == null) break block4;
            }
            catch (Throwable throwable) {
                if (abstractLock != null) {
                    CopyFileAreaStore.endBatching(abstractLock, (IProgressMonitor)subMonitor.newChild(1));
                }
                subMonitor.done();
                throw throwable;
            }
            CopyFileAreaStore.endBatching(abstractLock, (IProgressMonitor)subMonitor.newChild(1));
        }
        subMonitor.done();
        return arrayList;
    }

    public IPath getLocalPathFor(IVersionableHandle iVersionableHandle, IComponentHandle iComponentHandle, IContextHandle iContextHandle, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        IPath iPath;
        SubMonitor subMonitor;
        block3: {
            this.assertReadLocked();
            AbstractLock abstractLock = null;
            subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
            try {
                abstractLock = CopyFileAreaStore.beginBatching(new ComponentLock(this.getRoot(), iContextHandle, iComponentHandle), (IProgressMonitor)subMonitor.newChild(1));
                iPath = this.getLocalPathInternal(iVersionableHandle, iComponentHandle, iContextHandle);
                if (abstractLock == null) break block3;
            }
            catch (Throwable throwable) {
                if (abstractLock != null) {
                    CopyFileAreaStore.endBatching(abstractLock, (IProgressMonitor)subMonitor.newChild(1));
                }
                subMonitor.done();
                throw throwable;
            }
            CopyFileAreaStore.endBatching(abstractLock, (IProgressMonitor)subMonitor.newChild(1));
        }
        subMonitor.done();
        return iPath;
    }

    private IPath getLocalPathInternal(IVersionableHandle iVersionableHandle, IComponentHandle iComponentHandle, IContextHandle iContextHandle) throws FileSystemClientException {
        InverseFileItemInfo inverseFileItemInfo = this.metadata.getFileItemInfo(iVersionableHandle, iComponentHandle, iContextHandle);
        return this.getLocalPathInternal(inverseFileItemInfo, iComponentHandle, iContextHandle);
    }

    private IPath getLocalPathInternal(InverseFileItemInfo inverseFileItemInfo, IComponentHandle iComponentHandle, IContextHandle iContextHandle) throws FileSystemClientException {
        if (inverseFileItemInfo == null) {
            return null;
        }
        IPath iPath = this.metadata.getPathForShareRoot(inverseFileItemInfo.getVersionableHandle(), iComponentHandle, iContextHandle);
        if (iPath != null) {
            return iPath;
        }
        if (inverseFileItemInfo.getLocalName() == null) {
            return null;
        }
        return this.getLocalPathInternal_rec(this.metadata.getFileItemInfo((IVersionableHandle)inverseFileItemInfo.getLocalParent(), iComponentHandle, iContextHandle), iComponentHandle, iContextHandle).append(inverseFileItemInfo.getLocalName());
    }

    private IPath getLocalPathInternal_rec(InverseFileItemInfo inverseFileItemInfo, IComponentHandle iComponentHandle, IContextHandle iContextHandle) throws FileSystemClientException {
        ArrayList<String> arrayList = null;
        int n = 0;
        while (true) {
            IPath iPath;
            if ((iPath = this.metadata.getPathForShareRoot(inverseFileItemInfo.getVersionableHandle(), iComponentHandle, iContextHandle)) != null) {
                if (arrayList == null) {
                    return iPath;
                }
                int n2 = arrayList.size() - 1;
                if (n2 == 0) {
                    return iPath.append((String)arrayList.get(0));
                }
                StringBuilder stringBuilder = new StringBuilder(n + n2);
                stringBuilder.append((String)arrayList.get(n2));
                int n3 = n2 - 1;
                while (n3 >= 0) {
                    stringBuilder.append('/');
                    stringBuilder.append((String)arrayList.get(n3));
                    --n3;
                }
                return iPath.append(stringBuilder.toString());
            }
            String string = inverseFileItemInfo.getLocalName();
            if (string == null) {
                throw (Throwable)new IllegalStateException(NLS.bind((String)Messages.CopyFileAreaStore_10, (Object)inverseFileItemInfo.getVersionableHandle()));
            }
            if (arrayList == null) {
                arrayList = new ArrayList<String>();
            }
            n += string.length();
            arrayList.add(string);
            inverseFileItemInfo = this.metadata.getFileItemInfo((IVersionableHandle)inverseFileItemInfo.getLocalParent(), iComponentHandle, iContextHandle);
        }
    }

    public InverseFileItemInfo getItemInfo(IVersionableHandle iVersionableHandle, IComponentHandle iComponentHandle, IContextHandle iContextHandle) {
        this.assertReadLocked();
        try {
            return this.metadata.getFileItemInfo(iVersionableHandle, iComponentHandle, iContextHandle);
        }
        catch (FileSystemClientException fileSystemClientException) {
            LoggingHelper.log(fileSystemClientException);
            return null;
        }
    }

    /*
     * Loose catch block
     */
    public FileItemInfo getDeletedItem(IFolderHandle iFolderHandle, String string, IComponentHandle iComponentHandle, IContextHandle iContextHandle, IProgressMonitor iProgressMonitor) {
        block17: {
            SubMonitor subMonitor;
            AbstractLock abstractLock;
            block14: {
                InverseFileItemInfo inverseFileItemInfo;
                block15: {
                    IVersionableHandle iVersionableHandle;
                    this.assertReadLocked();
                    abstractLock = null;
                    subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
                    abstractLock = CopyFileAreaStore.beginBatching(new ComponentLock(this.getRoot(), iContextHandle, iComponentHandle), (IProgressMonitor)subMonitor.newChild(1));
                    InverseFileItemInfo inverseFileItemInfo2 = this.metadata.getFileItemInfo((IVersionableHandle)iFolderHandle, iComponentHandle, iContextHandle);
                    if (inverseFileItemInfo2 == null || (iVersionableHandle = (IVersionableHandle)inverseFileItemInfo2.getRemoteChildren().get(string)) == null || (inverseFileItemInfo2 = this.metadata.getFileItemInfo(iVersionableHandle, iComponentHandle, iContextHandle)).getLocalName() != null) break block14;
                    inverseFileItemInfo = inverseFileItemInfo2;
                    if (abstractLock == null) break block15;
                    try {
                        CopyFileAreaStore.endBatching(abstractLock, (IProgressMonitor)subMonitor.newChild(1));
                    }
                    catch (FileSystemClientException fileSystemClientException) {
                        LoggingHelper.log(fileSystemClientException);
                    }
                }
                subMonitor.done();
                return inverseFileItemInfo;
                catch (FileSystemClientException fileSystemClientException) {
                    block16: {
                        try {
                            LoggingHelper.log(fileSystemClientException);
                            if (abstractLock == null) break block16;
                        }
                        catch (Throwable throwable) {
                            if (abstractLock != null) {
                                try {
                                    CopyFileAreaStore.endBatching(abstractLock, (IProgressMonitor)subMonitor.newChild(1));
                                }
                                catch (FileSystemClientException fileSystemClientException2) {
                                    LoggingHelper.log(fileSystemClientException2);
                                }
                            }
                            subMonitor.done();
                            throw throwable;
                        }
                        try {
                            CopyFileAreaStore.endBatching(abstractLock, (IProgressMonitor)subMonitor.newChild(1));
                        }
                        catch (FileSystemClientException fileSystemClientException3) {
                            LoggingHelper.log(fileSystemClientException3);
                        }
                    }
                    subMonitor.done();
                    break block17;
                }
            }
            if (abstractLock != null) {
                try {
                    CopyFileAreaStore.endBatching(abstractLock, (IProgressMonitor)subMonitor.newChild(1));
                }
                catch (FileSystemClientException fileSystemClientException) {
                    LoggingHelper.log(fileSystemClientException);
                }
            }
            subMonitor.done();
        }
        return null;
    }

    public Collection getLocalItemPaths(IVersionableHandle iVersionableHandle, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        Collection collection;
        AbstractLock abstractLock;
        SubMonitor subMonitor;
        this.assertReadLocked();
        SubMonitor subMonitor2 = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        Collection collection2 = this.metadata.getLocations(iVersionableHandle);
        block7: while (true) {
            Object object2;
            subMonitor2.setWorkRemaining(100);
            if (collection2.isEmpty()) {
                return Collections.EMPTY_LIST;
            }
            subMonitor = new AbstractLock[collection2.size()];
            int n = 0;
            for (Object object2 : collection2) {
                subMonitor[n++] = new ComponentLock(this.getRoot(), object2.getConnection(), object2.getComponent());
            }
            object2 = MultiLock.combine((AbstractLock[])subMonitor);
            abstractLock = CopyFileAreaStore.beginBatching((AbstractLock)object2, (IProgressMonitor)subMonitor2.newChild(1));
            boolean bl = false;
            try {
                collection = this.metadata.getLocations(iVersionableHandle);
                if (collection.size() != collection2.size()) {
                    collection2 = collection;
                    continue;
                }
                HashSet hashSet = new HashSet(collection2);
                collection2 = collection;
                for (Object object3 : collection) {
                    if (!hashSet.contains(object3)) continue block7;
                }
                bl = true;
            }
            finally {
                if (bl) continue;
                CopyFileAreaStore.endBatching(abstractLock, (IProgressMonitor)subMonitor2.newChild(1));
                continue;
            }
            break;
        }
        try {
            Object object3;
            subMonitor = subMonitor2.newChild(98);
            subMonitor.setWorkRemaining(collection2.size());
            ArrayList<Collection> arrayList = new ArrayList<Collection>(collection2.size());
            for (Object object2 : collection2) {
                collection = this.getLocalPathInternal(iVersionableHandle, object2.getComponent(), object2.getConnection());
                if (collection != null) {
                    arrayList.add(collection);
                }
                subMonitor.worked(1);
            }
            subMonitor.done();
            object3 = arrayList;
            return (Collection)object3;
        }
        finally {
            CopyFileAreaStore.endBatching(abstractLock, (IProgressMonitor)subMonitor2.newChild(1));
            subMonitor2.done();
        }
    }

    public Collection getLocalItemPaths(IVersionableHandle iVersionableHandle, IContextHandle iContextHandle, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        AbstractLock abstractLock;
        Object object2;
        int n;
        SubMonitor subMonitor;
        this.assertReadLocked();
        SubMonitor subMonitor2 = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        Collection collection = this.metadata.getLocations(iVersionableHandle);
        block7: while (true) {
            subMonitor2.setWorkRemaining(100);
            subMonitor = new AbstractLock[collection.size()];
            n = 0;
            for (Object object2 : collection) {
                if (!object2.getConnection().sameItemId((IItemHandle)iContextHandle)) continue;
                subMonitor[n++] = new ComponentLock(this.getRoot(), object2.getConnection(), object2.getComponent());
            }
            if (n == 0) {
                return Collections.EMPTY_LIST;
            }
            object2 = MultiLock.combine((AbstractLock[])subMonitor);
            abstractLock = CopyFileAreaStore.beginBatching((AbstractLock)object2, (IProgressMonitor)subMonitor2.newChild(1));
            boolean bl = false;
            try {
                HashSet<ISharingMetadata$IConnectionComponent> hashSet = new HashSet<ISharingMetadata$IConnectionComponent>(n * 4 / 3);
                for (ISharingMetadata$IConnectionComponent iSharingMetadata$IConnectionComponent2 : collection) {
                    if (!iSharingMetadata$IConnectionComponent2.getConnection().sameItemId((IItemHandle)iContextHandle)) continue;
                    hashSet.add(iSharingMetadata$IConnectionComponent2);
                }
                collection = this.metadata.getLocations(iVersionableHandle);
                n = 0;
                for (ISharingMetadata$IConnectionComponent iSharingMetadata$IConnectionComponent2 : collection) {
                    if (!iSharingMetadata$IConnectionComponent2.getConnection().sameItemId((IItemHandle)iContextHandle)) continue;
                    if (!hashSet.contains(iSharingMetadata$IConnectionComponent2)) continue block7;
                    ++n;
                }
                if (n != hashSet.size()) continue;
                bl = true;
            }
            finally {
                if (bl) continue;
                CopyFileAreaStore.endBatching(abstractLock, (IProgressMonitor)subMonitor2.newChild(1));
                continue;
            }
            break;
        }
        try {
            subMonitor = subMonitor2.newChild(98);
            subMonitor.setWorkRemaining(n);
            object2 = new ArrayList<ISharingMetadata$IConnectionComponent>(n);
            for (ISharingMetadata$IConnectionComponent iSharingMetadata$IConnectionComponent : collection) {
                ISharingMetadata$IConnectionComponent iSharingMetadata$IConnectionComponent2;
                if (!iSharingMetadata$IConnectionComponent.getConnection().sameItemId((IItemHandle)iContextHandle)) continue;
                iSharingMetadata$IConnectionComponent2 = this.getLocalPathInternal(iVersionableHandle, iSharingMetadata$IConnectionComponent.getComponent(), iSharingMetadata$IConnectionComponent.getConnection());
                if (iSharingMetadata$IConnectionComponent2 != null) {
                    object2.add(iSharingMetadata$IConnectionComponent2);
                }
                subMonitor.worked(1);
            }
            subMonitor.done();
            ArrayList<ISharingMetadata$IConnectionComponent> arrayList = object2;
            return arrayList;
        }
        finally {
            CopyFileAreaStore.endBatching(abstractLock, (IProgressMonitor)subMonitor2.newChild(1));
            subMonitor2.done();
        }
    }

    public Collection getLocalItemPaths(IVersionableHandle iVersionableHandle, IComponentHandle iComponentHandle, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        AbstractLock abstractLock;
        Object object2;
        int n;
        SubMonitor subMonitor;
        this.assertReadLocked();
        SubMonitor subMonitor2 = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        Collection collection = this.metadata.getLocations(iVersionableHandle);
        block7: while (true) {
            subMonitor2.setWorkRemaining(100);
            subMonitor = new AbstractLock[collection.size()];
            n = 0;
            for (Object object2 : collection) {
                if (!object2.getComponent().sameItemId((IItemHandle)iComponentHandle)) continue;
                subMonitor[n++] = new ComponentLock(this.getRoot(), object2.getConnection(), object2.getComponent());
            }
            if (n == 0) {
                return Collections.EMPTY_LIST;
            }
            object2 = MultiLock.combine((AbstractLock[])subMonitor);
            abstractLock = CopyFileAreaStore.beginBatching((AbstractLock)object2, (IProgressMonitor)subMonitor2.newChild(1));
            boolean bl = false;
            try {
                HashSet<ISharingMetadata$IConnectionComponent> hashSet = new HashSet<ISharingMetadata$IConnectionComponent>(n * 4 / 3);
                for (ISharingMetadata$IConnectionComponent iSharingMetadata$IConnectionComponent2 : collection) {
                    if (!iSharingMetadata$IConnectionComponent2.getComponent().sameItemId((IItemHandle)iComponentHandle)) continue;
                    hashSet.add(iSharingMetadata$IConnectionComponent2);
                }
                collection = this.metadata.getLocations(iVersionableHandle);
                n = 0;
                for (ISharingMetadata$IConnectionComponent iSharingMetadata$IConnectionComponent2 : collection) {
                    if (!iSharingMetadata$IConnectionComponent2.getComponent().sameItemId((IItemHandle)iComponentHandle)) continue;
                    if (!hashSet.contains(iSharingMetadata$IConnectionComponent2)) continue block7;
                    ++n;
                }
                if (n != hashSet.size()) continue;
                bl = true;
            }
            finally {
                if (bl) continue;
                CopyFileAreaStore.endBatching(abstractLock, (IProgressMonitor)subMonitor2.newChild(1));
                continue;
            }
            break;
        }
        try {
            subMonitor = subMonitor2.newChild(98);
            subMonitor.setWorkRemaining(n);
            object2 = new ArrayList<ISharingMetadata$IConnectionComponent>(n);
            for (ISharingMetadata$IConnectionComponent iSharingMetadata$IConnectionComponent : collection) {
                ISharingMetadata$IConnectionComponent iSharingMetadata$IConnectionComponent2;
                if (!iSharingMetadata$IConnectionComponent.getComponent().sameItemId((IItemHandle)iComponentHandle)) continue;
                iSharingMetadata$IConnectionComponent2 = this.getLocalPathInternal(iVersionableHandle, iSharingMetadata$IConnectionComponent.getComponent(), iSharingMetadata$IConnectionComponent.getConnection());
                if (iSharingMetadata$IConnectionComponent2 != null) {
                    object2.add(iSharingMetadata$IConnectionComponent2);
                }
                subMonitor.worked(1);
            }
            subMonitor.done();
            ArrayList<ISharingMetadata$IConnectionComponent> arrayList = object2;
            return arrayList;
        }
        finally {
            CopyFileAreaStore.endBatching(abstractLock, (IProgressMonitor)subMonitor2.newChild(1));
            subMonitor2.done();
        }
    }

    public FileItemInfo getItemInfo(IPath iPath) {
        this.assertReadLocked();
        try {
            return this.metadata.getFileItemInfo(iPath);
        }
        catch (FileSystemClientException fileSystemClientException) {
            LoggingHelper.log(fileSystemClientException);
            return null;
        }
    }

    public void moveSharingInfo(IPath iPath, IPath iPath2, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        this.assertReadLocked();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        ISharingDescriptor[] iSharingDescriptorArray = new ISharingDescriptor[1];
        FileSystemClientException[] fileSystemClientExceptionArray = new FileSystemClientException[1];
        AbstractLock abstractLock = null;
        try {
            abstractLock = CopyFileAreaStore.beginBatchingWithLock(null, new CopyFileAreaStore$1(this, iPath2, iPath, iSharingDescriptorArray, fileSystemClientExceptionArray), (IProgressMonitor)subMonitor.newChild(1));
            if (fileSystemClientExceptionArray[0] != null) {
                throw (Throwable)((Object)fileSystemClientExceptionArray[0]);
            }
            InverseFileItemInfo inverseFileItemInfo = this.metadata.getFileItemInfo(iSharingDescriptorArray[0].getRootVersionable(), iSharingDescriptorArray[0].getComponent(), iSharingDescriptorArray[0].getConnectionHandle());
            if (inverseFileItemInfo != null) {
                this.metadata.setFileItemInfo(inverseFileItemInfo.getVersionableHandle(), iSharingDescriptorArray[0].getComponent(), iSharingDescriptorArray[0].getConnectionHandle(), inverseFileItemInfo.withLocalName(iPath2.lastSegment()));
                this.metadata.moveFileItemInfo(iPath, iPath2);
            }
            subMonitor.worked(50);
            this.metadata.setSharingDescriptor(iPath, null, (IProgressMonitor)subMonitor.newChild(24));
            CopyFileAreaManager.instance.batchingLock.addChange(new CopyFileAreaEvent(iSharingDescriptorArray[0].getRootVersionable(), this, iPath, 2));
            this.metadata.setSharingDescriptor(iPath2, iSharingDescriptorArray[0], (IProgressMonitor)subMonitor.newChild(24));
            CopyFileAreaManager.instance.batchingLock.addChange(new CopyFileAreaEvent(iSharingDescriptorArray[0].getRootVersionable(), this, iPath2, 1));
        }
        catch (Throwable throwable) {
            this.sharingInfoLock.unlock();
            if (abstractLock != null) {
                CopyFileAreaStore.endBatching(abstractLock, (IProgressMonitor)subMonitor.newChild(1));
            }
            subMonitor.done();
            throw throwable;
        }
        this.sharingInfoLock.unlock();
        if (abstractLock != null) {
            CopyFileAreaStore.endBatching(abstractLock, (IProgressMonitor)subMonitor.newChild(1));
        }
        subMonitor.done();
    }

    public void setSharingInfo(IPath iPath, ISharingDescriptor iSharingDescriptor, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        this.assertReadLocked();
        IPath iPath2 = iPath.setDevice(null).makeUNC(false).makeAbsolute().removeTrailingSeparator();
        Assert.isNotNull((Object)iSharingDescriptor);
        AbstractLock abstractLock = null;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        ISharingDescriptor[] iSharingDescriptorArray = new ISharingDescriptor[1];
        FileSystemClientException[] fileSystemClientExceptionArray = new FileSystemClientException[1];
        try {
            abstractLock = CopyFileAreaStore.beginBatchingWithLock(null, new CopyFileAreaStore$2(this, iSharingDescriptorArray, iPath2, iSharingDescriptor, fileSystemClientExceptionArray), (IProgressMonitor)subMonitor.newChild(1));
            if (fileSystemClientExceptionArray[0] != null) {
                throw (Throwable)((Object)fileSystemClientExceptionArray[0]);
            }
            if (iSharingDescriptorArray[0] == null) {
                if (this.getFileItemInfo(iSharingDescriptor) != null) {
                    throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.CopyFileAreaStore_12, (Object[])new Object[]{iPath2, iSharingDescriptor.getRootVersionable().getItemId().getUuidValue(), iSharingDescriptor.getConnectionName(), iSharingDescriptor.getComponentName()}), null)));
                }
                this.metadata.deleteFileItemInfo(iPath2, (IProgressMonitor)subMonitor.newChild(70));
            } else if (!(iSharingDescriptorArray[0].getComponent().sameItemId((IItemHandle)iSharingDescriptor.getComponent()) && iSharingDescriptorArray[0].getConnectionHandle().sameItemId((IItemHandle)iSharingDescriptor.getConnectionHandle()) && iSharingDescriptorArray[0].getRootVersionable().sameItemId((IItemHandle)iSharingDescriptor.getRootVersionable()))) {
                if (this.getFileItemInfo(iSharingDescriptor) != null) {
                    throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.CopyFileAreaStore_12, (Object[])new Object[]{iPath2, iSharingDescriptor.getRootVersionable().getItemId().getUuidValue(), iSharingDescriptor.getConnectionName(), iSharingDescriptor.getComponentName()}), null)));
                }
                if (!iSharingDescriptorArray[0].getRootVersionable().sameItemId((IItemHandle)iSharingDescriptor.getRootVersionable())) {
                    CopyFileAreaManager.instance.batchingLock.addChange(new CopyFileAreaEvent(iSharingDescriptorArray[0].getRootVersionable(), this, iPath2, 2));
                }
                IPath iPath3 = this.metadata.getPathForShareRoot(iSharingDescriptorArray[0].getRootVersionable(), iSharingDescriptorArray[0].getComponent(), iSharingDescriptorArray[0].getConnectionHandle());
                if (iSharingDescriptor.getRootVersionable() instanceof IFolderHandle) {
                    if (iSharingDescriptorArray[0].getRootVersionable() instanceof IFolderHandle) {
                        this.moveShareRootToWC(iPath3, iSharingDescriptorArray[0], iPath2, iSharingDescriptor, (IProgressMonitor)subMonitor.newChild(70));
                    } else {
                        this.deleteTreeInfoInternal(iPath3, iSharingDescriptorArray[0].getComponent(), iSharingDescriptorArray[0].getConnectionHandle(), true, (IProgressMonitor)subMonitor.newChild(70));
                    }
                } else if (iSharingDescriptor.getRootVersionable().sameItemId((IItemHandle)iSharingDescriptorArray[0].getRootVersionable())) {
                    InverseFileItemInfo inverseFileItemInfo = this.metadata.getFileItemInfo(iSharingDescriptor.getRootVersionable(), iSharingDescriptorArray[0].getComponent(), iSharingDescriptorArray[0].getConnectionHandle());
                    this.deleteTreeInfoInternal(iPath3, iSharingDescriptorArray[0].getComponent(), iSharingDescriptorArray[0].getConnectionHandle(), true, (IProgressMonitor)subMonitor.newChild(70));
                    InverseFileItemInfo inverseFileItemInfo2 = inverseFileItemInfo.withLocalName(iPath2.lastSegment());
                    this.metadata.setFileItemInfo(iPath2, inverseFileItemInfo2);
                    this.metadata.setFileItemInfo(iSharingDescriptor.getRootVersionable(), iSharingDescriptor.getComponent(), iSharingDescriptor.getConnectionHandle(), inverseFileItemInfo2);
                } else {
                    this.deleteTreeInfoInternal(iPath3, iSharingDescriptorArray[0].getComponent(), iSharingDescriptorArray[0].getConnectionHandle(), true, (IProgressMonitor)subMonitor.newChild(70));
                }
            } else {
                subMonitor.setWorkRemaining(29);
            }
            this.metadata.setSharingDescriptor(iPath2, iSharingDescriptor, (IProgressMonitor)subMonitor.newChild(14));
            if (!(iSharingDescriptorArray[0] == null || iSharingDescriptorArray[0].getComponent().sameItemId((IItemHandle)iSharingDescriptor.getComponent()) && iSharingDescriptorArray[0].getConnectionHandle().sameItemId((IItemHandle)iSharingDescriptor.getConnectionHandle()))) {
                subMonitor.setWorkRemaining(16);
                if (!this.metadata.hasShares(iSharingDescriptorArray[0].getComponent(), iSharingDescriptorArray[0].getConnectionHandle(), (IProgressMonitor)subMonitor.newChild(1))) {
                    LocalChangeManager.getInstance().clearPendingChanges(iSharingDescriptorArray[0].getConnectionHandle(), iSharingDescriptorArray[0].getComponent(), this.getRoot());
                }
            }
            boolean bl = this.metadata.componentLoaded(new LoadedConfigurationDescriptor(iSharingDescriptor.getRepositoryId(), iSharingDescriptor.getRepositoryUri(), iSharingDescriptor.getConnectionHandle(), iSharingDescriptor.getConnectionName(), iSharingDescriptor.getComponent(), iSharingDescriptor.getComponentName()), (IProgressMonitor)subMonitor.newChild(14)) != null;
            CopyFileAreaManager.instance.batchingLock.addChange(new CopyFileAreaEvent(iSharingDescriptor.getRootVersionable(), this, iPath2, 1));
            if (!bl) {
                CopyFileAreaManager.instance.batchingLock.addChange(new CopyFileAreaEvent(null, this, null, 7));
            }
        }
        catch (Throwable throwable) {
            this.sharingInfoLock.unlock();
            if (abstractLock != null) {
                CopyFileAreaStore.endBatching(abstractLock, (IProgressMonitor)subMonitor.newChild(1));
            }
            subMonitor.done();
            throw throwable;
        }
        this.sharingInfoLock.unlock();
        if (abstractLock != null) {
            CopyFileAreaStore.endBatching(abstractLock, (IProgressMonitor)subMonitor.newChild(1));
        }
        subMonitor.done();
    }

    private InverseFileItemInfo getFileItemInfo(ISharingDescriptor iSharingDescriptor) throws FileSystemClientException {
        return this.metadata.getFileItemInfo(iSharingDescriptor.getRootVersionable(), iSharingDescriptor.getComponent(), iSharingDescriptor.getConnectionHandle());
    }

    private void moveShareRootToWC(IPath iPath, ISharingDescriptor iSharingDescriptor, IPath iPath2, ISharingDescriptor iSharingDescriptor2, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        boolean bl = false;
        InverseFileItemInfo inverseFileItemInfo = null;
        if (this.sameWorkspaceComponent(iSharingDescriptor, iSharingDescriptor2)) {
            bl = this.getRemoteAncestorInternal(Collections.singleton(iSharingDescriptor.getRootVersionable().getItemId()), iSharingDescriptor2.getRootVersionable(), iSharingDescriptor.getComponent(), iSharingDescriptor.getConnectionHandle()) != null;
            inverseFileItemInfo = this.metadata.getFileItemInfo(iSharingDescriptor.getRootVersionable(), iSharingDescriptor.getComponent(), iSharingDescriptor.getConnectionHandle());
            subMonitor.setWorkRemaining(10);
        } else {
            this.removeLocalInfoFromInverseMetadata(iPath, iSharingDescriptor.getComponent(), iSharingDescriptor.getConnectionHandle(), subMonitor.newChild(25));
            this.assignNewUUIDsToRemoteSharesWithNoLocal(iSharingDescriptor.getRootVersionable(), iSharingDescriptor.getComponent(), iSharingDescriptor.getConnectionHandle(), subMonitor.newChild(20));
            bl = this.moveInverseMetadataForShareRootToNewWC(iSharingDescriptor, iSharingDescriptor2, subMonitor.newChild(20));
            inverseFileItemInfo = this.fixLocalItemInverseMetadataForShareRootToNewWC(iPath, iSharingDescriptor, iSharingDescriptor2, subMonitor.newChild(25));
        }
        if (!inverseFileItemInfo.getVersionableHandle().sameItemId((IItemHandle)iSharingDescriptor2.getRootVersionable())) {
            this.handeLocalMoveWithRemoteVersionableChange(iPath, iSharingDescriptor, inverseFileItemInfo, iPath2, iSharingDescriptor2, bl, subMonitor);
        }
        if (!iPath.equals((Object)iPath2)) {
            this.metadata.moveFileItemInfo(iPath, iPath2);
        }
        subMonitor.done();
    }

    private void handeLocalMoveWithRemoteVersionableChange(IPath iPath, ISharingDescriptor iSharingDescriptor, InverseFileItemInfo inverseFileItemInfo, IPath iPath2, ISharingDescriptor iSharingDescriptor2, boolean bl, SubMonitor subMonitor) throws FileSystemClientException {
        Object object3;
        IFolderHandle iFolderHandle;
        String string;
        IPath iPath3;
        InverseFileItemInfo inverseFileItemInfo2;
        if (!iSharingDescriptor.getRootVersionable().sameItemId((IItemHandle)iSharingDescriptor2.getRootVersionable())) {
            inverseFileItemInfo2 = this.metadata.getFileItemInfo(iSharingDescriptor2.getRootVersionable(), iSharingDescriptor.getComponent(), iSharingDescriptor.getConnectionHandle());
            iPath3 = this.getLocalPathInternal(inverseFileItemInfo2, iSharingDescriptor.getComponent(), iSharingDescriptor.getConnectionHandle());
        } else {
            inverseFileItemInfo2 = null;
            iPath3 = null;
        }
        HashMap<UUID, InverseFileItemInfo> hashMap = new HashMap<UUID, InverseFileItemInfo>();
        hashMap.put(inverseFileItemInfo.getVersionableHandle().getItemId(), inverseFileItemInfo);
        if (inverseFileItemInfo2 != null) {
            inverseFileItemInfo2 = this.getFileItemInfo(iSharingDescriptor2);
        }
        if (inverseFileItemInfo2 != null) {
            string = inverseFileItemInfo2.getLocalName();
            iFolderHandle = inverseFileItemInfo2.getLocalParent();
        } else {
            string = null;
            iFolderHandle = null;
        }
        if (bl) {
            hashMap.put(inverseFileItemInfo2.getVersionableHandle().getItemId(), inverseFileItemInfo2);
            object3 = this.getFileItemInfo((IVersionableHandle)inverseFileItemInfo2.getParent(), iSharingDescriptor2.getComponent(), iSharingDescriptor2.getConnectionHandle(), hashMap);
            object3 = ((InverseFileItemInfo)object3).removeRemoteChild(inverseFileItemInfo2.getName());
            hashMap.put(((FileItemInfo)object3).getVersionableHandle().getItemId(), (InverseFileItemInfo)object3);
        } else {
            inverseFileItemInfo2 = new InverseFileItemInfo((IFolderHandle)IFolder.ITEM_TYPE.createItemHandle(iSharingDescriptor2.getRootVersionable().getItemId(), UUID.generate()), null, null, true, Collections.EMPTY_MAP, null, iPath2.lastSegment());
            hashMap.put(inverseFileItemInfo2.getVersionableHandle().getItemId(), inverseFileItemInfo2);
        }
        inverseFileItemInfo = this.getFileItemInfo(inverseFileItemInfo.getVersionableHandle(), iSharingDescriptor2.getComponent(), iSharingDescriptor2.getConnectionHandle(), hashMap);
        if (inverseFileItemInfo.getVersionableHandle().hasStateId()) {
            object3 = new HashMap(inverseFileItemInfo2.getRemoteChildren());
            Object object2 = iPath2.lastSegment();
            int n = 0;
            while (object3.containsKey(object2)) {
                object2 = String.valueOf(iPath2.lastSegment()) + Integer.toString(n);
                ++n;
            }
            object3.put(object2, inverseFileItemInfo.getVersionableHandle());
            IVersionableHandle iVersionableHandle = inverseFileItemInfo2.getVersionableHandle().hasStateId() ? inverseFileItemInfo2.getVersionableHandle() : (IVersionableHandle)inverseFileItemInfo2.getVersionableHandle().getItemType().createItemHandle(inverseFileItemInfo2.getVersionableHandle().getItemId(), UUID.generate());
            inverseFileItemInfo2 = new InverseFileItemInfo(iVersionableHandle, inverseFileItemInfo2.isContentChanged(), inverseFileItemInfo2.getLastContentChangeCheckStamp(), null, null, true, Collections.unmodifiableMap((Map)object3), inverseFileItemInfo2.getLocalParent(), inverseFileItemInfo2.getLocalName(), inverseFileItemInfo2.getHash(), inverseFileItemInfo2.getContentLength(), inverseFileItemInfo2.getOriginalLineDelimiter(), inverseFileItemInfo2.getLineDelimiter(), inverseFileItemInfo2.getOriginalContentType(), inverseFileItemInfo2.getContentType(), inverseFileItemInfo2.getStoredPredecessorHintHash(), inverseFileItemInfo2.getStoredSize(), inverseFileItemInfo2.getStoredEncoding(), inverseFileItemInfo2.getStoredHash(), inverseFileItemInfo2.getStoredNumLineDelimiters(), inverseFileItemInfo2.isExecutable(), inverseFileItemInfo2.isOriginalExecutable());
            hashMap.put(inverseFileItemInfo2.getVersionableHandle().getItemId(), inverseFileItemInfo2);
            inverseFileItemInfo = new InverseFileItemInfo(inverseFileItemInfo.getVersionableHandle(), inverseFileItemInfo.isContentChanged(), inverseFileItemInfo.getLastContentChangeCheckStamp(), (IFolderHandle)iSharingDescriptor2.getRootVersionable(), (String)object2, inverseFileItemInfo.isLoadedWithAnotherName(), inverseFileItemInfo.getRemoteChildren(), iFolderHandle, string, inverseFileItemInfo.getHash(), inverseFileItemInfo.getContentLength(), inverseFileItemInfo.getOriginalLineDelimiter(), inverseFileItemInfo.getLineDelimiter(), inverseFileItemInfo.getOriginalContentType(), inverseFileItemInfo.getContentType(), inverseFileItemInfo.getStoredPredecessorHintHash(), inverseFileItemInfo.getStoredSize(), inverseFileItemInfo.getStoredEncoding(), inverseFileItemInfo.getStoredHash(), inverseFileItemInfo.getStoredNumLineDelimiters(), inverseFileItemInfo.isExecutable(), inverseFileItemInfo.isOriginalExecutable());
            hashMap.put(inverseFileItemInfo.getVersionableHandle().getItemId(), inverseFileItemInfo);
        }
        this.metadata.setFileItemInfo(iPath, inverseFileItemInfo2);
        if (iPath3 != null && iPath.isPrefixOf(iPath3)) {
            this.metadata.setFileItemInfo(iPath3, inverseFileItemInfo);
        }
        this.adjustChildrenToNewParent(iPath, (IFolderHandle)iSharingDescriptor2.getRootVersionable(), iSharingDescriptor2.getComponent(), iSharingDescriptor2.getConnectionHandle(), hashMap, (IProgressMonitor)subMonitor.newChild(5));
        if (iPath3 != null && iPath.isPrefixOf(iPath3)) {
            this.adjustChildrenToNewParent(iPath3, (IFolderHandle)inverseFileItemInfo.getVersionableHandle(), iSharingDescriptor2.getComponent(), iSharingDescriptor2.getConnectionHandle(), hashMap, (IProgressMonitor)subMonitor.newChild(5));
        }
        for (Object object3 : hashMap.values()) {
            this.metadata.setFileItemInfo(((FileItemInfo)object3).getVersionableHandle(), iSharingDescriptor2.getComponent(), iSharingDescriptor2.getConnectionHandle(), (InverseFileItemInfo)object3);
        }
    }

    private boolean sameWorkspaceComponent(ISharingDescriptor iSharingDescriptor, ISharingDescriptor iSharingDescriptor2) {
        return iSharingDescriptor.getComponent().sameItemId((IItemHandle)iSharingDescriptor2.getComponent()) && iSharingDescriptor.getConnectionHandle().sameItemId((IItemHandle)iSharingDescriptor2.getConnectionHandle());
    }

    private void removeLocalInfoFromInverseMetadata(IPath iPath, IComponentHandle iComponentHandle, IContextHandle iContextHandle, SubMonitor subMonitor) throws FileSystemClientException {
        ArrayList arrayList = new ArrayList();
        this.metadata.accept(new CopyFileAreaStore$3(this, iComponentHandle, iContextHandle, arrayList), iPath, Integer.MAX_VALUE, true, (IProgressMonitor)subMonitor);
        this.handleExceptions(arrayList, Messages.CopyFileAreaStore_21);
    }

    private void assignNewUUIDsToRemoteSharesWithNoLocal(IVersionableHandle iVersionableHandle, IComponentHandle iComponentHandle, IContextHandle iContextHandle, SubMonitor subMonitor) throws FileSystemClientException {
        ArrayList arrayList = new ArrayList();
        this.metadata.accept(new CopyFileAreaStore$4(this, iComponentHandle, iContextHandle, arrayList), iVersionableHandle, iComponentHandle, iContextHandle, Integer.MAX_VALUE, true, (IProgressMonitor)subMonitor);
        this.handleExceptions(arrayList, Messages.CopyFileAreaStore_22);
    }

    private boolean moveInverseMetadataForShareRootToNewWC(ISharingDescriptor iSharingDescriptor, ISharingDescriptor iSharingDescriptor2, SubMonitor subMonitor) throws FileSystemClientException {
        ArrayList arrayList = new ArrayList();
        boolean[] blArray = new boolean[1];
        this.metadata.accept(new CopyFileAreaStore$5(this, iSharingDescriptor, iSharingDescriptor2, blArray, arrayList), iSharingDescriptor.getRootVersionable(), iSharingDescriptor.getComponent(), iSharingDescriptor.getConnectionHandle(), Integer.MAX_VALUE, true, (IProgressMonitor)subMonitor);
        this.handleExceptions(arrayList, Messages.CopyFileAreaStore_14);
        return blArray[0];
    }

    private InverseFileItemInfo fixLocalItemInverseMetadataForShareRootToNewWC(IPath iPath, ISharingDescriptor iSharingDescriptor, ISharingDescriptor iSharingDescriptor2, SubMonitor subMonitor) throws FileSystemClientException {
        ArrayList arrayList = new ArrayList();
        InverseFileItemInfo[] inverseFileItemInfoArray = new InverseFileItemInfo[1];
        this.metadata.accept(new CopyFileAreaStore$6(this, iSharingDescriptor, iSharingDescriptor2, inverseFileItemInfoArray, arrayList), iPath, Integer.MAX_VALUE, true, (IProgressMonitor)subMonitor);
        this.handleExceptions(arrayList, Messages.CopyFileAreaStore_15);
        return inverseFileItemInfoArray[0];
    }

    private void adjustChildrenToNewParent(IPath iPath, IFolderHandle iFolderHandle, IComponentHandle iComponentHandle, IContextHandle iContextHandle, Map map, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        Map map2 = this.metadata.getChildInfos(iPath);
        for (FileItemInfo fileItemInfo : map2.values()) {
            InverseFileItemInfo inverseFileItemInfo = this.getFileItemInfo(fileItemInfo.getVersionableHandle(), iComponentHandle, iContextHandle, map);
            map.put(inverseFileItemInfo.getVersionableHandle().getItemId(), inverseFileItemInfo.withLocalParent(iFolderHandle));
        }
    }

    private InverseFileItemInfo getFileItemInfo(IVersionableHandle iVersionableHandle, IComponentHandle iComponentHandle, IContextHandle iContextHandle, Map map) throws FileSystemClientException {
        InverseFileItemInfo inverseFileItemInfo = (InverseFileItemInfo)map.get(iVersionableHandle.getItemId());
        if (inverseFileItemInfo != null) {
            return inverseFileItemInfo;
        }
        inverseFileItemInfo = this.metadata.getFileItemInfo(iVersionableHandle, iComponentHandle, iContextHandle);
        if (inverseFileItemInfo == null) {
            return null;
        }
        map.put(iVersionableHandle.getItemId(), inverseFileItemInfo);
        return inverseFileItemInfo;
    }

    public ISharingDescriptor getSharingInfo(IPath iPath) {
        this.assertReadLocked();
        try {
            return this.metadata.getSharingDescriptor(iPath);
        }
        catch (FileSystemClientException fileSystemClientException) {
            LoggingHelper.log(fileSystemClientException);
            return null;
        }
    }

    public ISharingDescriptor findSharingDescriptor(IPath iPath) throws FileSystemClientException {
        this.assertReadLocked();
        return this.internalFindSharingDescriptor(iPath);
    }

    private ISharingDescriptor internalFindSharingDescriptor(IPath iPath) throws FileSystemClientException {
        return this.metadata.findSharingDescriptor(iPath);
    }

    public boolean isShareRoot(IVersionableHandle iVersionableHandle, IComponentHandle iComponentHandle, IContextHandle iContextHandle) throws FileSystemClientException {
        this.assertReadLocked();
        return this.metadata.getPathForShareRoot(iVersionableHandle, iComponentHandle, iContextHandle) != null;
    }

    public void removeSharingInfo(IPath iPath, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        block6: {
            this.assertReadLocked();
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
            CopyFileAreaStore$RuleDescriptorPair copyFileAreaStore$RuleDescriptorPair = this.beginBatching(iPath, (IProgressMonitor)subMonitor.newChild(1));
            try {
                ISharingDescriptor iSharingDescriptor = copyFileAreaStore$RuleDescriptorPair.desc;
                if (iSharingDescriptor != null) {
                    if (this.metadata.setSharingDescriptor(iPath, null, (IProgressMonitor)subMonitor.newChild(49)) == null) {
                        throw (Throwable)new IllegalArgumentException(iPath + " is not a share root");
                    }
                    CopyFileAreaManager.instance.batchingLock.addChange(new CopyFileAreaEvent(iSharingDescriptor.getRootVersionable(), this, iPath, 2));
                    if (!this.metadata.hasShares(iSharingDescriptor.getComponent(), iSharingDescriptor.getConnectionHandle(), (IProgressMonitor)subMonitor.newChild(44))) {
                        LocalChangeManager.getInstance().clearPendingChanges(iSharingDescriptor.getConnectionHandle(), iSharingDescriptor.getComponent(), this.getRoot());
                        this.componentUnloaded(iSharingDescriptor.getComponent(), iSharingDescriptor.getConnectionHandle(), (IProgressMonitor)subMonitor.newChild(5));
                    }
                    break block6;
                }
                throw (Throwable)new IllegalArgumentException(iPath + " is not shared");
            }
            finally {
                CopyFileAreaStore.endBatching(copyFileAreaStore$RuleDescriptorPair.rule, (IProgressMonitor)subMonitor.newChild(1));
                subMonitor.done();
            }
        }
    }

    public void removeSharingInfo(IContextHandle iContextHandle, IComponentHandle iComponentHandle, IVersionableHandle iVersionableHandle, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        this.assertReadLocked();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        AbstractLock abstractLock = CopyFileAreaStore.beginBatching(new ComponentLock(this.getRoot(), iContextHandle, iComponentHandle), (IProgressMonitor)subMonitor.newChild(1));
        try {
            IPath iPath = this.metadata.getPathForShareRoot(iVersionableHandle, iComponentHandle, iContextHandle);
            if (iPath != null) {
                this.metadata.setSharingDescriptor(iPath, null, (IProgressMonitor)subMonitor.newChild(49));
                CopyFileAreaManager.instance.batchingLock.addChange(new CopyFileAreaEvent(iVersionableHandle, this, iPath, 2));
                if (!this.metadata.hasShares(iComponentHandle, iContextHandle, (IProgressMonitor)subMonitor.newChild(44))) {
                    LocalChangeManager.getInstance().clearPendingChanges(iContextHandle, iComponentHandle, this.getRoot());
                    this.componentUnloaded(iComponentHandle, iContextHandle, (IProgressMonitor)subMonitor.newChild(5));
                }
            } else {
                subMonitor.setWorkRemaining(1);
            }
        }
        finally {
            CopyFileAreaStore.endBatching(abstractLock, (IProgressMonitor)subMonitor.newChild(1));
            subMonitor.done();
        }
    }

    protected CopyFileAreaStore$RuleDescriptorPair beginBatching(IPath iPath, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        CopyFileAreaStore$RuleDescriptorPair copyFileAreaStore$RuleDescriptorPair = new CopyFileAreaStore$RuleDescriptorPair();
        ISharingDescriptor iSharingDescriptor = this.internalFindSharingDescriptor(iPath);
        while (true) {
            subMonitor.setWorkRemaining(100);
            copyFileAreaStore$RuleDescriptorPair.desc = iSharingDescriptor;
            if (iSharingDescriptor == null) {
                copyFileAreaStore$RuleDescriptorPair.rule = CopyFileAreaStore.beginBatching(BatchingLock.NULL_SCHEDULING_RULE, null);
                subMonitor.done();
                return copyFileAreaStore$RuleDescriptorPair;
            }
            copyFileAreaStore$RuleDescriptorPair.rule = CopyFileAreaStore.beginBatching(new ComponentLock(this.getRoot(), iSharingDescriptor.getConnectionHandle(), iSharingDescriptor.getComponent()), (IProgressMonitor)subMonitor.newChild(50));
            boolean bl = false;
            try {
                iSharingDescriptor = this.internalFindSharingDescriptor(iPath);
                if (iSharingDescriptor == null || !iSharingDescriptor.getComponent().sameItemId((IItemHandle)copyFileAreaStore$RuleDescriptorPair.desc.getComponent()) || !iSharingDescriptor.getConnectionHandle().sameItemId((IItemHandle)copyFileAreaStore$RuleDescriptorPair.desc.getConnectionHandle())) continue;
                subMonitor.done();
                bl = true;
                CopyFileAreaStore$RuleDescriptorPair copyFileAreaStore$RuleDescriptorPair2 = copyFileAreaStore$RuleDescriptorPair;
                return copyFileAreaStore$RuleDescriptorPair2;
            }
            finally {
                if (bl) continue;
                CopyFileAreaStore.endBatching(copyFileAreaStore$RuleDescriptorPair.rule, (IProgressMonitor)subMonitor.newChild(1));
                continue;
            }
            break;
        }
    }

    private CopyFileAreaStore$RuleDescriptorPairForMove beginBatching(IPath iPath, IPath iPath2, SubMonitor subMonitor) throws FileSystemClientException {
        CopyFileAreaStore$RuleDescriptorPairForMove copyFileAreaStore$RuleDescriptorPairForMove = new CopyFileAreaStore$RuleDescriptorPairForMove();
        while (true) {
            subMonitor.setWorkRemaining(100);
            copyFileAreaStore$RuleDescriptorPairForMove.beginBatching(this.getRoot(), this.internalFindSharingDescriptor(iPath), this.internalFindSharingDescriptor(iPath2), subMonitor.newChild(50));
            boolean bl = false;
            try {
                if (!copyFileAreaStore$RuleDescriptorPairForMove.descriptorsInSameComponent(this.internalFindSharingDescriptor(iPath), this.internalFindSharingDescriptor(iPath2))) continue;
                subMonitor.done();
                bl = true;
                CopyFileAreaStore$RuleDescriptorPairForMove copyFileAreaStore$RuleDescriptorPairForMove2 = copyFileAreaStore$RuleDescriptorPairForMove;
                return copyFileAreaStore$RuleDescriptorPairForMove2;
            }
            finally {
                if (bl) continue;
                copyFileAreaStore$RuleDescriptorPairForMove.endBatching(subMonitor.newChild(1));
                continue;
            }
            break;
        }
    }

    public static AbstractLock beginBatching(AbstractLock abstractLock, IProgressMonitor iProgressMonitor) {
        CopyFileAreaManager copyFileAreaManager = CopyFileAreaManager.instance;
        return copyFileAreaManager.batchingLock.acquire(abstractLock, copyFileAreaManager, CopyFileAreaManager.NULL_PARTICIPANT, true, iProgressMonitor);
    }

    public static AbstractLock beginBatchingWithLock(AbstractLock abstractLock, ILockParticipant iLockParticipant, IProgressMonitor iProgressMonitor) {
        CopyFileAreaManager copyFileAreaManager = CopyFileAreaManager.instance;
        return copyFileAreaManager.batchingLock.acquire(abstractLock, copyFileAreaManager, iLockParticipant, true, iProgressMonitor);
    }

    public static AbstractLock beginBatchingNoWait(AbstractLock abstractLock) {
        CopyFileAreaManager copyFileAreaManager = CopyFileAreaManager.instance;
        return copyFileAreaManager.batchingLock.acquire(abstractLock, copyFileAreaManager, CopyFileAreaManager.NULL_PARTICIPANT, false, null);
    }

    public static void endBatching(AbstractLock abstractLock, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        CopyFileAreaManager.instance.batchingLock.release(abstractLock, iProgressMonitor);
    }

    public void internalClear() throws FileSystemClientException {
        this.metadata.clear();
    }

    public boolean isConnectionShared(IContextHandle iContextHandle) throws FileSystemClientException {
        this.assertReadLocked();
        return this.internalIsConnectionShared(iContextHandle);
    }

    boolean internalIsConnectionShared(IContextHandle iContextHandle) throws FileSystemClientException {
        for (ISharingDescriptor iSharingDescriptor : this.metadata.getSharingDescriptors().values()) {
            if (!iSharingDescriptor.getConnectionHandle().sameItemId((IItemHandle)iContextHandle)) continue;
            return true;
        }
        return false;
    }

    public void accept(IRemoteVisitor iRemoteVisitor, IVersionableHandle iVersionableHandle, IComponentHandle iComponentHandle, IContextHandle iContextHandle, AbstractLock abstractLock, int n, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        this.assertReadLocked();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        try {
            if (abstractLock != null) {
                abstractLock = CopyFileAreaStore.beginBatching(abstractLock, (IProgressMonitor)subMonitor.newChild(1));
            }
            this.metadata.accept(iRemoteVisitor, iVersionableHandle, iComponentHandle, iContextHandle, n, abstractLock != null, (IProgressMonitor)subMonitor.newChild(98));
        }
        finally {
            if (abstractLock != null) {
                CopyFileAreaStore.endBatching(abstractLock, (IProgressMonitor)subMonitor.newChild(1));
            }
            subMonitor.done();
        }
    }

    public void accept(IVisitor iVisitor, IPath iPath, boolean bl, int n, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        this.assertReadLocked();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        try {
            this.metadata.accept(iVisitor, iPath, n, bl, (IProgressMonitor)subMonitor.newChild(98));
        }
        finally {
            subMonitor.done();
        }
    }

    public IPath[] allSharePaths() throws FileSystemClientException {
        this.assertReadLocked();
        return this.metadata.allShares();
    }

    public Collection allSharePaths(IPath iPath) throws FileSystemClientException {
        this.assertReadLocked();
        return this.metadata.allShares(iPath);
    }

    public boolean deleteTreeInfo(IPath iPath, boolean bl, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        boolean bl2;
        SubMonitor subMonitor;
        block5: {
            this.assertReadLocked();
            AbstractLock abstractLock = null;
            subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
            try {
                IContextHandle iContextHandle;
                IComponentHandle iComponentHandle;
                CopyFileAreaStore$RuleDescriptorPair copyFileAreaStore$RuleDescriptorPair = this.beginBatching(iPath, (IProgressMonitor)subMonitor.newChild(1));
                ISharingDescriptor iSharingDescriptor = copyFileAreaStore$RuleDescriptorPair.desc;
                abstractLock = copyFileAreaStore$RuleDescriptorPair.rule;
                if (iSharingDescriptor != null) {
                    iComponentHandle = iSharingDescriptor.getComponent();
                    iContextHandle = iSharingDescriptor.getConnectionHandle();
                } else {
                    iComponentHandle = null;
                    iContextHandle = null;
                }
                bl2 = this.deleteTreeInfoInternal(iPath, iComponentHandle, iContextHandle, bl, (IProgressMonitor)subMonitor.newChild(98));
                if (abstractLock == null) break block5;
            }
            catch (Throwable throwable) {
                if (abstractLock != null) {
                    CopyFileAreaStore.endBatching(abstractLock, (IProgressMonitor)subMonitor.newChild(1));
                }
                subMonitor.done();
                throw throwable;
            }
            CopyFileAreaStore.endBatching(abstractLock, (IProgressMonitor)subMonitor.newChild(1));
        }
        subMonitor.done();
        return bl2;
    }

    public void deleteTreeInfo(IVersionableHandle iVersionableHandle, IComponentHandle iComponentHandle, IContextHandle iContextHandle, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        InverseFileItemInfo inverseFileItemInfo;
        SubMonitor subMonitor;
        AbstractLock abstractLock;
        block9: {
            block10: {
                this.assertReadLocked();
                abstractLock = null;
                subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
                abstractLock = CopyFileAreaStore.beginBatching(new ComponentLock(this.getRoot(), iContextHandle, iComponentHandle), (IProgressMonitor)subMonitor.newChild(1));
                inverseFileItemInfo = this.metadata.getFileItemInfo(iVersionableHandle, iComponentHandle, iContextHandle);
                if (inverseFileItemInfo != null) break block9;
                if (abstractLock == null) break block10;
                CopyFileAreaStore.endBatching(abstractLock, (IProgressMonitor)subMonitor.newChild(1));
            }
            subMonitor.done();
            return;
        }
        try {
            if (inverseFileItemInfo.getParent() != null && this.metadata.getPathForShareRoot(inverseFileItemInfo.getVersionableHandle(), iComponentHandle, iContextHandle) == null) {
                this.updateParentInfoForRemoval(inverseFileItemInfo, iComponentHandle, iContextHandle);
            }
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(iVersionableHandle);
            do {
                IVersionableHandle iVersionableHandle2;
                IPath iPath;
                if ((iPath = this.getLocalPathInternal(inverseFileItemInfo = this.metadata.setFileItemInfo(iVersionableHandle2 = (IVersionableHandle)arrayList.remove(arrayList.size() - 1), iComponentHandle, iContextHandle, null), iComponentHandle, iContextHandle)) != null) {
                    InverseFileItemInfo inverseFileItemInfo2 = new InverseFileItemInfo((IVersionableHandle)inverseFileItemInfo.getVersionableHandle().getItemType().createItemHandle(UUID.generate(), null), false, -1L, null, null, inverseFileItemInfo.isLoadedWithAnotherName(), Collections.EMPTY_MAP, inverseFileItemInfo.getLocalParent(), inverseFileItemInfo.getLocalName(), null, -1L, null, inverseFileItemInfo.getLineDelimiter(), null, inverseFileItemInfo.getContentType(), null, -1L, null, null, -1L, inverseFileItemInfo.isExecutable(), false);
                    this.metadata.setFileItemInfo(inverseFileItemInfo2.getVersionableHandle(), iComponentHandle, iContextHandle, inverseFileItemInfo2);
                    this.metadata.setFileItemInfo(iPath, inverseFileItemInfo2);
                    if (inverseFileItemInfo.isFolder()) {
                        this.updateLocalParent(iPath, (IFolderHandle)inverseFileItemInfo2.getVersionableHandle(), iComponentHandle, iContextHandle);
                    }
                }
                arrayList.addAll(inverseFileItemInfo.getRemoteChildren().values());
            } while (!arrayList.isEmpty());
        }
        catch (Throwable throwable) {
            if (abstractLock != null) {
                CopyFileAreaStore.endBatching(abstractLock, (IProgressMonitor)subMonitor.newChild(1));
            }
            subMonitor.done();
            throw throwable;
        }
        if (abstractLock != null) {
            CopyFileAreaStore.endBatching(abstractLock, (IProgressMonitor)subMonitor.newChild(1));
        }
        subMonitor.done();
    }

    private boolean deleteTreeInfoInternal(IPath iPath, IComponentHandle iComponentHandle, IContextHandle iContextHandle, boolean bl, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        ArrayList arrayList = new ArrayList();
        IVersionableHandle[] iVersionableHandleArray = new IVersionableHandle[1];
        boolean[] blArray = new boolean[1];
        this.metadata.accept(new CopyFileAreaStore$7(this, iPath, iVersionableHandleArray, iComponentHandle, iContextHandle, blArray, arrayList), iPath, Integer.MAX_VALUE, true, (IProgressMonitor)subMonitor.newChild(33));
        if (iComponentHandle != null && bl && iVersionableHandleArray[0] != null && iVersionableHandleArray[0].hasStateId()) {
            this.metadata.accept(new CopyFileAreaStore$8(this, iVersionableHandleArray, iComponentHandle, iContextHandle, blArray, arrayList), iVersionableHandleArray[0], iComponentHandle, iContextHandle, Integer.MAX_VALUE, true, (IProgressMonitor)subMonitor.newChild(34));
        } else {
            subMonitor.setWorkRemaining(33);
        }
        this.metadata.deleteFileItemInfo(iPath, (IProgressMonitor)subMonitor.newChild(33));
        if (!arrayList.isEmpty()) {
            MultiStatus multiStatus = new MultiStatus("com.ibm.team.filesystem.client", 0, Messages.CopyFileAreaStore_19, null);
            for (FileSystemClientException fileSystemClientException : arrayList) {
                multiStatus.add(FileSystemStatus.getStatusFor((Throwable)((Object)fileSystemClientException)));
            }
            throw (Throwable)((Object)new FileSystemClientException((IStatus)multiStatus));
        }
        return blArray[0];
    }

    public void moveTreeInfo(IPath iPath, IPath iPath2, boolean bl, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        this.assertReadLocked();
        CopyFileAreaStore$RuleDescriptorPairForMove copyFileAreaStore$RuleDescriptorPairForMove = null;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        try {
            copyFileAreaStore$RuleDescriptorPairForMove = this.beginBatching(iPath, iPath2, subMonitor.newChild(1));
            ISharingDescriptor iSharingDescriptor = copyFileAreaStore$RuleDescriptorPairForMove.sourceDesc;
            ISharingDescriptor iSharingDescriptor2 = copyFileAreaStore$RuleDescriptorPairForMove.destDesc;
            if (iSharingDescriptor2 == null) {
                throw (Throwable)new AssertionFailedException(NLS.bind((String)"No sharing descriptor found for path ''{0}''", (Object)iPath2.toString()));
            }
            FileItemInfo fileItemInfo = this.metadata.getFileItemInfo(iPath2);
            if (fileItemInfo != null && !this.metadata.isSamePath(iPath, iPath2)) {
                this.deleteTreeInfoInternal(iPath2, iSharingDescriptor.getComponent(), iSharingDescriptor.getConnectionHandle(), false, (IProgressMonitor)subMonitor.newChild(1));
            }
            if (this.sameWorkspaceComponent(iSharingDescriptor, iSharingDescriptor2)) {
                this.moveSubtree(iPath, iSharingDescriptor, iPath2, bl);
            } else {
                this.moveSubtreeToWC(iPath, iSharingDescriptor, iPath2, iSharingDescriptor2, subMonitor.newChild(97));
            }
        }
        finally {
            if (copyFileAreaStore$RuleDescriptorPairForMove != null) {
                copyFileAreaStore$RuleDescriptorPairForMove.endBatching(subMonitor.newChild(1));
            }
            subMonitor.done();
        }
    }

    private void moveSubtreeToWC(IPath iPath, ISharingDescriptor iSharingDescriptor, IPath iPath2, ISharingDescriptor iSharingDescriptor2, SubMonitor subMonitor) throws FileSystemClientException {
        SubMonitor subMonitor2 = SubMonitor.convert((IProgressMonitor)((IProgressMonitor)subMonitor), (int)100);
        FileItemInfo fileItemInfo = this.metadata.getFileItemInfo(iPath);
        if (fileItemInfo == null) {
            throw (Throwable)new AssertionFailedException("File item info expected but not found at source path " + iPath.toOSString());
        }
        IVersionableHandle iVersionableHandle = fileItemInfo.getVersionableHandle();
        FileItemInfo fileItemInfo2 = this.metadata.getFileItemInfo(iPath2);
        if (fileItemInfo2 != null) {
            throw (Throwable)new AssertionFailedException("File item info found but not expected at destination path " + iPath2.toOSString());
        }
        FileItemInfo fileItemInfo3 = this.metadata.getFileItemInfo(iPath2.removeLastSegments(1));
        if (fileItemInfo3 == null) {
            throw (Throwable)new AssertionFailedException("File item info not found but expected for parent of destination path " + iPath2.toOSString());
        }
        this.removeLocalInfoFromInverseMetadata(iPath, iSharingDescriptor.getComponent(), iSharingDescriptor.getConnectionHandle(), subMonitor2.newChild(25));
        this.assignNewUUIDsToRemoteSharesWithNoLocal(iVersionableHandle, iSharingDescriptor.getComponent(), iSharingDescriptor.getConnectionHandle(), subMonitor2.newChild(20));
        this.moveInverseMetadataToNewWC(iVersionableHandle, iSharingDescriptor, (IFolderHandle)fileItemInfo3.getVersionableHandle(), iSharingDescriptor2, subMonitor2.newChild(20));
        InverseFileItemInfo inverseFileItemInfo = this.metadata.getFileItemInfo((IVersionableHandle)fileItemInfo.getParent(), iSharingDescriptor.getComponent(), iSharingDescriptor.getConnectionHandle());
        this.metadata.setFileItemInfo((IVersionableHandle)fileItemInfo.getParent(), iSharingDescriptor.getComponent(), iSharingDescriptor.getConnectionHandle(), inverseFileItemInfo.removeRemoteChild(iPath.lastSegment()));
        this.fixInverseMetadataForLocalItems(iPath, iSharingDescriptor, (IFolderHandle)fileItemInfo3.getVersionableHandle(), iSharingDescriptor2, subMonitor2.newChild(25));
        if (!iPath.equals((Object)iPath2)) {
            this.metadata.moveFileItemInfo(iPath, iPath2);
        }
        subMonitor2.done();
    }

    private void moveInverseMetadataToNewWC(IVersionableHandle iVersionableHandle, ISharingDescriptor iSharingDescriptor, IFolderHandle iFolderHandle, ISharingDescriptor iSharingDescriptor2, SubMonitor subMonitor) throws FileSystemClientException {
        ArrayList arrayList = new ArrayList();
        this.metadata.accept(new CopyFileAreaStore$9(this, iSharingDescriptor, iVersionableHandle, iFolderHandle, iSharingDescriptor2, arrayList), iVersionableHandle, iSharingDescriptor.getComponent(), iSharingDescriptor.getConnectionHandle(), Integer.MAX_VALUE, true, (IProgressMonitor)subMonitor);
        this.handleExceptions(arrayList, Messages.CopyFileAreaStore_14);
    }

    private void fixInverseMetadataForLocalItems(IPath iPath, ISharingDescriptor iSharingDescriptor, IFolderHandle iFolderHandle, ISharingDescriptor iSharingDescriptor2, SubMonitor subMonitor) throws FileSystemClientException {
        ArrayList arrayList = new ArrayList();
        this.metadata.accept(new CopyFileAreaStore$10(this, iSharingDescriptor, iSharingDescriptor2, iPath, iFolderHandle, arrayList), iPath, Integer.MAX_VALUE, true, (IProgressMonitor)subMonitor);
        this.handleExceptions(arrayList, Messages.CopyFileAreaStore_15);
    }

    private void moveSubtree(IPath iPath, ISharingDescriptor iSharingDescriptor, IPath iPath2, boolean bl) throws FileSystemClientException {
        FileItemInfo fileItemInfo = this.metadata.getFileItemInfo(iPath);
        if (fileItemInfo != null) {
            String string;
            IFolderHandle iFolderHandle;
            Assert.isTrue((!fileItemInfo.getVersionableHandle().sameItemId((IItemHandle)iSharingDescriptor.getRootVersionable()) ? 1 : 0) != 0);
            FileItemInfo fileItemInfo2 = this.metadata.getFileItemInfo(iPath2.removeLastSegments(1));
            IFolderHandle iFolderHandle2 = (IFolderHandle)fileItemInfo2.getVersionableHandle();
            String string2 = iPath2.lastSegment();
            if (bl) {
                iFolderHandle = iFolderHandle2;
                string = string2;
            } else {
                iFolderHandle = fileItemInfo.getParent();
                string = fileItemInfo.getName();
            }
            InverseFileItemInfo inverseFileItemInfo = this.metadata.getFileItemInfo(fileItemInfo.getVersionableHandle(), iSharingDescriptor.getComponent(), iSharingDescriptor.getConnectionHandle());
            InverseFileItemInfo inverseFileItemInfo2 = new InverseFileItemInfo(fileItemInfo.getVersionableHandle(), fileItemInfo.isContentChanged(), fileItemInfo.getLastContentChangeCheckStamp(), iFolderHandle, string, fileItemInfo.isLoadedWithAnotherName(), inverseFileItemInfo.getRemoteChildren(), iFolderHandle2, string2, fileItemInfo.getHash(), fileItemInfo.getContentLength(), fileItemInfo.getOriginalLineDelimiter(), fileItemInfo.getLineDelimiter(), fileItemInfo.getOriginalContentType(), fileItemInfo.getContentType(), fileItemInfo.getStoredPredecessorHintHash(), fileItemInfo.getStoredSize(), fileItemInfo.getStoredEncoding(), fileItemInfo.getStoredHash(), fileItemInfo.getStoredNumLineDelimiters(), fileItemInfo.isExecutable(), fileItemInfo.isOriginalExecutable());
            this.updateParentInfoForChange(inverseFileItemInfo2, fileItemInfo, iSharingDescriptor.getComponent(), iSharingDescriptor.getConnectionHandle());
            this.metadata.setFileItemInfo(fileItemInfo.getVersionableHandle(), iSharingDescriptor.getComponent(), iSharingDescriptor.getConnectionHandle(), inverseFileItemInfo2);
            if (bl) {
                this.metadata.setFileItemInfo(iPath, inverseFileItemInfo2);
            }
        }
        this.metadata.moveFileItemInfo(iPath, iPath2);
    }

    public void run(AbstractLock abstractLock, CopyFileAreaStore$IOperation copyFileAreaStore$IOperation, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        try {
            abstractLock = CopyFileAreaStore.beginBatching(abstractLock, (IProgressMonitor)subMonitor.newChild(1));
            copyFileAreaStore$IOperation.execute((IProgressMonitor)subMonitor.newChild(98));
        }
        finally {
            if (abstractLock != null) {
                CopyFileAreaStore.endBatching(abstractLock, (IProgressMonitor)subMonitor.newChild(1));
            }
            subMonitor.done();
        }
    }

    public void run(CopyFileAreaStore$IOperation copyFileAreaStore$IOperation, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        this.metadata.run(new CopyFileAreaStore$11(this, copyFileAreaStore$IOperation, iProgressMonitor));
    }

    public String toDebugString() {
        this.assertReadLocked();
        return this.metadata.toDebugString();
    }

    public ISharingMetadata internalGetMetadata() {
        return this.metadata;
    }

    public void close() throws FileSystemClientException {
        CopyFileAreaManager.instance.deregister(this.getRoot(), false, null);
    }

    void internalClose() throws FileSystemClientException {
        this.metadata.close();
        LocalChangeManager.getInstance().clearPendingChanges(this.getRoot());
    }

    public void sync() throws FileSystemClientException {
        this.assertReadLocked();
        this.metadata.close();
    }

    public IPath getRoot() {
        return this.path;
    }

    public boolean isCaseSensitive() {
        return this.metadata.isCaseSensitive();
    }

    public void setConfigurationState(IContextHandle iContextHandle, IComponentHandle iComponentHandle, ISyncTime iSyncTime, ISyncTime iSyncTime2, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        this.assertReadLocked();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        AbstractLock abstractLock = CopyFileAreaStore.beginBatching(new ComponentLock(this.getRoot(), iContextHandle, iComponentHandle), (IProgressMonitor)subMonitor.newChild(1));
        try {
            Map map = this.metadata.getSharingDescriptors(iComponentHandle, iContextHandle);
            SubMonitor subMonitor2 = subMonitor.newChild(98);
            subMonitor2.setWorkRemaining(map.size());
            for (Map.Entry entry : map.entrySet()) {
                ISharingDescriptor iSharingDescriptor = (ISharingDescriptor)entry.getValue();
                IPath iPath = (IPath)entry.getKey();
                this.updateConfigurationState(iPath, iSharingDescriptor, iSyncTime, iSyncTime2, subMonitor2);
            }
            subMonitor2.done();
        }
        finally {
            CopyFileAreaStore.endBatching(abstractLock, (IProgressMonitor)subMonitor.newChild(1));
            subMonitor.done();
        }
    }

    private void updateConfigurationState(IPath iPath, ISharingDescriptor iSharingDescriptor, ISyncTime iSyncTime, ISyncTime iSyncTime2, SubMonitor subMonitor) throws FileSystemClientException {
        SharingDescriptor sharingDescriptor = (SharingDescriptor)iSharingDescriptor;
        if (iSyncTime == null || iSyncTime.equals(sharingDescriptor.getConfigurationState())) {
            SharingDescriptor sharingDescriptor2 = new SharingDescriptor(sharingDescriptor, iSyncTime2);
            this.metadata.setSharingDescriptor(iPath, sharingDescriptor2, (IProgressMonitor)subMonitor.newChild(1));
            CopyFileAreaManager.instance.batchingLock.addChange(new CopyFileAreaEvent(sharingDescriptor2.getRootVersionable(), this, iPath, 6));
        } else if (iSyncTime2.equals(sharingDescriptor.getConfigurationState())) {
            subMonitor.worked(1);
        } else if (sharingDescriptor.isUnknownState()) {
            SharingDescriptor sharingDescriptor3 = new SharingDescriptor(sharingDescriptor, ISyncTime.TIME_NONE);
            this.metadata.setSharingDescriptor(iPath, sharingDescriptor3, (IProgressMonitor)subMonitor.newChild(1));
            CopyFileAreaManager.instance.batchingLock.addChange(new CopyFileAreaEvent(sharingDescriptor3.getRootVersionable(), this, iPath, 6));
        }
    }

    private void setConfigurationState(IContextHandle iContextHandle, IComponentHandle iComponentHandle, IVersionableHandle iVersionableHandle, ISyncTime iSyncTime, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        this.assertReadLocked();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        AbstractLock abstractLock = CopyFileAreaStore.beginBatching(new ComponentLock(this.getRoot(), iContextHandle, iComponentHandle), (IProgressMonitor)subMonitor.newChild(1));
        try {
            SharingDescriptor sharingDescriptor;
            IPath iPath = this.getLocalPathInternal(iVersionableHandle, iComponentHandle, iContextHandle);
            if (iPath != null && (sharingDescriptor = (SharingDescriptor)this.metadata.getSharingDescriptor(iPath)) != null && !iSyncTime.equals(sharingDescriptor.getConfigurationState())) {
                SharingDescriptor sharingDescriptor2 = new SharingDescriptor(sharingDescriptor, iSyncTime);
                this.metadata.setSharingDescriptor(iPath, sharingDescriptor2, (IProgressMonitor)subMonitor.newChild(98));
                CopyFileAreaManager.instance.batchingLock.addChange(new CopyFileAreaEvent(sharingDescriptor2.getRootVersionable(), this, iPath, 6));
            }
            subMonitor.setWorkRemaining(1);
        }
        finally {
            CopyFileAreaStore.endBatching(abstractLock, (IProgressMonitor)subMonitor.newChild(1));
            subMonitor.done();
        }
    }

    public void setConfigurationState(IContextHandle iContextHandle, IComponentHandle iComponentHandle, IPath iPath, ISyncTime iSyncTime, ISyncTime iSyncTime2, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        this.assertReadLocked();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        AbstractLock abstractLock = CopyFileAreaStore.beginBatching(new ComponentLock(this.getRoot(), iContextHandle, iComponentHandle), (IProgressMonitor)subMonitor.newChild(1));
        try {
            ISharingDescriptor iSharingDescriptor = this.metadata.getSharingDescriptor(iPath);
            if (iSharingDescriptor != null && iSharingDescriptor.getComponent().sameItemId((IItemHandle)iComponentHandle) && iSharingDescriptor.getConnectionHandle().sameItemId((IItemHandle)iContextHandle)) {
                this.updateConfigurationState(iPath, iSharingDescriptor, iSyncTime, iSyncTime2, subMonitor.newChild(98));
            }
            subMonitor.setWorkRemaining(1);
        }
        finally {
            CopyFileAreaStore.endBatching(abstractLock, (IProgressMonitor)subMonitor.newChild(1));
            subMonitor.done();
        }
    }

    public void setConfigurationState(IContextHandle iContextHandle, IComponentHandle iComponentHandle, IPath iPath, ISyncTime iSyncTime, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        this.assertReadLocked();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        AbstractLock abstractLock = CopyFileAreaStore.beginBatching(new ComponentLock(this.getRoot(), iContextHandle, iComponentHandle), (IProgressMonitor)subMonitor.newChild(1));
        try {
            SharingDescriptor sharingDescriptor = (SharingDescriptor)this.metadata.getSharingDescriptor(iPath);
            if (sharingDescriptor != null && sharingDescriptor.getComponent().sameItemId((IItemHandle)iComponentHandle) && sharingDescriptor.getConnectionHandle().sameItemId((IItemHandle)iContextHandle) && !iSyncTime.equals(sharingDescriptor.getConfigurationState())) {
                SharingDescriptor sharingDescriptor2 = new SharingDescriptor(sharingDescriptor, iSyncTime);
                this.metadata.setSharingDescriptor(iPath, sharingDescriptor2, (IProgressMonitor)subMonitor.newChild(98));
                CopyFileAreaManager.instance.batchingLock.addChange(new CopyFileAreaEvent(sharingDescriptor2.getRootVersionable(), this, iPath, 6));
            }
            subMonitor.setWorkRemaining(1);
        }
        finally {
            CopyFileAreaStore.endBatching(abstractLock, (IProgressMonitor)subMonitor.newChild(1));
            subMonitor.done();
        }
    }

    public void setUnknownConfigurationState(IContextHandle iContextHandle, IComponentHandle iComponentHandle, IPath iPath, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        this.assertReadLocked();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        AbstractLock abstractLock = CopyFileAreaStore.beginBatching(new ComponentLock(this.getRoot(), iContextHandle, iComponentHandle), (IProgressMonitor)subMonitor.newChild(1));
        try {
            SharingDescriptor sharingDescriptor = (SharingDescriptor)this.metadata.getSharingDescriptor(iPath);
            if (sharingDescriptor != null && sharingDescriptor.getComponent().sameItemId((IItemHandle)iComponentHandle) && sharingDescriptor.getConnectionHandle().sameItemId((IItemHandle)iContextHandle)) {
                SharingDescriptor sharingDescriptor2 = new SharingDescriptor(sharingDescriptor, ISyncTime.TIME_NONE);
                this.metadata.setSharingDescriptor(iPath, sharingDescriptor2, (IProgressMonitor)subMonitor.newChild(98));
                CopyFileAreaManager.instance.batchingLock.addChange(new CopyFileAreaEvent(sharingDescriptor2.getRootVersionable(), this, iPath, 6));
            }
            subMonitor.setWorkRemaining(1);
        }
        finally {
            CopyFileAreaStore.endBatching(abstractLock, (IProgressMonitor)subMonitor.newChild(1));
            subMonitor.done();
        }
    }

    public boolean isLoaded(IComponentHandle iComponentHandle, IContextHandle iContextHandle, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        this.assertReadLocked();
        return this.internalIsLoaded(iComponentHandle, iContextHandle, iProgressMonitor);
    }

    boolean internalIsLoaded(IComponentHandle iComponentHandle, IContextHandle iContextHandle, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        return this.metadata.isLoaded(iComponentHandle, iContextHandle, iProgressMonitor);
    }

    public Collection allLoadedComponents(IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        this.assertReadLocked();
        return this.internalAllLoadedComponents(iProgressMonitor);
    }

    Collection internalAllLoadedComponents(IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        return this.metadata.allLoadedComponents(iProgressMonitor);
    }

    public Collection allLoadedContexts(IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        this.assertReadLocked();
        return this.internalAllLoadedContexts(iProgressMonitor);
    }

    Collection internalAllLoadedContexts(IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        return this.metadata.allLoadedContexts(iProgressMonitor);
    }

    public void componentLoaded(LoadedConfigurationDescriptor loadedConfigurationDescriptor, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        this.assertReadLocked();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        AbstractLock abstractLock = CopyFileAreaStore.beginBatching(new ComponentLock(this.getRoot(), loadedConfigurationDescriptor.connectionHandle, loadedConfigurationDescriptor.componentHandle), (IProgressMonitor)subMonitor.newChild(1));
        try {
            boolean bl;
            boolean bl2 = bl = this.metadata.componentLoaded(loadedConfigurationDescriptor, (IProgressMonitor)subMonitor.newChild(98)) != null;
            if (!bl) {
                CopyFileAreaManager.instance.batchingLock.addChange(new CopyFileAreaEvent(null, this, null, 7));
            }
        }
        finally {
            CopyFileAreaStore.endBatching(abstractLock, (IProgressMonitor)subMonitor.newChild(1));
            subMonitor.done();
        }
    }

    public void componentUnloaded(IComponentHandle iComponentHandle, IContextHandle iContextHandle, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        this.assertReadLocked();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        AbstractLock abstractLock = CopyFileAreaStore.beginBatching(new ComponentLock(this.getRoot(), iContextHandle, iComponentHandle), (IProgressMonitor)subMonitor.newChild(1));
        try {
            boolean bl;
            if (this.metadata.hasShares(iComponentHandle, iContextHandle, (IProgressMonitor)subMonitor.newChild(49))) {
                throw (Throwable)((Object)new FileSystemClientException(new FileSystemStatus(Messages.CopyFileAreaStore_20)));
            }
            boolean bl2 = bl = this.metadata.componentUnloaded(iComponentHandle, iContextHandle, (IProgressMonitor)subMonitor.newChild(49)) != null;
            if (bl) {
                CopyFileAreaManager.instance.batchingLock.addChange(new CopyFileAreaEvent(null, this, null, 8));
            }
        }
        finally {
            CopyFileAreaStore.endBatching(abstractLock, (IProgressMonitor)subMonitor.newChild(1));
            subMonitor.done();
        }
    }

    public boolean isCorrupted() {
        this.assertReadLocked();
        return this.metadata.isCorrupted();
    }

    public int getNumShares(IComponentHandle iComponentHandle, IContextHandle iContextHandle, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        this.assertReadLocked();
        return this.internalGetNumShares(iComponentHandle, iContextHandle, iProgressMonitor);
    }

    int internalGetNumShares(IComponentHandle iComponentHandle, IContextHandle iContextHandle, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        int n = this.metadata.getSharingDescriptors(iComponentHandle, iContextHandle).size();
        subMonitor.done();
        return n;
    }

    public Map getShares(IContextHandle iContextHandle, IComponentHandle iComponentHandle, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        this.assertReadLocked();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        AbstractLock abstractLock = CopyFileAreaStore.beginBatching(new ComponentLock(this.getRoot(), iContextHandle, iComponentHandle), (IProgressMonitor)subMonitor.newChild(1));
        try {
            Map map = this.metadata.getSharingDescriptors(iComponentHandle, iContextHandle);
            return map;
        }
        finally {
            CopyFileAreaStore.endBatching(abstractLock, (IProgressMonitor)subMonitor.newChild(1));
            subMonitor.done();
        }
    }

    private void handleExceptions(List list, String string) throws FileSystemClientException {
        if (!list.isEmpty()) {
            MultiStatus multiStatus = new MultiStatus("com.ibm.team.filesystem.client", 0, string, null);
            for (FileSystemClientException fileSystemClientException : list) {
                multiStatus.add(FileSystemStatus.getStatusFor((Throwable)((Object)fileSystemClientException)));
            }
            throw (Throwable)((Object)new FileSystemClientException((IStatus)multiStatus));
        }
    }

    static /* synthetic */ IPath access$0(CopyFileAreaStore copyFileAreaStore, InverseFileItemInfo inverseFileItemInfo, IComponentHandle iComponentHandle, IContextHandle iContextHandle) throws FileSystemClientException {
        return copyFileAreaStore.getLocalPathInternal(inverseFileItemInfo, iComponentHandle, iContextHandle);
    }

    static /* synthetic */ void access$1(CopyFileAreaStore copyFileAreaStore, IPath iPath, IFolderHandle iFolderHandle, IComponentHandle iComponentHandle, IContextHandle iContextHandle) throws FileSystemClientException {
        copyFileAreaStore.updateLocalParent(iPath, iFolderHandle, iComponentHandle, iContextHandle);
    }

    static /* synthetic */ void access$2(CopyFileAreaStore copyFileAreaStore, FileItemInfo fileItemInfo, IComponentHandle iComponentHandle, IContextHandle iContextHandle) throws FileSystemClientException {
        copyFileAreaStore.updateParentInfoForRemoval(fileItemInfo, iComponentHandle, iContextHandle);
    }
}

