/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.copyfileareas;

import com.ibm.team.filesystem.client.ICopyFileAreaEvent;
import com.ibm.team.filesystem.client.ICopyFileAreaListener;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class CopyFileAreaNotifier
extends Job {
    private static final int SCHEDULING_DELAY = 1000;
    private final ArrayList collectedEvents = new ArrayList();
    private final ListenerList globalListeners = new ListenerList();
    private volatile long latestRequest;

    public CopyFileAreaNotifier() {
        super(Messages.CopyFileAreaNotifier_0);
        this.setSystem(true);
        this.setPriority(30);
    }

    public void addGlobalListener(ICopyFileAreaListener iCopyFileAreaListener) {
        this.globalListeners.add((Object)iCopyFileAreaListener);
    }

    public void removeGlobalListener(ICopyFileAreaListener iCopyFileAreaListener) {
        this.globalListeners.remove((Object)iCopyFileAreaListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireEvents(ICopyFileAreaEvent[] iCopyFileAreaEventArray) {
        if (iCopyFileAreaEventArray.length == 0) {
            return;
        }
        CopyFileAreaNotifier copyFileAreaNotifier = this;
        synchronized (copyFileAreaNotifier) {
            this.collectedEvents.addAll((Collection)Arrays.asList(iCopyFileAreaEventArray));
        }
        this.latestRequest = System.currentTimeMillis();
        this.schedule(1000L);
    }

    public void shutdown() {
        this.globalListeners.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IStatus run(IProgressMonitor iProgressMonitor) {
        ICopyFileAreaEvent[] iCopyFileAreaEventArray;
        if (System.currentTimeMillis() - this.latestRequest < 1000L) {
            this.schedule(1000L);
            return Status.CANCEL_STATUS;
        }
        CopyFileAreaNotifier copyFileAreaNotifier = this;
        synchronized (copyFileAreaNotifier) {
            iCopyFileAreaEventArray = this.collectedEvents.toArray(new ICopyFileAreaEvent[this.collectedEvents.size()]);
            this.collectedEvents.clear();
        }
        if (iCopyFileAreaEventArray.length == 0) {
            return Status.OK_STATUS;
        }
        copyFileAreaNotifier = new MultiStatus("com.ibm.team.filesystem.client", 0, Messages.CopyFileAreaNotifier_1, null);
        Object[] objectArray = this.globalListeners.getListeners();
        int n = objectArray.length;
        while (n != 0) {
            ICopyFileAreaListener iCopyFileAreaListener = (ICopyFileAreaListener)objectArray[--n];
            try {
                iCopyFileAreaListener.change(iCopyFileAreaEventArray);
            }
            catch (Exception exception) {
                copyFileAreaNotifier.add(FileSystemStatus.getStatusFor(4, "com.ibm.team.filesystem.client", 0, Messages.CopyFileAreaNotifier_2, exception));
            }
        }
        ICopyFileAreaEvent[] iCopyFileAreaEventArray2 = new ICopyFileAreaEvent[1];
        int n2 = 0;
        while (n2 != iCopyFileAreaEventArray.length) {
            ICopyFileAreaEvent iCopyFileAreaEvent = iCopyFileAreaEventArray[n2];
            objectArray = ((CopyFileAreaEvent)iCopyFileAreaEventArray[n2]).getCFA().listeners.getListeners();
            iCopyFileAreaEventArray2[0] = iCopyFileAreaEvent;
            int n3 = objectArray.length;
            while (n3 != 0) {
                ICopyFileAreaListener iCopyFileAreaListener = (ICopyFileAreaListener)objectArray[--n3];
                try {
                    iCopyFileAreaListener.change(iCopyFileAreaEventArray2);
                }
                catch (Exception exception) {
                    copyFileAreaNotifier.add(FileSystemStatus.getStatusFor(4, "com.ibm.team.filesystem.client", 0, Messages.CopyFileAreaNotifier_2, exception));
                }
            }
            ++n2;
        }
        return copyFileAreaNotifier.isOK() ? Status.OK_STATUS : copyFileAreaNotifier;
    }
}

