/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.copyfileareas;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.ICopyFileAreaListener;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.BiPartitionLock;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.ISharingMetadata;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.copyfileareas.AbstractLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.BatchingLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.BatchingLock$ThreadInfo;
import com.ibm.team.filesystem.client.internal.copyfileareas.CFACreateLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.CFARemoveLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileArea;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaEvent;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaLockRequestFactory;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaManager$$Cold;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaManager$1;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaManager$2;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaNotifier;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreasLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.GlobalLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileArea;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICorruptCopyFileAreaListener;
import com.ibm.team.filesystem.client.internal.copyfileareas.IFlushOperation;
import com.ibm.team.filesystem.client.internal.copyfileareas.ILockParticipant;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationDescriptor;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;

public class CopyFileAreaManager
implements ICopyFileAreaManager,
IFlushOperation {
    public static final CopyFileAreaManager instance = new CopyFileAreaManager();
    private static final String SCM_PRIVATE = ".jazz5";
    private static final String INTERUM_METADATA_FOLDER = ".jazz4";
    private static final String OLD_METADATA_FOLDER_NAME = ".jazz3";
    public static final String[] SUPPORTED_METADATA_FOLDERS = new String[]{".jazz5", ".jazz4", ".jazz3"};
    static final ILockParticipant NULL_PARTICIPANT = new CopyFileAreaManager$1();
    protected final BatchingLock batchingLock = new BatchingLock();
    protected final ConcurrentHashMap cfas = new ConcurrentHashMap();
    protected final CopyFileAreaNotifier notifier = new CopyFileAreaNotifier();
    protected final BiPartitionLock cfaListLock = new BiPartitionLock();
    protected final ListenerList corruptionListenerList = new ListenerList();

    private CopyFileAreaManager() {
    }

    public void addListener(ICopyFileAreaListener iCopyFileAreaListener) {
        this.notifier.addGlobalListener(iCopyFileAreaListener);
    }

    public void removeListener(ICopyFileAreaListener iCopyFileAreaListener) {
        this.notifier.removeGlobalListener(iCopyFileAreaListener);
    }

    public void flush(BatchingLock$ThreadInfo batchingLock$ThreadInfo, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        this.notifier.fireEvents(batchingLock$ThreadInfo.getEvents());
    }

    public boolean isLocked(AbstractLock abstractLock) {
        return this.batchingLock.isLocked(abstractLock);
    }

    public void endAvoidNotify(Object object, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        this.batchingLock.release((AbstractLock)object, iProgressMonitor);
    }

    public static IPath getMetadataPathForRoot(IPath iPath) {
        return iPath.append(SCM_PRIVATE);
    }

    public CopyFileAreaLockRequestFactory lockRequestFactory() {
        return CopyFileAreaLockRequestFactory.instance;
    }

    public void shutdown(IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        this.waitForJobs(300000L);
        ArrayList<IStatus> arrayList = new ArrayList<IStatus>();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        AbstractLock abstractLock = this.batchingLock.acquire(GlobalLock.INSTANCE, this, NULL_PARTICIPANT, true, (IProgressMonitor)subMonitor.newChild(10));
        try {
            SubMonitor subMonitor2 = subMonitor.newChild(80);
            this.cfaListLock.acquirePart1();
            try {
                subMonitor2.setWorkRemaining(this.cfas.size());
                for (CopyFileArea copyFileArea : this.cfas.values()) {
                    try {
                        this.deregister(copyFileArea.getRoot(), false, (IProgressMonitor)subMonitor2.newChild(1));
                    }
                    catch (Exception exception) {
                        arrayList.add(FileSystemStatus.getStatusFor(exception));
                    }
                }
                this.notifier.shutdown();
                subMonitor2.done();
            }
            finally {
                this.cfaListLock.releasePart1();
            }
        }
        finally {
            this.batchingLock.release(abstractLock, (IProgressMonitor)subMonitor.newChild(10));
        }
        int n = arrayList.size();
        if (n != 0) {
            throw (Throwable)((Object)new FileSystemClientException((IStatus)new MultiStatus("com.ibm.team.filesystem.client", 0, arrayList.toArray(new IStatus[n]), Messages.SharingManager_2, null)));
        }
    }

    private void waitForJobs(long l) {
        try {
            boolean bl = true;
            long l2 = System.currentTimeMillis();
            while (bl) {
                Job[] jobArray;
                bl = false;
                Job[] jobArray2 = jobArray = Job.getJobManager().find((Object)this);
                int n = jobArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Job job = jobArray2[n2];
                    if (job.belongsTo((Object)this) && job.getState() != 0) {
                        if (System.currentTimeMillis() - l2 > l) {
                            LoggingHelper.log(FileSystemStatus.getStatusFor(4, NLS.bind((String)"Job {0} has been in state {1} for too long", (Object)job.getName(), (Object)job.getState()), null));
                            return;
                        }
                        bl = true;
                        break;
                    }
                    ++n2;
                }
                if (!bl) continue;
                Thread.sleep(100L);
            }
        }
        catch (InterruptedException interruptedException) {}
    }

    public static IPath getOldMetadataPathForRoot(IPath iPath) {
        return iPath.append(OLD_METADATA_FOLDER_NAME);
    }

    public static IPath getInterumMetadataPathForRoot(IPath iPath) {
        return iPath.append(INTERUM_METADATA_FOLDER);
    }

    public void addCorruptionListener(ICorruptCopyFileAreaListener iCorruptCopyFileAreaListener) throws  {
        CopyFileAreaManager$$Cold.addCorruptionListener(this, iCorruptCopyFileAreaListener);
    }

    public void removeCorruptionListener(ICorruptCopyFileAreaListener iCorruptCopyFileAreaListener) throws  {
        CopyFileAreaManager$$Cold.removeCorruptionListener(this, iCorruptCopyFileAreaListener);
    }

    public Object beginAvoidNotify() throws  {
        return CopyFileAreaManager$$Cold.beginAvoidNotify(this);
    }

    public boolean copyFileAreaExists(IPath iPath, int n) {
        if (n == 1) {
            return CopyFileAreaManager.getMetadataPathForRoot(iPath).toFile().exists();
        }
        if (n == 0) {
            if (this.cfas.containsKey(iPath)) {
                return true;
            }
            return this.cfas.containsKey(CopyFileAreaManager.getCanonicalPath(iPath));
        }
        if (n == 2) {
            boolean bl = false;
            String[] stringArray = SUPPORTED_METADATA_FOLDERS;
            int n2 = SUPPORTED_METADATA_FOLDERS.length;
            int n3 = 0;
            while (n3 < n2) {
                String string = stringArray[n3];
                bl = iPath.append(string).toFile().exists();
                if (bl) {
                    return true;
                }
                ++n3;
            }
            return false;
        }
        return false;
    }

    private static IPath getCanonicalPath(IPath iPath) throws  {
        return CopyFileAreaManager$$Cold.getCanonicalPath(iPath);
    }

    private ISharingMetadata createSharingMetadata(IPath iPath) throws FileSystemClientException {
        return CopyFileAreaManager$$Cold.createSharingMetadata(this, iPath);
    }

    public CopyFileArea createCopyFileArea(IPath iPath, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        this.batchingLock.validateAcquire(CFACreateLock.INSTANCE);
        CopyFileArea copyFileArea = (CopyFileArea)this.cfas.get(iPath);
        if (copyFileArea != null) {
            return copyFileArea;
        }
        copyFileArea = (CopyFileArea)this.cfas.get(iPath = CopyFileAreaManager.getCanonicalPath(iPath));
        if (copyFileArea != null) {
            return copyFileArea;
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        AbstractLock abstractLock = this.batchingLock.acquire(CFACreateLock.INSTANCE, this, NULL_PARTICIPANT, true, (IProgressMonitor)subMonitor.newChild(40));
        try {
            iPath = CopyFileAreaManager.getCanonicalPath(iPath);
            copyFileArea = (CopyFileArea)this.cfas.get(iPath);
            if (copyFileArea != null) {
                CopyFileArea copyFileArea2 = copyFileArea;
                return copyFileArea2;
            }
            for (IPath iPath2 : this.cfas.keySet()) {
                if (!iPath2.isPrefixOf(iPath) && !iPath.isPrefixOf(iPath2)) continue;
                throw (Throwable)new IllegalArgumentException("Cannot nest CFAs " + iPath + " and " + iPath2);
            }
            copyFileArea = new CopyFileArea(iPath, this.createSharingMetadata(iPath));
            this.cfaListLock.acquirePart1();
            try {
                this.cfas.put(iPath, copyFileArea);
            }
            finally {
                this.cfaListLock.releasePart1();
            }
            this.batchingLock.addChange(new CopyFileAreaEvent(null, copyFileArea, null, 9));
            if (instance.requiresMigration(iPath)) {
                copyFileArea.internalGetMetadata().setCorrupt(true, "Metadata migration is required", null);
            }
        }
        finally {
            this.batchingLock.release(abstractLock, (IProgressMonitor)subMonitor.newChild(40));
        }
        return copyFileArea;
    }

    public void deregister(IPath iPath, boolean bl, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        if (!this.cfas.containsKey(iPath) && !this.cfas.containsKey(iPath = CopyFileAreaManager.getCanonicalPath(iPath))) {
            this.batchingLock.validateAcquire(new CFARemoveLock(iPath));
            return;
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        AbstractLock abstractLock = this.batchingLock.acquire(new CFARemoveLock(iPath), this, NULL_PARTICIPANT, true, (IProgressMonitor)subMonitor.newChild(40));
        try {
            CopyFileArea copyFileArea = (CopyFileArea)this.cfas.get(iPath);
            if (copyFileArea == null) {
                return;
            }
            this.cfaListLock.acquirePart1();
            try {
                copyFileArea.internalClose();
                if (bl) {
                    copyFileArea.internalClear();
                }
                this.cfas.remove(iPath);
            }
            finally {
                this.cfaListLock.releasePart1();
            }
            this.batchingLock.addChange(new CopyFileAreaEvent(null, copyFileArea, null, 10));
        }
        finally {
            this.batchingLock.release(abstractLock, (IProgressMonitor)subMonitor.newChild(40));
        }
    }

    public Collection getAllCopyFileAreas() throws  {
        return CopyFileAreaManager$$Cold.getAllCopyFileAreas(this);
    }

    public ICopyFileArea getCopyFileAreaForPath(IPath iPath) {
        Object object2;
        if (iPath.isAbsolute()) {
            for (Object object2 : this.getAllCopyFileAreas()) {
                if (!object2.getRoot().isPrefixOf(iPath)) continue;
                return object2;
            }
        }
        if (!(object2 = new Path(iPath.toFile().getAbsolutePath())).equals((Object)iPath)) {
            ArrayList arrayList = new ArrayList(this.getAllCopyFileAreas());
            Collections.sort(arrayList, new CopyFileAreaManager$2(this));
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                ICopyFileArea iCopyFileArea = (ICopyFileArea)iterator.next();
                if (object2.segmentCount() < iCopyFileArea.getRoot().segmentCount()) continue;
                IPath iPath2 = object2.removeLastSegments(object2.segmentCount() - iCopyFileArea.getRoot().segmentCount());
                IPath iPath3 = CopyFileAreaManager.getCanonicalPath(iPath2);
                if (!iCopyFileArea.getRoot().equals((Object)iPath3)) continue;
                return iCopyFileArea;
            }
        }
        return null;
    }

    public Collection getCopyFileAreasForConnection(IConnection iConnection, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        return CopyFileAreaManager$$Cold.getCopyFileAreasForConnection(this, iConnection, iProgressMonitor);
    }

    public Collection getCopyFileAreasForConfiguration(ConfigurationDescriptor configurationDescriptor, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        return CopyFileAreaManager$$Cold.getCopyFileAreasForConfiguration(this, configurationDescriptor, iProgressMonitor);
    }

    public CopyFileArea getExistingCopyFileArea(IPath iPath) {
        CopyFileArea copyFileArea = (CopyFileArea)this.cfas.get(iPath);
        if (copyFileArea != null) {
            return copyFileArea;
        }
        return (CopyFileArea)this.cfas.get(CopyFileAreaManager.getCanonicalPath(iPath));
    }

    public int getNumShares(IContextHandle iContextHandle, IComponentHandle iComponentHandle, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        return CopyFileAreaManager$$Cold.getNumShares(this, iContextHandle, iComponentHandle, iProgressMonitor);
    }

    public AbstractLock getSchedulingRule(IShareable iShareable, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        return CopyFileAreaManager$$Cold.getSchedulingRule(this, iShareable, iProgressMonitor);
    }

    public boolean isConnectionShared(IContextHandle iContextHandle) throws FileSystemClientException {
        return CopyFileAreaManager$$Cold.isConnectionShared(this, iContextHandle);
    }

    public CopyFileAreasLock lock(Collection collection, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        return CopyFileAreaManager$$Cold.lock(this, collection, iProgressMonitor);
    }

    public void internalClear() throws FileSystemClientException {
        this.waitForJobs(30000L);
        AbstractLock abstractLock = this.batchingLock.acquire(GlobalLock.INSTANCE, this, NULL_PARTICIPANT, true, null);
        try {
            this.cfaListLock.acquirePart1();
            try {
                for (CopyFileArea copyFileArea : this.cfas.values()) {
                    copyFileArea.internalClear();
                }
                this.cfas.clear();
            }
            finally {
                this.cfaListLock.releasePart1();
            }
        }
        finally {
            this.batchingLock.release(abstractLock, null);
        }
    }

    public boolean hasOldMetaDataFolder(IPath iPath) {
        IPath iPath2 = CopyFileAreaManager.getCanonicalPath(iPath);
        return CopyFileAreaManager.getOldMetadataPathForRoot(iPath2).toFile().exists();
    }

    public boolean hasInterumMetadataFolder(IPath iPath) {
        IPath iPath2 = CopyFileAreaManager.getCanonicalPath(iPath);
        return CopyFileAreaManager.getInterumMetadataPathForRoot(iPath2).toFile().exists();
    }

    public boolean requiresMigration(IPath iPath) throws  {
        return CopyFileAreaManager$$Cold.requiresMigration(this, iPath);
    }
}

