/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.copyfileareas;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.internal.copyfileareas.ComponentLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaLockRequest;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaStore;
import com.ibm.team.filesystem.client.internal.copyfileareas.GlobalCFALock;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileArea;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationDescriptor;
import java.util.Collection;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

public class CopyFileAreaConfigurationLockRequest
extends CopyFileAreaLockRequest {
    private final Collection configurationsToLock;
    private final boolean expandToIncludeEntireCopyFileArea;
    private final IPath cfaPath;

    public CopyFileAreaConfigurationLockRequest(IPath iPath, Collection collection, boolean bl) {
        this.cfaPath = iPath;
        this.configurationsToLock = collection;
        this.expandToIncludeEntireCopyFileArea = bl;
    }

    public void addLocks(Set set, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        if (!this.expandToIncludeEntireCopyFileArea && this.configurationsToLock.isEmpty()) {
            return;
        }
        ICopyFileArea iCopyFileArea = CopyFileAreaManager.instance.getExistingCopyFileArea(this.cfaPath);
        if (iCopyFileArea == null) {
            iCopyFileArea = CopyFileAreaManager.instance.createCopyFileArea(this.cfaPath, iProgressMonitor);
        }
        if (this.expandToIncludeEntireCopyFileArea) {
            set.add(new GlobalCFALock(((CopyFileAreaStore)((Object)iCopyFileArea)).getRoot()));
        } else {
            for (ConfigurationDescriptor configurationDescriptor : this.configurationsToLock) {
                set.add(new ComponentLock(((CopyFileAreaStore)((Object)iCopyFileArea)).getRoot(), configurationDescriptor.connectionHandle, configurationDescriptor.componentHandle));
            }
        }
    }

    public boolean validateLocks(IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        if (!this.expandToIncludeEntireCopyFileArea && this.configurationsToLock.isEmpty()) {
            return true;
        }
        ICopyFileArea iCopyFileArea = CopyFileAreaManager.instance.getExistingCopyFileArea(this.cfaPath);
        if (iCopyFileArea == null) {
            return false;
        }
        if (this.expandToIncludeEntireCopyFileArea) {
            return CopyFileAreaManager.instance.batchingLock.isLocked(new GlobalCFALock(((CopyFileAreaStore)((Object)iCopyFileArea)).getRoot()));
        }
        for (ConfigurationDescriptor configurationDescriptor : this.configurationsToLock) {
            if (CopyFileAreaManager.instance.batchingLock.isLocked(new ComponentLock(((CopyFileAreaStore)((Object)iCopyFileArea)).getRoot(), configurationDescriptor.connectionHandle, configurationDescriptor.componentHandle))) continue;
            return false;
        }
        return true;
    }
}

