/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.copyfileareas;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.internal.FileItemInfo;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.ISharingMetadata;
import com.ibm.team.filesystem.client.internal.ISharingMetadata$ISharingDescriptorPath;
import com.ibm.team.filesystem.client.internal.InverseFileItemInfo;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.Share;
import com.ibm.team.filesystem.client.internal.copyfileareas.AbstractLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.ComponentLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileArea$1;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaStore;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaStore$RuleDescriptorPair;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileArea;
import com.ibm.team.filesystem.client.internal.utils.NonCancellingProgressMonitor;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class CopyFileArea
extends CopyFileAreaStore
implements ICopyFileArea {
    protected CopyFileArea(IPath iPath, ISharingMetadata iSharingMetadata) {
        super(iPath, iSharingMetadata);
    }

    public Collection allShares() throws FileSystemClientException {
        this.assertReadLocked();
        ArrayList<Share> arrayList = new ArrayList<Share>();
        Map map = this.metadata.getSharingDescriptors();
        for (Map.Entry entry : map.entrySet()) {
            arrayList.add(new Share(this.path, (IPath)entry.getKey(), this.isCaseSensitive(), (ISharingDescriptor)entry.getValue()));
        }
        return arrayList;
    }

    public Collection allShares(IContextHandle iContextHandle, IComponentHandle iComponentHandle, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        Map map = super.getShares(iContextHandle, iComponentHandle, iProgressMonitor);
        ArrayList<Share> arrayList = new ArrayList<Share>(map.size());
        for (Map.Entry entry : map.entrySet()) {
            arrayList.add(new Share(this.path, (IPath)entry.getKey(), this.isCaseSensitive(), (ISharingDescriptor)entry.getValue()));
        }
        return arrayList;
    }

    public void newItem(IPath iPath, IVersionableHandle iVersionableHandle, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        if (iVersionableHandle instanceof IFolderHandle) {
            this.setItemInfo(iPath, new FileItemInfo((IFolderHandle)iVersionableHandle, null, null, false), iProgressMonitor);
        } else {
            this.setItemInfo(iPath, new FileItemInfo(iVersionableHandle, false, -1L, null, null, false, null, -1L, null, null, null, null, null, -1L, null, null, -1L, false, false), iProgressMonitor);
        }
    }

    public boolean forget(IPath iPath, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        this.assertReadLocked();
        boolean bl = true;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        CopyFileAreaStore$RuleDescriptorPair copyFileAreaStore$RuleDescriptorPair = this.beginBatching(iPath, (IProgressMonitor)subMonitor.newChild(1));
        try {
            if (copyFileAreaStore$RuleDescriptorPair.desc == null) {
                throw (Throwable)new IllegalArgumentException();
            }
            SubMonitor subMonitor2 = SubMonitor.convert((IProgressMonitor)((IProgressMonitor)new NonCancellingProgressMonitor((IProgressMonitor)subMonitor.newChild(98))), (int)98);
            if (this.metadata.getSharingDescriptor(iPath) == null) {
                bl = false;
                subMonitor2.setWorkRemaining(49);
            }
            this.deleteTreeInfo(iPath, true, (IProgressMonitor)subMonitor2.newChild(49));
            if (bl) {
                this.removeSharingInfo(iPath, (IProgressMonitor)subMonitor2.newChild(49));
            }
        }
        finally {
            CopyFileArea.endBatching(copyFileAreaStore$RuleDescriptorPair.rule, (IProgressMonitor)subMonitor.newChild(1));
        }
        subMonitor.done();
        return bl;
    }

    public boolean forget(IContextHandle iContextHandle, IComponentHandle iComponentHandle, IVersionableHandle iVersionableHandle, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        boolean bl = true;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        AbstractLock abstractLock = CopyFileArea.beginBatching(new ComponentLock(this.getRoot(), iContextHandle, iComponentHandle), (IProgressMonitor)subMonitor.newChild(1));
        try {
            InverseFileItemInfo inverseFileItemInfo;
            if (!this.isShareRoot(iVersionableHandle, iComponentHandle, iContextHandle)) {
                bl = false;
                subMonitor.setWorkRemaining(50);
            }
            if ((inverseFileItemInfo = this.getItemInfo(iVersionableHandle, iComponentHandle, iContextHandle)) != null) {
                this.deleteTreeInfo(iVersionableHandle, iComponentHandle, iContextHandle, (IProgressMonitor)subMonitor.newChild(49));
            }
            if (bl) {
                this.removeSharingInfo(iContextHandle, iComponentHandle, iVersionableHandle, (IProgressMonitor)subMonitor.newChild(49));
            }
        }
        finally {
            CopyFileArea.endBatching(abstractLock, (IProgressMonitor)subMonitor.newChild(1));
        }
        subMonitor.done();
        return bl;
    }

    public void restoreVersionable(IPath iPath, ISharingDescriptor iSharingDescriptor, IVersionableHandle iVersionableHandle, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        AbstractLock abstractLock = CopyFileArea.beginBatching(new ComponentLock(this.getRoot(), iSharingDescriptor.getConnectionHandle(), iSharingDescriptor.getComponent()), (IProgressMonitor)subMonitor.newChild(1));
        try {
            InverseFileItemInfo inverseFileItemInfo = this.getItemInfo(iVersionableHandle, iSharingDescriptor.getComponent(), iSharingDescriptor.getConnectionHandle());
            Assert.isTrue((inverseFileItemInfo != null ? 1 : 0) != 0);
            Assert.isTrue((((FileItemInfo)inverseFileItemInfo).getParent() != null ? 1 : 0) != 0);
            this.setItemInfo(iPath, new FileItemInfo(((FileItemInfo)inverseFileItemInfo).getVersionableHandle(), !(iVersionableHandle instanceof IFolderHandle), -1L, ((FileItemInfo)inverseFileItemInfo).getParent(), ((FileItemInfo)inverseFileItemInfo).getName(), ((FileItemInfo)inverseFileItemInfo).isLoadedWithAnotherName(), ((FileItemInfo)inverseFileItemInfo).getHash(), ((FileItemInfo)inverseFileItemInfo).getContentLength(), ((FileItemInfo)inverseFileItemInfo).getOriginalLineDelimiter(), ((FileItemInfo)inverseFileItemInfo).getLineDelimiter(), ((FileItemInfo)inverseFileItemInfo).getOriginalContentType(), ((FileItemInfo)inverseFileItemInfo).getContentType(), ((FileItemInfo)inverseFileItemInfo).getStoredPredecessorHintHash(), ((FileItemInfo)inverseFileItemInfo).getStoredSize(), ((FileItemInfo)inverseFileItemInfo).getStoredEncoding(), ((FileItemInfo)inverseFileItemInfo).getStoredHash(), ((FileItemInfo)inverseFileItemInfo).getStoredNumLineDelimiters(), ((FileItemInfo)inverseFileItemInfo).isOriginalExecutable(), ((FileItemInfo)inverseFileItemInfo).isOriginalExecutable()), (IProgressMonitor)subMonitor.newChild(98));
        }
        finally {
            CopyFileArea.endBatching(abstractLock, (IProgressMonitor)subMonitor.newChild(1));
        }
        subMonitor.done();
    }

    public Share getShare(IPath iPath) {
        this.assertReadLocked();
        try {
            ISharingMetadata$ISharingDescriptorPath iSharingMetadata$ISharingDescriptorPath = this.metadata.findSharingDescriptorPath(iPath);
            if (iSharingMetadata$ISharingDescriptorPath != null) {
                return new Share(this.getRoot(), iSharingMetadata$ISharingDescriptorPath.getPath(), this.isCaseSensitive(), iSharingMetadata$ISharingDescriptorPath.getDescriptor());
            }
        }
        catch (FileSystemClientException fileSystemClientException) {
            LoggingHelper.log(fileSystemClientException);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IShare getShare(IContextHandle iContextHandle, IComponentHandle iComponentHandle, IVersionableHandle iVersionableHandle, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        this.assertReadLocked();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        AbstractLock abstractLock = CopyFileArea.beginBatching(new ComponentLock(this.getRoot(), iContextHandle, iComponentHandle), (IProgressMonitor)subMonitor.newChild(1));
        try {
            InverseFileItemInfo inverseFileItemInfo;
            while (!this.isShareRoot(iVersionableHandle, iComponentHandle, iContextHandle)) {
                inverseFileItemInfo = this.getItemInfo(iVersionableHandle, iComponentHandle, iContextHandle);
                if (inverseFileItemInfo == null) {
                    return null;
                }
                iVersionableHandle = inverseFileItemInfo.getLocalParent();
                if (iVersionableHandle != null) continue;
                iVersionableHandle = inverseFileItemInfo.getParent();
            }
            inverseFileItemInfo = this.getLocalPathFor(iContextHandle, iComponentHandle, iVersionableHandle, (IProgressMonitor)subMonitor.newChild(98));
            if (inverseFileItemInfo == null) return null;
            ISharingDescriptor iSharingDescriptor = this.getSharingInfo((IPath)inverseFileItemInfo);
            if (iSharingDescriptor == null) return null;
            Share share = new Share(this.getRoot(), (IPath)inverseFileItemInfo, this.isCaseSensitive(), iSharingDescriptor);
            return share;
        }
        finally {
            CopyFileArea.endBatching(abstractLock, (IProgressMonitor)subMonitor.newChild(1));
            subMonitor.done();
        }
    }

    public void syncMetaData() throws FileSystemClientException {
        this.sync();
    }

    public IPath getLocalPathFor(IContextHandle iContextHandle, IComponentHandle iComponentHandle, IVersionableHandle iVersionableHandle, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        return this.getLocalPathFor(iVersionableHandle, iComponentHandle, iContextHandle, iProgressMonitor);
    }

    public IPath getRemotePathFor(IContextHandle iContextHandle, IComponentHandle iComponentHandle, IVersionableHandle iVersionableHandle, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        return super.getRemotePathFor(iVersionableHandle, iComponentHandle, iContextHandle, iProgressMonitor);
    }

    public Collection getLocalPathsFor(IComponentHandle iComponentHandle, IVersionableHandle iVersionableHandle, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        return this.getLocalItemPaths(iVersionableHandle, iComponentHandle, iProgressMonitor);
    }

    public Collection getLocalPathsFor(IVersionableHandle iVersionableHandle, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        return this.getLocalItemPaths(iVersionableHandle, iProgressMonitor);
    }

    public void share(IPath iPath, ISharingDescriptor iSharingDescriptor, FileItemInfo fileItemInfo, int n, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)102);
        ISharingDescriptor[] iSharingDescriptorArray = new ISharingDescriptor[1];
        FileSystemClientException[] fileSystemClientExceptionArray = new FileSystemClientException[1];
        AbstractLock abstractLock = null;
        try {
            abstractLock = CopyFileArea.beginBatchingWithLock(null, new CopyFileArea$1(this, iSharingDescriptorArray, iPath, iSharingDescriptor, fileSystemClientExceptionArray), (IProgressMonitor)subMonitor.newChild(1));
            if (iSharingDescriptorArray[0] != null) {
                if (this.metadata.getPathForShareRoot(iSharingDescriptorArray[0].getRootVersionable(), iSharingDescriptorArray[0].getComponent(), iSharingDescriptorArray[0].getConnectionHandle()).segmentCount() != iPath.segmentCount()) {
                    throw (Throwable)new IllegalArgumentException();
                }
                if ((n & 1) == 1) {
                    if (fileItemInfo != null) {
                        subMonitor.setWorkRemaining(151);
                    }
                    this.forget(iPath, (IProgressMonitor)subMonitor.newChild(50));
                } else if ((n & 2) != 2) {
                    throw (Throwable)((Object)new FileSystemClientException(new FileSystemStatus(4, NLS.bind((String)Messages.CopyFileArea_0, (Object)iPath, (Object[])new Object[0]))));
                }
            }
            if (fileItemInfo == null) {
                subMonitor.setWorkRemaining(51);
            }
            this.setSharingInfo(iPath, iSharingDescriptor, (IProgressMonitor)subMonitor.newChild(50));
            if (fileItemInfo != null) {
                this.setItemInfo(iPath, fileItemInfo, (IProgressMonitor)subMonitor.newChild(50));
            }
        }
        catch (Throwable throwable) {
            this.sharingInfoLock.unlock();
            if (abstractLock != null) {
                CopyFileArea.endBatching(abstractLock, (IProgressMonitor)subMonitor.newChild(1));
            }
            throw throwable;
        }
        this.sharingInfoLock.unlock();
        if (abstractLock != null) {
            CopyFileArea.endBatching(abstractLock, (IProgressMonitor)subMonitor.newChild(1));
        }
    }

    public void setItemMetaData(IPath iPath, FileItemInfo fileItemInfo, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        this.setItemInfo(iPath, fileItemInfo, iProgressMonitor);
    }

    public void setItemMetaData(IContextHandle iContextHandle, IComponentHandle iComponentHandle, FileItemInfo fileItemInfo, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        this.setItemInfo(fileItemInfo.getVersionableHandle(), iComponentHandle, iContextHandle, fileItemInfo, iProgressMonitor);
    }

    public void moveInfo(IPath iPath, IPath iPath2, boolean bl, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        CopyFileAreaStore$RuleDescriptorPair copyFileAreaStore$RuleDescriptorPair = this.beginBatching(iPath, (IProgressMonitor)subMonitor.newChild(1));
        try {
            if (copyFileAreaStore$RuleDescriptorPair.desc == null) {
                throw (Throwable)new IllegalArgumentException();
            }
            if (this.getSharingInfo(iPath) != null) {
                this.moveSharingInfo(iPath, iPath2, iProgressMonitor);
            } else {
                this.moveTreeInfo(iPath, iPath2, bl, iProgressMonitor);
            }
        }
        finally {
            CopyFileArea.endBatching(copyFileAreaStore$RuleDescriptorPair.rule, (IProgressMonitor)subMonitor.newChild(1));
        }
    }

    public boolean isConfigurationShared(IContextHandle iContextHandle, IComponentHandle iComponentHandle, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        return this.isLoaded(iComponentHandle, iContextHandle, iProgressMonitor);
    }

    public Collection allLoadedConfigurations(IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        return this.allLoadedComponents(iProgressMonitor);
    }

    public void makePendingDeletion(IPath iPath, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        this.deleteTreeInfo(iPath, false, iProgressMonitor);
    }
}

