/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.copyfileareas;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.ISharingMetadata;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.copyfileareas.AbstractLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.CFALockUtil$LockResult;
import com.ibm.team.filesystem.client.internal.copyfileareas.CFAReadLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.CFARemoveLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.ComponentLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileArea;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaStore;
import com.ibm.team.filesystem.client.internal.copyfileareas.GlobalCFALock;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileArea;
import com.ibm.team.filesystem.client.internal.copyfileareas.MultiLock;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

public final class CFALockUtil {
    public static final int LOCK_OBTAINED = 0;
    public static final int PATH_NOT_MANAGED = 1;
    public static final int LOCK_HELD_BY_ANOTHER_THREAD = 2;
    public static final int LOCK_REQUEST_CANCELED = 3;
    public static final int LOCK_REQUEST_FAILED = 4;

    private CFALockUtil() {
    }

    public static boolean isLocked(AbstractLock abstractLock) {
        return CopyFileAreaManager.instance.isLocked(abstractLock);
    }

    public static boolean isLockedForUpdate(IPath iPath, IComponentHandle iComponentHandle, IContextHandle iContextHandle) {
        ICopyFileArea iCopyFileArea = CopyFileAreaManager.instance.getExistingCopyFileArea(iPath);
        if (iCopyFileArea == null) {
            return false;
        }
        return CFALockUtil.isLocked(new ComponentLock(((CopyFileAreaStore)((Object)iCopyFileArea)).getRoot(), iContextHandle, iComponentHandle));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AbstractLock lockExistingForUpdate(IPath iPath, IPath iPath2, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        AbstractLock abstractLock = CFALockUtil.lockExistingForRead(iPath, (IProgressMonitor)subMonitor.newChild(20));
        if (abstractLock == null) {
            subMonitor.done();
            return null;
        }
        boolean bl = false;
        try {
            ICopyFileArea iCopyFileArea = CopyFileAreaManager.instance.getExistingCopyFileArea(iPath);
            ISharingDescriptor iSharingDescriptor = ((CopyFileAreaStore)((Object)iCopyFileArea)).findSharingDescriptor(iPath2);
            CFALockUtil.endBatching(abstractLock, (IProgressMonitor)subMonitor.newChild(1));
            bl = true;
            if (iSharingDescriptor == null) {
                subMonitor.done();
                return null;
            }
            IPath iPath3 = ((CopyFileAreaStore)((Object)iCopyFileArea)).getRoot();
            while (true) {
                abstractLock = CFALockUtil.beginBatching(new ComponentLock(iPath3, iSharingDescriptor.getConnectionHandle(), iSharingDescriptor.getComponent()), true, (IProgressMonitor)subMonitor.newChild(30));
                bl = false;
                iCopyFileArea = CopyFileAreaManager.instance.getExistingCopyFileArea(iPath);
                if (iCopyFileArea == null) {
                    CFALockUtil.endBatching(abstractLock, (IProgressMonitor)subMonitor.newChild(1));
                    subMonitor.done();
                    bl = true;
                    return null;
                }
                IPath iPath4 = ((CopyFileAreaStore)((Object)iCopyFileArea)).getRoot();
                if (!iPath4.equals((Object)iPath3)) {
                    iPath3 = iPath4;
                } else {
                    ISharingDescriptor iSharingDescriptor2 = ((CopyFileAreaStore)((Object)iCopyFileArea)).findSharingDescriptor(iPath2);
                    if (iSharingDescriptor2 == null) {
                        CFALockUtil.endBatching(abstractLock, (IProgressMonitor)subMonitor.newChild(1));
                        subMonitor.done();
                        bl = true;
                        return null;
                    }
                    if (iSharingDescriptor2.getComponent().sameItemId((IItemHandle)iSharingDescriptor.getComponent()) && iSharingDescriptor2.getConnectionHandle().sameItemId((IItemHandle)iSharingDescriptor.getConnectionHandle())) {
                        subMonitor.done();
                        bl = true;
                        AbstractLock abstractLock2 = abstractLock;
                        return abstractLock2;
                    }
                    iSharingDescriptor = iSharingDescriptor2;
                }
                CFALockUtil.endBatching(abstractLock, (IProgressMonitor)subMonitor.newChild(1));
                bl = true;
                subMonitor.setWorkRemaining(79);
            }
        }
        finally {
            if (!bl) {
                CFALockUtil.endBatching(abstractLock, (IProgressMonitor)subMonitor.newChild(1));
            }
        }
    }

    public static AbstractLock lockExistingForRead(IPath iPath, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        ICopyFileArea iCopyFileArea = CopyFileAreaManager.instance.getExistingCopyFileArea(iPath);
        if (iCopyFileArea == null) {
            subMonitor.done();
            return null;
        }
        IPath iPath2 = ((CopyFileAreaStore)((Object)iCopyFileArea)).getRoot();
        while (true) {
            AbstractLock abstractLock = CFALockUtil.beginBatching(new CFAReadLock(iPath2), true, (IProgressMonitor)subMonitor.newChild(50));
            boolean bl = false;
            try {
                iCopyFileArea = CopyFileAreaManager.instance.getExistingCopyFileArea(iPath);
                if (iCopyFileArea == null) {
                    return null;
                }
                IPath iPath3 = ((CopyFileAreaStore)((Object)iCopyFileArea)).getRoot();
                if (iPath3.equals((Object)iPath2)) {
                    subMonitor.done();
                    bl = true;
                    AbstractLock abstractLock2 = abstractLock;
                    return abstractLock2;
                }
                iPath2 = iPath3;
            }
            finally {
                if (!bl) {
                    CopyFileAreaStore.endBatching(abstractLock, (IProgressMonitor)subMonitor.newChild(1));
                }
            }
            subMonitor.setWorkRemaining(100);
        }
    }

    public static AbstractLock lockExistingForGlobalUpdate(IPath iPath, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        ICopyFileArea iCopyFileArea = CopyFileAreaManager.instance.getExistingCopyFileArea(iPath);
        if (iCopyFileArea == null) {
            subMonitor.done();
            return null;
        }
        IPath iPath2 = ((CopyFileAreaStore)((Object)iCopyFileArea)).getRoot();
        while (true) {
            AbstractLock abstractLock = CFALockUtil.beginBatching(new GlobalCFALock(iPath2), true, (IProgressMonitor)subMonitor.newChild(50));
            boolean bl = false;
            try {
                iCopyFileArea = CopyFileAreaManager.instance.getExistingCopyFileArea(iPath);
                if (iCopyFileArea == null) {
                    return null;
                }
                IPath iPath3 = ((CopyFileAreaStore)((Object)iCopyFileArea)).getRoot();
                if (iPath3.equals((Object)iPath2)) {
                    subMonitor.done();
                    bl = true;
                    AbstractLock abstractLock2 = abstractLock;
                    return abstractLock2;
                }
                iPath2 = iPath3;
            }
            finally {
                if (!bl) {
                    CopyFileAreaStore.endBatching(abstractLock, (IProgressMonitor)subMonitor.newChild(1));
                }
            }
            subMonitor.setWorkRemaining(100);
        }
    }

    public static AbstractLock lockExistingForUpdate(IPath iPath, IContextHandle iContextHandle, IComponentHandle iComponentHandle, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        ICopyFileArea iCopyFileArea = CopyFileAreaManager.instance.getExistingCopyFileArea(iPath);
        if (iCopyFileArea == null) {
            subMonitor.done();
            return null;
        }
        IPath iPath2 = ((CopyFileAreaStore)((Object)iCopyFileArea)).getRoot();
        while (true) {
            AbstractLock abstractLock = CFALockUtil.beginBatching(new ComponentLock(iPath2, iContextHandle, iComponentHandle), true, (IProgressMonitor)subMonitor.newChild(50));
            boolean bl = false;
            try {
                iCopyFileArea = CopyFileAreaManager.instance.getExistingCopyFileArea(iPath);
                if (iCopyFileArea == null) {
                    return null;
                }
                IPath iPath3 = ((CopyFileAreaStore)((Object)iCopyFileArea)).getRoot();
                if (iPath3.equals((Object)iPath2)) {
                    subMonitor.done();
                    bl = true;
                    AbstractLock abstractLock2 = abstractLock;
                    return abstractLock2;
                }
                iPath2 = iPath3;
            }
            finally {
                if (!bl) {
                    CopyFileAreaStore.endBatching(abstractLock, (IProgressMonitor)subMonitor.newChild(1));
                }
            }
            subMonitor.setWorkRemaining(100);
        }
    }

    public static AbstractLock lockExistingForReadForLocation(IPath iPath, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        ICopyFileArea iCopyFileArea = CopyFileAreaManager.instance.getCopyFileAreaForPath(iPath);
        if (iCopyFileArea == null) {
            subMonitor.done();
            return null;
        }
        IPath iPath2 = iCopyFileArea.getRoot();
        while (true) {
            AbstractLock abstractLock = CFALockUtil.beginBatching(new CFAReadLock(iPath2), true, (IProgressMonitor)subMonitor.newChild(50));
            boolean bl = false;
            try {
                iCopyFileArea = CopyFileAreaManager.instance.getExistingCopyFileArea(iPath2);
                if (iCopyFileArea != null) {
                    IPath iPath3 = iCopyFileArea.getRoot();
                    if (iPath3.equals((Object)iPath2)) {
                        subMonitor.done();
                        bl = true;
                        AbstractLock abstractLock2 = abstractLock;
                        return abstractLock2;
                    }
                    iPath2 = iPath3;
                } else {
                    CopyFileAreaStore.endBatching(abstractLock, (IProgressMonitor)subMonitor.newChild(1));
                    bl = true;
                    iCopyFileArea = CopyFileAreaManager.instance.getCopyFileAreaForPath(iPath);
                    if (iCopyFileArea == null) {
                        subMonitor.done();
                        return null;
                    }
                    iPath2 = iCopyFileArea.getRoot();
                }
            }
            finally {
                if (!bl) {
                    CopyFileAreaStore.endBatching(abstractLock, (IProgressMonitor)subMonitor.newChild(1));
                }
            }
            subMonitor.setWorkRemaining(100);
        }
    }

    public static AbstractLock beginBatching(AbstractLock abstractLock, boolean bl, IProgressMonitor iProgressMonitor) {
        CopyFileAreaManager copyFileAreaManager = CopyFileAreaManager.instance;
        return copyFileAreaManager.batchingLock.acquire(abstractLock, copyFileAreaManager, CopyFileAreaManager.NULL_PARTICIPANT, bl, iProgressMonitor);
    }

    public static void endBatching(AbstractLock abstractLock, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        CopyFileAreaManager.instance.batchingLock.release(abstractLock, iProgressMonitor);
    }

    public static AbstractLock createAndLockSuperExclusive(IPath iPath, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        ICopyFileArea iCopyFileArea = CopyFileAreaManager.instance.getExistingCopyFileArea(iPath);
        if (iCopyFileArea == null) {
            iCopyFileArea = CopyFileAreaManager.instance.createCopyFileArea(iPath, (IProgressMonitor)subMonitor.newChild(30));
        }
        IPath iPath2 = ((CopyFileAreaStore)((Object)iCopyFileArea)).getRoot();
        while (true) {
            AbstractLock abstractLock = CFALockUtil.beginBatching(new CFARemoveLock(iPath2), true, (IProgressMonitor)subMonitor.newChild(20));
            boolean bl = false;
            try {
                iCopyFileArea = CopyFileAreaManager.instance.getExistingCopyFileArea(iPath2);
                if (iCopyFileArea != null) {
                    IPath iPath3 = ((CopyFileAreaStore)((Object)iCopyFileArea)).getRoot();
                    if (iPath3.equals((Object)iPath2)) {
                        subMonitor.done();
                        bl = true;
                        AbstractLock abstractLock2 = abstractLock;
                        return abstractLock2;
                    }
                    iPath2 = iPath3;
                } else {
                    CFALockUtil.endBatching(abstractLock, (IProgressMonitor)subMonitor.newChild(1));
                    bl = true;
                    iCopyFileArea = CopyFileAreaManager.instance.createCopyFileArea(iPath, (IProgressMonitor)subMonitor.newChild(1));
                    iPath2 = ((CopyFileAreaStore)((Object)iCopyFileArea)).getRoot();
                }
            }
            finally {
                if (!bl) {
                    CFALockUtil.endBatching(abstractLock, (IProgressMonitor)subMonitor.newChild(1));
                }
            }
            subMonitor.setWorkRemaining(70);
        }
    }

    public static AbstractLock createAndLockForReading(IPath iPath, boolean bl, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        ICopyFileArea iCopyFileArea = CopyFileAreaManager.instance.getExistingCopyFileArea(iPath);
        if (iCopyFileArea == null) {
            iCopyFileArea = CopyFileAreaManager.instance.createCopyFileArea(iPath, (IProgressMonitor)subMonitor.newChild(30));
        }
        IPath iPath2 = ((CopyFileAreaStore)((Object)iCopyFileArea)).getRoot();
        AbstractLock abstractLock;
        while ((abstractLock = CFALockUtil.beginBatching(new CFAReadLock(iPath2), bl, (IProgressMonitor)subMonitor.newChild(20))) != null) {
            boolean bl2 = false;
            try {
                iCopyFileArea = CopyFileAreaManager.instance.getExistingCopyFileArea(iPath2);
                if (iCopyFileArea != null) {
                    IPath iPath3 = ((CopyFileAreaStore)((Object)iCopyFileArea)).getRoot();
                    if (iPath3.equals((Object)iPath2)) {
                        subMonitor.done();
                        bl2 = true;
                        AbstractLock abstractLock2 = abstractLock;
                        return abstractLock2;
                    }
                    iPath2 = iPath3;
                } else {
                    CFALockUtil.endBatching(abstractLock, (IProgressMonitor)subMonitor.newChild(1));
                    bl2 = true;
                    iCopyFileArea = CopyFileAreaManager.instance.createCopyFileArea(iPath, (IProgressMonitor)subMonitor.newChild(1));
                    iPath2 = ((CopyFileAreaStore)((Object)iCopyFileArea)).getRoot();
                }
            }
            finally {
                if (!bl2) {
                    CFALockUtil.endBatching(abstractLock, (IProgressMonitor)subMonitor.newChild(1));
                }
            }
            subMonitor.setWorkRemaining(70);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static AbstractLock createAndLockForUpdate(IPath iPath, IPath iPath2, boolean bl, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        AbstractLock abstractLock = CFALockUtil.createAndLockForReading(iPath, bl, (IProgressMonitor)subMonitor.newChild(20));
        if (abstractLock == null) {
            return null;
        }
        boolean bl2 = false;
        try {
            ICopyFileArea iCopyFileArea = CopyFileAreaManager.instance.getExistingCopyFileArea(iPath);
            ISharingDescriptor iSharingDescriptor = ((CopyFileAreaStore)((Object)iCopyFileArea)).findSharingDescriptor(iPath2);
            CFALockUtil.endBatching(abstractLock, (IProgressMonitor)subMonitor.newChild(1));
            bl2 = true;
            if (iSharingDescriptor == null) {
                subMonitor.done();
                return null;
            }
            IPath iPath3 = ((CopyFileAreaStore)((Object)iCopyFileArea)).getRoot();
            while (true) {
                if ((abstractLock = CFALockUtil.beginBatching(new ComponentLock(iPath3, iSharingDescriptor.getConnectionHandle(), iSharingDescriptor.getComponent()), bl, (IProgressMonitor)subMonitor.newChild(30))) == null) {
                    return null;
                }
                bl2 = false;
                iCopyFileArea = CopyFileAreaManager.instance.getExistingCopyFileArea(iPath);
                if (iCopyFileArea == null) {
                    CFALockUtil.endBatching(abstractLock, (IProgressMonitor)subMonitor.newChild(1));
                    bl2 = true;
                    iCopyFileArea = CopyFileAreaManager.instance.createCopyFileArea(iPath, (IProgressMonitor)subMonitor.newChild(1));
                    iPath3 = ((CopyFileAreaStore)((Object)iCopyFileArea)).getRoot();
                } else {
                    IPath iPath4 = ((CopyFileAreaStore)((Object)iCopyFileArea)).getRoot();
                    if (!iPath4.equals((Object)iPath3)) {
                        iPath3 = iPath4;
                    } else {
                        ISharingDescriptor iSharingDescriptor2 = ((CopyFileAreaStore)((Object)iCopyFileArea)).findSharingDescriptor(iPath2);
                        if (iSharingDescriptor2 == null) {
                            CFALockUtil.endBatching(abstractLock, (IProgressMonitor)subMonitor.newChild(1));
                            subMonitor.done();
                            bl2 = true;
                            return null;
                        }
                        if (iSharingDescriptor2.getComponent().sameItemId((IItemHandle)iSharingDescriptor.getComponent()) && iSharingDescriptor2.getConnectionHandle().sameItemId((IItemHandle)iSharingDescriptor.getConnectionHandle())) {
                            subMonitor.done();
                            bl2 = true;
                            AbstractLock abstractLock2 = abstractLock;
                            return abstractLock2;
                        }
                        iSharingDescriptor = iSharingDescriptor2;
                    }
                    CFALockUtil.endBatching(abstractLock, (IProgressMonitor)subMonitor.newChild(1));
                    bl2 = true;
                }
                subMonitor.setWorkRemaining(79);
            }
        }
        finally {
            if (!bl2) {
                CFALockUtil.endBatching(abstractLock, (IProgressMonitor)subMonitor.newChild(1));
            }
        }
    }

    public static AbstractLock createAndLockForUpdate(IPath iPath, IContextHandle iContextHandle, IComponentHandle iComponentHandle, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        ICopyFileArea iCopyFileArea = CopyFileAreaManager.instance.getExistingCopyFileArea(iPath);
        if (iCopyFileArea == null) {
            iCopyFileArea = CopyFileAreaManager.instance.createCopyFileArea(iPath, (IProgressMonitor)subMonitor.newChild(30));
        }
        IPath iPath2 = ((CopyFileAreaStore)((Object)iCopyFileArea)).getRoot();
        while (true) {
            AbstractLock abstractLock = CFALockUtil.beginBatching(new ComponentLock(iPath2, iContextHandle, iComponentHandle), true, (IProgressMonitor)subMonitor.newChild(20));
            boolean bl = false;
            try {
                iCopyFileArea = CopyFileAreaManager.instance.getExistingCopyFileArea(iPath2);
                if (iCopyFileArea != null) {
                    IPath iPath3 = ((CopyFileAreaStore)((Object)iCopyFileArea)).getRoot();
                    if (iPath3.equals((Object)iPath2)) {
                        subMonitor.done();
                        bl = true;
                        AbstractLock abstractLock2 = abstractLock;
                        return abstractLock2;
                    }
                    iPath2 = iPath3;
                } else {
                    CFALockUtil.endBatching(abstractLock, (IProgressMonitor)subMonitor.newChild(1));
                    bl = true;
                    iCopyFileArea = CopyFileAreaManager.instance.createCopyFileArea(iPath, (IProgressMonitor)subMonitor.newChild(1));
                    iPath2 = ((CopyFileAreaStore)((Object)iCopyFileArea)).getRoot();
                }
            }
            finally {
                if (!bl) {
                    CFALockUtil.endBatching(abstractLock, (IProgressMonitor)subMonitor.newChild(1));
                }
            }
            subMonitor.setWorkRemaining(70);
        }
    }

    public static CFALockUtil$LockResult createAndLockForUpdateOfChildren(IPath iPath, IPath iPath2, boolean bl, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        AbstractLock abstractLock = CFALockUtil.createAndLockForReading(iPath, bl, (IProgressMonitor)subMonitor.newChild(20));
        if (abstractLock == null) {
            return new CFALockUtil$LockResult(bl, subMonitor);
        }
        boolean bl2 = false;
        try {
            IPath[] iPathArray;
            IPath iPath3;
            ICopyFileArea iCopyFileArea = CopyFileAreaManager.instance.getExistingCopyFileArea(iPath);
            IPath iPath4 = ((CopyFileAreaStore)((Object)iCopyFileArea)).getRoot();
            ISharingDescriptor iSharingDescriptor = null;
            IPath[] iPathArray2 = ((CopyFileAreaStore)((Object)iCopyFileArea)).allSharePaths();
            ISharingMetadata iSharingMetadata = ((CopyFileAreaStore)((Object)iCopyFileArea)).internalGetMetadata();
            IPath iPath5 = iSharingMetadata.getCanonicalPath(iPath2, true);
            IShare iShare = null;
            boolean bl3 = false;
            IPath[] iPathArray3 = iPathArray2;
            int n = iPathArray2.length;
            int n2 = 0;
            while (n2 < n) {
                iPath3 = iPathArray3[n2];
                iPathArray = iSharingMetadata.getCanonicalPath(iPath3, true);
                if (iPathArray.isPrefixOf(iPath5)) {
                    iShare = ((CopyFileArea)iCopyFileArea).getShare(iPath3);
                    if (iShare != null) break;
                    LoggingHelper.log(new FileSystemStatus(NLS.bind((String)"Expected share could not be found at ''{0}''", (Object)iPath3.toOSString())));
                }
                if (iPath5.isPrefixOf((IPath)iPathArray)) {
                    bl3 = true;
                    break;
                }
                ++n2;
            }
            if (iShare != null) {
                iSharingDescriptor = iShare.getSharingDescriptor();
            } else if (!bl3) {
                CFALockUtil.endBatching(abstractLock, (IProgressMonitor)subMonitor.newChild(1));
                bl2 = true;
                subMonitor.done();
                CFALockUtil$LockResult cFALockUtil$LockResult = new CFALockUtil$LockResult(1);
                return cFALockUtil$LockResult;
            }
            CFALockUtil.endBatching(abstractLock, (IProgressMonitor)subMonitor.newChild(1));
            bl2 = true;
            while (true) {
                abstractLock = iSharingDescriptor == null ? new GlobalCFALock(iPath4) : new ComponentLock(iPath4, iSharingDescriptor.getConnectionHandle(), iSharingDescriptor.getComponent());
                if ((abstractLock = CFALockUtil.beginBatching(abstractLock, bl, (IProgressMonitor)subMonitor.newChild(30))) == null) {
                    CFALockUtil$LockResult cFALockUtil$LockResult = new CFALockUtil$LockResult(bl, subMonitor);
                    return cFALockUtil$LockResult;
                }
                bl2 = false;
                iCopyFileArea = CopyFileAreaManager.instance.getExistingCopyFileArea(iPath);
                if (iCopyFileArea == null) {
                    CFALockUtil.endBatching(abstractLock, (IProgressMonitor)subMonitor.newChild(1));
                    bl2 = true;
                    iCopyFileArea = CopyFileAreaManager.instance.createCopyFileArea(iPath, (IProgressMonitor)subMonitor.newChild(1));
                    iPath4 = ((CopyFileAreaStore)((Object)iCopyFileArea)).getRoot();
                } else {
                    iPath3 = ((CopyFileAreaStore)((Object)iCopyFileArea)).getRoot();
                    if (!iPath3.equals((Object)iPath4)) {
                        iPath4 = iPath3;
                    } else {
                        ISharingDescriptor iSharingDescriptor2;
                        iPathArray2 = ((CopyFileAreaStore)((Object)iCopyFileArea)).allSharePaths();
                        iSharingMetadata = ((CopyFileAreaStore)((Object)iCopyFileArea)).internalGetMetadata();
                        iPath5 = iSharingMetadata.getCanonicalPath(iPath2, true);
                        iShare = null;
                        bl3 = false;
                        iPathArray = iPathArray2;
                        int n3 = iPathArray2.length;
                        n = 0;
                        while (n < n3) {
                            IPath iPath6 = iPathArray[n];
                            IPath iPath7 = iSharingMetadata.getCanonicalPath(iPath6, true);
                            if (iPath7.isPrefixOf(iPath5)) {
                                iShare = ((CopyFileArea)iCopyFileArea).getShare(iPath6);
                                if (iShare != null) break;
                                LoggingHelper.log(new FileSystemStatus(NLS.bind((String)"Expected share could not be found at ''{0}''", (Object)iPath6.toOSString())));
                            }
                            if (iPath5.isPrefixOf(iPath7)) {
                                bl3 = true;
                                break;
                            }
                            ++n;
                        }
                        if (iShare != null) {
                            iSharingDescriptor2 = iShare.getSharingDescriptor();
                        } else {
                            if (!bl3) {
                                CFALockUtil.endBatching(abstractLock, (IProgressMonitor)subMonitor.newChild(1));
                                bl2 = true;
                                subMonitor.done();
                                CFALockUtil$LockResult cFALockUtil$LockResult = new CFALockUtil$LockResult(1);
                                return cFALockUtil$LockResult;
                            }
                            iSharingDescriptor2 = null;
                        }
                        if (iSharingDescriptor == null) {
                            if (iSharingDescriptor2 == null) {
                                subMonitor.done();
                                bl2 = true;
                                CFALockUtil$LockResult cFALockUtil$LockResult = new CFALockUtil$LockResult(abstractLock);
                                return cFALockUtil$LockResult;
                            }
                        } else if (iSharingDescriptor2 != null && iSharingDescriptor2.getComponent().sameItemId((IItemHandle)iSharingDescriptor.getComponent()) && iSharingDescriptor2.getConnectionHandle().sameItemId((IItemHandle)iSharingDescriptor.getConnectionHandle())) {
                            subMonitor.done();
                            bl2 = true;
                            CFALockUtil$LockResult cFALockUtil$LockResult = new CFALockUtil$LockResult(abstractLock);
                            return cFALockUtil$LockResult;
                        }
                        iSharingDescriptor = iSharingDescriptor2;
                    }
                    CFALockUtil.endBatching(abstractLock, (IProgressMonitor)subMonitor.newChild(1));
                    bl2 = true;
                }
                subMonitor.setWorkRemaining(79);
            }
        }
        finally {
            if (!bl2) {
                CFALockUtil.endBatching(abstractLock, (IProgressMonitor)subMonitor.newChild(1));
            }
        }
    }

    public static AbstractLock createAndLockForReading(List list, boolean bl, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        ICopyFileArea iCopyFileArea;
        int n = list.size();
        Assert.isTrue((n != 0 ? 1 : 0) != 0);
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        IPath[] iPathArray = new IPath[n];
        SubMonitor subMonitor2 = subMonitor.newChild(30);
        subMonitor2.setWorkRemaining(n);
        int n2 = 0;
        AbstractLock[] abstractLockArray = new AbstractLock[n];
        for (Object object : list) {
            IPath iPath;
            iCopyFileArea = CopyFileAreaManager.instance.getExistingCopyFileArea((IPath)object);
            if (iCopyFileArea == null) {
                iCopyFileArea = CopyFileAreaManager.instance.createCopyFileArea((IPath)object, (IProgressMonitor)subMonitor2.newChild(1));
            }
            iPathArray[n2] = iPath = ((CopyFileAreaStore)((Object)iCopyFileArea)).getRoot();
            abstractLockArray[n2] = new CFAReadLock(iPath);
            ++n2;
        }
        Object object;
        while ((object = CFALockUtil.beginBatching(MultiLock.combine(abstractLockArray), bl, (IProgressMonitor)subMonitor.newChild(20))) != null) {
            boolean bl2 = false;
            try {
                n2 = 0;
                iCopyFileArea = subMonitor.newChild(1);
                iCopyFileArea.setWorkRemaining(n + 1);
                for (IPath iPath : list) {
                    IPath iPath2;
                    ICopyFileArea iCopyFileArea2 = CopyFileAreaManager.instance.getExistingCopyFileArea(iPath);
                    if (iCopyFileArea2 != null) {
                        iPath2 = ((CopyFileAreaStore)((Object)iCopyFileArea2)).getRoot();
                        if (!iPath2.equals((Object)iPathArray[n2])) {
                            if (!bl2) {
                                CFALockUtil.endBatching((AbstractLock)object, (IProgressMonitor)iCopyFileArea.newChild(1));
                                bl2 = true;
                            }
                            iPathArray[n2] = iPath2;
                            abstractLockArray[n2] = new CFAReadLock(iPath2);
                        }
                    } else {
                        if (!bl2) {
                            CFALockUtil.endBatching((AbstractLock)object, (IProgressMonitor)iCopyFileArea.newChild(1));
                            bl2 = true;
                        }
                        iCopyFileArea2 = CopyFileAreaManager.instance.createCopyFileArea(iPath, (IProgressMonitor)iCopyFileArea.newChild(1));
                        iPathArray[n2] = iPath2 = ((CopyFileAreaStore)((Object)iCopyFileArea2)).getRoot();
                        abstractLockArray[n2] = new CFAReadLock(iPath2);
                    }
                    ++n2;
                }
                iCopyFileArea.done();
                if (!bl2) {
                    subMonitor.done();
                    bl2 = true;
                    Object object2 = object;
                    return object2;
                }
            }
            finally {
                if (!bl2) {
                    CFALockUtil.endBatching((AbstractLock)object, (IProgressMonitor)subMonitor.newChild(1));
                }
            }
            subMonitor.setWorkRemaining(70);
        }
        return null;
    }

    public static CFALockUtil$LockResult createAndLockForUpdateOfChildren(List list, List list2, boolean bl, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        int n = list.size();
        Assert.isTrue((n == list2.size() ? 1 : 0) != 0);
        Assert.isTrue((n != 0 ? 1 : 0) != 0);
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        AbstractLock abstractLock = CFALockUtil.createAndLockForReading(list, bl, (IProgressMonitor)subMonitor.newChild(20));
        if (abstractLock == null) {
            return new CFALockUtil$LockResult(bl, subMonitor);
        }
        boolean bl2 = false;
        try {
            IPath iPath;
            IPath iPath2;
            Object object;
            Object object2;
            Object object3;
            ISharingMetadata iSharingMetadata;
            Object object4;
            IPath iPath3;
            ICopyFileArea iCopyFileArea;
            ISharingDescriptor[] iSharingDescriptorArray = new ISharingDescriptor[n];
            AbstractLock[] abstractLockArray = new AbstractLock[n];
            IPath[] iPathArray = new IPath[n];
            Iterator iterator = list.iterator();
            Iterator iterator2 = list2.iterator();
            int n2 = 0;
            while (n2 != n) {
                IPath iPath4 = (IPath)iterator.next();
                IPath iPath5 = (IPath)iterator2.next();
                iCopyFileArea = CopyFileAreaManager.instance.getExistingCopyFileArea(iPath4);
                iPath3 = ((CopyFileAreaStore)((Object)iCopyFileArea)).getRoot();
                object4 = ((CopyFileAreaStore)((Object)iCopyFileArea)).allSharePaths();
                iSharingMetadata = ((CopyFileAreaStore)((Object)iCopyFileArea)).internalGetMetadata();
                object3 = iSharingMetadata.getCanonicalPath(iPath5, true);
                object2 = null;
                object = object4;
                int n3 = ((IPath[])object4).length;
                int n4 = 0;
                while (n4 < n3) {
                    iPath2 = object[n4];
                    iPath = iSharingMetadata.getCanonicalPath(iPath2, true);
                    if (iPath.isPrefixOf((IPath)object3)) {
                        object2 = ((CopyFileArea)iCopyFileArea).getShare(iPath2);
                        if (object2 != null) break;
                        LoggingHelper.log(new FileSystemStatus(NLS.bind((String)"Expected share could not be found at ''{0}''", (Object)iPath2.toOSString())));
                    }
                    if (object3.isPrefixOf(iPath)) break;
                    ++n4;
                }
                iPathArray[n2] = iPath3;
                if (object2 != null) {
                    iSharingDescriptorArray[n2] = object2.getSharingDescriptor();
                    abstractLockArray[n2] = new ComponentLock(iPath3, iSharingDescriptorArray[n2].getConnectionHandle(), iSharingDescriptorArray[n2].getComponent());
                } else {
                    iSharingDescriptorArray[n2] = null;
                    abstractLockArray[n2] = new GlobalCFALock(iPath3);
                }
                ++n2;
            }
            CFALockUtil.endBatching(abstractLock, (IProgressMonitor)subMonitor.newChild(1));
            bl2 = true;
            while (true) {
                if ((abstractLock = CFALockUtil.beginBatching(MultiLock.combine(abstractLockArray), bl, (IProgressMonitor)subMonitor.newChild(30))) == null) {
                    CFALockUtil$LockResult cFALockUtil$LockResult = new CFALockUtil$LockResult(bl, subMonitor);
                    return cFALockUtil$LockResult;
                }
                bl2 = false;
                iterator = list.iterator();
                iterator2 = list2.iterator();
                n2 = 0;
                boolean bl3 = true;
                int n5 = 0;
                while (n5 != n) {
                    iCopyFileArea = (IPath)iterator.next();
                    iPath3 = (IPath)iterator2.next();
                    object4 = CopyFileAreaManager.instance.getExistingCopyFileArea((IPath)iCopyFileArea);
                    if (object4 == null) {
                        if (!bl2) {
                            CFALockUtil.endBatching(abstractLock, (IProgressMonitor)subMonitor.newChild(1));
                            bl2 = true;
                        }
                        object4 = CopyFileAreaManager.instance.createCopyFileArea((IPath)iCopyFileArea, (IProgressMonitor)subMonitor.newChild(1));
                        iSharingMetadata = ((CopyFileAreaStore)object4).getRoot();
                        iSharingDescriptorArray[n5] = null;
                        abstractLockArray[n5] = new GlobalCFALock((IPath)iSharingMetadata);
                        iPathArray[n5] = iSharingMetadata;
                        n2 = 1;
                    } else {
                        iSharingMetadata = ((CopyFileAreaStore)object4).getRoot();
                        if (!iSharingMetadata.equals(iPathArray[n5])) {
                            iPathArray[n5] = iSharingMetadata;
                            n2 = 1;
                        } else if (!bl2) {
                            Object object5;
                            object3 = ((CopyFileArea)object4).allShares();
                            object2 = ((CopyFileAreaStore)object4).internalGetMetadata();
                            iPath2 = object2.getCanonicalPath(iPath3, true);
                            Object object6 = null;
                            object = object3.iterator();
                            while (object.hasNext()) {
                                object5 = (IShare)object.next();
                                iPath = object2.getCanonicalPath(object5.getPath(), true);
                                if (iPath.isPrefixOf(iPath2)) {
                                    object6 = object5;
                                    break;
                                }
                                if (!iPath2.isPrefixOf(iPath)) continue;
                                bl3 = false;
                                break;
                            }
                            if (object6 != null) {
                                object5 = object6.getSharingDescriptor();
                                bl3 = false;
                                object = iSharingDescriptorArray[n5];
                                if (object == null || !object5.getComponent().sameItemId((IItemHandle)object.getComponent()) || !object5.getConnectionHandle().sameItemId((IItemHandle)object.getConnectionHandle())) {
                                    iSharingDescriptorArray[n5] = object5;
                                    abstractLockArray[n5] = new ComponentLock((IPath)iSharingMetadata, object5.getConnectionHandle(), object5.getComponent());
                                    n2 = 1;
                                }
                            } else if (iSharingDescriptorArray[n5] != null) {
                                iSharingDescriptorArray[n5] = null;
                                abstractLockArray[n5] = new GlobalCFALock((IPath)iSharingMetadata);
                                n2 = 1;
                            }
                        }
                    }
                    ++n5;
                }
                if (n2 == 0) {
                    if (bl3) {
                        CFALockUtil.endBatching(abstractLock, (IProgressMonitor)subMonitor.newChild(1));
                        bl2 = true;
                        subMonitor.done();
                        CFALockUtil$LockResult cFALockUtil$LockResult = new CFALockUtil$LockResult(1);
                        return cFALockUtil$LockResult;
                    }
                    subMonitor.done();
                    bl2 = true;
                    CFALockUtil$LockResult cFALockUtil$LockResult = new CFALockUtil$LockResult(abstractLock);
                    return cFALockUtil$LockResult;
                }
                CFALockUtil.endBatching(abstractLock, (IProgressMonitor)subMonitor.newChild(1));
                bl2 = true;
                subMonitor.setWorkRemaining(79);
            }
        }
        finally {
            if (!bl2) {
                CFALockUtil.endBatching(abstractLock, (IProgressMonitor)subMonitor.newChild(1));
            }
        }
    }

    public static void endBatching(CFALockUtil$LockResult cFALockUtil$LockResult, SubMonitor subMonitor) throws FileSystemClientException {
        if (cFALockUtil$LockResult.code == 0) {
            CFALockUtil.endBatching(cFALockUtil$LockResult.lock, (IProgressMonitor)subMonitor);
        }
    }
}

