/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.copyfileareas;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.ICopyFileAreaEvent;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.copyfileareas.AbstractLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.BatchingLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.IFlushOperation;
import com.ibm.team.filesystem.client.internal.copyfileareas.MultiLock;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;

public class BatchingLock$ThreadInfo {
    private final ArrayList changes = new ArrayList();
    private final IFlushOperation operation;
    private Job job;
    private final ArrayList rules = new ArrayList();
    private final ArrayList baseRule = new ArrayList();
    final /* synthetic */ BatchingLock this$0;

    public BatchingLock$ThreadInfo(BatchingLock batchingLock, IFlushOperation iFlushOperation) {
        this.this$0 = batchingLock;
        this.operation = iFlushOperation;
    }

    public AbstractLock pushRule(AbstractLock abstractLock) {
        this.checkRule(abstractLock);
        this.addRule(abstractLock);
        return abstractLock;
    }

    public void popRule(AbstractLock abstractLock, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        try {
            if (this.isFlushRequired(abstractLock)) {
                this.flush(iProgressMonitor);
            }
        }
        finally {
            this.removeRule(abstractLock);
        }
    }

    public boolean isNested() {
        return !this.rules.isEmpty();
    }

    public void addChange(ICopyFileAreaEvent iCopyFileAreaEvent) {
        this.changes.add(iCopyFileAreaEvent);
    }

    public boolean isEmpty() {
        return this.changes.isEmpty();
    }

    public ICopyFileAreaEvent[] getEvents() {
        return this.changes.toArray(new ICopyFileAreaEvent[this.changes.size()]);
    }

    public void flush(IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        try {
            try {
                if (this.operation != null) {
                    this.operation.flush(this, iProgressMonitor);
                }
            }
            catch (OutOfMemoryError outOfMemoryError) {
                throw (Throwable)outOfMemoryError;
            }
            catch (Error error) {
                this.handleAbortedFlush(error);
                throw (Throwable)error;
            }
            catch (RuntimeException runtimeException) {
                this.handleAbortedFlush(runtimeException);
                throw (Throwable)runtimeException;
            }
        }
        finally {
            this.changes.clear();
        }
    }

    private boolean isFlushRequired(AbstractLock abstractLock) {
        for (AbstractLock abstractLock2 : this.rules) {
            if (abstractLock2 == abstractLock) {
                abstractLock = BatchingLock.NULL_SCHEDULING_RULE;
                continue;
            }
            if (abstractLock2 == BatchingLock.NULL_SCHEDULING_RULE) continue;
            return false;
        }
        return true;
    }

    private void handleAbortedFlush(Throwable throwable) {
        LoggingHelper.error("com.ibm.team.filesystem.client", "Flush aborted", throwable);
    }

    public void checkRule(AbstractLock abstractLock) {
        AbstractLock abstractLock2;
        int n;
        if (abstractLock != BatchingLock.NULL_SCHEDULING_RULE && abstractLock != BatchingLock.AVOID_NOTIFICATION_RULE && (n = this.baseRule.size()) != 0 && !(abstractLock2 = (AbstractLock)this.baseRule.get(n - 1)).mayPromoteTo(abstractLock)) {
            throw (Throwable)new IllegalStateException("The rule " + abstractLock + " is not promotable from the base rule " + abstractLock2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRule(AbstractLock abstractLock) {
        AbstractLock abstractLock2 = null;
        if (abstractLock != BatchingLock.NULL_SCHEDULING_RULE && abstractLock != BatchingLock.AVOID_NOTIFICATION_RULE) {
            int n = this.baseRule.size();
            abstractLock2 = n == 0 ? abstractLock : MultiLock.combine(abstractLock, (AbstractLock)this.baseRule.get(n - 1));
        }
        ArrayList arrayList = this.rules;
        synchronized (arrayList) {
            this.rules.add(abstractLock);
            if (abstractLock2 != null) {
                this.baseRule.add(abstractLock2);
            }
            this.job = Job.getJobManager().currentJob();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeRule(AbstractLock abstractLock) {
        int n;
        Object object;
        int n2 = -1;
        int n3 = 0;
        int n4 = this.rules.size() - 1;
        while (n4 >= 0) {
            object = (AbstractLock)this.rules.get(n4);
            if (object == abstractLock) {
                n2 = n4;
                break;
            }
            if (object != BatchingLock.NULL_SCHEDULING_RULE && object != BatchingLock.AVOID_NOTIFICATION_RULE) {
                ++n3;
            }
            --n4;
        }
        if (n2 == -1) {
            Assert.isTrue((boolean)false, (String)("end for lock '" + abstractLock + "' does not match any stacked rule"));
        }
        ArrayList<Object> arrayList = null;
        if (n3 != 0 && abstractLock != BatchingLock.NULL_SCHEDULING_RULE && abstractLock != BatchingLock.AVOID_NOTIFICATION_RULE) {
            arrayList = new ArrayList<Object>(n3);
            object = (AbstractLock)this.baseRule.get(this.baseRule.size() - n3 - 1);
            n = this.rules.size();
            int n5 = n2 + 1;
            while (n5 < n) {
                AbstractLock abstractLock2 = (AbstractLock)this.rules.get(n5);
                if (abstractLock2 != BatchingLock.NULL_SCHEDULING_RULE && abstractLock2 != BatchingLock.AVOID_NOTIFICATION_RULE) {
                    object = MultiLock.combine(new AbstractLock[]{object, abstractLock2});
                    arrayList.add(object);
                }
                ++n5;
            }
        }
        object = this.rules;
        synchronized (object) {
            this.job = Job.getJobManager().currentJob();
            n = this.baseRule.size();
            if (abstractLock != BatchingLock.NULL_SCHEDULING_RULE && abstractLock != BatchingLock.AVOID_NOTIFICATION_RULE) {
                this.rules.notifyAll();
                this.baseRule.subList(n - 1 - n3, n).clear();
                if (arrayList != null) {
                    this.baseRule.addAll((Collection)arrayList);
                }
            }
            this.rules.remove(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean ruleConflicts(AbstractLock abstractLock) {
        ArrayList arrayList = this.rules;
        synchronized (arrayList) {
            int n = this.baseRule.size();
            if (n != 0) {
                return ((AbstractLock)this.baseRule.get(n - 1)).isConflicting(abstractLock);
            }
            return false;
        }
    }

    public boolean ruleContained(AbstractLock abstractLock) {
        int n = this.baseRule.size();
        if (n == 0) {
            return false;
        }
        return ((AbstractLock)this.baseRule.get(n - 1)).contains(abstractLock);
    }

    static /* synthetic */ ArrayList access$0(BatchingLock$ThreadInfo batchingLock$ThreadInfo) {
        return batchingLock$ThreadInfo.rules;
    }

    static /* synthetic */ Job access$1(BatchingLock$ThreadInfo batchingLock$ThreadInfo) {
        return batchingLock$ThreadInfo.job;
    }
}

