/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.content;

import com.ibm.team.filesystem.client.IFileContentManager;
import com.ibm.team.filesystem.client.IFileContentManagerSession;
import com.ibm.team.filesystem.client.internal.content.AsyncFileContentManagerSession;
import com.ibm.team.filesystem.client.internal.content.FileContentManager$LineDelimiterVerifyingStream;
import com.ibm.team.filesystem.client.internal.content.SyncFileContentManagerSession;
import com.ibm.team.filesystem.common.FileLineDelimiter;
import com.ibm.team.filesystem.common.IFileContent;
import com.ibm.team.filesystem.common.IFileContentService;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.common.internal.FileContent;
import com.ibm.team.filesystem.common.internal.FilesystemFactory;
import com.ibm.team.filesystem.common.internal.util.FileContentProperties;
import com.ibm.team.filesystem.common.util.LineDelimiterUtil;
import com.ibm.team.filesystem.common.util.VerifyConvertToCRInputStream;
import com.ibm.team.filesystem.common.util.VerifyConvertToCRLFInputStream;
import com.ibm.team.filesystem.common.util.VerifyConvertToLFInputStream;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.utils.ReaderToInputStream;
import com.ibm.team.scm.client.content.AbstractVersionedContentManagerInputStreamProvider;
import com.ibm.team.scm.client.content.BasicVersionedContentManager;
import com.ibm.team.scm.common.ContentHash;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IVersionedContent;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Locale;
import org.apache.commons.httpclient.HttpMethod;
import org.eclipse.core.runtime.IProgressMonitor;

public final class FileContentManager
extends BasicVersionedContentManager
implements IFileContentManager {
    private static final FileLineDelimiter SERVER_PLATFORM_LINE_DELIMITER = FileLineDelimiter.LINE_DELIMITER_LF;
    private static final Method storeMethod;
    private final Object serviceDelegate = Proxy.newProxyInstance(this.getClassLoaderForProxy(IFileContentService.class), new Class[]{IFileContentService.class}, fakeInvocationHandler);

    static {
        try {
            storeMethod = IFileContentService.class.getDeclaredMethod("storeContent", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw (Throwable)new RuntimeException(noSuchMethodException);
        }
    }

    public FileContentManager(IClientLibraryContext iClientLibraryContext) {
        super(iClientLibraryContext);
    }

    protected Method getStoreMethodForStatistics(long l, ContentHash contentHash, ContentHash contentHash2, FileContentProperties fileContentProperties) {
        return storeMethod;
    }

    protected Object getStoreDelegateForStatistics(long l, ContentHash contentHash, ContentHash contentHash2, FileContentProperties fileContentProperties) {
        return this.serviceDelegate;
    }

    public void retrieveContent(IFileItemHandle iFileItemHandle, IFileContent iFileContent, OutputStream outputStream, IProgressMonitor iProgressMonitor) throws TeamRepositoryException {
        super.retrieveContent((IVersionableHandle)iFileItemHandle, (IVersionedContent)iFileContent, outputStream, null, iProgressMonitor);
    }

    protected InputStream internalRetrieveContentStream(IVersionableHandle iVersionableHandle, IVersionedContent iVersionedContent, FileContentProperties fileContentProperties, IProgressMonitor iProgressMonitor) throws TeamRepositoryException {
        InputStream inputStream;
        block17: {
            InputStream inputStream2 = super.internalRetrieveContentStream(iVersionableHandle, iVersionedContent, (Object)fileContentProperties, iProgressMonitor);
            boolean bl = false;
            try {
                InputStream inputStream3;
                if (fileContentProperties != null) {
                    FileLineDelimiter fileLineDelimiter = fileContentProperties.lineDelimiter;
                    if (fileLineDelimiter == FileLineDelimiter.LINE_DELIMITER_PLATFORM) {
                        fileLineDelimiter = FileLineDelimiter.getPlatformDelimiter();
                    }
                    if (fileLineDelimiter == FileLineDelimiter.LINE_DELIMITER_NONE) {
                        inputStream3 = inputStream2;
                    } else {
                        try {
                            inputStream3 = new ReaderToInputStream((InputStreamReader)LineDelimiterUtil.getNonVerifyingLineDelimiterConverter((InputStream)inputStream2, (String)fileContentProperties.encoding, (FileLineDelimiter)fileLineDelimiter));
                        }
                        catch (IOException iOException) {
                            throw (Throwable)new TeamRepositoryException((Object)this.teamRepository(), iOException.getMessage(), (Throwable)iOException);
                        }
                    }
                } else {
                    IFileContent iFileContent = (IFileContent)iVersionedContent;
                    try {
                        inputStream3 = this.getConversionStream(inputStream2, iFileContent.getCharacterEncoding(), iFileContent.getLineDelimiter());
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        throw (Throwable)new TeamRepositoryException((Object)this.teamRepository(), unsupportedEncodingException.getMessage(), (Throwable)unsupportedEncodingException);
                    }
                    catch (UnsupportedCharsetException unsupportedCharsetException) {
                        throw (Throwable)new TeamRepositoryException((Object)this.teamRepository(), unsupportedCharsetException.getMessage(), (Throwable)unsupportedCharsetException);
                    }
                }
                bl = true;
                inputStream = inputStream3;
                if (bl) break block17;
            }
            catch (Throwable throwable) {
                if (!bl) {
                    try {
                        inputStream2.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            try {
                inputStream2.close();
            }
            catch (IOException iOException) {}
        }
        return inputStream;
    }

    private InputStream getConversionStream(InputStream inputStream, String string, FileLineDelimiter fileLineDelimiter) throws UnsupportedEncodingException {
        if (fileLineDelimiter == FileLineDelimiter.LINE_DELIMITER_PLATFORM && SERVER_PLATFORM_LINE_DELIMITER != FileLineDelimiter.getPlatformDelimiter()) {
            switch (FileLineDelimiter.getPlatformDelimiter()) {
                case LINE_DELIMITER_CRLF: {
                    return (InputStream)new ReaderToInputStream((InputStreamReader)new VerifyConvertToCRLFInputStream(inputStream, string));
                }
                case LINE_DELIMITER_CR: {
                    return (InputStream)new ReaderToInputStream((InputStreamReader)new VerifyConvertToCRInputStream(inputStream, string));
                }
                case LINE_DELIMITER_LF: {
                    return (InputStream)new ReaderToInputStream((InputStreamReader)new VerifyConvertToLFInputStream(inputStream, string));
                }
            }
            return inputStream;
        }
        return inputStream;
    }

    public InputStream retrieveContentStream(IFileItemHandle iFileItemHandle, IFileContent iFileContent, IProgressMonitor iProgressMonitor) throws TeamRepositoryException {
        return super.retrieveContentStream((IVersionableHandle)iFileItemHandle, (IVersionedContent)iFileContent, null, iProgressMonitor);
    }

    public InputStream retrieveContentStream(IFileItemHandle iFileItemHandle, IFileContent iFileContent, String string, FileLineDelimiter fileLineDelimiter, IProgressMonitor iProgressMonitor) throws TeamRepositoryException {
        FileContentProperties fileContentProperties = new FileContentProperties(string, fileLineDelimiter);
        return super.retrieveContentStream((IVersionableHandle)iFileItemHandle, (IVersionedContent)iFileContent, (Object)fileContentProperties, iProgressMonitor);
    }

    public static boolean validLineDelimiter(FileLineDelimiter fileLineDelimiter) {
        return fileLineDelimiter == FileLineDelimiter.LINE_DELIMITER_NONE || fileLineDelimiter == FileLineDelimiter.LINE_DELIMITER_LF || fileLineDelimiter == FileLineDelimiter.LINE_DELIMITER_CRLF || fileLineDelimiter == FileLineDelimiter.LINE_DELIMITER_CR || fileLineDelimiter == FileLineDelimiter.LINE_DELIMITER_PLATFORM;
    }

    private static boolean isTextType(String string) {
        return string != null && string.trim().toLowerCase(Locale.ENGLISH).startsWith("text/");
    }

    protected InputStream wrapInputStreamForUpload(InputStream inputStream, FileContentProperties fileContentProperties) throws TeamRepositoryException, IOException {
        inputStream = super.wrapInputStreamForUpload(inputStream, (Object)fileContentProperties);
        if (fileContentProperties.lineDelimiter != FileLineDelimiter.LINE_DELIMITER_NONE) {
            inputStream = new FileContentManager$LineDelimiterVerifyingStream(fileContentProperties, inputStream);
        }
        return inputStream;
    }

    private static FileLineDelimiter getTransmissionLineDelimiter(FileLineDelimiter fileLineDelimiter) {
        if (fileLineDelimiter == FileLineDelimiter.LINE_DELIMITER_PLATFORM) {
            return SERVER_PLATFORM_LINE_DELIMITER;
        }
        return fileLineDelimiter;
    }

    protected IVersionedContent createVersionedContent(ContentHash contentHash, ContentHash contentHash2, long l, FileContentProperties fileContentProperties) {
        FileContent fileContent = FilesystemFactory.eINSTANCE.createFileContent();
        fileContent.setHash(contentHash);
        fileContent.setPredecessorHint(contentHash2);
        fileContent.setSize(l);
        fileContent.setCharacterEncoding(fileContentProperties.encoding);
        fileContent.setLineDelimiterCount(fileContentProperties.getLineDelimiterCount());
        fileContent.setLineDelimiterSetting(fileContentProperties.lineDelimiter.dbValue());
        return (IVersionedContent)fileContent;
    }

    public IFileContent storeContent(String string, FileLineDelimiter fileLineDelimiter, AbstractVersionedContentManagerInputStreamProvider abstractVersionedContentManagerInputStreamProvider, ContentHash contentHash, IProgressMonitor iProgressMonitor) throws TeamRepositoryException {
        if (abstractVersionedContentManagerInputStreamProvider == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        boolean bl = false;
        FileContentProperties fileContentProperties = null;
        try {
            fileContentProperties = new FileContentProperties(string, fileLineDelimiter);
            bl = true;
        }
        catch (Throwable throwable) {
            if (!bl) {
                try {
                    abstractVersionedContentManagerInputStreamProvider.dispose();
                }
                catch (IOException iOException) {
                }
                catch (TeamRepositoryException teamRepositoryException) {}
            }
            throw throwable;
        }
        if (!bl) {
            try {
                abstractVersionedContentManagerInputStreamProvider.dispose();
            }
            catch (IOException iOException) {
            }
            catch (TeamRepositoryException teamRepositoryException) {}
        }
        return (IFileContent)super.storeContent(abstractVersionedContentManagerInputStreamProvider, contentHash, (Object)fileContentProperties, iProgressMonitor);
    }

    protected URI getStoreURI(AbstractVersionedContentManagerInputStreamProvider abstractVersionedContentManagerInputStreamProvider, long l, ContentHash contentHash, ContentHash contentHash2, FileContentProperties fileContentProperties) throws TeamRepositoryException {
        try {
            fileContentProperties.validateForStore();
            URI uRI = new URI(this.server.getRepositoryURL());
            String string = "hashcode=" + contentHash2.toString();
            if (contentHash != null) {
                string = String.valueOf(string) + "&predecessorHintHash=" + contentHash.toString();
            }
            if (l > Integer.MAX_VALUE) {
                string = String.valueOf(string) + "&length=" + Long.toString(l);
            }
            string = String.valueOf(string) + "&lineDelimiter=" + FileContentManager.getTransmissionLineDelimiter(fileContentProperties.lineDelimiter).asQuery();
            if (fileContentProperties.encoding != null && fileContentProperties.encoding.trim().length() > 0) {
                string = String.valueOf(string) + "&encoding=" + fileContentProperties.encoding;
            }
            if (fileContentProperties.lineDelimiter != FileLineDelimiter.LINE_DELIMITER_NONE) {
                string = String.valueOf(string) + "&lineDelimiterCount=" + fileContentProperties.getLineDelimiterCount();
            }
            String string2 = String.valueOf(uRI.getPath()) + "service" + "/" + IFileContentService.class.getName() + "/" + "content";
            String string3 = uRI.getQuery();
            if (string3 != null && string3.trim().length() != 0) {
                string = String.valueOf(string3.trim()) + '&' + string;
            }
            uRI = new URI(null, null, string2, string, uRI.getFragment());
            return uRI;
        }
        catch (URISyntaxException uRISyntaxException) {
            throw (Throwable)new TeamRepositoryException((Object)this.teamRepository(), uRISyntaxException.getMessage(), (Throwable)uRISyntaxException);
        }
    }

    protected void addServiceVersionHeaderForStore(HttpMethod httpMethod, FileContentProperties fileContentProperties) {
        super.addServiceVersionHeader(httpMethod, IFileContentService.class.getName());
    }

    public ITeamRepository teamRepository() {
        return super.teamRepository();
    }

    public IFileContentManagerSession createSession(int n, boolean bl, String string, long l, IProgressMonitor iProgressMonitor) {
        return (IFileContentManagerSession)super.createSession(n, bl, string, l, iProgressMonitor);
    }

    public IFileContentManagerSession createSession(String string, boolean bl, long l, IProgressMonitor iProgressMonitor) {
        return (IFileContentManagerSession)super.createSession(string, bl, l, iProgressMonitor);
    }

    protected IFileContentManagerSession createAsyncSession(int n, boolean bl, String string, long l, IProgressMonitor iProgressMonitor) {
        return new AsyncFileContentManagerSession(n, bl, string, l, this, iProgressMonitor);
    }

    protected IFileContentManagerSession createSyncSession(boolean bl, String string, long l, IProgressMonitor iProgressMonitor) {
        return new SyncFileContentManagerSession(string, l, this, iProgressMonitor);
    }

    public boolean convertDelimitersDuringRetrieval(IFileContent iFileContent) {
        return iFileContent.getLineDelimiter() == FileLineDelimiter.LINE_DELIMITER_PLATFORM && SERVER_PLATFORM_LINE_DELIMITER != FileLineDelimiter.getPlatformDelimiter();
    }

    public static void validateArgumentsForUpload(String string, FileContentProperties fileContentProperties) {
        if (FileContentManager.isTextType(string) && (fileContentProperties.encoding == null || fileContentProperties.encoding.trim().equals(""))) {
            throw (Throwable)new IllegalArgumentException("Character encoding must be supplied if media type is text");
        }
    }

    public long getUnclaimedContentCleanupPeriod(IProgressMonitor iProgressMonitor) throws TeamRepositoryException {
        return super.getCleanupPeriod(iProgressMonitor);
    }

    static /* synthetic */ FileLineDelimiter access$11(FileLineDelimiter fileLineDelimiter) {
        return FileContentManager.getTransmissionLineDelimiter(fileLineDelimiter);
    }
}

