/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.content;

import com.ibm.team.filesystem.client.internal.content.FileContentManager;
import com.ibm.team.filesystem.common.FileLineDelimiter;
import com.ibm.team.filesystem.common.internal.util.FileContentProperties;
import com.ibm.team.filesystem.common.util.LineDelimiterVerifier;
import com.ibm.team.filesystem.common.util.VerifyConvertToCRInputStream;
import com.ibm.team.filesystem.common.util.VerifyConvertToCRLFInputStream;
import com.ibm.team.filesystem.common.util.VerifyConvertToLFInputStream;
import com.ibm.team.repository.common.utils.ReaderToInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class FileContentManager$LineDelimiterVerifyingStream
extends InputStream {
    final LineDelimiterVerifier verifier;
    final InputStream in;
    final FileContentProperties properties;

    public FileContentManager$LineDelimiterVerifyingStream(FileContentProperties fileContentProperties, InputStream inputStream) throws IOException {
        this.properties = fileContentProperties;
        FileLineDelimiter fileLineDelimiter = FileContentManager.access$11(fileContentProperties.lineDelimiter);
        if (fileLineDelimiter == FileLineDelimiter.LINE_DELIMITER_LF) {
            this.verifier = (LineDelimiterVerifier)new VerifyConvertToLFInputStream(inputStream, fileContentProperties.encoding);
        } else if (fileLineDelimiter == FileLineDelimiter.LINE_DELIMITER_CRLF) {
            this.verifier = (LineDelimiterVerifier)new VerifyConvertToCRLFInputStream(inputStream, fileContentProperties.encoding);
        } else if (fileLineDelimiter == FileLineDelimiter.LINE_DELIMITER_CR) {
            this.verifier = (LineDelimiterVerifier)new VerifyConvertToCRInputStream(inputStream, fileContentProperties.encoding);
        } else {
            throw (Throwable)new IllegalArgumentException();
        }
        this.in = (InputStream)new ReaderToInputStream((InputStreamReader)this.verifier);
    }

    public int read() throws IOException {
        int n = this.in.read();
        if (n == -1) {
            this.properties.setLineDelimiterCount(this.verifier.getLineDelimiterCount());
        }
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.in.read(byArray, n, n2);
        if (n3 == -1) {
            this.properties.setLineDelimiterCount(this.verifier.getLineDelimiterCount());
        }
        return n3;
    }

    public long skip(long l) throws IOException {
        return this.in.skip(l);
    }

    public int available() throws IOException {
        return this.in.available();
    }

    public void close() throws IOException {
        this.in.close();
    }

    public void mark(int n) {
        this.in.mark(n);
    }

    public void reset() throws IOException {
        this.in.reset();
    }

    public boolean markSupported() {
        return this.in.markSupported();
    }
}

