/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.client.internal.PersistentHeapManager;
import com.ibm.team.filesystem.client.internal.PersistentHeapManager$AutoClosingPersistentFileHeap;
import com.ibm.team.internal.repository.rcp.dbhm.BadHeapException;
import com.ibm.team.internal.repository.rcp.dbhm.DBHMException;
import com.ibm.team.internal.repository.rcp.dbhm.PersistentBTreeHeap;
import com.ibm.team.internal.repository.rcp.dbhm.PersistentDiskBackedHashMap;
import java.io.File;
import java.io.IOException;

public class Store
extends PersistentDiskBackedHashMap {
    private boolean doInit;
    private PersistentHeapManager mgr;

    public Store(File file, PersistentHeapManager persistentHeapManager) {
        super(file);
        this.mgr = persistentHeapManager;
        this.doInit = true;
        try {
            super.initFromFile(file);
        }
        catch (IOException iOException) {
            throw (Throwable)new DBHMException((Throwable)iOException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw (Throwable)new DBHMException((Throwable)illegalArgumentException);
        }
    }

    protected void initFromFile(File file) throws IOException {
        if (this.doInit) {
            super.initFromFile(file);
        }
    }

    protected PersistentBTreeHeap newPersistentBTreeHeap(File file) throws IOException {
        try {
            return this.mgr.getPersistentFileHeap(file);
        }
        catch (BadHeapException badHeapException) {
            throw (Throwable)new DBHMException((Throwable)badHeapException);
        }
    }

    public void close() throws IOException {
        boolean bl = this.isEmpty();
        super.close();
        if (bl) {
            ((PersistentHeapManager$AutoClosingPersistentFileHeap)this.heap).delete();
        }
    }
}

